# include "SemParallel.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 23 "SemParallel.puma" */


# include "Idents.h"
# include "StringM.h"
# include "Types.h"
# include "protocol.h"
 
# include "Transform.h"    /* CombineACF */
 
# include "Rank.h"
# include "Objects.h"
# include "TreeOps.h"
# include "Nesting.h"      /* Inc/DecNesting       */
 
# include "Loops.h"        /* ForallVarCheck, HasOuterParallelLoop */
 
# include "SemExp.h"         /* SemVariable, SemIndexList */
# include "SemReduction.h"   /* IdentifyReduction         */

# include "labels.h"
# include "Traverse.h"

# define MODULE "SemParallel"

static int   jump_label;
static rbool assigned_gotos;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySemParallel.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* SemParallel_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemParallel, routine %s failed\n",
  yyFunction);
 SemParallel_Exit ();
}

void SemParallel ARGS ((tTree par_construct));
static tTree RemoveDoLabel ARGS ((tTree body));
static void SemanticOnClause ARGS ((tTree on_clause));
static void SemanticResident ARGS ((tTree resident_vars));
static void SemanticNewVars ARGS ((tTree v));
static void CheckNewVarObject ARGS ((tDefinitions obj));
static void SemanticRedVars ARGS ((tTree v));
static void CheckRedVarObject ARGS ((tDefinitions obj));
static void SemanticForallLoop ARGS ((tTree t, tTree loop));
static void SemanticParConstruct ARGS ((tTree t, tTree par_constrcut));
static void MakeParConstructSerial ARGS ((tTree loop, tTree stmt));
static void CheckTaskBody ARGS ((tTree body, int indep_flag));
static rbool IsResident ARGS ((tTree body));
static void CheckJumpOut ARGS ((tTree stmt, tTree body));
rbool HasJumpOut ARGS ((tTree stmts));
static void SetLabelInfo ARGS ((tTree t));
static rbool LegalIndepLoop ARGS ((tTree loop));
rbool LegalIndepBody ARGS ((tTree stmts));

void SemParallel
# if defined __STDC__ | defined __cplusplus
(register tTree par_construct)
# else
(par_construct)
 register tTree par_construct;
# endif
{
/* line 63 "SemParallel.puma" */
  {
/* line 65 "SemParallel.puma" */
   set_protocol_stmt (par_construct);
/* line 66 "SemParallel.puma" */
   goto yyL1;
  }
yyL1:;


  switch (par_construct->Kind) {
  case kACF_FORALL:
/* line 69 "SemParallel.puma" */
  {
/* line 73 "SemParallel.puma" */
   CheckJumpOut (par_construct, par_construct->ACF_FORALL.FORALL_BODY);
/* line 75 "SemParallel.puma" */
   SemanticForallLoop (par_construct->ACF_FORALL.FORALL_BODY, par_construct);
  }
   return;

  case kACF_DO:
  if (par_construct->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 78 "SemParallel.puma" */
  {
/* line 80 "SemParallel.puma" */
   CheckJumpOut (par_construct, par_construct->ACF_DO.DO_BODY);
/* line 87 "SemParallel.puma" */
   SemanticParConstruct (par_construct->ACF_DO.DO_BODY, par_construct);
  }
   return;

  }
  if (par_construct->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 90 "SemParallel.puma" */
   return;

  }
  break;
  case kACF_HOME:
/* line 95 "SemParallel.puma" */
  {
/* line 97 "SemParallel.puma" */
   CheckJumpOut (par_construct, par_construct->ACF_HOME.HOME_BODY);
/* line 99 "SemParallel.puma" */
   SemanticOnClause (par_construct->ACF_HOME.HOME_VAR);
/* line 100 "SemParallel.puma" */
   SemanticParConstruct (par_construct->ACF_HOME.HOME_BODY, par_construct);
  }
   return;

  case kACF_RESIDENT:
/* line 103 "SemParallel.puma" */
  {
/* line 105 "SemParallel.puma" */
   CheckJumpOut (par_construct, par_construct->ACF_RESIDENT.RESIDENT_BODY);
/* line 107 "SemParallel.puma" */
   SemanticResident (par_construct->ACF_RESIDENT.RESIDENT_VAR);
  }
   return;

  case kACF_NEW:
/* line 110 "SemParallel.puma" */
  {
/* line 112 "SemParallel.puma" */
   SemanticNewVars (par_construct->ACF_NEW.NEW_VAR);
  }
   return;

  case kACF_REDUCTION:
  if (par_construct->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (par_construct->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 115 "SemParallel.puma" */
 {
  tTree fn;
  int kind;
  int error;
  {
/* line 120 "SemParallel.puma" */
   CheckJumpOut (par_construct, par_construct->ACF_REDUCTION.REDUCTION_BODY);
/* line 122 "SemParallel.puma" */
   SemanticRedVars (par_construct->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem);
/* line 128 "SemParallel.puma" */
   IdentifyReduction (par_construct->ACF_REDUCTION.REDUCTION_BODY, par_construct->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem, & error, & fn, & kind);
/* line 130 "SemParallel.puma" */
 if (fn == NoTree)

       { char msg[80], varstr[40];
         set_protocol_stmt (par_construct);
         StrUnparse (varstr, 40, par_construct->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem);
         sprintf (msg, "reduction variable %s not used in any reduction",
                  varstr);
         serious_warning_protocol (msg);
       }

     else

       { par_construct->ACF_REDUCTION.REDUCTION_FUNC = fn;
         par_construct->ACF_REDUCTION.red_kind     = kind;
       }

   
  }
   return;
 }

  }
  }
  break;
  case kACF_TASK_REGION:
/* line 149 "SemParallel.puma" */
  {
/* line 151 "SemParallel.puma" */
   CheckJumpOut (par_construct, par_construct->ACF_TASK_REGION.TASK_BODY);
/* line 153 "SemParallel.puma" */
   CheckTaskBody (par_construct->ACF_TASK_REGION.TASK_BODY, par_construct->ACF_TASK_REGION.task_flag);
  }
   return;

  }

/* line 156 "SemParallel.puma" */
  {
/* line 158 "SemParallel.puma" */
   failure_protocol (MODULE, "SemParallel", par_construct);
  }
   return;

;
}

static tTree RemoveDoLabel
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Elem->Kind == kACF_DUMMY) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 169 "SemParallel.puma" */
   return body->ACF_LIST.Next;

  }
  }
/* line 173 "SemParallel.puma" */
  {
/* line 174 "SemParallel.puma" */
 body->ACF_LIST.Next = RemoveDoLabel (body->ACF_LIST.Next); 
  }
   return body;

  }
  if (body->Kind == kACF_EMPTY) {
/* line 178 "SemParallel.puma" */
   return body;

  }
/* line 182 "SemParallel.puma" */
  {
/* line 183 "SemParallel.puma" */
   failure_protocol (MODULE, "RemoveDoLabel", body);
  }
   return body;

}

static void SemanticOnClause
# if defined __STDC__ | defined __cplusplus
(register tTree on_clause)
# else
(on_clause)
 register tTree on_clause;
# endif
{
  if (on_clause->Kind == kON_PROC_CLAUSE) {
/* line 195 "SemParallel.puma" */
  {
/* line 197 "SemParallel.puma" */
   SemTopology (on_clause->ON_PROC_CLAUSE.ON_PROC);
  }
   return;

  }
  if (on_clause->Kind == kON_VAR_CLAUSE) {
/* line 200 "SemParallel.puma" */
  {
/* line 202 "SemParallel.puma" */
   SemVariable (on_clause->ON_VAR_CLAUSE.ON_VAR);
  }
   return;

  }
/* line 205 "SemParallel.puma" */
  {
/* line 206 "SemParallel.puma" */
   failure_protocol (MODULE, "SemanticOnClause", on_clause);
  }
   return;

;
}

static void SemanticResident
# if defined __STDC__ | defined __cplusplus
(register tTree resident_vars)
# else
(resident_vars)
 register tTree resident_vars;
# endif
{
 yyRecursion:
  if (resident_vars->Kind == kBTV_EMPTY) {
/* line 217 "SemParallel.puma" */
   return;

  }
  if (resident_vars->Kind == kBTV_LIST) {
  if (resident_vars->BTV_LIST.Elem->Kind == kDUMMY_VAR) {
  if (resident_vars->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 220 "SemParallel.puma" */
   return;

  }
  }
/* line 223 "SemParallel.puma" */
  {
/* line 225 "SemParallel.puma" */
   SemVariable (resident_vars->BTV_LIST.Elem);
/* line 226 "SemParallel.puma" */
   resident_vars = resident_vars->BTV_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 229 "SemParallel.puma" */
  {
/* line 230 "SemParallel.puma" */
   failure_protocol (MODULE, "SemanticResident", resident_vars);
  }
   return;

;
}

static void SemanticNewVars
# if defined __STDC__ | defined __cplusplus
(register tTree v)
# else
(v)
 register tTree v;
# endif
{
 yyRecursion:
/* line 241 "SemParallel.puma" */
  {
/* line 242 "SemParallel.puma" */
   if (! ((v == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (v->Kind == kBTV_LIST) {
/* line 245 "SemParallel.puma" */
  {
/* line 246 "SemParallel.puma" */
   SemanticNewVars (v->BTV_LIST.Elem);
/* line 247 "SemParallel.puma" */
   v = v->BTV_LIST.Next;
   goto yyRecursion;
  }

  }
  if (v->Kind == kBTV_EMPTY) {
/* line 250 "SemParallel.puma" */
   return;

  }
  if (v->Kind == kUSED_VAR) {
/* line 253 "SemParallel.puma" */
  {
/* line 255 "SemParallel.puma" */
   CheckNewVarObject (v->USED_VAR.VARNAME->VAR_OBJ.Object);
  }
   return;

  }
/* line 261 "SemParallel.puma" */
  {
/* line 262 "SemParallel.puma" */
   error_protocol ("illegal variable in NEW directive");
/* line 263 "SemParallel.puma" */
   tree_protocol ("illegal var : ", v);
  }
   return;

;
}

static void CheckNewVarObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 268 "SemParallel.puma" */
  {
/* line 269 "SemParallel.puma" */
   if (! ((IsPointerObject (obj)))) goto yyL1;
  {
/* line 270 "SemParallel.puma" */
   error_protocol ("variable in NEW must not be a POINTER");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 273 "SemParallel.puma" */
  {
/* line 275 "SemParallel.puma" */
 if (obj->VarObject.Kind->VarLocal.save)
       error_protocol ("variable in NEW must not have the SAVE attribute");
     if (obj->VarObject.target)
       error_protocol ("variable in NEW must not have the TARGET attribute");
   
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 282 "SemParallel.puma" */
  {
/* line 284 "SemParallel.puma" */
   error_protocol ("variable in NEW must not be a dummy argument");
/* line 285 "SemParallel.puma" */
   obj_protocol ("object is : ", obj);
  }
   return;

  }
  }
/* line 288 "SemParallel.puma" */
  {
/* line 290 "SemParallel.puma" */
   error_protocol ("illegal variable in NEW option");
/* line 291 "SemParallel.puma" */
   obj_protocol ("object is : ", obj);
  }
   return;

;
}

static void SemanticRedVars
# if defined __STDC__ | defined __cplusplus
(register tTree v)
# else
(v)
 register tTree v;
# endif
{
 yyRecursion:
/* line 302 "SemParallel.puma" */
  {
/* line 303 "SemParallel.puma" */
   if (! ((v == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (v->Kind == kBTV_LIST) {
/* line 306 "SemParallel.puma" */
  {
/* line 307 "SemParallel.puma" */
   SemanticRedVars (v->BTV_LIST.Elem);
/* line 308 "SemParallel.puma" */
   v = v->BTV_LIST.Next;
   goto yyRecursion;
  }

  }
  if (v->Kind == kBTV_EMPTY) {
/* line 311 "SemParallel.puma" */
   return;

  }
  if (v->Kind == kUSED_VAR) {
/* line 314 "SemParallel.puma" */
  {
/* line 316 "SemParallel.puma" */
   CheckRedVarObject (v->USED_VAR.VARNAME->VAR_OBJ.Object);
  }
   return;

  }
/* line 322 "SemParallel.puma" */
  {
/* line 323 "SemParallel.puma" */
   error_protocol ("illegal variable in NEW directive");
/* line 324 "SemParallel.puma" */
   tree_protocol ("illegal var : ", v);
  }
   return;

;
}

static void CheckRedVarObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 338 "SemParallel.puma" */
  {
/* line 339 "SemParallel.puma" */
   if (! ((IsPointerObject (obj)))) goto yyL1;
  {
/* line 340 "SemParallel.puma" */
   error_protocol ("variable in REDUCTION must not be a POINTER");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 343 "SemParallel.puma" */
  {
/* line 345 "SemParallel.puma" */
 if (obj->VarObject.Kind->VarLocal.save)
       error_protocol ("var in REDUCTION must not have the SAVE attribute");
     if (obj->VarObject.target)
       error_protocol ("var in REDUCTION must not have the TARGET attribute");
   
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 352 "SemParallel.puma" */
  {
/* line 354 "SemParallel.puma" */
   warning_protocol ("variable in REDUCTION must not be a dummy argument");
/* line 355 "SemParallel.puma" */
   obj_protocol ("object is : ", obj);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarCommon) {
/* line 358 "SemParallel.puma" */
  {
/* line 360 "SemParallel.puma" */
   warning_protocol ("variable in REDUCTION should not be in common");
/* line 361 "SemParallel.puma" */
   obj_protocol ("object is : ", obj);
  }
   return;

  }
  }
/* line 364 "SemParallel.puma" */
  {
/* line 366 "SemParallel.puma" */
   error_protocol ("illegal variable in REDUCTION option");
/* line 367 "SemParallel.puma" */
   obj_protocol ("object is : ", obj);
  }
   return;

;
}

static void SemanticForallLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree loop)
# else
(t, loop)
 register tTree t;
 register tTree loop;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 381 "SemParallel.puma" */
  {
/* line 383 "SemParallel.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 384 "SemParallel.puma" */
   SemanticForallLoop (t->ACF_LIST.Elem, loop);
/* line 385 "SemParallel.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 388 "SemParallel.puma" */
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 391 "SemParallel.puma" */
  {
/* line 395 "SemParallel.puma" */
   ForallVarCheck (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
  }
   return;

  }
  break;
  case kACF_WHERE:
/* line 398 "SemParallel.puma" */
  {
/* line 402 "SemParallel.puma" */
   SemanticForallLoop (t->ACF_WHERE.TRUE_PART, loop);
/* line 403 "SemParallel.puma" */
   t = t->ACF_WHERE.FALSE_PART;
   goto yyRecursion;
  }

  case kACF_FORALL:
/* line 406 "SemParallel.puma" */
   return;

  case kACF_HOME:
/* line 411 "SemParallel.puma" */
  {
/* line 413 "SemParallel.puma" */
   t = t->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  case kACF_IF:
/* line 418 "SemParallel.puma" */
  {
/* line 420 "SemParallel.puma" */
   SemanticForallLoop (t->ACF_IF.THEN_PART, loop);
/* line 421 "SemParallel.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  }

/* line 424 "SemParallel.puma" */
  {
/* line 426 "SemParallel.puma" */
   error_protocol ("this statement is not allowed in FORALL");
  }
   return;

;
}

static void SemanticParConstruct
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree par_constrcut)
# else
(t, par_constrcut)
 register tTree t;
 register tTree par_constrcut;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 439 "SemParallel.puma" */
  {
/* line 441 "SemParallel.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 442 "SemParallel.puma" */
   SemanticParConstruct (t->ACF_LIST.Elem, par_constrcut);
/* line 443 "SemParallel.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 446 "SemParallel.puma" */
   return;

  case kACF_DUMMY:
/* line 449 "SemParallel.puma" */
   return;

  case kACF_BASIC:

  switch (t->ACF_BASIC.BASIC_STMT->Kind) {
  case kASSIGN_STMT:
/* line 454 "SemParallel.puma" */
   return;

  case kATOMIC_STMT:
/* line 459 "SemParallel.puma" */
   return;

  case kCALL_STMT:
/* line 462 "SemParallel.puma" */
   return;

  case kREDUCE_STMT:
/* line 467 "SemParallel.puma" */
   return;

  case kALLOCATE_STMT:
/* line 472 "SemParallel.puma" */
   return;

  case kDEALLOCATE_STMT:
/* line 473 "SemParallel.puma" */
   return;

  case kCREATE_DSP_STMT:
/* line 474 "SemParallel.puma" */
   return;

  case kFREE_DSP_STMT:
/* line 475 "SemParallel.puma" */
   return;

  }

  break;
  case kACF_HOME:
/* line 477 "SemParallel.puma" */
  {
/* line 479 "SemParallel.puma" */
   t = t->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  case kACF_TASK_REGION:
/* line 482 "SemParallel.puma" */
  {
/* line 484 "SemParallel.puma" */
   t = t->ACF_TASK_REGION.TASK_BODY;
   goto yyRecursion;
  }

  case kACF_FORALL:
/* line 487 "SemParallel.puma" */
   return;

  case kACF_DO:
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 492 "SemParallel.puma" */
   return;

  }
/* line 497 "SemParallel.puma" */
  {
/* line 501 "SemParallel.puma" */
   t = t->ACF_DO.DO_BODY;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 504 "SemParallel.puma" */
  {
/* line 508 "SemParallel.puma" */
   t = t->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;
  }

  case kACF_IF:
/* line 511 "SemParallel.puma" */
  {
/* line 513 "SemParallel.puma" */
   SemanticParConstruct (t->ACF_IF.THEN_PART, par_constrcut);
/* line 514 "SemParallel.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_NEW:
/* line 517 "SemParallel.puma" */
  {
/* line 519 "SemParallel.puma" */
   t = t->ACF_NEW.NEW_BODY;
   goto yyRecursion;
  }

  case kACF_RESIDENT:
/* line 522 "SemParallel.puma" */
  {
/* line 524 "SemParallel.puma" */
   t = t->ACF_RESIDENT.RESIDENT_BODY;
   goto yyRecursion;
  }

  case kACF_REDUCTION:
/* line 527 "SemParallel.puma" */
  {
/* line 529 "SemParallel.puma" */
   t = t->ACF_REDUCTION.REDUCTION_BODY;
   goto yyRecursion;
  }

  }

/* line 532 "SemParallel.puma" */
  {
/* line 534 "SemParallel.puma" */
   MakeParConstructSerial (par_constrcut, t);
  }
   return;

;
}

static void MakeParConstructSerial
# if defined __STDC__ | defined __cplusplus
(register tTree loop, register tTree stmt)
# else
(loop, stmt)
 register tTree loop;
 register tTree stmt;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 545 "SemParallel.puma" */
  {
/* line 547 "SemParallel.puma" */
   set_protocol_stmt (stmt);
/* line 549 "SemParallel.puma" */
   serious_warning_protocol ("not handled in INDEPENDENT loop");
  }
   return;

  }
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 563 "SemParallel.puma" */
   return;

  }
  }
  if (loop->Kind == kACF_HOME) {
  if (loop->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 554 "SemParallel.puma" */
  {
/* line 556 "SemParallel.puma" */
   set_protocol_stmt (stmt);
/* line 558 "SemParallel.puma" */
   serious_warning_protocol ("not handled in ON HOME directive");
  }
   return;

  }
  if (loop->ACF_HOME.HOME_VAR->Kind == kON_ALL_CLAUSE) {
/* line 566 "SemParallel.puma" */
   return;

  }
  }
/* line 569 "SemParallel.puma" */
  {
/* line 571 "SemParallel.puma" */
   failure_protocol (MODULE, "MakeParConstructSerial", loop);
  }
   return;

;
}

static void CheckTaskBody
# if defined __STDC__ | defined __cplusplus
(register tTree body, register int indep_flag)
# else
(body, indep_flag)
 register tTree body;
 register int indep_flag;
# endif
{
 yyRecursion:
  if (body->Kind == kACF_LIST) {
/* line 582 "SemParallel.puma" */
  {
/* line 584 "SemParallel.puma" */
   CheckTaskBody (body->ACF_LIST.Elem, indep_flag);
/* line 585 "SemParallel.puma" */
   body = body->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (body->Kind == kACF_EMPTY) {
/* line 588 "SemParallel.puma" */
   return;

  }
  if (body->Kind == kACF_HOME) {
/* line 591 "SemParallel.puma" */
  {
/* line 593 "SemParallel.puma" */
 if (!IsResident (body->ACF_HOME.HOME_BODY))
        serious_warning_protocol ("ON clause in TASK_REGION not resident");
   
  }
   return;

  }
  if (body->Kind == kACF_TASK_REGION) {
/* line 598 "SemParallel.puma" */
   return;

  }
/* line 601 "SemParallel.puma" */
  {
/* line 603 "SemParallel.puma" */
   if (! ((indep_flag))) goto yyL5;
  {
/* line 605 "SemParallel.puma" */
   error_protocol ("illegal stmt in INDEPENDENT task_region");
/* line 606 "SemParallel.puma" */
   tree_protocol ("this statement is not allowed :\n", body);
  }
  }
   return;
yyL5:;

;
}

static rbool IsResident
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Elem->Kind == kACF_RESIDENT) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 611 "SemParallel.puma" */
   return rtrue;

  }
  }
  }
  return rfalse;
}

static void CheckJumpOut
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree body)
# else
(stmt, body)
 register tTree stmt;
 register tTree body;
# endif
{
/* line 624 "SemParallel.puma" */
 char msg[100]; 
/* line 626 "SemParallel.puma" */
  {
/* line 628 "SemParallel.puma" */
   if (! ((HasJumpOut (body)))) goto yyL1;
  {
/* line 630 "SemParallel.puma" */
   set_protocol_stmt (stmt);
/* line 632 "SemParallel.puma" */
   sprintf (msg, "jump (to label %d), out of construct, not allowed", jump_label);
/* line 635 "SemParallel.puma" */
   error_protocol (msg);
  }
  }
   return;
yyL1:;

/* line 638 "SemParallel.puma" */
   return;

;
}

rbool HasJumpOut
# if defined __STDC__ | defined __cplusplus
(register tTree stmts)
# else
(stmts)
 register tTree stmts;
# endif
{
/* line 652 "SemParallel.puma" */
 {
  int i;
  int n;
  rbool jump;
  int label;
  int used;
  int defined;
  {
/* line 654 "SemParallel.puma" */
   assigned_gotos = rfalse;
/* line 656 "SemParallel.puma" */
   InitLabels ();
/* line 658 "SemParallel.puma" */
   FullTraverseAST (stmts, SetLabelInfo);
/* line 664 "SemParallel.puma" */
   n = GetNoLabels ();
/* line 666 "SemParallel.puma" */
   jump = rfalse;
/* line 668 "SemParallel.puma" */
/* line 668 "SemParallel.puma" */
   i = 1;
   while (i <= n) {
/* line 674 "SemParallel.puma" */
   GetLabelInfo (i, & label, & used, & defined);
/* line 676 "SemParallel.puma" */
   if (((used > 0) && (defined == 0))) {
/* line 678 "SemParallel.puma" */
   jump_label = label;
/* line 680 "SemParallel.puma" */
   jump = rtrue;
   }
/* line 668 "SemParallel.puma" */
   i ++;
   }
/* line 686 "SemParallel.puma" */
   if (! ((jump || assigned_gotos))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static void SetLabelInfo
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kACF_NODE)) {
/* line 696 "SemParallel.puma" */
  {
/* line 698 "SemParallel.puma" */
   if (! ((t->ACF_NODE.Label != 0))) goto yyL1;
  {
/* line 700 "SemParallel.puma" */
   LabelDefine (t->ACF_NODE.Label);
  }
  }
   return;
yyL1:;

  }
  if (t->Kind == kGOTO_STMT) {
/* line 703 "SemParallel.puma" */
  {
/* line 705 "SemParallel.puma" */
   LabelUse (t->GOTO_STMT.GOTO_LABEL);
  }
   return;

  }
  if (t->Kind == kASS_GOTO_STMT) {
  if (t->ASS_GOTO_STMT.LABELS->Kind == kLABEL_EMPTY) {
/* line 710 "SemParallel.puma" */
  {
/* line 712 "SemParallel.puma" */
   assigned_gotos = rtrue;
  }
   return;

  }
  }
  if (t->Kind == kRETURN_PARAM) {
/* line 715 "SemParallel.puma" */
  {
/* line 717 "SemParallel.puma" */
   LabelUse (t->RETURN_PARAM.label);
  }
   return;

  }
  if (t->Kind == kLABEL_LIST) {
/* line 720 "SemParallel.puma" */
  {
/* line 722 "SemParallel.puma" */
   LabelUse (t->LABEL_LIST.Elem);
  }
   return;

  }
  if (t->Kind == kCOMP_IF_STMT) {
/* line 725 "SemParallel.puma" */
  {
/* line 729 "SemParallel.puma" */
   LabelUse (t->COMP_IF_STMT.IF_LT_LABEL);
/* line 730 "SemParallel.puma" */
   LabelUse (t->COMP_IF_STMT.IF_EQ_LABEL);
/* line 731 "SemParallel.puma" */
   LabelUse (t->COMP_IF_STMT.IF_GT_LABEL);
  }
   return;

  }
;
}

static rbool LegalIndepLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 742 "SemParallel.puma" */
  {
/* line 744 "SemParallel.puma" */
   if (! ((HasJumpOut (loop->ACF_DO.DO_BODY)))) goto yyL1;
  {
/* line 745 "SemParallel.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 748 "SemParallel.puma" */
  {
/* line 750 "SemParallel.puma" */
   if (! ((LegalIndepBody (loop->ACF_DO.DO_BODY)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

rbool LegalIndepBody
# if defined __STDC__ | defined __cplusplus
(register tTree stmts)
# else
(stmts)
 register tTree stmts;
# endif
{

  switch (stmts->Kind) {
  case kACF_LIST:
/* line 761 "SemParallel.puma" */
  {
/* line 763 "SemParallel.puma" */
   set_protocol_stmt (stmts->ACF_LIST.Elem);
/* line 764 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_LIST.Elem)))) goto yyL1;
  {
/* line 765 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  break;
  case kACF_EMPTY:
/* line 768 "SemParallel.puma" */
   return rtrue;

  case kACF_BASIC:

  switch (stmts->ACF_BASIC.BASIC_STMT->Kind) {
  case kASSIGN_STMT:
/* line 770 "SemParallel.puma" */
   return rtrue;

  case kATOMIC_STMT:
/* line 771 "SemParallel.puma" */
   return rtrue;

  case kCALL_STMT:
/* line 772 "SemParallel.puma" */
   return rtrue;

  case kREDUCE_STMT:
/* line 773 "SemParallel.puma" */
   return rtrue;

  case kALLOCATE_STMT:
/* line 774 "SemParallel.puma" */
   return rtrue;

  case kDEALLOCATE_STMT:
/* line 775 "SemParallel.puma" */
   return rtrue;

  case kCREATE_DSP_STMT:
/* line 776 "SemParallel.puma" */
   return rtrue;

  case kFREE_DSP_STMT:
/* line 777 "SemParallel.puma" */
   return rtrue;

  }

  break;
  case kACF_HOME:
/* line 779 "SemParallel.puma" */
  {
/* line 781 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_HOME.HOME_BODY)))) goto yyL11;
  }
   return rtrue;
yyL11:;

  break;
  case kACF_TASK_REGION:
/* line 784 "SemParallel.puma" */
  {
/* line 786 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_TASK_REGION.TASK_BODY)))) goto yyL12;
  }
   return rtrue;
yyL12:;

  break;
  case kACF_FORALL:
/* line 789 "SemParallel.puma" */
   return rtrue;

  case kACF_DO:
/* line 791 "SemParallel.puma" */
  {
/* line 793 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_DO.DO_BODY)))) goto yyL14;
  }
   return rtrue;
yyL14:;

  break;
  case kACF_WHILE:
/* line 796 "SemParallel.puma" */
  {
/* line 798 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_WHILE.WHILE_BODY)))) goto yyL15;
  }
   return rtrue;
yyL15:;

  break;
  case kACF_IF:
/* line 801 "SemParallel.puma" */
  {
/* line 803 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_IF.THEN_PART)))) goto yyL16;
  {
/* line 804 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_IF.ELSE_PART)))) goto yyL16;
  }
  }
   return rtrue;
yyL16:;

  break;
  case kACF_NEW:
/* line 807 "SemParallel.puma" */
  {
/* line 809 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_NEW.NEW_BODY)))) goto yyL17;
  }
   return rtrue;
yyL17:;

  break;
  case kACF_RESIDENT:
/* line 812 "SemParallel.puma" */
  {
/* line 814 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_RESIDENT.RESIDENT_BODY)))) goto yyL18;
  }
   return rtrue;
yyL18:;

  break;
  case kACF_REDUCTION:
/* line 817 "SemParallel.puma" */
  {
/* line 819 "SemParallel.puma" */
   if (! ((LegalIndepBody (stmts->ACF_REDUCTION.REDUCTION_BODY)))) goto yyL19;
  }
   return rtrue;
yyL19:;

  break;
  case kACF_DUMMY:
/* line 822 "SemParallel.puma" */
   return rtrue;

  }

  return rfalse;
}

void BeginSemParallel ARGS ((void))
{
}

void CloseSemParallel ARGS ((void))
{
}
