# include "SemMap.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 39 "SemMap.puma" */


# include "Idents.h"
# include "StringM.h"
# include "Types.h"

# include "DefTable.h"

# include "Expressions.h"    /* ResolveExpression   */
# include "Invariant.h"      /* IsVarInExp          */
# include "TreeOps.h"

# include "protocol.h"
# include "Rank.h"
# include "MapDefs.h"        /* AnalTargetSpec      */

# include "Mapping.h"        /* ReplaceDefaultDistributions */

# include "Distributions.h"  /* IsAlignedObj                */

# define MODULE "SemMap"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySemMap.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* SemMap_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemMap, routine %s failed\n",
  yyFunction);
 SemMap_Exit ();
}

void EvalObjSpecMapping ARGS ((tDefinitions t));
void EvalObjRangeMapping ARGS ((tDefinitions t));
static tDefinitions EvalSpecMapDecl ARGS ((tDefinitions obj, tDefinitions d));
static tDefinitions EvalRangeMapDecl ARGS ((tDefinitions obj, tDefinitions d));
static tDefinitions EvalDistributionDecl ARGS ((tTree layout_decl));
tDefinitions EvalDistributionStmt ARGS ((tTree layout_stmt));
static tDefinitions EvalRangeDecl ARGS ((tTree layout_decl));
static void GetObjectInfo ARGS ((tTree var, tIdent * yyP2, tDefinitions * yyP1));
static tDefinitions EvalDistributionSpec ARGS ((tTree d_spec, tTree p_spec));
static tDefinitions EvalRangeSpec ARGS ((tIdent tid, tTree d_spec));
static rbool IsReplicatedDistribution ARGS ((tTree t));
static tDefinitions ComputeNodeDistribution ARGS ((tTree mapping, tDefinitions p_obj));
static tDefinitions ComputeRangeDistribution ARGS ((tTree mapping));
static tDefinitions MakeDistDimList ARGS ((tTree mapping, int top_dim, int temp_dim));
static void CodeDistribution ARGS ((tTree distribution, int * yyP6, tTree * yyP5, tTree * yyP4, tTree * yyP3));
static rbool IsLegalIntArray ARGS ((tTree int_array));
static int NoDistributedDims ARGS ((tDefinitions dlist));
static tDefinitions EvalAlignmentDecl ARGS ((tTree align_decl));
tDefinitions EvalAlignmentStmt ARGS ((tTree align_stmt));
static tDefinitions ComputeAlignment ARGS ((tTree source, tTree target, tDefinitions temp_obj));
static tDefinitions MakeAlignTargetDimList ARGS ((int temp_dim, tTree source, tTree target));
static tDefinitions MakeAlignSourceDimList ARGS ((int i, int n, tDefinitions target_list));
static void FindEntry ARGS ((tDefinitions target_list, int index, tDefinitions * yyP7));

void EvalObjSpecMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kTemplateObject) {
  if (t->TemplateObject.Dist->Mapping.spec->Kind == kMapDecl) {
/* line 75 "SemMap.puma" */
  {
/* line 77 "SemMap.puma" */
 t->TemplateObject.Dist->Mapping.spec = EvalSpecMapDecl (t, t->TemplateObject.Dist->Mapping.spec); 
  }
   return;

  }
  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Dist->Mapping.spec->Kind == kMapDecl) {
/* line 80 "SemMap.puma" */
  {
/* line 82 "SemMap.puma" */
 t->VarObject.Dist->Mapping.spec = EvalSpecMapDecl (t, t->VarObject.Dist->Mapping.spec); 
  }
   return;

  }
  }
/* line 85 "SemMap.puma" */
  {
/* line 87 "SemMap.puma" */
   obj_error_protocol ("EvalObjSpecMapping illegal", t);
  }
   return;

;
}

void EvalObjRangeMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kTemplateObject) {
  if (t->TemplateObject.Dist->Mapping.range->Kind == kRangeDecl) {
/* line 92 "SemMap.puma" */
  {
/* line 94 "SemMap.puma" */
 t->TemplateObject.Dist->Mapping.range = EvalRangeMapDecl (t, t->TemplateObject.Dist->Mapping.range); 
  }
   return;

  }
  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Dist->Mapping.range->Kind == kRangeDecl) {
/* line 97 "SemMap.puma" */
  {
/* line 99 "SemMap.puma" */
 t->VarObject.Dist->Mapping.range = EvalRangeMapDecl (t, t->VarObject.Dist->Mapping.range); 
  }
   return;

  }
  }
/* line 102 "SemMap.puma" */
  {
/* line 104 "SemMap.puma" */
   obj_error_protocol ("EvalObjSpecMapping illegal", t);
  }
   return;

;
}

static tDefinitions EvalSpecMapDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions d)
# else
(obj, d)
 register tDefinitions obj;
 register tDefinitions d;
# endif
{
  if (d->Kind == kMapDecl) {
  if (d->MapDecl.decl->Kind == kDISTRIBUTE_DECL) {
/* line 115 "SemMap.puma" */
  {
/* line 117 "SemMap.puma" */
   set_protocol_stmt (d->MapDecl.decl);
/* line 119 "SemMap.puma" */
   ReplaceDefaultDistributions (obj, d->MapDecl.decl);
/* line 120 "SemMap.puma" */
   ControlDistributeDecl (obj, d->MapDecl.decl);
  }
   return EvalDistributionDecl (d->MapDecl.decl);

  }
  if (d->MapDecl.decl->Kind == kALIGN_DECL) {
/* line 125 "SemMap.puma" */
  {
/* line 127 "SemMap.puma" */
   set_protocol_stmt (d->MapDecl.decl);
  }
   return EvalAlignmentDecl (d->MapDecl.decl);

  }
/* line 132 "SemMap.puma" */
  {
/* line 134 "SemMap.puma" */
   set_protocol_stmt (d->MapDecl.decl);
/* line 136 "SemMap.puma" */
   failure_protocol (MODULE, "EvalDistribution", d->MapDecl.decl);
  }
   return d;

  }
/* line 141 "SemMap.puma" */
   return d;

}

static tDefinitions EvalRangeMapDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions d)
# else
(obj, d)
 register tDefinitions obj;
 register tDefinitions d;
# endif
{
  if (d->Kind == kRangeDecl) {
  if (d->RangeDecl.decl->Kind == kRANGE_DECL) {
/* line 154 "SemMap.puma" */
  {
/* line 156 "SemMap.puma" */
   set_protocol_stmt (d->RangeDecl.decl);
  }
   return EvalRangeDecl (d->RangeDecl.decl);

  }
/* line 161 "SemMap.puma" */
  {
/* line 163 "SemMap.puma" */
   set_protocol_stmt (d->RangeDecl.decl);
/* line 165 "SemMap.puma" */
   failure_protocol (MODULE, "EvalRangeMapDecl", d->RangeDecl.decl);
  }
   return d;

  }
/* line 170 "SemMap.puma" */
   return d;

}

static tDefinitions EvalDistributionDecl
# if defined __STDC__ | defined __cplusplus
(register tTree layout_decl)
# else
(layout_decl)
 register tTree layout_decl;
# endif
{
  if (layout_decl->Kind == kDISTRIBUTE_DECL) {
/* line 186 "SemMap.puma" */
   return EvalDistributionSpec (layout_decl->DISTRIBUTE_DECL.DISTRIBUTION, layout_decl->DISTRIBUTE_DECL.TARGET);

  }
/* line 191 "SemMap.puma" */
  {
/* line 193 "SemMap.puma" */
   failure_protocol (MODULE, "EvalDistributionDecl", layout_decl);
  }
   return mMapReplicated ();

}

tDefinitions EvalDistributionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree layout_stmt)
# else
(layout_stmt)
 register tTree layout_stmt;
# endif
{
  if (layout_stmt->Kind == kREDISTRIBUTE_STMT) {
  if (layout_stmt->REDISTRIBUTE_STMT.DISTRIBUTEE->Kind == kBTV_LIST) {
/* line 202 "SemMap.puma" */
 {
  tIdent yyV1;
  tDefinitions yyV2;
  {
/* line 205 "SemMap.puma" */
   GetObjectInfo (layout_stmt->REDISTRIBUTE_STMT.DISTRIBUTEE->BTV_LIST.Elem, & yyV1, & yyV2);
/* line 207 "SemMap.puma" */
   ReplaceDefaultDistributions (yyV2, layout_stmt);
/* line 209 "SemMap.puma" */
   ControlRedistributeStmt (layout_stmt);
  }
   return EvalDistributionSpec (layout_stmt->REDISTRIBUTE_STMT.DISTRIBUTION, layout_stmt->REDISTRIBUTE_STMT.TARGET);
 }

  }
  }
/* line 214 "SemMap.puma" */
  {
/* line 216 "SemMap.puma" */
   failure_protocol (MODULE, "EvalDistributionStmt", layout_stmt);
  }
   return mMapReplicated ();

}

static tDefinitions EvalRangeDecl
# if defined __STDC__ | defined __cplusplus
(register tTree layout_decl)
# else
(layout_decl)
 register tTree layout_decl;
# endif
{
  if (layout_decl->Kind == kRANGE_DECL) {
  if (layout_decl->RANGE_DECL.RANGES->Kind == kRANGE_LIST) {
  if (layout_decl->RANGE_DECL.RANGES->RANGE_LIST.Next->Kind == kRANGE_EMPTY) {
/* line 232 "SemMap.puma" */
 {
  tDefinitions selector;
  {
/* line 236 "SemMap.puma" */
   selector = EvalRangeSpec (layout_decl->RANGE_DECL.Ident, layout_decl->RANGE_DECL.RANGES->RANGE_LIST.Elem);
  }
   return mRangeSelection (mRangeList (selector, mRangeEmpty ()));
 }

  }
  }
  }
/* line 241 "SemMap.puma" */
  {
/* line 243 "SemMap.puma" */
   failure_protocol (MODULE, "EvalRangeDecl", layout_decl);
  }
   return mRangeDefault ();

}

static void GetObjectInfo
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent * yyP2, register tDefinitions * yyP1)
# else
(var, yyP2, yyP1)
 register tTree var;
 register tIdent * yyP2;
 register tDefinitions * yyP1;
# endif
{
  if (var->Kind == kVAR_OBJ) {
/* line 256 "SemMap.puma" */
   * yyP2 = var->VAR_OBJ.Ident;
   * yyP1 = var->VAR_OBJ.Object;
   return;

  }
  if (var->Kind == kUSED_VAR) {
/* line 259 "SemMap.puma" */
 {
  tIdent yyV1;
  tDefinitions yyV2;
  {
/* line 261 "SemMap.puma" */
   GetObjectInfo (var->USED_VAR.VARNAME, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 264 "SemMap.puma" */
   * yyP2 = var->SELECTED_VAR.SELECTOR->REC_COMP.Ident;
   * yyP1 = var->SELECTED_VAR.SELECTOR->REC_COMP.Object;
   return;

  }
/* line 267 "SemMap.puma" */
  {
/* line 269 "SemMap.puma" */
   failure_protocol (MODULE, "GetObjectInfo", var);
  }
   * yyP2 = DefaultId ();
   * yyP1 = NoObject;
   return;

;
}

static tDefinitions EvalDistributionSpec
# if defined __STDC__ | defined __cplusplus
(register tTree d_spec, register tTree p_spec)
# else
(d_spec, p_spec)
 register tTree d_spec;
 register tTree p_spec;
# endif
{
  if (d_spec->Kind == kANY_DISTRIBUTION) {
/* line 280 "SemMap.puma" */
   return mMapReplicated ();

  }
  if (d_spec->Kind == kREPL_DISTRIBUTION) {
/* line 285 "SemMap.puma" */
   return mMapReplicated ();

  }
  if (d_spec->Kind == kNODE_DISTRIBUTION) {
/* line 290 "SemMap.puma" */
  {
/* line 292 "SemMap.puma" */
   if (! ((IsReplicatedDistribution (d_spec->NODE_DISTRIBUTION.MAPPING)))) goto yyL3;
  }
   return mMapReplicated ();
yyL3:;

  if (p_spec->Kind == kPROCESSOR_ARRAY) {
/* line 297 "SemMap.puma" */
   return ComputeNodeDistribution (d_spec->NODE_DISTRIBUTION.MAPPING, p_spec->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object);

  }
  if (p_spec->Kind == kPROCESSOR_SUBSET) {
/* line 302 "SemMap.puma" */
   return ComputeNodeDistribution (d_spec->NODE_DISTRIBUTION.MAPPING, p_spec->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Object);

  }
  if (p_spec->Kind == kANY_PROCESSOR_ARRAY) {
/* line 307 "SemMap.puma" */
   return ComputeNodeDistribution (d_spec->NODE_DISTRIBUTION.MAPPING, NoObject);

  }
  }
/* line 314 "SemMap.puma" */
  {
/* line 316 "SemMap.puma" */
   failure_protocol (MODULE, "EvalDistributionSpec", d_spec);
  }
   return mMapReplicated ();

}

static tDefinitions EvalRangeSpec
# if defined __STDC__ | defined __cplusplus
(register tIdent tid, register tTree d_spec)
# else
(tid, d_spec)
 register tIdent tid;
 register tTree d_spec;
# endif
{
  if (d_spec->Kind == kNODE_DISTRIBUTION) {
/* line 329 "SemMap.puma" */
  {
/* line 331 "SemMap.puma" */
   if (! ((IsReplicatedDistribution (d_spec->NODE_DISTRIBUTION.MAPPING)))) goto yyL1;
  }
   return mRangeReplicated ();
yyL1:;

/* line 336 "SemMap.puma" */
   return ComputeRangeDistribution (d_spec->NODE_DISTRIBUTION.MAPPING);

  }
/* line 341 "SemMap.puma" */
  {
/* line 343 "SemMap.puma" */
   failure_protocol (MODULE, "EvalRangeSpec", d_spec);
  }
   return mRangeReplicated ();

}

static rbool IsReplicatedDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kDIST_EMPTY) {
/* line 359 "SemMap.puma" */
   return rtrue;

  }
  if (t->Kind == kDIST_LIST) {
  if (t->DIST_LIST.Elem->Kind == kSERIAL_DISTRIBUTION) {
/* line 362 "SemMap.puma" */
  {
/* line 364 "SemMap.puma" */
   t = t->DIST_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  return rfalse;
}

static tDefinitions ComputeNodeDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree mapping, register tDefinitions p_obj)
# else
(mapping, p_obj)
 register tTree mapping;
 register tDefinitions p_obj;
# endif
{
/* line 384 "SemMap.puma" */
 {
  tDefinitions array_list;
  {
/* line 388 "SemMap.puma" */
   array_list = MakeDistDimList (mapping, 1, 1);
  }
   return mMapDist (mDistribution (p_obj, array_list));
 }

}

static tDefinitions ComputeRangeDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree mapping)
# else
(mapping)
 register tTree mapping;
# endif
{
/* line 395 "SemMap.puma" */
 {
  tDefinitions array_list;
  {
/* line 399 "SemMap.puma" */
   array_list = MakeDistDimList (mapping, 1, 1);
  }
   return mRangeDist (array_list);
 }

}

static tDefinitions MakeDistDimList
# if defined __STDC__ | defined __cplusplus
(register tTree mapping, register int top_dim, register int temp_dim)
# else
(mapping, top_dim, temp_dim)
 register tTree mapping;
 register int top_dim;
 register int temp_dim;
# endif
{
  if (mapping->Kind == kDIST_EMPTY) {
/* line 422 "SemMap.puma" */
   return mDIM_EMPTY ();

  }
  if (mapping->Kind == kDIST_LIST) {
  if (mapping->DIST_LIST.Elem->Kind == kSERIAL_DISTRIBUTION) {
/* line 427 "SemMap.puma" */
   return mDIM_LIST (mSerialDimension (temp_dim), MakeDistDimList (mapping->DIST_LIST.Next, top_dim, temp_dim + 1));

  }
/* line 435 "SemMap.puma" */
 {
  int yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 439 "SemMap.puma" */
   CodeDistribution (mapping->DIST_LIST.Elem, & yyV1, & yyV2, & yyV3, & yyV4);
  }
   return mDIM_LIST (mDistributedDimension (temp_dim, top_dim, yyV1, yyV2, yyV3, yyV4), MakeDistDimList (mapping->DIST_LIST.Next, top_dim + 1, temp_dim + 1));
 }

  }
/* line 446 "SemMap.puma" */
  {
/* line 448 "SemMap.puma" */
   failure_protocol (MODULE, "MakeDistDimList", mapping);
  }
   return mDIM_EMPTY ();

}

static void CodeDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree distribution, register int * yyP6, register tTree * yyP5, register tTree * yyP4, register tTree * yyP3)
# else
(distribution, yyP6, yyP5, yyP4, yyP3)
 register tTree distribution;
 register int * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{

  switch (distribution->Kind) {
  case kBLOCK_DISTRIBUTION:
  if (distribution->BLOCK_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
/* line 462 "SemMap.puma" */
   * yyP6 = kBLOCK_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }
/* line 465 "SemMap.puma" */
  {
/* line 467 "SemMap.puma" */
 if (TreeRank (distribution->BLOCK_DISTRIBUTION.SIZE) != 0)
       { error_protocol ("size of BLOCK must be scalar");
         tree_protocol ("illegal size expression is : ", distribution->BLOCK_DISTRIBUTION.SIZE);
       }
   
  }
   * yyP6 = kBLOCK_DIM;
   * yyP5 = distribution->BLOCK_DISTRIBUTION.SIZE;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kCYCLIC_DISTRIBUTION:
  if (distribution->CYCLIC_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
/* line 474 "SemMap.puma" */
   * yyP6 = kCYCLIC_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }
/* line 477 "SemMap.puma" */
  {
/* line 479 "SemMap.puma" */
 if (TreeRank (distribution->CYCLIC_DISTRIBUTION.SIZE) != 0)
       { error_protocol ("size of CYCLIC must be scalar");
         tree_protocol ("illegal size expression is : ", distribution->CYCLIC_DISTRIBUTION.SIZE);
       }
   
  }
   * yyP6 = kCYCLIC_DIM;
   * yyP5 = distribution->CYCLIC_DISTRIBUTION.SIZE;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kGEN_BLOCK_DISTRIBUTION:
/* line 486 "SemMap.puma" */
  {
/* line 489 "SemMap.puma" */
 if (!IsLegalIntArray (distribution->GEN_BLOCK_DISTRIBUTION.ARRAY))

       { error_protocol ("size array in GEN_BLOCK must have rank 1");
         tree_protocol ("illegal array is : ", distribution->GEN_BLOCK_DISTRIBUTION.ARRAY);
       }
   
  }
   * yyP6 = kGEN_BLOCK_DIM;
   * yyP5 = distribution->GEN_BLOCK_DISTRIBUTION.ARRAY;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kINDIRECT_DISTRIBUTION:
/* line 497 "SemMap.puma" */
  {
/* line 500 "SemMap.puma" */
 if (!IsLegalIntArray (distribution->INDIRECT_DISTRIBUTION.ARRAY))

       { error_protocol ("map array in INDIRECT must have rank 1");
         tree_protocol ("illegal array is : ", distribution->INDIRECT_DISTRIBUTION.ARRAY);
       }
   
  }
   * yyP6 = kINDIRECT_DIM;
   * yyP5 = distribution->INDIRECT_DISTRIBUTION.ARRAY;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kARBITRARY_DISTRIBUTION:
/* line 508 "SemMap.puma" */
  {
/* line 511 "SemMap.puma" */
 if (TreeRank (distribution->ARBITRARY_DISTRIBUTION.SIZE) != 0)
       { error_protocol ("size of ARBITRARY must be scalar");
         tree_protocol ("illegal size expression is : ", distribution->ARBITRARY_DISTRIBUTION.SIZE);
       }

     if (!IsLegalIntArray (distribution->ARBITRARY_DISTRIBUTION.LENGTH))

       { error_protocol ("length array in ARBITRARY must have rank 1");
         tree_protocol ("illegal array is : ", distribution->ARBITRARY_DISTRIBUTION.LENGTH);
       }

     if (!IsLegalIntArray (distribution->ARBITRARY_DISTRIBUTION.MAP))

       { error_protocol ("map array in ARBITRARY must have rank 1");
         tree_protocol ("illegal array is : ", distribution->ARBITRARY_DISTRIBUTION.LENGTH);
       }
   
  }
   * yyP6 = kARBITRARY_DIM;
   * yyP5 = distribution->ARBITRARY_DISTRIBUTION.SIZE;
   * yyP4 = distribution->ARBITRARY_DISTRIBUTION.LENGTH;
   * yyP3 = distribution->ARBITRARY_DISTRIBUTION.MAP;
   return;

  case kANY_BLOCK_DISTRIBUTION:
/* line 530 "SemMap.puma" */
   * yyP6 = kANY_BLOCK_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_CYCLIC_DISTRIBUTION:
/* line 533 "SemMap.puma" */
   * yyP6 = kANY_CYCLIC_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_GEN_BLOCK_DISTRIBUTION:
/* line 536 "SemMap.puma" */
   * yyP6 = kANY_GEN_BLOCK_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_INDIRECT_DISTRIBUTION:
/* line 539 "SemMap.puma" */
   * yyP6 = kANY_INDIRECT_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_ARBITRARY_DISTRIBUTION:
/* line 542 "SemMap.puma" */
   * yyP6 = kANY_ARBITRARY_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_DIM_DISTRIBUTION:
/* line 545 "SemMap.puma" */
   * yyP6 = kANY_DISTRIBUTED_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }

/* line 548 "SemMap.puma" */
  {
/* line 550 "SemMap.puma" */
   error_protocol ("illegal distribution format");
/* line 551 "SemMap.puma" */
   tree_protocol ("illegal distribution is ", distribution);
  }
   * yyP6 = kANY_DISTRIBUTED_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

;
}

static rbool IsLegalIntArray
# if defined __STDC__ | defined __cplusplus
(register tTree int_array)
# else
(int_array)
 register tTree int_array;
# endif
{
  if (int_array->Kind == kUSED_VAR) {
/* line 562 "SemMap.puma" */
  {
/* line 564 "SemMap.puma" */
   if (! ((VarRank (int_array->USED_VAR.VARNAME->VAR_OBJ.Object) == 1))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static int NoDistributedDims
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dlist)
# else
(dlist)
 register tDefinitions dlist;
# endif
{
 yyRecursion:
  if (dlist->Kind == kDIM_EMPTY) {
/* line 575 "SemMap.puma" */
   return 0;

  }
  if (dlist->Kind == kDIM_LIST) {
  if (dlist->DIM_LIST.Elem->Kind == kDistributedDimension) {
/* line 580 "SemMap.puma" */
   return NoDistributedDims (dlist->DIM_LIST.Next) + 1;

  }
/* line 585 "SemMap.puma" */
   dlist = dlist->DIM_LIST.Next;
   goto yyRecursion;

  }
 yyAbort ("NoDistributedDims");
 { int yyDummy; return yyDummy; }
}

static tDefinitions EvalAlignmentDecl
# if defined __STDC__ | defined __cplusplus
(register tTree align_decl)
# else
(align_decl)
 register tTree align_decl;
# endif
{
  if (align_decl->Kind == kALIGN_DECL) {
/* line 601 "SemMap.puma" */
   return mMapAlign (ComputeAlignment (align_decl->ALIGN_DECL.ALIGN_SOURCE, align_decl->ALIGN_DECL.ALIGN_TARGET->ALIGN_SPEC.SUBSCRIPTS, align_decl->ALIGN_DECL.ALIGN_TARGET->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Object));

  }
/* line 607 "SemMap.puma" */
  {
/* line 609 "SemMap.puma" */
   failure_protocol ("Distributions", "EvalAlignmentDecl", align_decl);
  }
   return mMapReplicated ();

}

tDefinitions EvalAlignmentStmt
# if defined __STDC__ | defined __cplusplus
(register tTree align_stmt)
# else
(align_stmt)
 register tTree align_stmt;
# endif
{
  if (align_stmt->Kind == kREALIGN_STMT) {
/* line 625 "SemMap.puma" */
   return mMapAlign (ComputeAlignment (align_stmt->REALIGN_STMT.ALIGN_SOURCE, align_stmt->REALIGN_STMT.ALIGN_TARGET->ALIGN_SPEC.SUBSCRIPTS, align_stmt->REALIGN_STMT.ALIGN_TARGET->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Object));

  }
/* line 632 "SemMap.puma" */
  {
/* line 634 "SemMap.puma" */
   failure_protocol (MODULE, "EvalAlignmentStmt", align_stmt);
  }
   return NoObject;

}

static tDefinitions ComputeAlignment
# if defined __STDC__ | defined __cplusplus
(register tTree source, register tTree target, register tDefinitions temp_obj)
# else
(source, target, temp_obj)
 register tTree source;
 register tTree target;
 register tDefinitions temp_obj;
# endif
{
/* line 657 "SemMap.puma" */
 {
  tDefinitions target_list;
  tDefinitions source_list;
  tDefinitions newtop_list;
  {
/* line 665 "SemMap.puma" */
 if (IsAlignedObj (temp_obj))
         error_protocol ("aligned target in ALIGN not allowed");
    
/* line 669 "SemMap.puma" */
   target_list = MakeAlignTargetDimList (1, source, target);
/* line 674 "SemMap.puma" */
   source_list = MakeAlignSourceDimList (1, TreeListLength (source), target_list);
  }
   return mAlignment (temp_obj, target_list, source_list);
 }

}

static tDefinitions MakeAlignTargetDimList
# if defined __STDC__ | defined __cplusplus
(register int temp_dim, register tTree source, register tTree target)
# else
(temp_dim, source, target)
 register int temp_dim;
 register tTree source;
 register tTree target;
# endif
{
  if (target->Kind == kBTE_LIST) {
  if (target->BTE_LIST.Elem->Kind == kDUMMY_EXP) {
/* line 706 "SemMap.puma" */
   return mDIM_LIST (mReplicatedDimension (temp_dim), MakeAlignTargetDimList (temp_dim + 1, source, target->BTE_LIST.Next));

  }
/* line 712 "SemMap.puma" */
 {
  tDefinitions dim;
  int index_dim;
  tTree mult_tree;
  int mult_val;
  tTree add_tree;
  int add_val;
  rbool done;
  {
/* line 723 "SemMap.puma" */
   AnalTargetExp (target->BTE_LIST.Elem, source, & index_dim, & done, & mult_tree, & mult_val, & add_tree, & add_val);
/* line 726 "SemMap.puma" */
   if (! ((index_dim > 0))) goto yyL2;
  {
/* line 734 "SemMap.puma" */
 if (mult_tree == NoTree)
        mult_tree = MakeConstant (mult_val);
      else
        mult_tree = MultConstant (mult_tree, mult_val);
     if (add_tree == NoTree)
        add_tree = MakeConstant (add_val);
      else
        add_tree = MultConstant (add_tree, add_val);
   
  }
  }
   return mDIM_LIST (mAlignedDimension (index_dim, temp_dim, mult_tree, add_tree), MakeAlignTargetDimList (temp_dim + 1, source, target->BTE_LIST.Next));
 }
yyL2:;

/* line 749 "SemMap.puma" */
   return mDIM_LIST (mEmbeddedDimension (temp_dim, target->BTE_LIST.Elem), MakeAlignTargetDimList (temp_dim + 1, source, target->BTE_LIST.Next));

  }
  if (target->Kind == kBTE_EMPTY) {
/* line 755 "SemMap.puma" */
   return mDIM_EMPTY ();

  }
/* line 760 "SemMap.puma" */
  {
/* line 762 "SemMap.puma" */
   failure_protocol (MODULE, "MakeAlignTargetDimList", target);
  }
   return mDIM_EMPTY ();

}

static tDefinitions MakeAlignSourceDimList
# if defined __STDC__ | defined __cplusplus
(register int i, register int n, register tDefinitions target_list)
# else
(i, n, target_list)
 register int i;
 register int n;
 register tDefinitions target_list;
# endif
{
/* line 786 "SemMap.puma" */
  {
/* line 788 "SemMap.puma" */
   if (! ((i > n))) goto yyL1;
  }
   return mDIM_EMPTY ();
yyL1:;

/* line 792 "SemMap.puma" */
 {
  tDefinitions yyV1;
  {
/* line 794 "SemMap.puma" */
   FindEntry (target_list, i, & yyV1);
  }
   return mDIM_LIST (yyV1, MakeAlignSourceDimList (i + 1, n, target_list));
 }

}

static void FindEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions target_list, register int index, register tDefinitions * yyP7)
# else
(target_list, index, yyP7)
 register tDefinitions target_list;
 register int index;
 register tDefinitions * yyP7;
# endif
{
  if (target_list->Kind == kDIM_EMPTY) {
/* line 807 "SemMap.puma" */
 {
  tDefinitions dim;
  {
/* line 811 "SemMap.puma" */
   dim = mSerialDimension (index);
  }
   * yyP7 = dim;
   return;
 }

  }
  if (target_list->Kind == kDIM_LIST) {
  if (target_list->DIM_LIST.Elem->Kind == kAlignedDimension) {
/* line 814 "SemMap.puma" */
  {
/* line 816 "SemMap.puma" */
   if (! ((target_list->DIM_LIST.Elem->AlignedDimension.dimension == index))) goto yyL2;
  }
   * yyP7 = target_list->DIM_LIST.Elem;
   return;
yyL2:;

  }
/* line 819 "SemMap.puma" */
 {
  tDefinitions yyV1;
  {
/* line 821 "SemMap.puma" */
   FindEntry (target_list->DIM_LIST.Next, index, & yyV1);
  }
   * yyP7 = yyV1;
   return;
 }

  }
;
}

void BeginSemMap ARGS ((void))
{
}

void CloseSemMap ARGS ((void))
{
}
