# include "SemIntr.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 29 "SemIntr.puma" */


# define MODULE "SemIntr"

# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "DefTable.h"
# include "Transform.h"   /* ExpToVarParam */
# include "SemExp.h"      /* MergeRank, ScalarVariable, ... */
# include "SemPreds.h"    /* IntExpr, ...                   */
# include "Types.h"       /* GetTypeZero                    */
# include "Expressions.h" /* MakeConstant */
# include "Intrinsics.h"
# include "Rank.h"
# include "Objects.h"





# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySemIntr.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* SemIntr_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemIntr, routine %s failed\n",
  yyFunction);
 SemIntr_Exit ();
}

void SemIntrinsicFunction ARGS ((tTree exp, tIdent name, tTree params));
void SemIntrinsicSubroutine ARGS ((tIdent name, tTree params));
static void NoScalarArgument ARGS ((tIdent routine_id, tIdent arg, tTree arg_tree));
static void SameShape ARGS ((tIdent routine_id, tIdent arg1, tTree arg_tree1, tIdent arg2, tTree arg_tree2));
static void Conformable ARGS ((tIdent routine_id, tIdent arg1, tTree arg_tree1, tIdent arg2, tTree arg_tree2));
static void LegalDimArgument ARGS ((tIdent routine_id, tIdent arg, tTree arg_tree, tTree dim_tree));
static tTree MakeOmittedDim ARGS ((tTree dim));
static void CheckElementalIntrinsic ARGS ((tTree exp, tIdent name, tTree params));
static void CheckMerge ARGS ((tTree params));
static void CheckPack ARGS ((tTree params));
static void CheckUnpack ARGS ((tTree params));
static void CheckReshape ARGS ((tTree params));
static void CheckCShift ARGS ((tTree params));
static void CheckSpread ARGS ((tTree params));
static void CheckEOShift ARGS ((tTree params));
static void CheckSort ARGS ((tIdent name, tTree params));
static void CheckMatMul ARGS ((tTree params));
static void CheckDotProd ARGS ((tTree params));
static tTree GetBoundary ARGS ((tTree boundary, tTree array));
static void CheckTranspose ARGS ((tTree params));
static void CheckRed ARGS ((tIdent name, tTree params));
static void CheckLocRed ARGS ((tIdent name, tTree params));
static void CheckScan ARGS ((tIdent name, tTree params));
static void CheckScatter ARGS ((tIdent name, tTree params));
static void CheckSizeParams ARGS ((tIdent name, tTree params));
static void CheckBoundParams ARGS ((tIdent name, tTree params));
static void CheckIndexParams ARGS ((tTree params));
static void CheckPresentParams ARGS ((tTree params));
static void CheckConformRanks ARGS ((tTree call, tTree params, int rank));
void SetIntrinsicInfo ARGS ((tIdent name, int base_rank, routine set_parameter));
static void SetMinMaxParams ARGS ((int len, routine set_parameter, check_pred pred));
static void SetReductionParams ARGS ((int dimrank, routine set_parameter, check_pred pred));
static void SetScanParams ARGS ((tIdent name, routine set_parameter));
static void SetScatterParams ARGS ((int base_rank, routine set_parameter, check_pred pred));

void SemIntrinsicFunction
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tIdent name, register tTree params)
# else
(exp, name, params)
 register tTree exp;
 register tIdent name;
 register tTree params;
# endif
{
/* line 61 "SemIntr.puma" */
  {
/* line 63 "SemIntr.puma" */
   if (! ((GetIntrinsicClass (GetIntrinsicObject (name)) == kELEMENTAL))) goto yyL1;
  {
/* line 65 "SemIntr.puma" */
   CheckElementalIntrinsic (exp, name, params);
  }
  }
   return;
yyL1:;

/* line 68 "SemIntr.puma" */
  {
/* line 70 "SemIntr.puma" */
   if (! ((GetIntrinsicClass (GetIntrinsicObject (name)) == kINQUIRY))) goto yyL2;
  }
   return;
yyL2:;

/* line 73 "SemIntr.puma" */
  {
/* line 75 "SemIntr.puma" */
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kREDUCTION))) goto yyL3;
  {
/* line 76 "SemIntr.puma" */
   CheckRed (name, params);
  }
  }
   return;
yyL3:;

/* line 79 "SemIntr.puma" */
  {
/* line 81 "SemIntr.puma" */
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kLOCREDUCTION))) goto yyL4;
  {
/* line 82 "SemIntr.puma" */
   CheckLocRed (name, params);
  }
  }
   return;
yyL4:;

/* line 85 "SemIntr.puma" */
  {
/* line 87 "SemIntr.puma" */
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kSCAN))) goto yyL5;
  {
/* line 88 "SemIntr.puma" */
   CheckScan (name, params);
  }
  }
   return;
yyL5:;

  if (equaltIdent (name, IsIdent ("SPREAD"))) {
/* line 91 "SemIntr.puma" */
  {
/* line 93 "SemIntr.puma" */
   CheckSpread (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CSHIFT"))) {
/* line 100 "SemIntr.puma" */
  {
/* line 102 "SemIntr.puma" */
   CheckCShift (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EOSHIFT"))) {
/* line 105 "SemIntr.puma" */
  {
/* line 107 "SemIntr.puma" */
   CheckEOShift (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TRANSPOSE"))) {
/* line 114 "SemIntr.puma" */
  {
/* line 116 "SemIntr.puma" */
   CheckTranspose (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
/* line 123 "SemIntr.puma" */
  {
/* line 125 "SemIntr.puma" */
   CheckSort (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
/* line 128 "SemIntr.puma" */
  {
/* line 130 "SemIntr.puma" */
   CheckSort (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SORT_UP"))) {
/* line 137 "SemIntr.puma" */
  {
/* line 139 "SemIntr.puma" */
   CheckSort (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SORT_DOWN"))) {
/* line 142 "SemIntr.puma" */
  {
/* line 144 "SemIntr.puma" */
   CheckSort (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DOT_PRODUCT"))) {
/* line 151 "SemIntr.puma" */
  {
/* line 153 "SemIntr.puma" */
   CheckDotProd (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MATMUL"))) {
/* line 160 "SemIntr.puma" */
  {
/* line 162 "SemIntr.puma" */
   CheckMatMul (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MERGE", 5))) {
/* line 169 "SemIntr.puma" */
  {
/* line 171 "SemIntr.puma" */
   CheckMerge (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PACK"))) {
/* line 178 "SemIntr.puma" */
  {
/* line 180 "SemIntr.puma" */
   CheckPack (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
/* line 183 "SemIntr.puma" */
  {
/* line 185 "SemIntr.puma" */
   warning_protocol ("UNPACK ist not checked until now");
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
/* line 192 "SemIntr.puma" */
  {
/* line 194 "SemIntr.puma" */
   warning_protocol ("RESHAPE ist not checked until now");
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SIZE"))) {
/* line 201 "SemIntr.puma" */
  {
/* line 203 "SemIntr.puma" */
   CheckSizeParams (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LBOUND"))) {
/* line 206 "SemIntr.puma" */
  {
/* line 208 "SemIntr.puma" */
   CheckBoundParams (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("UBOUND"))) {
/* line 211 "SemIntr.puma" */
  {
/* line 213 "SemIntr.puma" */
   CheckBoundParams (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
/* line 216 "SemIntr.puma" */
  {
/* line 218 "SemIntr.puma" */
   warning_protocol ("SHAPE ist not checked until now");
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PRESENT"))) {
/* line 221 "SemIntr.puma" */
  {
/* line 223 "SemIntr.puma" */
   CheckPresentParams (params);
  }
   return;

  }
/* line 230 "SemIntr.puma" */
  {
/* line 232 "SemIntr.puma" */
   if (! ((IntrFuncScatter (name)))) goto yyL25;
  {
/* line 233 "SemIntr.puma" */
   CheckScatter (name, params);
  }
  }
   return;
yyL25:;

/* line 240 "SemIntr.puma" */
  {
/* line 242 "SemIntr.puma" */
   if (! (((name == IsIdent ("SELECTED_INT_KIND")) || (name == IsIdent ("SELECTED_REAL_KIND"))))) goto yyL26;
  }
   return;
yyL26:;

/* line 246 "SemIntr.puma" */
  {
/* line 248 "SemIntr.puma" */
   if (! ((name == IsIdent ("LOCAL_BLKCNT")))) goto yyL27;
  }
   return;
yyL27:;

/* line 251 "SemIntr.puma" */
  {
/* line 253 "SemIntr.puma" */
   if (! (((name == IsIdent ("LOCAL_LINDEX")) || (name == IsIdent ("LOCAL_UINDEX"))))) goto yyL28;
  }
   return;
yyL28:;

/* line 257 "SemIntr.puma" */
  {
/* line 259 "SemIntr.puma" */
   error_protocol ("unknown intrinsic function in Semantic Analysis");
/* line 260 "SemIntr.puma" */
   tree_protocol ("intrinsic call : ", mPROC_OBJ (name));
  }
   return;

;
}

void SemIntrinsicSubroutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (equaltIdent (name, IsIdent ("DATE_AND_TIME"))) {
/* line 271 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_NUMBER"))) {
/* line 274 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_SEED"))) {
/* line 277 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("CPU_TIME"))) {
/* line 280 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("MVBITS"))) {
/* line 283 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("SYSTEM_CLOCK"))) {
/* line 286 "SemIntr.puma" */
   return;

  }
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 289 "SemIntr.puma" */
  {
/* line 293 "SemIntr.puma" */
   if (! (((name == IsIdent ("HPF_ALIGNMENT")) || (name == IsIdent ("GLOBAL_ALIGNMENT"))))) goto yyL7;
  }
   return;
yyL7:;

  }
  }
  }
  }
  }
  }
  }
  }
  if (equaltIdent (name, IsIdent ("HPF_DISTRIBUTION"))) {
/* line 297 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_DISTRIBUTION"))) {
/* line 298 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("HPF_TEMPLATE"))) {
/* line 300 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TEMPLATE"))) {
/* line 301 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("HPF_SUBGRID_INFO"))) {
/* line 303 "SemIntr.puma" */
   return;

  }
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 305 "SemIntr.puma" */
  {
/* line 307 "SemIntr.puma" */
   if (! (((name == IsIdent ("ABSTRACT_TO_PHYSICAL")) || (name == IsIdent ("PHYSICAL_TO_ABSTRACT"))))) goto yyL13;
  }
   return;
yyL13:;

  }
  }
  }
  if (equaltIdent (name, IsIdent ("LOCAL_TO_GLOBAL"))) {
/* line 311 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TO_LOCAL"))) {
/* line 312 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("HPF_SEND"))) {
/* line 314 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("HPF_RECV"))) {
/* line 315 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("HPF_BCAST"))) {
/* line 316 "SemIntr.puma" */
   return;

  }
/* line 318 "SemIntr.puma" */
  {
/* line 319 "SemIntr.puma" */
   error_protocol ("unknown/illegal intrinsic subroutine (not supported)");
  }
   return;

;
}

static void NoScalarArgument
# if defined __STDC__ | defined __cplusplus
(register tIdent routine_id, register tIdent arg, register tTree arg_tree)
# else
(routine_id, arg, arg_tree)
 register tIdent routine_id;
 register tIdent arg;
 register tTree arg_tree;
# endif
{
/* line 336 "SemIntr.puma" */

char routine_name [MAX_ID_LENGTH];
char arg_name     [MAX_ID_LENGTH];
char msg          [MAX_LINE_LENGTH];

/* line 342 "SemIntr.puma" */
  {
/* line 344 "SemIntr.puma" */
   if (! ((TreeRank (arg_tree) > 0))) goto yyL1;
  }
   return;
yyL1:;

/* line 347 "SemIntr.puma" */
  {
/* line 349 "SemIntr.puma" */
   GetString (routine_id, routine_name);
/* line 350 "SemIntr.puma" */
   GetString (arg, arg_name);
/* line 351 "SemIntr.puma" */
   sprintf (msg, "argument for %s in %s must not be scalar", arg_name, routine_name);
/* line 353 "SemIntr.puma" */
   error_protocol (msg);
  }
   return;

;
}

static void SameShape
# if defined __STDC__ | defined __cplusplus
(register tIdent routine_id, register tIdent arg1, register tTree arg_tree1, register tIdent arg2, register tTree arg_tree2)
# else
(routine_id, arg1, arg_tree1, arg2, arg_tree2)
 register tIdent routine_id;
 register tIdent arg1;
 register tTree arg_tree1;
 register tIdent arg2;
 register tTree arg_tree2;
# endif
{
/* line 365 "SemIntr.puma" */

char routine_name [MAX_ID_LENGTH];
char arg_name1    [MAX_ID_LENGTH];
char arg_name2    [MAX_ID_LENGTH];
char msg          [MAX_LINE_LENGTH];

  if (arg_tree2->Kind == kNO_PARAM) {
/* line 372 "SemIntr.puma" */
   return;

  }
/* line 375 "SemIntr.puma" */
  {
/* line 377 "SemIntr.puma" */
   if (! ((TreeRank (arg_tree1) == TreeRank (arg_tree2)))) goto yyL2;
  }
   return;
yyL2:;

/* line 380 "SemIntr.puma" */
  {
/* line 382 "SemIntr.puma" */
   GetString (routine_id, routine_name);
/* line 383 "SemIntr.puma" */
   GetString (arg1, arg_name1);
/* line 384 "SemIntr.puma" */
   GetString (arg2, arg_name2);
/* line 385 "SemIntr.puma" */
   sprintf (msg, "arguments %s and %s in %s must have the same shape", arg_name1, arg_name2, routine_name);
/* line 387 "SemIntr.puma" */
   error_protocol (msg);
  }
   return;

;
}

static void Conformable
# if defined __STDC__ | defined __cplusplus
(register tIdent routine_id, register tIdent arg1, register tTree arg_tree1, register tIdent arg2, register tTree arg_tree2)
# else
(routine_id, arg1, arg_tree1, arg2, arg_tree2)
 register tIdent routine_id;
 register tIdent arg1;
 register tTree arg_tree1;
 register tIdent arg2;
 register tTree arg_tree2;
# endif
{
/* line 399 "SemIntr.puma" */

char routine_name [MAX_ID_LENGTH];
char arg_name1    [MAX_ID_LENGTH];
char arg_name2    [MAX_ID_LENGTH];
char msg          [MAX_LINE_LENGTH];

  if (arg_tree2->Kind == kNO_PARAM) {
/* line 406 "SemIntr.puma" */
   return;

  }
/* line 409 "SemIntr.puma" */
  {
/* line 411 "SemIntr.puma" */
   if (! ((TreeRank (arg_tree1) == TreeRank (arg_tree2)))) goto yyL2;
  }
   return;
yyL2:;

/* line 414 "SemIntr.puma" */
  {
/* line 416 "SemIntr.puma" */
   if (! ((TreeRank (arg_tree2) == 0))) goto yyL3;
  }
   return;
yyL3:;

/* line 419 "SemIntr.puma" */
  {
/* line 421 "SemIntr.puma" */
   GetString (routine_id, routine_name);
/* line 422 "SemIntr.puma" */
   GetString (arg1, arg_name1);
/* line 423 "SemIntr.puma" */
   GetString (arg2, arg_name2);
/* line 424 "SemIntr.puma" */
   sprintf (msg, "arguments %s and %s in %s must be conformable", arg_name1, arg_name2, routine_name);
/* line 426 "SemIntr.puma" */
   error_protocol (msg);
  }
   return;

;
}

static void LegalDimArgument
# if defined __STDC__ | defined __cplusplus
(register tIdent routine_id, register tIdent arg, register tTree arg_tree, register tTree dim_tree)
# else
(routine_id, arg, arg_tree, dim_tree)
 register tIdent routine_id;
 register tIdent arg;
 register tTree arg_tree;
 register tTree dim_tree;
# endif
{
/* line 438 "SemIntr.puma" */

int  dim, rank;
rbool found;
char routine_name [MAX_ID_LENGTH];
char arg_name     [MAX_ID_LENGTH];
char msg          [MAX_LINE_LENGTH];

  if (dim_tree->Kind == kNO_PARAM) {
/* line 446 "SemIntr.puma" */
   return;

  }
/* line 449 "SemIntr.puma" */
  {
/* line 451 "SemIntr.puma" */
   if (! ((! ScalarIntExpr (dim_tree)))) goto yyL2;
  {
/* line 453 "SemIntr.puma" */
   GetString (routine_id, routine_name);
/* line 454 "SemIntr.puma" */
   sprintf (msg, "DIM argument in %s is not scalar integer", routine_name);
/* line 455 "SemIntr.puma" */
   error_protocol (msg);
  }
  }
   return;
yyL2:;

/* line 458 "SemIntr.puma" */
  {
/* line 460 "SemIntr.puma" */
   rank = TreeRank (arg_tree);
/* line 461 "SemIntr.puma" */
   GetIntConstValue (dim_tree, & found, & dim);
/* line 462 "SemIntr.puma" */
   if (! ((found))) goto yyL3;
  {
/* line 464 "SemIntr.puma" */
 if (dim < 1)
 
     { GetString (routine_id, routine_name);
       sprintf (msg, "DIM argument in %s must be positive", routine_name);
       error_protocol (msg);
     }

     if (dim > rank)

     { GetString (routine_id, routine_name);
       GetString (arg, arg_name);
       sprintf (msg, "DIM argument (=%d) in %s must be <= %d (rank of %s)",
                      dim, routine_name, rank, arg_name);
       error_protocol (msg);
     }
   
  }
  }
   return;
yyL3:;

/* line 482 "SemIntr.puma" */
  {
/* line 484 "SemIntr.puma" */
   GetString (routine_id, routine_name);
/* line 485 "SemIntr.puma" */
   sprintf (msg, "value of DIM argument in %s unknown at compile time", routine_name);
/* line 487 "SemIntr.puma" */
   warning_protocol (msg);
  }
   return;

;
}

static tTree MakeOmittedDim
# if defined __STDC__ | defined __cplusplus
(register tTree dim)
# else
(dim)
 register tTree dim;
# endif
{
  if (dim->Kind == kNO_PARAM) {
/* line 498 "SemIntr.puma" */
   return ExpToVarParam (MakeConstant (1));

  }
/* line 503 "SemIntr.puma" */
   return dim;

}

static void CheckElementalIntrinsic
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tIdent name, register tTree params)
# else
(exp, name, params)
 register tTree exp;
 register tIdent name;
 register tTree params;
# endif
{
  if (equaltIdent (name, IsIdent ("INDEX"))) {
/* line 516 "SemIntr.puma" */
  {
/* line 518 "SemIntr.puma" */
   CheckIndexParams (params);
/* line 519 "SemIntr.puma" */
   CheckConformRanks (exp, params, 0);
  }
   return;

  }
/* line 522 "SemIntr.puma" */
  {
/* line 524 "SemIntr.puma" */
   CheckConformRanks (exp, params, 0);
  }
   return;

;
}

static void CheckMerge
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 535 "SemIntr.puma" */
  {
/* line 537 "SemIntr.puma" */
 if (MergeRank (TreeRank (params->BTP_LIST.Elem), TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem)) == -1)
       error_protocol ("sources in MERGE have different rank");
     if (MergeRank (TreeRank (params->BTP_LIST.Elem), TreeRank (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem)) == -1)
       error_protocol ("rank of mask in MERGE is not conform");
   
  }
   return;

  }
  }
  }
  }
/* line 544 "SemIntr.puma" */
  {
/* line 545 "SemIntr.puma" */
   error_protocol ("MERGE has not three Parameters");
  }
   return;

;
}

static void CheckPack
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 556 "SemIntr.puma" */
  {
/* line 558 "SemIntr.puma" */
 
   
  }
   return;

  }
  }
  }
  }
/* line 562 "SemIntr.puma" */
  {
/* line 563 "SemIntr.puma" */
   error_protocol ("PACK has not three Parameters");
  }
   return;

;
}

static void CheckUnpack
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 574 "SemIntr.puma" */
  {
/* line 576 "SemIntr.puma" */
 
   
  }
   return;

  }
  }
  }
  }
/* line 580 "SemIntr.puma" */
  {
/* line 581 "SemIntr.puma" */
   error_protocol ("UNPACK has not three Parameters");
  }
   return;

;
}

static void CheckReshape
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 592 "SemIntr.puma" */
  {
/* line 595 "SemIntr.puma" */
 
   
  }
   return;

  }
  }
  }
  }
  }
/* line 599 "SemIntr.puma" */
  {
/* line 600 "SemIntr.puma" */
   error_protocol ("RESHAPE has not three Parameters");
  }
   return;

;
}

static void CheckCShift
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 610 "SemIntr.puma" */
  {
/* line 612 "SemIntr.puma" */
   NoScalarArgument (IsIdent ("CSHIFT"), IsIdent ("ARRAY"), params->BTP_LIST.Elem);
/* line 616 "SemIntr.puma" */
 params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = MakeOmittedDim (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem); 
/* line 618 "SemIntr.puma" */
   LegalDimArgument (IsIdent ("CSHIFT"), IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
/* line 622 "SemIntr.puma" */
 if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) == 0)
        {  }
       else if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) != TreeRank (params->BTP_LIST.Elem) - 1)
        error_protocol ("shift-rank must have rank array-rank - 1");
   
  }
   return;

  }
  }
  }
  }
/* line 629 "SemIntr.puma" */
  {
/* line 630 "SemIntr.puma" */
   error_protocol ("CSHIFT has illegal parameter list");
  }
   return;

;
}

static void CheckSpread
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 641 "SemIntr.puma" */
   return;

  }
  }
  }
  }
/* line 647 "SemIntr.puma" */
  {
/* line 648 "SemIntr.puma" */
   error_protocol ("SPREAD has not three parameters");
  }
   return;

;
}

static void CheckEOShift
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 659 "SemIntr.puma" */
  {
/* line 662 "SemIntr.puma" */
   NoScalarArgument (IsIdent ("EOSHIFT"), IsIdent ("ARRAY"), params->BTP_LIST.Elem);
/* line 666 "SemIntr.puma" */
 params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = MakeOmittedDim (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem); 
/* line 668 "SemIntr.puma" */
   LegalDimArgument (IsIdent ("EOSHIFT"), IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
/* line 670 "SemIntr.puma" */
 if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) == 0)
        {  }
       else if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) != TreeRank (params->BTP_LIST.Elem) - 1)
        error_protocol ("shift-rank must have rank array-rank - 1");

     
 
     params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = GetBoundary (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, params->BTP_LIST.Elem); 
   
  }
   return;

  }
  }
  }
  }
  }
;
}

static void CheckSort
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 690 "SemIntr.puma" */
  {
/* line 692 "SemIntr.puma" */
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
/* line 693 "SemIntr.puma" */
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
/* line 696 "SemIntr.puma" */
  {
/* line 698 "SemIntr.puma" */
   error_protocol ("illegal argument list in GRADE/SORT_DOWN/UP");
  }
   return;

;
}

static void CheckMatMul
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 709 "SemIntr.puma" */
 {
  int rank_a;
  int rank_b;
  {
/* line 714 "SemIntr.puma" */
   rank_a = TreeRank (params->BTP_LIST.Elem);
/* line 715 "SemIntr.puma" */
   rank_b = TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem);
/* line 717 "SemIntr.puma" */
 if ((rank_a < 1) || (rank_a > 2))
       error_protocol ("MATRIX_A in MATMUL must have rank one or two");
     if ((rank_b < 1) || (rank_b > 2))
       error_protocol ("MATRIX_B in MATMUL must have rank one or two");
     if ((rank_a == 1) && (rank_b == 1))
       error_protocol ("MATRIX_A or MATRIX_B in MATMUL must have rank two");
   
  }
   return;
 }

  }
  }
  }
;
}

static void CheckDotProd
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 734 "SemIntr.puma" */
  {
/* line 736 "SemIntr.puma" */
 if (TreeRank (params->BTP_LIST.Elem) != 1)
       error_protocol ("VECTOR_A in DOT_PRODUCT must have rank one");
     if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) != 1)
       error_protocol ("VECTOR_B in DOT_PRODUCT must have rank one");

     
   
  }
   return;

  }
  }
  }
;
}

static tTree GetBoundary
# if defined __STDC__ | defined __cplusplus
(register tTree boundary, register tTree array)
# else
(boundary, array)
 register tTree boundary;
 register tTree array;
# endif
{
  if (boundary->Kind == kNO_PARAM) {
  if (array->Kind == kVAR_PARAM) {
/* line 753 "SemIntr.puma" */
   return ExpToVarParam (GetTypeZero (array->VAR_PARAM.V));

  }
  }
/* line 758 "SemIntr.puma" */
   return boundary;

}

static void CheckTranspose
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 770 "SemIntr.puma" */
  {
/* line 772 "SemIntr.puma" */
 if (TreeRank (params->BTP_LIST.Elem) != 2)
       error_protocol ("Array in transpose must be two-dimensional");
   
  }
   return;

  }
  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 777 "SemIntr.puma" */
   return;

  }
  }
  }
/* line 780 "SemIntr.puma" */
  {
/* line 782 "SemIntr.puma" */
   error_protocol ("illegal arguments for TRANSPOSE");
  }
   return;

;
}

static void CheckRed
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 796 "SemIntr.puma" */
  {
/* line 798 "SemIntr.puma" */
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
/* line 799 "SemIntr.puma" */
   Conformable (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, IsIdent ("MASK"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
/* line 800 "SemIntr.puma" */
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
  }
/* line 803 "SemIntr.puma" */
  {
/* line 805 "SemIntr.puma" */
   error_protocol ("reduction intrinsic has not three parameters");
  }
   return;

;
}

static void CheckLocRed
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
/* line 818 "SemIntr.puma" */
  {
/* line 820 "SemIntr.puma" */
   CheckRed (name, params);
  }
   return;

;
}

static void CheckScan
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 841 "SemIntr.puma" */
  {
/* line 845 "SemIntr.puma" */
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
/* line 846 "SemIntr.puma" */
   SameShape (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, IsIdent ("SEGMENT"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
/* line 847 "SemIntr.puma" */
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 852 "SemIntr.puma" */
  {
/* line 857 "SemIntr.puma" */
   NoScalarArgument (name, IsIdent ("MASK"), params->BTP_LIST.Elem);
/* line 858 "SemIntr.puma" */
   SameShape (name, IsIdent ("MASK"), params->BTP_LIST.Elem, IsIdent ("SEGMENT"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
/* line 859 "SemIntr.puma" */
   LegalDimArgument (name, IsIdent ("MASK"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 864 "SemIntr.puma" */
  {
/* line 870 "SemIntr.puma" */
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
/* line 871 "SemIntr.puma" */
   LegalDimArgument (name, IsIdent ("MASK"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
/* line 872 "SemIntr.puma" */
   SameShape (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, IsIdent ("SEGMENT"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
/* line 873 "SemIntr.puma" */
   Conformable (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, IsIdent ("MASK"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
  }
  }
  }
;
}

static void CheckScatter
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 884 "SemIntr.puma" */
  {
/* line 886 "SemIntr.puma" */
 if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) < 1)
     { error_protocol ("BASE in xxx_SCATTER must not be scalar");
       tree_protocol ("BASE argument is ", params->BTP_LIST.Next->BTP_LIST.Elem);
     }
  
  }
   return;

  }
  }
;
}

static void CheckSizeParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 901 "SemIntr.puma" */
  {
/* line 903 "SemIntr.puma" */
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
/* line 904 "SemIntr.puma" */
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
/* line 907 "SemIntr.puma" */
  {
/* line 909 "SemIntr.puma" */
   error_protocol ("illegal argument list for intrinsic SIZE");
  }
   return;

;
}

static void CheckBoundParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 914 "SemIntr.puma" */
  {
/* line 916 "SemIntr.puma" */
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
/* line 917 "SemIntr.puma" */
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
/* line 920 "SemIntr.puma" */
  {
/* line 922 "SemIntr.puma" */
   error_protocol ("illegal argument list for intrinsic LBOUND/UBOUND");
  }
   return;

;
}

static void CheckIndexParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 927 "SemIntr.puma" */
 {
  tTree f_val;
  {
/* line 931 "SemIntr.puma" */
 f_val = mCONST_EXP (mBOOL_CONSTANT (0));
    params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = ExpToVarParam (f_val);
  
  }
   return;
 }

  }
  }
  }
  }
  }
;
}

static void CheckPresentParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 944 "SemIntr.puma" */
  {
/* line 949 "SemIntr.puma" */
   if (! ((IsVarDummy (params->BTP_LIST.Elem->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL1;
  }
   return;
yyL1:;

  }
  }
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 952 "SemIntr.puma" */
  {
/* line 954 "SemIntr.puma" */
   error_protocol ("argument of present must be a dummy argument");
  }
   return;

  }
  }
  }
/* line 957 "SemIntr.puma" */
  {
/* line 958 "SemIntr.puma" */
   error_protocol ("illegal parameter list for present");
  }
   return;

;
}

static void CheckConformRanks
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree params, register int rank)
# else
(call, params, rank)
 register tTree call;
 register tTree params;
 register int rank;
# endif
{
 yyRecursion:
  if (params->Kind == kBTP_LIST) {
/* line 971 "SemIntr.puma" */
 {
  int rank1;
  int prank;
  {
/* line 976 "SemIntr.puma" */
   rank1 = TreeRank (params->BTP_LIST.Elem);
/* line 977 "SemIntr.puma" */
   prank = rank;
/* line 979 "SemIntr.puma" */
 prank = rank;

     if (rank1 < 0)

        {  }

      else if (rank1 == 0)

        {   }

      else if (rank == 0)

        { prank = rank1;     }

      else if (rank1 != rank)

        { error_protocol ("rank mismatch in elemental call");
          tree_protocol ("call is : ", call);
          tree_protocol ("illegal rank for ", params->BTP_LIST.Elem);
        }
   
/* line 1001 "SemIntr.puma" */
   params = params->BTP_LIST.Next;
   rank = prank;
   goto yyRecursion;
  }
 }

  }
;
}

void SetIntrinsicInfo
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int base_rank, routine set_parameter)
# else
(name, base_rank, set_parameter)
 register tIdent name;
 register int base_rank;
 routine set_parameter;
# endif
{
  if (equaltIdent (name, IsIdent ("ABS"))) {
/* line 1018 "SemIntr.puma" */
  {
/* line 1020 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ACHAR"))) {
/* line 1023 "SemIntr.puma" */
  {
/* line 1025 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ACOS"))) {
/* line 1028 "SemIntr.puma" */
  {
/* line 1030 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_NUM_PROCS"))) {
/* line 1033 "SemIntr.puma" */
  {
/* line 1035 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_PROCS_SHAPE"))) {
/* line 1038 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("ADJUSTL"))) {
/* line 1041 "SemIntr.puma" */
  {
/* line 1043 "SemIntr.puma" */
   set_parameter ("STRING", rtrue, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ADJUSTR"))) {
/* line 1046 "SemIntr.puma" */
  {
/* line 1048 "SemIntr.puma" */
   set_parameter ("STRING", rtrue, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("AIMAG"))) {
/* line 1051 "SemIntr.puma" */
  {
/* line 1053 "SemIntr.puma" */
   set_parameter ("Z", rtrue, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("AINT"))) {
/* line 1063 "SemIntr.puma" */
  {
/* line 1065 "SemIntr.puma" */
   if (! (((name == IsIdent ("AINT")) || (name == IsIdent ("ANINT"))))) goto yyL9;
  {
/* line 1067 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, NumExpr, - 1);
/* line 1068 "SemIntr.puma" */
   set_parameter ("KIND", rfalse, IntentIn, InitIntExpr, 0);
  }
  }
   return;
yyL9:;

  }
  if (equaltIdent (name, IsIdent ("ALL"))) {
/* line 1071 "SemIntr.puma" */
  {
/* line 1073 "SemIntr.puma" */
   set_parameter ("MASK", rtrue, IntentIn, LogicalExpr, - 1);
/* line 1074 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ALLOCATED"))) {
/* line 1077 "SemIntr.puma" */
  {
/* line 1079 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, AllocateObject, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ALOG"))) {
/* line 1082 "SemIntr.puma" */
  {
/* line 1084 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ALOG10"))) {
/* line 1087 "SemIntr.puma" */
  {
/* line 1089 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
/* line 1092 "SemIntr.puma" */
  {
/* line 1094 "SemIntr.puma" */
   if (! (((name == IsIdent ("AMAX0")) || (name == IsIdent ("AMAX1")) || (name == IsIdent ("DMAX1")) || (name == IsIdent ("DMIN1")) || (name == IsIdent ("AMIN0")) || (name == IsIdent ("AMIN1"))))) goto yyL14;
  {
/* line 1098 "SemIntr.puma" */
   SetMinMaxParams (base_rank, set_parameter, NumExpr);
  }
  }
   return;
yyL14:;

  if (equaltIdent (name, IsIdent ("AMOD"))) {
/* line 1101 "SemIntr.puma" */
  {
/* line 1103 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, RealExpr, - 1);
/* line 1104 "SemIntr.puma" */
   set_parameter ("P", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ANINT"))) {
/* line 1114 "SemIntr.puma" */
  {
/* line 1116 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, NumExpr, - 1);
/* line 1117 "SemIntr.puma" */
   set_parameter ("KIND", rfalse, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ANY"))) {
/* line 1120 "SemIntr.puma" */
  {
/* line 1122 "SemIntr.puma" */
   set_parameter ("MASK", rtrue, IntentIn, LogicalExpr, - 1);
/* line 1123 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ASIN"))) {
/* line 1126 "SemIntr.puma" */
  {
/* line 1128 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ASSOCIATED"))) {
/* line 1131 "SemIntr.puma" */
  {
/* line 1133 "SemIntr.puma" */
   set_parameter ("POINTER", rtrue, IntentIn, PointerObject, - 1);
/* line 1134 "SemIntr.puma" */
   set_parameter ("TARGET", rfalse, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ATAN"))) {
/* line 1137 "SemIntr.puma" */
  {
/* line 1139 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ATAN2"))) {
/* line 1142 "SemIntr.puma" */
  {
/* line 1144 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
/* line 1145 "SemIntr.puma" */
   set_parameter ("Y", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("BIT_SIZE"))) {
/* line 1148 "SemIntr.puma" */
  {
/* line 1150 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("BTEST"))) {
/* line 1153 "SemIntr.puma" */
  {
/* line 1155 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
/* line 1156 "SemIntr.puma" */
   set_parameter ("POS", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CABS"))) {
/* line 1159 "SemIntr.puma" */
  {
/* line 1161 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CCOS"))) {
/* line 1164 "SemIntr.puma" */
  {
/* line 1166 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CEILING"))) {
/* line 1169 "SemIntr.puma" */
  {
/* line 1171 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CEXP"))) {
/* line 1174 "SemIntr.puma" */
  {
/* line 1176 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CHAR"))) {
/* line 1179 "SemIntr.puma" */
  {
/* line 1181 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, IntExpr, - 1);
/* line 1182 "SemIntr.puma" */
   set_parameter ("KIND", rfalse, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CLOG"))) {
/* line 1185 "SemIntr.puma" */
  {
/* line 1187 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CMPLX"))) {
/* line 1196 "SemIntr.puma" */
  {
/* line 1198 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
/* line 1199 "SemIntr.puma" */
   set_parameter ("Y", rtrue, IntentIn, NumExpr, - 1);
/* line 1200 "SemIntr.puma" */
   set_parameter ("KIND", rfalse, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CONJG"))) {
/* line 1203 "SemIntr.puma" */
  {
/* line 1205 "SemIntr.puma" */
   set_parameter ("Z", rtrue, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COS"))) {
/* line 1208 "SemIntr.puma" */
  {
/* line 1210 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COSH"))) {
/* line 1213 "SemIntr.puma" */
  {
/* line 1215 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COUNT"))) {
/* line 1218 "SemIntr.puma" */
  {
/* line 1220 "SemIntr.puma" */
   set_parameter ("MASK", rtrue, IntentIn, LogicalExpr, - 1);
/* line 1221 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CPU_TIME"))) {
/* line 1230 "SemIntr.puma" */
  {
/* line 1232 "SemIntr.puma" */
   set_parameter ("TIME", rtrue, IntentOut, RealExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CSHIFT"))) {
/* line 1242 "SemIntr.puma" */
  {
/* line 1244 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, Expr, - 1);
/* line 1245 "SemIntr.puma" */
   set_parameter ("SHIFT", rtrue, IntentIn, IntExpr, - 1);
/* line 1246 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CSIN"))) {
/* line 1249 "SemIntr.puma" */
  {
/* line 1251 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CSQRT"))) {
/* line 1254 "SemIntr.puma" */
  {
/* line 1256 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DABS"))) {
/* line 1259 "SemIntr.puma" */
  {
/* line 1261 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DACOS"))) {
/* line 1264 "SemIntr.puma" */
  {
/* line 1266 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DASIN"))) {
/* line 1269 "SemIntr.puma" */
  {
/* line 1271 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DATAN"))) {
/* line 1274 "SemIntr.puma" */
  {
/* line 1276 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DATAN2"))) {
/* line 1279 "SemIntr.puma" */
  {
/* line 1281 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
/* line 1282 "SemIntr.puma" */
   set_parameter ("Y", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DATE_AND_TIME"))) {
/* line 1291 "SemIntr.puma" */
  {
/* line 1293 "SemIntr.puma" */
   set_parameter ("DATE", rfalse, IntentOut, StringExpr, 0);
/* line 1294 "SemIntr.puma" */
   set_parameter ("TIME", rfalse, IntentOut, StringExpr, 0);
/* line 1295 "SemIntr.puma" */
   set_parameter ("ZONE", rfalse, IntentOut, StringExpr, 0);
/* line 1296 "SemIntr.puma" */
   set_parameter ("VALUES", rfalse, IntentOut, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DBLE"))) {
/* line 1299 "SemIntr.puma" */
  {
/* line 1301 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DCOS"))) {
/* line 1304 "SemIntr.puma" */
  {
/* line 1306 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DCOSH"))) {
/* line 1309 "SemIntr.puma" */
  {
/* line 1311 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DDIM"))) {
/* line 1314 "SemIntr.puma" */
  {
/* line 1316 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
/* line 1317 "SemIntr.puma" */
   set_parameter ("Y", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DEXP"))) {
/* line 1320 "SemIntr.puma" */
  {
/* line 1322 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DIGITS"))) {
/* line 1325 "SemIntr.puma" */
  {
/* line 1327 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DIM"))) {
/* line 1330 "SemIntr.puma" */
  {
/* line 1332 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
/* line 1333 "SemIntr.puma" */
   set_parameter ("Y", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DINT"))) {
/* line 1336 "SemIntr.puma" */
  {
/* line 1338 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DLOG"))) {
/* line 1341 "SemIntr.puma" */
  {
/* line 1343 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DLOG10"))) {
/* line 1346 "SemIntr.puma" */
  {
/* line 1348 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DMOD"))) {
/* line 1351 "SemIntr.puma" */
  {
/* line 1353 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, DoubleRealExpr, - 1);
/* line 1354 "SemIntr.puma" */
   set_parameter ("P", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DNINT"))) {
/* line 1357 "SemIntr.puma" */
  {
/* line 1359 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DOT_PRODUCT"))) {
/* line 1370 "SemIntr.puma" */
  {
/* line 1372 "SemIntr.puma" */
   set_parameter ("VECTOR_A", rtrue, IntentIn, Expr, 1);
/* line 1373 "SemIntr.puma" */
   set_parameter ("VECTOR_B", rtrue, IntentIn, Expr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DPROD"))) {
/* line 1376 "SemIntr.puma" */
  {
/* line 1378 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
/* line 1379 "SemIntr.puma" */
   set_parameter ("Y", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DSIGN"))) {
/* line 1382 "SemIntr.puma" */
  {
/* line 1384 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, DoubleRealExpr, - 1);
/* line 1385 "SemIntr.puma" */
   set_parameter ("B", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DSIN"))) {
/* line 1388 "SemIntr.puma" */
  {
/* line 1390 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DSINH"))) {
/* line 1393 "SemIntr.puma" */
  {
/* line 1395 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DSQRT"))) {
/* line 1398 "SemIntr.puma" */
  {
/* line 1400 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DTAN"))) {
/* line 1403 "SemIntr.puma" */
  {
/* line 1405 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DTANH"))) {
/* line 1408 "SemIntr.puma" */
  {
/* line 1410 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EOSHIFT"))) {
/* line 1420 "SemIntr.puma" */
  {
/* line 1422 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, Expr, - 1);
/* line 1423 "SemIntr.puma" */
   set_parameter ("SHIFT", rtrue, IntentIn, IntExpr, 0);
/* line 1424 "SemIntr.puma" */
   set_parameter ("BOUNDARY", rfalse, IntentIn, Expr, 0);
/* line 1425 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EPSILON"))) {
/* line 1428 "SemIntr.puma" */
  {
/* line 1430 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EXP"))) {
/* line 1433 "SemIntr.puma" */
  {
/* line 1435 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EXPONENT"))) {
/* line 1438 "SemIntr.puma" */
  {
/* line 1440 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("FLOAT"))) {
/* line 1443 "SemIntr.puma" */
  {
/* line 1445 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("FLOOR"))) {
/* line 1448 "SemIntr.puma" */
  {
/* line 1450 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("FRACTION"))) {
/* line 1453 "SemIntr.puma" */
  {
/* line 1455 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
/* line 1465 "SemIntr.puma" */
  {
/* line 1467 "SemIntr.puma" */
   if (! (((name == IsIdent ("GRADE_DOWN")) || (name == IsIdent ("GRADE_UP"))))) goto yyL72;
  {
/* line 1469 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, SortExpr, - 1);
/* line 1470 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL72:;

/* line 1480 "SemIntr.puma" */
  {
/* line 1482 "SemIntr.puma" */
   if (! (((name == IsIdent ("SORT_DOWN")) || (name == IsIdent ("SORT_UP"))))) goto yyL73;
  {
/* line 1484 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, SortExpr, - 1);
/* line 1485 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL73:;

  if (equaltIdent (name, IsIdent ("HUGE"))) {
/* line 1494 "SemIntr.puma" */
  {
/* line 1496 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IABS"))) {
/* line 1499 "SemIntr.puma" */
  {
/* line 1501 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IACHAR"))) {
/* line 1504 "SemIntr.puma" */
  {
/* line 1506 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IALL"))) {
/* line 1509 "SemIntr.puma" */
  {
/* line 1511 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IANY"))) {
/* line 1514 "SemIntr.puma" */
  {
/* line 1516 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IAND"))) {
/* line 1519 "SemIntr.puma" */
  {
/* line 1521 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
/* line 1522 "SemIntr.puma" */
   set_parameter ("J", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IBCLR"))) {
/* line 1525 "SemIntr.puma" */
  {
/* line 1527 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
/* line 1528 "SemIntr.puma" */
   set_parameter ("POS", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IBITS"))) {
/* line 1531 "SemIntr.puma" */
  {
/* line 1533 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
/* line 1534 "SemIntr.puma" */
   set_parameter ("POS", rtrue, IntentIn, IntExpr, - 1);
/* line 1535 "SemIntr.puma" */
   set_parameter ("LEN", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IBSET"))) {
/* line 1538 "SemIntr.puma" */
  {
/* line 1540 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
/* line 1541 "SemIntr.puma" */
   set_parameter ("POS", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ICHAR"))) {
/* line 1544 "SemIntr.puma" */
  {
/* line 1546 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IDIM"))) {
/* line 1549 "SemIntr.puma" */
  {
/* line 1551 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, IntExpr, - 1);
/* line 1552 "SemIntr.puma" */
   set_parameter ("Y", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IDINT"))) {
/* line 1555 "SemIntr.puma" */
  {
/* line 1557 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IDNINT"))) {
/* line 1560 "SemIntr.puma" */
  {
/* line 1562 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IEOR"))) {
/* line 1565 "SemIntr.puma" */
  {
/* line 1567 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
/* line 1568 "SemIntr.puma" */
   set_parameter ("J", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IFIX"))) {
/* line 1571 "SemIntr.puma" */
  {
/* line 1573 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ILEN"))) {
/* line 1576 "SemIntr.puma" */
  {
/* line 1578 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("INDEX"))) {
/* line 1581 "SemIntr.puma" */
  {
/* line 1583 "SemIntr.puma" */
   set_parameter ("STRING", rtrue, IntentIn, StringExpr, - 1);
/* line 1584 "SemIntr.puma" */
   set_parameter ("SUBSTRING", rtrue, IntentIn, StringExpr, - 1);
/* line 1585 "SemIntr.puma" */
   set_parameter ("BACK", rfalse, IntentIn, LogicalExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("INT"))) {
/* line 1595 "SemIntr.puma" */
  {
/* line 1597 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, NumExpr, - 1);
/* line 1598 "SemIntr.puma" */
   set_parameter ("KIND", rfalse, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IOR"))) {
/* line 1601 "SemIntr.puma" */
  {
/* line 1603 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
/* line 1604 "SemIntr.puma" */
   set_parameter ("J", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IPARITY"))) {
/* line 1607 "SemIntr.puma" */
  {
/* line 1609 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ISHFT"))) {
/* line 1612 "SemIntr.puma" */
  {
/* line 1614 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
/* line 1615 "SemIntr.puma" */
   set_parameter ("SHIFT", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ISHFTC"))) {
/* line 1618 "SemIntr.puma" */
  {
/* line 1620 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
/* line 1621 "SemIntr.puma" */
   set_parameter ("SHIFT", rtrue, IntentIn, IntExpr, - 1);
/* line 1622 "SemIntr.puma" */
   set_parameter ("SSIZE", rfalse, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ISIGN"))) {
/* line 1625 "SemIntr.puma" */
  {
/* line 1627 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, IntExpr, - 1);
/* line 1628 "SemIntr.puma" */
   set_parameter ("B", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("KIND"))) {
/* line 1631 "SemIntr.puma" */
  {
/* line 1633 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LBOUND"))) {
/* line 1636 "SemIntr.puma" */
  {
/* line 1638 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, ArrayExpr, - 1);
/* line 1639 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LEADZ"))) {
/* line 1642 "SemIntr.puma" */
  {
/* line 1644 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LEN"))) {
/* line 1647 "SemIntr.puma" */
  {
/* line 1649 "SemIntr.puma" */
   set_parameter ("STRING", rtrue, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LEN_TRIM"))) {
/* line 1652 "SemIntr.puma" */
  {
/* line 1654 "SemIntr.puma" */
   set_parameter ("STRING", rtrue, IntentIn, StringExpr, - 1);
  }
   return;

  }
/* line 1666 "SemIntr.puma" */
  {
/* line 1668 "SemIntr.puma" */
   if (! (((name == IsIdent ("LGE")) || (name == IsIdent ("LGT")) || (name == IsIdent ("LLE")) || (name == IsIdent ("LLT"))))) goto yyL102;
  {
/* line 1671 "SemIntr.puma" */
   set_parameter ("STRING_A", rtrue, IntentIn, StringExpr, - 1);
/* line 1672 "SemIntr.puma" */
   set_parameter ("STRING_B", rtrue, IntentIn, StringExpr, - 1);
  }
  }
   return;
yyL102:;

  if (equaltIdent (name, IsIdent ("LOG"))) {
/* line 1675 "SemIntr.puma" */
  {
/* line 1677 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LOGICAL"))) {
/* line 1680 "SemIntr.puma" */
  {
/* line 1682 "SemIntr.puma" */
   set_parameter ("L", rtrue, IntentIn, NumExpr, - 1);
/* line 1683 "SemIntr.puma" */
   set_parameter ("KIND", rfalse, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LOG10"))) {
/* line 1686 "SemIntr.puma" */
  {
/* line 1688 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MATMUL"))) {
/* line 1697 "SemIntr.puma" */
  {
/* line 1699 "SemIntr.puma" */
   set_parameter ("MATRIX_A", rtrue, IntentIn, Expr, - 1);
/* line 1700 "SemIntr.puma" */
   set_parameter ("MATRIX_B", rtrue, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAX"))) {
/* line 1703 "SemIntr.puma" */
  {
/* line 1705 "SemIntr.puma" */
   SetMinMaxParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAXEXPONENT"))) {
/* line 1708 "SemIntr.puma" */
  {
/* line 1710 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAXLOC"))) {
/* line 1713 "SemIntr.puma" */
  {
/* line 1715 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAXVAL"))) {
/* line 1718 "SemIntr.puma" */
  {
/* line 1720 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAX0"))) {
/* line 1723 "SemIntr.puma" */
  {
/* line 1725 "SemIntr.puma" */
   SetMinMaxParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAX1"))) {
/* line 1728 "SemIntr.puma" */
  {
/* line 1730 "SemIntr.puma" */
   SetMinMaxParams (base_rank, set_parameter, NormalRealExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MERGE"))) {
/* line 1739 "SemIntr.puma" */
  {
/* line 1741 "SemIntr.puma" */
   set_parameter ("TSOURCE", rtrue, IntentIn, Expr, - 1);
/* line 1742 "SemIntr.puma" */
   set_parameter ("FSOURCE", rtrue, IntentIn, Expr, - 1);
/* line 1743 "SemIntr.puma" */
   set_parameter ("MASK", rtrue, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MIN"))) {
/* line 1746 "SemIntr.puma" */
  {
/* line 1748 "SemIntr.puma" */
   SetMinMaxParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MINEXPONENT"))) {
/* line 1751 "SemIntr.puma" */
  {
/* line 1753 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MINLOC"))) {
/* line 1756 "SemIntr.puma" */
  {
/* line 1758 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MINVAL"))) {
/* line 1761 "SemIntr.puma" */
  {
/* line 1763 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MIN0"))) {
/* line 1766 "SemIntr.puma" */
  {
/* line 1768 "SemIntr.puma" */
   SetMinMaxParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MIN1"))) {
/* line 1771 "SemIntr.puma" */
  {
/* line 1773 "SemIntr.puma" */
   SetMinMaxParams (base_rank, set_parameter, NormalRealExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MOD"))) {
/* line 1776 "SemIntr.puma" */
  {
/* line 1778 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, NumExpr, - 1);
/* line 1779 "SemIntr.puma" */
   set_parameter ("P", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MODULO"))) {
/* line 1782 "SemIntr.puma" */
  {
/* line 1784 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, NumExpr, - 1);
/* line 1785 "SemIntr.puma" */
   set_parameter ("P", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MVBITS"))) {
/* line 1788 "SemIntr.puma" */
  {
/* line 1790 "SemIntr.puma" */
   set_parameter ("FROM", rtrue, IntentIn, IntExpr, - 1);
/* line 1791 "SemIntr.puma" */
   set_parameter ("FROMPOS", rtrue, IntentIn, IntExpr, - 1);
/* line 1792 "SemIntr.puma" */
   set_parameter ("LEN", rtrue, IntentIn, IntExpr, - 1);
/* line 1793 "SemIntr.puma" */
   set_parameter ("TO", rtrue, IntentInOut, IntExpr, - 1);
/* line 1794 "SemIntr.puma" */
   set_parameter ("TOPOS", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("NEAREST"))) {
/* line 1803 "SemIntr.puma" */
  {
/* line 1805 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
/* line 1806 "SemIntr.puma" */
   set_parameter ("S", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("NINT"))) {
/* line 1809 "SemIntr.puma" */
  {
/* line 1811 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, RealExpr, - 1);
/* line 1812 "SemIntr.puma" */
   set_parameter ("KIND", rfalse, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("NOT"))) {
/* line 1815 "SemIntr.puma" */
  {
/* line 1817 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("NUMBER_OF_PROCESSORS"))) {
/* line 1826 "SemIntr.puma" */
  {
/* line 1828 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PACK"))) {
/* line 1837 "SemIntr.puma" */
  {
/* line 1839 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, ArrayExpr, - 1);
/* line 1840 "SemIntr.puma" */
   set_parameter ("MASK", rtrue, IntentIn, LogicalExpr, - 1);
/* line 1841 "SemIntr.puma" */
   set_parameter ("VECTOR", rfalse, IntentIn, Expr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PARITY"))) {
/* line 1844 "SemIntr.puma" */
  {
/* line 1846 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, LogicalExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("POPCNT"))) {
/* line 1849 "SemIntr.puma" */
  {
/* line 1851 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("POPPAR"))) {
/* line 1854 "SemIntr.puma" */
  {
/* line 1856 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PRECISION"))) {
/* line 1859 "SemIntr.puma" */
  {
/* line 1861 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PRESENT"))) {
/* line 1864 "SemIntr.puma" */
  {
/* line 1866 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PROCESSORS_SHAPE"))) {
/* line 1869 "SemIntr.puma" */
   return;

  }
  if (equaltIdent (name, IsIdent ("PRODUCT"))) {
/* line 1872 "SemIntr.puma" */
  {
/* line 1874 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RADIX"))) {
/* line 1877 "SemIntr.puma" */
  {
/* line 1879 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_NUMBER"))) {
/* line 1882 "SemIntr.puma" */
  {
/* line 1884 "SemIntr.puma" */
   set_parameter ("HARVEST", rtrue, IntentOut, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_SEED"))) {
/* line 1887 "SemIntr.puma" */
  {
/* line 1889 "SemIntr.puma" */
   set_parameter ("SIZE", rfalse, IntentOut, Expr, - 1);
/* line 1890 "SemIntr.puma" */
   set_parameter ("PUT", rfalse, IntentOut, Expr, - 1);
/* line 1891 "SemIntr.puma" */
   set_parameter ("GET", rfalse, IntentOut, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RANGE"))) {
/* line 1894 "SemIntr.puma" */
  {
/* line 1896 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("REAL"))) {
/* line 1905 "SemIntr.puma" */
  {
/* line 1907 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, NumExpr, - 1);
/* line 1908 "SemIntr.puma" */
   set_parameter ("KIND", rfalse, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("REPEAT"))) {
/* line 1911 "SemIntr.puma" */
  {
/* line 1913 "SemIntr.puma" */
   set_parameter ("STRING", rtrue, IntentIn, StringExpr, 0);
/* line 1914 "SemIntr.puma" */
   set_parameter ("NCOPIES", rtrue, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
/* line 1923 "SemIntr.puma" */
  {
/* line 1925 "SemIntr.puma" */
   set_parameter ("SOURCE", rtrue, IntentIn, ArrayExpr, - 1);
/* line 1926 "SemIntr.puma" */
   set_parameter ("SHAPE", rtrue, IntentIn, IntExpr, 1);
/* line 1927 "SemIntr.puma" */
   set_parameter ("PAD", rfalse, IntentIn, Expr, - 1);
/* line 1928 "SemIntr.puma" */
   set_parameter ("ORDER", rfalse, IntentIn, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RRSPACING"))) {
/* line 1931 "SemIntr.puma" */
  {
/* line 1933 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SCALE"))) {
/* line 1936 "SemIntr.puma" */
  {
/* line 1938 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
/* line 1939 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SCAN"))) {
/* line 1942 "SemIntr.puma" */
  {
/* line 1944 "SemIntr.puma" */
   set_parameter ("STRING", rtrue, IntentIn, StringExpr, - 1);
/* line 1945 "SemIntr.puma" */
   set_parameter ("SET", rtrue, IntentIn, StringExpr, - 1);
/* line 1946 "SemIntr.puma" */
   set_parameter ("BACK", rfalse, IntentIn, LogicalExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_INT_KIND"))) {
/* line 1956 "SemIntr.puma" */
  {
/* line 1958 "SemIntr.puma" */
   set_parameter ("R", rtrue, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_REAL_KIND"))) {
/* line 1961 "SemIntr.puma" */
  {
/* line 1963 "SemIntr.puma" */
   set_parameter ("P", rfalse, IntentIn, IntExpr, 0);
/* line 1964 "SemIntr.puma" */
   set_parameter ("R", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SET_EXPONENT"))) {
/* line 1967 "SemIntr.puma" */
  {
/* line 1969 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
/* line 1970 "SemIntr.puma" */
   set_parameter ("I", rtrue, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
/* line 1973 "SemIntr.puma" */
  {
/* line 1975 "SemIntr.puma" */
   set_parameter ("SOURCE", rtrue, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SIGN"))) {
/* line 1978 "SemIntr.puma" */
  {
/* line 1980 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, NumExpr, - 1);
/* line 1981 "SemIntr.puma" */
   set_parameter ("B", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SIN"))) {
/* line 1984 "SemIntr.puma" */
  {
/* line 1986 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SINH"))) {
/* line 1989 "SemIntr.puma" */
  {
/* line 1991 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SIZE"))) {
/* line 1994 "SemIntr.puma" */
  {
/* line 1996 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, ArrayExpr, - 1);
/* line 1997 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SNGL"))) {
/* line 2000 "SemIntr.puma" */
  {
/* line 2002 "SemIntr.puma" */
   set_parameter ("A", rtrue, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SPACING"))) {
/* line 2005 "SemIntr.puma" */
  {
/* line 2007 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SPREAD"))) {
/* line 2016 "SemIntr.puma" */
  {
/* line 2018 "SemIntr.puma" */
   set_parameter ("SOURCE", rtrue, IntentIn, Expr, - 1);
/* line 2019 "SemIntr.puma" */
   set_parameter ("DIM", rtrue, IntentIn, IntExpr, 0);
/* line 2020 "SemIntr.puma" */
   set_parameter ("NCOPIES", rtrue, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SQRT"))) {
/* line 2023 "SemIntr.puma" */
  {
/* line 2025 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SUM"))) {
/* line 2028 "SemIntr.puma" */
  {
/* line 2030 "SemIntr.puma" */
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SYSTEM_CLOCK"))) {
/* line 2033 "SemIntr.puma" */
  {
/* line 2035 "SemIntr.puma" */
   set_parameter ("COUNT", rfalse, IntentOut, IntExpr, 0);
/* line 2036 "SemIntr.puma" */
   set_parameter ("COUNT_RATE", rfalse, IntentOut, IntExpr, 0);
/* line 2037 "SemIntr.puma" */
   set_parameter ("COUNT_MAX", rfalse, IntentOut, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TAN"))) {
/* line 2040 "SemIntr.puma" */
  {
/* line 2042 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TANH"))) {
/* line 2045 "SemIntr.puma" */
  {
/* line 2047 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TINY"))) {
/* line 2050 "SemIntr.puma" */
  {
/* line 2052 "SemIntr.puma" */
   set_parameter ("X", rtrue, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TRANSFER"))) {
/* line 2055 "SemIntr.puma" */
  {
/* line 2057 "SemIntr.puma" */
   set_parameter ("SOURCE", rtrue, IntentIn, Expr, - 1);
/* line 2058 "SemIntr.puma" */
   set_parameter ("MOLD", rtrue, IntentIn, Expr, - 1);
/* line 2059 "SemIntr.puma" */
   set_parameter ("SIZE", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TRANSPOSE"))) {
/* line 2070 "SemIntr.puma" */
  {
/* line 2072 "SemIntr.puma" */
   set_parameter ("MATRIX", rtrue, IntentIn, Expr, - 1);
/* line 2073 "SemIntr.puma" */
   set_parameter ("ORDER", rfalse, IntentIn, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TRIM", 4))) {
/* line 2082 "SemIntr.puma" */
  {
/* line 2084 "SemIntr.puma" */
   set_parameter ("STRING", rtrue, IntentIn, StringExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("UBOUND"))) {
/* line 2087 "SemIntr.puma" */
  {
/* line 2089 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, ArrayExpr, - 1);
/* line 2090 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
/* line 2099 "SemIntr.puma" */
  {
/* line 2101 "SemIntr.puma" */
   set_parameter ("VECTOR", rtrue, IntentIn, Expr, 1);
/* line 2102 "SemIntr.puma" */
   set_parameter ("MASK", rtrue, IntentIn, LogicalExpr, - 1);
/* line 2103 "SemIntr.puma" */
   set_parameter ("FIELD", rtrue, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("VERIFY"))) {
/* line 2112 "SemIntr.puma" */
  {
/* line 2114 "SemIntr.puma" */
   set_parameter ("STRING", rtrue, IntentIn, StringExpr, - 1);
/* line 2115 "SemIntr.puma" */
   set_parameter ("SET", rtrue, IntentIn, StringExpr, - 1);
/* line 2116 "SemIntr.puma" */
   set_parameter ("BACK", rfalse, IntentIn, LogicalExpr, 0);
  }
   return;

  }
/* line 2125 "SemIntr.puma" */
  {
/* line 2127 "SemIntr.puma" */
   if (! ((IntrFuncScan (name)))) goto yyL168;
  {
/* line 2128 "SemIntr.puma" */
   SetScanParams (name, set_parameter);
  }
  }
   return;
yyL168:;

  if (equaltIdent (name, IsIdent ("ALL_SCATTER"))) {
/* line 2137 "SemIntr.puma" */
  {
/* line 2139 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, LogicalExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ANY_SCATTER"))) {
/* line 2142 "SemIntr.puma" */
  {
/* line 2144 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, LogicalExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COPY_SCATTER"))) {
/* line 2146 "SemIntr.puma" */
  {
/* line 2148 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COUNT_SCATTER"))) {
/* line 2151 "SemIntr.puma" */
  {
/* line 2153 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IALL_SCATTER"))) {
/* line 2156 "SemIntr.puma" */
  {
/* line 2158 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IANY_SCATTER"))) {
/* line 2161 "SemIntr.puma" */
  {
/* line 2163 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IPARITY_SCATTER"))) {
/* line 2166 "SemIntr.puma" */
  {
/* line 2168 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAXVAL_SCATTER"))) {
/* line 2171 "SemIntr.puma" */
  {
/* line 2173 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MINVAL_SCATTER"))) {
/* line 2176 "SemIntr.puma" */
  {
/* line 2178 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PARITY_SCATTER"))) {
/* line 2181 "SemIntr.puma" */
  {
/* line 2183 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PRODUCT_SCATTER"))) {
/* line 2186 "SemIntr.puma" */
  {
/* line 2188 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SUM_SCATTER"))) {
/* line 2191 "SemIntr.puma" */
  {
/* line 2193 "SemIntr.puma" */
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
/* line 2206 "SemIntr.puma" */
  {
/* line 2208 "SemIntr.puma" */
   if (! (((name == IsIdent ("HPF_ALIGNMENT")) || (name == IsIdent ("GLOBAL_ALIGNMENT"))))) goto yyL181;
  {
/* line 2211 "SemIntr.puma" */
   set_parameter ("ALIGNEE", rtrue, IntentIn, Expr, - 1);
/* line 2212 "SemIntr.puma" */
   set_parameter ("LB", rfalse, IntentOut, IntExpr, 1);
/* line 2213 "SemIntr.puma" */
   set_parameter ("UB", rfalse, IntentOut, IntExpr, 1);
/* line 2214 "SemIntr.puma" */
   set_parameter ("STRIDE", rfalse, IntentOut, IntExpr, 1);
/* line 2215 "SemIntr.puma" */
   set_parameter ("AXIS_MAP", rfalse, IntentOut, IntExpr, 1);
/* line 2216 "SemIntr.puma" */
   set_parameter ("IDENTITY_MAP", rfalse, IntentOut, LogicalExpr, 0);
/* line 2217 "SemIntr.puma" */
   set_parameter ("DYNAMIC", rfalse, IntentOut, LogicalExpr, 0);
/* line 2218 "SemIntr.puma" */
   set_parameter ("NCOPIES", rfalse, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL181:;

/* line 2221 "SemIntr.puma" */
  {
/* line 2223 "SemIntr.puma" */
   if (! (((name == IsIdent ("HPF_DISTRIBUTION")) || (name == IsIdent ("GLOBAL_DISTRIBUTION"))))) goto yyL182;
  {
/* line 2226 "SemIntr.puma" */
   set_parameter ("DISTRIBUTEE", rtrue, IntentIn, Expr, - 1);
/* line 2227 "SemIntr.puma" */
   set_parameter ("AXIS_TYPE", rfalse, IntentOut, StringExpr, 1);
/* line 2228 "SemIntr.puma" */
   set_parameter ("AXIS_INFO", rfalse, IntentOut, IntExpr, 1);
/* line 2229 "SemIntr.puma" */
   set_parameter ("PROCESSORS_RANK", rfalse, IntentOut, IntExpr, 0);
/* line 2230 "SemIntr.puma" */
   set_parameter ("PROCESSORS_SHAPE", rfalse, IntentOut, IntExpr, 1);
/* line 2231 "SemIntr.puma" */
   set_parameter ("PLB", rfalse, IntentOut, IntExpr, 1);
/* line 2232 "SemIntr.puma" */
   set_parameter ("PUB", rfalse, IntentOut, IntExpr, 1);
/* line 2233 "SemIntr.puma" */
   set_parameter ("PSTRIDE", rfalse, IntentOut, IntExpr, 1);
/* line 2234 "SemIntr.puma" */
   set_parameter ("LOW_SHADOW", rfalse, IntentOut, IntExpr, 1);
/* line 2235 "SemIntr.puma" */
   set_parameter ("HIGH_SHADOW", rfalse, IntentOut, IntExpr, 1);
  }
  }
   return;
yyL182:;

/* line 2238 "SemIntr.puma" */
  {
/* line 2240 "SemIntr.puma" */
   if (! (((name == IsIdent ("HPF_TEMPLATE")) || (name == IsIdent ("GLOBAL_TEMPLATE"))))) goto yyL183;
  {
/* line 2243 "SemIntr.puma" */
   set_parameter ("ALIGNEE", rtrue, IntentIn, Expr, - 1);
/* line 2244 "SemIntr.puma" */
   set_parameter ("TEMPLATE_RANK", rfalse, IntentOut, IntExpr, 0);
/* line 2245 "SemIntr.puma" */
   set_parameter ("LB", rfalse, IntentOut, IntExpr, 1);
/* line 2246 "SemIntr.puma" */
   set_parameter ("UB", rfalse, IntentOut, IntExpr, 1);
/* line 2247 "SemIntr.puma" */
   set_parameter ("AXIS_TYPE", rfalse, IntentOut, StringExpr, 1);
/* line 2248 "SemIntr.puma" */
   set_parameter ("AXIS_INFO", rfalse, IntentOut, IntExpr, 1);
/* line 2249 "SemIntr.puma" */
   set_parameter ("NUMBER_ALIGNED", rfalse, IntentOut, IntExpr, 0);
/* line 2250 "SemIntr.puma" */
   set_parameter ("DYNAMIC", rfalse, IntentOut, LogicalExpr, 0);
  }
  }
   return;
yyL183:;

/* line 2259 "SemIntr.puma" */
  {
/* line 2261 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_MAP_ARRAY")))) goto yyL184;
  {
/* line 2263 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, Expr, - 1);
/* line 2264 "SemIntr.puma" */
   set_parameter ("TEMPLATE_DIM", rtrue, IntentIn, IntExpr, 0);
/* line 2265 "SemIntr.puma" */
   set_parameter ("MAP_ARAY", rtrue, IntentOut, IntExpr, 1);
  }
  }
   return;
yyL184:;

/* line 2274 "SemIntr.puma" */
  {
/* line 2276 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_NUMBER_MAPPED")))) goto yyL185;
  {
/* line 2278 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, Expr, - 1);
/* line 2279 "SemIntr.puma" */
   set_parameter ("PROCESSORS_DIM", rtrue, IntentIn, IntExpr, 0);
/* line 2280 "SemIntr.puma" */
   set_parameter ("NUMBER_MAPPED", rtrue, IntentOut, IntExpr, 1);
  }
  }
   return;
yyL185:;

/* line 2289 "SemIntr.puma" */
  {
/* line 2291 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_SUBGRID_INFO")))) goto yyL186;
  {
/* line 2293 "SemIntr.puma" */
   if (! ((base_rank == 0))) goto yyL186;
  {
/* line 2295 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, Expr, - 1);
/* line 2296 "SemIntr.puma" */
   set_parameter ("IERR", rfalse, IntentOut, IntExpr, 0);
/* line 2297 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
/* line 2298 "SemIntr.puma" */
   set_parameter ("LB", rfalse, IntentOut, IntExpr, - 1);
/* line 2299 "SemIntr.puma" */
   set_parameter ("UB", rfalse, IntentOut, IntExpr, - 1);
/* line 2300 "SemIntr.puma" */
   set_parameter ("STRIDE", rfalse, IntentOut, IntExpr, - 1);
/* line 2301 "SemIntr.puma" */
   set_parameter ("LB_EMBED", rfalse, IntentOut, IntExpr, - 1);
/* line 2302 "SemIntr.puma" */
   set_parameter ("UB_EMBED", rfalse, IntentOut, IntExpr, - 1);
/* line 2303 "SemIntr.puma" */
   set_parameter ("AXIS_MAP", rfalse, IntentOut, IntExpr, - 1);
  }
  }
  }
   return;
yyL186:;

/* line 2306 "SemIntr.puma" */
  {
/* line 2308 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_SUBGRID_INFO")))) goto yyL187;
  {
/* line 2310 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, Expr, - 1);
/* line 2311 "SemIntr.puma" */
   set_parameter ("IERR", rfalse, IntentOut, IntExpr, 0);
/* line 2312 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
/* line 2313 "SemIntr.puma" */
   set_parameter ("LB", rfalse, IntentOut, IntExpr, 1);
/* line 2314 "SemIntr.puma" */
   set_parameter ("UB", rfalse, IntentOut, IntExpr, 1);
/* line 2315 "SemIntr.puma" */
   set_parameter ("STRIDE", rfalse, IntentOut, IntExpr, 1);
  }
  }
   return;
yyL187:;

/* line 2324 "SemIntr.puma" */
  {
/* line 2326 "SemIntr.puma" */
   if (! ((name == IsIdent ("GLOBAL_SHAPE")))) goto yyL188;
  {
/* line 2328 "SemIntr.puma" */
   set_parameter ("SOURCE", rtrue, IntentIn, Expr, - 1);
  }
  }
   return;
yyL188:;

/* line 2337 "SemIntr.puma" */
  {
/* line 2339 "SemIntr.puma" */
   if (! ((name == IsIdent ("GLOBAL_SIZE")))) goto yyL189;
  {
/* line 2341 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, Expr, - 1);
/* line 2342 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL189:;

  if (equaltIdent (name, IsIdent ("ABSTRACT_TO_PHYSICAL"))) {
/* line 2352 "SemIntr.puma" */
  {
/* line 2354 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, DummyHPFArray, - 1);
/* line 2355 "SemIntr.puma" */
   set_parameter ("INDEX", rtrue, IntentIn, IntExpr, 1);
/* line 2356 "SemIntr.puma" */
   set_parameter ("PROC", rtrue, IntentOut, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PHYSICAL_TO_ABSTRACT"))) {
/* line 2359 "SemIntr.puma" */
  {
/* line 2361 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, DummyHPFArray, - 1);
/* line 2362 "SemIntr.puma" */
   set_parameter ("PROC", rtrue, IntentIn, IntExpr, 0);
/* line 2363 "SemIntr.puma" */
   set_parameter ("INDEX", rtrue, IntentOut, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_TO_GLOBAL"))) {
/* line 2373 "SemIntr.puma" */
  {
/* line 2375 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, DummyHPFArray, - 1);
/* line 2376 "SemIntr.puma" */
   set_parameter ("L_INDEX", rtrue, IntentIn, IntExpr, 1);
/* line 2377 "SemIntr.puma" */
   set_parameter ("G_INDEX", rtrue, IntentOut, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TO_LOCAL"))) {
/* line 2380 "SemIntr.puma" */
  {
/* line 2382 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, DummyHPFArray, - 1);
/* line 2383 "SemIntr.puma" */
   set_parameter ("G_INDEX", rtrue, IntentIn, IntExpr, 1);
/* line 2384 "SemIntr.puma" */
   set_parameter ("L_INDEX", rfalse, IntentOut, IntExpr, 1);
/* line 2385 "SemIntr.puma" */
   set_parameter ("LOCAL", rfalse, IntentOut, LogicalExpr, 0);
/* line 2386 "SemIntr.puma" */
   set_parameter ("NCOPIES", rfalse, IntentOut, IntExpr, 0);
/* line 2387 "SemIntr.puma" */
   set_parameter ("PROCS", rfalse, IntentOut, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MY_PROCESSOR"))) {
/* line 2396 "SemIntr.puma" */
   return;

  }
/* line 2407 "SemIntr.puma" */
  {
/* line 2409 "SemIntr.puma" */
   if (! ((name == IsIdent ("LOCAL_BLKCNT")))) goto yyL195;
  {
/* line 2411 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, DummyHPFArray, - 1);
/* line 2412 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
/* line 2413 "SemIntr.puma" */
   set_parameter ("PROC", rfalse, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL195:;

/* line 2416 "SemIntr.puma" */
  {
/* line 2418 "SemIntr.puma" */
   if (! (((name == IsIdent ("LOCAL_LINDEX")) || (name == IsIdent ("LOCAL_UINDEX"))))) goto yyL196;
  {
/* line 2421 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, DummyHPFArray, - 1);
/* line 2422 "SemIntr.puma" */
   set_parameter ("DIM", rtrue, IntentIn, IntExpr, 0);
/* line 2423 "SemIntr.puma" */
   set_parameter ("PROC", rfalse, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL196:;

/* line 2441 "SemIntr.puma" */
  {
/* line 2443 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_TASK_INIT")))) goto yyL197;
  }
   return;
yyL197:;

/* line 2446 "SemIntr.puma" */
  {
/* line 2448 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_TASK_EXIT")))) goto yyL198;
  }
   return;
yyL198:;

/* line 2451 "SemIntr.puma" */
  {
/* line 2453 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_TASK_RANK")))) goto yyL199;
  {
/* line 2455 "SemIntr.puma" */
   set_parameter ("RANK", rtrue, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL199:;

/* line 2458 "SemIntr.puma" */
  {
/* line 2460 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_TASK_SIZE")))) goto yyL200;
  {
/* line 2462 "SemIntr.puma" */
   set_parameter ("SIZE", rtrue, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL200:;

/* line 2465 "SemIntr.puma" */
  {
/* line 2467 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_SEND")))) goto yyL201;
  {
/* line 2469 "SemIntr.puma" */
   set_parameter ("DATA", rtrue, IntentIn, DummyHPFArray, - 1);
/* line 2470 "SemIntr.puma" */
   set_parameter ("DEST", rtrue, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL201:;

/* line 2473 "SemIntr.puma" */
  {
/* line 2475 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_RECV")))) goto yyL202;
  {
/* line 2477 "SemIntr.puma" */
   set_parameter ("DATA", rtrue, IntentOut, DummyHPFArray, - 1);
/* line 2478 "SemIntr.puma" */
   set_parameter ("SOURCE", rfalse, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL202:;

/* line 2481 "SemIntr.puma" */
  {
/* line 2483 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_BCAST")))) goto yyL203;
  {
/* line 2485 "SemIntr.puma" */
   set_parameter ("DATA", rtrue, IntentInOut, DummyHPFArray, - 1);
/* line 2486 "SemIntr.puma" */
   set_parameter ("ROOT", rfalse, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL203:;

/* line 2489 "SemIntr.puma" */
  {
/* line 2491 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_SEND_INIT")))) goto yyL204;
  {
/* line 2493 "SemIntr.puma" */
   set_parameter ("DATA", rtrue, IntentIn, DummyHPFArray, - 1);
/* line 2494 "SemIntr.puma" */
   set_parameter ("DEST", rtrue, IntentIn, IntExpr, 0);
/* line 2495 "SemIntr.puma" */
   set_parameter ("REQUEST", rtrue, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL204:;

/* line 2498 "SemIntr.puma" */
  {
/* line 2500 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_RECV_INIT")))) goto yyL205;
  {
/* line 2502 "SemIntr.puma" */
   set_parameter ("DATA", rtrue, IntentIn, DummyHPFArray, - 1);
/* line 2503 "SemIntr.puma" */
   set_parameter ("SOURCE", rtrue, IntentIn, IntExpr, 0);
/* line 2504 "SemIntr.puma" */
   set_parameter ("REQUEST", rtrue, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL205:;

/* line 2507 "SemIntr.puma" */
  {
/* line 2509 "SemIntr.puma" */
   if (! ((name == IsIdent ("HPF_TASK_COMM")))) goto yyL206;
  {
/* line 2511 "SemIntr.puma" */
   set_parameter ("REQUEST", rtrue, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL206:;

/* line 2514 "SemIntr.puma" */
   return;

;
}

static void SetMinMaxParams
# if defined __STDC__ | defined __cplusplus
(register int len, routine set_parameter, check_pred pred)
# else
(len, set_parameter, pred)
 register int len;
 routine set_parameter;
 check_pred pred;
# endif
{
/* line 2527 "SemIntr.puma" */
 {
  int i;
  {
/* line 2529 "SemIntr.puma" */
   set_parameter ("A1", rtrue, IntentIn, pred, - 1);
/* line 2530 "SemIntr.puma" */
   set_parameter ("A2", rtrue, IntentIn, pred, - 1);
/* line 2534 "SemIntr.puma" */
 for (i=3; i <= len; i++)
         { char id[10];
           sprintf (id, "A%d", i);
           set_parameter (id, rfalse, IntentIn, pred, -1);
         }
     
  }
   return;
 }

;
}

static void SetReductionParams
# if defined __STDC__ | defined __cplusplus
(register int dimrank, routine set_parameter, check_pred pred)
# else
(dimrank, set_parameter, pred)
 register int dimrank;
 routine set_parameter;
 check_pred pred;
# endif
{
  if (equalint (dimrank, 0)) {
/* line 2552 "SemIntr.puma" */
  {
/* line 2554 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, pred, - 1);
/* line 2555 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
/* line 2556 "SemIntr.puma" */
   set_parameter ("MASK", rfalse, IntentIn, LogicalExpr, - 1);
  }
   return;

  }
/* line 2559 "SemIntr.puma" */
  {
/* line 2561 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, pred, - 1);
/* line 2562 "SemIntr.puma" */
   set_parameter ("MASK", rfalse, IntentIn, LogicalExpr, - 1);
/* line 2563 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
  }
   return;

;
}

static void SetScanParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name, routine set_parameter)
# else
(name, set_parameter)
 register tIdent name;
 routine set_parameter;
# endif
{
/* line 2574 "SemIntr.puma" */
  {
/* line 2576 "SemIntr.puma" */
   if (! (((name == IsIdent ("COPY_PREFIX")) || (name == IsIdent ("COPY_SUFFIX"))))) goto yyL1;
  {
/* line 2580 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, Expr, - 1);
/* line 2581 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
/* line 2582 "SemIntr.puma" */
   set_parameter ("SEGMENT", rfalse, IntentIn, LogicalExpr, - 1);
  }
  }
   return;
yyL1:;

/* line 2585 "SemIntr.puma" */
  {
/* line 2587 "SemIntr.puma" */
   if (! (((name == IsIdent ("ALL_PREFIX")) || (name == IsIdent ("ALL_SUFFIX")) || (name == IsIdent ("ANY_PREFIX")) || (name == IsIdent ("ANY_SUFFIX")) || (name == IsIdent ("COUNT_PREFIX")) || (name == IsIdent ("COUNT_SUFFIX")) || (name == IsIdent ("PARITY_PREFIX")) || (name == IsIdent ("PARITY_SUFFIX"))))) goto yyL2;
  {
/* line 2597 "SemIntr.puma" */
   set_parameter ("MASK", rtrue, IntentIn, LogicalExpr, - 1);
/* line 2598 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
/* line 2599 "SemIntr.puma" */
   set_parameter ("SEGMENT", rfalse, IntentIn, LogicalExpr, - 1);
/* line 2600 "SemIntr.puma" */
   set_parameter ("EXCLUSIVE", rfalse, IntentIn, LogicalExpr, 0);
  }
  }
   return;
yyL2:;

/* line 2603 "SemIntr.puma" */
  {
/* line 2605 "SemIntr.puma" */
   if (! (((name == IsIdent ("IALL_PREFIX")) || (name == IsIdent ("IALL_SUFFIX")) || (name == IsIdent ("IANY_PREFIX")) || (name == IsIdent ("IANY_SUFFIX")) || (name == IsIdent ("IPARITY_PREFIX")) || (name == IsIdent ("IPARITY_SUFFIX"))))) goto yyL3;
  {
/* line 2612 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, IntExpr, - 1);
/* line 2613 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
/* line 2614 "SemIntr.puma" */
   set_parameter ("MASK", rfalse, IntentIn, LogicalExpr, - 1);
/* line 2615 "SemIntr.puma" */
   set_parameter ("SEGMENT", rfalse, IntentIn, LogicalExpr, - 1);
/* line 2616 "SemIntr.puma" */
   set_parameter ("EXCLUSIVE", rfalse, IntentIn, LogicalExpr, 0);
  }
  }
   return;
yyL3:;

/* line 2619 "SemIntr.puma" */
  {
/* line 2621 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, NumExpr, - 1);
/* line 2622 "SemIntr.puma" */
   set_parameter ("DIM", rfalse, IntentIn, IntExpr, 0);
/* line 2623 "SemIntr.puma" */
   set_parameter ("MASK", rfalse, IntentIn, LogicalExpr, - 1);
/* line 2624 "SemIntr.puma" */
   set_parameter ("SEGMENT", rfalse, IntentIn, LogicalExpr, - 1);
/* line 2625 "SemIntr.puma" */
   set_parameter ("EXCLUSIVE", rfalse, IntentIn, LogicalExpr, 0);
  }
   return;

;
}

static void SetScatterParams
# if defined __STDC__ | defined __cplusplus
(register int base_rank, routine set_parameter, check_pred pred)
# else
(base_rank, set_parameter, pred)
 register int base_rank;
 routine set_parameter;
 check_pred pred;
# endif
{
/* line 2637 "SemIntr.puma" */
 {
  int i;
  {
/* line 2639 "SemIntr.puma" */
   set_parameter ("ARRAY", rtrue, IntentIn, pred, - 1);
/* line 2640 "SemIntr.puma" */
   set_parameter ("BASE", rtrue, IntentIn, pred, - 1);
/* line 2644 "SemIntr.puma" */
 for (i=1; i <= base_rank; i++)
         { char id[10];
           sprintf (id, "INDX%d", i);
           set_parameter (id, rtrue, IntentIn, IntExpr, -1);
         }
     
/* line 2650 "SemIntr.puma" */
   set_parameter ("MASK", rfalse, IntentIn, LogicalExpr, - 1);
  }
   return;
 }

;
}

void BeginSemIntr ARGS ((void))
{
}

void CloseSemIntr ARGS ((void))
{
}
