# include "SemExp.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 36 "SemExp.puma" */


# define MODULE "SemExp"

# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "DefTable.h"

# include "Transform.h"
# include "ShowDefs.h"
# include "Expressions.h"    /* MakeConstant */

# include "SemCalling.h"    /*                  */
# include "SemPreds.h"      /*                  */
# include "SemIntr.h"      /*                  */
# include "Intrinsics.h"    /* NormalIntrinsicParams */
# include "Nesting.h"
# include "Rank.h"
# include "TreeOps.h"
# include "Objects.h"

# include "Types.h"     /* GetTypeZero      */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySemExp.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* SemExp_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemExp, routine %s failed\n",
  yyFunction);
 SemExp_Exit ();
}

void SemVariable ARGS ((tTree var));
static void SemParentArray ARGS ((tTree v, int * yyP1));
tTree SemExpression ARGS ((tTree exp));
static void NormalIntrinsicParams ARGS ((tIdent name, tTree params));
static void CheckRank ARGS ((tTree exp));
static void CheckTypeExpression ARGS ((tDefinitions complist, tTree explist));
tTree SemAssignment ARGS ((tTree assign));
static tTree ClassifyBinExp ARGS ((tTree exp, type_rec type, type_rec type1, type_rec type2));
static tTree ClassifyUnExp ARGS ((tTree exp, type_rec type, type_rec type1));
static tTree ClassifyAssign ARGS ((tTree assign, type_rec type_var, type_rec type_exp));
static tTree ClassifyTypeExp ARGS ((tTree exp, type_rec type_var, type_rec type_exp));
static void CheckRankAssign ARGS ((int rank1, int rank2));
static void CheckRankTypeAssign ARGS ((int rank1, int rank2, tTree exp));
static void CheckRankBinExp ARGS ((tTree exp, int rank1, int rank2));
static tTree ExpConvert ARGS ((tTree exp, int kind, int size));
static tTree MakeCall ARGS ((tIdent id, tTree exp, int size));
static void SetIntentInCall ARGS ((tTree params));
static void SemConstant ARGS ((tTree t));
static int EvalParameter ARGS ((tIdent id, tDefinitions obj, int default_size));
void SemParameter ARGS ((tTree param));
void SemIndexList ARGS ((tTree t));
static void SemExpList ARGS ((tTree t));
void SemParamList ARGS ((tTree t));
void SemTopology ARGS ((tTree t));
static void TopIndexList ARGS ((tTree t));

void SemVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
/* line 78 "SemExp.puma" */
  {
/* line 79 "SemExp.puma" */
   if (! ((var == NoTree))) goto yyL1;
  {
/* line 80 "SemExp.puma" */
   failure_protocol (MODULE, "SemVariable : no tree", var);
  }
  }
   return;
yyL1:;


  switch (var->Kind) {
  case kUSED_VAR:
/* line 89 "SemExp.puma" */
  {
/* line 91 "SemExp.puma" */
   SemVariable (var->USED_VAR.VARNAME);
/* line 93 "SemExp.puma" */
 if (IsCurrentLoopVar (var))
         var->Kind = kLOOP_VAR;
    
  }
   return;

  case kLOOP_VAR:
/* line 98 "SemExp.puma" */
  {
/* line 100 "SemExp.puma" */
   var = var->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;
  }

  case kDUMMY_VAR:
/* line 103 "SemExp.puma" */
   return;

  case kSELECTED_VAR:
/* line 106 "SemExp.puma" */
  {
/* line 108 "SemExp.puma" */
   SemVariable (var->SELECTED_VAR.SELEC_VAR);
/* line 110 "SemExp.puma" */
 

      if ((TreeRank(var->SELECTED_VAR.SELEC_VAR) > 0) && (VarRank (var->SELECTED_VAR.SELECTOR->REC_COMP.Object) > 0))
        { error_protocol ("more than one component has non-zero rank");
          tree_protocol ("indexed selected variable is ", var);
        }
    
  }
   return;

  case kSUBSTRING_VAR:
/* line 119 "SemExp.puma" */
  {
/* line 121 "SemExp.puma" */
   SemVariable (var->SUBSTRING_VAR.IND_VAR);
/* line 123 "SemExp.puma" */
 if (TreeRank(var->SUBSTRING_VAR.IND_VAR) != 0)
        { error_protocol ("rank of string variable > 0");
          tree_protocol ("string variable is ", var);
        }
    
/* line 129 "SemExp.puma" */
 var->SUBSTRING_VAR.IND_EXP = SemExpression (var->SUBSTRING_VAR.IND_EXP) ; 
  }
   return;

  case kINDEXED_VAR:
/* line 134 "SemExp.puma" */
 {
  int yyV1;
  {
/* line 136 "SemExp.puma" */
   SemVariable (var->INDEXED_VAR.IND_VAR);
/* line 137 "SemExp.puma" */
   SemIndexList (var->INDEXED_VAR.IND_EXPS);
/* line 139 "SemExp.puma" */
   SemParentArray (var->INDEXED_VAR.IND_VAR, & yyV1);
/* line 141 "SemExp.puma" */
 if (yyV1 != TreeListLength (var->INDEXED_VAR.IND_EXPS))

       { char msg[100];
         sprintf (msg, "illegal number of indexes : %d used, but rank = %d",
                        TreeListLength (var->INDEXED_VAR.IND_EXPS), yyV1);
         error_protocol (msg);
         tree_protocol ("indexed variable is ", var);
       }
    
  }
   return;
 }

  case kVAR_OBJ:
/* line 152 "SemExp.puma" */
  {
/* line 154 "SemExp.puma" */
   if (! ((var->VAR_OBJ.Object == NoObject))) goto yyL8;
  {
/* line 156 "SemExp.puma" */
   error_protocol ("No object for use of variable found");
/* line 157 "SemExp.puma" */
   tree_protocol ("Variable is ", var);
  }
  }
   return;
yyL8:;

/* line 160 "SemExp.puma" */
   return;

  }

/* line 164 "SemExp.puma" */
  {
/* line 166 "SemExp.puma" */
   failure_protocol (MODULE, "SemVariable", var);
  }
   return;

;
}

static void SemParentArray
# if defined __STDC__ | defined __cplusplus
(register tTree v, register int * yyP1)
# else
(v, yyP1)
 register tTree v;
 register int * yyP1;
# endif
{
  if (v->Kind == kUSED_VAR) {
/* line 177 "SemExp.puma" */
 {
  int rank;
  {
/* line 180 "SemExp.puma" */
   rank = VarRank (v->USED_VAR.VARNAME->VAR_OBJ.Object);
  }
   * yyP1 = rank;
   return;
 }

  }
  if (v->Kind == kSELECTED_VAR) {
/* line 183 "SemExp.puma" */
 {
  int rank;
  {
/* line 185 "SemExp.puma" */
 if (TreeRank (v->SELECTED_VAR.SELEC_VAR) != 0)
        error_protocol ("array of indexed structure_components not allowed");
    
/* line 190 "SemExp.puma" */
   rank = VarRank (v->SELECTED_VAR.SELECTOR->REC_COMP.Object);
  }
   * yyP1 = rank;
   return;
 }

  }
/* line 193 "SemExp.puma" */
  {
/* line 195 "SemExp.puma" */
   error_protocol ("variable cannot be indexed");
/* line 196 "SemExp.puma" */
   tree_protocol ("illegal variable is : ", v);
  }
   * yyP1 = 0;
   return;

;
}

tTree SemExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
/* line 207 "SemExp.puma" */
  {
/* line 213 "SemExp.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  {
/* line 214 "SemExp.puma" */
   failure_protocol (MODULE, "SemExpression : no tree", exp);
  }
  }
   return mDUMMY_EXP ();
yyL1:;


  switch (exp->Kind) {
  case kDUMMY_EXP:
/* line 218 "SemExp.puma" */
   return exp;

  case kCONST_EXP:
/* line 222 "SemExp.puma" */
  {
/* line 224 "SemExp.puma" */
   SemConstant (exp->CONST_EXP.C);
  }
   return exp;

  case kARRAY_EXP:
/* line 228 "SemExp.puma" */
  {
/* line 230 "SemExp.puma" */
   SemExpList (exp->ARRAY_EXP.ELEMENTS);
  }
   return exp;

  case kSLICE_EXP:
/* line 234 "SemExp.puma" */
  {
/* line 236 "SemExp.puma" */
 exp->SLICE_EXP.FIRST = SemExpression (exp->SLICE_EXP.FIRST);
     exp->SLICE_EXP.STOP  = SemExpression (exp->SLICE_EXP.STOP);
     exp->SLICE_EXP.INC   = SemExpression (exp->SLICE_EXP.INC);

     if (!ScalarIntExpr (exp->SLICE_EXP.FIRST))
        { error_protocol ("scalar integer expression for _:_ expected");
          tree_protocol ("illegal expression is : ", exp->SLICE_EXP.FIRST);
        }
     if (!ScalarIntExpr (exp->SLICE_EXP.STOP))
        { error_protocol ("scalar integer expression for _:_ expected");
          tree_protocol ("illegal expression is : ", exp->SLICE_EXP.STOP);
        }
     if (!ScalarIntExpr (exp->SLICE_EXP.INC))
        { error_protocol ("scalar integer expression for _:_ expected");
          tree_protocol ("illegal expression is : ", exp->SLICE_EXP.INC);
        }
   
  }
   return exp;

  case kOP_EXP:
/* line 256 "SemExp.puma" */
 {
  type_rec type1;
  type_rec type2;
  type_rec type;
  {
/* line 258 "SemExp.puma" */
 exp->OP_EXP.OPND1 = SemExpression (exp->OP_EXP.OPND1);
     exp->OP_EXP.OPND2 = SemExpression (exp->OP_EXP.OPND2);
   
/* line 262 "SemExp.puma" */
   CheckRankBinExp (exp, TreeRank (exp->OP_EXP.OPND1), TreeRank (exp->OP_EXP.OPND2));
/* line 268 "SemExp.puma" */
   GetExpType (exp->OP_EXP.OPND1, & type1);
/* line 269 "SemExp.puma" */
   GetExpType (exp->OP_EXP.OPND2, & type2);
/* line 270 "SemExp.puma" */
   GetOp2Type (exp->OP_EXP.EXP_OP, type1, type2, & type);
  }
   return ClassifyBinExp (exp, type, type1, type2);
 }

  case kOP1_EXP:
/* line 275 "SemExp.puma" */
 {
  type_rec type1;
  type_rec type;
  {
/* line 277 "SemExp.puma" */
 exp->OP1_EXP.OPND = SemExpression (exp->OP1_EXP.OPND); 
/* line 282 "SemExp.puma" */
   GetExpType (exp->OP1_EXP.OPND, & type1);
/* line 283 "SemExp.puma" */
   GetOp1Type (exp->OP1_EXP.EXP_OP1, type1, & type);
  }
   return ClassifyUnExp (exp, type, type1);
 }

  case kTYPE_EXP:
  if (exp->TYPE_EXP.ID->TYPE_OBJ.Object->Kind == kTypeObject) {
/* line 288 "SemExp.puma" */
  {
/* line 290 "SemExp.puma" */
   SemExpList (exp->TYPE_EXP.ELEMENTS);
/* line 294 "SemExp.puma" */
   CheckTypeExpression (exp->TYPE_EXP.ID->TYPE_OBJ.Object->TypeObject.Components, exp->TYPE_EXP.ELEMENTS);
  }
   return exp;

  }
  break;
  case kVAR_EXP:
/* line 299 "SemExp.puma" */
  {
/* line 301 "SemExp.puma" */
   SemVariable (exp->VAR_EXP.V);
  }
   return exp;

  case kNAMED_EXP:
/* line 305 "SemExp.puma" */
  {
/* line 307 "SemExp.puma" */
   error_protocol ("named expression not allowed here");
/* line 309 "SemExp.puma" */
 exp->NAMED_EXP.VAL = SemExpression (exp->NAMED_EXP.VAL); 
  }
   return exp;

  case kDO_EXP:
/* line 314 "SemExp.puma" */
  {
/* line 316 "SemExp.puma" */
   IncLoopNesting (exp);
/* line 318 "SemExp.puma" */
   SemVariable (exp->DO_EXP.DO_ID);
/* line 320 "SemExp.puma" */
 if (!ScalarIntVariable (exp->DO_EXP.DO_ID))
        error_protocol ("not scalar integer variable in implied do");

     exp->DO_EXP.RANGE = SemExpression (exp->DO_EXP.RANGE);   
   
/* line 326 "SemExp.puma" */
   SemExpList (exp->DO_EXP.BODY);
/* line 327 "SemExp.puma" */
   DecLoopNesting (exp);
  }
   return exp;

  case kFUNC_CALL_EXP:
/* line 332 "SemExp.puma" */
  {
/* line 334 "SemExp.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL12;
  {
/* line 336 "SemExp.puma" */
   SemParamList (exp->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 340 "SemExp.puma" */
   SemCalling (exp);
/* line 342 "SemExp.puma" */
   NormalIntrinsicParams (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, exp->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 344 "SemExp.puma" */
   SemIntrinsicFunction (exp, exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, exp->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 346 "SemExp.puma" */
   CheckRank (exp);
  }
  }
   return exp;
yyL12:;

/* line 351 "SemExp.puma" */
  {
/* line 355 "SemExp.puma" */
   SemParamList (exp->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 357 "SemExp.puma" */
 exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object = IdentifyGenericRoutine (exp, exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object); 
/* line 359 "SemExp.puma" */
   SemCalling (exp);
/* line 361 "SemExp.puma" */
   CheckRank (exp);
  }
   return exp;

  }

/* line 366 "SemExp.puma" */
  {
/* line 368 "SemExp.puma" */
   failure_protocol (MODULE, "SemExpression", exp);
  }
   return NoTree;

}

static void NormalIntrinsicParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 388 "SemExp.puma" */
  {
/* line 390 "SemExp.puma" */
   if (! (((name == MakeIdent ("ALL", 3)) || (name == MakeIdent ("ANY", 3)) || (name == MakeIdent ("COUNT", 5))))) goto yyL1;
  {
/* line 394 "SemExp.puma" */
 params->BTP_LIST.Next->BTP_LIST.Next = mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), params->BTP_LIST.Next->BTP_LIST.Next); 
  }
  }
   return;
yyL1:;

  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 397 "SemExp.puma" */
 {
  tTree help;
  {
/* line 399 "SemExp.puma" */
   if (! ((IntrFuncRed (name) || IntrFuncLocRed (name)))) goto yyL2;
  {
/* line 400 "SemExp.puma" */
   if (! ((TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) > 0))) goto yyL2;
  {
/* line 403 "SemExp.puma" */
 help = params->BTP_LIST.Next->BTP_LIST.Elem; params->BTP_LIST.Next->BTP_LIST.Elem = params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem; params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = help; 
  }
  }
  }
   return;
 }
yyL2:;

  }
  }
  }
;
}

static void CheckRank
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
/* line 416 "SemExp.puma" */
  {
/* line 418 "SemExp.puma" */
   if (! ((TreeRank (exp) >= 0))) goto yyL1;
  }
   return;
yyL1:;

/* line 421 "SemExp.puma" */
  {
/* line 423 "SemExp.puma" */
 char msg[100];
     char f_name[MAX_ID_LENGTH];
     GetString (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, f_name);
     if (IsIntrCall (exp))
        sprintf (msg, "rank error for intrinsic function %s", f_name);
      else
        sprintf (msg, "rank error for function call of %s", f_name);
     error_protocol (msg);
   
  }
   return;

  }
;
}

static void CheckTypeExpression
# if defined __STDC__ | defined __cplusplus
(register tDefinitions complist, register tTree explist)
# else
(complist, explist)
 register tDefinitions complist;
 register tTree explist;
# endif
{
 yyRecursion:
  if (complist->Kind == kENTRY_EMPTY) {
  if (explist->Kind == kBTE_LIST) {
/* line 442 "SemExp.puma" */
  {
/* line 444 "SemExp.puma" */
   error_protocol ("too many components in type expression");
  }
   return;

  }
  if (explist->Kind == kBTE_EMPTY) {
/* line 447 "SemExp.puma" */
   return;

  }
  }
  if (complist->Kind == kENTRY_LIST) {
  if (explist->Kind == kBTE_EMPTY) {
/* line 450 "SemExp.puma" */
  {
/* line 452 "SemExp.puma" */
   error_protocol ("not enough components in type expression");
  }
   return;

  }
  if (explist->Kind == kBTE_LIST) {
/* line 455 "SemExp.puma" */
 {
  type_rec type1;
  type_rec type2;
  {
/* line 457 "SemExp.puma" */
   CheckRankTypeAssign (VarRank (complist->ENTRY_LIST.Elem), TreeRank (explist->BTE_LIST.Elem), explist->BTE_LIST.Elem);
/* line 462 "SemExp.puma" */
   GetTypeRecord (GetBaseType (GetObjectType (complist->ENTRY_LIST.Elem)), & type1);
/* line 463 "SemExp.puma" */
   GetExpType (explist->BTE_LIST.Elem, & type2);
/* line 465 "SemExp.puma" */
 explist->BTE_LIST.Elem = ClassifyTypeExp (explist->BTE_LIST.Elem, type1, type2); 
/* line 467 "SemExp.puma" */
   complist = complist->ENTRY_LIST.Next;
   explist = explist->BTE_LIST.Next;
   goto yyRecursion;
  }
 }

  }
  }
/* line 470 "SemExp.puma" */
  {
/* line 471 "SemExp.puma" */
   failure_protocol (MODULE, "ChecktTypeExpression", explist);
  }
   return;

;
}

tTree SemAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
/* line 482 "SemExp.puma" */
 {
  type_rec type1;
  type_rec type2;
  {
/* line 484 "SemExp.puma" */
   SemVariable (assign->ASSIGN_STMT.ASSIGN_VAR);
/* line 486 "SemExp.puma" */
 if (!IsLegalOutVar (assign->ASSIGN_STMT.ASSIGN_VAR))
        error_protocol (type_error_msg);

     assign->ASSIGN_STMT.ASSIGN_EXP = SemExpression (assign->ASSIGN_STMT.ASSIGN_EXP);

   
/* line 493 "SemExp.puma" */
   CheckRankAssign (TreeRank (assign->ASSIGN_STMT.ASSIGN_VAR), TreeRank (assign->ASSIGN_STMT.ASSIGN_EXP));
/* line 498 "SemExp.puma" */
   GetExpType (assign->ASSIGN_STMT.ASSIGN_VAR, & type1);
/* line 499 "SemExp.puma" */
   GetExpType (assign->ASSIGN_STMT.ASSIGN_EXP, & type2);
  }
   return ClassifyAssign (assign, type1, type2);
 }

  }
/* line 504 "SemExp.puma" */
  {
/* line 505 "SemExp.puma" */
   failure_protocol (MODULE, "SemAssignment", assign);
  }
   return assign;

}

static tTree ClassifyBinExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, type_rec type, type_rec type1, type_rec type2)
# else
(exp, type, type1, type2)
 register tTree exp;
 type_rec type;
 type_rec type1;
 type_rec type2;
# endif
{
/* line 523 "SemExp.puma" */
  {
/* line 525 "SemExp.puma" */
   if (! ((type1 . type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return exp;
yyL1:;

/* line 529 "SemExp.puma" */
  {
/* line 531 "SemExp.puma" */
   if (! ((type2 . type_kind == kDUMMY_TYPE))) goto yyL2;
  }
   return exp;
yyL2:;

  if (exp->Kind == kOP_EXP) {
/* line 535 "SemExp.puma" */
  {
/* line 539 "SemExp.puma" */
   if (! ((type . type_kind != kDUMMY_TYPE))) goto yyL3;
  {
/* line 540 "SemExp.puma" */
   if (! ((SameTypeRecord (type1, type2)))) goto yyL3;
  }
  }
   return exp;
yyL3:;

/* line 545 "SemExp.puma" */
  {
/* line 549 "SemExp.puma" */
   if (! ((type . type_kind != kDUMMY_TYPE))) goto yyL4;
  {
/* line 550 "SemExp.puma" */
   if (! ((IsSubType (type1, type2)))) goto yyL4;
  {
/* line 552 "SemExp.puma" */
 exp->OP_EXP.OPND1 = ExpConvert (exp->OP_EXP.OPND1, type2.type_kind, type2.type_size); 
  }
  }
  }
   return exp;
yyL4:;

/* line 557 "SemExp.puma" */
  {
/* line 561 "SemExp.puma" */
   if (! ((type . type_kind != kDUMMY_TYPE))) goto yyL5;
  {
/* line 562 "SemExp.puma" */
   if (! ((IsSubType (type2, type1)))) goto yyL5;
  {
/* line 564 "SemExp.puma" */
 exp->OP_EXP.OPND2 = ExpConvert (exp->OP_EXP.OPND2, type1.type_kind, type1.type_size); 
  }
  }
  }
   return exp;
yyL5:;

/* line 569 "SemExp.puma" */
 {
  tTree new_exp;
  {
/* line 575 "SemExp.puma" */
   new_exp = IdentifyBinaryRoutine (exp);
/* line 577 "SemExp.puma" */
   if (! ((new_exp != NoTree))) goto yyL6;
  }
   return new_exp;
 }
yyL6:;

/* line 582 "SemExp.puma" */
  {
/* line 584 "SemExp.puma" */
 char str1[30], str2[30], msg[100];
     OutType (str1, type1);
     OutType (str2, type2);
     sprintf (msg, "illegal operand types (%s,%s) for binary operation", 
              str1, str2);
     error_protocol (msg);
     tree_protocol ("binary expression is : ", exp);

   
  }
   return exp;

  }
 yyAbort ("ClassifyBinExp");
 { tTree yyDummy; return yyDummy; }
}

static tTree ClassifyUnExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, type_rec type, type_rec type1)
# else
(exp, type, type1)
 register tTree exp;
 type_rec type;
 type_rec type1;
# endif
{
/* line 606 "SemExp.puma" */
  {
/* line 608 "SemExp.puma" */
   if (! ((type1 . type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return exp;
yyL1:;

  if (exp->Kind == kOP1_EXP) {
/* line 612 "SemExp.puma" */
  {
/* line 616 "SemExp.puma" */
   if (! ((type . type_kind != kDUMMY_TYPE))) goto yyL2;
  }
   return exp;
yyL2:;

/* line 620 "SemExp.puma" */
 {
  tTree new_exp;
  {
/* line 626 "SemExp.puma" */
   new_exp = IdentifyUnaryRoutine (exp);
/* line 628 "SemExp.puma" */
   if (! ((new_exp != NoTree))) goto yyL3;
  }
   return new_exp;
 }
yyL3:;

/* line 633 "SemExp.puma" */
  {
/* line 635 "SemExp.puma" */
   error_protocol ("illegal operand for unary operation");
/* line 636 "SemExp.puma" */
   tree_protocol ("unary expression is : ", exp);
  }
   return exp;

  }
/* line 640 "SemExp.puma" */
  {
/* line 641 "SemExp.puma" */
   failure_protocol (MODULE, "UnaryCheck", exp);
  }
   return exp;

}

static tTree ClassifyAssign
# if defined __STDC__ | defined __cplusplus
(register tTree assign, type_rec type_var, type_rec type_exp)
# else
(assign, type_var, type_exp)
 register tTree assign;
 type_rec type_var;
 type_rec type_exp;
# endif
{
/* line 659 "SemExp.puma" */
  {
/* line 661 "SemExp.puma" */
   if (! ((type_var . type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return assign;
yyL1:;

/* line 666 "SemExp.puma" */
  {
/* line 668 "SemExp.puma" */
   if (! ((type_exp . type_kind == kDUMMY_TYPE))) goto yyL2;
  }
   return assign;
yyL2:;

/* line 673 "SemExp.puma" */
  {
/* line 677 "SemExp.puma" */
   if (! ((LegalAssignmentTypes (type_var, type_exp)))) goto yyL3;
  {
/* line 679 "SemExp.puma" */
   if (! ((SameTypeRecord (type_var, type_exp)))) goto yyL3;
  }
  }
   return assign;
yyL3:;

  if (assign->Kind == kASSIGN_STMT) {
/* line 684 "SemExp.puma" */
  {
/* line 688 "SemExp.puma" */
   if (! ((LegalAssignmentTypes (type_var, type_exp)))) goto yyL4;
  {
/* line 690 "SemExp.puma" */
 assign->ASSIGN_STMT.ASSIGN_EXP = ExpConvert (assign->ASSIGN_STMT.ASSIGN_EXP, type_var.type_kind, type_var.type_size); 
  }
  }
   return assign;
yyL4:;

/* line 695 "SemExp.puma" */
 {
  tTree new_assign;
  {
/* line 701 "SemExp.puma" */
   new_assign = IdentifyAssignRoutine (assign);
/* line 703 "SemExp.puma" */
   if (! ((new_assign != NoTree))) goto yyL5;
  }
   return new_assign;
 }
yyL5:;

/* line 708 "SemExp.puma" */
  {
/* line 710 "SemExp.puma" */
 char str1[30], str2[30], msg[100];
     OutType (str1, type_var);
     OutType (str2, type_exp);
     sprintf (msg, "illegal types (%s=%s) for assignment", str1, str2);
     error_protocol (msg);
   
  }
   return assign;

  }
/* line 720 "SemExp.puma" */
  {
/* line 722 "SemExp.puma" */
   failure_protocol (MODULE, "ClassifyAssign", assign);
  }
   return assign;

}

static tTree ClassifyTypeExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, type_rec type_var, type_rec type_exp)
# else
(exp, type_var, type_exp)
 register tTree exp;
 type_rec type_var;
 type_rec type_exp;
# endif
{
/* line 739 "SemExp.puma" */
  {
/* line 741 "SemExp.puma" */
   if (! ((type_var . type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return exp;
yyL1:;

/* line 745 "SemExp.puma" */
  {
/* line 747 "SemExp.puma" */
   if (! ((type_exp . type_kind == kDUMMY_TYPE))) goto yyL2;
  }
   return exp;
yyL2:;

/* line 751 "SemExp.puma" */
  {
/* line 755 "SemExp.puma" */
   if (! ((LegalAssignmentTypes (type_var, type_exp)))) goto yyL3;
  {
/* line 757 "SemExp.puma" */
   if (! ((type_var . type_kind == type_exp . type_kind))) goto yyL3;
  {
/* line 758 "SemExp.puma" */
   if (! ((type_var . type_size == type_exp . type_size))) goto yyL3;
  }
  }
  }
   return exp;
yyL3:;

/* line 763 "SemExp.puma" */
  {
/* line 767 "SemExp.puma" */
   if (! ((LegalAssignmentTypes (type_var, type_exp)))) goto yyL4;
  }
   return ExpConvert (exp, type_var . type_kind, type_var . type_size);
yyL4:;

/* line 772 "SemExp.puma" */
  {
/* line 774 "SemExp.puma" */
 char str1[30], str2[30], msg[100];
     OutType (str1, type_var);
     OutType (str2, type_exp);
     sprintf (msg, "illegal type (%s expected, not %s) within type exp",
                    str1, str2);
     error_protocol (msg);
     tree_protocol ("illegal exp is ", exp);
   
  }
   return exp;

}

static void CheckRankAssign
# if defined __STDC__ | defined __cplusplus
(register int rank1, register int rank2)
# else
(rank1, rank2)
 register int rank1;
 register int rank2;
# endif
{
/* line 797 "SemExp.puma" */
 {
  rbool okay;
  {
/* line 801 "SemExp.puma" */
   if (! ((rank1 >= 0))) goto yyL1;
  {
/* line 802 "SemExp.puma" */
   if (! ((rank2 >= 0))) goto yyL1;
  {
/* line 804 "SemExp.puma" */
   okay = (rank2 == 0) || (rank1 == rank2);
/* line 806 "SemExp.puma" */
 if (!okay)
       { char msg[100];
         sprintf (msg, "ASSIGN rank mismatch, lhs = %d, rhs = %d",
                        rank1, rank2);
         error_protocol (msg);
       }
   
  }
  }
  }
   return;
 }
yyL1:;

;
}

static void CheckRankTypeAssign
# if defined __STDC__ | defined __cplusplus
(register int rank1, register int rank2, register tTree exp)
# else
(rank1, rank2, exp)
 register int rank1;
 register int rank2;
 register tTree exp;
# endif
{
/* line 817 "SemExp.puma" */
 {
  rbool okay;
  {
/* line 821 "SemExp.puma" */
   if (! ((rank1 >= 0))) goto yyL1;
  {
/* line 822 "SemExp.puma" */
   if (! ((rank2 >= 0))) goto yyL1;
  {
/* line 824 "SemExp.puma" */
   okay = (rank2 == 0) || (rank1 == rank2);
/* line 826 "SemExp.puma" */
 if (!okay)
       { char msg[100];
         sprintf (msg, "rank error in type exp, rank = %d should be %d",
                        rank2, rank1);
         error_protocol (msg);
         tree_error_protocol ("illegal component is ", exp);
       }
   
  }
  }
  }
   return;
 }
yyL1:;

;
}

static void CheckRankBinExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int rank1, register int rank2)
# else
(exp, rank1, rank2)
 register tTree exp;
 register int rank1;
 register int rank2;
# endif
{
/* line 838 "SemExp.puma" */
 {
  rbool okay;
  {
/* line 842 "SemExp.puma" */
   if (! ((rank1 >= 0))) goto yyL1;
  {
/* line 843 "SemExp.puma" */
   if (! ((rank2 >= 0))) goto yyL1;
  {
/* line 845 "SemExp.puma" */
   okay = (rank1 == 0) || (rank2 == 0) || (rank1 == rank2);
/* line 847 "SemExp.puma" */
 if (!okay)
       { char msg[100];
         sprintf (msg, "binary exp rank mismatch, e1 = %d, e2 = %d",
                        rank1, rank2);
         error_protocol (msg);
         tree_protocol ("expression is : ", exp);
       }
   
/* line 855 "SemExp.puma" */
   if (! ((okay))) goto yyL1;
  }
  }
  }
   return;
 }
yyL1:;

;
}

static tTree ExpConvert
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int kind, register int size)
# else
(exp, kind, size)
 register tTree exp;
 register int kind;
 register int size;
# endif
{
/* line 871 "SemExp.puma" */
  {
/* line 873 "SemExp.puma" */
   if (! ((kind == kREAL_TYPE))) goto yyL1;
  {
/* line 874 "SemExp.puma" */
   if (! ((size == default_real_size))) goto yyL1;
  }
  }
   return MakeCall (MakeIdent ("REAL", 4), exp, 0);
yyL1:;

/* line 879 "SemExp.puma" */
  {
/* line 881 "SemExp.puma" */
   if (! ((kind == kREAL_TYPE))) goto yyL2;
  {
/* line 882 "SemExp.puma" */
   if (! ((size == 2 * default_real_size))) goto yyL2;
  }
  }
   return MakeCall (MakeIdent ("DBLE", 4), exp, - 1);
yyL2:;

/* line 887 "SemExp.puma" */
  {
/* line 889 "SemExp.puma" */
   if (! ((kind == kREAL_TYPE))) goto yyL3;
  }
   return MakeCall (MakeIdent ("REAL", 4), exp, size);
yyL3:;

/* line 894 "SemExp.puma" */
  {
/* line 896 "SemExp.puma" */
   if (! ((kind == kINTEGER_TYPE))) goto yyL4;
  {
/* line 897 "SemExp.puma" */
   if (! ((size == default_int_size))) goto yyL4;
  }
  }
   return MakeCall (MakeIdent ("INT", 3), exp, 0);
yyL4:;

/* line 902 "SemExp.puma" */
  {
/* line 904 "SemExp.puma" */
   if (! ((kind == kINTEGER_TYPE))) goto yyL5;
  }
   return MakeCall (MakeIdent ("INT", 3), exp, size);
yyL5:;

/* line 908 "SemExp.puma" */
  {
/* line 910 "SemExp.puma" */
   if (! ((kind == kCOMPLEX_TYPE))) goto yyL6;
  {
/* line 911 "SemExp.puma" */
   if (! ((size == 2 * default_real_size))) goto yyL6;
  }
  }
   return MakeCall (MakeIdent ("CMPLX", 5), exp, 0);
yyL6:;

/* line 916 "SemExp.puma" */
  {
/* line 918 "SemExp.puma" */
   if (! ((kind == kCOMPLEX_TYPE))) goto yyL7;
  {
/* line 919 "SemExp.puma" */
   if (! ((size == 4 * default_real_size))) goto yyL7;
  }
  }
   return MakeCall (MakeIdent ("DCMPLX", 6), exp, 0);
yyL7:;

/* line 924 "SemExp.puma" */
  {
/* line 926 "SemExp.puma" */
 char str1[30], msg[100];
     type_rec t;
     t.type_kind = kind;
     t.type_size = size;
     OutType (str1, t);
     sprintf (msg, "illegal type conversion (%s)", str1);
     error_protocol (msg);
   
  }
   return exp;

}

static tTree MakeCall
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree exp, register int size)
# else
(id, exp, size)
 register tIdent id;
 register tTree exp;
 register int size;
# endif
{
/* line 944 "SemExp.puma" */
 {
  tTree call;
  tTree params;
  {
/* line 949 "SemExp.puma" */
 call = mPROC_OBJ (id);
     call->PROC_OBJ.Object = GetIntrinsicObject (id);
     params = mBTP_EMPTY ();
     if (size == 0)
        params = mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), params);
      else if (size > 0)
        params = mBTP_LIST (ExpToVarParam (MakeConstant (size)), params);
     params = mBTP_LIST (ExpToVarParam (exp), params);
     SetIntentInCall (params);
     call = mFUNC_CALL_EXP (call, params);
   
  }
   return call;
 }

}

static void SetIntentInCall
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 966 "SemExp.puma" */
  {
/* line 968 "SemExp.puma" */
 params->BTP_LIST.Elem->VAR_PARAM.intent = IntentIn; 
  }
   return;

  }
  }
/* line 971 "SemExp.puma" */
  {
/* line 972 "SemExp.puma" */
   failure_protocol (MODULE, "SetIntentInCall", params);
  }
   return;

;
}

static void SemConstant
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kREAL_CONSTANT) {
/* line 983 "SemExp.puma" */
  {
/* line 985 "SemExp.puma" */
   if (! ((t->REAL_CONSTANT.kind >= 0))) goto yyL1;
  }
   return;
yyL1:;

/* line 988 "SemExp.puma" */
  {
/* line 990 "SemExp.puma" */
   if (! (((- t->REAL_CONSTANT.kind) == DefaultId ()))) goto yyL2;
  {
/* line 992 "SemExp.puma" */
 t->REAL_CONSTANT.kind = default_real_size; 
  }
  }
   return;
yyL2:;

/* line 995 "SemExp.puma" */
  {
/* line 997 "SemExp.puma" */
   t->REAL_CONSTANT.kind = EvalParameter (- t->REAL_CONSTANT.kind, GetGlobalObject (- t->REAL_CONSTANT.kind), default_real_size);
  }
   return;

  }
;
}

static int EvalParameter
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tDefinitions obj, register int default_size)
# else
(id, obj, default_size)
 register tIdent id;
 register tDefinitions obj;
 register int default_size;
# endif
{
/* line 1002 "SemExp.puma" */

char msg[100], string[100];

/* line 1006 "SemExp.puma" */
  {
/* line 1008 "SemExp.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 1010 "SemExp.puma" */
 GetString (id, string);
     sprintf (msg, "unknown kind identifier %s in constant", string);
     error_protocol (msg);
   
  }
  }
   return default_size;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarParameter) {
/* line 1017 "SemExp.puma" */
 {
  rbool found;
  int val;
  {
/* line 1022 "SemExp.puma" */
   GetIntConstValue (obj->VarObject.Kind->VarParameter.Val, & found, & val);
/* line 1024 "SemExp.puma" */
 if (!found)
      { val = default_size;
        GetString (id, string);
        sprintf (msg, "kind identifier %s not known at compile time", string);
        error_protocol (msg);
        tree_protocol ("kind expression is : ", obj->VarObject.Kind->VarParameter.Val);
      }
     else if (val < 0)
      { GetString (id, string);
        sprintf (msg, "kind %s not supported", string);
        error_protocol (msg);
        val = default_size;
      }
   
  }
   return val;
 }

  }
  }
/* line 1041 "SemExp.puma" */
  {
/* line 1043 "SemExp.puma" */
 GetString (id, string);
     sprintf (msg, "kind identifier %s is not parameter", string);
     error_protocol (msg);
   
  }
   return default_size;

}

void SemParameter
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
 yyRecursion:
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
/* line 1058 "SemExp.puma" */
  {
/* line 1060 "SemExp.puma" */
 param->VAR_PARAM.V->ADDR.E = SemExpression (param->VAR_PARAM.V->ADDR.E); 
  }
   return;

  }
/* line 1063 "SemExp.puma" */
  {
/* line 1065 "SemExp.puma" */
   SemVariable (param->VAR_PARAM.V);
  }
   return;

  }
  if (param->Kind == kNO_PARAM) {
/* line 1068 "SemExp.puma" */
   return;

  }
  if (param->Kind == kNAMED_PARAM) {
/* line 1071 "SemExp.puma" */
  {
/* line 1073 "SemExp.puma" */
   param = param->NAMED_PARAM.VAL;
   goto yyRecursion;
  }

  }
  if (param->Kind == kFUNC_PARAM) {
/* line 1076 "SemExp.puma" */
   return;

  }
  if (param->Kind == kPROC_PARAM) {
/* line 1079 "SemExp.puma" */
   return;

  }
/* line 1082 "SemExp.puma" */
  {
/* line 1083 "SemExp.puma" */
   failure_protocol (MODULE, "SemParameter", param);
  }
   return;

;
}

void SemIndexList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTE_LIST) {
/* line 1103 "SemExp.puma" */
  {
/* line 1105 "SemExp.puma" */
 t->BTE_LIST.Elem = SemExpression (t->BTE_LIST.Elem);

     if (!IntExpr (t->BTE_LIST.Elem))
        { error_protocol ("subscript not integer");
          tree_protocol ("subscript : ", t->BTE_LIST.Elem);
        }
     if (TreeRank (t->BTE_LIST.Elem) > 1)
        { error_protocol ("vector-subscript must have rank 1");
          tree_protocol ("subscript : ", t->BTE_LIST.Elem);
        }
   
/* line 1116 "SemExp.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTE_EMPTY) {
/* line 1119 "SemExp.puma" */
   return;

  }
/* line 1122 "SemExp.puma" */
  {
/* line 1123 "SemExp.puma" */
   failure_protocol (MODULE, "SemIndexList", t);
  }
   return;

;
}

static void SemExpList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTE_LIST) {
/* line 1136 "SemExp.puma" */
  {
/* line 1138 "SemExp.puma" */
 t->BTE_LIST.Elem = SemExpression (t->BTE_LIST.Elem); 
/* line 1139 "SemExp.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTE_EMPTY) {
/* line 1142 "SemExp.puma" */
   return;

  }
/* line 1145 "SemExp.puma" */
  {
/* line 1146 "SemExp.puma" */
   failure_protocol (MODULE, "SemExpList", t);
  }
   return;

;
}

void SemParamList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_LIST) {
/* line 1157 "SemExp.puma" */
  {
/* line 1159 "SemExp.puma" */
   SemParameter (t->BTP_LIST.Elem);
/* line 1160 "SemExp.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTP_EMPTY) {
/* line 1163 "SemExp.puma" */
   return;

  }
/* line 1166 "SemExp.puma" */
  {
/* line 1167 "SemExp.puma" */
   failure_protocol (MODULE, "SemParamList", t);
  }
   return;

;
}

void SemTopology
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kANY_PROCESSOR_ARRAY) {
/* line 1178 "SemExp.puma" */
   return;

  }
  if (t->Kind == kDEFAULT_PROCESSOR_ARRAY) {
/* line 1181 "SemExp.puma" */
   return;

  }
  if (t->Kind == kPROCESSOR_ARRAY) {
/* line 1184 "SemExp.puma" */
   return;

  }
  if (t->Kind == kPROCESSOR_SUBSET) {
/* line 1187 "SemExp.puma" */
 {
  int rank;
  {
/* line 1192 "SemExp.puma" */
   SemIndexList (t->PROCESSOR_SUBSET.SUBSCRIPTS);
/* line 1193 "SemExp.puma" */
   TopIndexList (t->PROCESSOR_SUBSET.SUBSCRIPTS);
/* line 1195 "SemExp.puma" */
 rank = VarRank (t->PROCESSOR_SUBSET.FULLTOP->TOP_OBJ.Object);

     if (rank != TreeListLength (t->PROCESSOR_SUBSET.SUBSCRIPTS))

       { char msg[100];
         sprintf (msg, "illegal number of indexes : %d used, but rank = %d",
                        TreeListLength (t->PROCESSOR_SUBSET.SUBSCRIPTS), rank);
         error_protocol (msg);
         tree_protocol ("illegal processor subset : ", t);
       }
   
  }
   return;
 }

  }
/* line 1208 "SemExp.puma" */
  {
/* line 1209 "SemExp.puma" */
   failure_protocol (MODULE, "SemTopology", t);
  }
   return;

;
}

static void TopIndexList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 1214 "SemExp.puma" */
  {
/* line 1216 "SemExp.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 1219 "SemExp.puma" */
  {
/* line 1221 "SemExp.puma" */
   if (! ((TreeRank (t->BTE_LIST.Elem) == 0))) goto yyL2;
  {
/* line 1223 "SemExp.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }
  }
yyL2:;

  if (t->BTE_LIST.Elem->Kind == kVAR_EXP) {
  if (t->BTE_LIST.Elem->VAR_EXP.V->Kind == kUSED_VAR) {
/* line 1226 "SemExp.puma" */
  {
/* line 1228 "SemExp.puma" */
   if (! ((TreeRank (t->BTE_LIST.Elem) == 1))) goto yyL3;
  {
/* line 1230 "SemExp.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }
  }
yyL3:;

  }
  }
/* line 1233 "SemExp.puma" */
  {
/* line 1235 "SemExp.puma" */
   if (! ((TreeRank (t->BTE_LIST.Elem) == 1))) goto yyL4;
  {
/* line 1237 "SemExp.puma" */
   error_protocol ("vector-subscript must be array name");
/* line 1238 "SemExp.puma" */
   tree_protocol ("subscript : ", t->BTE_LIST.Elem);
  }
  }
   return;
yyL4:;

/* line 1241 "SemExp.puma" */
  {
/* line 1243 "SemExp.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTE_EMPTY) {
/* line 1246 "SemExp.puma" */
   return;

  }
/* line 1249 "SemExp.puma" */
  {
/* line 1250 "SemExp.puma" */
   failure_protocol (MODULE, "TopIndexList", t);
  }
   return;

;
}

void BeginSemExp ARGS ((void))
{
}

void CloseSemExp ARGS ((void))
{
}
