# include "SemDecls.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 37 "SemDecls.puma" */

# include "Idents.h"
# include "StringM.h"
# include "Types.h"
# include "protocol.h"

# include "DefTable.h"
# include "Objects.h"

# include "TreeOps.h"
# include "Rank.h"
# include "SemExp.h"         /* import SemExp            */
# include "Common.h"         /* import CheckCommonBlock  */
# include "Nesting.h"
# include "Expressions.h"
# include "Semantic.h"
# include "SemPreds.h"

# define MODULE "SemDecls"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySemDecls.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* SemDecls_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemDecls, routine %s failed\n",
  yyFunction);
 SemDecls_Exit ();
}

void SemDeclarations ARGS ((tTree t, tTree current_unit));
static void SemInterface ARGS ((tTree items));
void SemDefinitions ARGS ((tDefinitions t));
static void SemDefinitions1 ARGS ((tDefinitions t));
static void SemDefinitions2 ARGS ((tDefinitions t));
static void SemObjectType ARGS ((tDefinitions o));
static void CorrectType ARGS ((tIdent id, tTree t));
static int GetSize ARGS ((tTree kind));
static void CheckKindValue ARGS ((tTree type, int size));
static void EvaluateKindParam ARGS ((tTree type));
static tTree ComputeSize ARGS ((tTree kind, int default_size));
static void SemCheckAttributes ARGS ((tDefinitions obj));

void SemDeclarations
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree current_unit)
# else
(t, current_unit)
 register tTree t;
 register tTree current_unit;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kDECL_EMPTY:
/* line 71 "SemDecls.puma" */
   return;

  case kDECL_LIST:
/* line 74 "SemDecls.puma" */
  {
/* line 76 "SemDecls.puma" */
   set_protocol_stmt (t->DECL_LIST.Elem);
/* line 78 "SemDecls.puma" */
   SemDeclarations (t->DECL_LIST.Elem, current_unit);
/* line 79 "SemDecls.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kVAR_DECL:
/* line 88 "SemDecls.puma" */
   return;

  case kTYPE_DECL:
/* line 93 "SemDecls.puma" */
   return;

  case kTEMPLATE_DECL:
/* line 98 "SemDecls.puma" */
   return;

  case kPROCESSORS_DECL:
/* line 103 "SemDecls.puma" */
   return;

  case kDIMENSION_DECL:
/* line 108 "SemDecls.puma" */
  {
/* line 110 "SemDecls.puma" */
   error_protocol ("there should be no longer any DIMENSION_DECL");
  }
   return;

  case kPARAMETER_DECL:
/* line 113 "SemDecls.puma" */
   return;

  case kCOMMON_DECL:
/* line 118 "SemDecls.puma" */
 {
  rbool is_main;
  {
/* line 124 "SemDecls.puma" */
   is_main = (current_unit -> Kind == kPROGRAM_DECL);
/* line 126 "SemDecls.puma" */
   CheckCommonBlock (t, is_main);
  }
   return;
 }

  case kNAMELIST_DECL:
/* line 129 "SemDecls.puma" */
   return;

  case kEQV_DECL:
/* line 133 "SemDecls.puma" */
   return;

  case kDATA_DECL:
/* line 137 "SemDecls.puma" */
   return;

  case kSAVE_DECL:
/* line 140 "SemDecls.puma" */
   return;

  case kHPF_SEQUENCE_DECL:
/* line 144 "SemDecls.puma" */
   return;

  case kNOSEQUENCE_DECL:
/* line 147 "SemDecls.puma" */
   return;

  case kEXTERNAL_DECL:
/* line 150 "SemDecls.puma" */
   return;

  case kINTRINSIC_DECL:
/* line 153 "SemDecls.puma" */
   return;

  case kINTENT_DECL:
/* line 156 "SemDecls.puma" */
   return;

  case kPUBLIC_DECL:
/* line 159 "SemDecls.puma" */
   return;

  case kPRIVATE_DECL:
/* line 162 "SemDecls.puma" */
   return;

  case kALLOCATABLE_DECL:
/* line 165 "SemDecls.puma" */
   return;

  case kPOINTER_DECL:
/* line 168 "SemDecls.puma" */
   return;

  case kTARGET_DECL:
/* line 171 "SemDecls.puma" */
   return;

  case kIMPLICIT_DECL:
/* line 174 "SemDecls.puma" */
   return;

  case kDISTRIBUTE_DECL:
/* line 179 "SemDecls.puma" */
  {
/* line 181 "SemDecls.puma" */
   SemTopology (t->DISTRIBUTE_DECL.TARGET);
  }
   return;

  case kRANGE_DECL:
/* line 184 "SemDecls.puma" */
   return;

  case kOPTIONAL_DECL:
/* line 187 "SemDecls.puma" */
   return;

  case kSHARED_DECL:
/* line 190 "SemDecls.puma" */
   return;

  case kSHADOW_DECL:
/* line 193 "SemDecls.puma" */
   return;

  case kTRACE_DECL:
/* line 196 "SemDecls.puma" */
   return;

  case kNODSP_DECL:
/* line 199 "SemDecls.puma" */
   return;

  case kTREE_DECL:
/* line 202 "SemDecls.puma" */
   return;

  case kSELECT_DECL:
/* line 205 "SemDecls.puma" */
   return;

  case kPASS_BY_DECL:
/* line 208 "SemDecls.puma" */
   return;

  case kLAYOUT_DECL:
/* line 211 "SemDecls.puma" */
   return;

  case kDYNAMIC_DECL:
/* line 214 "SemDecls.puma" */
   return;

  case kINHERIT_DECL:
/* line 217 "SemDecls.puma" */
   return;

  case kALIGN_DECL:
/* line 222 "SemDecls.puma" */
   return;

  case kSTMT_FUNC_DECL:
/* line 225 "SemDecls.puma" */
   return;

  case kINTERFACE_DECL:
  if (t->INTERFACE_DECL.SPEC->Kind == kNO_GENERIC_SPEC) {
/* line 229 "SemDecls.puma" */
  {
/* line 231 "SemDecls.puma" */
   SemInterface (t->INTERFACE_DECL.ITEMS);
  }
   return;

  }
/* line 234 "SemDecls.puma" */
 {
  tDefinitions Obj;
  {
/* line 238 "SemDecls.puma" */
   Obj = GetLocalObject (GetGenericId (t->INTERFACE_DECL.SPEC));
/* line 240 "SemDecls.puma" */
   OpenScope (Obj->GenericObject.Interfaces);
/* line 241 "SemDecls.puma" */
   SemInterface (t->INTERFACE_DECL.ITEMS);
/* line 242 "SemDecls.puma" */
   CloseScope ();
  }
   return;
 }

  case kUSE_DECL:
/* line 267 "SemDecls.puma" */
   return;

  case kONLY_USE_DECL:
/* line 270 "SemDecls.puma" */
   return;

  case kFORMAT_DECL:
/* line 273 "SemDecls.puma" */
   return;

  }

/* line 276 "SemDecls.puma" */
  {
/* line 277 "SemDecls.puma" */
   failure_protocol ("SemDecls", "SemDeclarations", t);
  }
   return;

;
}

static void SemInterface
# if defined __STDC__ | defined __cplusplus
(register tTree items)
# else
(items)
 register tTree items;
# endif
{
 yyRecursion:
  if (items->Kind == kUNIT_EMPTY) {
/* line 288 "SemDecls.puma" */
   return;

  }
  if (items->Kind == kUNIT_LIST) {
/* line 291 "SemDecls.puma" */
  {
/* line 293 "SemDecls.puma" */
   SemInterface (items->UNIT_LIST.Elem);
/* line 294 "SemDecls.puma" */
   items = items->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
  if (items->Kind == kPROC_DECL) {
/* line 297 "SemDecls.puma" */
  {
/* line 299 "SemDecls.puma" */
   NestOpenUnit (items);
/* line 300 "SemDecls.puma" */
   SemDefinitions (GetCurrentScope ());
/* line 301 "SemDecls.puma" */
   Semantic (items->PROC_DECL.PROC_BODY);
/* line 302 "SemDecls.puma" */
   NestCloseUnit (items);
  }
   return;

  }
  if (items->Kind == kFUNC_DECL) {
/* line 305 "SemDecls.puma" */
  {
/* line 307 "SemDecls.puma" */
   NestOpenUnit (items);
/* line 308 "SemDecls.puma" */
   SemDefinitions (GetCurrentScope ());
/* line 309 "SemDecls.puma" */
   Semantic (items->FUNC_DECL.FUNC_BODY);
/* line 310 "SemDecls.puma" */
   NestCloseUnit (items);
  }
   return;

  }
  if (items->Kind == kMODULE_PROC_DECL) {
/* line 313 "SemDecls.puma" */
   return;

  }
/* line 316 "SemDecls.puma" */
  {
/* line 318 "SemDecls.puma" */
   failure_protocol (MODULE, "SemInterface", items);
  }
   return;

;
}

void SemDefinitions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
/* line 329 "SemDecls.puma" */
  {
/* line 331 "SemDecls.puma" */
   SemDefinitions1 (t);
/* line 332 "SemDecls.puma" */
   SemDefinitions2 (t);
  }
   return;

;
}

static void SemDefinitions1
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
 yyRecursion:
  if (t->Kind == kENTRY_LIST) {
/* line 348 "SemDecls.puma" */
  {
/* line 352 "SemDecls.puma" */
   SemDefinitions1 (t->ENTRY_LIST.Next);
/* line 353 "SemDecls.puma" */
   set_protocol_stmt (t->ENTRY_LIST.Elem->Object.decl);
/* line 354 "SemDecls.puma" */
   t = t->ENTRY_LIST.Elem;
   goto yyRecursion;
  }

  }
  if (t->Kind == kENTRY_EMPTY) {
/* line 357 "SemDecls.puma" */
   return;

  }
/* line 360 "SemDecls.puma" */
  {
/* line 362 "SemDecls.puma" */
   if (! ((IsUsedObject (t, GetCurrentUnitObject ())))) goto yyL3;
  }
   return;
yyL3:;

  if (t->Kind == kVarObject) {
  if (t->VarObject.Kind->Kind == kVarParameter) {
/* line 365 "SemDecls.puma" */
  {
/* line 367 "SemDecls.puma" */
 t->VarObject.Kind->VarParameter.Val = SemExpression (t->VarObject.Kind->VarParameter.Val);
     if (!InitializationExpr (t->VarObject.Kind->VarParameter.Val))
       error_protocol ("expression in PARAMETER must be initialization expr");
   
  }
   return;

  }
  if (t->VarObject.Kind->Kind == kVarDummy) {
/* line 373 "SemDecls.puma" */
  {
/* line 375 "SemDecls.puma" */
   if (! ((! IsVarAssumedShape (t)))) goto yyL5;
  {
/* line 376 "SemDecls.puma" */
   if (! ((VarRank (t) > 0))) goto yyL5;
  {
/* line 377 "SemDecls.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL5;
  {
/* line 378 "SemDecls.puma" */
   if (! ((! IsF77Unit (GetCurrentUnit ())))) goto yyL5;
  {
/* line 380 "SemDecls.puma" */
   error_protocol ("HPF_LOCAL only with assumed shape args");
  }
  }
  }
  }
  }
   return;
yyL5:;

  }
  }
;
}

static void SemDefinitions2
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
/* line 391 "SemDecls.puma" */

char msg[100];
char name[80];

 yyRecursion:

  switch (t->Kind) {
  case kENTRY_LIST:
/* line 396 "SemDecls.puma" */
  {
/* line 398 "SemDecls.puma" */
   set_protocol_stmt (t->ENTRY_LIST.Elem->Object.decl);
/* line 400 "SemDecls.puma" */
   SemObjectType (t->ENTRY_LIST.Elem);
/* line 403 "SemDecls.puma" */
   SemCheckAttributes (t->ENTRY_LIST.Elem);
/* line 405 "SemDecls.puma" */
   SemDefinitions2 (t->ENTRY_LIST.Elem);
/* line 406 "SemDecls.puma" */
   t = t->ENTRY_LIST.Next;
   goto yyRecursion;
  }

  case kENTRY_EMPTY:
/* line 409 "SemDecls.puma" */
   return;

  case kVarObject:
  if (t->VarObject.decl->Kind == kVAR_DECL) {
/* line 412 "SemDecls.puma" */
  {
/* line 414 "SemDecls.puma" */
   obj_protocol ("this object is local here : ", t);
  }
   return;

  }
  if (t->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 417 "SemDecls.puma" */
  {
/* line 419 "SemDecls.puma" */
   obj_protocol ("this object is dummy here : ", t);
  }
   return;

  }
  break;
  case kTemplateObject:
  if (t->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
/* line 422 "SemDecls.puma" */
   return;

  }
  break;
  case kTopologyObject:
  if (t->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
/* line 428 "SemDecls.puma" */
  {
/* line 430 "SemDecls.puma" */
 if (t->TopologyObject.target != NoTree)
     { t->TopologyObject.target = SemExpression (t->TopologyObject.target); 
       if (!ScalarIntExpr (t->TopologyObject.target))
         error_protocol ("target in MAP directive must be scalar int expr");
     }
  
  }
   return;

  }
  if (t->TopologyObject.decl->Kind == kSUB_PROCS_DECL) {
/* line 438 "SemDecls.puma" */
   return;

  }
  break;
  case kFuncObject:
  if (t->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 443 "SemDecls.puma" */
   return;

  }
  if (t->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 448 "SemDecls.puma" */
   return;

  }
  if (t->FuncObject.decl->Kind == kINTRINSIC_DECL) {
/* line 453 "SemDecls.puma" */
   return;

  }
  break;
  case kProcObject:
  if (t->ProcObject.decl->Kind == kPROGRAM_DECL) {
/* line 458 "SemDecls.puma" */
  {
/* line 460 "SemDecls.puma" */
   obj_error_protocol ("call of main program", t);
  }
   return;

  }
  if (t->ProcObject.decl->Kind == kPROC_DECL) {
/* line 463 "SemDecls.puma" */
   return;

  }
  if (t->ProcObject.decl->Kind == kINTRINSIC_DECL) {
/* line 466 "SemDecls.puma" */
   return;

  }
  break;
  }

  if (t->Kind == kExternalObject) {
/* line 469 "SemDecls.puma" */
   return;

  }
  if (t->Kind == kBlockObject) {
/* line 472 "SemDecls.puma" */
   return;

  }
  if (t->Kind == kTypeObject) {
/* line 475 "SemDecls.puma" */
  {
/* line 477 "SemDecls.puma" */
   if (! ((t->TypeObject.Components == NoEntries))) goto yyL16;
  {
/* line 479 "SemDecls.puma" */
   GetString (t->TypeObject.Ident, name);
/* line 481 "SemDecls.puma" */
 sprintf (msg, "type %d has not been defined", name);
       error_protocol (msg);
     
  }
  }
   return;
yyL16:;

/* line 486 "SemDecls.puma" */
  {
/* line 488 "SemDecls.puma" */
   SemDefinitions (t->TypeObject.Components);
  }
   return;

  }
  if (t->Kind == kNameListObject) {
/* line 491 "SemDecls.puma" */
   return;

  }
  if (t->Kind == kGenericObject) {
/* line 494 "SemDecls.puma" */
   return;

  }
  if (Definitions_IsType (t, kObject)) {
/* line 497 "SemDecls.puma" */
  {
/* line 499 "SemDecls.puma" */
   tree_error_protocol ("Unknown/Illegal object in Semantic Analysis : ", t->Object.decl);
  }
   return;

  }
/* line 502 "SemDecls.puma" */
  {
/* line 503 "SemDecls.puma" */
   failure_protocol (MODULE, "SemDefinitions", NoTree);
  }
   return;

;
}

static void SemObjectType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions o)
# else
(o)
 register tDefinitions o;
# endif
{
  if (o->Kind == kVarObject) {
  if (o->VarObject.decl->Kind == kVAR_DECL) {
/* line 517 "SemDecls.puma" */
  {
/* line 519 "SemDecls.puma" */
   CorrectType (o->VarObject.Ident, o->VarObject.decl->VAR_DECL.VAL);
  }
   return;

  }
  if (o->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 522 "SemDecls.puma" */
  {
/* line 524 "SemDecls.puma" */
   CorrectType (o->VarObject.Ident, o->VarObject.decl->VAR_PARAM_DECL.VAL);
  }
   return;

  }
  }
  if (o->Kind == kTemplateObject) {
  if (o->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
/* line 527 "SemDecls.puma" */
  {
/* line 529 "SemDecls.puma" */
   CorrectType (o->TemplateObject.Ident, o->TemplateObject.decl->TEMPLATE_DECL.DIMENSIONS);
  }
   return;

  }
  }
  if (o->Kind == kTopologyObject) {
  if (o->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
/* line 532 "SemDecls.puma" */
  {
/* line 534 "SemDecls.puma" */
   CorrectType (o->TopologyObject.Ident, o->TopologyObject.decl->PROCESSORS_DECL.DIMENSIONS);
  }
   return;

  }
  }
  if (o->Kind == kFuncObject) {
  if (o->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 537 "SemDecls.puma" */
   return;

  }
  if (o->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 542 "SemDecls.puma" */
  {
/* line 544 "SemDecls.puma" */
   CorrectType (o->FuncObject.Ident, o->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE);
  }
   return;

  }
  }
;
}

static void CorrectType
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree t)
# else
(id, t)
 register tIdent id;
 register tTree t;
# endif
{
/* line 555 "SemDecls.puma" */

char string[50], msg [100];

 yyRecursion:

  switch (t->Kind) {
  case kALIGN_TYPE:
/* line 559 "SemDecls.puma" */
   return;

  case kDUMMY_TYPE:
/* line 564 "SemDecls.puma" */
  {
/* line 566 "SemDecls.puma" */
   GetString (id, string);
/* line 567 "SemDecls.puma" */
   sprintf (msg, "%s undeclared (has no type)", string);
/* line 568 "SemDecls.puma" */
   error_protocol (msg);
  }
   return;

  case kINTEGER_TYPE:
/* line 571 "SemDecls.puma" */
  {
/* line 573 "SemDecls.puma" */
   EvaluateKindParam (t);
/* line 574 "SemDecls.puma" */
   CheckKindValue (t, GetSize (t->INTEGER_TYPE.SIZE));
  }
   return;

  case kREAL_TYPE:
/* line 577 "SemDecls.puma" */
  {
/* line 579 "SemDecls.puma" */
   EvaluateKindParam (t);
/* line 580 "SemDecls.puma" */
   CheckKindValue (t, GetSize (t->REAL_TYPE.SIZE));
  }
   return;

  case kBOOLEAN_TYPE:
/* line 583 "SemDecls.puma" */
  {
/* line 585 "SemDecls.puma" */
   EvaluateKindParam (t);
/* line 586 "SemDecls.puma" */
   CheckKindValue (t, GetSize (t->BOOLEAN_TYPE.SIZE));
  }
   return;

  case kCOMPLEX_TYPE:
/* line 589 "SemDecls.puma" */
  {
/* line 591 "SemDecls.puma" */
   EvaluateKindParam (t);
/* line 592 "SemDecls.puma" */
   CheckKindValue (t, GetSize (t->COMPLEX_TYPE.SIZE));
  }
   return;

  case kSTRING_TYPE:
  if (t->STRING_TYPE.LENGTH->Kind == kDUMMY_EXP) {
/* line 595 "SemDecls.puma" */
   return;

  }
/* line 598 "SemDecls.puma" */
  {
/* line 600 "SemDecls.puma" */
 t->STRING_TYPE.LENGTH = ComputeSize (t->STRING_TYPE.LENGTH, -1); 
  }
   return;

  case kARRAY_TYPE:
/* line 603 "SemDecls.puma" */
  {
/* line 604 "SemDecls.puma" */
   CorrectType (id, t->ARRAY_TYPE.ARRAY_INDEX_TYPES);
/* line 605 "SemDecls.puma" */
   t = t->ARRAY_TYPE.ARRAY_COMP_TYPE;
   goto yyRecursion;
  }

  case kSHAPE_LIST:
/* line 608 "SemDecls.puma" */
  {
/* line 609 "SemDecls.puma" */
   CorrectType (id, t->SHAPE_LIST.Elem);
/* line 610 "SemDecls.puma" */
   t = t->SHAPE_LIST.Next;
   goto yyRecursion;
  }

  case kSHAPE_EMPTY:
/* line 613 "SemDecls.puma" */
   return;

  case kEXPLICIT_SHAPE:
/* line 616 "SemDecls.puma" */
  {
/* line 618 "SemDecls.puma" */
 t->EXPLICIT_SHAPE.LOWER = SemExpression (t->EXPLICIT_SHAPE.LOWER);
      if (!ScalarIntExpr (t->EXPLICIT_SHAPE.LOWER))
         { error_protocol ("array bound must be scalar integer expression");
           tree_protocol  ("illegal lower bound : ", t->EXPLICIT_SHAPE.LOWER);
         }
      t->EXPLICIT_SHAPE.UPPER = SemExpression (t->EXPLICIT_SHAPE.UPPER);
      if (!ScalarIntExpr (t->EXPLICIT_SHAPE.UPPER))
        {  error_protocol ("array bound must be scalar integer expression");
           tree_protocol  ("illegal upper bound : ", t->EXPLICIT_SHAPE.UPPER);
         }
    
  }
   return;

  case kSHAPE_SPEC:
  case kASSUMED_SHAPE:
  case kDEFERRED_SHAPE:
  case kASSUMED_SIZE:
/* line 631 "SemDecls.puma" */
   return;

  case kTYPE_ID:
/* line 634 "SemDecls.puma" */
   return;

  }

;
}

static int GetSize
# if defined __STDC__ | defined __cplusplus
(register tTree kind)
# else
(kind)
 register tTree kind;
# endif
{
  if (kind->Kind == kCONST_EXP) {
  if (kind->CONST_EXP.C->Kind == kINT_CONSTANT) {
/* line 645 "SemDecls.puma" */
   return kind->CONST_EXP.C->INT_CONSTANT.value;

  }
  }
 yyAbort ("GetSize");
 { int yyDummy; return yyDummy; }
}

static void CheckKindValue
# if defined __STDC__ | defined __cplusplus
(register tTree type, register int size)
# else
(type, size)
 register tTree type;
 register int size;
# endif
{
/* line 649 "SemDecls.puma" */
 char msg[100]; 
  if (type->Kind == kINTEGER_TYPE) {
/* line 651 "SemDecls.puma" */
  {
/* line 653 "SemDecls.puma" */
   if (! ((size == default_int_size))) goto yyL1;
  }
   return;
yyL1:;

/* line 656 "SemDecls.puma" */
  {
/* line 658 "SemDecls.puma" */
   error_protocol ("illegal INTEGER type");
/* line 659 "SemDecls.puma" */
   sprintf (msg, "Only INTEGER*%d allowed", default_int_size);
/* line 660 "SemDecls.puma" */
   print_protocol (msg);
  }
   return;

  }
  if (type->Kind == kBOOLEAN_TYPE) {
/* line 663 "SemDecls.puma" */
  {
/* line 664 "SemDecls.puma" */
   if (! ((size == 1))) goto yyL3;
  }
   return;
yyL3:;

/* line 667 "SemDecls.puma" */
  {
/* line 668 "SemDecls.puma" */
   if (! ((size == default_int_size))) goto yyL4;
  }
   return;
yyL4:;

/* line 671 "SemDecls.puma" */
  {
/* line 673 "SemDecls.puma" */
   error_protocol ("illegal LOGICAL type");
/* line 674 "SemDecls.puma" */
   sprintf (msg, "Only LOGICAL*1 or LOGICAL*%d allowed", default_int_size);
/* line 675 "SemDecls.puma" */
   print_protocol (msg);
  }
   return;

  }
  if (type->Kind == kREAL_TYPE) {
/* line 678 "SemDecls.puma" */
  {
/* line 679 "SemDecls.puma" */
   if (! ((size == default_real_size))) goto yyL6;
  }
   return;
yyL6:;

/* line 682 "SemDecls.puma" */
  {
/* line 683 "SemDecls.puma" */
   if (! ((size == 2 * default_real_size))) goto yyL7;
  }
   return;
yyL7:;

/* line 686 "SemDecls.puma" */
  {
/* line 688 "SemDecls.puma" */
   error_protocol ("illegal REAL type");
/* line 689 "SemDecls.puma" */
   sprintf (msg, "Only REAL*%d or REAL*%d allowed", default_real_size, 2 * default_real_size);
/* line 691 "SemDecls.puma" */
   print_protocol (msg);
  }
   return;

  }
  if (type->Kind == kCOMPLEX_TYPE) {
/* line 694 "SemDecls.puma" */
  {
/* line 695 "SemDecls.puma" */
   if (! ((size == 2 * default_real_size))) goto yyL9;
  }
   return;
yyL9:;

/* line 698 "SemDecls.puma" */
  {
/* line 699 "SemDecls.puma" */
   if (! ((size == 4 * default_real_size))) goto yyL10;
  }
   return;
yyL10:;

/* line 702 "SemDecls.puma" */
  {
/* line 703 "SemDecls.puma" */
   sprintf (msg, "Only COMPLEX*%d or COMPLEX*%d allowed", 2 * default_real_size, 4 * default_real_size);
/* line 705 "SemDecls.puma" */
   print_protocol (msg);
  }
   return;

  }
;
}

static void EvaluateKindParam
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
  if (type->Kind == kREAL_TYPE) {
/* line 722 "SemDecls.puma" */
  {
/* line 723 "SemDecls.puma" */
 type->REAL_TYPE.SIZE = ComputeSize (type->REAL_TYPE.SIZE, default_real_size); 
  }
   return;

  }
  if (type->Kind == kINTEGER_TYPE) {
/* line 726 "SemDecls.puma" */
  {
/* line 727 "SemDecls.puma" */
 type->INTEGER_TYPE.SIZE = ComputeSize (type->INTEGER_TYPE.SIZE, default_int_size); 
  }
   return;

  }
  if (type->Kind == kCOMPLEX_TYPE) {
/* line 730 "SemDecls.puma" */
  {
/* line 731 "SemDecls.puma" */
 type->COMPLEX_TYPE.SIZE = ComputeSize (type->COMPLEX_TYPE.SIZE, 2*default_real_size); 
  }
   return;

  }
  if (type->Kind == kBOOLEAN_TYPE) {
/* line 734 "SemDecls.puma" */
  {
/* line 735 "SemDecls.puma" */
 type->BOOLEAN_TYPE.SIZE = ComputeSize (type->BOOLEAN_TYPE.SIZE, default_int_size); 
  }
   return;

  }
;
}

static tTree ComputeSize
# if defined __STDC__ | defined __cplusplus
(register tTree kind, register int default_size)
# else
(kind, default_size)
 register tTree kind;
 register int default_size;
# endif
{
  if (kind->Kind == kCONST_EXP) {
  if (kind->CONST_EXP.C->Kind == kINT_CONSTANT) {
/* line 746 "SemDecls.puma" */
   return kind;

  }
  }
  if (kind->Kind == kDUMMY_EXP) {
/* line 750 "SemDecls.puma" */
 {
  register tTree yyV1;
   yyALLOC (tTree,Tree_PoolFreePtr,Tree_PoolStartPtr,
    Tree_Alloc,yINT_CONSTANT,MakeTree,yyV1,kINT_CONSTANT,Tree_InitHead)
    yyV1->INT_CONSTANT.value = default_size;
   return mCONST_EXP (yyV1);
 }

  }
/* line 754 "SemDecls.puma" */
 {
  register tTree yyV1;
  rbool found;
  int val;
  {
/* line 759 "SemDecls.puma" */
   GetIntConstValue (kind, & found, & val);
/* line 761 "SemDecls.puma" */
 if (!found)
       { val = default_size;
         error_protocol ("kind of type must be evaluated at compile time");
         tree_protocol ("kind expression is : ", kind);
         WriteTree (stdout, kind);
       }
     else if (val < 0)
       { error_protocol ("kind not suppported");
         tree_protocol  ("kind value is : ", kind);
         val = default_size;
       }
   
  }
   yyALLOC (tTree,Tree_PoolFreePtr,Tree_PoolStartPtr,
    Tree_Alloc,yINT_CONSTANT,MakeTree,yyV1,kINT_CONSTANT,Tree_InitHead)
    yyV1->INT_CONSTANT.value = val;
   return mCONST_EXP (yyV1);
 }

}

static void SemCheckAttributes
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 792 "SemDecls.puma" */
 {
  tTree dimension;
  {
/* line 794 "SemDecls.puma" */
   if (! ((obj->VarObject.arr_kind == arr_pointer))) goto yyL1;
  {
/* line 798 "SemDecls.puma" */
   dimension = GetObjDimension (obj);
/* line 800 "SemDecls.puma" */
 if (dimension)

         { if (!IsDeferredShape (dimension))

              error_protocol ("POINTER array must have deferred shape");
         }

    
/* line 809 "SemDecls.puma" */
   goto yyL1;
  }
  }
 }
yyL1:;

/* line 812 "SemDecls.puma" */
 {
  tTree dimension;
  {
/* line 814 "SemDecls.puma" */
   if (! ((obj->VarObject.arr_kind == arr_allocatable))) goto yyL2;
  {
/* line 818 "SemDecls.puma" */
   dimension = GetObjDimension (obj);
/* line 820 "SemDecls.puma" */
 if (dimension)

       { if (!IsDeferredShape (dimension))

            error_protocol ("ALLOCATABLE array must have deferred shape");
       }

       else

         error_protocol ("ALLOCATABLE attribute can only be used for arrays");
    
/* line 832 "SemDecls.puma" */
   goto yyL2;
  }
  }
 }
yyL2:;

  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 839 "SemDecls.puma" */
 {
  tTree dimension;
  {
/* line 841 "SemDecls.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.function != NoTree))) goto yyL3;
  {
/* line 845 "SemDecls.puma" */
   dimension = GetObjDimension (obj);
/* line 847 "SemDecls.puma" */
   if (! ((dimension))) goto yyL3;
  {
/* line 848 "SemDecls.puma" */
   if (! ((obj->VarObject.arr_kind != arr_pointer))) goto yyL3;
  {
/* line 850 "SemDecls.puma" */
 if (IsExplicitShape (dimension))

         obj->VarObject.arr_kind =  arr_explicit_shape;

       else 

         error_protocol 
            ("function result (no POINTER) must be explicitly shaped");
     
/* line 860 "SemDecls.puma" */
   goto yyL3;
  }
  }
  }
  }
 }
yyL3:;

/* line 867 "SemDecls.puma" */
 {
  tTree dimension;
  {
/* line 871 "SemDecls.puma" */
   dimension = GetObjDimension (obj);
/* line 873 "SemDecls.puma" */
   if (! ((dimension))) goto yyL4;
  {
/* line 874 "SemDecls.puma" */
   if (! ((obj->VarObject.arr_kind != arr_pointer))) goto yyL4;
  {
/* line 876 "SemDecls.puma" */
 if (IsAssumedShape (dimension))

         obj->VarObject.arr_kind =  arr_assumed_shape;

       else if (IsExplicitShape (dimension))

         obj->VarObject.arr_kind =  arr_explicit_shape;

       else if (IsAssumedSize (dimension))

         obj->VarObject.arr_kind = arr_assumed_size;

       else

         error_protocol ("illegal dimensions for dummy array");
     
/* line 893 "SemDecls.puma" */
   goto yyL4;
  }
  }
  }
 }
yyL4:;

  }
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 900 "SemDecls.puma" */
 {
  tTree dimension;
  {
/* line 904 "SemDecls.puma" */
   dimension = GetObjDimension (obj);
/* line 906 "SemDecls.puma" */
   if (! ((dimension))) goto yyL5;
  {
/* line 908 "SemDecls.puma" */
 if (IsExplicitShape (dimension))

       { rbool found;
         int  val;

         GetExplicitShapeSize (dimension, &found, &val);

         if (found)
             obj->VarObject.arr_kind =  arr_fixed_size;
           else
             obj->VarObject.arr_kind =  arr_automatic;
       }

       else if (IsDeferredShape (dimension))

        { if ((obj->VarObject.arr_kind != arr_allocatable) && (obj->VarObject.arr_kind != arr_pointer))

           { serious_warning_protocol (
                "deferred shape, but no POINTER/ALLOCATABLE attribute");
 
             obj->VarObject.arr_kind = arr_allocatable;
           }

        }

       else if (IsAssumedSize (dimension))

         error_protocol ("assumed size not allowed for non dummy arrays");

       else if (IsAssumedShape (dimension))

         error_protocol ("assumed shape not allowed for non dummy arrays");

       else

         error_protocol ("illegal dimensions for array");
     
/* line 946 "SemDecls.puma" */
   goto yyL5;
  }
  }
 }
yyL5:;

  }
  if (obj->VarObject.Kind->Kind == kVarCommon) {
/* line 953 "SemDecls.puma" */
 {
  tTree dimension;
  {
/* line 957 "SemDecls.puma" */
   dimension = GetObjDimension (obj);
/* line 959 "SemDecls.puma" */
   if (! ((dimension))) goto yyL6;
  {
/* line 961 "SemDecls.puma" */
 if (IsExplicitShape (dimension))

       { rbool found;
         int  val;

         GetExplicitShapeSize (dimension, &found, &val);

         if (!found)

            error_protocol ("size of COMMON array unknown");

         obj->VarObject.arr_kind = arr_fixed_size;

       }

      else

       error_protocol ("COMMON array must be explicitly shaped");
     
/* line 981 "SemDecls.puma" */
   goto yyL6;
  }
  }
 }
yyL6:;

  }
  }
;
}

void BeginSemDecls ARGS ((void))
{
}

void CloseSemDecls ARGS ((void))
{
}
