# include "SemCalling.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 38 "SemCalling.puma" */


# include <string.h>

# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "Objects.h"     /* GetReferenceObject */
# include "Types.h"       /* type_rec, GetTypeRecord */
# include "Rank.h"
# include "TreeOps.h"
# include "DefTable.h" 
# include "ShowDefs.h"
# include "Intrinsics.h"

# include "Transform.h"

# include "SemIntr.h"
# include "SemExp.h"
# include "SemPreds.h"

# define MODULE "SemCalling"

# undef DEBUG

static tTree MoveParameter ();    /* needed to define static function */
 
static int  param_counter = 0;

# define KIND_UNKNOWN  0
# define KIND_VAR      1
# define KIND_FUNC     2
# define KIND_PROC     3
# define KIND_EXT      4

/* values needed for optional parameters */

static rbool   is_mandatory  [MAX_DUMMIES];
static tIdent  param_name    [MAX_DUMMIES];
static tTree   param_val     [MAX_DUMMIES];

/* values needed for type checking */

typedef rbool check_routine ();

static tObject param_dummy [MAX_DUMMIES];  /* VAR, DSP, FUNC, PROC, EXT    */
static int  param_kind     [MAX_DUMMIES];  /* VAR, DSP, FUNC, PROC, EXT    */
static int  param_intent   [MAX_DUMMIES];  /* IN, OUT, INOUT, <unknown>    */
static int  param_layout   [MAX_DUMMIES];  /* LAYOUT (F77_ARRAY), ...      */
static int  param_pass_by  [MAX_DUMMIES];  /* PASS_BY ('*', HANDLE)        */
static int  param_pointer  [MAX_DUMMIES];  /* POINTER attribute of dummy   */
static int  param_trace    [MAX_DUMMIES];  /* TRACE attribute of dummy     */
static int  param_dynamic  [MAX_DUMMIES];  /* DYNAMIC attribute of dummy   */
static int  param_sequence [MAX_DUMMIES];  /* SEQUENCE attribute of dummy  */
static int  param_rank     [MAX_DUMMIES];  /* rank of dummy argument       */
static int  param_type     [MAX_DUMMIES];  /* type of dummy argument       */
static int  param_size     [MAX_DUMMIES];  /* size of dummy argument       */

static check_routine *param_check [MAX_DUMMIES];  /* check for intrinsic arg */

       /*************************************************
       *                                                *
       *  init_parameters ()                            *
       *                                                *
       *************************************************/

static void init_parameters () 

{ 
  param_counter = 0;
}

       /*************************************************
       *                                                *
       *  set_no_interface ()                           *
       *  no_interface ()         ! no interface avail. *
       *                                                *
       *************************************************/

static void set_no_interface () 

{ 
  param_counter = -1;
}

static rbool no_interface ()

{
  return (param_counter == -1);

} /* no_interface */

       /*************************************************
       *                                                *
       *  set_intrinsic_parameter (...)                 *
       *                                                *
       *************************************************/

static void set_intrinsic_parameter (name, mandatory, kind, check, rank)

char *name;
rbool mandatory;
int  kind;
check_routine check;
int  rank;

{ param_name   [param_counter] = MakeIdent (name, strlen(name));
  param_dummy  [param_counter] = NoObject;
  is_mandatory [param_counter] = mandatory;
  param_val    [param_counter] = NoTree;

  param_kind     [param_counter] = KIND_UNKNOWN;
  param_intent   [param_counter] = kind;
  param_layout   [param_counter] = kDEFAULT_LAYOUT;
  param_pass_by  [param_counter] = kDEFAULT_PASS_BY;
  param_pointer  [param_counter] = kNOT_POINTER;
  param_trace    [param_counter] = 0;
  param_dynamic  [param_counter] = kHPF_NOT_DYNAMIC; /* never in intrinsic */
  param_rank     [param_counter] = rank; 
  param_sequence [param_counter] = 0;     /* no sequence association */

  /* for type make difference between string and other arguments */

  if (check == StringExpr)
    param_type   [param_counter] = kSTRING_TYPE;
   else
    param_type   [param_counter] = kDUMMY_TYPE;

  param_size   [param_counter] = -1;           /* every size is allowed */
  param_check  [param_counter] = check;

  param_counter += 1;

#ifdef DEBUG
  printf ("set intrinsic parameter %d, mand = %d, rank = %d\n",
           param_counter, mandatory, rank);
#endif

} /* set_intrinsic_parameter */

       /*************************************************
       *                                                *
       *  set_user_parameter (...)                      *
       *                                                *
       *************************************************/

static void set_user_parameter (name, dummy, mandatory, 
                                kind, intent, layout, pass_by, pointer, trace, 
                                dynamic, sequence, rank, type, size)

tIdent  name;
tObject dummy;
rbool   mandatory;
int kind, intent, layout, pass_by, pointer, trace, 
    dynamic, sequence, rank, type, size;

{ param_name   [param_counter] = name;
  param_dummy  [param_counter] = dummy;
  is_mandatory [param_counter] = mandatory;
  param_val    [param_counter] = NoTree;

  param_kind     [param_counter] = kind;
  param_intent   [param_counter] = intent;
  param_layout   [param_counter] = layout;
  param_pass_by  [param_counter] = pass_by;
  param_pointer  [param_counter] = pointer; 
  param_trace    [param_counter] = trace;
  param_dynamic  [param_counter] = dynamic;
  param_sequence [param_counter] = sequence;
  param_rank     [param_counter] = rank;
  param_type     [param_counter] = type;
  param_size     [param_counter] = size;

  param_counter += 1;

#ifdef DEBUG
  printf ("set user param %d, mand = %d, rank = %d, kind = %d, intent =%d\n",
           param_counter, mandatory, rank, kind, intent);
#endif

} /* set_user_parameter */


static void get_type_string (tstr, type_kind)

char *tstr;
int type_kind;

{ switch (type_kind) {

  case kINTEGER_TYPE : sprintf (tstr, "INTEGER"); break;
  case kREAL_TYPE    : sprintf (tstr, "REAL"); break;
  case kBOOLEAN_TYPE : sprintf (tstr, "LOGICAL"); break;
  case kCOMPLEX_TYPE : sprintf (tstr, "COMPLEX"); break;
  case kSTRING_TYPE  : sprintf (tstr, "CHARACTER"); break;
  case kTYPE_ID      : sprintf (tstr, "TYPE"); break;
  case kDUMMY_TYPE   : sprintf (tstr, "<dummy>"); break;
  default            : sprintf (tstr, "<unknown>"); break;

  } /* switch */

} /* get_type_string */
 
       /*************************************************
       *                                                *
       *  FindNamedPosition (name => flag, pos)         *
       *                                                *
       *  flag = 0            parameter not available   *
       *  flag = 2   pos      parameter already set     *
       *  flag = 1   pos      parameter at position pos *
       *                                                *
       *************************************************/
 
static void FindNamedPosition (name, flag, pos)

tIdent name;
int *flag, *pos;
 
{ int found, i;
 
  found = 0;
  i     = 0;
 
  while ( (!found) && (i<param_counter))
   { found = (param_name[i] == name);
     if (!found) i++;
   }
 
  if (!found) 
     *flag = 0;
    else if (param_val[i] != NoTree)
     *flag = 2;
    else
     *flag = 1;

  *pos = i;
 
} /* FindNamedPosition */

       /*************************************************
       *                                                *
       *  PutNamedParameter (tIdent name, tTree val)    *
       *                                                *
       *************************************************/
 
static void PutNamedParameter (name, val)
tIdent name;
tTree  val;
 
{ int found, pos;
  char string[100], msg[100];
 
  FindNamedPosition (name, &found, &pos);

  if (found == 0)
   { GetString (name, string);
     sprintf (msg, "formal parameter %s does not exist", string);
     error_protocol (msg);
   }
  else if (found > 1)
   { GetString (name, string);
     sprintf (msg, "formal parameter %s specified more than once", string);
     error_protocol (msg);
   }
  else
     param_val[pos] = val;

} /* PutNamedParameter */
 
       /*************************************************
       *                                                *
       *  SetNamedParameter (tIdent name, tTree val)    *
       *                                                *
       *  - returns rtrue if it was okay                 *
       *                                                *
       *************************************************/

static rbool SetNamedParameter (name, val)

tIdent name;
tTree  val;

{ int found, pos;
 
  FindNamedPosition (name, &found, &pos);
 
  if (found == 1)
     { param_val[pos] = val;
       return (rtrue);
     }
   else
     return (rfalse);

} /* SetNamedParameter */

       /*************************************************
       *                                                *
       *  FindFreePosition (name => pos)                *
       *                                                *
       *  pos >= 0  free position found                 *
       *                                                *
       *************************************************/
 
static void FindFreePosition (pos)
 
int *pos;
 
{ int found, i;
 
  i     = 0;
  found = 0;
 
  /* find free position */
 
  while ( (!found) && (i<param_counter))
   { found = (param_val[i] == NoTree);
     if (!found) i++;
   }
 
  *pos = i;
  if (!found) *pos = -1;

} /* FindFreePosition */

       /*************************************************
       *                                                *
       *  PutUnNamedParameter (tTree val)             *
       *                                                *
       *************************************************/
 
static void PutUnNamedParameter (val)
tTree val;
 
{ int pos;
  char msg[100];
 
  FindFreePosition (&pos);
 
  if (pos < 0)
   { sprintf (msg, "too many arguments (max = %d)", param_counter);
     error_protocol (msg);
   }
  else
     param_val[pos] = val;
 
} /* put_unnamed_parameter */

       /*************************************************
       *                                                *
       *  SetUnNamedParameter (tTree val)               *
       *                                                *
       *  - returns rtrue if it was okay                 *
       *                                                *
       *************************************************/
 
static rbool SetUnNamedParameter (val)
 
tTree  val;
 
{ int pos;
 
  FindFreePosition (&pos);
 
  if (pos >= 0)
     { param_val[pos] = val;
       return (rtrue);
     }
   else
     return (rfalse);
 
} /* SetUnNamedParameter */
 
       /*************************************************
       *                                                *
       *  Tree make_new_parameterlist                   *
       *                                                *
       *************************************************/
 
static tTree MakeNewParameterList (old)
 
tTree old;
 
{ tTree new, val;
  int i;
 
  new = old;
 
#ifdef DEBUG
  printf ("MakeNewParameterList, old has %d params, %d params required\n", 
           TreeListLength (old), param_counter);
#endif

  for (i=0; i<param_counter; i++)

    {  val = param_val[i];
       if (val == NoTree) val = mNO_PARAM (param_type[i]);
       new = MoveParameter (new, i, val);
    }

  return (new);
 
} /* MakeNewParameterList */
 


# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySemCalling.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* SemCalling_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemCalling, routine %s failed\n",
  yyFunction);
 SemCalling_Exit ();
}

void SemCalling ARGS ((tTree t));
static void SetInterfaceUse ARGS ((tDefinitions obj));
static void SetUserParamFormals ARGS ((tTree formals, tDefinitions entries));
static int GetDummyKind ARGS ((tDefinitions obj));
static int GetDummyIntent ARGS ((tDefinitions obj));
static int GetDummyLayout ARGS ((tDefinitions obj));
static int GetDummyPassBy ARGS ((tDefinitions obj));
static int GetDummyPointer ARGS ((tDefinitions obj));
static int GetDummyTrace ARGS ((tDefinitions obj));
static int GetDummyDynamic ARGS ((tDefinitions obj));
static int GetDummySequence ARGS ((tDefinitions obj));
static void GetDummyType ARGS ((tDefinitions obj, int * yyP2, int * yyP1));
static rbool HasOptionalAttribute ARGS ((tDefinitions obj));
static void CheckCorrectParameterList ARGS ((tTree params, rbool intrinsic_flag));
static void SetNamedParameters ARGS ((tTree t));
static void SetUnNamedParameters ARGS ((tTree t));
static void CheckKind ARGS ((tTree t, int kind));
void CheckIntention ARGS ((tTree t, int intent));
static void CheckLayout ARGS ((tTree t, int dummy_layout));
static void CheckPassBy ARGS ((tTree t, int dummy_pass_by));
static void CheckTrace ARGS ((tTree t, int dummy_trace));
static void CheckDynamic ARGS ((tTree t, int dummy_dynamic));
static void SetDummy ARGS ((tTree t, tDefinitions dummy));
static void CheckRank ARGS ((tTree t, int rank, int sequence));
static void CheckType ARGS ((tTree t, int type, int size));
static rbool IsEqualType ARGS ((int kind1, int kind2, int size1, int size2));
tDefinitions IdentifyGenericRoutine ARGS ((tTree call, tDefinitions MyObj));
tTree IdentifyBinaryRoutine ARGS ((tTree exp));
tTree IdentifyUnaryRoutine ARGS ((tTree exp));
tTree IdentifyAssignRoutine ARGS ((tTree ass));
static tDefinitions GetOpEntries ARGS ((tDefinitions Obj));
static tDefinitions FindRoutine ARGS ((tTree t, tDefinitions entries));
static tDefinitions FindBinaryRoutine ARGS ((tTree e1, tTree e2, tDefinitions entries));
static tDefinitions FindUnaryRoutine ARGS ((tTree e1, tDefinitions entries));
static rbool Match ARGS ((tTree t, tDefinitions Obj));
static rbool MatchBinary ARGS ((tTree e1, tTree e2, tDefinitions Obj));
static rbool MatchUnary ARGS ((tTree e1, tDefinitions Obj));
static rbool CanSetNamedParameters ARGS ((tTree params));
static rbool CanSetUnNamedParameters ARGS ((tTree params));
static rbool MatchingParameters ARGS ((tTree params));
static rbool MatchType ARGS ((tTree p, int type, int size));
static rbool MatchExpType ARGS ((tTree exp, int type, int size));
static tTree MoveParameter ARGS ((tTree paramlist, int pos, tTree val));
static rbool WithNamedParameters ARGS ((tTree t));
static int ScatterRank ARGS ((tIdent name, tTree params));
static void SetParamDefaults ARGS ((tTree call, tTree params));
static void SetVarParamDefaults ARGS ((tTree call, tTree param));
static void SetDefaultIntention ARGS ((tTree param));
static void SetDefaultLayout ARGS ((tTree call, tTree param));
static void SetDefaultPassBy ARGS ((tTree call, tTree param));
void PrintParamVals ARGS ((tTree params));

void SemCalling
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 459 "SemCalling.puma" */
  {
/* line 461 "SemCalling.puma" */
   if (! ((IsIntrCall (t)))) goto yyL1;
  {
/* line 463 "SemCalling.puma" */
   init_parameters ();
/* line 464 "SemCalling.puma" */
   SetIntrinsicInfo (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, ScatterRank (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->FUNC_CALL_EXP.FUNC_PARAMS), set_intrinsic_parameter);
/* line 466 "SemCalling.puma" */
   CheckCorrectParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS, rtrue);
/* line 467 "SemCalling.puma" */
   t->FUNC_CALL_EXP.FUNC_PARAMS = MakeNewParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 469 "SemCalling.puma" */
   SetParamDefaults (t, t->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 470 "SemCalling.puma" */
   tree_protocol ("function call : ", t);
/* line 471 "SemCalling.puma" */
   PrintParamVals (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
   return;
yyL1:;

/* line 474 "SemCalling.puma" */
  {
/* line 476 "SemCalling.puma" */
   SetInterfaceUse (GetReferenceObject (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object));
/* line 477 "SemCalling.puma" */
   CheckCorrectParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS, rfalse);
/* line 478 "SemCalling.puma" */
   t->FUNC_CALL_EXP.FUNC_PARAMS = MakeNewParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 480 "SemCalling.puma" */
   SetParamDefaults (t, t->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 481 "SemCalling.puma" */
   tree_protocol ("function call : ", t);
/* line 482 "SemCalling.puma" */
   PrintParamVals (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return;

  }
  if (t->Kind == kCALL_STMT) {
/* line 485 "SemCalling.puma" */
  {
/* line 487 "SemCalling.puma" */
   if (! ((IsIntrCall (t)))) goto yyL3;
  {
/* line 488 "SemCalling.puma" */
   init_parameters ();
/* line 489 "SemCalling.puma" */
   SetIntrinsicInfo (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, ScatterRank (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, t->CALL_STMT.CALL_PARAMS), set_intrinsic_parameter);
/* line 491 "SemCalling.puma" */
   CheckCorrectParameterList (t->CALL_STMT.CALL_PARAMS, rtrue);
/* line 492 "SemCalling.puma" */
   t->CALL_STMT.CALL_PARAMS = MakeNewParameterList (t->CALL_STMT.CALL_PARAMS);
/* line 494 "SemCalling.puma" */
   SetParamDefaults (t, t->CALL_STMT.CALL_PARAMS);
/* line 495 "SemCalling.puma" */
   tree_protocol ("subroutine call : ", t);
/* line 496 "SemCalling.puma" */
   PrintParamVals (t->CALL_STMT.CALL_PARAMS);
  }
  }
   return;
yyL3:;

/* line 499 "SemCalling.puma" */
  {
/* line 501 "SemCalling.puma" */
   SetInterfaceUse (GetReferenceObject (t->CALL_STMT.CALL_ID->PROC_OBJ.Object));
/* line 502 "SemCalling.puma" */
   CheckCorrectParameterList (t->CALL_STMT.CALL_PARAMS, rfalse);
/* line 503 "SemCalling.puma" */
   t->CALL_STMT.CALL_PARAMS = MakeNewParameterList (t->CALL_STMT.CALL_PARAMS);
/* line 505 "SemCalling.puma" */
   SetParamDefaults (t, t->CALL_STMT.CALL_PARAMS);
/* line 506 "SemCalling.puma" */
   tree_protocol ("subroutine call : ", t);
/* line 507 "SemCalling.puma" */
   PrintParamVals (t->CALL_STMT.CALL_PARAMS);
  }
   return;

  }
/* line 510 "SemCalling.puma" */
  {
/* line 511 "SemCalling.puma" */
   failure_protocol (MODULE, "SemCalling", t);
  }
   return;

;
}

static void SetInterfaceUse
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 527 "SemCalling.puma" */
  {
/* line 528 "SemCalling.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 529 "SemCalling.puma" */
   set_no_interface ();
  }
  }
   return;
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 532 "SemCalling.puma" */
  {
/* line 535 "SemCalling.puma" */
   init_parameters ();
/* line 536 "SemCalling.puma" */
   SetUserParamFormals (obj->FuncObject.decl->FUNC_DECL.FORMALS, obj->FuncObject.Declarations);
  }
   return;

  }
  if (obj->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 539 "SemCalling.puma" */
  {
/* line 543 "SemCalling.puma" */
   set_no_interface ();
  }
   return;

  }
  }
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kPROC_DECL) {
/* line 546 "SemCalling.puma" */
  {
/* line 549 "SemCalling.puma" */
   init_parameters ();
/* line 550 "SemCalling.puma" */
   SetUserParamFormals (obj->ProcObject.decl->PROC_DECL.FORMALS, obj->ProcObject.Declarations);
  }
   return;

  }
  }
  if (obj->Kind == kGenericObject) {
/* line 553 "SemCalling.puma" */
  {
/* line 555 "SemCalling.puma" */
   set_no_interface ();
/* line 556 "SemCalling.puma" */
   stmt_protocol ("could not check parameters of the call");
  }
   return;

  }
/* line 559 "SemCalling.puma" */
  {
/* line 560 "SemCalling.puma" */
   error_protocol ("illegal object for the call");
  }
   return;

;
}

static void SetUserParamFormals
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tDefinitions entries)
# else
(formals, entries)
 register tTree formals;
 register tDefinitions entries;
# endif
{
 yyRecursion:
  if (formals->Kind == kDECL_LIST) {
/* line 571 "SemCalling.puma" */
  {
/* line 573 "SemCalling.puma" */
   SetUserParamFormals (formals->DECL_LIST.Elem, entries);
/* line 574 "SemCalling.puma" */
   formals = formals->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (formals->Kind == kDECL_EMPTY) {
/* line 577 "SemCalling.puma" */
   return;

  }
  if (formals->Kind == kVAR_PARAM_DECL) {
/* line 580 "SemCalling.puma" */
 {
  tDefinitions dummy;
  rbool optional;
  int yyV1;
  int yyV2;
  {
/* line 585 "SemCalling.puma" */
   dummy = GetDeclEntry (formals->VAR_PARAM_DECL.Ident, entries);
/* line 587 "SemCalling.puma" */
   optional = HasOptionalAttribute (dummy);
/* line 589 "SemCalling.puma" */
   GetDummyType (dummy, & yyV1, & yyV2);
/* line 591 "SemCalling.puma" */
   set_user_parameter (formals->VAR_PARAM_DECL.Ident, dummy, (! optional), GetDummyKind (dummy), GetDummyIntent (dummy), GetDummyLayout (dummy), GetDummyPassBy (dummy), GetDummyPointer (dummy), GetDummyTrace (dummy), GetDummyDynamic (dummy), GetDummySequence (dummy), VarRank (dummy), yyV1, yyV2);
  }
   return;
 }

  }
/* line 599 "SemCalling.puma" */
  {
/* line 601 "SemCalling.puma" */
   failure_protocol (MODULE, "SetUserParamFormals", formals);
  }
   return;

;
}

static int GetDummyKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 612 "SemCalling.puma" */
   return KIND_VAR;

  }
  }
  if (obj->Kind == kFuncObject) {
/* line 616 "SemCalling.puma" */
   return KIND_FUNC;

  }
  if (obj->Kind == kProcObject) {
/* line 620 "SemCalling.puma" */
   return KIND_PROC;

  }
  if (obj->Kind == kExternalObject) {
/* line 624 "SemCalling.puma" */
   return KIND_EXT;

  }
 yyAbort ("GetDummyKind");
 { int yyDummy; return yyDummy; }
}

static int GetDummyIntent
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 630 "SemCalling.puma" */
   return obj->VarObject.Kind->VarDummy.Intent;

  }
  }
  if (obj->Kind == kFuncObject) {
/* line 634 "SemCalling.puma" */
   return 0;

  }
  if (obj->Kind == kProcObject) {
/* line 638 "SemCalling.puma" */
   return 0;

  }
  if (obj->Kind == kExternalObject) {
/* line 642 "SemCalling.puma" */
   return 0;

  }
/* line 646 "SemCalling.puma" */
  {
/* line 647 "SemCalling.puma" */
   failure_protocol ("MODULE", "GetDummyIntent", obj->Object.decl);
  }
   return 0;

}

static int GetDummyLayout
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 659 "SemCalling.puma" */
   return obj->VarObject.Kind->VarDummy.layout;

  }
  }
/* line 663 "SemCalling.puma" */
   return kDEFAULT_LAYOUT;

}

static int GetDummyPassBy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 675 "SemCalling.puma" */
   return obj->VarObject.Kind->VarDummy.pass_by;

  }
  }
/* line 679 "SemCalling.puma" */
   return kDEFAULT_PASS_BY;

}

static int GetDummyPointer
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 691 "SemCalling.puma" */
  {
/* line 693 "SemCalling.puma" */
   if (! ((obj->VarObject.arr_kind == arr_pointer))) goto yyL1;
  }
   return kIS_POINTER;
yyL1:;

  }
/* line 698 "SemCalling.puma" */
   return kNOT_POINTER;

}

static int GetDummyTrace
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 710 "SemCalling.puma" */
   return obj->VarObject.trace;

  }
/* line 715 "SemCalling.puma" */
   return 0;

}

static int GetDummyDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 727 "SemCalling.puma" */
 {
  int dyn;
  {
/* line 731 "SemCalling.puma" */
 if (obj->VarObject.Dist->Mapping.dynamic) 
        dyn = 1;
       else 
        dyn =2;
   
  }
   return dyn;
 }

  }
/* line 740 "SemCalling.puma" */
   return 0;

}

static int GetDummySequence
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 752 "SemCalling.puma" */
   return obj->VarObject.sequence;

  }
/* line 757 "SemCalling.puma" */
   return 0;

}

static void GetDummyType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int * yyP2, register int * yyP1)
# else
(obj, yyP2, yyP1)
 register tDefinitions obj;
 register int * yyP2;
 register int * yyP1;
# endif
{
  if (obj->Kind == kProcObject) {
/* line 769 "SemCalling.puma" */
   * yyP2 = 0;
   * yyP1 = 0;
   return;

  }
  if (obj->Kind == kExternalObject) {
/* line 772 "SemCalling.puma" */
   * yyP2 = 0;
   * yyP1 = 0;
   return;

  }
/* line 775 "SemCalling.puma" */
 {
  type_rec type;
  {
/* line 779 "SemCalling.puma" */
   GetTypeRecord (GetBaseType (GetObjectType (obj)), & type);
  }
   * yyP2 = type . type_kind;
   * yyP1 = type . type_size;
   return;
 }

;
}

static rbool HasOptionalAttribute
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 790 "SemCalling.puma" */
  {
/* line 791 "SemCalling.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.optional))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 794 "SemCalling.puma" */
  {
/* line 795 "SemCalling.puma" */
   return rfalse;
  }

  }
  }
  if (obj->Kind == kProcObject) {
/* line 798 "SemCalling.puma" */
  {
/* line 799 "SemCalling.puma" */
   if (! ((obj->ProcObject.Kind == DummyRoutine))) goto yyL3;
  {
/* line 800 "SemCalling.puma" */
   return rfalse;
  }
  }
yyL3:;

  }
  if (obj->Kind == kFuncObject) {
/* line 803 "SemCalling.puma" */
  {
/* line 804 "SemCalling.puma" */
   if (! ((obj->FuncObject.Kind == DummyRoutine))) goto yyL4;
  {
/* line 805 "SemCalling.puma" */
   return rfalse;
  }
  }
yyL4:;

  }
  if (obj->Kind == kExternalObject) {
/* line 808 "SemCalling.puma" */
  {
/* line 809 "SemCalling.puma" */
   if (! ((obj->ExternalObject.Kind == DummyRoutine))) goto yyL5;
  {
/* line 810 "SemCalling.puma" */
   return rfalse;
  }
  }
yyL5:;

  }
/* line 813 "SemCalling.puma" */
  {
/* line 814 "SemCalling.puma" */
   obj_protocol ("cannot ask this object for optional attribute", obj);
/* line 815 "SemCalling.puma" */
   failure_protocol (MODULE, "HasOptionalAttribute", obj->Object.decl);
  }
   return rtrue;

}

static void CheckCorrectParameterList
# if defined __STDC__ | defined __cplusplus
(register tTree params, register rbool intrinsic_flag)
# else
(params, intrinsic_flag)
 register tTree params;
 register rbool intrinsic_flag;
# endif
{
/* line 828 "SemCalling.puma" */
  {
/* line 830 "SemCalling.puma" */
   if (! ((no_interface ()))) goto yyL1;
  {
/* line 832 "SemCalling.puma" */
 if (WithNamedParameters (params))
     error_protocol ("cannot verify named parameters (no interface available)");
 
  }
  }
   return;
yyL1:;

/* line 837 "SemCalling.puma" */
  {
/* line 840 "SemCalling.puma" */
 int i;
   char string[100], msg[100];
   type_rec act_type;

   check_routine *p;

   SetNamedParameters (params);
   SetUnNamedParameters (params);

   for (i=0; i<param_counter; i++)

     { 
#ifdef DEBUG
       printf ("checking parameter %d of %d, mandatory = %d\n",
                i+1, param_counter, is_mandatory[i]); 
#endif

       if (is_mandatory[i] && (param_val[i] == NoTree))

        { GetString (param_name[i], string);
          sprintf (msg, "actual for dummy argument %s is missed", string);
          error_protocol (msg);
        }

        else if (param_val[i] != NoTree)

        { CheckKind      (param_val[i], param_kind[i]);
          CheckLayout    (param_val[i], param_layout[i]);
          CheckPassBy    (param_val[i], param_pass_by[i]);
          CheckTrace     (param_val[i], param_trace[i]);
          CheckDynamic   (param_val[i], param_dynamic[i]);
          CheckIntention (param_val[i], param_intent[i]);
          CheckRank      (param_val[i], param_rank[i], param_sequence[i]);
          SetDummy       (param_val[i], param_dummy[i]);
   
          if (!intrinsic_flag)

             CheckType   (param_val[i], param_type[i], param_size[i]);

           else 
   
             { p = param_check[i];

               if (!p (param_val[i]))

                 { GetString (param_name[i], string);
                   sprintf (msg, "intrinsic argument %s %s", 
                                 string, type_error_msg);
                   error_protocol (msg);
                   tree_protocol ("illegal argument is ", param_val[i]);
 
                   GetParamType (param_val[i], &act_type);
 
                   get_type_string (string, act_type.type_kind);
                   sprintf (msg, "actual type : %s*%d : ", 
                                  string, act_type.type_size);
                   tree_protocol (msg, param_val[i]);
                 }
             }

        } 

     } 
 
  }
   return;

;
}

static void SetNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
/* line 914 "SemCalling.puma" */
  {
/* line 916 "SemCalling.puma" */
   PutNamedParameter (t->BTP_LIST.Elem->NAMED_PARAM.Name, t->BTP_LIST.Elem->NAMED_PARAM.VAL);
/* line 917 "SemCalling.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 920 "SemCalling.puma" */
  {
/* line 922 "SemCalling.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTP_EMPTY) {
/* line 925 "SemCalling.puma" */
   return;

  }
;
}

static void SetUnNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
/* line 936 "SemCalling.puma" */
  {
/* line 938 "SemCalling.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 941 "SemCalling.puma" */
  {
/* line 943 "SemCalling.puma" */
   PutUnNamedParameter (t->BTP_LIST.Elem);
/* line 944 "SemCalling.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTP_EMPTY) {
/* line 947 "SemCalling.puma" */
   return;

  }
;
}

static void CheckKind
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int kind)
# else
(t, kind)
 register tTree t;
 register int kind;
# endif
{
  if (t->Kind == kNO_PARAM) {
/* line 958 "SemCalling.puma" */
   return;

  }
  if (t->Kind == kFUNC_PARAM) {
/* line 961 "SemCalling.puma" */
  {
/* line 963 "SemCalling.puma" */
 switch (kind) {

     case KIND_FUNC    : break;
     case KIND_EXT     : break;
     case KIND_UNKNOWN : break;
     case KIND_PROC    : error_protocol ("subroutine expected, not function");
                         break;
     case KIND_VAR     : error_protocol ("var expected, not function");
                         break;
     }
   
  }
   return;

  }
  if (t->Kind == kPROC_PARAM) {
/* line 976 "SemCalling.puma" */
  {
/* line 978 "SemCalling.puma" */
 switch (kind) {

     case KIND_PROC    : break;
     case KIND_EXT     : break;
     case KIND_UNKNOWN : break;
     case KIND_FUNC    : error_protocol ("function expected, not subroutine");
                         break;
     case KIND_VAR     : error_protocol ("var expected, not subroutine");
                         break;
     }
   
  }
   return;

  }
  if (t->Kind == kVAR_PARAM) {
/* line 991 "SemCalling.puma" */
  {
/* line 993 "SemCalling.puma" */
 switch (kind) {

     case KIND_VAR     : break;
     case KIND_UNKNOWN : break;
     case KIND_PROC    : error_protocol ("subroutine expected, not variable");
                         break;
     case KIND_FUNC    : error_protocol ("function exptected, not variable");
                         break;
     case KIND_EXT     : error_protocol ("external exptected, not variable");
                         break;
     }
   
  }
   return;

  }
/* line 1007 "SemCalling.puma" */
   return;

;
}

void CheckIntention
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int intent)
# else
(t, intent)
 register tTree t;
 register int intent;
# endif
{
  if (t->Kind == kVAR_PARAM) {
/* line 1020 "SemCalling.puma" */
  {
/* line 1022 "SemCalling.puma" */
   if (! ((! IsDefinableParam (t)))) goto yyL1;
  {
/* line 1023 "SemCalling.puma" */
   if (! ((intent == IntentOut))) goto yyL1;
  {
/* line 1025 "SemCalling.puma" */
   error_protocol ("not definable argument for OUT argument");
/* line 1026 "SemCalling.puma" */
   tree_protocol ("wrong argument is ", t);
  }
  }
  }
   return;
yyL1:;

/* line 1029 "SemCalling.puma" */
  {
/* line 1031 "SemCalling.puma" */
   if (! ((! IsDefinableParam (t)))) goto yyL2;
  {
/* line 1032 "SemCalling.puma" */
   if (! ((intent == IntentInOut))) goto yyL2;
  {
/* line 1034 "SemCalling.puma" */
   error_protocol ("not definable arguemnt for INOUT argument");
/* line 1035 "SemCalling.puma" */
   tree_protocol ("wrong argument is ", t);
  }
  }
  }
   return;
yyL2:;

/* line 1038 "SemCalling.puma" */
  {
/* line 1040 "SemCalling.puma" */
 t->VAR_PARAM.intent = intent; 
  }
   return;

  }
;
}

static void CheckLayout
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int dummy_layout)
# else
(t, dummy_layout)
 register tTree t;
 register int dummy_layout;
# endif
{
  if (t->Kind == kVAR_PARAM) {
/* line 1051 "SemCalling.puma" */
  {
/* line 1053 "SemCalling.puma" */
 t->VAR_PARAM.layout = dummy_layout; 
  }
   return;

  }
;
}

static void CheckPassBy
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int dummy_pass_by)
# else
(t, dummy_pass_by)
 register tTree t;
 register int dummy_pass_by;
# endif
{
  if (t->Kind == kVAR_PARAM) {
/* line 1064 "SemCalling.puma" */
  {
/* line 1066 "SemCalling.puma" */
 t->VAR_PARAM.pass_by = dummy_pass_by; 
  }
   return;

  }
;
}

static void CheckTrace
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int dummy_trace)
# else
(t, dummy_trace)
 register tTree t;
 register int dummy_trace;
# endif
{
  if (t->Kind == kVAR_PARAM) {
/* line 1077 "SemCalling.puma" */
  {
/* line 1079 "SemCalling.puma" */
 t->VAR_PARAM.trace = dummy_trace; 
  }
   return;

  }
;
}

static void CheckDynamic
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int dummy_dynamic)
# else
(t, dummy_dynamic)
 register tTree t;
 register int dummy_dynamic;
# endif
{
  if (t->Kind == kVAR_PARAM) {
/* line 1090 "SemCalling.puma" */
  {
/* line 1092 "SemCalling.puma" */
 t->VAR_PARAM.dynamic = dummy_dynamic; 
  }
   return;

  }
;
}

static void SetDummy
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions dummy)
# else
(t, dummy)
 register tTree t;
 register tDefinitions dummy;
# endif
{
  if (t->Kind == kVAR_PARAM) {
/* line 1097 "SemCalling.puma" */
  {
/* line 1099 "SemCalling.puma" */
 t->VAR_PARAM.formal = dummy; 
  }
   return;

  }
;
}

static void CheckRank
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int rank, register int sequence)
# else
(t, rank, sequence)
 register tTree t;
 register int rank;
 register int sequence;
# endif
{
/* line 1110 "SemCalling.puma" */

char msg[100];

/* line 1114 "SemCalling.puma" */
  {
/* line 1116 "SemCalling.puma" */
   if (! ((rank == - 1))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kVAR_PARAM) {
/* line 1119 "SemCalling.puma" */
  {
/* line 1121 "SemCalling.puma" */
   if (! ((TreeRank (t) != rank))) goto yyL2;
  {
/* line 1123 "SemCalling.puma" */
 
 
     if (semantic_check == 0)
         warning_protocol ("rank mismatch for actual argument");
       else if (sequence == IsSequence)
         warning_protocol ("sequence association for actual argument");
       else
         error_protocol ("rank mismatch for actual argument");
 
     sprintf (msg, "   actual parameter (rank = %d) is ", TreeRank(t));
     tree_protocol (msg, t);
     sprintf (msg, "   dummy  parameter (rank = %d) ", rank);
     print_protocol (msg);

   
  }
  }
   return;
yyL2:;

  }
/* line 1140 "SemCalling.puma" */
   return;

;
}

static void CheckType
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int type, register int size)
# else
(t, type, size)
 register tTree t;
 register int type;
 register int size;
# endif
{
/* line 1151 "SemCalling.puma" */

char msg[100], tstr[50];

/* line 1155 "SemCalling.puma" */
  {
/* line 1156 "SemCalling.puma" */
   if (! ((type == kDUMMY_TYPE))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kVAR_PARAM) {
/* line 1159 "SemCalling.puma" */
 {
  type_rec act_type;
  {
/* line 1163 "SemCalling.puma" */
   GetParamType (t, & act_type);
/* line 1165 "SemCalling.puma" */
 if (!IsEqualType (act_type.type_kind, type, act_type.type_size, size))

       { if (semantic_check == 0)
            warning_protocol ("type/size mismatch for actual and dummy");
           else
            error_protocol ("type/size mismatch for actual and dummy");
         get_type_string (tstr, act_type.type_kind);
         sprintf (msg, "actual type : %s*%d : ", tstr, act_type.type_size);
         tree_protocol (msg, t);
         get_type_string (tstr, type);
         sprintf (msg, "formal type : %s*%d", tstr, size);
         print_protocol (msg);
       }
   
  }
   return;
 }

  }
;
}

static rbool IsEqualType
# if defined __STDC__ | defined __cplusplus
(register int kind1, register int kind2, register int size1, register int size2)
# else
(kind1, kind2, size1, size2)
 register int kind1;
 register int kind2;
 register int size1;
 register int size2;
# endif
{
/* line 1183 "SemCalling.puma" */
  {
/* line 1184 "SemCalling.puma" */
   if (! ((kind1 == kind2))) goto yyL1;
  {
/* line 1185 "SemCalling.puma" */
   if (! ((size1 == size2))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 1188 "SemCalling.puma" */
  {
/* line 1189 "SemCalling.puma" */
   if (! ((kind1 == kind2))) goto yyL2;
  {
/* line 1190 "SemCalling.puma" */
   if (! ((kind1 == kTYPE_ID))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 1193 "SemCalling.puma" */
  {
/* line 1194 "SemCalling.puma" */
   if (! ((kind1 == kind2))) goto yyL3;
  {
/* line 1195 "SemCalling.puma" */
   if (! ((kind1 == kSTRING_TYPE))) goto yyL3;
  {
/* line 1196 "SemCalling.puma" */
   if (! ((size2 == - 1))) goto yyL3;
  }
  }
  }
   return rtrue;
yyL3:;

  return rfalse;
}

tDefinitions IdentifyGenericRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tDefinitions MyObj)
# else
(call, MyObj)
 register tTree call;
 register tDefinitions MyObj;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (MyObj->Kind == kGenericObject) {
/* line 1207 "SemCalling.puma" */
 {
  tDefinitions Obj;
  {
/* line 1211 "SemCalling.puma" */
   Obj = FindRoutine (call, MyObj->GenericObject.Interfaces);
/* line 1213 "SemCalling.puma" */
 if (Obj == NoObject)
         { error_protocol ("no interface subroutine matches");
           Obj = MyObj;
         }
       else
         { tree_protocol ("generic subroutine call : ", call);
           obj_protocol ("identified with ", Obj);
         }
    
  }
   return Obj;
 }

  }
  if (MyObj->Kind == kProcObject) {
/* line 1226 "SemCalling.puma" */
   return MyObj;

  }
  }
  if (call->Kind == kFUNC_CALL_EXP) {
  if (MyObj->Kind == kGenericObject) {
/* line 1231 "SemCalling.puma" */
 {
  tDefinitions Obj;
  {
/* line 1235 "SemCalling.puma" */
   Obj = FindRoutine (call, MyObj->GenericObject.Interfaces);
/* line 1237 "SemCalling.puma" */
 if (Obj == NoObject)
        { error_protocol ("no interface function matches");
          Obj = MyObj;
        }
       else
        { tree_protocol ("generic function call : ", call);
          obj_protocol ("identified with ", Obj);
        }
    
  }
   return Obj;
 }

  }
  if (MyObj->Kind == kFuncObject) {
/* line 1250 "SemCalling.puma" */
   return MyObj;

  }
  }
/* line 1255 "SemCalling.puma" */
  {
/* line 1257 "SemCalling.puma" */
   error_protocol ("no legal object for subroutine/function");
/* line 1258 "SemCalling.puma" */
   tree_protocol ("call is : ", call);
/* line 1259 "SemCalling.puma" */
   obj_protocol ("this is object : ", MyObj);
  }
   return MyObj;

}

tTree IdentifyBinaryRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kOP_EXP) {
/* line 1271 "SemCalling.puma" */
 {
  tTree new;
  tDefinitions Obj;
  tDefinitions f_entries;
  {
/* line 1277 "SemCalling.puma" */
   f_entries = GetOpEntries (GetGlobalObject (MakeOperatorId (exp->OP_EXP.EXP_OP)));
/* line 1279 "SemCalling.puma" */
   if (! ((f_entries != NoEntries))) goto yyL1;
  {
/* line 1281 "SemCalling.puma" */
   Obj = FindBinaryRoutine (exp->OP_EXP.OPND1, exp->OP_EXP.OPND2, f_entries);
/* line 1283 "SemCalling.puma" */
 if (Obj == NoObject)
        new = NoTree;
      else
        { new = mPROC_OBJ (Obj->Object.Ident);
          new->PROC_OBJ.Object = Obj;
          new = mFUNC_CALL_EXP (new,
                 mBTP_LIST (ExpToVarParam (exp->OP_EXP.OPND1),
                  mBTP_LIST (ExpToVarParam (exp->OP_EXP.OPND2), mBTP_EMPTY ())));
        }
   
  }
  }
   return new;
 }
yyL1:;

  }
/* line 1297 "SemCalling.puma" */
   return NoTree;

}

tTree IdentifyUnaryRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kOP1_EXP) {
/* line 1309 "SemCalling.puma" */
 {
  tTree new;
  tDefinitions Obj;
  tDefinitions f_entries;
  {
/* line 1315 "SemCalling.puma" */
   f_entries = GetOpEntries (GetGlobalObject (MakeOperatorId (exp->OP1_EXP.EXP_OP1)));
/* line 1317 "SemCalling.puma" */
   if (! ((f_entries != NoEntries))) goto yyL1;
  {
/* line 1320 "SemCalling.puma" */
   Obj = FindUnaryRoutine (exp->OP1_EXP.OPND, f_entries);
/* line 1322 "SemCalling.puma" */
 if (Obj == NoObject)
        new = NoTree;
      else
        { new = mPROC_OBJ (Obj->Object.Ident);
          new->PROC_OBJ.Object = Obj;
          new = mFUNC_CALL_EXP (new,
                  mBTP_LIST (ExpToVarParam (exp->OP1_EXP.OPND), mBTP_EMPTY ()));
        }
   
  }
  }
   return new;
 }
yyL1:;

  }
/* line 1335 "SemCalling.puma" */
   return NoTree;

}

tTree IdentifyAssignRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree ass)
# else
(ass)
 register tTree ass;
# endif
{
  if (ass->Kind == kASSIGN_STMT) {
/* line 1347 "SemCalling.puma" */
 {
  tTree new;
  tDefinitions Obj;
  tDefinitions f_entries;
  {
/* line 1353 "SemCalling.puma" */
   f_entries = GetOpEntries (GetGlobalObject (MakeIdent ("=", 1)));
/* line 1355 "SemCalling.puma" */
   if (! ((f_entries != NoEntries))) goto yyL1;
  {
/* line 1357 "SemCalling.puma" */
   Obj = FindBinaryRoutine (ass->ASSIGN_STMT.ASSIGN_VAR, ass->ASSIGN_STMT.ASSIGN_EXP, f_entries);
/* line 1359 "SemCalling.puma" */
 if (Obj == NoObject)
        new = NoTree;
      else
        { new = mPROC_OBJ (Obj->Object.Ident);
          new->PROC_OBJ.Object = Obj;
          new = mCALL_STMT (new,
                 mBTP_LIST (mVAR_PARAM (ass->ASSIGN_STMT.ASSIGN_VAR),
                  mBTP_LIST (ExpToVarParam (ass->ASSIGN_STMT.ASSIGN_EXP), mBTP_EMPTY ())));
        }
   
  }
  }
   return new;
 }
yyL1:;

  }
/* line 1373 "SemCalling.puma" */
   return NoTree;

}

static tDefinitions GetOpEntries
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
/* line 1379 "SemCalling.puma" */
  {
/* line 1380 "SemCalling.puma" */
   if (! ((Obj == NoObject))) goto yyL1;
  }
   return NoEntries;
yyL1:;

  if (Obj->Kind == kGenericObject) {
/* line 1384 "SemCalling.puma" */
   return Obj->GenericObject.Interfaces;

  }
/* line 1388 "SemCalling.puma" */
   return NoEntries;

}

static tDefinitions FindRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions entries)
# else
(t, entries)
 register tTree t;
 register tDefinitions entries;
# endif
{
 yyRecursion:
  if (entries->Kind == kENTRY_LIST) {
/* line 1400 "SemCalling.puma" */
  {
/* line 1402 "SemCalling.puma" */
   if (! ((Match (t, entries->ENTRY_LIST.Elem)))) goto yyL1;
  {
/* line 1404 "SemCalling.puma" */
 if (FindRoutine (t, entries->ENTRY_LIST.Next) != NoObject)
         error_protocol ("call of generic routine is ambiguous");
    
  }
  }
   return entries->ENTRY_LIST.Elem;
yyL1:;

/* line 1411 "SemCalling.puma" */
   entries = entries->ENTRY_LIST.Next;
   goto yyRecursion;

  }
  if (entries->Kind == kENTRY_EMPTY) {
/* line 1416 "SemCalling.puma" */
   return NoObject;

  }
 yyAbort ("FindRoutine");
 { tDefinitions yyDummy; return yyDummy; }
}

static tDefinitions FindBinaryRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2, register tDefinitions entries)
# else
(e1, e2, entries)
 register tTree e1;
 register tTree e2;
 register tDefinitions entries;
# endif
{
 yyRecursion:
  if (entries->Kind == kENTRY_LIST) {
/* line 1434 "SemCalling.puma" */
  {
/* line 1436 "SemCalling.puma" */
   if (! ((MatchBinary (e1, e2, entries->ENTRY_LIST.Elem)))) goto yyL1;
  {
/* line 1438 "SemCalling.puma" */
 if (FindBinaryRoutine (e1, e2, entries->ENTRY_LIST.Next) != NoObject)
         error_protocol ("call of binary interface operator is ambiguous");
    
  }
  }
   return entries->ENTRY_LIST.Elem;
yyL1:;

/* line 1445 "SemCalling.puma" */
   entries = entries->ENTRY_LIST.Next;
   goto yyRecursion;

  }
  if (entries->Kind == kENTRY_EMPTY) {
/* line 1450 "SemCalling.puma" */
   return NoObject;

  }
 yyAbort ("FindBinaryRoutine");
 { tDefinitions yyDummy; return yyDummy; }
}

static tDefinitions FindUnaryRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tDefinitions entries)
# else
(e1, entries)
 register tTree e1;
 register tDefinitions entries;
# endif
{
 yyRecursion:
  if (entries->Kind == kENTRY_LIST) {
/* line 1463 "SemCalling.puma" */
  {
/* line 1465 "SemCalling.puma" */
   if (! ((MatchUnary (e1, entries->ENTRY_LIST.Elem)))) goto yyL1;
  {
/* line 1467 "SemCalling.puma" */
 if (FindUnaryRoutine (e1, entries->ENTRY_LIST.Next) != NoObject)
         error_protocol ("call of unary interface operator is ambiguous");
    
  }
  }
   return entries->ENTRY_LIST.Elem;
yyL1:;

/* line 1474 "SemCalling.puma" */
   entries = entries->ENTRY_LIST.Next;
   goto yyRecursion;

  }
  if (entries->Kind == kENTRY_EMPTY) {
/* line 1479 "SemCalling.puma" */
   return NoObject;

  }
 yyAbort ("FindUnaryRoutine");
 { tDefinitions yyDummy; return yyDummy; }
}

static rbool Match
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions Obj)
# else
(t, Obj)
 register tTree t;
 register tDefinitions Obj;
# endif
{
  if (t->Kind == kCALL_STMT) {
  if (Obj->Kind == kProcObject) {
  if (Obj->ProcObject.decl->Kind == kPROC_DECL) {
/* line 1492 "SemCalling.puma" */
  {
/* line 1495 "SemCalling.puma" */
   SetInterfaceUse (Obj);
/* line 1496 "SemCalling.puma" */
   if (! ((MatchingParameters (t->CALL_STMT.CALL_PARAMS)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  }
  if (t->Kind == kFUNC_CALL_EXP) {
  if (Obj->Kind == kFuncObject) {
  if (Obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 1499 "SemCalling.puma" */
  {
/* line 1502 "SemCalling.puma" */
   SetInterfaceUse (Obj);
/* line 1503 "SemCalling.puma" */
   if (! ((MatchingParameters (t->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  }
  return rfalse;
}

static rbool MatchBinary
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2, register tDefinitions Obj)
# else
(e1, e2, Obj)
 register tTree e1;
 register tTree e2;
 register tDefinitions Obj;
# endif
{
  if (Obj->Kind == kFuncObject) {
/* line 1516 "SemCalling.puma" */
  {
/* line 1518 "SemCalling.puma" */
   SetInterfaceUse (Obj);
/* line 1520 "SemCalling.puma" */
   if (! ((param_counter == 2))) goto yyL1;
  {
/* line 1522 "SemCalling.puma" */
   if (! ((MatchExpType (e1, param_type [0], param_size [0])))) goto yyL1;
  {
/* line 1523 "SemCalling.puma" */
   if (! ((MatchExpType (e2, param_type [1], param_size [1])))) goto yyL1;
  }
  }
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool MatchUnary
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tDefinitions Obj)
# else
(e1, Obj)
 register tTree e1;
 register tDefinitions Obj;
# endif
{
  if (Obj->Kind == kFuncObject) {
/* line 1536 "SemCalling.puma" */
  {
/* line 1538 "SemCalling.puma" */
   SetInterfaceUse (Obj);
/* line 1540 "SemCalling.puma" */
   if (! ((param_counter == 1))) goto yyL1;
  {
/* line 1542 "SemCalling.puma" */
   if (! ((MatchExpType (e1, param_type [0], param_size [0])))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool CanSetNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
/* line 1553 "SemCalling.puma" */
  {
/* line 1555 "SemCalling.puma" */
   if (! ((SetNamedParameter (params->BTP_LIST.Elem->NAMED_PARAM.Name, params->BTP_LIST.Elem->NAMED_PARAM.VAL)))) goto yyL1;
  {
/* line 1556 "SemCalling.puma" */
   if (! ((CanSetNamedParameters (params->BTP_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 1559 "SemCalling.puma" */
  {
/* line 1561 "SemCalling.puma" */
   return rfalse;
  }

  }
/* line 1564 "SemCalling.puma" */
  {
/* line 1566 "SemCalling.puma" */
   if (! ((CanSetNamedParameters (params->BTP_LIST.Next)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (params->Kind == kBTP_EMPTY) {
/* line 1569 "SemCalling.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool CanSetUnNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
/* line 1580 "SemCalling.puma" */
  {
/* line 1582 "SemCalling.puma" */
   if (! ((CanSetUnNamedParameters (params->BTP_LIST.Next)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
/* line 1585 "SemCalling.puma" */
  {
/* line 1587 "SemCalling.puma" */
   if (! ((SetUnNamedParameter (params->BTP_LIST.Elem)))) goto yyL2;
  {
/* line 1588 "SemCalling.puma" */
   if (! ((CanSetUnNamedParameters (params->BTP_LIST.Next)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  if (params->Kind == kBTP_EMPTY) {
/* line 1591 "SemCalling.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool MatchingParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
/* line 1602 "SemCalling.puma" */
 {
  rbool match;
  int i;
  {
/* line 1607 "SemCalling.puma" */
   if (! ((CanSetNamedParameters (params)))) goto yyL1;
  {
/* line 1608 "SemCalling.puma" */
   if (! ((CanSetUnNamedParameters (params)))) goto yyL1;
  {
/* line 1610 "SemCalling.puma" */
 match = rtrue;
 
     for (i=0; i<param_counter; i++)
 
      { if (is_mandatory[i] && (param_val[i] == NoTree))

           match = rfalse;    

         else if (param_val[i] != NoTree)
 
         { if (!MatchType (param_val[i], param_type[i], param_size[i]))
            match = rfalse;
 
         } 
 
     } 

   
/* line 1629 "SemCalling.puma" */
   if (! ((match))) goto yyL1;
  }
  }
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static rbool MatchType
# if defined __STDC__ | defined __cplusplus
(register tTree p, register int type, register int size)
# else
(p, type, size)
 register tTree p;
 register int type;
 register int size;
# endif
{
  if (p->Kind == kVAR_PARAM) {
/* line 1634 "SemCalling.puma" */
 {
  type_rec act_type;
  {
/* line 1638 "SemCalling.puma" */
   GetParamType (p, & act_type);
/* line 1640 "SemCalling.puma" */
   if (! ((IsEqualType (act_type . type_kind, type, act_type . type_size, size)))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  }
  return rfalse;
}

static rbool MatchExpType
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int type, register int size)
# else
(exp, type, size)
 register tTree exp;
 register int type;
 register int size;
# endif
{
/* line 1645 "SemCalling.puma" */
 {
  type_rec act_type;
  {
/* line 1649 "SemCalling.puma" */
   GetExpType (exp, & act_type);
/* line 1651 "SemCalling.puma" */
   if (! ((IsEqualType (act_type . type_kind, type, act_type . type_size, size)))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static tTree MoveParameter
# if defined __STDC__ | defined __cplusplus
(register tTree paramlist, register int pos, register tTree val)
# else
(paramlist, pos, val)
 register tTree paramlist;
 register int pos;
 register tTree val;
# endif
{
  if (paramlist->Kind == kBTP_LIST) {
/* line 1664 "SemCalling.puma" */
  {
/* line 1666 "SemCalling.puma" */
   if (! ((pos > 0))) goto yyL1;
  {
/* line 1668 "SemCalling.puma" */
 paramlist->BTP_LIST.Next = MoveParameter (paramlist->BTP_LIST.Next, pos-1, val); 
  }
  }
   return paramlist;
yyL1:;

  if (equalint (pos, 0)) {
/* line 1673 "SemCalling.puma" */
  {
/* line 1675 "SemCalling.puma" */
 paramlist->BTP_LIST.Elem = val; 
  }
   return paramlist;

  }
  }
  if (paramlist->Kind == kBTP_EMPTY) {
  if (equalint (pos, 0)) {
/* line 1680 "SemCalling.puma" */
   return mBTP_LIST (val, paramlist);

  }
  }
/* line 1685 "SemCalling.puma" */
  {
/* line 1687 "SemCalling.puma" */
   failure_protocol (MODULE, "MoveParameter", paramlist);
  }
   return NoTree;

}

static rbool WithNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
/* line 1702 "SemCalling.puma" */
   return rtrue;

  }
/* line 1705 "SemCalling.puma" */
  {
/* line 1706 "SemCalling.puma" */
   if (! ((WithNamedParameters (t->BTP_LIST.Next)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static int ScatterRank
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 1727 "SemCalling.puma" */
  {
/* line 1731 "SemCalling.puma" */
   if (! ((IntrFuncRed (name) || IntrFuncLocRed (name)))) goto yyL1;
  }
   return TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V);
yyL1:;

  }
/* line 1735 "SemCalling.puma" */
  {
/* line 1737 "SemCalling.puma" */
   if (! ((IntrFuncScatter (name)))) goto yyL2;
  }
   return TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem);
yyL2:;

  }
  }
/* line 1741 "SemCalling.puma" */
  {
/* line 1743 "SemCalling.puma" */
   if (! ((IntrFuncElemental (name)))) goto yyL3;
  }
   return TreeListLength (params);
yyL3:;

/* line 1747 "SemCalling.puma" */
   return 0;

}

static void SetParamDefaults
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree params)
# else
(call, params)
 register tTree call;
 register tTree params;
# endif
{
 yyRecursion:
  if (params->Kind == kBTP_LIST) {
/* line 1759 "SemCalling.puma" */
  {
/* line 1761 "SemCalling.puma" */
   SetParamDefaults (call, params->BTP_LIST.Elem);
/* line 1762 "SemCalling.puma" */
   params = params->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (params->Kind == kVAR_PARAM) {
/* line 1765 "SemCalling.puma" */
  {
/* line 1767 "SemCalling.puma" */
   SetVarParamDefaults (call, params);
  }
   return;

  }
;
}

static void SetVarParamDefaults
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree param)
# else
(call, param)
 register tTree call;
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
/* line 1778 "SemCalling.puma" */
  {
/* line 1780 "SemCalling.puma" */
   if (! ((param->VAR_PARAM.intent == IntentNo))) goto yyL1;
  {
/* line 1782 "SemCalling.puma" */
   SetDefaultIntention (param);
/* line 1784 "SemCalling.puma" */
   goto yyL1;
  }
  }
yyL1:;

/* line 1787 "SemCalling.puma" */
  {
/* line 1789 "SemCalling.puma" */
   if (! ((param->VAR_PARAM.layout == kDEFAULT_LAYOUT))) goto yyL2;
  {
/* line 1791 "SemCalling.puma" */
   SetDefaultLayout (call, param);
/* line 1793 "SemCalling.puma" */
   goto yyL2;
  }
  }
yyL2:;

/* line 1796 "SemCalling.puma" */
  {
/* line 1798 "SemCalling.puma" */
   if (! ((param->VAR_PARAM.pass_by == kDEFAULT_PASS_BY))) goto yyL3;
  {
/* line 1800 "SemCalling.puma" */
   SetDefaultPassBy (call, param);
/* line 1802 "SemCalling.puma" */
   goto yyL3;
  }
  }
yyL3:;

  }
;
}

static void SetDefaultIntention
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
/* line 1813 "SemCalling.puma" */
  {
/* line 1815 "SemCalling.puma" */
   if (! ((! IsDefinableParam (param)))) goto yyL1;
  {
/* line 1817 "SemCalling.puma" */
   param->VAR_PARAM.intent = IntentIn;
  }
  }
   return;
yyL1:;

/* line 1820 "SemCalling.puma" */
  {
/* line 1822 "SemCalling.puma" */
   param->VAR_PARAM.intent = IntentInOut;
  }
   return;

  }
;
}

static void SetDefaultLayout
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree param)
# else
(call, param)
 register tTree call;
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
/* line 1833 "SemCalling.puma" */
 {
  int model;
  {
/* line 1837 "SemCalling.puma" */
 model = HPF_GLOBAL;

     if (IsLocalCall (call))  model = HPF_LOCAL;
     if (IsSerialCall (call)) model = HPF_SERIAL;
   
/* line 1843 "SemCalling.puma" */
   param->VAR_PARAM.layout = GetLayout (IsF77Call (call), model);
  }
   return;
 }

  }
;
}

static void SetDefaultPassBy
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree param)
# else
(call, param)
 register tTree call;
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
/* line 1854 "SemCalling.puma" */
  {
/* line 1856 "SemCalling.puma" */
   if (! ((IsF77Call (call)))) goto yyL1;
  {
/* line 1858 "SemCalling.puma" */
   param->VAR_PARAM.pass_by = kDATA_PASS_BY;
  }
  }
   return;
yyL1:;

/* line 1861 "SemCalling.puma" */
  {
/* line 1863 "SemCalling.puma" */
   param->VAR_PARAM.pass_by = kHPF_HANDLE_PASS_BY;
  }
   return;

  }
;
}

void PrintParamVals
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
/* line 1874 "SemCalling.puma" */

char str_layout [20];
char str_pass   [20];
char msg[120];

 yyRecursion:
  if (params->Kind == kBTP_LIST) {
/* line 1880 "SemCalling.puma" */
  {
/* line 1882 "SemCalling.puma" */
   PrintParamVals (params->BTP_LIST.Elem);
/* line 1883 "SemCalling.puma" */
   params = params->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (params->Kind == kVAR_PARAM) {
/* line 1886 "SemCalling.puma" */
  {
/* line 1889 "SemCalling.puma" */
 if (params->VAR_PARAM.layout == kDEFAULT_LAYOUT)
        sprintf (str_layout, "default");
      else if (params->VAR_PARAM.layout == kHPF_GLOBAL_LAYOUT)
        sprintf (str_layout, "hpf_global_array");
      else if (params->VAR_PARAM.layout == kHPF_LOCAL_LAYOUT)
        sprintf (str_layout, "hpf_local_array");
      else if (params->VAR_PARAM.layout == kHPF_SERIAL_LAYOUT)
        sprintf (str_layout, "hpf_serial_array");
      else if (params->VAR_PARAM.layout == kF77_LOCAL_LAYOUT)
        sprintf (str_layout, "f77_local_array");
      else if (params->VAR_PARAM.layout == kF77_SERIAL_LAYOUT)
        sprintf (str_layout, "f77_serial_array");
      else
        sprintf (str_layout, "unknown");

     if (params->VAR_PARAM.pass_by == kDEFAULT_PASS_BY)
        sprintf (str_pass, "default");
      else if (params->VAR_PARAM.pass_by == kDATA_PASS_BY)
        sprintf (str_pass, "data");
      else if (params->VAR_PARAM.pass_by == kHPF_HANDLE_PASS_BY)
        sprintf (str_pass, "handle");
      else
        sprintf (str_pass, "unknown");

     sprintf (msg, 
       "argument (intent=%d,layout=%s,pass_by=%s,ptr=%d,dynamic=%d) : ",
            params->VAR_PARAM.intent, str_layout, str_pass, params->VAR_PARAM.pointer, params->VAR_PARAM.dynamic);

     tree_protocol (msg, params);
   
  }
   return;

  }
;
}

void BeginSemCalling ARGS ((void))
{
}

void CloseSemCalling ARGS ((void))
{
}
