# include "Scatter.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 32 "Scatter.puma" */


# define MODULE "Scatter"

# define MAX_INDIRECT_RANK 4
# include "Idents.h"
# include "StringM.h"
# include "Types.h"      /* IntrFuncRed */
# include "protocol.h"

# include "MoveControl.h"          /* CountMovement */
# include "Transform.h"            /* ExpToVarParam, ConcatParams */

# include "Expressions.h"          /* MakeConstant     */

# include "Reductions.h"
# include "Distributions.h"
# include "CodeGeneral.h"
# include "CodeDescriptors.h"
# include "Dalib.h"
# include "Rank.h"
# include "TreeOps.h"
# include "Shapes.h"
# include "Nesting.h"

# define TARGET_SEC_ID 1
# define SOURCE_SEC_ID 2
# define MASK_SEC_ID   3
# define INDEX_SEC_ID  4



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyScatter.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Scatter_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Scatter, routine %s failed\n",
  yyFunction);
 Scatter_Exit ();
}

static tTree VarTopParam ARGS ((tTree A));
static void MakeIndDefine ARGS ((tTree s_id, tTree A, tTree B, tTree M, tTree indexes, tTree * yyP2, tTree * yyP1));
static void MakeScatterCall ARGS ((int op, tTree A, tTree B, tTree M, tTree indexes, tTree * yyP3));
static void MakeIndexParams ARGS ((tTree indexes, int nr, int snr, tTree * yyP6, tTree * yyP5, tTree * yyP4));
static tTree MakeDescriptorParam ARGS ((tTree var, int nr));
static void GetScatterParams ARGS ((tTree params, tTree * yyP10, tTree * yyP9, tTree * yyP8, tTree * yyP7));
static void SplitTail ARGS ((tTree params, tTree * yyP12, tTree * yyP11));
tTree MakeScatterStmt ARGS ((tTree call));
static rbool BaseIsVar ARGS ((tTree base, tTree var));
static int GetScatterOp ARGS ((tTree type, tIdent name));
tTree CodeScatterStmt ARGS ((tTree stmt));
rbool IsIndShadowStmt ARGS ((tTree s));
tTree CodeIndShadow ARGS ((tTree s));
static tTree CodeVarList ARGS ((tTree vars, int ptr, int dyn, tTree params));
static tTree DalibScheduleId ARGS ((int id));
static void SetParamAtt ARGS ((tTree param, int pass_by, int pointer, int dynamic));

static tTree VarTopParam
# if defined __STDC__ | defined __cplusplus
(register tTree A)
# else
(A)
 register tTree A;
# endif
{
 yyRecursion:
  if (A->Kind == kINDEXED_VAR) {
/* line 71 "Scatter.puma" */
   A = A->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  }
  if (A->Kind == kUSED_VAR) {
/* line 76 "Scatter.puma" */
   return MakeTopologyParam (GetTopologyObj (A->USED_VAR.VARNAME->VAR_OBJ.Object));

  }
 yyAbort ("VarTopParam");
 { tTree yyDummy; return yyDummy; }
}

static void MakeIndDefine
# if defined __STDC__ | defined __cplusplus
(register tTree s_id, register tTree A, register tTree B, register tTree M, register tTree indexes, register tTree * yyP2, register tTree * yyP1)
# else
(s_id, A, B, M, indexes, yyP2, yyP1)
 register tTree s_id;
 register tTree A;
 register tTree B;
 register tTree M;
 register tTree indexes;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 93 "Scatter.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  tTree param;
  tTree pre1;
  tTree post1;
  {
/* line 95 "Scatter.puma" */
   MakeIndexParams (indexes, TreeRank (B), INDEX_SEC_ID, & yyV1, & yyV2, & yyV3);
/* line 98 "Scatter.puma" */
   yyV2 = CompleteBTPs (yyV2);
/* line 105 "Scatter.puma" */
 if (M != NoTree)

       {  MakeIndexParams (M, 1, MASK_SEC_ID, &pre1, &param, &post1);
          yyV1 = CombineACF (yyV1, pre1);
          yyV3 = CombineACF (post1, yyV3);
          yyV2 = CombineBTP (param, yyV2); 
       }

      else

          yyV2 = mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), 
                        mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), yyV2));

     MakeIndexParams (B, 1, TARGET_SEC_ID, &pre1, &param, &post1);
     yyV1 = CombineACF (yyV1, pre1);
     yyV3 = CombineACF (post1, yyV3);
     yyV2 = CombineBTP (param, yyV2); 

     MakeIndexParams (A, 1, SOURCE_SEC_ID, &pre1, &param, &post1);
     yyV1 = CombineACF (yyV1, pre1);
     yyV3 = CombineACF (post1, yyV3);
     yyV2 = CombineBTP (param, yyV2); 

     yyV2 = mBTP_LIST (s_id, yyV2);

     call = mPROC_OBJ (MakeDalibId ("inspector_get"));

     call = mACF_BASIC (mCALL_STMT (call, yyV2));
     SetACFNode (call, 0, 0);

   
  }
   * yyP2 = CombineACF (yyV1, call);
   * yyP1 = yyV3;
   return;
 }

;
}

static void MakeScatterCall
# if defined __STDC__ | defined __cplusplus
(register int op, register tTree A, register tTree B, register tTree M, register tTree indexes, register tTree * yyP3)
# else
(op, A, B, M, indexes, yyP3)
 register int op;
 register tTree A;
 register tTree B;
 register tTree M;
 register tTree indexes;
 register tTree * yyP3;
# endif
{
/* line 146 "Scatter.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  tTree param;
  tTree pre1;
  tTree post1;
  {
/* line 148 "Scatter.puma" */
   MakeIndexParams (indexes, TreeRank (B), INDEX_SEC_ID, & yyV1, & yyV2, & yyV3);
/* line 151 "Scatter.puma" */
   yyV2 = CompleteBTPs (yyV2);
/* line 158 "Scatter.puma" */
 if (M != NoTree)
 
       {  MakeIndexParams (M, 1, MASK_SEC_ID, &pre1, &param, &post1);
          yyV1 = CombineACF (yyV1, pre1);
          yyV3 = CombineACF (post1, yyV3);
          yyV2 = CombineBTP (param, yyV2);
       }
 
      else
 
          yyV2 = mBTP_LIST (mNO_PARAM (kDUMMY_TYPE),
                        mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), yyV2));
 
     MakeIndexParams (B, 1, TARGET_SEC_ID, &pre1, &param, &post1);
     yyV1 = CombineACF (yyV1, pre1);
     yyV3 = CombineACF (post1, yyV3);
     yyV2 = CombineBTP (param, yyV2);
 
     MakeIndexParams (A, 1, SOURCE_SEC_ID, &pre1, &param, &post1);

     yyV1 = CombineACF (yyV1, pre1);
     yyV3 = CombineACF (post1, yyV3);
     yyV2 = CombineBTP (param, yyV2);
 
     yyV2 = mBTP_LIST (ExpToVarParam (MakeConstant (op)), yyV2);
 
     call = mPROC_OBJ (MakeDalibId ("scatter"));
 
     call = mACF_BASIC (mCALL_STMT (call, yyV2));
     SetACFNode (call, 0, 0);
 
   
  }
   * yyP3 = CombineACF (CombineACF (yyV1, call), yyV3);
   return;
 }

;
}

static void MakeIndexParams
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int nr, register int snr, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(indexes, nr, snr, yyP6, yyP5, yyP4)
 register tTree indexes;
 register int nr;
 register int snr;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
  if (indexes->Kind == kBTP_LIST) {
/* line 201 "Scatter.puma" */
  {
/* line 202 "Scatter.puma" */
   if (! ((nr == 0))) goto yyL1;
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;
yyL1:;

/* line 205 "Scatter.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 209 "Scatter.puma" */
   MakeIndexParams (indexes->BTP_LIST.Elem, nr, snr, & yyV1, & yyV2, & yyV3);
/* line 210 "Scatter.puma" */
   MakeIndexParams (indexes->BTP_LIST.Next, nr - 1, snr + 1, & yyV4, & yyV5, & yyV6);
  }
   * yyP6 = CombineACF (yyV1, yyV4);
   * yyP5 = CombineBTP (yyV2, yyV5);
   * yyP4 = CombineACF (yyV3, yyV6);
   return;
 }

  }
  if (indexes->Kind == kBTP_EMPTY) {
/* line 213 "Scatter.puma" */
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

  }
  if (indexes->Kind == kNO_PARAM) {
/* line 216 "Scatter.puma" */
 {
  tTree params;
  {
/* line 219 "Scatter.puma" */
   params = mBTP_LIST (indexes, mBTP_LIST (indexes, NoTree));
  }
   * yyP6 = NoTree;
   * yyP5 = params;
   * yyP4 = NoTree;
   return;
 }

  }
  if (indexes->Kind == kVAR_PARAM) {
  if (indexes->VAR_PARAM.V->Kind == kADDR) {
/* line 222 "Scatter.puma" */
 {
  tTree params;
  {
/* line 225 "Scatter.puma" */
   params = mBTP_LIST (indexes, mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), NoTree));
  }
   * yyP6 = NoTree;
   * yyP5 = params;
   * yyP4 = NoTree;
   return;
 }

  }
/* line 228 "Scatter.puma" */
 {
  tTree params;
  {
/* line 230 "Scatter.puma" */
   if (! ((TreeRank (indexes->VAR_PARAM.V) == 0))) goto yyL6;
  {
/* line 231 "Scatter.puma" */
   if (! ((TreeReadDistribution (indexes) == 0))) goto yyL6;
  {
/* line 234 "Scatter.puma" */
   params = mBTP_LIST (indexes, mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), NoTree));
  }
  }
  }
   * yyP6 = NoTree;
   * yyP5 = params;
   * yyP4 = NoTree;
   return;
 }
yyL6:;

/* line 237 "Scatter.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 239 "Scatter.puma" */
   MakeIndexParams (indexes->VAR_PARAM.V, nr, snr, & yyV1, & yyV2, & yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  if (indexes->Kind == kINDEXED_VAR) {
/* line 242 "Scatter.puma" */
 {
  tTree pre;
  tTree post;
  tTree params;
  {
/* line 248 "Scatter.puma" */
   DalibSectionTranslation (snr, indexes, & pre, & params, & post);
/* line 249 "Scatter.puma" */
   params = mBTP_LIST (mVAR_PARAM (FirstArrayElement (indexes)), mBTP_LIST (params, NoTree));
  }
   * yyP6 = pre;
   * yyP5 = params;
   * yyP4 = post;
   return;
 }

  }
/* line 253 "Scatter.puma" */
  {
/* line 255 "Scatter.puma" */
   failure_protocol (MODULE, "MakeIndexParams", indexes);
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

static tTree MakeDescriptorParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int nr)
# else
(var, nr)
 register tTree var;
 register int nr;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 269 "Scatter.puma" */
   return mVAR_PARAM (MakeUsedVarA (TreeVarName (var->USED_VAR.VARNAME), "_DSP"));

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 274 "Scatter.puma" */
  {
/* line 276 "Scatter.puma" */
   if (! ((IsWholeVar (var)))) goto yyL2;
  }
   return mVAR_PARAM (MakeUsedVarA (TreeVarName (var->INDEXED_VAR.IND_VAR), "_DSP"));
yyL2:;

/* line 281 "Scatter.puma" */
   return DalibSectionDescriptor (nr);

  }
/* line 286 "Scatter.puma" */
  {
/* line 288 "Scatter.puma" */
   failure_protocol (MODULE, "MakeDescriptorParam", var);
  }
   return NoTree;

}

static void GetScatterParams
# if defined __STDC__ | defined __cplusplus
(register tTree params, register tTree * yyP10, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(params, yyP10, yyP9, yyP8, yyP7)
 register tTree params;
 register tTree * yyP10;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 300 "Scatter.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 303 "Scatter.puma" */
   SplitTail (params->BTP_LIST.Next->BTP_LIST.Next, & yyV1, & yyV2);
  }
   * yyP10 = params->BTP_LIST.Elem->VAR_PARAM.V;
   * yyP9 = params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V;
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }

  }
  }
  }
  }
/* line 306 "Scatter.puma" */
  {
/* line 308 "Scatter.puma" */
   failure_protocol (MODULE, "GetScatterParams", params);
  }
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

;
}

static void SplitTail
# if defined __STDC__ | defined __cplusplus
(register tTree params, register tTree * yyP12, register tTree * yyP11)
# else
(params, yyP12, yyP11)
 register tTree params;
 register tTree * yyP12;
 register tTree * yyP11;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 319 "Scatter.puma" */
 {
  tTree save_mask;
  {
/* line 322 "Scatter.puma" */
 save_mask = params->BTP_LIST.Next->BTP_LIST.Elem;
      params->BTP_LIST.Next = params->BTP_LIST.Next->BTP_LIST.Next;          
    
  }
   * yyP12 = params;
   * yyP11 = save_mask;
   return;
 }

  }
  }
/* line 327 "Scatter.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 329 "Scatter.puma" */
   SplitTail (params->BTP_LIST.Next, & yyV1, & yyV2);
  }
   * yyP12 = params;
   * yyP11 = yyV2;
   return;
 }

  }
/* line 332 "Scatter.puma" */
  {
/* line 334 "Scatter.puma" */
   failure_protocol (MODULE, "SplitTail scatter params", params);
  }
   * yyP12 = NoTree;
   * yyP11 = NoTree;
   return;

;
}

tTree MakeScatterStmt
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kACF_BASIC) {
  if (call->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (call->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 347 "Scatter.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 350 "Scatter.puma" */
   GetScatterParams (call->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 354 "Scatter.puma" */
 if (!BaseIsVar (yyV2, call->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR))
         error_protocol ("base of scatter must be lhs var");

      call->ACF_BASIC.BASIC_STMT = mSCATTER_STMT (call->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, yyV1, yyV2, yyV3, yyV4);

    
  }
   return call;
 }

  }
  }
  }
/* line 364 "Scatter.puma" */
  {
/* line 365 "Scatter.puma" */
   failure_protocol (MODULE, "MakeScatterStmt", call);
  }
   return NoTree;

}

static rbool BaseIsVar
# if defined __STDC__ | defined __cplusplus
(register tTree base, register tTree var)
# else
(base, var)
 register tTree base;
 register tTree var;
# endif
{
  if (base->Kind == kINDEXED_VAR) {
  if (var->Kind == kINDEXED_VAR) {
/* line 371 "Scatter.puma" */
  {
/* line 373 "Scatter.puma" */
   if (! ((TreeVarName (base->INDEXED_VAR.IND_VAR) == TreeVarName (var->INDEXED_VAR.IND_VAR)))) goto yyL1;
  {
/* line 374 "Scatter.puma" */
   if (! ((EqualIndexes (base->INDEXED_VAR.IND_EXPS, var->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static int GetScatterOp
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tIdent name)
# else
(type, name)
 register tTree type;
 register tIdent name;
# endif
{
/* line 385 "Scatter.puma" */

char str[100];

/* line 389 "Scatter.puma" */
  {
/* line 391 "Scatter.puma" */
   if (! ((name == MakeIdent ("COPY_SCATTER", 12)))) goto yyL1;
  }
   return 0;
yyL1:;

/* line 395 "Scatter.puma" */
  {
/* line 399 "Scatter.puma" */
   GetString (name, str);
  }
   return GetGlobalOp (type, MakeIdent (str, strlen (str) - 8));

}

tTree CodeScatterStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kSCATTER_STMT) {
/* line 411 "Scatter.puma" */
 {
  tTree stmtlist;
  tTree s_id;
  tTree size;
  tTree free_dsp;
  tTree params;
  tTree call;
  int nop;
  {
/* line 413 "Scatter.puma" */
   if (! ((stmt->SCATTER_STMT.func == MakeIdent ("GET_SCATTER", 11)))) goto yyL1;
  {
/* line 423 "Scatter.puma" */
 s_id = mVAR_PARAM (MakeUsedVarAn (MakeIdent ("IS",2), "_", 1));
     DefineNewIntVar (TreeVarName (s_id));
 
     size = MakeTreeSizeParam (stmt->SCATTER_STMT.BASE);
 
     
 
     params = mBTP_LIST (s_id, mBTP_EMPTY());
     call   = mPROC_OBJ (MakeDalibId ("inspector_release"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, NoTree);
 
     
 
     params = mBTP_EMPTY();
     params = mBTP_LIST (MakeDescriptorParam(stmt->SCATTER_STMT.ARRAY, SOURCE_SEC_ID), params);
     params = mBTP_LIST (s_id, params);
     call   = mPROC_OBJ (MakeDalibId ("executor_gather_recv"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, stmtlist);
 
     
 
     params = mBTP_EMPTY();
     params = mBTP_LIST (MakeDescriptorParam(stmt->SCATTER_STMT.BASE, TARGET_SEC_ID), params);
     params = mBTP_LIST (s_id, params);
     call   = mPROC_OBJ (MakeDalibId ("executor_gather_send"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, stmtlist);
 
     
 
     MakeIndDefine (s_id, stmt->SCATTER_STMT.ARRAY, stmt->SCATTER_STMT.BASE, stmt->SCATTER_STMT.MASK, stmt->SCATTER_STMT.INDEXES, &call, &free_dsp);
     stmtlist = CombineACF (call, stmtlist);
     stmtlist = CombineACF (stmtlist, free_dsp);
 
   
  }
  }
   return stmtlist;
 }
yyL1:;

/* line 467 "Scatter.puma" */
 {
  tTree stmtlist;
  int nop;
  {
/* line 471 "Scatter.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  {
/* line 478 "Scatter.puma" */
 nop = GetScatterOp (TreeType (stmt->SCATTER_STMT.BASE), stmt->SCATTER_STMT.func);

     MakeScatterCall (nop, stmt->SCATTER_STMT.ARRAY, stmt->SCATTER_STMT.BASE, stmt->SCATTER_STMT.MASK, stmt->SCATTER_STMT.INDEXES, &stmtlist);

   
  }
  }
   return stmtlist;
 }
yyL2:;

/* line 487 "Scatter.puma" */
 {
  tTree stmtlist;
  tTree s_id;
  tTree size;
  tTree free_dsp;
  tTree params;
  tTree call;
  int nop;
  {
/* line 499 "Scatter.puma" */
 s_id = mVAR_PARAM (MakeUsedVarAn (MakeIdent ("IS",2), "_", 1));
     DefineNewIntVar (TreeVarName (s_id));

     size = MakeTreeSizeParam (stmt->SCATTER_STMT.BASE);

     

     params = mBTP_LIST (s_id, mBTP_EMPTY());
     call   = mPROC_OBJ (MakeDalibId ("inspector_release"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, NoTree);

     

     nop = GetScatterOp (TreeType (stmt->SCATTER_STMT.BASE), stmt->SCATTER_STMT.func);

     params = mBTP_EMPTY();
     params = mBTP_LIST (MakeDescriptorParam(stmt->SCATTER_STMT.BASE, TARGET_SEC_ID), params);
     params = mBTP_LIST (ExpToVarParam (MakeConstant(nop)), params);
     params = mBTP_LIST (s_id, params);
     call   = mPROC_OBJ (MakeDalibId ("executor_scatter_recv"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, stmtlist);

     

     params = mBTP_EMPTY();
     params = mBTP_LIST (MakeDescriptorParam(stmt->SCATTER_STMT.ARRAY, SOURCE_SEC_ID), params);
     params = mBTP_LIST (s_id, params);
     call   = mPROC_OBJ (MakeDalibId ("executor_scatter_send"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, stmtlist);

     

     MakeIndDefine (s_id, stmt->SCATTER_STMT.ARRAY, stmt->SCATTER_STMT.BASE, stmt->SCATTER_STMT.MASK, stmt->SCATTER_STMT.INDEXES, &call, &free_dsp);
     stmtlist = CombineACF (call, stmtlist);
     stmtlist = CombineACF (stmtlist, free_dsp);

   
  }
   return stmtlist;
 }

  }
/* line 546 "Scatter.puma" */
  {
/* line 547 "Scatter.puma" */
   failure_protocol (MODULE, "CodeScatterStmt", stmt);
  }
   return NoTree;

}

rbool IsIndShadowStmt
# if defined __STDC__ | defined __cplusplus
(register tTree s)
# else
(s)
 register tTree s;
# endif
{
  if (s->Kind == kIND_SHADOW_CREATE) {
/* line 558 "Scatter.puma" */
   return rtrue;

  }
  if (s->Kind == kIND_SHADOW_FREE) {
/* line 559 "Scatter.puma" */
   return rtrue;

  }
  if (s->Kind == kIND_SHADOW_PUT) {
/* line 560 "Scatter.puma" */
   return rtrue;

  }
  if (s->Kind == kIND_SHADOW_GET) {
/* line 561 "Scatter.puma" */
   return rtrue;

  }
  if (s->Kind == kIND_SHADOW_SET) {
/* line 562 "Scatter.puma" */
   return rtrue;

  }
  return rfalse;
}

tTree CodeIndShadow
# if defined __STDC__ | defined __cplusplus
(register tTree s)
# else
(s)
 register tTree s;
# endif
{
  if (s->Kind == kIND_SHADOW_CREATE) {
/* line 587 "Scatter.puma" */
 {
  tTree call;
  tTree param;
  tTree params;
  {
/* line 593 "Scatter.puma" */
   params = mBTP_EMPTY ();
/* line 594 "Scatter.puma" */
   params = CodeVarList (s->IND_SHADOW_CREATE.MASK, kIS_POINTER, kHPF_NOT_DYNAMIC, params);
/* line 595 "Scatter.puma" */
   params = CodeVarList (s->IND_SHADOW_CREATE.INDEX_VAR, kNOT_POINTER, kHPF_NOT_DYNAMIC, params);
/* line 596 "Scatter.puma" */
   params = CodeVarList (s->IND_SHADOW_CREATE.TMP_INDEX_VAR, kNOT_POINTER, kHPF_NOT_DYNAMIC, params);
/* line 597 "Scatter.puma" */
   params = CodeVarList (s->IND_SHADOW_CREATE.SHADOW_VAR, kNOT_POINTER, kHPF_IS_DYNAMIC, params);
/* line 598 "Scatter.puma" */
   param = DalibScheduleId (s->IND_SHADOW_CREATE.id);
/* line 599 "Scatter.puma" */
   params = mBTP_LIST (param, params);
/* line 600 "Scatter.puma" */
   call = mPROC_OBJ (MakeDalibId ("insp_shadow_get"));
/* line 601 "Scatter.puma" */
   call = mCALL_STMT (call, params);
  }
   return call;
 }

  }
  if (s->Kind == kIND_SHADOW_FREE) {
/* line 606 "Scatter.puma" */
 {
  tTree call;
  tTree param;
  tTree params;
  {
/* line 612 "Scatter.puma" */
   params = mBTP_EMPTY ();
/* line 613 "Scatter.puma" */
   params = CodeVarList (s->IND_SHADOW_FREE.INDEX_VAR, kNOT_POINTER, kHPF_NOT_DYNAMIC, params);
/* line 614 "Scatter.puma" */
   param = DalibScheduleId (s->IND_SHADOW_FREE.id);
/* line 615 "Scatter.puma" */
   params = mBTP_LIST (param, params);
/* line 616 "Scatter.puma" */
   call = mPROC_OBJ (MakeDalibId ("insp_shadow_release"));
/* line 617 "Scatter.puma" */
   call = mCALL_STMT (call, params);
  }
   return call;
 }

  }
  if (s->Kind == kIND_SHADOW_GET) {
/* line 622 "Scatter.puma" */
 {
  tTree call;
  tTree params;
  tTree param;
  {
/* line 628 "Scatter.puma" */
   params = mBTP_EMPTY ();
/* line 629 "Scatter.puma" */
   param = mVAR_PARAM (s->IND_SHADOW_GET.SHADOW_VAR);
/* line 630 "Scatter.puma" */
   SetParamAtt (param, kHPF_HANDLE_PASS_BY, kNOT_POINTER, kHPF_NOT_DYNAMIC);
/* line 631 "Scatter.puma" */
   params = mBTP_LIST (param, params);
/* line 632 "Scatter.puma" */
   param = DalibScheduleId (s->IND_SHADOW_GET.id);
/* line 633 "Scatter.puma" */
   params = mBTP_LIST (param, params);
/* line 634 "Scatter.puma" */
   call = mPROC_OBJ (MakeDalibId ("exec_shadow_get"));
/* line 635 "Scatter.puma" */
   call = mCALL_STMT (call, params);
  }
   return call;
 }

  }
  if (s->Kind == kIND_SHADOW_SET) {
/* line 640 "Scatter.puma" */
 {
  tTree call;
  tTree params;
  tTree param;
  {
/* line 646 "Scatter.puma" */
   params = mBTP_EMPTY ();
/* line 647 "Scatter.puma" */
   params = mBTP_LIST (ExpToVarParam (s->IND_SHADOW_SET.VAL), params);
/* line 648 "Scatter.puma" */
   param = mVAR_PARAM (s->IND_SHADOW_SET.SHADOW_VAR);
/* line 649 "Scatter.puma" */
   SetParamAtt (param, kHPF_HANDLE_PASS_BY, kNOT_POINTER, kHPF_NOT_DYNAMIC);
/* line 650 "Scatter.puma" */
   params = mBTP_LIST (param, params);
/* line 651 "Scatter.puma" */
   param = DalibScheduleId (s->IND_SHADOW_SET.id);
/* line 652 "Scatter.puma" */
   params = mBTP_LIST (param, params);
/* line 653 "Scatter.puma" */
   call = mPROC_OBJ (MakeDalibId ("exec_shadow_set"));
/* line 654 "Scatter.puma" */
   call = mCALL_STMT (call, params);
  }
   return call;
 }

  }
  if (s->Kind == kIND_SHADOW_PUT) {
/* line 659 "Scatter.puma" */
 {
  tTree call;
  tTree params;
  tTree param;
  {
/* line 665 "Scatter.puma" */
   params = mBTP_EMPTY ();
/* line 666 "Scatter.puma" */
   params = mBTP_LIST (ExpToVarParam (MakeConstant (s->IND_SHADOW_PUT.op)), params);
/* line 667 "Scatter.puma" */
   param = mVAR_PARAM (s->IND_SHADOW_PUT.SHADOW_VAR);
/* line 668 "Scatter.puma" */
   SetParamAtt (param, kHPF_HANDLE_PASS_BY, kNOT_POINTER, kHPF_NOT_DYNAMIC);
/* line 669 "Scatter.puma" */
   params = mBTP_LIST (param, params);
/* line 670 "Scatter.puma" */
   param = DalibScheduleId (s->IND_SHADOW_PUT.id);
/* line 671 "Scatter.puma" */
   params = mBTP_LIST (param, params);
/* line 672 "Scatter.puma" */
   call = mPROC_OBJ (MakeDalibId ("exec_shadow_put"));
/* line 673 "Scatter.puma" */
   call = mCALL_STMT (call, params);
  }
   return call;
 }

  }
/* line 678 "Scatter.puma" */
  {
/* line 680 "Scatter.puma" */
   failure_protocol (MODULE, "CodeIndShadow", s);
  }
   return NoTree;

}

static tTree CodeVarList
# if defined __STDC__ | defined __cplusplus
(register tTree vars, register int ptr, register int dyn, register tTree params)
# else
(vars, ptr, dyn, params)
 register tTree vars;
 register int ptr;
 register int dyn;
 register tTree params;
# endif
{
  if (vars->Kind == kBTV_EMPTY) {
/* line 693 "Scatter.puma" */
   return params;

  }
  if (vars->Kind == kBTV_LIST) {
/* line 698 "Scatter.puma" */
   return CodeVarList (vars->BTV_LIST.Elem, ptr, dyn, CodeVarList (vars->BTV_LIST.Next, ptr, dyn, params));

  }
  if (vars->Kind == kDUMMY_VAR) {
/* line 703 "Scatter.puma" */
   return mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), params));

  }
/* line 709 "Scatter.puma" */
 {
  tTree full_var;
  tTree param_data;
  tTree param_dsp;
  {
/* line 715 "Scatter.puma" */
   full_var = MakeFullShape (vars);
/* line 717 "Scatter.puma" */
   param_dsp = mVAR_PARAM (CopyTree (full_var));
/* line 718 "Scatter.puma" */
   SetParamAtt (param_dsp, kHPF_HANDLE_PASS_BY, ptr, dyn);
/* line 720 "Scatter.puma" */
   param_data = mVAR_PARAM (full_var);
/* line 721 "Scatter.puma" */
   SetParamAtt (param_data, kDATA_PASS_BY, kNOT_POINTER, kHPF_NOT_DYNAMIC);
  }
   return mBTP_LIST (param_data, mBTP_LIST (param_dsp, params));
 }

}

static tTree DalibScheduleId
# if defined __STDC__ | defined __cplusplus
(register int id)
# else
(id)
 register int id;
# endif
{
/* line 734 "Scatter.puma" */
 {
  tTree param;
  {
/* line 738 "Scatter.puma" */
   param = MakeUsedVarAn (IsIdent ("S"), "_ID", id);
/* line 739 "Scatter.puma" */
   DefineNewIntVar (TreeVarName (param));
/* line 740 "Scatter.puma" */
   param = mVAR_PARAM (param);
/* line 741 "Scatter.puma" */
   SetParamAtt (param, kDATA_PASS_BY, 0, 2);
  }
   return param;
 }

}

static void SetParamAtt
# if defined __STDC__ | defined __cplusplus
(register tTree param, register int pass_by, register int pointer, register int dynamic)
# else
(param, pass_by, pointer, dynamic)
 register tTree param;
 register int pass_by;
 register int pointer;
 register int dynamic;
# endif
{
  if (param->Kind == kVAR_PARAM) {
/* line 759 "Scatter.puma" */
  {
/* line 763 "Scatter.puma" */
 param->VAR_PARAM.pass_by = pass_by;
     param->VAR_PARAM.pointer = pointer;
     param->VAR_PARAM.dynamic = dynamic;
   
  }
   return;

  }
  if (param->Kind == kNO_PARAM) {
/* line 769 "Scatter.puma" */
   return;

  }
/* line 772 "Scatter.puma" */
  {
/* line 774 "Scatter.puma" */
   failure_protocol (MODULE, "SetParamAtt", param);
  }
   return;

;
}

void BeginScatter ARGS ((void))
{
}

void CloseScatter ARGS ((void))
{
}
