# include "SMParallel.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 25 "SMParallel.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Types.h"
# include "Transform.h"      /* CombineACF, CombineBTV, ... */
# include "TreeOps.h"       
# include "Rank.h"           
# include "Objects.h"           
# include "Traverse.h"       /* ReplaceAST                  */
# include "VarDescriptor.h"  /* SetVarDescriptor            */

# define MODULE "SMParallel"

static tTree new_vars;       /* used globally to collect local vars */
static int   par_loops;      /* nest depth of parallel loops        */

static tTree global_reduction;

# define MAX_PAR_LOOPS 1     /* maximal nesting of parallel loops   */

static tTree local1, local2, global;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySMParallel.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* SMParallel_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SMParallel, routine %s failed\n",
  yyFunction);
 SMParallel_Exit ();
}

static rbool IsSMParallelLoop ARGS ((tTree t));
void FindSMParallel ARGS ((tTree t));
static rbool StopFind ARGS ((tTree t));
static tTree FindPARALLEL ARGS ((tTree t));
static rbool DoItParallel ARGS ((tTree t));
static void SetItParallel ARGS ((tTree t));
static rbool IsDistributedId ARGS ((tTree home_var, tTree id));
void MakeSMParallel ARGS ((tTree t));
static rbool StopPARALLEL ARGS ((tTree t));
static tTree TranslatePARALLEL ARGS ((tTree t));
tTree MakeParallel ARGS ((tTree t));
static tTree TranslateParBody ARGS ((tTree t));
static rbool StopTranslation ARGS ((tTree t));
static tTree DoTranslation ARGS ((tTree t));
static void MakeLocalLoopVar ARGS ((tTree t));
static tTree ApplySMReduction ARGS ((tTree reduction, tTree stmts));
static rbool StopREDUCTION ARGS ((tTree t));
static tTree TranslateREDUCTION ARGS ((tTree t));
static tTree GetRedVar ARGS ((tTree t));
void AutoScope ARGS ((tTree t));
static void AddSharedVariable ARGS ((tTree t));
tTree FinalSM ARGS ((tTree t));

static rbool IsSMParallelLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 64 "SMParallel.puma" */
  {
/* line 66 "SMParallel.puma" */
   if (! ((t->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection & kSELECT_CONCUR))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

void FindSMParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 79 "SMParallel.puma" */
  {
/* line 81 "SMParallel.puma" */
   if (! ((sm_parallelization))) goto yyL1;
  {
/* line 83 "SMParallel.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopFind, FindPARALLEL); 
  }
  }
   return;
yyL1:;

/* line 86 "SMParallel.puma" */
   return;

  }
/* line 89 "SMParallel.puma" */
  {
/* line 90 "SMParallel.puma" */
   failure_protocol (MODULE, "FindSMParallel", t);
  }
   return;

;
}

static rbool StopFind
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
/* line 104 "SMParallel.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree FindPARALLEL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
/* line 117 "SMParallel.puma" */
  {
/* line 119 "SMParallel.puma" */
   if (! ((DoItParallel (t)))) goto yyL1;
  {
/* line 121 "SMParallel.puma" */
   SetItParallel (t);
  }
  }
   return t;
yyL1:;

/* line 126 "SMParallel.puma" */
  {
/* line 130 "SMParallel.puma" */
 t->ACF_DO.DO_BODY = ReplaceAST (t->ACF_DO.DO_BODY, StopFind, FindPARALLEL); 
  }
   return t;

  }
/* line 135 "SMParallel.puma" */
   return t;

}

static rbool DoItParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 150 "SMParallel.puma" */
  {
/* line 152 "SMParallel.puma" */
   if (! ((sm_parallelization))) goto yyL1;
  {
/* line 153 "SMParallel.puma" */
   if (! ((t->ACF_DO.DO_DEP_INFO->INDEP_INFO.user_independent))) goto yyL1;
  {
/* line 155 "SMParallel.puma" */
   tree_protocol ("INDEPENDEDNT loop will be used for SM parallelism :\n", t);
  }
  }
  }
   return rtrue;
yyL1:;

  }
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
/* line 158 "SMParallel.puma" */
  {
/* line 160 "SMParallel.puma" */
   if (! ((sm_parallelization))) goto yyL2;
  {
/* line 161 "SMParallel.puma" */
   if (! ((IsDistributedId (t->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, t->ACF_DO.DO_ID)))) goto yyL2;
  {
/* line 163 "SMParallel.puma" */
   tree_protocol ("DO loop over distributed dimension will be used for SM parallelism :\n", t);
  }
  }
  }
   return rtrue;
yyL2:;

  }
  }
/* line 167 "SMParallel.puma" */
  {
/* line 168 "SMParallel.puma" */
   tree_protocol ("DO loop not used for SM parallelism :\n", t);
/* line 169 "SMParallel.puma" */
   return rfalse;
  }

}

static void SetItParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 182 "SMParallel.puma" */
  {
/* line 184 "SMParallel.puma" */
 t->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection = t->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection | kSELECT_CONCUR; 
/* line 186 "SMParallel.puma" */
   FileUnparse (stdout, t);
  }
   return;

  }
  }
;
}

static rbool IsDistributedId
# if defined __STDC__ | defined __cplusplus
(register tTree home_var, register tTree id)
# else
(home_var, id)
 register tTree home_var;
 register tTree id;
# endif
{
/* line 200 "SMParallel.puma" */
 {
  var_descriptor vard;
  rbool found;
  int topdim;
  tTree val;
  {
/* line 207 "SMParallel.puma" */
   SetVarDescriptor (home_var, & vard);
/* line 209 "SMParallel.puma" */
 found  = rfalse;
     topdim = 0;

     while ((!found) && (topdim < vard.topology_rank))

       { val= vard.on_val[topdim];

         if (val != NoTree)
            found = IsVarInExp (TreeVarName (id), val);

         topdim += 1;
       }

     

   
/* line 226 "SMParallel.puma" */
   if (! ((found))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

void MakeSMParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 242 "SMParallel.puma" */
  {
/* line 244 "SMParallel.puma" */
   tree_protocol ("body before SM parallelism : \n", t->BODY_NODE.STATS);
/* line 246 "SMParallel.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopPARALLEL, TranslatePARALLEL); 
/* line 248 "SMParallel.puma" */
   tree_protocol ("body after SM parallelism : \n", t->BODY_NODE.STATS);
  }
   return;

  }
/* line 251 "SMParallel.puma" */
  {
/* line 252 "SMParallel.puma" */
   failure_protocol (MODULE, "MakeSMParallel", t);
  }
   return;

;
}

static rbool StopPARALLEL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
/* line 265 "SMParallel.puma" */
  {
/* line 267 "SMParallel.puma" */
   if (! ((IsSMParallelLoop (t)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static tTree TranslatePARALLEL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
/* line 278 "SMParallel.puma" */
 {
  tTree new;
  {
/* line 280 "SMParallel.puma" */
   if (! ((IsSMParallelLoop (t)))) goto yyL1;
  {
/* line 284 "SMParallel.puma" */
   new = MakeParallel (t);
/* line 286 "SMParallel.puma" */
   tree_protocol ("translation of SM parallel loops :\n", new);
  }
  }
   return new;
 }
yyL1:;

  }
  if (t->Kind == kACF_NEW) {
/* line 291 "SMParallel.puma" */
   return t->ACF_NEW.NEW_BODY;

  }
  if (t->Kind == kACF_REDUCTION) {
/* line 296 "SMParallel.puma" */
  {
/* line 298 "SMParallel.puma" */
   if (! ((sm_parallelization == NO_MP))) goto yyL3;
  }
   return t->ACF_REDUCTION.REDUCTION_BODY;
yyL3:;

/* line 303 "SMParallel.puma" */
   return ApplySMReduction (t, t->ACF_REDUCTION.REDUCTION_BODY);

  }
/* line 308 "SMParallel.puma" */
   return t;

}

tTree MakeParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
/* line 323 "SMParallel.puma" */
 {
  tTree new;
  {
/* line 327 "SMParallel.puma" */
 new_vars  = mBTV_EMPTY ();    
     par_loops = 1;

     t->ACF_DO.DO_BODY = TranslateParBody (t->ACF_DO.DO_BODY);

     MakeLocalLoopVar (t);

     new = mACF_PARALLEL (mBTV_EMPTY(), mBTV_EMPTY (),
                          new_vars, mACF_LIST (t, mACF_EMPTY ()));

     tree_protocol ("translation of SM parallel loop : \n", new);

   
  }
   return new;
 }

  }
  if (t->Kind == kACF_PARALLEL) {
/* line 344 "SMParallel.puma" */
  {
/* line 346 "SMParallel.puma" */
 new_vars = t->ACF_PARALLEL.LOCAL_VARS;

     par_loops = 0;

     t->ACF_PARALLEL.PARALLEL_BODY = TranslateParBody (t->ACF_PARALLEL.PARALLEL_BODY);

     t->ACF_PARALLEL.LOCAL_VARS = new_vars;

   
  }
   return t;

  }
/* line 359 "SMParallel.puma" */
  {
/* line 361 "SMParallel.puma" */
   failure_protocol (MODULE, "MakeParallel", t);
  }
   return t;

}

static tTree TranslateParBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 372 "SMParallel.puma" */
   return ReplaceAST (t, StopTranslation, DoTranslation);

}

static rbool StopTranslation
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
/* line 379 "SMParallel.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_DO) {
/* line 382 "SMParallel.puma" */
  {
/* line 384 "SMParallel.puma" */
   if (! ((IsSMParallelLoop (t)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static tTree DoTranslation
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_HOME) {
/* line 389 "SMParallel.puma" */
   return t->ACF_HOME.HOME_BODY;

  }
  if (t->Kind == kACF_NEW) {
/* line 394 "SMParallel.puma" */
  {
/* line 396 "SMParallel.puma" */
 new_vars = ConcatVars (t->ACF_NEW.NEW_VAR, new_vars); 
  }
   return t->ACF_NEW.NEW_BODY;

  }
  if (t->Kind == kACF_RESIDENT) {
/* line 401 "SMParallel.puma" */
   return t->ACF_RESIDENT.RESIDENT_BODY;

  }
  if (t->Kind == kACF_REDUCTION) {
/* line 406 "SMParallel.puma" */
   return t->ACF_REDUCTION.REDUCTION_BODY;

  }
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kPARDO_INFO) {
/* line 411 "SMParallel.puma" */
  {
/* line 413 "SMParallel.puma" */
   MakeLocalLoopVar (t);
/* line 415 "SMParallel.puma" */
 par_loops ++;

     t->ACF_DO.DO_BODY = TranslateParBody (t->ACF_DO.DO_BODY);

     par_loops --;

     if (par_loops >= MAX_PAR_LOOPS) t->ACF_DO.DO_DEP_INFO = mSERIAL_INFO ();

   
  }
   return t;

  }
  }
/* line 428 "SMParallel.puma" */
  {
/* line 430 "SMParallel.puma" */
   MakeLocalLoopVar (t);
  }
   return t;

}

static void MakeLocalLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
/* line 437 "SMParallel.puma" */
  {
/* line 439 "SMParallel.puma" */
 new_vars = mBTV_LIST (CopyTree(t->ACF_DO.DO_ID), new_vars); 
  }
   return;

  }
;
}

static tTree ApplySMReduction
# if defined __STDC__ | defined __cplusplus
(register tTree reduction, register tTree stmts)
# else
(reduction, stmts)
 register tTree reduction;
 register tTree stmts;
# endif
{
  if (reduction->Kind == kACF_REDUCTION) {
  if (reduction->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 452 "SMParallel.puma" */
  {
/* line 454 "SMParallel.puma" */
   if (! ((TreeRank (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem) > 0))) goto yyL1;
  {
/* line 456 "SMParallel.puma" */
   set_protocol_stmt (reduction);
/* line 458 "SMParallel.puma" */
   error_protocol ("SM reduction only for scalar variables");
/* line 459 "SMParallel.puma" */
   tree_protocol ("illegal reduction variable : ", reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem);
  }
  }
   return stmts;
yyL1:;

  }
  }
  }
/* line 464 "SMParallel.puma" */
 {
  tTree new;
  {
/* line 468 "SMParallel.puma" */
 global_reduction = reduction; 

     tree_protocol ("apply reduction : \n", reduction);

     new = ReplaceAST (stmts, StopREDUCTION, TranslateREDUCTION);

     tree_protocol ("result of applied reduction : \n", new);

   
  }
   return new;
 }

}

static rbool StopREDUCTION
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
/* line 491 "SMParallel.puma" */
  {
/* line 493 "SMParallel.puma" */
   if (! ((IsSMParallelLoop (t)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kACF_PARALLEL) {
/* line 496 "SMParallel.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree TranslateREDUCTION
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_PARALLEL) {
/* line 507 "SMParallel.puma" */
  {
/* line 509 "SMParallel.puma" */
 t->ACF_PARALLEL.REDUCTION_VARS = CombineBTV (GetRedVar(global_reduction), t->ACF_PARALLEL.REDUCTION_VARS); 
  }
   return t;

  }
/* line 514 "SMParallel.puma" */
   return t;

}

static tTree GetRedVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_REDUCTION) {
/* line 520 "SMParallel.puma" */
   return t->ACF_REDUCTION.REDUCTION_VAR;

  }
/* line 527 "SMParallel.puma" */
  {
/* line 529 "SMParallel.puma" */
   failure_protocol (MODULE, "GetRedVar", t);
  }
   return NoTree;

}

void AutoScope
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_PARALLEL) {
/* line 544 "SMParallel.puma" */
  {
/* line 547 "SMParallel.puma" */
 local1 = t->ACF_PARALLEL.REDUCTION_VARS;
     local2 = t->ACF_PARALLEL.LOCAL_VARS;
     global = t->ACF_PARALLEL.SHARED_VARS;
   
/* line 552 "SMParallel.puma" */
   tree_protocol ("AutoScope : local vars = ", t->ACF_PARALLEL.LOCAL_VARS);
/* line 553 "SMParallel.puma" */
   tree_protocol ("AutoScope : shared vars = ", t->ACF_PARALLEL.SHARED_VARS);
/* line 554 "SMParallel.puma" */
   tree_protocol ("AutoScope : red vars = ", t->ACF_PARALLEL.REDUCTION_VARS);
/* line 556 "SMParallel.puma" */
   FullTraverseAST (t->ACF_PARALLEL.PARALLEL_BODY, AddSharedVariable);
/* line 558 "SMParallel.puma" */
   tree_protocol ("AutoScope : new shared vars = ", global);
/* line 560 "SMParallel.puma" */
 t->ACF_PARALLEL.SHARED_VARS = global; 
  }
   return;

  }
/* line 563 "SMParallel.puma" */
  {
/* line 564 "SMParallel.puma" */
   failure_protocol (MODULE, "AutoScope", t);
  }
   return;

;
}

static void AddSharedVariable
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
/* line 570 "SMParallel.puma" */
  {
/* line 572 "SMParallel.puma" */
   if (! ((t->USED_VAR.VARNAME->VAR_OBJ.Object != NoObject))) goto yyL1;
  {
/* line 573 "SMParallel.puma" */
   if (! ((IsVarParameter (t->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL1;
  }
  }
   return;
yyL1:;

/* line 576 "SMParallel.puma" */
  {
/* line 578 "SMParallel.puma" */
   if (! ((! IsVarInExp (t->USED_VAR.VARNAME->VAR_OBJ.Ident, local1)))) goto yyL2;
  {
/* line 579 "SMParallel.puma" */
   if (! ((! IsVarInExp (t->USED_VAR.VARNAME->VAR_OBJ.Ident, local2)))) goto yyL2;
  {
/* line 580 "SMParallel.puma" */
   if (! ((! IsVarInExp (t->USED_VAR.VARNAME->VAR_OBJ.Ident, global)))) goto yyL2;
  {
/* line 582 "SMParallel.puma" */
 global = mBTV_LIST (CopyTree (t), global); 
  }
  }
  }
  }
   return;
yyL2:;

  }
  if (t->Kind == kLOOP_VAR) {
/* line 587 "SMParallel.puma" */
  {
/* line 589 "SMParallel.puma" */
   if (! ((! IsVarInExp (t->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, local1)))) goto yyL3;
  {
/* line 590 "SMParallel.puma" */
   if (! ((! IsVarInExp (t->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, local2)))) goto yyL3;
  {
/* line 591 "SMParallel.puma" */
   if (! ((! IsVarInExp (t->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, global)))) goto yyL3;
  {
/* line 593 "SMParallel.puma" */
 global = mBTV_LIST (CopyTree (t), global); 
  }
  }
  }
  }
   return;
yyL3:;

  }
;
}

tTree FinalSM
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_PARALLEL) {
  if (t->ACF_PARALLEL.REDUCTION_VARS->Kind == kBTV_EMPTY) {
/* line 606 "SMParallel.puma" */
   return t;

  }
/* line 611 "SMParallel.puma" */
  {
/* line 613 "SMParallel.puma" */
   if (! ((sm_parallelization == CRAY_MP))) goto yyL2;
  {
/* line 615 "SMParallel.puma" */
   set_protocol_stmt (t);
/* line 617 "SMParallel.puma" */
   serious_warning_protocol ("REDUCTION not supported here");
  }
  }
   return t->ACF_PARALLEL.PARALLEL_BODY;
yyL2:;

/* line 622 "SMParallel.puma" */
   return t;

  }
/* line 627 "SMParallel.puma" */
  {
/* line 629 "SMParallel.puma" */
   failure_protocol (MODULE, "FinalSM", t);
  }
   return NoTree;

}

void BeginSMParallel ARGS ((void))
{
}

void CloseSMParallel ARGS ((void))
{
}
