# include "ReplaceExp.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 24 "ReplaceExp.puma" */


# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Expressions.h"   /* AddConstant */
# include "TreeOps.h"       /* IsVarInExp  */

# define MODULE "ReplaceExp"

       /*************************************************
       *                                                *
       *  global data for replacing expressions         *
       *                                                *
       *************************************************/

# define NEW_LOOP_ID  1

static int action;

static tTree new_loop_id;    /*  action == NEW_LOOP_ID    */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyReplaceExp.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ReplaceExp_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ReplaceExp, routine %s failed\n",
  yyFunction);
 ReplaceExp_Exit ();
}

void RenameLoopId ARGS ((tTree t, tTree id, tTree id_new));
tTree RenameExpLoopId ARGS ((tTree t, tTree id, tTree id_new));
static void DoReplace ARGS ((tTree t, tTree id));
static tTree ReplaceExp ARGS ((tTree exp, tTree id));
static void ChangeLoopId ARGS ((tTree loopid1, tTree loopid2));
static void MakeNewLoopId ARGS ((tTree loop, tTree id_new));
static tTree GetNewLoopId ARGS ((void));

void RenameLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree id, register tTree id_new)
# else
(t, id, id_new)
 register tTree t;
 register tTree id;
 register tTree id_new;
# endif
{
  if (id->Kind == kLOOP_VAR) {
  if (id_new->Kind == kLOOP_VAR) {
/* line 81 "ReplaceExp.puma" */
  {
/* line 83 "ReplaceExp.puma" */
   action = NEW_LOOP_ID;
/* line 84 "ReplaceExp.puma" */
   new_loop_id = id_new;
/* line 86 "ReplaceExp.puma" */
   DoReplace (t, id);
  }
   return;

  }
  }
/* line 89 "ReplaceExp.puma" */
  {
/* line 91 "ReplaceExp.puma" */
   failure2_protocol (MODULE, "RenameLoopId", id, id_new);
  }
   return;

;
}

tTree RenameExpLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree id, register tTree id_new)
# else
(t, id, id_new)
 register tTree t;
 register tTree id;
 register tTree id_new;
# endif
{
  if (id->Kind == kLOOP_VAR) {
  if (id_new->Kind == kLOOP_VAR) {
/* line 102 "ReplaceExp.puma" */
  {
/* line 104 "ReplaceExp.puma" */
   action = NEW_LOOP_ID;
/* line 105 "ReplaceExp.puma" */
   new_loop_id = id_new;
  }
   return ReplaceExp (t, id);

  }
  }
/* line 110 "ReplaceExp.puma" */
  {
/* line 112 "ReplaceExp.puma" */
   failure2_protocol (MODULE, "RenameExpLoopId", id, id_new);
  }
   return t;

}

static void DoReplace
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree id)
# else
(t, id)
 register tTree t;
 register tTree id;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 126 "ReplaceExp.puma" */
  {
/* line 127 "ReplaceExp.puma" */
   DoReplace (t->ACF_LIST.Elem, id);
/* line 128 "ReplaceExp.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 131 "ReplaceExp.puma" */
   return;

  case kACF_DUMMY:
/* line 134 "ReplaceExp.puma" */
   return;

  case kACF_BASIC:
/* line 137 "ReplaceExp.puma" */
  {
/* line 138 "ReplaceExp.puma" */
   t = t->ACF_BASIC.BASIC_STMT;
   goto yyRecursion;
  }

  case kACF_IF:
/* line 141 "ReplaceExp.puma" */
  {
/* line 142 "ReplaceExp.puma" */
 t->ACF_IF.IF_EXP = ReplaceExp (t->ACF_IF.IF_EXP, id); 
/* line 143 "ReplaceExp.puma" */
   DoReplace (t->ACF_IF.THEN_PART, id);
/* line 144 "ReplaceExp.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_WHERE:
/* line 147 "ReplaceExp.puma" */
  {
/* line 149 "ReplaceExp.puma" */
 t->ACF_WHERE.WHERE_EXP = ReplaceExp (t->ACF_WHERE.WHERE_EXP, id); 
/* line 150 "ReplaceExp.puma" */
   DoReplace (t->ACF_WHERE.TRUE_PART, id);
/* line 151 "ReplaceExp.puma" */
   t = t->ACF_WHERE.FALSE_PART;
   goto yyRecursion;
  }

  case kACF_CASE:
/* line 154 "ReplaceExp.puma" */
  {
/* line 155 "ReplaceExp.puma" */
 t->ACF_CASE.CASE_EXP = ReplaceExp (t->ACF_CASE.CASE_EXP, id); 
/* line 156 "ReplaceExp.puma" */
   t = t->ACF_CASE.CASE_ALTS;
   goto yyRecursion;
  }

  case kSELECTED_ACF_LIST:
/* line 159 "ReplaceExp.puma" */
  {
/* line 160 "ReplaceExp.puma" */
   DoReplace (t->SELECTED_ACF_LIST.Elem, id);
/* line 161 "ReplaceExp.puma" */
   t = t->SELECTED_ACF_LIST.Next;
   goto yyRecursion;
  }

  case kSELECTED_ACF_EMPTY:
/* line 164 "ReplaceExp.puma" */
   return;

  case kSELECTED_ACF_NODE:
/* line 167 "ReplaceExp.puma" */
  {
/* line 168 "ReplaceExp.puma" */
   DoReplace (t->SELECTED_ACF_NODE.SELECT_LIST, id);
/* line 169 "ReplaceExp.puma" */
   t = t->SELECTED_ACF_NODE.SELECT_ACFS;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 172 "ReplaceExp.puma" */
  {
/* line 173 "ReplaceExp.puma" */
 t->ACF_WHILE.WHILE_EXP = ReplaceExp (t->ACF_WHILE.WHILE_EXP, id); 
/* line 174 "ReplaceExp.puma" */
   t = t->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;
  }

  case kACF_FORALL:
/* line 177 "ReplaceExp.puma" */
  {
/* line 179 "ReplaceExp.puma" */
 t->ACF_FORALL.FORALL_RANGE = ReplaceExp (t->ACF_FORALL.FORALL_RANGE, id); 
/* line 180 "ReplaceExp.puma" */
   t = t->ACF_FORALL.FORALL_BODY;
   goto yyRecursion;
  }

  case kACF_DO:
/* line 183 "ReplaceExp.puma" */
 {
  tTree temp_id;
  {
/* line 185 "ReplaceExp.puma" */
   if (! ((TreeVarName (t->ACF_DO.DO_ID) == TreeVarName (new_loop_id)))) goto yyL13;
  {
/* line 189 "ReplaceExp.puma" */
   temp_id = GetNewLoopId ();
/* line 191 "ReplaceExp.puma" */
   MakeNewLoopId (t, temp_id);
/* line 195 "ReplaceExp.puma" */
 t->ACF_DO.DO_RANGE = ReplaceExp (t->ACF_DO.DO_RANGE, id); 
/* line 197 "ReplaceExp.puma" */
   DoReplace (t->ACF_DO.DO_BODY, id);
/* line 201 "ReplaceExp.puma" */
   MakeNewLoopId (t, id);
  }
  }
   return;
 }
yyL13:;

/* line 204 "ReplaceExp.puma" */
  {
/* line 206 "ReplaceExp.puma" */
 t->ACF_DO.DO_RANGE = ReplaceExp (t->ACF_DO.DO_RANGE, id); 
/* line 208 "ReplaceExp.puma" */
   t = t->ACF_DO.DO_BODY;
   goto yyRecursion;
  }

  case kACF_ON:
/* line 217 "ReplaceExp.puma" */
  {
/* line 219 "ReplaceExp.puma" */
   DoReplace (t->ACF_ON.ON_BODY, id);
/* line 220 "ReplaceExp.puma" */
   t = t->ACF_ON.ON_SPECS;
   goto yyRecursion;
  }

  case kON_LIST:
/* line 223 "ReplaceExp.puma" */
  {
/* line 225 "ReplaceExp.puma" */
   DoReplace (t->ON_LIST.Elem, id);
/* line 226 "ReplaceExp.puma" */
   t = t->ON_LIST.Next;
   goto yyRecursion;
  }

  case kON_EMPTY:
/* line 229 "ReplaceExp.puma" */
   return;

  case kON_SPEC:
/* line 232 "ReplaceExp.puma" */
  {
/* line 234 "ReplaceExp.puma" */
 t->ON_SPEC.ON_VAL = ReplaceExp (t->ON_SPEC.ON_VAL, id); 
  }
   return;

  case kASSIGN_STMT:
/* line 243 "ReplaceExp.puma" */
  {
/* line 245 "ReplaceExp.puma" */
   DoReplace (t->ASSIGN_STMT.ASSIGN_VAR, id);
/* line 246 "ReplaceExp.puma" */
 t->ASSIGN_STMT.ASSIGN_EXP = ReplaceExp (t->ASSIGN_STMT.ASSIGN_EXP, id); 
  }
   return;

  case kFORMAT_STMT:
/* line 249 "ReplaceExp.puma" */
   return;

  case kIO_STMT:
/* line 253 "ReplaceExp.puma" */
  {
/* line 254 "ReplaceExp.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }

  case kCALL_STMT:
/* line 257 "ReplaceExp.puma" */
  {
/* line 258 "ReplaceExp.puma" */
   t = t->CALL_STMT.CALL_PARAMS;
   goto yyRecursion;
  }

  case kREDUCE_STMT:
/* line 261 "ReplaceExp.puma" */
  {
/* line 263 "ReplaceExp.puma" */
   t = t->REDUCE_STMT.RED_PARAMS;
   goto yyRecursion;
  }

  case kALLOCATE_STMT:
/* line 266 "ReplaceExp.puma" */
  {
/* line 267 "ReplaceExp.puma" */
   DoReplace (t->ALLOCATE_STMT.PARAMS, id);
/* line 268 "ReplaceExp.puma" */
 t->ALLOCATE_STMT.STATUS = ReplaceExp (t->ALLOCATE_STMT.STATUS, id); 
  }
   return;

  case kDEALLOCATE_STMT:
/* line 271 "ReplaceExp.puma" */
  {
/* line 272 "ReplaceExp.puma" */
   DoReplace (t->DEALLOCATE_STMT.PARAMS, id);
/* line 273 "ReplaceExp.puma" */
 t->DEALLOCATE_STMT.STATUS = ReplaceExp (t->DEALLOCATE_STMT.STATUS, id); 
  }
   return;

  case kINHERIT_DSP_STMT:
/* line 276 "ReplaceExp.puma" */
   return;

  case kCREATE_DSP_STMT:
/* line 279 "ReplaceExp.puma" */
   return;

  case kFREE_DSP_STMT:
/* line 282 "ReplaceExp.puma" */
   return;

  case kGOTO_STMT:
/* line 285 "ReplaceExp.puma" */
   return;

  case kCOMP_IF_STMT:
/* line 288 "ReplaceExp.puma" */
  {
/* line 290 "ReplaceExp.puma" */
 t->COMP_IF_STMT.IF_EXP = ReplaceExp (t->COMP_IF_STMT.IF_EXP, id); 
  }
   return;

  case kSTOP_STMT:
/* line 293 "ReplaceExp.puma" */
  {
/* line 295 "ReplaceExp.puma" */
 t->STOP_STMT.STOP_CONST = ReplaceExp (t->STOP_STMT.STOP_CONST, id); 
  }
   return;

  case kRETURN_STMT:
/* line 298 "ReplaceExp.puma" */
  {
/* line 300 "ReplaceExp.puma" */
 t->RETURN_STMT.RETURN_EXP = ReplaceExp (t->RETURN_STMT.RETURN_EXP, id); 
  }
   return;

  case kBTP_LIST:
/* line 309 "ReplaceExp.puma" */
  {
/* line 310 "ReplaceExp.puma" */
   DoReplace (t->BTP_LIST.Elem, id);
/* line 311 "ReplaceExp.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  case kBTP_EMPTY:
/* line 314 "ReplaceExp.puma" */
   return;

  case kBTE_LIST:
/* line 317 "ReplaceExp.puma" */
  {
/* line 318 "ReplaceExp.puma" */
 t->BTE_LIST.Elem = ReplaceExp (t->BTE_LIST.Elem, id); 
/* line 319 "ReplaceExp.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  case kBTE_EMPTY:
/* line 322 "ReplaceExp.puma" */
   return;

  case kVAR_PARAM:
  if (t->VAR_PARAM.V->Kind == kLOOP_VAR) {
  if (id->Kind == kLOOP_VAR) {
/* line 333 "ReplaceExp.puma" */
  {
/* line 336 "ReplaceExp.puma" */
   if (! ((t->VAR_PARAM.V->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident == id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL37;
  {
/* line 338 "ReplaceExp.puma" */
 if (action == NEW_LOOP_ID)
        ChangeLoopId (t->VAR_PARAM.V, new_loop_id);
   
  }
  }
   return;
yyL37:;

  }
  }
  if (t->VAR_PARAM.V->Kind == kADDR) {
/* line 343 "ReplaceExp.puma" */
  {
/* line 344 "ReplaceExp.puma" */
 t->VAR_PARAM.V->ADDR.E = ReplaceExp (t->VAR_PARAM.V->ADDR.E, id); 
  }
   return;

  }
/* line 347 "ReplaceExp.puma" */
  {
/* line 348 "ReplaceExp.puma" */
   t = t->VAR_PARAM.V;
   goto yyRecursion;
  }

  case kFUNC_PARAM:
/* line 351 "ReplaceExp.puma" */
   return;

  case kPROC_PARAM:
/* line 354 "ReplaceExp.puma" */
   return;

  case kNO_PARAM:
/* line 357 "ReplaceExp.puma" */
   return;

  case kUSED_VAR:
/* line 366 "ReplaceExp.puma" */
   return;

  case kLOOP_VAR:
/* line 369 "ReplaceExp.puma" */
   return;

  case kSUBSTRING_VAR:
/* line 372 "ReplaceExp.puma" */
  {
/* line 374 "ReplaceExp.puma" */
   DoReplace (t->SUBSTRING_VAR.IND_VAR, id);
/* line 375 "ReplaceExp.puma" */
 t->SUBSTRING_VAR.IND_EXP = ReplaceExp (t->SUBSTRING_VAR.IND_EXP, id); 
  }
   return;

  case kSELECTED_VAR:
/* line 378 "ReplaceExp.puma" */
  {
/* line 380 "ReplaceExp.puma" */
   t = t->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }

  case kINDEXED_VAR:
/* line 383 "ReplaceExp.puma" */
  {
/* line 385 "ReplaceExp.puma" */
   DoReplace (t->INDEXED_VAR.IND_VAR, id);
/* line 386 "ReplaceExp.puma" */
   t = t->INDEXED_VAR.IND_EXPS;
   goto yyRecursion;
  }

  }

/* line 389 "ReplaceExp.puma" */
  {
/* line 390 "ReplaceExp.puma" */
   failure_protocol (MODULE, "DoReplace", t);
  }
   return;

;
}

static tTree ReplaceExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id)
# else
(exp, id)
 register tTree exp;
 register tTree id;
# endif
{
/* line 401 "ReplaceExp.puma" */
  {
/* line 403 "ReplaceExp.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  {
/* line 404 "ReplaceExp.puma" */
   failure_protocol (MODULE, "ReplaceExp with exp = NoTree", exp);
  }
  }
   return NoTree;
yyL1:;

/* line 408 "ReplaceExp.puma" */
  {
/* line 410 "ReplaceExp.puma" */
   if (! ((id == NoTree))) goto yyL2;
  {
/* line 411 "ReplaceExp.puma" */
   failure_protocol (MODULE, "ReplaceExp with id = NoTree", id);
  }
  }
   return NoTree;
yyL2:;

/* line 415 "ReplaceExp.puma" */
  {
/* line 417 "ReplaceExp.puma" */
   if (! ((! IsVarInExp (TreeVarName (id), exp)))) goto yyL3;
  }
   return exp;
yyL3:;


  switch (exp->Kind) {
  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kLOOP_VAR) {
  if (id->Kind == kLOOP_VAR) {
/* line 422 "ReplaceExp.puma" */
  {
/* line 424 "ReplaceExp.puma" */
   if (! ((TreeVarName (exp->VAR_EXP.V) == TreeVarName (id)))) goto yyL4;
  {
/* line 426 "ReplaceExp.puma" */
   ChangeLoopId (exp->VAR_EXP.V, new_loop_id);
  }
  }
   return exp;
yyL4:;

  }
  }
/* line 431 "ReplaceExp.puma" */
  {
/* line 432 "ReplaceExp.puma" */
   DoReplace (exp->VAR_EXP.V, id);
  }
   return exp;

  case kADDR:
/* line 436 "ReplaceExp.puma" */
  {
/* line 437 "ReplaceExp.puma" */
   DoReplace (exp->ADDR.E, id);
  }
   return exp;

  case kARRAY_EXP:
/* line 441 "ReplaceExp.puma" */
  {
/* line 442 "ReplaceExp.puma" */
   DoReplace (exp->ARRAY_EXP.ELEMENTS, id);
  }
   return exp;

  case kSLICE_EXP:
/* line 446 "ReplaceExp.puma" */
  {
/* line 447 "ReplaceExp.puma" */
 exp->SLICE_EXP.FIRST =  ReplaceExp (exp->SLICE_EXP.FIRST, id); 
      exp->SLICE_EXP.STOP  =  ReplaceExp (exp->SLICE_EXP.STOP, id);
      exp->SLICE_EXP.INC  =  ReplaceExp (exp->SLICE_EXP.INC, id);
    
  }
   return exp;

  case kOP_EXP:
/* line 454 "ReplaceExp.puma" */
  {
/* line 455 "ReplaceExp.puma" */
 exp->OP_EXP.OPND1 = ReplaceExp (exp->OP_EXP.OPND1, id);
      exp->OP_EXP.OPND2 = ReplaceExp (exp->OP_EXP.OPND2, id);
    
  }
   return exp;

  case kOP1_EXP:
/* line 461 "ReplaceExp.puma" */
  {
/* line 462 "ReplaceExp.puma" */
 exp->OP1_EXP.OPND = ReplaceExp (exp->OP1_EXP.OPND, id); 
  }
   return exp;

  case kFUNC_CALL_EXP:
/* line 466 "ReplaceExp.puma" */
  {
/* line 467 "ReplaceExp.puma" */
 DoReplace (exp->FUNC_CALL_EXP.FUNC_PARAMS, id); 
  }
   return exp;

  case kDO_EXP:
/* line 471 "ReplaceExp.puma" */
  {
/* line 472 "ReplaceExp.puma" */
 exp->DO_EXP.RANGE = ReplaceExp (exp->DO_EXP.RANGE, id);
      DoReplace (exp->DO_EXP.BODY, id);
    
  }
   return exp;

  }

/* line 478 "ReplaceExp.puma" */
  {
/* line 479 "ReplaceExp.puma" */
   failure_protocol (MODULE, "ReplaceExp", exp);
  }
   return NoTree;

}

static void ChangeLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree loopid1, register tTree loopid2)
# else
(loopid1, loopid2)
 register tTree loopid1;
 register tTree loopid2;
# endif
{
  if (loopid1->Kind == kLOOP_VAR) {
  if (loopid2->Kind == kLOOP_VAR) {
/* line 491 "ReplaceExp.puma" */
  {
/* line 494 "ReplaceExp.puma" */
 loopid1->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident = loopid2->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident;
    loopid1->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Object  = loopid2->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Object;
  
  }
   return;

  }
  }
/* line 504 "ReplaceExp.puma" */
  {
/* line 506 "ReplaceExp.puma" */
   failure2_protocol (MODULE, "ChangeLoopId", loopid1, loopid2);
  }
   return;

;
}

static void MakeNewLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree loop, register tTree id_new)
# else
(loop, id_new)
 register tTree loop;
 register tTree id_new;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 519 "ReplaceExp.puma" */
 {
  tTree save_id;
  {
/* line 523 "ReplaceExp.puma" */
   save_id = new_loop_id;
/* line 525 "ReplaceExp.puma" */
   new_loop_id = id_new;
/* line 527 "ReplaceExp.puma" */
   DoReplace (loop->ACF_DO.DO_BODY, loop->ACF_DO.DO_ID);
/* line 531 "ReplaceExp.puma" */
 loop->ACF_DO.DO_ID = CopyTree (id_new); 
/* line 533 "ReplaceExp.puma" */
   set_protocol_stmt (loop);
/* line 534 "ReplaceExp.puma" */
   stmt_protocol ("renamed loop variable");
/* line 536 "ReplaceExp.puma" */
   new_loop_id = save_id;
  }
   return;
 }

  }
;
}

static tTree GetNewLoopId
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 549 "ReplaceExp.puma" */
   return mLOOP_VAR (mVAR_OBJ (0, IsIdent ("IXYZx4y1z3")));

}

void BeginReplaceExp ARGS ((void))
{
}

void CloseReplaceExp ARGS ((void))
{
}
