# include "RemoteAccess.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 17 "RemoteAccess.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Types.h"

# define MODULE "RemoteAccess"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyRemoteAccess.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* RemoteAccess_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module RemoteAccess, routine %s failed\n",
  yyFunction);
 RemoteAccess_Exit ();
}

tTree TranslateRMA ARGS ((tTree stmt));
static void Find_RMA_Read ARGS ((tTree lhs, tTree rhs, rbool * yyP3, tTree * yyP2, tTree * yyP1));
static void Find_RMA_Write ARGS ((tTree lhs, tTree rhs, rbool * yyP7, tTree * yyP6, tTree * yyP5, int * yyP4));
static tTree GetTheUsedVariable ARGS ((tTree var));
static rbool LocalAccess ARGS ((tTree exp));
static rbool LocalVar ARGS ((tTree var));

tTree TranslateRMA
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 39 "RemoteAccess.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 41 "RemoteAccess.puma" */
   Find_RMA_Read (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, & yyV1, & yyV2, & yyV3);
/* line 43 "RemoteAccess.puma" */
   if (! ((yyV1))) goto yyL1;
  }
   return mACF_RM_READ (yyV3, yyV2);
 }
yyL1:;

/* line 48 "RemoteAccess.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  tTree yyV3;
  int yyV4;
  {
/* line 50 "RemoteAccess.puma" */
   Find_RMA_Write (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 52 "RemoteAccess.puma" */
   if (! ((yyV1))) goto yyL2;
  }
   return mACF_RM_WRITE (yyV4, yyV2, yyV3);
 }
yyL2:;

  }
  }
/* line 57 "RemoteAccess.puma" */
   return stmt;

}

static void Find_RMA_Read
# if defined __STDC__ | defined __cplusplus
(register tTree lhs, register tTree rhs, register rbool * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(lhs, rhs, yyP3, yyP2, yyP1)
 register tTree lhs;
 register tTree rhs;
 register rbool * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (rhs->Kind == kVAR_EXP) {
  if (rhs->VAR_EXP.V->Kind == kREMOTE_VAR) {
/* line 74 "RemoteAccess.puma" */
   * yyP3 = rtrue;
   * yyP2 = rhs->VAR_EXP.V->REMOTE_VAR.VAR;
   * yyP1 = lhs;
   return;

  }
  }
/* line 77 "RemoteAccess.puma" */
   * yyP3 = rfalse;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void Find_RMA_Write
# if defined __STDC__ | defined __cplusplus
(register tTree lhs, register tTree rhs, register rbool * yyP7, register tTree * yyP6, register tTree * yyP5, register int * yyP4)
# else
(lhs, rhs, yyP7, yyP6, yyP5, yyP4)
 register tTree lhs;
 register tTree rhs;
 register rbool * yyP7;
 register tTree * yyP6;
 register tTree * yyP5;
 register int * yyP4;
# endif
{
  if (lhs->Kind == kREMOTE_VAR) {
/* line 92 "RemoteAccess.puma" */
  {
/* line 94 "RemoteAccess.puma" */
   if (! ((LocalAccess (rhs)))) goto yyL1;
  }
   * yyP7 = rtrue;
   * yyP6 = lhs->REMOTE_VAR.VAR;
   * yyP5 = rhs;
   * yyP4 = 0;
   return;
yyL1:;

/* line 97 "RemoteAccess.puma" */
 {
  tTree fn;
  tTree exp;
  tTree red_exp;
  int op;
  {
/* line 104 "RemoteAccess.puma" */
   CheckReduction (lhs->REMOTE_VAR.VAR, rhs, GetTheUsedVariable (lhs->REMOTE_VAR.VAR), & fn, & red_exp);
/* line 106 "RemoteAccess.puma" */
   if (! ((fn != NoTree))) goto yyL2;
  {
/* line 110 "RemoteAccess.puma" */
   op = GetGlobalOp (TreeType (lhs->REMOTE_VAR.VAR), fn->PROC_OBJ.Ident);
  }
  }
   * yyP7 = rtrue;
   * yyP6 = lhs->REMOTE_VAR.VAR;
   * yyP5 = red_exp;
   * yyP4 = op;
   return;
 }
yyL2:;

  }
/* line 113 "RemoteAccess.puma" */
   * yyP7 = rfalse;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   * yyP4 = 0;
   return;

;
}

static tTree GetTheUsedVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kUSED_VAR) {
/* line 118 "RemoteAccess.puma" */
   return var;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 123 "RemoteAccess.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  }
  if (var->Kind == kREMOTE_VAR) {
/* line 128 "RemoteAccess.puma" */
   var = var->REMOTE_VAR.VAR;
   goto yyRecursion;

  }
/* line 133 "RemoteAccess.puma" */
   return var;

}

static rbool LocalAccess
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kOP_EXP) {
/* line 148 "RemoteAccess.puma" */
  {
/* line 150 "RemoteAccess.puma" */
   if (! ((LocalAccess (exp->OP_EXP.OPND1)))) goto yyL1;
  {
/* line 151 "RemoteAccess.puma" */
   if (! ((LocalAccess (exp->OP_EXP.OPND2)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  if (exp->Kind == kOP1_EXP) {
/* line 154 "RemoteAccess.puma" */
  {
/* line 156 "RemoteAccess.puma" */
   if (! ((LocalAccess (exp->OP1_EXP.OPND)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (exp->Kind == kVAR_EXP) {
/* line 159 "RemoteAccess.puma" */
  {
/* line 161 "RemoteAccess.puma" */
   if (! ((LocalVar (exp->VAR_EXP.V)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (exp->Kind == kBTE_LIST) {
/* line 164 "RemoteAccess.puma" */
  {
/* line 166 "RemoteAccess.puma" */
   if (! ((LocalAccess (exp->BTE_LIST.Elem)))) goto yyL4;
  {
/* line 167 "RemoteAccess.puma" */
   if (! ((LocalAccess (exp->BTE_LIST.Next)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

  }
  if (exp->Kind == kBTE_EMPTY) {
/* line 170 "RemoteAccess.puma" */
   return rtrue;

  }
  if (exp->Kind == kCONST_EXP) {
/* line 173 "RemoteAccess.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool LocalVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
/* line 186 "RemoteAccess.puma" */
  {
/* line 188 "RemoteAccess.puma" */
   return rfalse;
  }

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 191 "RemoteAccess.puma" */
  {
/* line 193 "RemoteAccess.puma" */
   if (! ((LocalAccess (var->INDEXED_VAR.IND_EXPS)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (var->Kind == kUSED_VAR) {
/* line 196 "RemoteAccess.puma" */
   return rtrue;

  }
  if (var->Kind == kLOOP_VAR) {
/* line 199 "RemoteAccess.puma" */
   return rtrue;

  }
  return rfalse;
}

void BeginRemoteAccess ARGS ((void))
{
}

void CloseRemoteAccess ARGS ((void))
{
}
