# include "RegShadow.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 34 "RegShadow.puma" */


# include <stdio.h>
# include <string.h>

# include "Idents.h"
# include "StringM.h"
# include "DynArray.h"

# include "protocol.h"

# include "Rank.h"            /* VarRank                           */
# include "Objects.h"         /* IsVarCommon                       */
# include "DefTable.h"        /* IsVarCommon                       */
# include "Expressions.h"     /* GetIntConstValue                  */
# include "Transform.h"       /* ExpToVarParam                     */

# define MODULE "RegShadow"

/*********************************************************************
*                                                                    *
*                                                                    *
*********************************************************************/

# define SHADOW_VARS_INIT_SIZE  10

static unsigned long all_shadow_max = 0;   /* must be a long variable */

static tObject *all_shadow;        /* size is given by all_cand_max */

static int no_var_shadow = 0;            /* number of candidates */

static rbool FindShadowVar (var)
tObject var;

{ rbool found;
  int   i;
  tIdent id;

  found = rfalse;

  for (i=0; (i < no_var_shadow) && (!found); i++)
     found = (var == all_shadow[i]);

  return found;

} /* FindShadowVar */

static void SetShadowVar (var)
tObject var;

{ /* make sure that all_shadow [all_shadow_max] is big enough */

  if (no_var_shadow >= all_shadow_max)

     { /* we have to make/extend the dynamic array 'all_candidates' */

       if (all_shadow_max == 0)

           { all_shadow_max = SHADOW_VARS_INIT_SIZE;
             MakeArray ((char * *) &all_shadow, &all_shadow_max,
                        (long) sizeof (tObject));
           }

        else

           ExtendArray ((char * *) &all_shadow, &all_shadow_max,
                        (long) sizeof (tObject));

#ifdef DEBUG
        printf ("Made/Extended array all_shadow to size = %d\n",
                 all_shadow_max);
#endif

        if (all_shadow == (tObject *) 0)

          failure_protocol (MODULE,
             "could not make/extend array for shadow objs", NoTree);
      }

   all_shadow [no_var_shadow] = var;

   no_var_shadow ++;

}  /* SetShadowVar */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyRegShadow.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* RegShadow_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module RegShadow, routine %s failed\n",
  yyFunction);
 RegShadow_Exit ();
}

void SetDefaultShadow ARGS ((tDefinitions obj));
static rbool UnitInSource ARGS ((tDefinitions unit));
static rbool IsAvailableUnit ARGS ((tTree t, tTree unit_decl));
static tTree MakeDummyUserShadow ARGS ((int len));
static tTree MakeNoUserShadow ARGS ((int len));
rbool IsZeroShadow ARGS ((tTree shadow_specs));
static rbool IsZeroExp ARGS ((tTree exp));
void IncShadowSystemSize ARGS ((tTree shadow_spec, int full_flag, int pos));
static void IncLeftSize ARGS ((tTree shadow_spec, int new_size));
static void IncRightSize ARGS ((tTree shadow_spec, int new_size));
static void SetFullFlag ARGS ((tTree shadow_spec, int full_flag));
rbool HasEnoughShadow ARGS ((tDefinitions var, pshift pos));
static rbool HasEnoughVarShadow ARGS ((tTree shadow_specs, int dim, pshift pos));
static rbool SufficientShadowSize ARGS ((tTree shadow_spec, int pos));
static int GetShadowWidth ARGS ((tTree user_size, int system_size));
tTree MakeShadowParams ARGS ((tTree t));
void AddShadowWidth ARGS ((tTree exp_shape, tTree shadow_spec));
static tTree GetLeftShadowWidth ARGS ((tTree t));
static tTree GetRightShadowWidth ARGS ((tTree t));
static tTree GetShadowWidthExp ARGS ((tTree user_size, int system_size));
static rbool HasSystemShadow ARGS ((tDefinitions var));
static rbool HasEnoughSystemShadow ARGS ((tDefinitions var));
static rbool MoreSystemShadow ARGS ((tTree spec));
static rbool EnoughSystemShadow ARGS ((tTree spec));
static rbool MoreSystemSize ARGS ((int system_size, tTree user_size));
static rbool EnoughSystemSize ARGS ((int system_size, tTree user_size));
static void PrintBestShadow ARGS ((tTree spec, MsgString s));
void FixShadowVarObject ARGS ((tDefinitions obj));
void PrintShadowInfo ARGS ((void));
static void PrintVarShadowInfo ARGS ((tDefinitions var));
static void PrintCommonVarShadowInfo ARGS ((tDefinitions var));
static rbool IsCommonReference ARGS ((tDefinitions var));
static rbool MainProgramAvailable ARGS ((tTree units));

void SetDefaultShadow
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 139 "RegShadow.puma" */
  {
/* line 141 "RegShadow.puma" */
   if (! ((obj->VarObject.shadow == NoTree))) goto yyL1;
  {
/* line 143 "RegShadow.puma" */
   if (! ((UnitInSource (obj->VarObject.in)))) goto yyL1;
  {
/* line 146 "RegShadow.puma" */
   obj->VarObject.shadow = MakeDummyUserShadow (VarRank (obj));
  }
  }
  }
   return;
yyL1:;

/* line 149 "RegShadow.puma" */
  {
/* line 151 "RegShadow.puma" */
   if (! ((obj->VarObject.shadow == NoTree))) goto yyL2;
  {
/* line 153 "RegShadow.puma" */
   obj->VarObject.shadow = MakeNoUserShadow (VarRank (obj));
  }
  }
   return;
yyL2:;

  }
/* line 156 "RegShadow.puma" */
  {
/* line 158 "RegShadow.puma" */
   failure_protocol (MODULE, "SetDefaultShadow", obj->Object.decl);
  }
   return;

;
}

static rbool UnitInSource
# if defined __STDC__ | defined __cplusplus
(register tDefinitions unit)
# else
(unit)
 register tDefinitions unit;
# endif
{
/* line 171 "RegShadow.puma" */
  {
/* line 173 "RegShadow.puma" */
   if (! ((unit == NoObject))) goto yyL1;
  {
/* line 174 "RegShadow.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 177 "RegShadow.puma" */
  {
/* line 179 "RegShadow.puma" */
   if (! ((IsAvailableUnit (TreeRoot, unit->Object.decl)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 184 "RegShadow.puma" */
  {
/* line 186 "RegShadow.puma" */
   if (! ((UnitInSource (unit->Object.in)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  return rfalse;
}

static rbool IsAvailableUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree unit_decl)
# else
(t, unit_decl)
 register tTree t;
 register tTree unit_decl;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
/* line 197 "RegShadow.puma" */
  {
/* line 199 "RegShadow.puma" */
   if (! ((IsAvailableUnit (t->COMP_UNIT.COMP_ELEMENTS, unit_decl)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kUNIT_LIST) {
/* line 202 "RegShadow.puma" */
  {
/* line 204 "RegShadow.puma" */
   if (! ((t->UNIT_LIST.Elem == unit_decl))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 207 "RegShadow.puma" */
  {
/* line 209 "RegShadow.puma" */
   if (! ((IsAvailableUnit (t->UNIT_LIST.Next, unit_decl)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static tTree MakeDummyUserShadow
# if defined __STDC__ | defined __cplusplus
(register int len)
# else
(len)
 register int len;
# endif
{
/* line 219 "RegShadow.puma" */
  {
/* line 221 "RegShadow.puma" */
   if (! ((len <= 0))) goto yyL1;
  }
   return mSHADOW_EMPTY ();
yyL1:;

/* line 226 "RegShadow.puma" */
 {
  tTree shadow_spec;
  {
/* line 230 "RegShadow.puma" */
   shadow_spec = mSHADOW_SPEC (0, mDUMMY_EXP (), mDUMMY_EXP (), 0, 0, 0, 0);
  }
   return mSHADOW_LIST (shadow_spec, MakeDummyUserShadow (len - 1));
 }

}

static tTree MakeNoUserShadow
# if defined __STDC__ | defined __cplusplus
(register int len)
# else
(len)
 register int len;
# endif
{
/* line 237 "RegShadow.puma" */
  {
/* line 239 "RegShadow.puma" */
   if (! ((len <= 0))) goto yyL1;
  }
   return mSHADOW_EMPTY ();
yyL1:;

/* line 244 "RegShadow.puma" */
 {
  tTree shadow_spec;
  tTree user_left;
  tTree user_right;
  {
/* line 251 "RegShadow.puma" */
   user_left = MakeConstant (0);
/* line 252 "RegShadow.puma" */
   user_right = MakeConstant (0);
/* line 254 "RegShadow.puma" */
   shadow_spec = mSHADOW_SPEC (0, user_left, user_right, 0, 0, 0, 0);
  }
   return mSHADOW_LIST (shadow_spec, MakeNoUserShadow (len - 1));
 }

}

rbool IsZeroShadow
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_specs)
# else
(shadow_specs)
 register tTree shadow_specs;
# endif
{
/* line 267 "RegShadow.puma" */
  {
/* line 269 "RegShadow.puma" */
   if (! ((shadow_specs == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (shadow_specs->Kind == kSHADOW_DECL) {
/* line 272 "RegShadow.puma" */
  {
/* line 274 "RegShadow.puma" */
   if (! ((IsZeroShadow (shadow_specs->SHADOW_DECL.SHADOWS)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (shadow_specs->Kind == kSHADOW_LIST) {
/* line 277 "RegShadow.puma" */
  {
/* line 279 "RegShadow.puma" */
   if (! ((IsZeroShadow (shadow_specs->SHADOW_LIST.Elem)))) goto yyL3;
  {
/* line 280 "RegShadow.puma" */
   if (! ((IsZeroShadow (shadow_specs->SHADOW_LIST.Next)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  if (shadow_specs->Kind == kSHADOW_EMPTY) {
/* line 283 "RegShadow.puma" */
   return rtrue;

  }
  if (shadow_specs->Kind == kSHADOW_SPEC) {
/* line 286 "RegShadow.puma" */
  {
/* line 289 "RegShadow.puma" */
   if (! ((IsZeroExp (shadow_specs->SHADOW_SPEC.SHADOW_LEFT)))) goto yyL5;
  {
/* line 290 "RegShadow.puma" */
   if (! ((IsZeroExp (shadow_specs->SHADOW_SPEC.SHADOW_RIGHT)))) goto yyL5;
  {
/* line 291 "RegShadow.puma" */
   if (! ((shadow_specs->SHADOW_SPEC.left_size == 0))) goto yyL5;
  {
/* line 292 "RegShadow.puma" */
   if (! ((shadow_specs->SHADOW_SPEC.right_size == 0))) goto yyL5;
  }
  }
  }
  }
   return rtrue;
yyL5:;

  }
  return rfalse;
}

static rbool IsZeroExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
/* line 297 "RegShadow.puma" */
  {
/* line 299 "RegShadow.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (exp->Kind == kDUMMY_EXP) {
/* line 302 "RegShadow.puma" */
   return rtrue;

  }
/* line 305 "RegShadow.puma" */
 {
  rbool found;
  int val;
  {
/* line 310 "RegShadow.puma" */
   GetIntConstValue (exp, & found, & val);
/* line 312 "RegShadow.puma" */
   if (! ((found))) goto yyL3;
  {
/* line 313 "RegShadow.puma" */
   if (! ((val == 0))) goto yyL3;
  }
  }
   return rtrue;
 }
yyL3:;

  return rfalse;
}

void IncShadowSystemSize
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_spec, register int full_flag, register int pos)
# else
(shadow_spec, full_flag, pos)
 register tTree shadow_spec;
 register int full_flag;
 register int pos;
# endif
{
/* line 331 "RegShadow.puma" */
  {
/* line 333 "RegShadow.puma" */
   if (! ((pos < 0))) goto yyL1;
  {
/* line 335 "RegShadow.puma" */
   IncRightSize (shadow_spec, - pos);
/* line 336 "RegShadow.puma" */
   SetFullFlag (shadow_spec, full_flag);
  }
  }
   return;
yyL1:;

/* line 339 "RegShadow.puma" */
  {
/* line 341 "RegShadow.puma" */
   if (! ((pos > 0))) goto yyL2;
  {
/* line 343 "RegShadow.puma" */
   IncLeftSize (shadow_spec, pos);
/* line 344 "RegShadow.puma" */
   SetFullFlag (shadow_spec, full_flag);
  }
  }
   return;
yyL2:;

;
}

static void IncLeftSize
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_spec, register int new_size)
# else
(shadow_spec, new_size)
 register tTree shadow_spec;
 register int new_size;
# endif
{
 yyRecursion:
/* line 349 "RegShadow.puma" */
  {
/* line 351 "RegShadow.puma" */
   if (! ((new_size > MAX_SHADOW_SIZE))) goto yyL1;
  {
/* line 353 "RegShadow.puma" */
   new_size = MAX_SHADOW_SIZE;
   goto yyRecursion;
  }
  }
yyL1:;

  if (shadow_spec->Kind == kSHADOW_SPEC) {
/* line 356 "RegShadow.puma" */
  {
/* line 358 "RegShadow.puma" */
   if (! ((shadow_spec->SHADOW_SPEC.left_size < new_size))) goto yyL2;
  {
/* line 360 "RegShadow.puma" */
 shadow_spec->SHADOW_SPEC.left_size = new_size; 
  }
  }
   return;
yyL2:;

/* line 363 "RegShadow.puma" */
   return;

  }
/* line 366 "RegShadow.puma" */
  {
/* line 368 "RegShadow.puma" */
   failure_protocol (MODULE, "IncLeftSize", shadow_spec);
  }
   return;

;
}

static void IncRightSize
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_spec, register int new_size)
# else
(shadow_spec, new_size)
 register tTree shadow_spec;
 register int new_size;
# endif
{
 yyRecursion:
/* line 373 "RegShadow.puma" */
  {
/* line 375 "RegShadow.puma" */
   if (! ((new_size > MAX_SHADOW_SIZE))) goto yyL1;
  {
/* line 377 "RegShadow.puma" */
   new_size = MAX_SHADOW_SIZE;
   goto yyRecursion;
  }
  }
yyL1:;

  if (shadow_spec->Kind == kSHADOW_SPEC) {
/* line 380 "RegShadow.puma" */
  {
/* line 382 "RegShadow.puma" */
   if (! ((shadow_spec->SHADOW_SPEC.right_size < new_size))) goto yyL2;
  {
/* line 384 "RegShadow.puma" */
 shadow_spec->SHADOW_SPEC.right_size = new_size; 
  }
  }
   return;
yyL2:;

/* line 387 "RegShadow.puma" */
   return;

  }
/* line 390 "RegShadow.puma" */
  {
/* line 392 "RegShadow.puma" */
   failure_protocol (MODULE, "IncRightSize", shadow_spec);
  }
   return;

;
}

static void SetFullFlag
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_spec, register int full_flag)
# else
(shadow_spec, full_flag)
 register tTree shadow_spec;
 register int full_flag;
# endif
{
/* line 397 "RegShadow.puma" */
  {
/* line 399 "RegShadow.puma" */
   if (! ((! full_flag))) goto yyL1;
  }
   return;
yyL1:;

  if (shadow_spec->Kind == kSHADOW_SPEC) {
/* line 402 "RegShadow.puma" */
  {
/* line 404 "RegShadow.puma" */
   shadow_spec->SHADOW_SPEC.full_flag = 1;
  }
   return;

  }
;
}

rbool HasEnoughShadow
# if defined __STDC__ | defined __cplusplus
(register tDefinitions var, pshift pos)
# else
(var, pos)
 register tDefinitions var;
 pshift pos;
# endif
{
  if (var->Kind == kVarObject) {
/* line 415 "RegShadow.puma" */
  {
/* line 417 "RegShadow.puma" */
   if (! ((HasEnoughVarShadow (var->VarObject.shadow, 0, pos)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool HasEnoughVarShadow
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_specs, register int dim, pshift pos)
# else
(shadow_specs, dim, pos)
 register tTree shadow_specs;
 register int dim;
 pshift pos;
# endif
{
/* line 430 "RegShadow.puma" */
  {
/* line 432 "RegShadow.puma" */
   if (! ((shadow_specs == NoTree))) goto yyL1;
  {
/* line 433 "RegShadow.puma" */
   if (! ((IsZeroShifting (pos)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 436 "RegShadow.puma" */
  {
/* line 438 "RegShadow.puma" */
   if (! ((shadow_specs == NoTree))) goto yyL2;
  {
/* line 439 "RegShadow.puma" */
   return rfalse;
  }
  }
yyL2:;

  if (shadow_specs->Kind == kSHADOW_EMPTY) {
/* line 442 "RegShadow.puma" */
   return rtrue;

  }
  if (shadow_specs->Kind == kSHADOW_LIST) {
/* line 447 "RegShadow.puma" */
  {
/* line 449 "RegShadow.puma" */
   if (! ((SufficientShadowSize (shadow_specs->SHADOW_LIST.Elem, pos -> shift_pos [dim])))) goto yyL4;
  {
/* line 450 "RegShadow.puma" */
   if (! ((HasEnoughVarShadow (shadow_specs->SHADOW_LIST.Next, dim + 1, pos)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static rbool SufficientShadowSize
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_spec, register int pos)
# else
(shadow_spec, pos)
 register tTree shadow_spec;
 register int pos;
# endif
{
  if (shadow_spec->Kind == kSHADOW_SPEC) {
/* line 466 "RegShadow.puma" */
  {
/* line 469 "RegShadow.puma" */
   if (! ((GetShadowWidth (shadow_spec->SHADOW_SPEC.SHADOW_RIGHT, shadow_spec->SHADOW_SPEC.right_size) >= - pos))) goto yyL1;
  {
/* line 470 "RegShadow.puma" */
   if (! ((GetShadowWidth (shadow_spec->SHADOW_SPEC.SHADOW_LEFT, shadow_spec->SHADOW_SPEC.left_size) >= pos))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static int GetShadowWidth
# if defined __STDC__ | defined __cplusplus
(register tTree user_size, register int system_size)
# else
(user_size, system_size)
 register tTree user_size;
 register int system_size;
# endif
{
/* line 484 "RegShadow.puma" */
  {
/* line 486 "RegShadow.puma" */
   if (! ((user_size == NoTree))) goto yyL1;
  }
   return system_size;
yyL1:;

  if (user_size->Kind == kDUMMY_EXP) {
/* line 491 "RegShadow.puma" */
   return system_size;

  }
/* line 496 "RegShadow.puma" */
 {
  rbool found;
  int val;
  {
/* line 501 "RegShadow.puma" */
   GetIntConstValue (user_size, & found, & val);
/* line 503 "RegShadow.puma" */
   if (! ((found))) goto yyL3;
  {
/* line 504 "RegShadow.puma" */
   if (! ((val > 0))) goto yyL3;
  }
  }
   return val;
 }
yyL3:;

/* line 509 "RegShadow.puma" */
   return 0;

}

tTree MakeShadowParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSHADOW_EMPTY) {
/* line 525 "RegShadow.puma" */
   return mBTP_EMPTY ();

  }
  if (t->Kind == kSHADOW_LIST) {
/* line 530 "RegShadow.puma" */
   return mBTP_LIST (ExpToVarParam (GetLeftShadowWidth (t->SHADOW_LIST.Elem)), mBTP_LIST (ExpToVarParam (GetRightShadowWidth (t->SHADOW_LIST.Elem)), MakeShadowParams (t->SHADOW_LIST.Next)));

  }
/* line 537 "RegShadow.puma" */
  {
/* line 539 "RegShadow.puma" */
   failure_protocol (MODULE, "MakeShadowParams", t);
  }
   return NoTree;

}

void AddShadowWidth
# if defined __STDC__ | defined __cplusplus
(register tTree exp_shape, register tTree shadow_spec)
# else
(exp_shape, shadow_spec)
 register tTree exp_shape;
 register tTree shadow_spec;
# endif
{
  if (exp_shape->Kind == kEXPLICIT_SHAPE) {
  if (shadow_spec->Kind == kSHADOW_SPEC) {
/* line 560 "RegShadow.puma" */
 {
  tTree exp;
  rbool found;
  int val;
  {
/* line 566 "RegShadow.puma" */
   exp = GetLeftShadowWidth (shadow_spec);
/* line 568 "RegShadow.puma" */
   GetIntConstValue (exp, & found, & val);
/* line 570 "RegShadow.puma" */
   if ((found)) {
/* line 571 "RegShadow.puma" */
   exp_shape->EXPLICIT_SHAPE.LOWER = AddConstant (exp_shape->EXPLICIT_SHAPE.LOWER, - val);
   } else {
/* line 573 "RegShadow.puma" */
   exp_shape->EXPLICIT_SHAPE.LOWER = mOP_EXP (mOP_MINUS (), exp_shape->EXPLICIT_SHAPE.LOWER, exp);
   }
/* line 576 "RegShadow.puma" */
   exp = GetRightShadowWidth (shadow_spec);
/* line 578 "RegShadow.puma" */
   GetIntConstValue (exp, & found, & val);
/* line 580 "RegShadow.puma" */
   if ((found)) {
/* line 581 "RegShadow.puma" */
   exp_shape->EXPLICIT_SHAPE.UPPER = AddConstant (exp_shape->EXPLICIT_SHAPE.UPPER, val);
   } else {
/* line 583 "RegShadow.puma" */
   exp_shape->EXPLICIT_SHAPE.UPPER = mOP_EXP (mOP_PLUS (), exp_shape->EXPLICIT_SHAPE.UPPER, exp);
   }
  }
   return;
 }

  }
  }
/* line 587 "RegShadow.puma" */
  {
/* line 589 "RegShadow.puma" */
   failure2_protocol (MODULE, "AddShadowWidth", exp_shape, shadow_spec);
  }
   return;

;
}

static tTree GetLeftShadowWidth
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSHADOW_SPEC) {
/* line 600 "RegShadow.puma" */
   return GetShadowWidthExp (t->SHADOW_SPEC.SHADOW_LEFT, t->SHADOW_SPEC.left_size);

  }
 yyAbort ("GetLeftShadowWidth");
 { tTree yyDummy; return yyDummy; }
}

static tTree GetRightShadowWidth
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSHADOW_SPEC) {
/* line 607 "RegShadow.puma" */
   return GetShadowWidthExp (t->SHADOW_SPEC.SHADOW_RIGHT, t->SHADOW_SPEC.right_size);

  }
 yyAbort ("GetRightShadowWidth");
 { tTree yyDummy; return yyDummy; }
}

static tTree GetShadowWidthExp
# if defined __STDC__ | defined __cplusplus
(register tTree user_size, register int system_size)
# else
(user_size, system_size)
 register tTree user_size;
 register int system_size;
# endif
{
/* line 620 "RegShadow.puma" */
  {
/* line 622 "RegShadow.puma" */
   if (! ((user_size == NoTree))) goto yyL1;
  }
   return MakeConstant (system_size);
yyL1:;

  if (user_size->Kind == kDUMMY_EXP) {
/* line 627 "RegShadow.puma" */
   return MakeConstant (system_size);

  }
/* line 632 "RegShadow.puma" */
   return user_size;

}

static rbool HasSystemShadow
# if defined __STDC__ | defined __cplusplus
(register tDefinitions var)
# else
(var)
 register tDefinitions var;
# endif
{
  if (var->Kind == kVarObject) {
/* line 648 "RegShadow.puma" */
  {
/* line 650 "RegShadow.puma" */
   if (! ((var->VarObject.shadow == NoTree))) goto yyL1;
  {
/* line 652 "RegShadow.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 655 "RegShadow.puma" */
  {
/* line 657 "RegShadow.puma" */
   if (! ((MoreSystemShadow (var->VarObject.shadow)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static rbool HasEnoughSystemShadow
# if defined __STDC__ | defined __cplusplus
(register tDefinitions var)
# else
(var)
 register tDefinitions var;
# endif
{
  if (var->Kind == kVarObject) {
/* line 662 "RegShadow.puma" */
  {
/* line 664 "RegShadow.puma" */
   if (! ((var->VarObject.shadow == NoTree))) goto yyL1;
  {
/* line 666 "RegShadow.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 669 "RegShadow.puma" */
  {
/* line 671 "RegShadow.puma" */
   if (! ((EnoughSystemShadow (var->VarObject.shadow)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static rbool MoreSystemShadow
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
  if (spec->Kind == kSHADOW_DECL) {
/* line 680 "RegShadow.puma" */
  {
/* line 682 "RegShadow.puma" */
   if (! ((MoreSystemShadow (spec->SHADOW_DECL.SHADOWS)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (spec->Kind == kSHADOW_LIST) {
/* line 685 "RegShadow.puma" */
  {
/* line 687 "RegShadow.puma" */
   if (! ((MoreSystemShadow (spec->SHADOW_LIST.Elem)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 690 "RegShadow.puma" */
  {
/* line 692 "RegShadow.puma" */
   if (! ((MoreSystemShadow (spec->SHADOW_LIST.Next)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (spec->Kind == kSHADOW_SPEC) {
/* line 695 "RegShadow.puma" */
  {
/* line 697 "RegShadow.puma" */
   if (! ((MoreSystemSize (spec->SHADOW_SPEC.left_size, spec->SHADOW_SPEC.SHADOW_LEFT)))) goto yyL4;
  }
   return rtrue;
yyL4:;

/* line 700 "RegShadow.puma" */
  {
/* line 702 "RegShadow.puma" */
   if (! ((MoreSystemSize (spec->SHADOW_SPEC.right_size, spec->SHADOW_SPEC.SHADOW_RIGHT)))) goto yyL5;
  }
   return rtrue;
yyL5:;

  }
  return rfalse;
}

static rbool EnoughSystemShadow
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
  if (spec->Kind == kSHADOW_DECL) {
/* line 711 "RegShadow.puma" */
  {
/* line 713 "RegShadow.puma" */
   if (! ((EnoughSystemShadow (spec->SHADOW_DECL.SHADOWS)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (spec->Kind == kSHADOW_LIST) {
/* line 716 "RegShadow.puma" */
  {
/* line 718 "RegShadow.puma" */
   if (! ((EnoughSystemShadow (spec->SHADOW_LIST.Elem)))) goto yyL2;
  {
/* line 719 "RegShadow.puma" */
   if (! ((EnoughSystemShadow (spec->SHADOW_LIST.Next)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  if (spec->Kind == kSHADOW_EMPTY) {
/* line 722 "RegShadow.puma" */
   return rtrue;

  }
  if (spec->Kind == kSHADOW_SPEC) {
/* line 725 "RegShadow.puma" */
  {
/* line 728 "RegShadow.puma" */
   if (! ((EnoughSystemSize (spec->SHADOW_SPEC.left_size, spec->SHADOW_SPEC.SHADOW_LEFT)))) goto yyL4;
  {
/* line 729 "RegShadow.puma" */
   if (! ((EnoughSystemSize (spec->SHADOW_SPEC.right_size, spec->SHADOW_SPEC.SHADOW_RIGHT)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static rbool MoreSystemSize
# if defined __STDC__ | defined __cplusplus
(register int system_size, register tTree user_size)
# else
(system_size, user_size)
 register int system_size;
 register tTree user_size;
# endif
{
  if (user_size->Kind == kDUMMY_EXP) {
/* line 738 "RegShadow.puma" */
  {
/* line 740 "RegShadow.puma" */
   if (! ((system_size > 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
/* line 743 "RegShadow.puma" */
 {
  rbool found;
  int val;
  {
/* line 748 "RegShadow.puma" */
   GetIntConstValue (user_size, & found, & val);
/* line 750 "RegShadow.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 751 "RegShadow.puma" */
   if (! ((system_size > val))) goto yyL2;
  }
  }
   return rtrue;
 }
yyL2:;

  return rfalse;
}

static rbool EnoughSystemSize
# if defined __STDC__ | defined __cplusplus
(register int system_size, register tTree user_size)
# else
(system_size, user_size)
 register int system_size;
 register tTree user_size;
# endif
{
  if (user_size->Kind == kDUMMY_EXP) {
/* line 760 "RegShadow.puma" */
   return rtrue;

  }
/* line 763 "RegShadow.puma" */
 {
  rbool found;
  int val;
  {
/* line 768 "RegShadow.puma" */
   GetIntConstValue (user_size, & found, & val);
/* line 770 "RegShadow.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 771 "RegShadow.puma" */
   if (! ((system_size <= val))) goto yyL2;
  }
  }
   return rtrue;
 }
yyL2:;

  return rfalse;
}

static void PrintBestShadow
# if defined __STDC__ | defined __cplusplus
(register tTree spec, MsgString s)
# else
(spec, s)
 register tTree spec;
 MsgString s;
# endif
{
 yyRecursion:
/* line 782 "RegShadow.puma" */
  {
/* line 784 "RegShadow.puma" */
   if (! ((spec == NoTree))) goto yyL1;
  {
/* line 786 "RegShadow.puma" */
   failure_protocol (MODULE, "PrintBestShadow", spec);
  }
  }
   return;
yyL1:;

  if (spec->Kind == kSHADOW_DECL) {
/* line 789 "RegShadow.puma" */
  {
/* line 791 "RegShadow.puma" */
   goto yyRecursion;
  }

  }
  if (spec->Kind == kSHADOW_SPEC) {
/* line 794 "RegShadow.puma" */
  {
/* line 798 "RegShadow.puma" */
 sprintf (s, "%d:%d", spec->SHADOW_SPEC.left_size, spec->SHADOW_SPEC.right_size); 
  }
   return;

  }
  if (spec->Kind == kSHADOW_LIST) {
  if (spec->SHADOW_LIST.Next->Kind == kSHADOW_EMPTY) {
/* line 801 "RegShadow.puma" */
  {
/* line 803 "RegShadow.puma" */
   spec = spec->SHADOW_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 806 "RegShadow.puma" */
  {
/* line 808 "RegShadow.puma" */
 char help [30];
     PrintBestShadow (spec->SHADOW_LIST.Next, help);
     PrintBestShadow (spec->SHADOW_LIST.Elem, s);
     strcat (s, ",");
     strcat (s, help);
   
  }
   return;

  }
/* line 816 "RegShadow.puma" */
  {
/* line 818 "RegShadow.puma" */
   if (! ((spec == NoTree))) goto yyL6;
  {
/* line 820 "RegShadow.puma" */
   failure_protocol (MODULE, "PrintBestShadow", spec);
  }
  }
   return;
yyL6:;

;
}

void FixShadowVarObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 833 "RegShadow.puma" */
  {
/* line 835 "RegShadow.puma" */
   if (! ((FindShadowVar (obj)))) goto yyL1;
  }
   return;
yyL1:;

/* line 838 "RegShadow.puma" */
  {
/* line 840 "RegShadow.puma" */
   SetShadowVar (obj);
  }
   return;

;
}

void PrintShadowInfo
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 854 "RegShadow.puma" */
 {
  int i;
  tDefinitions var;
  {
/* line 858 "RegShadow.puma" */
/* line 858 "RegShadow.puma" */
   i = 0;
   while (i < no_var_shadow) {
/* line 862 "RegShadow.puma" */
   var = all_shadow [i];
/* line 864 "RegShadow.puma" */
   set_protocol_stmt (var->VarObject.decl);
/* line 866 "RegShadow.puma" */
   if ((IsVarCommon (var))) {
/* line 867 "RegShadow.puma" */
   PrintCommonVarShadowInfo (var);
   } else {
/* line 869 "RegShadow.puma" */
   PrintVarShadowInfo (var);
   }
/* line 858 "RegShadow.puma" */
   i ++;
   }
  }
   return;
 }

;
}

static void PrintVarShadowInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions var)
# else
(var)
 register tDefinitions var;
# endif
{
/* line 886 "RegShadow.puma" */

char var_name[MAX_ID_LENGTH];
char shadow_string [256];
char msg [256];

/* line 892 "RegShadow.puma" */
  {
/* line 896 "RegShadow.puma" */
   if (! ((! HasSystemShadow (var)))) goto yyL1;
  }
   return;
yyL1:;

/* line 899 "RegShadow.puma" */
  {
/* line 903 "RegShadow.puma" */
   if (! ((EnoughSystemShadow (var->VarObject.shadow)))) goto yyL2;
  {
/* line 905 "RegShadow.puma" */
   GetString (var->VarObject.Ident, var_name);
/* line 906 "RegShadow.puma" */
   PrintBestShadow (var->VarObject.shadow, shadow_string);
/* line 908 "RegShadow.puma" */
   sprintf (msg, "shadow %s(%s) added", var_name, shadow_string);
/* line 910 "RegShadow.puma" */
   info_protocol (msg);
  }
  }
   return;
yyL2:;

/* line 914 "RegShadow.puma" */
  {
/* line 918 "RegShadow.puma" */
   GetString (var->VarObject.Ident, var_name);
/* line 919 "RegShadow.puma" */
   PrintBestShadow (var->VarObject.shadow, shadow_string);
/* line 921 "RegShadow.puma" */
   sprintf (msg, "shadow %s(%s) should improve performance", var_name, shadow_string);
/* line 924 "RegShadow.puma" */
   serious_warning_protocol (msg);
  }
   return;

;
}

static void PrintCommonVarShadowInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions var)
# else
(var)
 register tDefinitions var;
# endif
{
/* line 935 "RegShadow.puma" */

char var_name[MAX_ID_LENGTH];
char shadow_string [256];
char msg [256];

/* line 941 "RegShadow.puma" */
  {
/* line 943 "RegShadow.puma" */
   if (! ((! IsCommonReference (var)))) goto yyL1;
  }
   return;
yyL1:;

/* line 946 "RegShadow.puma" */
  {
/* line 948 "RegShadow.puma" */
   if (! ((MainProgramAvailable (TreeRoot)))) goto yyL2;
  {
/* line 950 "RegShadow.puma" */
   PrintVarShadowInfo (var);
  }
  }
   return;
yyL2:;

/* line 953 "RegShadow.puma" */
  {
/* line 957 "RegShadow.puma" */
   if (! ((! HasSystemShadow (var)))) goto yyL3;
  }
   return;
yyL3:;

/* line 960 "RegShadow.puma" */
  {
/* line 964 "RegShadow.puma" */
   if (! ((EnoughSystemShadow (var->VarObject.shadow)))) goto yyL4;
  {
/* line 966 "RegShadow.puma" */
   GetString (var->VarObject.Ident, var_name);
/* line 967 "RegShadow.puma" */
   PrintBestShadow (var->VarObject.shadow, shadow_string);
/* line 969 "RegShadow.puma" */
   sprintf (msg, "shadow %s(%s) in COMMON added, defined in MAIN ?", var_name, shadow_string);
/* line 972 "RegShadow.puma" */
   serious_warning_protocol (msg);
  }
  }
   return;
yyL4:;

;
}

static rbool IsCommonReference
# if defined __STDC__ | defined __cplusplus
(register tDefinitions var)
# else
(var)
 register tDefinitions var;
# endif
{
  if (var->Kind == kVarObject) {
  if (var->VarObject.Kind->Kind == kVarCommon) {
/* line 982 "RegShadow.puma" */
 {
  tDefinitions common;
  {
/* line 986 "RegShadow.puma" */
   common = GetDeclEntry (var->VarObject.Kind->VarCommon.Block, GetCommonEntries ());
/* line 988 "RegShadow.puma" */
   if ((common == NoObject)) {
/* line 990 "RegShadow.puma" */
   failure_protocol (MODULE, "IsCommonReference", var->Object.decl);
   }
/* line 994 "RegShadow.puma" */
/* line 996 "RegShadow.puma" */
   if (! ((var == GetDeclEntry (var->VarObject.Ident, common->CommonObject.CommonElements)))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  }
  }
  return rfalse;
}

static rbool MainProgramAvailable
# if defined __STDC__ | defined __cplusplus
(register tTree units)
# else
(units)
 register tTree units;
# endif
{
 yyRecursion:
  if (units->Kind == kCOMP_UNIT) {
/* line 1007 "RegShadow.puma" */
  {
/* line 1009 "RegShadow.puma" */
   units = units->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  }
  if (units->Kind == kUNIT_LIST) {
  if (units->UNIT_LIST.Elem->Kind == kPROGRAM_DECL) {
/* line 1012 "RegShadow.puma" */
   return rtrue;

  }
/* line 1015 "RegShadow.puma" */
  {
/* line 1017 "RegShadow.puma" */
   units = units->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
  return rfalse;
}

void BeginRegShadow ARGS ((void))
{
}

void CloseRegShadow ARGS ((void))
{
}
