# include "Reductions.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 35 "Reductions.puma" */


# define  MODULE "Reductions"

# include <stdio.h>
# include "Tree.h"
# include "Idents.h"
# include "protocol.h"
# include "DefTable.h"

# include "StringM.h"
# include "Definitions.h"
# include "Types.h"
# include "Transform.h"    /* ExpToVarParam */
# include "Expressions.h"  /* MakeConstant  */
# include "Intrinsics.h"
# include "Objects.h"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyReductions.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Reductions_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Reductions, routine %s failed\n",
  yyFunction);
 Reductions_Exit ();
}

rbool IsReduction ARGS ((tTree t));
rbool IsLocReduction ARGS ((tTree t));
void SplitReduction ARGS ((tTree params, tTree * reduction_array, int * reduction_dim, tTree * reduction_mask));
int GetReductionDim ARGS ((tTree params));
tTree InitReductionStmt ARGS ((tTree var, tTree vtype, tTree func));
static int GetSizeVal ARGS ((tTree type));
static int GetVal ARGS ((tTree kind));
tTree GenRedAssign ARGS ((tTree var, tTree exp, tIdent id));
static tTree MakeOpRedCall ARGS ((tTree op, tTree var, tTree exp));
static tTree MakeIntrRedCall ARGS ((tIdent fname, tTree var, tTree exp));
tTree ResolveReduce ARGS ((tTree t));
static tTree ResolveDoIt ARGS ((tTree t, tIdent func, tTree var, tTree exp, tTree other_stmts));
static tTree LocationStmts ARGS ((tTree params));
int GetGlobalOp ARGS ((tTree type, tIdent redfunc));
static int GetGlobalOp1 ARGS ((tTree type, int size, tIdent redfunc));
tTree GetReductionZero ARGS ((tTree vtype, tIdent ident));

rbool IsReduction
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
/* line 65 "Reductions.puma" */
  {
/* line 67 "Reductions.puma" */
   if (! ((IsReduction (t->ACF_BASIC.BASIC_STMT)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kASSIGN_STMT) {
  if (t->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 70 "Reductions.puma" */
  {
/* line 72 "Reductions.puma" */
   if (! ((IsIntrCall (t->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
/* line 73 "Reductions.puma" */
   if (! ((IntrFuncRed (t->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

rbool IsLocReduction
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
/* line 86 "Reductions.puma" */
  {
/* line 88 "Reductions.puma" */
   if (! ((IsLocReduction (t->ACF_BASIC.BASIC_STMT)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kASSIGN_STMT) {
  if (t->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 91 "Reductions.puma" */
  {
/* line 93 "Reductions.puma" */
   if (! ((IsIntrCall (t->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
/* line 94 "Reductions.puma" */
   if (! (((t->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("MINLOC")) || (t->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("MAXLOC"))))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

void SplitReduction
# if defined __STDC__ | defined __cplusplus
(register tTree params, register tTree * reduction_array, register int * reduction_dim, register tTree * reduction_mask)
# else
(params, reduction_array, reduction_dim, reduction_mask)
 register tTree params;
 register tTree * reduction_array;
 register int * reduction_dim;
 register tTree * reduction_mask;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 113 "Reductions.puma" */
   * reduction_array = params->BTP_LIST.Elem;
   * reduction_dim = GetReductionDim (params);
   * reduction_mask = NoTree;
   return;

  }
  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 117 "Reductions.puma" */
   * reduction_array = params->BTP_LIST.Elem;
   * reduction_dim = GetReductionDim (params);
   * reduction_mask = params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem;
   return;

  }
  }
  }
  }
/* line 121 "Reductions.puma" */
  {
/* line 123 "Reductions.puma" */
   failure_protocol ("Reductions", "SplitReduction", params);
  }
   * reduction_array = NoTree;
   * reduction_dim = 0;
   * reduction_mask = NoTree;
   return;

;
}

int GetReductionDim
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 128 "Reductions.puma" */
   return 0;

  }
  }
  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 133 "Reductions.puma" */
 {
  int idim;
  rbool found;
  {
/* line 138 "Reductions.puma" */
 GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, &found, &idim);
     if (!found) idim = -1;
   
  }
   return idim;
 }

  }
  }
  }
  }
 yyAbort ("GetReductionDim");
 { int yyDummy; return yyDummy; }
}

tTree InitReductionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree vtype, register tTree func)
# else
(var, vtype, func)
 register tTree var;
 register tTree vtype;
 register tTree func;
# endif
{
/* line 163 "Reductions.puma" */

tTree t;

  if (func->Kind == kPROC_OBJ) {
/* line 167 "Reductions.puma" */
  {
/* line 169 "Reductions.puma" */
 t = mCONST_EXP (GetReductionZero (vtype, func->PROC_OBJ.Ident));
     t = mASSIGN_STMT (var, t);
     t = mACF_BASIC (t);
   
  }
   return t;

  }
 yyAbort ("InitReductionStmt");
 { tTree yyDummy; return yyDummy; }
}

static int GetSizeVal
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
  if (type->Kind == kINTEGER_TYPE) {
/* line 178 "Reductions.puma" */
   return GetVal (type->INTEGER_TYPE.SIZE);

  }
  if (type->Kind == kREAL_TYPE) {
/* line 179 "Reductions.puma" */
   return GetVal (type->REAL_TYPE.SIZE);

  }
  if (type->Kind == kBOOLEAN_TYPE) {
/* line 180 "Reductions.puma" */
   return GetVal (type->BOOLEAN_TYPE.SIZE);

  }
  if (type->Kind == kCOMPLEX_TYPE) {
/* line 181 "Reductions.puma" */
   return GetVal (type->COMPLEX_TYPE.SIZE);

  }
 yyAbort ("GetSizeVal");
 { int yyDummy; return yyDummy; }
}

static int GetVal
# if defined __STDC__ | defined __cplusplus
(register tTree kind)
# else
(kind)
 register tTree kind;
# endif
{
  if (kind->Kind == kCONST_EXP) {
  if (kind->CONST_EXP.C->Kind == kINT_CONSTANT) {
/* line 185 "Reductions.puma" */
   return kind->CONST_EXP.C->INT_CONSTANT.value;

  }
  }
 yyAbort ("GetVal");
 { int yyDummy; return yyDummy; }
}

tTree GenRedAssign
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, register tIdent id)
# else
(var, exp, id)
 register tTree var;
 register tTree exp;
 register tIdent id;
# endif
{
  if (equaltIdent (id, IsIdent ("SUM"))) {
/* line 198 "Reductions.puma" */
   return MakeOpRedCall (mOP_PLUS (), var, exp);

  }
  if (equaltIdent (id, IsIdent ("ANY"))) {
/* line 203 "Reductions.puma" */
   return MakeOpRedCall (mOP_OR (), var, exp);

  }
  if (equaltIdent (id, IsIdent ("PARITY"))) {
/* line 208 "Reductions.puma" */
   return MakeOpRedCall (mOP_NEQV (), var, exp);

  }
  if (equaltIdent (id, IsIdent ("ALL"))) {
/* line 213 "Reductions.puma" */
   return MakeOpRedCall (mOP_AND (), var, exp);

  }
  if (equaltIdent (id, IsIdent ("PRODUCT"))) {
/* line 218 "Reductions.puma" */
   return MakeOpRedCall (mOP_TIMES (), var, exp);

  }
  if (equaltIdent (id, IsIdent ("IALL"))) {
/* line 223 "Reductions.puma" */
   return MakeIntrRedCall (IsIdent ("IAND"), var, exp);

  }
  if (equaltIdent (id, IsIdent ("IANY"))) {
/* line 228 "Reductions.puma" */
   return MakeIntrRedCall (IsIdent ("IOR"), var, exp);

  }
  if (equaltIdent (id, IsIdent ("IPARITY"))) {
/* line 233 "Reductions.puma" */
   return MakeIntrRedCall (IsIdent ("IEOR"), var, exp);

  }
  if (equaltIdent (id, IsIdent ("MINVAL"))) {
/* line 238 "Reductions.puma" */
   return MakeIntrRedCall (IsIdent ("MIN"), var, exp);

  }
  if (equaltIdent (id, IsIdent ("MAXVAL"))) {
/* line 243 "Reductions.puma" */
   return MakeIntrRedCall (IsIdent ("MAX"), var, exp);

  }
/* line 248 "Reductions.puma" */
  {
/* line 250 "Reductions.puma" */
   failure_protocol (MODULE, "GenRedAssign", mPROC_OBJ (id));
  }
   return NoTree;

}

static tTree MakeOpRedCall
# if defined __STDC__ | defined __cplusplus
(register tTree op, register tTree var, register tTree exp)
# else
(op, var, exp)
 register tTree op;
 register tTree var;
 register tTree exp;
# endif
{
/* line 262 "Reductions.puma" */
 {
  tTree stmt;
  {
/* line 266 "Reductions.puma" */
 stmt = mOP_EXP (op, mVAR_EXP (CopyTree(var)), exp);
      stmt = mASSIGN_STMT (var, stmt);
    
  }
   return stmt;
 }

}

static tTree MakeIntrRedCall
# if defined __STDC__ | defined __cplusplus
(register tIdent fname, register tTree var, register tTree exp)
# else
(fname, var, exp)
 register tIdent fname;
 register tTree var;
 register tTree exp;
# endif
{
/* line 281 "Reductions.puma" */
 {
  tTree params;
  tTree stmt;
  {
/* line 286 "Reductions.puma" */
 params = mBTP_EMPTY ();
      params = mBTP_LIST (ExpToVarParam (exp), params);
      params = mBTP_LIST (mVAR_PARAM (CopyTree(var)), params);
      stmt   = mPROC_OBJ (fname);
      stmt->PROC_OBJ.Object = GetIntrinsicObject (fname);
      stmt = mFUNC_CALL_EXP (stmt, params);
      stmt = mASSIGN_STMT (var, stmt);
    
  }
   return stmt;
 }

}

tTree ResolveReduce
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->Kind == kBTP_LIST) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
/* line 320 "Reductions.puma" */
   return ResolveDoIt (t, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, LocationStmts (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Next));

  }
/* line 332 "Reductions.puma" */
   return ResolveDoIt (t, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, mVAR_EXP (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V), LocationStmts (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Next));

  }
  }
  }
  }
  }
  }
/* line 343 "Reductions.puma" */
  {
/* line 345 "Reductions.puma" */
   failure_protocol (MODULE, "ResolveReduce", t);
  }
   return NoTree;

}

static tTree ResolveDoIt
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent func, register tTree var, register tTree exp, register tTree other_stmts)
# else
(t, func, var, exp, other_stmts)
 register tTree t;
 register tIdent func;
 register tTree var;
 register tTree exp;
 register tTree other_stmts;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (equaltIdent (func, IsIdent ("COUNT"))) {
/* line 352 "Reductions.puma" */
  {
/* line 356 "Reductions.puma" */
 

      t->ACF_BASIC.BASIC_STMT = MakeOpRedCall (mOP_PLUS (), var, MakeConstant(1));

    
  }
   return mACF_IF (exp, MakeStmtList (t), mACF_EMPTY ());

  }
  if (other_stmts->Kind == kACF_EMPTY) {
/* line 365 "Reductions.puma" */
  {
/* line 369 "Reductions.puma" */
 t->ACF_BASIC.BASIC_STMT = GenRedAssign (var, exp, func); 
  }
   return t;

  }
 {
  tTree cond;
  tTree stmt;
  if (equaltIdent (func, IsIdent ("MINVAL"))) {
/* line 374 "Reductions.puma" */
  {
/* line 381 "Reductions.puma" */
 cond = mOP_EXP (mOP_LT(), CopyTree(exp), mVAR_EXP (CopyTree(var)));
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (var, exp);

      

      stmt = mACF_LIST (t, other_stmts);
      stmt = mACF_IF (cond, stmt, mACF_EMPTY ());
    
  }
   return stmt;

  }
 }
 {
  tTree cond;
  tTree stmt;
  if (equaltIdent (func, IsIdent ("MAXVAL"))) {
/* line 393 "Reductions.puma" */
  {
/* line 400 "Reductions.puma" */
 cond = mOP_EXP (mOP_GT(), CopyTree(exp), mVAR_EXP (CopyTree(var)));
      t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (var, exp);

      

      stmt = mACF_LIST (t, other_stmts);
      stmt = mACF_IF (cond, stmt, mACF_EMPTY ());
    
  }
   return stmt;

  }
 }
  }
/* line 411 "Reductions.puma" */
  {
/* line 413 "Reductions.puma" */
   failure_protocol (MODULE, "ResolveReduce", t);
  }
   return NoTree;

}

static tTree LocationStmts
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
/* line 429 "Reductions.puma" */

tTree stmt;

  if (params->Kind == kBTP_EMPTY) {
/* line 433 "Reductions.puma" */
   return mACF_EMPTY ();

  }
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
/* line 438 "Reductions.puma" */
  {
/* line 440 "Reductions.puma" */
 stmt = mASSIGN_STMT (params->BTP_LIST.Elem->VAR_PARAM.V, params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E);
      stmt = mACF_BASIC (stmt);
    
  }
   return mACF_LIST (stmt, LocationStmts (params->BTP_LIST.Next->BTP_LIST.Next));

  }
/* line 447 "Reductions.puma" */
  {
/* line 449 "Reductions.puma" */
 stmt = mASSIGN_STMT (params->BTP_LIST.Elem->VAR_PARAM.V, mVAR_EXP (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V));
      stmt = mACF_BASIC (stmt);
    
  }
   return mACF_LIST (stmt, LocationStmts (params->BTP_LIST.Next->BTP_LIST.Next));

  }
  }
  }
  }
 yyAbort ("LocationStmts");
 { tTree yyDummy; return yyDummy; }
}

int GetGlobalOp
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tIdent redfunc)
# else
(type, redfunc)
 register tTree type;
 register tIdent redfunc;
# endif
{
/* line 466 "Reductions.puma" */
   return GetGlobalOp1 (type, GetSizeVal (type), redfunc);

}

static int GetGlobalOp1
# if defined __STDC__ | defined __cplusplus
(register tTree type, register int size, register tIdent redfunc)
# else
(type, size, redfunc)
 register tTree type;
 register int size;
 register tIdent redfunc;
# endif
{
  if (type->Kind == kBOOLEAN_TYPE) {
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("ANY"))) {
/* line 473 "Reductions.puma" */
   return 17;

  }
  }
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("ALL"))) {
/* line 477 "Reductions.puma" */
   return 16;

  }
  }
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("PARITY"))) {
/* line 481 "Reductions.puma" */
   return 18;

  }
  }
  }
  if (type->Kind == kINTEGER_TYPE) {
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("SUM"))) {
/* line 485 "Reductions.puma" */
   return 7;

  }
  }
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("PRODUCT"))) {
/* line 489 "Reductions.puma" */
   return 10;

  }
  }
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("MINVAL"))) {
/* line 493 "Reductions.puma" */
   return 1;

  }
  }
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("MAXVAL"))) {
/* line 497 "Reductions.puma" */
   return default_int_size;

  }
  }
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("IALL"))) {
/* line 501 "Reductions.puma" */
   return 13;

  }
  }
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("IANY"))) {
/* line 505 "Reductions.puma" */
   return 14;

  }
  }
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("IPARITY"))) {
/* line 509 "Reductions.puma" */
   return 15;

  }
  }
  if (equalint (size, 1 * default_int_size)) {
  if (equaltIdent (redfunc, IsIdent ("COUNT"))) {
/* line 513 "Reductions.puma" */
   return 7;

  }
  }
  }
  if (type->Kind == kREAL_TYPE) {
  if (equalint (size, 1 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("SUM"))) {
/* line 517 "Reductions.puma" */
   return 8;

  }
  }
  if (equalint (size, 1 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("PRODUCT"))) {
/* line 521 "Reductions.puma" */
   return 11;

  }
  }
  if (equalint (size, 1 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("MINVAL"))) {
/* line 525 "Reductions.puma" */
   return 2;

  }
  }
  if (equalint (size, 1 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("MAXVAL"))) {
/* line 529 "Reductions.puma" */
   return 5;

  }
  }
  if (equalint (size, 2 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("SUM"))) {
/* line 533 "Reductions.puma" */
   return 9;

  }
  }
  if (equalint (size, 2 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("PRODUCT"))) {
/* line 537 "Reductions.puma" */
   return 12;

  }
  }
  if (equalint (size, 2 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("MINVAL"))) {
/* line 541 "Reductions.puma" */
   return 3;

  }
  }
  if (equalint (size, 2 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("MAXVAL"))) {
/* line 545 "Reductions.puma" */
   return 6;

  }
  }
  }
  if (type->Kind == kCOMPLEX_TYPE) {
  if (equalint (size, 2 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("SUM"))) {
/* line 549 "Reductions.puma" */
   return 19;

  }
  }
  if (equalint (size, 2 * default_real_size)) {
  if (equaltIdent (redfunc, IsIdent ("PRODUCT"))) {
/* line 553 "Reductions.puma" */
   return 20;

  }
  }
  }
/* line 557 "Reductions.puma" */
  {
/* line 558 "Reductions.puma" */
   error_protocol ("This reduction is not handled within ADAPTOR");
/* line 559 "Reductions.puma" */
   tree_protocol ("type is ", type);
  }
   return - 1;

}

tTree GetReductionZero
# if defined __STDC__ | defined __cplusplus
(register tTree vtype, register tIdent ident)
# else
(vtype, ident)
 register tTree vtype;
 register tIdent ident;
# endif
{
  if (vtype->Kind == kBOOLEAN_TYPE) {
/* line 571 "Reductions.puma" */
  {
/* line 573 "Reductions.puma" */
   if (! ((GetVal (vtype->BOOLEAN_TYPE.SIZE) == default_int_size))) goto yyL1;
  {
/* line 574 "Reductions.puma" */
   if (! ((ident == IsIdent ("ANY")))) goto yyL1;
  }
  }
   return mBOOL_CONSTANT (0);
yyL1:;

/* line 579 "Reductions.puma" */
  {
/* line 581 "Reductions.puma" */
   if (! ((GetVal (vtype->BOOLEAN_TYPE.SIZE) == default_int_size))) goto yyL2;
  {
/* line 582 "Reductions.puma" */
   if (! ((ident == IsIdent ("ALL")))) goto yyL2;
  }
  }
   return mBOOL_CONSTANT (1);
yyL2:;

/* line 587 "Reductions.puma" */
  {
/* line 589 "Reductions.puma" */
   if (! ((GetVal (vtype->BOOLEAN_TYPE.SIZE) == default_int_size))) goto yyL3;
  {
/* line 590 "Reductions.puma" */
   if (! ((ident == IsIdent ("PARITY")))) goto yyL3;
  }
  }
   return mBOOL_CONSTANT (0);
yyL3:;

/* line 605 "Reductions.puma" */
  {
/* line 607 "Reductions.puma" */
   if (! ((GetVal (vtype->BOOLEAN_TYPE.SIZE) == default_int_size))) goto yyL5;
  {
/* line 608 "Reductions.puma" */
   if (! ((ident == IsIdent ("COUNT")))) goto yyL5;
  }
  }
   return mINT_CONSTANT (0);
yyL5:;

  }
  if (vtype->Kind == kINTEGER_TYPE) {
/* line 597 "Reductions.puma" */
  {
/* line 599 "Reductions.puma" */
   if (! ((GetVal (vtype->INTEGER_TYPE.SIZE) == default_int_size))) goto yyL4;
  {
/* line 600 "Reductions.puma" */
   if (! ((ident == IsIdent ("COUNT")))) goto yyL4;
  }
  }
   return mINT_CONSTANT (0);
yyL4:;

/* line 613 "Reductions.puma" */
  {
/* line 615 "Reductions.puma" */
   if (! ((GetVal (vtype->INTEGER_TYPE.SIZE) == default_int_size))) goto yyL6;
  {
/* line 616 "Reductions.puma" */
   if (! ((ident == IsIdent ("SUM")))) goto yyL6;
  }
  }
   return mINT_CONSTANT (0);
yyL6:;

/* line 621 "Reductions.puma" */
  {
/* line 623 "Reductions.puma" */
   if (! ((GetVal (vtype->INTEGER_TYPE.SIZE) == default_int_size))) goto yyL7;
  {
/* line 624 "Reductions.puma" */
   if (! ((ident == IsIdent ("PRODUCT")))) goto yyL7;
  }
  }
   return mINT_CONSTANT (1);
yyL7:;

/* line 629 "Reductions.puma" */
  {
/* line 631 "Reductions.puma" */
   if (! ((GetVal (vtype->INTEGER_TYPE.SIZE) == default_int_size))) goto yyL8;
  {
/* line 632 "Reductions.puma" */
   if (! ((ident == IsIdent ("MAXVAL")))) goto yyL8;
  }
  }
   return mINT_CONSTANT (- 2147483647);
yyL8:;

/* line 637 "Reductions.puma" */
  {
/* line 639 "Reductions.puma" */
   if (! ((GetVal (vtype->INTEGER_TYPE.SIZE) == default_int_size))) goto yyL9;
  {
/* line 640 "Reductions.puma" */
   if (! ((ident == IsIdent ("MINVAL")))) goto yyL9;
  }
  }
   return mINT_CONSTANT (2147483647);
yyL9:;

/* line 645 "Reductions.puma" */
  {
/* line 647 "Reductions.puma" */
   if (! ((GetVal (vtype->INTEGER_TYPE.SIZE) == default_int_size))) goto yyL10;
  {
/* line 648 "Reductions.puma" */
   if (! ((ident == IsIdent ("IALL")))) goto yyL10;
  }
  }
   return mINT_CONSTANT (- 1);
yyL10:;

/* line 653 "Reductions.puma" */
  {
/* line 655 "Reductions.puma" */
   if (! ((GetVal (vtype->INTEGER_TYPE.SIZE) == default_int_size))) goto yyL11;
  {
/* line 656 "Reductions.puma" */
   if (! ((ident == IsIdent ("IANY")))) goto yyL11;
  }
  }
   return mINT_CONSTANT (0);
yyL11:;

/* line 661 "Reductions.puma" */
  {
/* line 663 "Reductions.puma" */
   if (! ((GetVal (vtype->INTEGER_TYPE.SIZE) == default_int_size))) goto yyL12;
  {
/* line 664 "Reductions.puma" */
   if (! ((ident == IsIdent ("IPARITY")))) goto yyL12;
  }
  }
   return mINT_CONSTANT (0);
yyL12:;

  }
  if (vtype->Kind == kREAL_TYPE) {
/* line 669 "Reductions.puma" */
  {
/* line 671 "Reductions.puma" */
   if (! ((GetVal (vtype->REAL_TYPE.SIZE) == default_real_size))) goto yyL13;
  {
/* line 672 "Reductions.puma" */
   if (! ((ident == IsIdent ("SUM")))) goto yyL13;
  }
  }
   return mREAL_CONSTANT (PutString ("0.0", 3), default_real_size);
yyL13:;

/* line 677 "Reductions.puma" */
  {
/* line 679 "Reductions.puma" */
   if (! ((GetVal (vtype->REAL_TYPE.SIZE) == default_real_size))) goto yyL14;
  {
/* line 680 "Reductions.puma" */
   if (! ((ident == IsIdent ("PRODUCT")))) goto yyL14;
  }
  }
   return mREAL_CONSTANT (PutString ("1.0", 3), default_real_size);
yyL14:;

/* line 685 "Reductions.puma" */
  {
/* line 687 "Reductions.puma" */
   if (! ((GetVal (vtype->REAL_TYPE.SIZE) == default_real_size))) goto yyL15;
  {
/* line 688 "Reductions.puma" */
   if (! ((ident == IsIdent ("MINVAL")))) goto yyL15;
  }
  }
   return mREAL_CONSTANT (PutString ("3.4028235E+38", 13), default_real_size);
yyL15:;

/* line 693 "Reductions.puma" */
  {
/* line 695 "Reductions.puma" */
   if (! ((GetVal (vtype->REAL_TYPE.SIZE) == default_real_size))) goto yyL16;
  {
/* line 696 "Reductions.puma" */
   if (! ((ident == IsIdent ("MAXVAL")))) goto yyL16;
  }
  }
   return mREAL_CONSTANT (PutString ("-3.4028235E+38", 14), default_real_size);
yyL16:;

/* line 701 "Reductions.puma" */
  {
/* line 703 "Reductions.puma" */
   if (! ((GetVal (vtype->REAL_TYPE.SIZE) == 2 * default_real_size))) goto yyL17;
  {
/* line 704 "Reductions.puma" */
   if (! ((ident == IsIdent ("SUM")))) goto yyL17;
  }
  }
   return mREAL_CONSTANT (PutString ("0.0d0", 5), 2 * default_real_size);
yyL17:;

/* line 709 "Reductions.puma" */
  {
/* line 711 "Reductions.puma" */
   if (! ((GetVal (vtype->REAL_TYPE.SIZE) == 2 * default_real_size))) goto yyL18;
  {
/* line 712 "Reductions.puma" */
   if (! ((ident == IsIdent ("PRODUCT")))) goto yyL18;
  }
  }
   return mREAL_CONSTANT (PutString ("1.0d0", 5), 2 * default_real_size);
yyL18:;

/* line 717 "Reductions.puma" */
  {
/* line 719 "Reductions.puma" */
   if (! ((GetVal (vtype->REAL_TYPE.SIZE) == 2 * default_real_size))) goto yyL19;
  {
/* line 720 "Reductions.puma" */
   if (! ((ident == IsIdent ("MINVAL")))) goto yyL19;
  }
  }
   return mREAL_CONSTANT (PutString ("1.797693134862313E+308", 22), 2 * default_real_size);
yyL19:;

/* line 726 "Reductions.puma" */
  {
/* line 728 "Reductions.puma" */
   if (! ((GetVal (vtype->REAL_TYPE.SIZE) == 2 * default_real_size))) goto yyL20;
  {
/* line 729 "Reductions.puma" */
   if (! ((ident == IsIdent ("MAXVAL")))) goto yyL20;
  }
  }
   return mREAL_CONSTANT (PutString ("-1.797693134862313E+308", 23), 2 * default_real_size);
yyL20:;

  }
  if (vtype->Kind == kCOMPLEX_TYPE) {
/* line 735 "Reductions.puma" */
  {
/* line 737 "Reductions.puma" */
   if (! ((GetVal (vtype->COMPLEX_TYPE.SIZE) == 2 * default_real_size))) goto yyL21;
  {
/* line 738 "Reductions.puma" */
   if (! ((ident == IsIdent ("SUM")))) goto yyL21;
  }
  }
   return mCOMPLEX_CONSTANT (PutString ("0.0", 3), PutString ("0.0", 3));
yyL21:;

/* line 743 "Reductions.puma" */
  {
/* line 745 "Reductions.puma" */
   if (! ((GetVal (vtype->COMPLEX_TYPE.SIZE) == 2 * default_real_size))) goto yyL22;
  {
/* line 746 "Reductions.puma" */
   if (! ((ident == IsIdent ("PRODUCT")))) goto yyL22;
  }
  }
   return mCOMPLEX_CONSTANT (PutString ("1.0", 3), PutString ("0.0", 3));
yyL22:;

  }
/* line 751 "Reductions.puma" */
  {
/* line 753 "Reductions.puma" */
   error_protocol ("illegal reduction type");
/* line 754 "Reductions.puma" */
   tree_protocol ("type : ", vtype);
  }
   return mINT_CONSTANT (1);

}

void BeginReductions ARGS ((void))
{
}

void CloseReductions ARGS ((void))
{
}
