# include "ReductionComm.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 21 "ReductionComm.puma" */


# undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "HomeTraverse.h"    /* AppendBody */

# include "Transform.h"    /* AppendBody */
# include "Rank.h"

# include "Distributions.h"
# include "Ownership.h"    /* MakeOnSpecs, MakeOnTopology */
# include "Descriptor.h"   /* PrintableDescriptorVar      */
# include "HomeDescriptor.h"   /* IsSerialDescriptor      */
# include "MoveDescriptor.h"   /* IsSerialDescriptor      */
# include "Nesting.h" 
# include "TreeOps.h" 

# define MODULE "ReductionComm"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyReductionComm.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ReductionComm_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ReductionComm, routine %s failed\n",
  yyFunction);
 ReductionComm_Exit ();
}

void ReductionCommunication ARGS ((tTree body));
static tTree TranslateReduction ARGS ((tTree stmt, pvar home));
static tTree GenerateReduction ARGS ((pvar active_home, pvar red_home, tTree func, tTree var));
static tTree GenerateTopReduction ARGS ((pvar active_home, pvar red_home, tTree func, tTree var));
static tTree GenerateTopBroadcast ARGS ((tTree var, pvar home));
static tTree MakeRedDimSpecs ARGS ((pvar active_home));
static tTree MakeNewRedDimSpecs ARGS ((pvar active_home, pvar sub_home));
static tTree MakeReplicatedOnSpecs ARGS ((pvar all_home, pvar red_home, pvar var_home));
static void FindReductionHome ARGS ((tTree t, pvar home, tTree red_var, pvar red_home, rbool * yyP1));
static void CombineReductionHome ARGS ((pvar home1, rbool found1, pvar home2, rbool found2, rbool * yyP2));
static rbool SameReductionVar ARGS ((tTree vl1, tTree vl2));
static rbool SameReplication ARGS ((pvar home1, pvar home2));
static void MakeFullTopHome ARGS ((pvar home));
static rbool OnMoreProcs ARGS ((pvar home, int pdim));

void ReductionCommunication
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 63 "ReductionComm.puma" */
 {
  var_descriptor home;
  {
/* line 67 "ReductionComm.puma" */
   MakeReplicatedDescriptor (& home);
/* line 69 "ReductionComm.puma" */
 body->BODY_NODE.STATS = HomeReplaceAST (body->BODY_NODE.STATS, &home, TranslateReduction); 
  }
   return;
 }

  }
/* line 72 "ReductionComm.puma" */
  {
/* line 74 "ReductionComm.puma" */
   failure_protocol (MODULE, "ReductionCommunication", body);
  }
   return;

;
}

static tTree TranslateReduction
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home)
# else
(stmt, home)
 register tTree stmt;
 pvar home;
# endif
{
  if (stmt->Kind == kACF_REDUCTION) {
/* line 124 "ReductionComm.puma" */
 {
  tTree comm;
  var_descriptor red_home;
  rbool yyV1;
  {
/* line 132 "ReductionComm.puma" */
   set_protocol_stmt (stmt);
/* line 134 "ReductionComm.puma" */
   FindReductionHome (stmt->ACF_REDUCTION.REDUCTION_BODY, home, stmt->ACF_REDUCTION.REDUCTION_VAR, & red_home, & yyV1);
/* line 136 "ReductionComm.puma" */
 if (!yyV1)
       { 
         MakeReplicatedDescriptor (&red_home);
       }
   
/* line 142 "ReductionComm.puma" */
   tree_protocol ("generate reduction, var = ", stmt->ACF_REDUCTION.REDUCTION_VAR);
/* line 143 "ReductionComm.puma" */
   tree_protocol ("home of reduction is    = ", PrintableDescriptorVar (home));
/* line 144 "ReductionComm.puma" */
   tree_protocol ("home of reduce    is    = ", PrintableDescriptorVar (& red_home));
/* line 147 "ReductionComm.puma" */
   comm = GenerateReduction (home, & red_home, stmt->ACF_REDUCTION.REDUCTION_FUNC, stmt->ACF_REDUCTION.REDUCTION_VAR);
/* line 149 "ReductionComm.puma" */
   tree_protocol ("==> generated reduction = \n ", comm);
  }
   return CombineACF (stmt, comm);
 }

  }
/* line 154 "ReductionComm.puma" */
   return stmt;

}

static tTree GenerateReduction
# if defined __STDC__ | defined __cplusplus
(pvar active_home, pvar red_home, register tTree func, register tTree var)
# else
(active_home, red_home, func, var)
 pvar active_home;
 pvar red_home;
 register tTree func;
 register tTree var;
# endif
{
/* line 185 "ReductionComm.puma" */
  {
/* line 187 "ReductionComm.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 192 "ReductionComm.puma" */
  {
/* line 194 "ReductionComm.puma" */
   if (! ((IsReplicatedDescriptor (red_home)))) goto yyL2;
  }
   return NoTree;
yyL2:;

/* line 202 "ReductionComm.puma" */
  {
/* line 204 "ReductionComm.puma" */
   if (! ((VDIsSame (active_home, red_home)))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 212 "ReductionComm.puma" */
  {
/* line 214 "ReductionComm.puma" */
   if (! ((TreeWriteDistribution (var) == 0))) goto yyL4;
  {
/* line 216 "ReductionComm.puma" */
   if (! ((IsSerialDescriptor (red_home)))) goto yyL4;
  }
  }
   return mACF_BASIC (mREDUCTION_STMT (func, var, MakeOnTopology (active_home), MakeRedDimSpecs (active_home)));
yyL4:;

/* line 225 "ReductionComm.puma" */
 {
  var_descriptor full_top_home;
  {
/* line 227 "ReductionComm.puma" */
   if (! ((IsReplicatedDescriptor (active_home)))) goto yyL5;
  {
/* line 233 "ReductionComm.puma" */
 full_top_home = *red_home; 
/* line 235 "ReductionComm.puma" */
   MakeFullTopHome (& full_top_home);
  }
  }
   return CombineACF (GenerateTopReduction (& full_top_home, red_home, func, var), GenerateTopBroadcast (var, & full_top_home));
 }
yyL5:;

/* line 244 "ReductionComm.puma" */
   return GenerateTopReduction (active_home, red_home, func, var);

}

static tTree GenerateTopReduction
# if defined __STDC__ | defined __cplusplus
(pvar active_home, pvar red_home, register tTree func, register tTree var)
# else
(active_home, red_home, func, var)
 pvar active_home;
 pvar red_home;
 register tTree func;
 register tTree var;
# endif
{
/* line 277 "ReductionComm.puma" */
 {
  tTree on_top;
  tTree on_spec;
  {
/* line 279 "ReductionComm.puma" */
   if (! ((TreeWriteDistribution (var) == 0))) goto yyL1;
  {
/* line 284 "ReductionComm.puma" */
   on_top = MakeOnTopology (active_home);
/* line 285 "ReductionComm.puma" */
   on_spec = MakeNewRedDimSpecs (active_home, red_home);
  }
  }
   return mACF_BASIC (mREDUCTION_STMT (func, var, on_top, on_spec));
 }
yyL1:;

  if (var->Kind == kBTV_LIST) {
/* line 290 "ReductionComm.puma" */
 {
  var_descriptor var_home;
  tTree on_top;
  tTree on_spec;
  {
/* line 294 "ReductionComm.puma" */
   SetVarDescriptor (var->BTV_LIST.Elem, & var_home);
/* line 299 "ReductionComm.puma" */
   on_top = MakeOnTopology (active_home);
/* line 300 "ReductionComm.puma" */
   on_spec = MakeReplicatedOnSpecs (active_home, red_home, & var_home);
  }
   return mACF_BASIC (mREDUCTION_STMT (func, var, on_top, on_spec));
 }

  }
 yyAbort ("GenerateTopReduction");
 { tTree yyDummy; return yyDummy; }
}

static tTree GenerateTopBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
/* line 316 "ReductionComm.puma" */
  {
/* line 318 "ReductionComm.puma" */
   if (! ((IsReplicatedDescriptor (home)))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 323 "ReductionComm.puma" */
  {
/* line 325 "ReductionComm.puma" */
   if (! ((IsHostDescriptor (home)))) goto yyL2;
  }
   return mACF_BASIC (mBROADCAST_STMT (CopyTree (var), mON_HOST (), mON_EMPTY ()));
yyL2:;

/* line 331 "ReductionComm.puma" */
  {
/* line 333 "ReductionComm.puma" */
   if (! ((IsFullTopologyObj (home -> topology_obj)))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 338 "ReductionComm.puma" */
   return mACF_BASIC (mBROADCAST_STMT (CopyTree (var), MakeOnTopology (home), mON_EMPTY ()));

}

static tTree MakeRedDimSpecs
# if defined __STDC__ | defined __cplusplus
(pvar active_home)
# else
(active_home)
 pvar active_home;
# endif
{
/* line 356 "ReductionComm.puma" */
 {
  tTree on_specs;
  {
/* line 360 "ReductionComm.puma" */
 int pdim;

     on_specs = mON_EMPTY ();

     for (pdim=1; pdim<=active_home->topology_rank; pdim++)
       if (OnMoreProcs (active_home, pdim))  
          on_specs = mON_LIST (MakeOnVal (active_home, pdim), on_specs);
   
  }
   return on_specs;
 }

}

static tTree MakeNewRedDimSpecs
# if defined __STDC__ | defined __cplusplus
(pvar active_home, pvar sub_home)
# else
(active_home, sub_home)
 pvar active_home;
 pvar sub_home;
# endif
{
/* line 384 "ReductionComm.puma" */
 {
  tTree specs;
  int pdim;
  {
/* line 389 "ReductionComm.puma" */
 specs = mON_EMPTY();

    for (pdim = 1; pdim <= active_home->topology_rank; pdim++)

       if (    OnMoreProcs (active_home, pdim)
              && !OnMoreProcs (sub_home, pdim)   )

             specs = mON_LIST (MakeOnVal (active_home, pdim), specs);
  
  }
   return specs;
 }

}

static tTree MakeReplicatedOnSpecs
# if defined __STDC__ | defined __cplusplus
(pvar all_home, pvar red_home, pvar var_home)
# else
(all_home, red_home, var_home)
 pvar all_home;
 pvar red_home;
 pvar var_home;
# endif
{
/* line 411 "ReductionComm.puma" */
 {
  tTree specs;
  int pdim;
  {
/* line 416 "ReductionComm.puma" */
 specs = mON_EMPTY();

    for (pdim = 1; pdim <= all_home->topology_rank; pdim++)

       { tTree val = var_home->on_val [pdim-1];

         if (     OnMoreProcs (all_home, pdim) 
              && !OnMoreProcs (red_home, pdim)
              && (val == NoTree)              )

             specs = mON_LIST (MakeOnVal (all_home, pdim), specs);
       }
  
  }
   return specs;
 }

}

static void FindReductionHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home, register tTree red_var, pvar red_home, register rbool * yyP1)
# else
(t, home, red_var, red_home, yyP1)
 register tTree t;
 pvar home;
 register tTree red_var;
 pvar red_home;
 register rbool * yyP1;
# endif
{

  switch (t->Kind) {
  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 448 "ReductionComm.puma" */
  {
/* line 450 "ReductionComm.puma" */
   if (! ((SameReductionVar (red_var, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS)))) goto yyL1;
  {
/* line 452 "ReductionComm.puma" */
 *red_home = *home; 
  }
  }
   * yyP1 = rtrue;
   return;
yyL1:;

  }
/* line 455 "ReductionComm.puma" */
   * yyP1 = rfalse;
   return;

  case kACF_LIST:
/* line 458 "ReductionComm.puma" */
 {
  var_descriptor red_home1;
  rbool yyV1;
  rbool yyV2;
  rbool yyV3;
  {
/* line 462 "ReductionComm.puma" */
   FindReductionHome (t->ACF_LIST.Elem, home, red_var, red_home, & yyV1);
/* line 463 "ReductionComm.puma" */
   FindReductionHome (t->ACF_LIST.Next, home, red_var, & red_home1, & yyV2);
/* line 465 "ReductionComm.puma" */
   CombineReductionHome (red_home, yyV1, & red_home1, yyV2, & yyV3);
  }
   * yyP1 = yyV3;
   return;
 }

  case kACF_EMPTY:
/* line 468 "ReductionComm.puma" */
   * yyP1 = rfalse;
   return;

  case kACF_DUMMY:
/* line 471 "ReductionComm.puma" */
   * yyP1 = rfalse;
   return;

  case kACF_HOME:
  if (t->ACF_HOME.HOME_VAR->Kind == kON_HOST_CLAUSE) {
/* line 474 "ReductionComm.puma" */
 {
  var_descriptor on_home;
  rbool yyV1;
  {
/* line 479 "ReductionComm.puma" */
   MakeHostDescriptor (& on_home);
/* line 481 "ReductionComm.puma" */
   FindReductionHome (t->ACF_HOME.HOME_BODY, & on_home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 484 "ReductionComm.puma" */
 {
  var_descriptor on_home;
  rbool yyV1;
  {
/* line 489 "ReductionComm.puma" */
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
/* line 491 "ReductionComm.puma" */
   FindReductionHome (t->ACF_HOME.HOME_BODY, & on_home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  break;
  case kACF_NEW:
/* line 494 "ReductionComm.puma" */
 {
  rbool yyV1;
  {
/* line 496 "ReductionComm.puma" */
   FindReductionHome (t->ACF_NEW.NEW_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_RESIDENT:
/* line 499 "ReductionComm.puma" */
 {
  rbool yyV1;
  {
/* line 501 "ReductionComm.puma" */
   FindReductionHome (t->ACF_RESIDENT.RESIDENT_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_REDUCTION:
/* line 504 "ReductionComm.puma" */
 {
  rbool yyV1;
  {
/* line 506 "ReductionComm.puma" */
   FindReductionHome (t->ACF_REDUCTION.REDUCTION_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_DO:
/* line 509 "ReductionComm.puma" */
 {
  rbool yyV1;
  {
/* line 511 "ReductionComm.puma" */
   FindReductionHome (t->ACF_DO.DO_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_WHILE:
/* line 514 "ReductionComm.puma" */
 {
  rbool yyV1;
  {
/* line 516 "ReductionComm.puma" */
   FindReductionHome (t->ACF_WHILE.WHILE_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_IF:
/* line 519 "ReductionComm.puma" */
 {
  var_descriptor red_home1;
  rbool yyV1;
  rbool yyV2;
  rbool yyV3;
  {
/* line 523 "ReductionComm.puma" */
   FindReductionHome (t->ACF_IF.THEN_PART, home, red_var, red_home, & yyV1);
/* line 524 "ReductionComm.puma" */
   FindReductionHome (t->ACF_IF.ELSE_PART, home, red_var, & red_home1, & yyV2);
/* line 526 "ReductionComm.puma" */
   CombineReductionHome (red_home, yyV1, & red_home1, yyV2, & yyV3);
  }
   * yyP1 = yyV3;
   return;
 }

  }

/* line 529 "ReductionComm.puma" */
  {
/* line 531 "ReductionComm.puma" */
   failure_protocol (MODULE, "FindReductionHome", t);
  }
   * yyP1 = rfalse;
   return;

;
}

static void CombineReductionHome
# if defined __STDC__ | defined __cplusplus
(pvar home1, register rbool found1, pvar home2, register rbool found2, register rbool * yyP2)
# else
(home1, found1, home2, found2, yyP2)
 pvar home1;
 register rbool found1;
 pvar home2;
 register rbool found2;
 register rbool * yyP2;
# endif
{
/* line 547 "ReductionComm.puma" */
  {
/* line 549 "ReductionComm.puma" */
   if (! ((! found2))) goto yyL1;
  }
   * yyP2 = found1;
   return;
yyL1:;

/* line 552 "ReductionComm.puma" */
  {
/* line 554 "ReductionComm.puma" */
   if (! ((! found1))) goto yyL2;
  {
/* line 555 "ReductionComm.puma" */
 *home1 = *home2; 
  }
  }
   * yyP2 = found2;
   return;
yyL2:;

/* line 558 "ReductionComm.puma" */
  {
/* line 560 "ReductionComm.puma" */
   if (! ((SameReplication (home1, home2)))) goto yyL3;
  {
/* line 562 "ReductionComm.puma" */
   tree_protocol ("home 1 is : ", PrintableDescriptorVar (home1));
/* line 563 "ReductionComm.puma" */
   tree_protocol ("home 2 is : ", PrintableDescriptorVar (home2));
  }
  }
   * yyP2 = rtrue;
   return;
yyL3:;

/* line 566 "ReductionComm.puma" */
  {
/* line 568 "ReductionComm.puma" */
   error_protocol ("two different homes for reductions");
/* line 569 "ReductionComm.puma" */
   tree_protocol ("home 1 is : ", PrintableDescriptorVar (home1));
/* line 570 "ReductionComm.puma" */
   tree_protocol ("home 2 is : ", PrintableDescriptorVar (home2));
  }
   * yyP2 = rtrue;
   return;

;
}

static rbool SameReductionVar
# if defined __STDC__ | defined __cplusplus
(register tTree vl1, register tTree vl2)
# else
(vl1, vl2)
 register tTree vl1;
 register tTree vl2;
# endif
{
  if (vl1->Kind == kBTV_LIST) {
  if (vl2->Kind == kBTP_LIST) {
  if (vl2->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 581 "ReductionComm.puma" */
  {
/* line 583 "ReductionComm.puma" */
   if (! ((TreeVarName (vl1->BTV_LIST.Elem) == TreeVarName (vl2->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  }
  return rfalse;
}

static rbool SameReplication
# if defined __STDC__ | defined __cplusplus
(pvar home1, pvar home2)
# else
(home1, home2)
 pvar home1;
 pvar home2;
# endif
{
/* line 594 "ReductionComm.puma" */
  {
/* line 596 "ReductionComm.puma" */
   if (! ((IsReplicatedDescriptor (home1)))) goto yyL1;
  {
/* line 597 "ReductionComm.puma" */
   if (! ((IsReplicatedDescriptor (home2)))) goto yyL1;
  {
/* line 599 "ReductionComm.puma" */
   print_protocol ("both homes are full replicated");
  }
  }
  }
   return rtrue;
yyL1:;

/* line 602 "ReductionComm.puma" */
  {
/* line 604 "ReductionComm.puma" */
   if (! ((IsSerialDescriptor (home1)))) goto yyL2;
  {
/* line 605 "ReductionComm.puma" */
   if (! ((IsSerialDescriptor (home2)))) goto yyL2;
  {
/* line 607 "ReductionComm.puma" */
   print_protocol ("both homes are are on a single processor");
  }
  }
  }
   return rtrue;
yyL2:;

/* line 610 "ReductionComm.puma" */
  {
/* line 612 "ReductionComm.puma" */
   if (! ((home1 -> topology_obj != home2 -> topology_obj))) goto yyL3;
  {
/* line 613 "ReductionComm.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 616 "ReductionComm.puma" */
 {
  rbool okay;
  {
/* line 620 "ReductionComm.puma" */
 int pdim;

      okay = rtrue;

      for (pdim = 1; pdim <= home1->topology_rank; pdim++)

       { if (OnMoreProcs (home1, pdim) && !OnMoreProcs(home2, pdim))
            okay = rfalse;
         if (OnMoreProcs (home2, pdim) && !OnMoreProcs(home1, pdim))
            okay = rfalse;
       }
    
/* line 633 "ReductionComm.puma" */
   if (! ((okay))) goto yyL4;
  }
   return rtrue;
 }
yyL4:;

  return rfalse;
}

static void MakeFullTopHome
# if defined __STDC__ | defined __cplusplus
(pvar home)
# else
(home)
 pvar home;
# endif
{
/* line 647 "ReductionComm.puma" */
  {
/* line 649 "ReductionComm.puma" */
 int pdim;

     for (pdim = 1; pdim <= home->topology_rank; pdim++)

         home->on_val[pdim-1] = NoTree;

   
  }
   return;

;
}

static rbool OnMoreProcs
# if defined __STDC__ | defined __cplusplus
(pvar home, register int pdim)
# else
(home, pdim)
 pvar home;
 register int pdim;
# endif
{
/* line 669 "ReductionComm.puma" */
  {
/* line 671 "ReductionComm.puma" */
   if (! ((home -> on_val [pdim - 1] == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 674 "ReductionComm.puma" */
  {
/* line 676 "ReductionComm.puma" */
   if (! ((TreeRank (home -> on_val [pdim - 1]) > 0))) goto yyL2;
  }
   return rtrue;
yyL2:;

  return rfalse;
}

void BeginReductionComm ARGS ((void))
{
}

void CloseReductionComm ARGS ((void))
{
}
