# include "Rank.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 23 "Rank.puma" */


# define MODULE "Rank"

# include "Idents.h"
# include "protocol.h"

# include "TreeOps.h"
# include "Expressions.h" /* evaluation of constants */
# include "DefTable.h"    /* GetIntrinsicObject */
# include "Objects.h"     /* GetFuncVarObj */
# include "Intrinsics.h"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyRank.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Rank_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Rank, routine %s failed\n",
  yyFunction);
 Rank_Exit ();
}

int VarRank ARGS ((tDefinitions v));
int TreeRank ARGS ((tTree t));
static int CountSlices ARGS ((tTree list));
int MergeRank ARGS ((int rank1, int rank2));
static int ParameterRank ARGS ((tTree t));
static int IntrFuncRank ARGS ((tIdent name, tTree param));
static int ArraySize ARGS ((tTree exp));
static int ArrayExpLength ARGS ((tTree exp));
static int FormalSize ARGS ((tTree t));
static int ActualSize ARGS ((tTree t));
static int GetSliceSize ARGS ((tTree lb, tTree ub));
static rbool HasDimArgument ARGS ((tTree param));

int VarRank
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
 yyRecursion:
/* line 48 "Rank.puma" */
  {
/* line 50 "Rank.puma" */
   if (! ((v == NoObject))) goto yyL1;
  }
   return 0;
yyL1:;


  switch (v->Kind) {
  case kVarObject:
  if (v->VarObject.decl->Kind == kVAR_DECL) {
/* line 54 "Rank.puma" */
   return TreeRank (v->VarObject.decl->VAR_DECL.VAL);

  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 58 "Rank.puma" */
   return TreeRank (v->VarObject.decl->VAR_PARAM_DECL.VAL);

  }
  if (v->VarObject.decl->Kind == kPARAMETER_DECL) {
/* line 62 "Rank.puma" */
   return 0;

  }
/* line 106 "Rank.puma" */
  {
/* line 107 "Rank.puma" */
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

  case kTemplateObject:
  if (v->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
/* line 66 "Rank.puma" */
   return TreeListLength (v->TemplateObject.decl->TEMPLATE_DECL.DIMENSIONS);

  }
  break;
  case kRaggedObject:
  if (v->RaggedObject.decl->Kind == kRAGGED_DECL) {
/* line 71 "Rank.puma" */
   return TreeListLength (v->RaggedObject.decl->RAGGED_DECL.DIMENSIONS);

  }
  break;
  case kTopologyObject:
/* line 78 "Rank.puma" */
  {
/* line 80 "Rank.puma" */
   if (! ((v->TopologyObject.Ident == DefaultId ()))) goto yyL7;
  }
   return v->TopologyObject.rank;
yyL7:;

/* line 85 "Rank.puma" */
  {
/* line 87 "Rank.puma" */
   if (! ((v->TopologyObject.decl == NoTree))) goto yyL8;
  {
/* line 89 "Rank.puma" */
   obj_protocol ("no rank of this topology object : ", v);
/* line 90 "Rank.puma" */
   failure_protocol (MODULE, "VarRank (TopologyObjext)", NoTree);
  }
  }
   return - 1;
yyL8:;

  if (v->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
/* line 94 "Rank.puma" */
   return v->TopologyObject.rank;

  }
  if (v->TopologyObject.decl->Kind == kSUB_PROCS_DECL) {
/* line 101 "Rank.puma" */
   return CountSlices (v->TopologyObject.decl->SUB_PROCS_DECL.DIMENSIONS);

  }
  break;
  case kFuncObject:
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 111 "Rank.puma" */
  {
/* line 113 "Rank.puma" */
   if (! ((v->FuncObject.decl->FUNC_DECL.FUNC_BODY == NoTree))) goto yyL12;
  }
   return 0;
yyL12:;

/* line 117 "Rank.puma" */
   v = GetFuncVarObj (v);
   goto yyRecursion;

  }
/* line 122 "Rank.puma" */
   return 0;

  case kExternalObject:
/* line 128 "Rank.puma" */
  {
/* line 129 "Rank.puma" */
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

  case kProcObject:
/* line 133 "Rank.puma" */
  {
/* line 134 "Rank.puma" */
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

  case kGenericObject:
/* line 138 "Rank.puma" */
  {
/* line 139 "Rank.puma" */
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

  }

/* line 143 "Rank.puma" */
  {
/* line 144 "Rank.puma" */
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

}

int TreeRank
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kVAR_DECL:
/* line 156 "Rank.puma" */
   t = t->VAR_DECL.VAL;
   goto yyRecursion;

  case kVAR_PARAM_DECL:
/* line 160 "Rank.puma" */
   t = t->VAR_PARAM_DECL.VAL;
   goto yyRecursion;

  case kPARAMETER_DECL:
/* line 164 "Rank.puma" */
   return 0;

  case kDUMMY_TYPE:
/* line 168 "Rank.puma" */
   return 0;

  case kINTEGER_TYPE:
/* line 172 "Rank.puma" */
   return 0;

  case kREAL_TYPE:
/* line 176 "Rank.puma" */
   return 0;

  case kBOOLEAN_TYPE:
/* line 180 "Rank.puma" */
   return 0;

  case kCOMPLEX_TYPE:
/* line 184 "Rank.puma" */
   return 0;

  case kSTRING_TYPE:
/* line 188 "Rank.puma" */
   return 0;

  case kARRAY_TYPE:
/* line 193 "Rank.puma" */
   return TreeListLength (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);

  case kSHAPE_LIST:
/* line 199 "Rank.puma" */
   return TreeListLength (t);

  case kSHAPE_EMPTY:
/* line 203 "Rank.puma" */
   return 0;

  case kTYPE_ID:
/* line 207 "Rank.puma" */
   return 0;

  case kVAR_OBJ:
/* line 211 "Rank.puma" */
   return VarRank (t->VAR_OBJ.Object);

  case kUSED_VAR:
/* line 215 "Rank.puma" */
   t = t->USED_VAR.VARNAME;
   goto yyRecursion;

  case kSUBSTRING_VAR:
/* line 219 "Rank.puma" */
   t = t->SUBSTRING_VAR.IND_VAR;
   goto yyRecursion;

  case kLOOP_VAR:
/* line 223 "Rank.puma" */
   return 0;

  case kINDEXED_VAR:
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 227 "Rank.puma" */
   return CountSlices (t->INDEXED_VAR.IND_EXPS);

  }
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 232 "Rank.puma" */
   return TreeRank (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR) + CountSlices (t->INDEXED_VAR.IND_EXPS);

  }
  break;
  case kSELECTED_VAR:
/* line 237 "Rank.puma" */
   return TreeRank (t->SELECTED_VAR.SELEC_VAR) + VarRank (t->SELECTED_VAR.SELECTOR->REC_COMP.Object);

  case kPERM_VAR:
/* line 241 "Rank.puma" */
   t = t->PERM_VAR.VAL;
   goto yyRecursion;

  case kDO_VAR:
/* line 245 "Rank.puma" */
   return 1;

  case kREMOTE_VAR:
/* line 249 "Rank.puma" */
   t = t->REMOTE_VAR.VAR;
   goto yyRecursion;

  case kADDR:
/* line 254 "Rank.puma" */
   t = t->ADDR.E;
   goto yyRecursion;

  case kDUMMY_EXP:
/* line 258 "Rank.puma" */
   return 0;

  case kCONST_EXP:
/* line 262 "Rank.puma" */
   return 0;

  case kARRAY_EXP:
/* line 266 "Rank.puma" */
   return 1;

  case kBOUND_EXP:
/* line 270 "Rank.puma" */
   return 0;

  case kTYPE_EXP:
/* line 274 "Rank.puma" */
   return 0;

  case kSLICE_EXP:
/* line 278 "Rank.puma" */
   return 1;

  case kOP_EXP:
/* line 282 "Rank.puma" */
   return MergeRank (TreeRank (t->OP_EXP.OPND1), TreeRank (t->OP_EXP.OPND2));

  case kOP1_EXP:
/* line 287 "Rank.puma" */
   t = t->OP1_EXP.OPND;
   goto yyRecursion;

  case kVAR_EXP:
/* line 291 "Rank.puma" */
   t = t->VAR_EXP.V;
   goto yyRecursion;

  case kFUNC_CALL_EXP:
/* line 295 "Rank.puma" */
  {
/* line 297 "Rank.puma" */
   if (! ((IsIntrCall (t)))) goto yyL34;
  }
   return IntrFuncRank (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->FUNC_CALL_EXP.FUNC_PARAMS);
yyL34:;

/* line 301 "Rank.puma" */
   return VarRank (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object);

  case kDO_EXP:
/* line 308 "Rank.puma" */
   return 1;

  case kNO_PARAM:
/* line 313 "Rank.puma" */
   return 0;

  case kNAMED_PARAM:
/* line 317 "Rank.puma" */
   t = t->NAMED_PARAM.VAL;
   goto yyRecursion;

  case kVAR_PARAM:
/* line 321 "Rank.puma" */
   t = t->VAR_PARAM.V;
   goto yyRecursion;

  }

/* line 325 "Rank.puma" */
  {
/* line 326 "Rank.puma" */
   failure_protocol (MODULE, "TreeRank (unknown tree)", t);
  }
   return 0;

}

static int CountSlices
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
  if (list->Kind == kBTE_EMPTY) {
/* line 338 "Rank.puma" */
   return 0;

  }
  if (list->Kind == kBTE_LIST) {
/* line 342 "Rank.puma" */
   return TreeRank (list->BTE_LIST.Elem) + CountSlices (list->BTE_LIST.Next);

  }
/* line 346 "Rank.puma" */
  {
/* line 347 "Rank.puma" */
   failure_protocol (MODULE, "CountSlices", list);
  }
   return - 1;

}

int MergeRank
# if defined __STDC__ | defined __cplusplus
(register int rank1, register int rank2)
# else
(rank1, rank2)
 register int rank1;
 register int rank2;
# endif
{
  if (equalint (rank1, 0)) {
/* line 359 "Rank.puma" */
   return rank2;

  }
  if (equalint (rank2, 0)) {
/* line 363 "Rank.puma" */
   return rank1;

  }
/* line 367 "Rank.puma" */
  {
/* line 368 "Rank.puma" */
   if (! ((rank1 == rank2))) goto yyL3;
  }
   return rank1;
yyL3:;

/* line 372 "Rank.puma" */
   return - 1;

}

static int ParameterRank
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_EMPTY) {
/* line 384 "Rank.puma" */
   return 0;

  }
  if (t->Kind == kBTP_LIST) {
/* line 389 "Rank.puma" */
   return MergeRank (TreeRank (t->BTP_LIST.Elem), ParameterRank (t->BTP_LIST.Next));

  }
 yyAbort ("ParameterRank");
 { int yyDummy; return yyDummy; }
}

static int IntrFuncRank
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree param)
# else
(name, param)
 register tIdent name;
 register tTree param;
# endif
{
/* line 402 "Rank.puma" */
  {
/* line 404 "Rank.puma" */
   if (! ((IntrFuncInquiry (name)))) goto yyL1;
  {
/* line 405 "Rank.puma" */
   if (! ((IntrFuncShape (name)))) goto yyL1;
  }
  }
   return 1;
yyL1:;

  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (param->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 411 "Rank.puma" */
  {
/* line 413 "Rank.puma" */
   if (! (((name == IsIdent ("LBOUND")) || (name == IsIdent ("UBOUND"))))) goto yyL2;
  }
   return 1;
yyL2:;

  }
  }
  }
  }
/* line 417 "Rank.puma" */
  {
/* line 419 "Rank.puma" */
   if (! ((IntrFuncInquiry (name)))) goto yyL3;
  }
   return 0;
yyL3:;

  if (param->Kind == kBTP_LIST) {
/* line 423 "Rank.puma" */
  {
/* line 425 "Rank.puma" */
   if (! ((IntrFuncElemental (name)))) goto yyL4;
  }
   return ParameterRank (param);
yyL4:;

/* line 429 "Rank.puma" */
  {
/* line 431 "Rank.puma" */
   if (! ((IntrFuncRed (name)))) goto yyL5;
  {
/* line 432 "Rank.puma" */
   if (! ((HasDimArgument (param)))) goto yyL5;
  }
  }
   return TreeRank (param->BTP_LIST.Elem) - 1;
yyL5:;

/* line 436 "Rank.puma" */
  {
/* line 438 "Rank.puma" */
   if (! ((IntrFuncRed (name)))) goto yyL6;
  }
   return 0;
yyL6:;

/* line 442 "Rank.puma" */
  {
/* line 444 "Rank.puma" */
   if (! ((IntrFuncScan (name)))) goto yyL7;
  }
   return TreeRank (param->BTP_LIST.Elem);
yyL7:;

  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 448 "Rank.puma" */
  {
/* line 450 "Rank.puma" */
   if (! ((IntrFuncScatter (name)))) goto yyL8;
  }
   return TreeRank (param->BTP_LIST.Next->BTP_LIST.Elem);
yyL8:;

  }
/* line 454 "Rank.puma" */
  {
/* line 456 "Rank.puma" */
   if (! ((IntrFuncLocRed (name)))) goto yyL9;
  {
/* line 457 "Rank.puma" */
   if (! ((HasDimArgument (param)))) goto yyL9;
  }
  }
   return TreeRank (param->BTP_LIST.Elem) - 1;
yyL9:;

/* line 461 "Rank.puma" */
  {
/* line 463 "Rank.puma" */
   if (! ((IntrFuncLocRed (name)))) goto yyL10;
  }
   return 1;
yyL10:;

  }
  if (equaltIdent (name, IsIdent ("TRANSPOSE"))) {
  if (param->Kind == kBTP_LIST) {
/* line 467 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("CSHIFT"))) {
  if (param->Kind == kBTP_LIST) {
/* line 471 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("EOSHIFT"))) {
  if (param->Kind == kBTP_LIST) {
/* line 476 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("SPREAD"))) {
  if (param->Kind == kBTP_LIST) {
/* line 481 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Elem) + 1;

  }
  }
  if (equaltIdent (name, IsIdent ("MERGE"))) {
/* line 488 "Rank.puma" */
   return ParameterRank (param);

  }
  if (equaltIdent (name, IsIdent ("PACK"))) {
/* line 493 "Rank.puma" */
   return 1;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 498 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Next->BTP_LIST.Elem);

  }
  }
  }
  if (equaltIdent (name, IsIdent ("MATMUL"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 503 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Elem) + TreeRank (param->BTP_LIST.Next->BTP_LIST.Elem) - 2;

  }
  }
  }
  if (equaltIdent (name, IsIdent ("DOT_PRODUCT"))) {
/* line 508 "Rank.puma" */
   return 0;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 513 "Rank.puma" */
   return ArraySize (param->BTP_LIST.Next->BTP_LIST.Elem);

  }
  }
  }
  if (equaltIdent (name, IsIdent ("REPEAT"))) {
/* line 520 "Rank.puma" */
   return 0;

  }
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
/* line 531 "Rank.puma" */
   return 2;

  }
  }
  }
  }
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
/* line 535 "Rank.puma" */
   return 2;

  }
  }
  }
  }
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
  if (param->Kind == kBTP_LIST) {
/* line 539 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
  if (param->Kind == kBTP_LIST) {
/* line 543 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("SORT_UP"))) {
  if (param->Kind == kBTP_LIST) {
/* line 551 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("SORT_DOWN"))) {
  if (param->Kind == kBTP_LIST) {
/* line 555 "Rank.puma" */
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("TRIM"))) {
/* line 563 "Rank.puma" */
   return 0;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_INT_KIND"))) {
/* line 567 "Rank.puma" */
   return 0;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_REAL_KIND"))) {
/* line 571 "Rank.puma" */
   return 0;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_BLKCNT"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
/* line 575 "Rank.puma" */
   return 1;

  }
  }
  }
  }
  if (equaltIdent (name, IsIdent ("LOCAL_BLKCNT"))) {
/* line 580 "Rank.puma" */
   return 0;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_LINDEX"))) {
/* line 585 "Rank.puma" */
   return 0;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_UINDEX"))) {
/* line 590 "Rank.puma" */
   return 0;

  }
/* line 595 "Rank.puma" */
  {
/* line 596 "Rank.puma" */
   obj_protocol ("no rank for this intrinsic object : ", GetIntrinsicObject (name));
  }
   return - 1;

}

static int ArraySize
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
 yyRecursion:

  switch (exp->Kind) {
  case kVAR_PARAM:
/* line 611 "Rank.puma" */
   exp = exp->VAR_PARAM.V;
   goto yyRecursion;

  case kARRAY_EXP:
/* line 615 "Rank.puma" */
   return ArrayExpLength (exp->ARRAY_EXP.ELEMENTS);

  case kADDR:
/* line 620 "Rank.puma" */
   exp = exp->ADDR.E;
   goto yyRecursion;

  case kVAR_EXP:
/* line 625 "Rank.puma" */
   exp = exp->VAR_EXP.V;
   goto yyRecursion;

  case kINDEXED_VAR:
/* line 631 "Rank.puma" */
   return ActualSize (exp->INDEXED_VAR.IND_EXPS);

  case kUSED_VAR:
/* line 636 "Rank.puma" */
   return FormalSize (GetObjDimension (exp->USED_VAR.VARNAME->VAR_OBJ.Object));

  case kFUNC_CALL_EXP:
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 641 "Rank.puma" */
  {
/* line 643 "Rank.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL7;
  {
/* line 644 "Rank.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SHAPE")))) goto yyL7;
  }
  }
   return TreeRank (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
yyL7:;

  }
  }
  break;
  }

/* line 649 "Rank.puma" */
   return - 1;

}

static int ArrayExpLength
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kBTE_EMPTY) {
/* line 656 "Rank.puma" */
   return 0;

  }
  if (exp->Kind == kBTE_LIST) {
/* line 660 "Rank.puma" */
  {
/* line 662 "Rank.puma" */
   if (! ((TreeRank (exp->BTE_LIST.Elem) == 0))) goto yyL2;
  {
/* line 663 "Rank.puma" */
   if (! ((ArrayExpLength (exp->BTE_LIST.Next) >= 0))) goto yyL2;
  }
  }
   return ArrayExpLength (exp->BTE_LIST.Next) + 1;
yyL2:;

  }
/* line 667 "Rank.puma" */
   return - 1;

}

static int FormalSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
/* line 674 "Rank.puma" */
  {
/* line 675 "Rank.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return - 1;
yyL1:;

  if (t->Kind == kSHAPE_LIST) {
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
/* line 680 "Rank.puma" */
   t = t->SHAPE_LIST.Elem;
   goto yyRecursion;

  }
  }
  if (t->Kind == kEXPLICIT_SHAPE) {
/* line 685 "Rank.puma" */
   return GetSliceSize (t->EXPLICIT_SHAPE.LOWER, t->EXPLICIT_SHAPE.UPPER);

  }
  if (Tree_IsType (t, kSHAPE_SPEC)) {
/* line 689 "Rank.puma" */
   return - 1;

  }
/* line 693 "Rank.puma" */
   return - 1;

}

static int ActualSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 699 "Rank.puma" */
  {
/* line 701 "Rank.puma" */
   if (! ((IsStride1 (t->BTE_LIST.Elem->SLICE_EXP.INC)))) goto yyL1;
  }
   return GetSliceSize (t->BTE_LIST.Elem->SLICE_EXP.FIRST, t->BTE_LIST.Elem->SLICE_EXP.STOP);
yyL1:;

  }
  }
  }
/* line 706 "Rank.puma" */
   return - 1;

}

static int GetSliceSize
# if defined __STDC__ | defined __cplusplus
(register tTree lb, register tTree ub)
# else
(lb, ub)
 register tTree lb;
 register tTree ub;
# endif
{
/* line 713 "Rank.puma" */
 {
  rbool found;
  int val1;
  int val2;
  {
/* line 719 "Rank.puma" */
   GetIntConstValue (lb, & found, & val1);
/* line 720 "Rank.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 721 "Rank.puma" */
   GetIntConstValue (ub, & found, & val2);
/* line 722 "Rank.puma" */
   if (! ((found))) goto yyL1;
  }
  }
   return val2 - val1 + 1;
 }
yyL1:;

/* line 726 "Rank.puma" */
   return - 1;

}

static rbool HasDimArgument
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 744 "Rank.puma" */
  {
/* line 745 "Rank.puma" */
   if (! ((TreeRank (param->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V) == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (param->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 748 "Rank.puma" */
  {
/* line 749 "Rank.puma" */
   if (! ((TreeRank (param->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V) == 0))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  }
  }
  return rfalse;
}

void BeginRank ARGS ((void))
{
}

void CloseRank ARGS ((void))
{
}
