# include "PseudoDynamic.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 49 "PseudoDynamic.puma" */


# include <stdio.h>
# include "Idents.h"
# include "protocol.h"
# include "StringM.h"
# include "Types.h"

# include "Transform.h"     /* ReplaceDECL, ... */
# include "Expressions.h"   /* MakeConstant, ... */
# include "Dalib.h"         /* MakeVarDeclA, ... */
# include "TriDenT.h"
# include "Rank.h"
# include "Objects.h"

# include "DefTable.h"

# define  MODULE "PseudoDynamic"

# define  static_lower_bound 1
# define  static_upper_bound 2

   /* every allocatable array will be translated to an array
      of size (static_lower_bound : static_upper_bound), but
      this size does not matter in any case                   */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyPseudoDynamic.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* PseudoDynamic_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module PseudoDynamic, routine %s failed\n",
  yyFunction);
 PseudoDynamic_Exit ();
}

tTree MakePseudoDynamicArray ARGS ((tTree val));
tTree PseudoDynamicDecls ARGS ((tIdent name, int rank, tTree type));
tTree PseudoDynamicCommDecls ARGS ((tIdent name, int rank));
void PseudoDynamicIndexing ARGS ((tTree t));
static void LinearizeIndexes ARGS ((tTree indexes, tTree var, int n));
static tTree MakeLinearIndex ARGS ((tTree index, tTree var, int n));
static tTree MakeLinearIndexExpression ARGS ((tTree index, tTree var, int n));
static tTree MakeDimExp ARGS ((tTree exp, tTree var, int n));
static tTree GetZeroVariable ARGS ((tTree var));
static tTree GetDimVariable ARGS ((tTree var, int n));
tTree PseudoDynamicParams ARGS ((tTree var, int n));

tTree MakePseudoDynamicArray
# if defined __STDC__ | defined __cplusplus
(register tTree val)
# else
(val)
 register tTree val;
# endif
{
  if (val->Kind == kVAR_DECL) {
/* line 91 "PseudoDynamic.puma" */
 {
  tDefinitions obj;
  tTree new_var;
  tTree new_decl;
  int rank;
  {
/* line 98 "PseudoDynamic.puma" */
   obj = GetLocalObject (val->VAR_DECL.Ident);
/* line 100 "PseudoDynamic.puma" */
 rank = VarRank (obj);

     if (IsRaggedVarObject (obj)) rank = 1;

     new_decl = PseudoDynamicDecls (val->VAR_DECL.Ident, rank,
                             MakeIntegerType (default_int_size));

     

     

     new_var = mEXPLICIT_SHAPE (MakeConstant (static_lower_bound), 
                                MakeConstant (static_upper_bound));

     new_var = mARRAY_TYPE (mSHAPE_LIST (new_var, mSHAPE_EMPTY()), 
                            GetBaseType (GetObjectType (obj))); 

     new_var = mVAR_DECL (val->VAR_DECL.Ident, val->VAR_DECL.Line, new_var);

     new_decl = mDECL_LIST (new_var, new_decl);

   
  }
   return new_decl;
 }

  }
 yyAbort ("MakePseudoDynamicArray");
 { tTree yyDummy; return yyDummy; }
}

tTree PseudoDynamicDecls
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int rank, register tTree type)
# else
(name, rank, type)
 register tIdent name;
 register int rank;
 register tTree type;
# endif
{
  if (equalint (rank, 0)) {
/* line 143 "PseudoDynamic.puma" */
   return mDECL_LIST (MakeVarDeclA (name, "_ZERO", MakeIntegerType (default_addr_size)), NoTree);

  }
/* line 150 "PseudoDynamic.puma" */
   return mDECL_LIST (MakeVarDeclAn (name, "_DIM", rank, type), PseudoDynamicDecls (name, rank - 1, type));

}

tTree PseudoDynamicCommDecls
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int rank)
# else
(name, rank)
 register tIdent name;
 register int rank;
# endif
{
  if (equalint (rank, 0)) {
/* line 158 "PseudoDynamic.puma" */
   return mDECL_LIST (MakeVarDeclA (name, "_ZERO", mDUMMY_TYPE ()), NoTree);

  }
/* line 163 "PseudoDynamic.puma" */
   return mDECL_LIST (MakeVarDeclAn (name, "_DIM", rank, mDUMMY_TYPE ()), PseudoDynamicCommDecls (name, rank - 1));

}

void PseudoDynamicIndexing
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 185 "PseudoDynamic.puma" */
 {
  tDefinitions obj;
  tTree zero;
  {
/* line 189 "PseudoDynamic.puma" */
   obj = GetGlobalObject (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
/* line 191 "PseudoDynamic.puma" */
   if (! ((IsRaggedVarObject (obj)))) goto yyL1;
  {
/* line 195 "PseudoDynamic.puma" */
 zero = mVAR_EXP (MakeUsedVarA (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, "_ZERO")); 

     zero = mOP_EXP (mOP_PLUS (), zero, TriDenTOffset (obj, t->INDEXED_VAR.IND_EXPS));
 
     t->INDEXED_VAR.IND_EXPS = mBTE_LIST (zero, mBTE_EMPTY ());
   
  }
  }
   return;
 }
yyL1:;

/* line 213 "PseudoDynamic.puma" */
  {
/* line 215 "PseudoDynamic.puma" */
   LinearizeIndexes (t->INDEXED_VAR.IND_EXPS, t->INDEXED_VAR.IND_VAR, 0);
  }
   return;

  }
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 218 "PseudoDynamic.puma" */
  {
/* line 220 "PseudoDynamic.puma" */
   LinearizeIndexes (t->INDEXED_VAR.IND_EXPS, t->INDEXED_VAR.IND_VAR, 0);
  }
   return;

  }
  }
;
}

static void LinearizeIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register tTree var, register int n)
# else
(indexes, var, n)
 register tTree indexes;
 register tTree var;
 register int n;
# endif
{
 yyRecursion:
  if (indexes->Kind == kBTE_LIST) {
/* line 247 "PseudoDynamic.puma" */
  {
/* line 249 "PseudoDynamic.puma" */
   if (! ((n > 0))) goto yyL1;
  {
/* line 250 "PseudoDynamic.puma" */
   indexes = indexes->BTE_LIST.Next;
   n = n - 1;
   goto yyRecursion;
  }
  }
yyL1:;

/* line 258 "PseudoDynamic.puma" */
  {
/* line 260 "PseudoDynamic.puma" */
 indexes->BTE_LIST.Elem  = MakeLinearIndex (indexes, var, 0);
     indexes->BTE_LIST.Next = mBTE_EMPTY ();  
   
  }
   return;

  }
  if (indexes->Kind == kBTE_EMPTY) {
/* line 253 "PseudoDynamic.puma" */
  {
/* line 255 "PseudoDynamic.puma" */
   if (! ((n == 0))) goto yyL2;
  }
   return;
yyL2:;

  }
/* line 265 "PseudoDynamic.puma" */
  {
/* line 267 "PseudoDynamic.puma" */
   failure_protocol ("PseudoDynamic", "ChangeFullIndexExpression", indexes);
  }
   return;

;
}

static tTree MakeLinearIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index, register tTree var, register int n)
# else
(index, var, n)
 register tTree index;
 register tTree var;
 register int n;
# endif
{
  if (index->Kind == kBTE_LIST) {
  if (index->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 281 "PseudoDynamic.puma" */
  {
/* line 283 "PseudoDynamic.puma" */
 index->BTE_LIST.Elem->SLICE_EXP.FIRST = MakeLinearIndexExpression (mBTE_LIST (index->BTE_LIST.Elem->SLICE_EXP.FIRST, index->BTE_LIST.Next), var, n);
      index->BTE_LIST.Elem->SLICE_EXP.STOP  = MakeLinearIndexExpression (mBTE_LIST (index->BTE_LIST.Elem->SLICE_EXP.STOP, index->BTE_LIST.Next), var, n);
    
  }
   return index->BTE_LIST.Elem;

  }
/* line 289 "PseudoDynamic.puma" */
   return MakeLinearIndexExpression (index, var, 0);

  }
 yyAbort ("MakeLinearIndex");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeLinearIndexExpression
# if defined __STDC__ | defined __cplusplus
(register tTree index, register tTree var, register int n)
# else
(index, var, n)
 register tTree index;
 register tTree var;
 register int n;
# endif
{
 yyRecursion:
  if (index->Kind == kBTE_LIST) {
  if (index->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 303 "PseudoDynamic.puma" */
  {
/* line 305 "PseudoDynamic.puma" */
   error_protocol ("linearization of index triplet not possible");
  }
   index = index->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;

  }
/* line 309 "PseudoDynamic.puma" */
   return mOP_EXP (mOP_PLUS (), MakeLinearIndexExpression (index->BTE_LIST.Next, var, n + 1), MakeDimExp (index->BTE_LIST.Elem, var, n));

  }
  if (index->Kind == kBTE_EMPTY) {
/* line 317 "PseudoDynamic.puma" */
   return mVAR_EXP (GetZeroVariable (var));

  }
 yyAbort ("MakeLinearIndexExpression");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeDimExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree var, register int n)
# else
(exp, var, n)
 register tTree exp;
 register tTree var;
 register int n;
# endif
{
/* line 332 "PseudoDynamic.puma" */

tTree newexp;
int val;
rbool found;

/* line 338 "PseudoDynamic.puma" */
  {
/* line 339 "PseudoDynamic.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  {
/* line 340 "PseudoDynamic.puma" */
   if (! ((n <= 0))) goto yyL1;
  }
  }
   return (MakeConstant (1));
yyL1:;

/* line 344 "PseudoDynamic.puma" */
  {
/* line 345 "PseudoDynamic.puma" */
   if (! ((exp == NoTree))) goto yyL2;
  }
   return mVAR_EXP (GetDimVariable (var, n));
yyL2:;

/* line 349 "PseudoDynamic.puma" */
  {
/* line 350 "PseudoDynamic.puma" */
   if (! ((n <= 0))) goto yyL3;
  }
   return exp;
yyL3:;

/* line 353 "PseudoDynamic.puma" */
  {
/* line 354 "PseudoDynamic.puma" */
 newexp = mVAR_EXP (GetDimVariable (var, n));
     GetIntConstValue (exp, &found, &val);
     if (found && (val == 0))
        newexp = exp;           
      else if (found && (val == 1))
        newexp = newexp;
      else
        newexp = mOP_EXP (mOP_TIMES (), exp, newexp);
   
  }
   return newexp;

}

static tTree GetZeroVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 376 "PseudoDynamic.puma" */
   return MakeUsedVarA (var->USED_VAR.VARNAME->VAR_OBJ.Ident, "_ZERO");

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 381 "PseudoDynamic.puma" */
   return mSELECTED_VAR (CopyTree (var->SELECTED_VAR.SELEC_VAR), MakeRecCompA (var->SELECTED_VAR.SELECTOR->REC_COMP.Ident, "_ZERO"));

  }
/* line 386 "PseudoDynamic.puma" */
  {
/* line 388 "PseudoDynamic.puma" */
   failure_protocol (MODULE, "GetZeroVariable", var);
  }
   return NoTree;

}

static tTree GetDimVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n)
# else
(var, n)
 register tTree var;
 register int n;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 402 "PseudoDynamic.puma" */
   return MakeUsedVarAn (var->USED_VAR.VARNAME->VAR_OBJ.Ident, "_DIM", n);

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 407 "PseudoDynamic.puma" */
   return mSELECTED_VAR (CopyTree (var->SELECTED_VAR.SELEC_VAR), MakeRecCompAn (var->SELECTED_VAR.SELECTOR->REC_COMP.Ident, "_DIM", n));

  }
/* line 412 "PseudoDynamic.puma" */
  {
/* line 414 "PseudoDynamic.puma" */
   failure_protocol (MODULE, "GetDimVariable", var);
  }
   return NoTree;

}

tTree PseudoDynamicParams
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n)
# else
(var, n)
 register tTree var;
 register int n;
# endif
{
/* line 428 "PseudoDynamic.puma" */
  {
/* line 430 "PseudoDynamic.puma" */
   if (! ((n <= 0))) goto yyL1;
  }
   return mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, "_ZERO")), mBTP_EMPTY ());
yyL1:;

/* line 436 "PseudoDynamic.puma" */
   return AppendParam (PseudoDynamicParams (var, n - 1), mVAR_PARAM (MakeVarSuffixAn (var, "_DIM", n)));

}

void BeginPseudoDynamic ARGS ((void))
{
}

void ClosePseudoDynamic ARGS ((void))
{
}
