/* $Id: Position.c,v 1.9 1998/04/21 21:57:31 grosch rel $ */

/*
 * $Log: Position.c,v $
 * Revision 1.9  1998/04/21 21:57:31  grosch
 * bug fix: typing error in head of procedure FormatPosition
 *
 * Revision 1.8  1998/04/04 10:14:35  grosch
 * extended type tPosition by new field FileName and
 * conditional compilation using the cpp variable NO_FILE_NAME
 * added function FormatPosition
 *
 * Revision 1.7  1997/05/27 13:25:04  grosch
 * truncation of filenames to 8.3 format
 *
 * Revision 1.6  1996/08/13 13:20:23  grosch
 * adaption to DLL's for Microsoft Visual C++
 *
 * Revision 1.5  1995/03/20  15:37:30  grosch
 * truncate lines to at most 80 characters
 *
 * Revision 1.4  1995/02/23  20:11:10  grosch
 * renamed Positions to Position, StringMem to StringM, Relations to Relation
 * output lines with at most 132 characters
 *
 * Revision 1.3  1993/08/18  15:01:05  grosch
 * rename System and Memory to rSystem and rMemory
 *
 * Revision 1.2  1992/08/13  13:47:33  grosch
 * increase format in WritePosition
 *
 * Revision 1.1  1992/08/13  12:29:12  grosch
 * fix bugs with ANSI C
 *
 * Revision 1.0  1992/08/07  14:31:42  grosch
 * Initial revision
 *
 */

/* Ich, Doktor Josef Grosch, Informatiker, Juli 1992 */

static char rcsid [] =
   "$Id: Position.c,v 1.9 1998/04/21 21:57:31 grosch rel $";

# include "Position.h"

# ifdef NO_FILE_NAME
   tPosition NoPosition = {0, 0};
# else
   tPosition NoPosition = {0, 0, 1 /* NoIdent */ };
# endif

int Compare
# if defined __STDC__ | defined __cplusplus
   (tPosition Position1, tPosition Position2)
# else
   (Position1, Position2) tPosition Position1, Position2;
# endif
{
# ifndef NO_FILE_NAME
   if (Position1.FileName < Position2.FileName) return -1;
   if (Position1.FileName > Position2.FileName) return  1;
# endif
   if (Position1.Line     < Position2.Line    ) return -1;
   if (Position1.Line     > Position2.Line    ) return  1;
   if (Position1.Column   < Position2.Column  ) return -1;
   if (Position1.Column   > Position2.Column  ) return  1;
   return 0;
}

void WritePosition
# if defined __STDC__ | defined __cplusplus
   (FILE * File, tPosition Position)
# else
   (File, Position) FILE * File; tPosition Position;
# endif
{
# ifdef NO_FILE_NAME
   (void) fprintf (File, "%4d,%3d", Position.Line, Position.Column);
# else
   (void) fprintf (File, "\"%s\":%4d,%3d",
      GetCStr (Position.FileName), Position.Line, Position.Column);
# endif
}

void ReadPosition
# if defined __STDC__ | defined __cplusplus
   (FILE * File, tPosition * Position)
# else
   (File, Position) FILE * File; tPosition * Position;
# endif
{
# ifdef NO_FILE_NAME
   (void) fscanf (File, "%4ld,%3hd", & Position->Line, & Position->Column);
# else
   char Buffer [256];
   int n = fscanf (File, "\"%[^:]:%ld,%hd",
      Buffer, & Position->Line, & Position->Column);
   if (n == 3)
      Position->FileName = MakeIdent (Buffer, strlen (Buffer) - 1);
   else {  
      (void) fscanf (File, "%[^\n]", Buffer);
      * Position = NoPosition;
   }
# endif
}

char * FormatPosition
# if defined __STDC__ | defined __cplusplus
   (char * String, tPosition Position)
# else
   (String, Position) char * String; tPosition Position;
# endif
{
   static char StaticString [512];
   if (! String) String = StaticString;
# ifdef NO_FILE_NAME
   (void) sprintf (String, "%4d,%3d", Position.Line, Position.Column);
# else
   (void) sprintf (String, "\"%s\":%4d,%3d",
      GetCStr (Position.FileName), Position.Line, Position.Column);
# endif
   return String;
}
