/* $Id: Parser.c,v 1.37 1998/04/04 15:20:54 grosch rel $ */

# include "Parser.h"

# ifdef __cplusplus
extern "C" {
#    include "Reuse.h"
#    include "rMemory.h"
#    include "General.h"
#    include "DynArray.h"
# ifndef NO_RECOVER
#    include "Sets.h"
# endif
# if ! defined NO_RECOVER | defined YYReParse
#    include "Errors.h"
# endif
# if defined YYDEBUG | defined lex_interface
#    include "Position.h"
# endif
#    include <stdio.h>
#    include <string.h>
}
# else
#    include "Reuse.h"
#    include "rMemory.h"
#    include "General.h"
#    include "DynArray.h"
# ifndef NO_RECOVER
#    include "Sets.h"
# endif
# if ! defined NO_RECOVER | defined YYReParse
#    include "Errors.h"
# endif
# if defined YYDEBUG | defined lex_interface
#    include "Position.h"
# endif
#    include <stdio.h>
# endif

# ifdef lex_interface
#    define GetToken	yylex
     extern int yylex ARGS ((void));
#    ifndef AttributeDef
#	include "Position.h"
	   typedef struct { tPosition Position; } tScanAttribute;
	   tScanAttribute	Attribute = {{ 0, 0 }};
#    endif
#    ifndef ErrorAttributeDef
#	define ErrorAttribute(Token, RepairAttribute)
#    endif
#    ifndef yyGetAttribute
#	define yyGetAttribute(yyAttrStackPtr, a) * yyAttrStackPtr = yylval
#    endif
# else
#    include "Scanner.h"
#    ifndef yyGetAttribute
#	define yyGetAttribute(yyAttrStackPtr, a) (yyAttrStackPtr)->Scan = a
#    endif
# endif

typedef unsigned short	yyStateRange	;
typedef unsigned short	yySymbolRange	;
typedef struct { yyStateRange Check, Next; } yytComb;
typedef enum {
yyNT0_intern	= 256,
yyNTfortran	= 257,
yyNTCR1	= 258,
yyNTCR0	= 259,
yyNTPIdent	= 260,
yyNTHPFIdent	= 261,
yyNTopt_comma	= 262,
yyNTopt_dcolon	= 263,
yyNTopt_label	= 264,
yyNTopt_ident	= 265,
yyNTprogram_units	= 266,
yyNTprogram_unit	= 267,
yyNTmain_program	= 268,
yyNTprogram_definition	= 269,
yyNTprogram_token	= 270,
yyNTmodule	= 271,
yyNTmodule_token	= 272,
yyNTsubroutine_subprogram	= 273,
yyNTsubroutine_definition	= 274,
yyNTsubroutine_token	= 275,
yyNTfunction_subprogram	= 276,
yyNTfunction_token	= 277,
yyNTfunction_definition	= 278,
yyNTfunction_result	= 279,
yyNTprefix	= 280,
yyNTextrinsic_spec	= 281,
yyNTextrinsic_spec_arg_list	= 282,
yyNTextrinsic_spec_arg	= 283,
yyNTextrinsic_kind_keyword	= 284,
yyNTblock_data	= 285,
yyNTblock_data_definition	= 286,
yyNTblock_data_token	= 287,
yyNTdummy_arguments	= 288,
yyNTunit_param_list	= 289,
yyNTunit_param	= 290,
yyNTblock	= 291,
yyNTinternal_subprogram_part	= 292,
yyNTinternal_subprograms	= 293,
yyNTinternal_subprogram	= 294,
yyNTkind_selector	= 295,
yyNTbasic_num_type	= 296,
yyNTnum_type	= 297,
yyNTchar_type	= 298,
yyNTkind_type	= 299,
yyNTtype_spec	= 300,
yyNTDimSpec	= 301,
yyNTDimIndexes	= 302,
yyNTDyn_Specifications	= 303,
yyNTDyn_Spec	= 304,
yyNTIndex_Typen	= 305,
yyNTexplicit_shape	= 306,
yyNTLastBegrenzer	= 307,
yyNTspecification_part	= 308,
yyNTdecl_constructs	= 309,
yyNTdeclaration_construct	= 310,
yyNTdefinition	= 311,
yyNTentity_decl_list	= 312,
yyNTentity_decl	= 313,
yyNTopt_array_spec	= 314,
yyNTopt_char_length	= 315,
yyNTopt_init_expr	= 316,
yyNTchar_length	= 317,
yyNTtype_param_value	= 318,
yyNTtype_declaration_stmt	= 319,
yyNToptional_attributes	= 320,
yyNTattribute_list	= 321,
yyNTattr_spec	= 322,
yyNTaccess_spec	= 323,
yyNTdimension_definition	= 324,
yyNTArraySpecList	= 325,
yyNTArraySpec	= 326,
yyNTequivalence_definition	= 327,
yyNTeqvblocks	= 328,
yyNTeqvblock	= 329,
yyNTmore_eqvs	= 330,
yyNTcommon_definition	= 331,
yyNTcommon_object	= 332,
yyNTcommon_cont	= 333,
yyNTnamed_common	= 334,
yyNTblank_common	= 335,
yyNTuse_stmt	= 336,
yyNTrename_list	= 337,
yyNTrename	= 338,
yyNTonly_list	= 339,
yyNTonly	= 340,
yyNTimplicit_definition	= 341,
yyNTmore_implicit_decl	= 342,
yyNTimplicit_decl	= 343,
yyNTletter_list	= 344,
yyNTletter_spec	= 345,
yyNTexternal_definition	= 346,
yyNTExtIdentList	= 347,
yyNTExtIdent	= 348,
yyNTintrinsic_definition	= 349,
yyNTIntIdentList	= 350,
yyNTIntrinsic_Ident	= 351,
yyNTaccess_definition	= 352,
yyNTaccess_id_list	= 353,
yyNTaccess_id	= 354,
yyNToptional_definition	= 355,
yyNToptional_id_list	= 356,
yyNToptional_ident	= 357,
yyNTmap_definition	= 358,
yyNTmap_id_list	= 359,
yyNTmap_ident	= 360,
yyNTnamelist_definition	= 361,
yyNTnamelist_cont	= 362,
yyNTnamelist_groupid	= 363,
yyNTnamelist_object	= 364,
yyNTsave_definition	= 365,
yyNTsave_var_list	= 366,
yyNTsave_var	= 367,
yyNTsequ_definition	= 368,
yyNTsequ_var_list	= 369,
yyNTsequ_var	= 370,
yyNTnsequ_definition	= 371,
yyNTnsequ_var_list	= 372,
yyNTnsequ_var	= 373,
yyNTallocatable_definition	= 374,
yyNTallocatable_var_list	= 375,
yyNTallocatable_var	= 376,
yyNTtarget_definition	= 377,
yyNTtarget_var_list	= 378,
yyNTtarget_var	= 379,
yyNTpointer_definition	= 380,
yyNTpointer_var_list	= 381,
yyNTpointer_var	= 382,
yyNTdata_statement	= 383,
yyNTdata_defs	= 384,
yyNTdata_def	= 385,
yyNTdata_liste	= 386,
yyNTdata_elem	= 387,
yyNTimpl_do_var	= 388,
yyNTdata_values	= 389,
yyNTdata_value	= 390,
yyNTdata_real_value	= 391,
yyNTparameter_definition	= 392,
yyNTnamed_constant_def_list	= 393,
yyNTnamed_constant_def	= 394,
yyNTderived_type_def	= 395,
yyNToptional_id	= 396,
yyNTopt_access_spec	= 397,
yyNTderived_type_components	= 398,
yyNTcomponent_def_stmt	= 399,
yyNTprivate_sequence_stmts	= 400,
yyNTprivate_sequence_stmt	= 401,
yyNTinterface_block	= 402,
yyNTinterface_body_list	= 403,
yyNTinterface_body	= 404,
yyNTmodule_procedure_stmt_list	= 405,
yyNTmodule_procedure_stmt	= 406,
yyNTprocedure_name_list	= 407,
yyNTprocedure_name	= 408,
yyNTgeneric_spec	= 409,
yyNTdefined_operator	= 410,
yyNTintrinsic_operator	= 411,
yyNTintent_definition	= 412,
yyNTintent_spec	= 413,
yyNTintent_list	= 414,
yyNTintent_item	= 415,
yyNThpf_directive	= 416,
yyNTadp_directive	= 417,
yyNTtemplate_directive	= 418,
yyNTtemplate_decl_list	= 419,
yyNTtemplate_decl	= 420,
yyNTprocessors_directive	= 421,
yyNTprocessors_decl_list	= 422,
yyNTprocessors_decl	= 423,
yyNTshadow_directive	= 424,
yyNTshadow_decl_list	= 425,
yyNTshadow_decl	= 426,
yyNTshadow_spec_list	= 427,
yyNTshadow_spec	= 428,
yyNTshadow_width	= 429,
yyNTtrace_directive	= 430,
yyNTtrace_id_list	= 431,
yyNTtrace_id	= 432,
yyNTtree_directive	= 433,
yyNTtree_id_list	= 434,
yyNTtree_id	= 435,
yyNTnodsp_directive	= 436,
yyNTnodsp_id_list	= 437,
yyNTnodsp_id	= 438,
yyNTinherit_directive	= 439,
yyNTinherit_decl_list	= 440,
yyNTinherit_decl	= 441,
yyNTrange_directive	= 442,
yyNTrange_attr_stuff_list	= 443,
yyNTrange_attr_continue	= 444,
yyNTrange_attr_stuff	= 445,
yyNTalign_directive	= 446,
yyNTsingle_align_stuff	= 447,
yyNTalign_source_list	= 448,
yyNTalign_source	= 449,
yyNTalign_spec	= 450,
yyNTopt_align_subscript_list	= 451,
yyNTalign_subscript_list	= 452,
yyNTalign_subscript	= 453,
yyNTdynamic_directive	= 454,
yyNTdynamic_list	= 455,
yyNTdynamic_var	= 456,
yyNTdistribute_directive	= 457,
yyNTsingle_dist_stuff	= 458,
yyNTopt_onto	= 459,
yyNTdist_onto_clause	= 460,
yyNTopt_section_subscript_list	= 461,
yyNTdist_format_clause	= 462,
yyNTdist_format_list	= 463,
yyNTdist_format	= 464,
yyNTcombined_directive	= 465,
yyNTobject_name_list	= 466,
yyNTobject_name	= 467,
yyNTcombined_att_list	= 468,
yyNTcombined_att	= 469,
yyNTalign_attribute_stuff	= 470,
yyNTdist_attribute_stuff	= 471,
yyNTexecution_part	= 472,
yyNTexecution_block	= 473,
yyNTexecution_part_construct	= 474,
yyNTexecutable_construct	= 475,
yyNTstatement	= 476,
yyNTstructured_statement	= 477,
yyNTaction_stmt	= 478,
yyNTused_label	= 479,
yyNTgoto_statement	= 480,
yyNTassigned_labels	= 481,
yyNTlabel_list	= 482,
yyNTassignment_statement	= 483,
yyNTstop_statement	= 484,
yyNTcontinue_statement	= 485,
yyNTreturn_statement	= 486,
yyNTexit_statement	= 487,
yyNTcycle_statement	= 488,
yyNTallocate_statement	= 489,
yyNTdeallocate_statement	= 490,
yyNTnullify_statement	= 491,
yyNTcall_statement	= 492,
yyNTparams	= 493,
yyNTparam	= 494,
yyNTio_statement	= 495,
yyNTwrite_statement	= 496,
yyNTprint_statement	= 497,
yyNTread_statement	= 498,
yyNTopen_statement	= 499,
yyNTclose_statement	= 500,
yyNTrewind_statement	= 501,
yyNTbackspace_statement	= 502,
yyNTendfile_statement	= 503,
yyNTinquire_statement	= 504,
yyNTexternal_file_unit	= 505,
yyNTio_specification	= 506,
yyNTio_spec_list	= 507,
yyNTio_spec	= 508,
yyNTformat_identifier	= 509,
yyNTio_list	= 510,
yyNTio_item	= 511,
yyNTformat_statement	= 512,
yyNTformat_list	= 513,
yyNTentry_statement	= 514,
yyNTstruct_loop_statement	= 515,
yyNTloop_statement	= 516,
yyNTindependent_clause	= 517,
yyNTind_clauses	= 518,
yyNTnew_clause	= 519,
yyNTnew_var_list	= 520,
yyNTreduction_clause	= 521,
yyNTreduction_var_list	= 522,
yyNTreduction_var	= 523,
yyNTForLabel	= 524,
yyNTLaufvariable	= 525,
yyNTDoRange	= 526,
yyNTforall_cont	= 527,
yyNTforall_end	= 528,
yyNTif_statement	= 529,
yyNTif_construct	= 530,
yyNTelse_part	= 531,
yyNTwhere_statement	= 532,
yyNTwhere_construct	= 533,
yyNTelsewhere_part	= 534,
yyNTcase_construct	= 535,
yyNTcase_list	= 536,
yyNTcase_item	= 537,
yyNTcase_selector	= 538,
yyNTcase_value_range_list	= 539,
yyNTcase_value_range	= 540,
yyNTadp_statement	= 541,
yyNTatomic_construct	= 542,
yyNThpf_statement	= 543,
yyNTrealign_attribute_stuff	= 544,
yyNTrealignee_list	= 545,
yyNTrealignee	= 546,
yyNTredist_attribute_stuff	= 547,
yyNTredistributee_list	= 548,
yyNTredistributee	= 549,
yyNTsimple_on_directive	= 550,
yyNThome_expr	= 551,
yyNTopt_hpf_on	= 552,
yyNTsimple_resident_directive	= 553,
yyNTopt_hpf_resident	= 554,
yyNTresident_clause	= 555,
yyNTopt_local_var_list	= 556,
yyNTlocal_var_list	= 557,
yyNTsimple_new_directive	= 558,
yyNTopt_hpf_new	= 559,
yyNTsimple_reduction_directive	= 560,
yyNTopt_hpf_reduction	= 561,
yyNTtask_flag	= 562,
yyNTvariable	= 563,
yyNTstructure_component	= 564,
yyNTindex_var	= 565,
yyNTsection_subscript_list	= 566,
yyNTIndex_Elem	= 567,
yyNTSlice	= 568,
yyNTdumexpression	= 569,
yyNTprimary	= 570,
yyNTimpl_do_exp	= 571,
yyNTexpression	= 572,
yyNTdefined_binary_op	= 573,
yyNTlevel5_expr	= 574,
yyNTequiv_op	= 575,
yyNTequiv_operand	= 576,
yyNTor_op	= 577,
yyNTor_operand	= 578,
yyNTand_op	= 579,
yyNTand_operand	= 580,
yyNTnot_op	= 581,
yyNTlevel4_expr	= 582,
yyNTrel_op	= 583,
yyNTlevel3_expr	= 584,
yyNTconcat_op	= 585,
yyNTlevel2_expr	= 586,
yyNTadd_op	= 587,
yyNTsigned_add_operand	= 588,
yyNTadd_operand	= 589,
yyNTmult_op	= 590,
yyNTmult_operand	= 591,
yyNTpower_op	= 592,
yyNTlevel1_expr	= 593,
yyNTdefined_unary_op	= 594,
yyNTPReal	= 595,
yyNTKonstante	= 596,
yyNTRealKonstante	= 597,
yyNTSignedKonstante	= 598
} yytNonterminal;
typedef struct { short yyMode; rbool yyActions, yyMessages; } yytControl;

static	yytControl	yyControl	= { 0, rtrue, rtrue };
	rbool		Debug	= rfalse;

# define yyFirstTerminal	0
# define yyLastTerminal	255
# define yySetSize	256
# define yyFirstSymbol	0
# define yyLastSymbol	598
# define yyTTableMax	2157
# define yyNTableMax	1548
# define yyStartState	1
# define yyFirstReadState	1
# define yyLastReadState	819
# define yyFirstReadReduceState	820
# define yyLastReadReduceState	1008
# define yyFirstReduceState	1009
# define yyLastReduceState	1803
# define yyLastState	1803
# define yyLastStopState	1009
# define YYTDefault
# define YYNDefault

# define yyFirstFinalState	yyFirstReadReduceState

# define ErrorMessages(Messages) yyControl.yyMessages = Messages
# define SemActions(Actions)	 yyControl.yyActions = Actions

# ifdef YYGetLook

# define GetLookahead(k)	yyGetLookahead ((k) - 1, yyTerminal)
# define GetAttribute(k, a)	xxGetAttribute ((k) - 1, yyTerminal, a)

static int yyGetLookahead	ARGS ((int yyk, yySymbolRange yyToken));
static void xxGetAttribute	ARGS ((int yyk, yySymbolRange yyToken,
				tScanAttribute * yyAttribute));

# endif

/* line 26 "fortran.lalr" */


#include <stdio.h>
#include "global.h"
#include "MySource.h"  /* CodeLine, GetPosition */
#include "Tree.h"
#include "BuildTree.h"
#include "labels.h"

#define NLine(a) MyCodeLine(a.Scan.Position.Line)

int MyCodeLine (line)
int line;
{
   return CodeLine(line);   /* CodeLine imported form MySource */
}

   /********************************************************
   *                                                       *
   *     Special functions for abstract syntax trees       *
   *                                                       *
   ********************************************************/

typedef struct { tScanAttribute Scan;
                 int Label;
                 int Line;
                 tTree Tree;         } tParsAttribute;

tStringRef MakeIntToReal (n)
int n;

{ char number[15];
  sprintf (number, "%d.", n);
  return (PutString (number, strlen (number)));
}



# if defined lex_interface & ! defined yylvalDef
     tParsAttribute yylval;
# endif

# ifndef yyInitStackSize
# define yyInitStackSize	100
# endif
# ifndef ERROR
# define ERROR
# endif
# define yyNoState		0
# define yystandard		1
# define yytrial		2
# define yybuffer		4
# define yyreparse		8
# define yyS			yySynAttribute
# define yyA			yyAttrStackPtr
# define YYACCEPT		goto yyAccept
# define YYABORT		goto yyAbort

# ifdef YYDEC_TABLE
# define yyDecrement(x)
# define yySetNT(x)
# else
# define yyDecrement(x)		yyStateStackPtr -= x; yyAttrStackPtr -= x;
# define yySetNT(x)		yyNonterminal = x;
# endif

# ifdef YYNDefault
# define yytNComb yytComb
# else
# define yytNComb yyStateRange
# endif

# if defined YYDEBUG | defined YYDCRP
static	long		yyCount		= 0;
static	FILE *		yyTrace		;

static	void		yyPrintState	ARGS ((yyStateRange yyState));
static	void		yyNl		ARGS ((void));

static	char *		yyRule		[] = { 0,
"0_intern : fortran _EOF_ ",
"fortran : CR0 program_units ",
"CR1 : NewLine CR0 ",
"CR0 : ",
"CR0 : NewLine CR0 ",
"PIdent : Ident ",
"PIdent : IN ",
"PIdent : OUT ",
"PIdent : INOUT ",
"PIdent : ALLOCATABLE1 ",
"PIdent : DIMENSION1 ",
"PIdent : PARAMETER1 ",
"PIdent : INTENT1 ",
"PIdent : EXTERNAL1 ",
"PIdent : INTRINSIC1 ",
"PIdent : OPTIONAL1 ",
"PIdent : LAYOUT1 ",
"PIdent : PASS_BY1 ",
"PIdent : MAP_TO1 ",
"PIdent : POINTER1 ",
"PIdent : SAVE1 ",
"PIdent : TARGET1 ",
"PIdent : DATA1 ",
"PIdent : PUBLIC1 ",
"PIdent : PRIVATE1 ",
"PIdent : SEQUENCE1 ",
"PIdent : ARRAY1 ",
"HPFIdent : Ident ",
"HPFIdent : NEW ",
"opt_comma : ",
"opt_comma : ',' ",
"opt_dcolon : ",
"opt_dcolon : '::' ",
"opt_label : ",
"opt_ident : ",
"opt_ident : PIdent ",
"program_units : program_unit ",
"program_units : program_unit program_units ",
"program_unit : main_program ",
"program_unit : subroutine_subprogram ",
"program_unit : function_subprogram ",
"program_unit : block_data ",
"program_unit : module ",
"main_program : block CR0 ",
"main_program : program_definition block program_token CR1 ",
"program_definition : PROGRAM PIdent dummy_arguments CR1 ",
"program_token : PROGRAM PIdent ",
"program_token : PROGRAM ",
"program_token : ",
"module : MODULE PIdent CR1 block module_token CR1 ",
"module_token : MODULE PIdent ",
"module_token : MODULE ",
"module_token : ",
"subroutine_subprogram : subroutine_definition block subroutine_token \
CR1 ",
"subroutine_definition : prefix SUBROUTINE PIdent dummy_arguments CR1 ",
"subroutine_token : SUBROUTINE PIdent ",
"subroutine_token : SUBROUTINE ",
"subroutine_token : ",
"function_subprogram : function_definition block function_token CR1 ",
"function_token : FUNCTION PIdent ",
"function_token : FUNCTION ",
"function_token : ",
"function_definition : prefix FUNCTION PIdent dummy_arguments \
function_result CR1 ",
"function_result : ",
"function_result : RESULT '(' PIdent ')' ",
"prefix : ",
"prefix : type_spec prefix ",
"prefix : RECURSIVE prefix ",
"prefix : PURE prefix ",
"prefix : EXTRINSIC '(' extrinsic_spec ')' prefix ",
"extrinsic_spec : extrinsic_kind_keyword ",
"extrinsic_spec : extrinsic_spec_arg_list ",
"extrinsic_spec_arg_list : extrinsic_spec_arg ",
"extrinsic_spec_arg_list : extrinsic_spec_arg ',' \
extrinsic_spec_arg_list ",
"extrinsic_spec_arg : PIdent '=' StringConst ",
"extrinsic_spec_arg : StringConst ",
"extrinsic_kind_keyword : PIdent ",
"block_data : block_data_definition block block_data_token CR1 ",
"block_data_definition : BLOCKDATA PIdent CR1 ",
"block_data_definition : BLOCKDATA CR1 ",
"block_data_token : BLOCKDATA PIdent ",
"block_data_token : BLOCKDATA ",
"block_data_token : ",
"dummy_arguments : ",
"dummy_arguments : '(' ')' ",
"dummy_arguments : '(' unit_param_list ')' ",
"unit_param_list : unit_param ",
"unit_param_list : unit_param ',' unit_param_list ",
"unit_param : PIdent ",
"unit_param : '*' ",
"block : specification_part execution_part internal_subprogram_part \
opt_label END ",
"internal_subprogram_part : ",
"internal_subprogram_part : CONTAINS CR1 internal_subprograms ",
"internal_subprograms : internal_subprogram ",
"internal_subprograms : internal_subprogram internal_subprograms ",
"internal_subprogram : subroutine_subprogram ",
"internal_subprogram : function_subprogram ",
"kind_selector : '(' expression ')' ",
"kind_selector : '(' PIdent '=' expression ')' ",
"kind_selector : '(' '*' ')' ",
"kind_selector : '(' PIdent '=' '*' ')' ",
"basic_num_type : REAL ",
"basic_num_type : INTEGER ",
"basic_num_type : COMPLEX ",
"basic_num_type : LOGICAL ",
"num_type : basic_num_type ",
"num_type : basic_num_type '*' IntConst ",
"num_type : DOUBLE_PRECISION ",
"num_type : DOUBLE_COMPLEX ",
"char_type : CHARACTER ",
"char_type : CHARACTER '*' char_length ",
"kind_type : CHARACTER kind_selector ",
"kind_type : basic_num_type kind_selector ",
"type_spec : kind_type ",
"type_spec : char_type ",
"type_spec : num_type ",
"type_spec : TYPE '(' PIdent ')' ",
"DimSpec : '(' DimIndexes ')' ",
"DimIndexes : Index_Typen ",
"DimIndexes : Dyn_Specifications ",
"Dyn_Specifications : Dyn_Spec ",
"Dyn_Specifications : Dyn_Spec ',' Dyn_Specifications ",
"Dyn_Spec : ':' ",
"Dyn_Spec : expression ':' ",
"Index_Typen : LastBegrenzer ",
"Index_Typen : explicit_shape ",
"Index_Typen : explicit_shape ',' Index_Typen ",
"explicit_shape : expression ",
"explicit_shape : expression ':' expression ",
"LastBegrenzer : '*' ",
"LastBegrenzer : expression ':' '*' ",
"specification_part : decl_constructs ",
"decl_constructs : declaration_construct CR1 decl_constructs ",
"decl_constructs : ",
"declaration_construct : use_stmt ",
"declaration_construct : derived_type_def ",
"declaration_construct : interface_block ",
"declaration_construct : type_declaration_stmt ",
"declaration_construct : opt_label definition ",
"definition : parameter_definition ",
"definition : implicit_definition ",
"definition : access_definition ",
"definition : allocatable_definition ",
"definition : common_definition ",
"definition : data_statement ",
"definition : format_statement ",
"definition : dimension_definition ",
"definition : equivalence_definition ",
"definition : external_definition ",
"definition : intent_definition ",
"definition : intrinsic_definition ",
"definition : namelist_definition ",
"definition : optional_definition ",
"definition : pointer_definition ",
"definition : save_definition ",
"definition : sequ_definition ",
"definition : nsequ_definition ",
"definition : target_definition ",
"definition : map_definition ",
"definition : hpf_directive ",
"definition : adp_directive ",
"entity_decl_list : entity_decl ",
"entity_decl_list : entity_decl ',' entity_decl_list ",
"entity_decl : PIdent opt_array_spec opt_char_length opt_init_expr ",
"opt_array_spec : ",
"opt_array_spec : '(' DimIndexes ')' ",
"opt_char_length : ",
"opt_char_length : '*' char_length ",
"opt_init_expr : ",
"opt_init_expr : '=' expression ",
"char_length : '(' type_param_value ')' ",
"char_length : IntConst ",
"type_param_value : '*' ",
"type_param_value : expression ",
"type_declaration_stmt : type_spec optional_attributes entity_decl_list ",
"optional_attributes : ",
"optional_attributes : '::' ",
"optional_attributes : attribute_list '::' ",
"attribute_list : ',' attr_spec ",
"attribute_list : ',' attr_spec attribute_list ",
"attr_spec : PARAMETER1 ",
"attr_spec : access_spec ",
"attr_spec : ALLOCATABLE1 ",
"attr_spec : DIMENSION1 '(' DimIndexes ')' ",
"attr_spec : ARRAY1 '(' DimIndexes ')' ",
"attr_spec : INTENT1 '(' intent_spec ')' ",
"attr_spec : EXTERNAL1 ",
"attr_spec : INTRINSIC1 ",
"attr_spec : OPTIONAL1 ",
"attr_spec : LAYOUT1 '(' StringConst ')' ",
"attr_spec : PASS_BY1 '(' StringConst ')' ",
"attr_spec : MAP_TO1 '(' StringConst ')' ",
"attr_spec : POINTER1 ",
"attr_spec : SAVE1 ",
"attr_spec : TARGET1 ",
"attr_spec : DATA1 ",
"access_spec : PUBLIC1 ",
"access_spec : PRIVATE1 ",
"access_spec : SEQUENCE1 ",
"dimension_definition : DIMENSION opt_dcolon ArraySpecList ",
"ArraySpecList : ArraySpec ",
"ArraySpecList : ArraySpec ',' ArraySpecList ",
"ArraySpec : PIdent DimSpec ",
"equivalence_definition : EQUIVALENCE eqvblocks ",
"eqvblocks : eqvblock ",
"eqvblocks : eqvblock ',' eqvblocks ",
"eqvblock : '(' variable ',' variable more_eqvs ')' ",
"more_eqvs : ",
"more_eqvs : ',' variable more_eqvs ",
"common_definition : COMMON blank_common common_object common_cont ",
"common_definition : COMMON named_common common_object common_cont ",
"common_object : PIdent ",
"common_object : PIdent DimSpec ",
"common_cont : ",
"common_cont : ',' common_object common_cont ",
"common_cont : opt_comma named_common common_object common_cont ",
"named_common : '/' PIdent '/' ",
"blank_common : '/' '/' ",
"blank_common : '//' ",
"blank_common : ",
"use_stmt : USE PIdent rename_list ",
"use_stmt : USE PIdent ',' ONLY ':' only_list ",
"rename_list : ",
"rename_list : ',' rename rename_list ",
"rename : PIdent '=>' PIdent ",
"only_list : only ",
"only_list : only ',' only_list ",
"only : access_id ",
"only : rename ",
"implicit_definition : IMPLICIT Ident ",
"implicit_definition : IMPLICIT implicit_decl more_implicit_decl ",
"more_implicit_decl : ",
"more_implicit_decl : ',' implicit_decl more_implicit_decl ",
"implicit_decl : num_type '(' letter_list ')' ",
"implicit_decl : char_type '(' letter_list ')' ",
"letter_list : letter_spec ",
"letter_list : letter_spec ',' letter_list ",
"letter_spec : PIdent ",
"letter_spec : PIdent '-' PIdent ",
"external_definition : EXTERNAL ExtIdentList ",
"ExtIdentList : ExtIdent ",
"ExtIdentList : ExtIdent ',' ExtIdentList ",
"ExtIdent : PIdent ",
"intrinsic_definition : INTRINSIC IntIdentList ",
"IntIdentList : Intrinsic_Ident ",
"IntIdentList : Intrinsic_Ident ',' IntIdentList ",
"Intrinsic_Ident : PIdent ",
"access_definition : PRIVATE ",
"access_definition : PUBLIC ",
"access_definition : PUBLIC opt_dcolon access_id_list ",
"access_definition : PRIVATE opt_dcolon access_id_list ",
"access_id_list : access_id ",
"access_id_list : access_id ',' access_id_list ",
"access_id : PIdent ",
"access_id : OPERATOR '(' defined_operator ')' ",
"access_id : ASSIGNMENT '(' '=' ')' ",
"optional_definition : OPTIONAL opt_dcolon optional_id_list ",
"optional_id_list : optional_ident ",
"optional_id_list : optional_ident ',' optional_id_list ",
"optional_ident : PIdent ",
"map_definition : MAP_TO '(' StringConst ')' opt_dcolon map_id_list ",
"map_definition : LAYOUT '(' StringConst ')' opt_dcolon map_id_list ",
"map_definition : PASS_BY '(' StringConst ')' opt_dcolon map_id_list ",
"map_id_list : map_ident ",
"map_id_list : map_ident ',' map_id_list ",
"map_ident : PIdent ",
"namelist_definition : NAMELIST namelist_groupid namelist_object \
namelist_cont ",
"namelist_cont : ",
"namelist_cont : ',' namelist_object namelist_cont ",
"namelist_cont : opt_comma namelist_groupid namelist_object \
namelist_cont ",
"namelist_groupid : '/' PIdent '/' ",
"namelist_object : PIdent ",
"save_definition : SAVE ",
"save_definition : SAVE opt_dcolon save_var_list ",
"save_var_list : save_var ",
"save_var_list : save_var ',' save_var_list ",
"save_var : PIdent ",
"save_var : '/' PIdent '/' ",
"sequ_definition : HPFSEQUENCE ",
"sequ_definition : HPFSEQUENCE opt_dcolon sequ_var_list ",
"sequ_var_list : sequ_var ",
"sequ_var_list : sequ_var ',' sequ_var_list ",
"sequ_var : PIdent ",
"sequ_var : '/' PIdent '/' ",
"nsequ_definition : NOSEQUENCE ",
"nsequ_definition : NOSEQUENCE opt_dcolon nsequ_var_list ",
"nsequ_var_list : nsequ_var ",
"nsequ_var_list : nsequ_var ',' nsequ_var_list ",
"nsequ_var : PIdent ",
"nsequ_var : '/' PIdent '/' ",
"allocatable_definition : ALLOCATABLE opt_dcolon allocatable_var_list ",
"allocatable_var_list : allocatable_var ",
"allocatable_var_list : allocatable_var ',' allocatable_var_list ",
"allocatable_var : PIdent ",
"allocatable_var : PIdent DimSpec ",
"target_definition : TARGET opt_dcolon target_var_list ",
"target_var_list : target_var ",
"target_var_list : target_var ',' target_var_list ",
"target_var : PIdent ",
"target_var : PIdent DimSpec ",
"pointer_definition : POINTER opt_dcolon pointer_var_list ",
"pointer_var_list : pointer_var ",
"pointer_var_list : pointer_var ',' pointer_var_list ",
"pointer_var : PIdent ",
"pointer_var : PIdent DimSpec ",
"data_statement : DATA data_defs ",
"data_defs : data_def ",
"data_defs : data_def opt_comma data_defs ",
"data_def : data_liste '/' data_values '/' ",
"data_liste : data_elem ",
"data_liste : data_elem ',' data_liste ",
"data_elem : variable ",
"data_elem : '(' data_elem ',' impl_do_var ')' ",
"impl_do_var : data_elem ',' impl_do_var ",
"impl_do_var : Laufvariable '=' DoRange ",
"data_values : data_value ",
"data_values : data_value ',' data_values ",
"data_value : PIdent ",
"data_value : SignedKonstante ",
"data_value : IntConst '*' data_real_value ",
"data_value : PIdent '*' data_real_value ",
"data_real_value : SignedKonstante ",
"data_real_value : PIdent ",
"parameter_definition : PARAMETER '(' named_constant_def_list ')' ",
"named_constant_def_list : named_constant_def ",
"named_constant_def_list : named_constant_def ',' \
named_constant_def_list ",
"named_constant_def : PIdent '=' expression ",
"derived_type_def : TYPE opt_access_spec PIdent CR1 \
private_sequence_stmts derived_type_components ENDTYPE optional_id ",
"optional_id : ",
"optional_id : PIdent ",
"opt_access_spec : ",
"opt_access_spec : '::' ",
"opt_access_spec : ',' access_spec '::' ",
"derived_type_components : ",
"derived_type_components : component_def_stmt derived_type_components ",
"component_def_stmt : type_declaration_stmt CR1 ",
"component_def_stmt : hpf_directive CR1 ",
"component_def_stmt : adp_directive CR1 ",
"private_sequence_stmts : ",
"private_sequence_stmts : private_sequence_stmt private_sequence_stmts ",
"private_sequence_stmt : PRIVATE CR1 ",
"private_sequence_stmt : SEQUENCE CR1 ",
"interface_block : INTERFACE generic_spec CR1 interface_body_list \
module_procedure_stmt_list ENDINTERFACE ",
"interface_body_list : ",
"interface_body_list : interface_body interface_body_list ",
"interface_body : subroutine_subprogram ",
"interface_body : function_subprogram ",
"module_procedure_stmt_list : ",
"module_procedure_stmt_list : module_procedure_stmt \
module_procedure_stmt_list ",
"module_procedure_stmt : MODULE PROCEDURE procedure_name_list CR1 ",
"procedure_name_list : procedure_name ",
"procedure_name_list : procedure_name ',' procedure_name_list ",
"procedure_name : PIdent ",
"generic_spec : ",
"generic_spec : PIdent ",
"generic_spec : OPERATOR '(' defined_operator ')' ",
"generic_spec : ASSIGNMENT '(' '=' ')' ",
"defined_operator : UserOp ",
"defined_operator : intrinsic_operator ",
"intrinsic_operator : power_op ",
"intrinsic_operator : mult_op ",
"intrinsic_operator : add_op ",
"intrinsic_operator : concat_op ",
"intrinsic_operator : rel_op ",
"intrinsic_operator : not_op ",
"intrinsic_operator : and_op ",
"intrinsic_operator : or_op ",
"intrinsic_operator : equiv_op ",
"intent_definition : INTENT '(' intent_spec ')' '::' intent_list ",
"intent_spec : IN ",
"intent_spec : OUT ",
"intent_spec : INOUT ",
"intent_list : intent_item ",
"intent_list : intent_item ',' intent_list ",
"intent_item : PIdent ",
"hpf_directive : template_directive ",
"hpf_directive : processors_directive ",
"hpf_directive : align_directive ",
"hpf_directive : distribute_directive ",
"hpf_directive : dynamic_directive ",
"hpf_directive : combined_directive ",
"hpf_directive : inherit_directive ",
"hpf_directive : range_directive ",
"hpf_directive : shadow_directive ",
"adp_directive : trace_directive ",
"adp_directive : tree_directive ",
"adp_directive : nodsp_directive ",
"template_directive : TEMPLATE template_decl_list ",
"template_decl_list : template_decl ",
"template_decl_list : template_decl ',' template_decl_list ",
"template_decl : PIdent ",
"template_decl : PIdent DimSpec ",
"processors_directive : PROCESSORS processors_decl_list ",
"processors_decl_list : processors_decl ",
"processors_decl_list : processors_decl ',' processors_decl_list ",
"processors_decl : PIdent ",
"processors_decl : PIdent DimSpec ",
"shadow_directive : SHADOW shadow_decl_list ",
"shadow_decl_list : shadow_decl ",
"shadow_decl_list : shadow_decl ',' shadow_decl_list ",
"shadow_decl : PIdent '(' shadow_spec_list ')' ",
"shadow_spec_list : shadow_spec ",
"shadow_spec_list : shadow_spec ',' shadow_spec_list ",
"shadow_spec : shadow_width ':' shadow_width ",
"shadow_spec : shadow_width ",
"shadow_width : '*' ",
"shadow_width : expression ",
"trace_directive : TRACE opt_dcolon trace_id_list ",
"trace_id_list : trace_id ",
"trace_id_list : trace_id ',' trace_id_list ",
"trace_id : PIdent ",
"tree_directive : TREE opt_dcolon tree_id_list ",
"tree_id_list : tree_id ",
"tree_id_list : tree_id ',' tree_id_list ",
"tree_id : PIdent ",
"nodsp_directive : NODESCRIPTOR opt_dcolon nodsp_id_list ",
"nodsp_id_list : nodsp_id ",
"nodsp_id_list : nodsp_id ',' nodsp_id_list ",
"nodsp_id : PIdent ",
"inherit_directive : INHERIT inherit_decl_list ",
"inherit_decl_list : inherit_decl ",
"inherit_decl_list : inherit_decl ',' inherit_decl_list ",
"inherit_decl : PIdent ",
"range_directive : RANGE PIdent range_attr_stuff_list ",
"range_attr_stuff_list : range_attr_stuff range_attr_continue ",
"range_attr_continue : ",
"range_attr_continue : range_attr_stuff range_attr_continue ",
"range_attr_stuff : '(' dist_format_list ')' ",
"align_directive : ALIGN single_align_stuff ",
"single_align_stuff : HPFIdent '(' align_source_list ')' WITH align_spec ",
"single_align_stuff : HPFIdent WITH align_spec ",
"align_source_list : align_source ",
"align_source_list : align_source ',' align_source_list ",
"align_source : ':' ",
"align_source : '*' ",
"align_source : HPFIdent ",
"align_spec : HPFIdent opt_align_subscript_list ",
"align_spec : '*' HPFIdent opt_align_subscript_list ",
"opt_align_subscript_list : ",
"opt_align_subscript_list : '(' align_subscript_list ')' ",
"align_subscript_list : align_subscript ",
"align_subscript_list : align_subscript ',' align_subscript_list ",
"align_subscript : '*' ",
"align_subscript : Index_Elem ",
"dynamic_directive : DYNAMIC dynamic_list ",
"dynamic_list : dynamic_var ",
"dynamic_list : dynamic_var ',' dynamic_list ",
"dynamic_var : HPFIdent ",
"distribute_directive : DISTRIBUTE single_dist_stuff ",
"single_dist_stuff : HPFIdent dist_format_clause opt_onto ",
"opt_onto : ",
"opt_onto : dist_onto_clause ",
"dist_onto_clause : ONTO HPFIdent opt_section_subscript_list ",
"dist_onto_clause : ONTO '*' HPFIdent opt_section_subscript_list ",
"dist_onto_clause : ONTO '*' ",
"opt_section_subscript_list : ",
"opt_section_subscript_list : '(' section_subscript_list ')' ",
"dist_format_clause : '(' dist_format_list ')' ",
"dist_format_clause : '*' '(' dist_format_list ')' ",
"dist_format_clause : '*' ",
"dist_format_list : dist_format ",
"dist_format_list : dist_format ',' dist_format_list ",
"dist_format : BLOCK ",
"dist_format : BLOCK '(' expression ')' ",
"dist_format : BLOCK '(' ')' ",
"dist_format : CYCLIC ",
"dist_format : CYCLIC '(' expression ')' ",
"dist_format : CYCLIC '(' ')' ",
"dist_format : GEN_BLOCK '(' variable ')' ",
"dist_format : GEN_BLOCK '(' ')' ",
"dist_format : INDIRECT '(' variable ')' ",
"dist_format : ARBITRARY '(' expression ',' variable ',' variable ')' ",
"dist_format : INDIRECT '(' ')' ",
"dist_format : ARBITRARY '(' ')' ",
"dist_format : '*' ",
"dist_format : ALL ",
"combined_directive : combined_att_list '::' object_name_list ",
"object_name_list : object_name ",
"object_name_list : object_name ',' object_name_list ",
"object_name : HPFIdent opt_array_spec ",
"combined_att_list : combined_att ",
"combined_att_list : combined_att ',' combined_att_list ",
"combined_att : ALIGN align_attribute_stuff ",
"combined_att : DISTRIBUTE dist_attribute_stuff ",
"combined_att : DYNAMIC ",
"combined_att : INHERIT ",
"combined_att : TEMPLATE ",
"combined_att : PROCESSORS ",
"combined_att : DIMENSION DimSpec ",
"combined_att : SHADOW '(' shadow_spec_list ')' ",
"combined_att : RANGE range_attr_stuff_list ",
"align_attribute_stuff : WITH align_spec ",
"align_attribute_stuff : '(' align_source_list ')' WITH align_spec ",
"dist_attribute_stuff : dist_format_clause opt_onto ",
"dist_attribute_stuff : dist_onto_clause ",
"execution_part : executable_construct CR1 execution_block ",
"execution_part : ",
"execution_block : execution_part_construct CR1 execution_block ",
"execution_block : ",
"execution_part_construct : executable_construct ",
"execution_part_construct : opt_label data_statement ",
"execution_part_construct : opt_label format_statement ",
"executable_construct : opt_label statement ",
"statement : action_stmt ",
"statement : entry_statement ",
"statement : hpf_statement ",
"statement : adp_statement ",
"statement : structured_statement ",
"structured_statement : where_construct ",
"structured_statement : case_construct ",
"structured_statement : PIdent ':' case_construct ",
"structured_statement : struct_loop_statement ",
"structured_statement : independent_clause struct_loop_statement ",
"structured_statement : PIdent ':' if_construct ",
"structured_statement : if_construct ",
"action_stmt : allocate_statement ",
"action_stmt : assignment_statement ",
"action_stmt : call_statement ",
"action_stmt : continue_statement ",
"action_stmt : cycle_statement ",
"action_stmt : deallocate_statement ",
"action_stmt : exit_statement ",
"action_stmt : goto_statement ",
"action_stmt : if_statement ",
"action_stmt : io_statement ",
"action_stmt : nullify_statement ",
"action_stmt : return_statement ",
"action_stmt : stop_statement ",
"action_stmt : where_statement ",
"used_label : IntConst ",
"goto_statement : GOTO used_label ",
"goto_statement : GOTO PIdent assigned_labels ",
"goto_statement : GOTO '(' label_list ')' opt_comma expression ",
"assigned_labels : ",
"assigned_labels : opt_comma '(' label_list ')' ",
"label_list : used_label ",
"label_list : used_label ',' label_list ",
"assignment_statement : variable '=' expression ",
"assignment_statement : variable '=>' expression ",
"assignment_statement : ASSIGN used_label TO PIdent ",
"stop_statement : STOP ",
"stop_statement : STOP expression ",
"continue_statement : CONTINUE ",
"return_statement : RETURN ",
"return_statement : RETURN expression ",
"exit_statement : EXIT PIdent ",
"exit_statement : EXIT ",
"exit_statement : CYCLE PIdent ",
"cycle_statement : CYCLE ",
"allocate_statement : ALLOCATE '(' params ')' ",
"allocate_statement : ALLOCATE TREE param ",
"deallocate_statement : DEALLOCATE '(' params ')' ",
"deallocate_statement : DEALLOCATE TREE param ",
"nullify_statement : NULLIFY '(' params ')' ",
"call_statement : CALL PIdent ",
"call_statement : CALL PIdent '(' ')' ",
"call_statement : CALL PIdent '(' params ')' ",
"params : param ",
"params : param ',' params ",
"param : PIdent '=' expression ",
"param : expression ",
"param : '*' used_label ",
"io_statement : print_statement ",
"io_statement : read_statement ",
"io_statement : write_statement ",
"io_statement : open_statement ",
"io_statement : close_statement ",
"io_statement : rewind_statement ",
"io_statement : backspace_statement ",
"io_statement : endfile_statement ",
"io_statement : inquire_statement ",
"write_statement : WRITE io_specification ",
"write_statement : WRITE io_specification io_list ",
"print_statement : PRINT format_identifier ",
"print_statement : PRINT format_identifier ',' io_list ",
"read_statement : READ format_identifier ",
"read_statement : READ format_identifier ',' io_list ",
"read_statement : READ io_specification ",
"read_statement : READ io_specification io_list ",
"open_statement : OPEN io_specification ",
"close_statement : CLOSE io_specification ",
"rewind_statement : REWIND external_file_unit ",
"rewind_statement : REWIND io_specification ",
"backspace_statement : BACKSPACE external_file_unit ",
"backspace_statement : BACKSPACE io_specification ",
"endfile_statement : ENDFILE external_file_unit ",
"endfile_statement : ENDFILE io_specification ",
"inquire_statement : INQUIRE io_specification ",
"external_file_unit : IntConst ",
"external_file_unit : variable ",
"io_specification : '(' io_spec_list ')' ",
"io_spec_list : io_spec ",
"io_spec_list : io_spec ',' io_spec_list ",
"io_spec : expression ",
"io_spec : PIdent '=' expression ",
"io_spec : '*' ",
"io_spec : PIdent '=' '*' ",
"format_identifier : used_label ",
"format_identifier : '*' ",
"format_identifier : StringConst ",
"format_identifier : PIdent ",
"io_list : io_item ",
"io_list : io_item ',' io_list ",
"io_item : expression ",
"format_statement : FORMAT format_list ",
"format_list : FORMAT_ARG format_list ",
"format_list : FORMAT_ARG ",
"entry_statement : ENTRY PIdent dummy_arguments function_result ",
"struct_loop_statement : loop_statement ",
"struct_loop_statement : PIdent ':' loop_statement ",
"loop_statement : DO ForLabel opt_comma WHILE '(' expression ')' CR1 \
execution_block ENDDO opt_ident ",
"loop_statement : DO ForLabel opt_comma Laufvariable '=' DoRange CR1 \
execution_block ENDDO opt_ident ",
"loop_statement : DO ForLabel CR1 execution_block ENDDO opt_ident ",
"loop_statement : FORALL '(' forall_cont ",
"independent_clause : INDEPENDENT ind_clauses CR1 ",
"ind_clauses : ",
"ind_clauses : opt_comma ON home_expr ind_clauses ",
"ind_clauses : opt_comma resident_clause ind_clauses ",
"ind_clauses : opt_comma new_clause ind_clauses ",
"ind_clauses : opt_comma reduction_clause ind_clauses ",
"new_clause : NEW '(' new_var_list ')' ",
"new_var_list : variable ",
"new_var_list : variable ',' new_var_list ",
"reduction_clause : REDUCTION '(' reduction_var_list ')' ",
"reduction_var_list : reduction_var ",
"reduction_var_list : reduction_var ',' reduction_var_list ",
"reduction_var : PIdent ",
"reduction_var : structure_component ",
"ForLabel : ",
"ForLabel : IntConst ",
"Laufvariable : PIdent ",
"DoRange : expression ',' expression ",
"DoRange : expression ',' expression ',' expression ",
"forall_cont : Laufvariable '=' Slice ',' forall_cont ",
"forall_cont : Laufvariable '=' Slice forall_end ",
"forall_cont : expression forall_end ",
"forall_end : ')' assignment_statement ",
"forall_end : ')' CR1 execution_block ENDFORALL ",
"if_statement : IF '(' expression ')' used_label ',' used_label ',' \
used_label ",
"if_statement : IF '(' expression ')' action_stmt ",
"if_construct : IF '(' expression ')' THEN opt_ident CR1 execution_block \
else_part ENDIF opt_ident ",
"else_part : ",
"else_part : ELSEIF '(' expression ')' THEN opt_ident CR1 \
execution_block else_part ",
"else_part : ELSE opt_ident CR1 execution_block ",
"where_statement : WHERE '(' expression ')' action_stmt ",
"where_construct : WHERE '(' expression ')' CR1 execution_part \
elsewhere_part ENDWHERE ",
"elsewhere_part : ",
"elsewhere_part : ELSEWHERE '(' expression ')' CR1 execution_part \
elsewhere_part ",
"elsewhere_part : ELSEWHERE CR1 execution_part ",
"case_construct : SELECTCASE '(' expression ')' CR1 case_list ENDSELECT \
opt_ident ",
"case_list : case_item ",
"case_list : case_item case_list ",
"case_item : CASE case_selector opt_ident CR1 execution_block ",
"case_item : CASE DEFAULT opt_ident CR1 execution_block ",
"case_selector : '(' case_value_range_list ')' ",
"case_value_range_list : case_value_range ",
"case_value_range_list : case_value_range ',' case_value_range_list ",
"case_value_range : expression ",
"case_value_range : expression ':' ",
"case_value_range : ':' expression ",
"case_value_range : expression ':' expression ",
"adp_statement : ATOMIC CR1 atomic_construct ",
"atomic_construct : opt_label assignment_statement ",
"hpf_statement : REALIGN realignee realign_attribute_stuff ",
"hpf_statement : REALIGN realign_attribute_stuff '::' realignee_list ",
"hpf_statement : REDISTRIBUTE redistributee dist_format_clause opt_onto ",
"hpf_statement : REDISTRIBUTE redist_attribute_stuff '::' \
redistributee_list ",
"hpf_statement : simple_on_directive CR1 executable_construct ",
"hpf_statement : simple_on_directive HPF_BEGIN CR1 execution_block \
HPF_END opt_hpf_on ",
"hpf_statement : simple_resident_directive CR1 executable_construct ",
"hpf_statement : simple_resident_directive HPF_BEGIN CR1 execution_block \
HPF_END opt_hpf_resident ",
"hpf_statement : simple_new_directive CR1 executable_construct ",
"hpf_statement : simple_new_directive HPF_BEGIN CR1 execution_block \
HPF_END opt_hpf_new ",
"hpf_statement : simple_reduction_directive CR1 executable_construct ",
"hpf_statement : simple_reduction_directive HPF_BEGIN CR1 \
execution_block HPF_END opt_hpf_reduction ",
"hpf_statement : task_flag TASK_REGION CR1 execution_block HPF_END \
TASK_REGION ",
"realign_attribute_stuff : WITH align_spec ",
"realign_attribute_stuff : '(' align_source_list ')' WITH align_spec ",
"realignee_list : realignee ",
"realignee_list : realignee ',' realignee_list ",
"realignee : HPFIdent ",
"redist_attribute_stuff : dist_format_clause opt_onto ",
"redist_attribute_stuff : dist_onto_clause ",
"redistributee_list : redistributee ",
"redistributee_list : redistributee ',' redistributee_list ",
"redistributee : HPFIdent ",
"simple_on_directive : ON home_expr ",
"simple_on_directive : ON home_expr ',' resident_clause ",
"simple_on_directive : ON home_expr ',' new_clause ",
"simple_on_directive : ON home_expr ',' resident_clause ',' new_clause ",
"home_expr : HOME '(' variable ')' ",
"home_expr : '(' PIdent ')' ",
"home_expr : '(' PIdent '(' section_subscript_list ')' ')' ",
"opt_hpf_on : ",
"opt_hpf_on : ON ",
"simple_resident_directive : resident_clause ",
"opt_hpf_resident : ",
"opt_hpf_resident : RESIDENT ",
"resident_clause : RESIDENT opt_local_var_list ",
"opt_local_var_list : ",
"opt_local_var_list : '(' local_var_list ')' ",
"local_var_list : variable ",
"local_var_list : variable ',' local_var_list ",
"simple_new_directive : new_clause ",
"opt_hpf_new : ",
"opt_hpf_new : NEW ",
"simple_reduction_directive : reduction_clause ",
"opt_hpf_reduction : ",
"opt_hpf_reduction : REDUCTION ",
"task_flag : INDEPENDENT ",
"task_flag : ",
"variable : PIdent ",
"variable : index_var ",
"variable : structure_component ",
"structure_component : variable '%' PIdent ",
"index_var : variable '(' ')' ",
"index_var : variable '(' section_subscript_list ')' ",
"section_subscript_list : Index_Elem ",
"section_subscript_list : Index_Elem ',' section_subscript_list ",
"Index_Elem : expression ",
"Index_Elem : PIdent '=' expression ",
"Index_Elem : Slice ",
"Slice : dumexpression ':' dumexpression ",
"Slice : dumexpression ':' dumexpression ':' dumexpression ",
"Slice : dumexpression '::' dumexpression ",
"dumexpression : ",
"dumexpression : expression ",
"primary : '(' expression ')' ",
"primary : '(' expression ',' impl_do_exp ')' ",
"primary : variable ",
"primary : Konstante ",
"primary : '[' section_subscript_list ']' ",
"primary : PReal '(' expression ')' ",
"impl_do_exp : expression ',' impl_do_exp ",
"impl_do_exp : Laufvariable '=' DoRange ",
"expression : expression defined_binary_op level5_expr ",
"expression : level5_expr ",
"defined_binary_op : UserOp ",
"level5_expr : equiv_operand ",
"level5_expr : level5_expr equiv_op equiv_operand ",
"equiv_op : EQV ",
"equiv_op : NEQV ",
"equiv_operand : or_operand ",
"equiv_operand : equiv_operand or_op or_operand ",
"or_op : OR ",
"or_op : XOR ",
"or_operand : and_operand ",
"or_operand : or_operand and_op and_operand ",
"and_op : AND ",
"and_operand : level4_expr ",
"and_operand : not_op level4_expr ",
"not_op : NOT ",
"level4_expr : level3_expr ",
"level4_expr : level3_expr rel_op level3_expr ",
"rel_op : '==' ",
"rel_op : '<=' ",
"rel_op : '>=' ",
"rel_op : '<>' ",
"rel_op : '<' ",
"rel_op : '>' ",
"level3_expr : level2_expr ",
"level3_expr : level3_expr concat_op level2_expr ",
"concat_op : '//' ",
"level2_expr : add_operand ",
"level2_expr : level2_expr add_op signed_add_operand ",
"level2_expr : '+' add_operand ",
"level2_expr : '-' add_operand ",
"add_op : '+' ",
"add_op : '-' ",
"signed_add_operand : add_operand ",
"signed_add_operand : '-' add_operand ",
"add_operand : mult_operand ",
"add_operand : add_operand mult_op mult_operand ",
"mult_op : '*' ",
"mult_op : '/' ",
"mult_operand : level1_expr ",
"mult_operand : level1_expr power_op mult_operand ",
"power_op : '**' ",
"level1_expr : defined_unary_op primary ",
"level1_expr : primary ",
"defined_unary_op : UserOp ",
"PReal : REAL ",
"Konstante : IntConst ",
"Konstante : RealKonstante ",
"Konstante : '(' expression ',' expression ')' ",
"Konstante : StringConst ",
"Konstante : TRUE ",
"Konstante : FALSE ",
"RealKonstante : IntConst '.' ",
"RealKonstante : RealConst ",
"RealKonstante : DRealConst ",
"SignedKonstante : Konstante ",
"SignedKonstante : '+' Konstante ",
"SignedKonstante : '-' IntConst ",
"SignedKonstante : '-' RealKonstante ",
""
};
# endif
	char *		TokenName	[yyLastTerminal + 2] = {
"_EOF_",
"Ident",
"IntConst",
"RealConst",
"DRealConst",
"StringConst",
0,
"UserOp",
0,
0,
"=",
"//",
"=>",
"(",
")",
"+",
"-",
"*",
"/",
"**",
":",
",",
0,
"[",
"]",
0,
0,
"::",
".",
"%",
"<>",
"==",
">",
">=",
"<",
"<=",
"AND",
"OR",
0,
"EQV",
"NEQV",
"TRUE",
"FALSE",
"NOT",
"XOR",
"BLOCKDATA",
"DATA",
0,
"INTRINSIC",
0,
"INTEGER",
"REAL",
"COMPLEX",
"LOGICAL",
"CHARACTER",
"DOUBLE_PRECISION",
"DOUBLE_COMPLEX",
"SAVE",
"IMPLICIT",
"EXTERNAL",
"PARAMETER",
"DIMENSION",
"COMMON",
"EQUIVALENCE",
"PROGRAM",
"RECURSIVE",
"SUBROUTINE",
"FUNCTION",
"END",
"DO",
"WHILE",
"IF",
"THEN",
"ELSE",
"ELSEIF",
"ENDDO",
"ENDIF",
"RESULT",
"ASSIGN",
"TO",
"CALL",
"CONTINUE",
"STOP",
"RETURN",
0,
"FORMAT",
"FORMAT_ARG",
"GOTO",
"ENTRY",
0,
"READ",
"WRITE",
"PRINT",
"OPEN",
"CLOSE",
"INQUIRE",
"BACKSPACE",
"ENDFILE",
"REWIND",
0,
"ALLOCATE",
"DEALLOCATE",
"WHERE",
"ENDWHERE",
"ELSEWHERE",
"SELECTCASE",
"CASE",
"DEFAULT",
0,
"FORALL",
"INTENT",
"IN",
"OUT",
"INOUT",
"ENDFORALL",
"CYCLE",
"EXIT",
0,
0,
0,
0,
0,
0,
0,
0,
"PROCEDURE",
"OPERATOR",
"ASSIGNMENT",
0,
0,
"TYPE",
"ENDTYPE",
"INTERFACE",
"ENDINTERFACE",
"MODULE",
0,
"CONTAINS",
"USE",
"ONLY",
0,
"ALLOCATABLE",
"OPTIONAL",
"POINTER",
"TARGET",
"PUBLIC",
"PRIVATE",
"NULLIFY",
"NAMELIST",
"SEQUENCE",
0,
0,
"ALIGN",
"WITH",
"REALIGN",
"DISTRIBUTE",
"REDISTRIBUTE",
"PROCESSORS",
"TEMPLATE",
"DYNAMIC",
"ONTO",
"BLOCK",
"CYCLIC",
"NOSEQUENCE",
"HPFSEQUENCE",
"INDEPENDENT",
"RESIDENT",
"ON",
"NEW",
"REDUCTION",
"INHERIT",
"HOME",
0,
0,
0,
0,
0,
0,
0,
0,
0,
"PURE",
"EXTRINSIC",
0,
0,
0,
0,
0,
0,
0,
0,
0,
"DIMENSION1",
"PARAMETER1",
"INTENT1",
"EXTERNAL1",
"INTRINSIC1",
"OPTIONAL1",
"POINTER1",
"SAVE1",
"TARGET1",
"DATA1",
"PUBLIC1",
"PRIVATE1",
"ALLOCATABLE1",
"ARRAY1",
"ENDSELECT",
"SEQUENCE1",
0,
"GEN_BLOCK",
"INDIRECT",
"HPF_BEGIN",
"HPF_END",
"TASK_REGION",
0,
"RANGE",
"ALL",
"LAYOUT",
"PASS_BY",
"MAP_TO",
"ARBITRARY",
0,
"SHADOW",
0,
0,
0,
"TRACE",
"TREE",
0,
0,
0,
0,
0,
0,
0,
0,
"NODESCRIPTOR",
"ATOMIC",
0,
0,
0,
"LAYOUT1",
"PASS_BY1",
"MAP_TO1",
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
"NewLine",
""
};
static	yytComb		yyTComb		[yyTTableMax + 1] = {
{   3, 1009}, {   1, 1012}, {  22, 1012}, {  16, 1045}, {  45,  898}, 
{ 663,  946}, {  86,  861}, { 619, 1720}, { 783,  946}, { 217,  946}, 
{ 619, 1639}, { 619, 1720}, { 217,  959}, { 619, 1720}, { 330,  507}, 
{ 619, 1720}, { 619, 1720}, { 619, 1720}, { 619, 1720}, { 619, 1720}, 
{ 290,  471}, { 619, 1720}, { 330, 1447}, { 134, 1114}, { 217,  958}, 
{ 582,  680}, { 582,  968}, { 134,   86}, { 330, 1447}, { 619, 1720}, 
{ 619, 1720}, { 619, 1720}, { 619, 1720}, { 619, 1720}, { 619, 1720}, 
{ 619, 1720}, { 619, 1720}, { 619, 1720}, { 665,  946}, { 619, 1720}, 
{ 619, 1720}, { 755,  772}, { 579,  844}, { 413,  162}, { 619, 1720}, 
{   1, 1012}, {   1, 1012}, { 413,  161}, {   1, 1012}, { 209,  946}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{ 564, 1569}, {   1, 1012}, { 473,  624}, { 473, 1007}, { 473, 1008}, 
{ 471,  623}, { 471, 1791}, { 564, 1569}, {   1, 1012}, { 471, 1791}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, { 423,  593}, 
{   1, 1012}, { 752,  946}, {   1, 1012}, {   1, 1012}, { 256,  441}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, { 256, 1720}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, { 256, 1720}, { 133, 1118}, 
{   1, 1012}, { 256, 1720}, { 260, 1728}, { 133,   29}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, { 260, 1728}, 
{   1, 1012}, {   1, 1012}, { 260, 1728}, { 423,  228}, { 603, 1507}, 
{ 603, 1507}, { 603, 1507}, { 603, 1507}, { 296,  858}, { 296,  857}, 
{ 296,  859}, { 296,  860}, { 296,  133}, { 296,  862}, { 296,  863}, 
{   1, 1012}, { 480, 1246}, {   1, 1012}, { 480,  628}, {   1, 1012}, 
{ 755,  773}, {   1, 1012}, {   1, 1012}, { 480, 1246}, { 727, 1042}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, { 149,  916}, { 149,  917}, 
{ 149,  918}, {   1, 1012}, { 603, 1507}, {   1, 1012}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, { 247,  434}, 
{ 603, 1507}, { 247,  435}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{ 360, 1415}, { 623,   95}, { 623, 1007}, { 623, 1008}, { 623, 1003}, 
{ 391, 1038}, { 360, 1415}, { 360, 1415}, { 727, 1042}, { 542,  657}, 
{   1, 1012}, {   1, 1012}, { 623,  474}, { 391,  844}, { 623,  472}, 
{ 623,  473}, { 579, 1038}, { 579, 1038}, { 579, 1038}, { 579, 1038}, 
{ 542, 1177}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, {   1, 1012}, 
{  93, 1142}, {   1, 1012}, { 727, 1507}, { 382, 1175}, { 780,  946}, 
{ 623, 1004}, { 623, 1005}, {   1, 1012}, { 560,  946}, {   1, 1012}, 
{ 382,  541}, {   1, 1012}, {   1, 1012}, {   1, 1012}, { 382, 1175}, 
{ 240, 1720}, {   1, 1012}, { 240, 1720}, { 240, 1720}, { 419,  584}, 
{   1, 1012}, {   1, 1012}, { 475,  626}, { 475, 1326}, { 161,  333}, 
{ 240,  423}, { 475, 1326}, { 269,   96}, { 269,   97}, { 187,  368}, 
{   1, 1012}, {   1, 1012}, { 161, 1468}, { 608, 1731}, { 240, 1720}, 
{   1, 1012}, {   1, 1012}, {   1, 1012}, { 161, 1468}, { 608,  693}, 
{ 608, 1731}, { 342,  517}, { 390,  946}, { 608, 1731}, { 595, 1042}, 
{  93, 1042}, { 603, 1507}, {  93, 1042}, { 176, 1434}, { 342, 1464}, 
{   1,    2}, { 330, 1447}, { 603, 1507}, {  93,    6}, { 176, 1434}, 
{ 342, 1464}, {  93, 1042}, {  93, 1042}, {  93, 1042}, {  93, 1042}, 
{  93, 1042}, {  93, 1042}, {  93, 1042}, {  20,   83}, {  20,   84}, 
{ 379,  538}, { 624, 1802}, {  93, 1142}, {  93, 1142}, { 624, 1802}, 
{  93, 1142}, { 579, 1624}, {  27, 1012}, {  27, 1012}, {  27, 1012}, 
{  27, 1012}, { 624, 1006}, {  93, 1142}, { 607, 1729}, {  93, 1142}, 
{  93, 1142}, {  93, 1142}, {  93, 1142}, { 595, 1042}, {  93, 1042}, 
{ 607, 1729}, {  93, 1142}, {  93, 1142}, { 607, 1729}, {  93, 1142}, 
{  93, 1142}, {  93, 1142}, {  93, 1142}, {  93, 1142}, {  93, 1142}, 
{  93, 1142}, {  93, 1142}, {  93, 1142}, { 729,  842}, {  93, 1142}, 
{  93, 1142}, {  93, 1142}, {  27, 1012}, {  27, 1012}, {  93, 1142}, 
{  27, 1012}, { 564, 1569}, {  62,  842}, {  93, 1142}, {  93, 1042}, 
{  93, 1142}, {  93, 1142}, {  93, 1142}, {  27, 1012}, {  93, 1142}, 
{  93, 1142}, { 648,  981}, { 819,  795}, { 819,  796}, { 187,  369}, 
{ 819, 1650}, { 789, 1666}, { 187,  370}, { 648,  931}, { 187,  944}, 
{ 187,  943}, { 187,  941}, { 789,  801}, { 789, 1666}, {  93,    9}, 
{  27, 1012}, {  93,   10}, {  27, 1012}, {  34,  891}, {  34,  892}, 
{  93, 1142}, {  93,   12}, { 187,  942}, {  34,  893}, {  93, 1042}, 
{  93, 1042}, {  93, 1042}, {  93, 1042}, {  93, 1042}, {  93, 1042}, 
{  93, 1142}, {  93, 1042}, {  27, 1012}, { 472,   95}, {  29,  872}, 
{  93, 1042}, { 472, 1003}, {  93, 1142}, {  93, 1042}, {  93, 1142}, 
{  93, 1042}, {  93, 1042}, {  93, 1042}, { 213,  946}, { 472,  474}, 
{  29,   94}, {  93, 1042}, {  93, 1042}, {  93, 1142}, {  93, 1142}, 
{  93, 1142}, {  93, 1142}, {  93, 1142}, {  93, 1042}, { 213,  390}, 
{ 161, 1468}, { 561,  669}, {  87,  198}, {  87,  876}, {  87,  199}, 
{  87,  881}, {  87,  882}, {  87,  883}, {  87,  887}, {  87,  888}, 
{  87,  889}, {  87,  890}, { 187,  371}, { 326, 1038}, {  87,  877}, 
{  87,  200}, { 326,  502}, { 472, 1004}, { 472, 1005}, { 187,  372}, 
{  93, 1142}, {  93, 1142}, {  93, 1142}, {  93, 1142}, {  93, 1142}, 
{  93, 1142}, {  93, 1142}, {  93, 1142}, {  93, 1142}, {  93, 1142}, 
{  93, 1142}, {  93, 1142}, {  93, 1142}, {  93, 1142}, {  27, 1012}, 
{  93, 1142}, {   6, 1118}, { 776, 1640}, { 419, 1695}, { 595, 1507}, 
{  27, 1012}, {  93, 1142}, { 391, 1542}, {  93, 1042}, { 776,  792}, 
{  93, 1042}, {  93, 1042}, {  93, 1042}, {   6,   30}, { 542, 1177}, 
{  93, 1042}, {  87,  201}, {  87,  202}, {  87,  203}, {  93, 1042}, 
{  93, 1042}, {   6, 1118}, { 411, 1459}, { 235,  416}, { 682,  732}, 
{ 449, 1748}, { 723, 1568}, {   6, 1118}, { 631,  981}, {  93, 1042}, 
{  93, 1142}, { 235, 1708}, { 449, 1748}, { 723, 1568}, {  93, 1142}, 
{  93, 1142}, {  93, 1142}, { 205, 1173}, { 449, 1748}, { 449, 1748}, 
{ 305, 1136}, { 631,  867}, { 449, 1748}, { 382, 1175}, { 205, 1173}, 
{ 449, 1748}, { 305,  489}, { 305, 1136}, { 419, 1695}, { 651,  981}, 
{   6, 1118}, {   6, 1118}, {   6, 1118}, {   6, 1118}, {   6, 1118}, 
{   6, 1118}, {   6, 1118}, { 449, 1748}, { 449, 1748}, { 729,  843}, 
{ 782,  716}, { 161, 1468}, {  33,    6}, { 651,  709}, { 236,  417}, 
{   6, 1118}, {   6, 1118}, {   6, 1118}, {  62,  843}, { 782,  210}, 
{ 782,  948}, { 782,  211}, { 782,  212}, {  33,    8}, {  33, 1074}, 
{  33, 1074}, { 782,  213}, { 176, 1434}, { 342, 1464}, { 782,  215}, 
{ 782,  216}, { 782,  217}, { 782,  218}, { 782,  219}, { 782,  220}, 
{ 782,  221}, { 782,  222}, { 782,  223}, { 380,  539}, { 782,  224}, 
{ 782,  225}, { 782,  718}, { 378,  537}, { 359, 1413}, { 587, 1720}, 
{ 587, 1635}, { 818, 1507}, { 818, 1507}, {  23, 1114}, { 359,  526}, 
{ 359, 1413}, { 618,  697}, { 587, 1635}, { 543, 1042}, { 782,  230}, 
{ 782,  231}, { 112,   95}, { 112, 1007}, { 112, 1008}, { 112, 1003}, 
{ 587, 1720}, {   6, 1118}, {   6, 1118}, {   6, 1118}, {  23,   86}, 
{  59, 1040}, {  59, 1040}, { 112,   99}, {  23, 1114}, { 664, 1038}, 
{ 664, 1038}, { 664, 1038}, { 664, 1038}, { 664, 1038}, {  23, 1114}, 
{ 664, 1038}, { 285,  847}, { 112,  100}, { 591, 1722}, { 591, 1636}, 
{   6, 1118}, { 664, 1038}, { 543, 1507}, { 664, 1038}, { 664, 1038}, 
{ 782,  226}, { 591, 1636}, { 341, 1463}, {  33,   32}, { 664,  844}, 
{ 590,  262}, { 664, 1038}, { 543, 1042}, { 341, 1463}, { 591, 1722}, 
{ 112, 1004}, { 112, 1005}, {  23, 1114}, {  23, 1114}, {  23, 1114}, 
{  23, 1114}, {  23, 1114}, {  23, 1114}, {  23, 1114}, { 411,  163}, 
{ 112, 1001}, { 590,  263}, { 335,  511}, { 335, 1474}, { 664, 1038}, 
{ 664, 1038}, { 664, 1038}, {  23, 1114}, {  23, 1114}, {  23, 1114}, 
{ 335, 1474}, { 334,  510}, { 334, 1471}, { 407,  923}, { 664, 1038}, 
{ 287,  848}, { 407,  922}, { 258, 1726}, { 222,  954}, { 334, 1471}, 
{ 235, 1708}, { 235, 1708}, { 235, 1708}, { 235, 1708}, { 258,  442}, 
{   6, 1118}, {   6, 1118}, { 258, 1726}, { 477, 1324}, { 222,  393}, 
{ 177,  354}, { 477,  627}, { 309, 1220}, {  33,   13}, {  33,   14}, 
{ 309, 1220}, {   6, 1118}, {   6, 1118}, {   6, 1118}, {   6, 1118}, 
{   6, 1118}, {   6, 1118}, {   6, 1118}, {   6, 1118}, {   6, 1118}, 
{   6, 1118}, {   6, 1118}, {   6, 1118}, {   6, 1118}, {   6, 1118}, 
{ 448, 1744}, {   6, 1118}, { 693, 1734}, {  23, 1114}, {  23, 1114}, 
{  23, 1114}, { 561, 1720}, { 448, 1744}, { 682, 1696}, { 693, 1734}, 
{ 326, 1276}, { 811, 1042}, { 693, 1734}, { 448, 1744}, { 448, 1744}, 
{ 235, 1708}, { 236,  418}, { 448, 1744}, { 130, 1318}, { 499,  915}, 
{ 448, 1744}, { 130,  291}, {  23, 1114}, { 499,  994}, { 664, 1038}, 
{ 664, 1038}, { 664, 1038}, { 499,  995}, { 499,  996}, { 499,  997}, 
{ 499,  998}, { 499,  999}, { 448,  982}, { 448,  983}, {  65, 1493}, 
{   6, 1118}, {   6, 1118}, {   6, 1118}, { 776, 1640}, {  59, 1256}, 
{  65, 1493}, { 811, 1507}, { 499,  991}, { 499,  988}, { 499,  993}, 
{ 499,  990}, { 499,  992}, { 499,  989}, { 499,  986}, { 499,  984}, 
{ 811, 1042}, { 499,  982}, { 499,  983}, { 682, 1696}, { 489, 1132}, 
{ 499,  987}, { 499,  985}, { 126, 1081}, { 552,  666}, { 366,  381}, 
{ 235, 1708}, { 489, 1132}, { 723, 1568}, {  15,   43}, { 126,  287}, 
{  15,   47}, { 179,  356}, { 366, 1173}, { 449, 1748}, { 552, 1720}, 
{ 754, 1655}, { 754,  770}, {  23, 1114}, {  23, 1114}, {  15,   44}, 
{  15,   45}, {  15,   46}, {  15,   48}, {  15,   49}, {  15,   50}, 
{  15,   51}, { 697,  322}, { 697,  323}, {  23, 1114}, {  23, 1114}, 
{  23, 1114}, {  23, 1114}, {  23, 1114}, {  23, 1114}, {  23, 1114}, 
{  23, 1114}, {  23, 1114}, {  23, 1114}, {  23, 1114}, {  23, 1114}, 
{  23, 1114}, {  23, 1114}, { 204,   87}, {  23, 1114}, { 224,  399}, 
{  10,   37}, {  10,   38}, {  15,   52}, { 204, 1187}, { 664, 1038}, 
{ 664, 1038}, { 664, 1038}, { 664, 1038}, { 664, 1038}, { 664, 1038}, 
{ 664, 1038}, { 664, 1038}, { 664, 1038}, { 664, 1038}, { 664, 1038}, 
{ 664, 1038}, { 664, 1038}, { 664, 1038}, { 160,  331}, { 664, 1038}, 
{  24,  858}, {  24,  857}, {  24,  859}, {  24,  860}, {  24,    6}, 
{  24,  862}, {  24,  863}, {  15,   53}, { 279, 1356}, { 279,  461}, 
{ 618, 1234}, { 104, 1745}, {  23, 1114}, {  23, 1114}, {  23, 1114}, 
{  24,    8}, {  24, 1074}, {  24, 1074}, { 104, 1745}, { 563, 1566}, 
{ 810, 1669}, { 121, 1352}, { 121, 1352}, { 225,  401}, { 104, 1745}, 
{ 104, 1745}, { 563,  670}, { 810, 1669}, { 104, 1745}, { 207, 1637}, 
{ 207,  962}, { 104, 1745}, { 232,  407}, { 664, 1038}, { 664, 1038}, 
{ 664, 1038}, { 788, 1664}, {  15,   54}, {  15,   55}, {  15,   56}, 
{  15,   57}, {  15,   58}, {  15,   59}, { 788,  800}, {  15,   60}, 
{ 178,  355}, { 341, 1463}, { 384, 1038}, {  15,   61}, { 207, 1637}, 
{ 426, 1042}, {  15,   62}, { 426, 1042}, {  15,   63}, {  15,   64}, 
{  15,   65}, { 453, 1000}, {  91, 1100}, { 255,  977}, {  15,   66}, 
{  15,   67}, { 426, 1042}, { 426, 1042}, { 426, 1042}, { 426, 1042}, 
{ 255,  440}, {  15,   68}, { 384,  844}, { 426, 1042}, { 426, 1042}, 
{  25, 1505}, { 426, 1042}, { 426, 1042}, { 426, 1042}, { 426, 1042}, 
{ 426, 1042}, { 426, 1042}, { 426, 1042}, { 426, 1042}, { 426, 1042}, 
{  24,   32}, { 426, 1042}, { 426, 1042}, { 426, 1042}, { 722, 1603}, 
{ 250, 1042}, { 426, 1042}, {  78,  187}, { 601,  981}, { 131, 1320}, 
{ 426, 1042}, { 722, 1603}, { 131, 1320}, {  78, 1489}, { 803, 1042}, 
{ 609, 1735}, { 426, 1042}, { 426, 1042}, { 207, 1637}, { 309, 1220}, 
{  50, 1228}, { 609, 1735}, { 609, 1735}, { 712, 1178}, { 414,  576}, 
{ 609, 1735}, { 414,  238}, { 250, 1507}, { 609, 1735}, {  10, 1362}, 
{  50,  897}, {  15,   69}, { 555, 1602}, {  15,   70}, {  15,   71}, 
{  15,   72}, { 384, 1038}, {  50,  143}, {  15,   73}, { 555, 1602}, 
{  68, 1494}, {  44, 1040}, {  15,   74}, {  15,   75}, { 250, 1042}, 
{  91,  248}, {  68, 1494}, { 426, 1042}, { 448, 1744}, { 515,  939}, 
{  24,   13}, {  24,   14}, {  15,   76}, { 803, 1042}, { 426, 1042}, 
{ 705,  744}, { 426, 1042}, { 160,  332}, {  25, 1505}, { 207, 1637}, 
{ 207, 1637}, { 207, 1637}, { 250, 1507}, { 250, 1507}, {   4,    5}, 
{ 426, 1042}, { 426, 1042}, { 426, 1042}, { 426, 1042}, { 426, 1042}, 
{  63, 1496}, { 241,  207}, {   9, 1339}, { 581, 1710}, { 803, 1507}, 
{ 586, 1630}, {  63, 1496}, { 384, 1038}, { 384, 1038}, { 384, 1038}, 
{ 581,  679}, { 630, 1335}, { 586,  683}, {   4,    7}, {   4,    8}, 
{   4, 1074}, {   4, 1074}, { 801, 1667}, { 630, 1335}, {  79,  188}, 
{ 554, 1600}, { 232,  408}, {   9,   34}, {  82,  192}, { 801, 1667}, 
{ 250, 1507}, { 101, 1720}, { 554,  667}, {   9,  910}, { 101,  261}, 
{ 101, 1720}, { 366, 1173}, { 101, 1720}, { 101, 1720}, { 101, 1720}, 
{ 101, 1720}, { 101, 1720}, { 101, 1720}, { 101, 1720}, { 482, 1244}, 
{ 637, 1216}, { 241,  229}, { 224,  400}, { 426, 1042}, { 369,  158}, 
{ 594,  207}, { 482,  629}, { 637,  703}, { 101, 1720}, { 101, 1720}, 
{ 101, 1720}, { 101, 1720}, { 101, 1720}, { 101, 1720}, { 101, 1720}, 
{ 101, 1720}, { 101, 1720}, { 589, 1633}, { 101, 1720}, { 101, 1720}, 
{  50, 1228}, {  50, 1228}, {  50, 1228}, { 101, 1720}, { 589,  684}, 
{ 804, 1641}, { 438,   43}, { 426, 1042}, { 570,  673}, { 207, 1637}, 
{ 207, 1637}, { 207, 1637}, { 207, 1637}, { 207, 1637}, { 207, 1637}, 
{ 207, 1637}, { 207, 1637}, { 207, 1637}, { 207, 1637}, { 207, 1637}, 
{ 207, 1637}, { 207, 1637}, { 207, 1637}, {   4,   11}, { 207, 1637}, 
{ 594,  229}, { 225,  402}, { 384, 1038}, { 384, 1038}, { 384, 1038}, 
{ 384, 1038}, { 384, 1038}, { 384, 1038}, { 384, 1038}, { 384, 1038}, 
{ 384, 1038}, { 384, 1038}, { 384, 1038}, { 384, 1038}, { 384, 1038}, 
{ 384, 1038}, { 304, 1134}, { 384, 1038}, { 803, 1507}, { 303, 1129}, 
{ 438,   52}, { 410,  407}, {  61,  158}, { 304,  488}, { 104, 1745}, 
{ 275, 1095}, { 303,  487}, {   9, 1339}, {   9, 1339}, {   9, 1339}, 
{  31,  114}, {  81,  190}, { 275,  456}, { 207, 1637}, { 207, 1637}, 
{ 207, 1637}, { 301, 1333}, { 515,  334}, { 515,  335}, { 358, 1410}, 
{ 799, 1668}, { 617, 1262}, { 328, 1440}, { 301,  486}, {   4,   13}, 
{   4,   14}, { 358,  525}, { 799, 1668}, { 207, 1637}, { 328,  505}, 
{ 737,  974}, { 384, 1038}, { 384, 1038}, { 384, 1038}, { 736,  973}, 
{  50, 1228}, {  50, 1228}, {  50, 1228}, {  50, 1228}, {  50, 1228}, 
{  50, 1228}, {  50, 1228}, {  50, 1228}, {  50, 1228}, {  50, 1228}, 
{  50, 1228}, {  50, 1228}, {  50, 1228}, {  50, 1228}, { 633, 1137}, 
{  50, 1228}, { 645, 1449}, { 340, 1469}, { 726,  674}, { 548, 1544}, 
{ 673, 1734}, { 633, 1137}, {  64, 1495}, { 645,  707}, { 340,  515}, 
{ 726,  758}, { 548,  663}, { 673, 1734}, {  64, 1495}, { 259,  443}, 
{ 515,  336}, { 515,  337}, { 734,  970}, { 310,  491}, { 696,  741}, 
{ 557, 1612}, { 259,  444}, { 515,  940}, {  41,  123}, {  85,  196}, 
{ 575,  163}, { 515,  338}, { 469,  285}, { 369,  159}, { 735,  971}, 
{ 374,  532}, { 601, 1547}, { 712, 1178}, { 281,  464}, {  50, 1228}, 
{  50, 1228}, {  50, 1228}, {   9, 1339}, {   9, 1339}, {   9, 1339}, 
{   9, 1339}, {   9, 1339}, {   9, 1339}, {   9, 1339}, {   9, 1339}, 
{   9, 1339}, {   9, 1339}, {   9, 1339}, {   9, 1339}, {   9, 1339}, 
{   9, 1339}, { 387,  547}, {   9, 1339}, {  44, 1281}, { 710,  746}, 
{  79, 1057}, {  82, 1070}, { 276, 1347}, { 276, 1347}, { 276, 1347}, 
{ 276, 1347}, { 276, 1347}, { 276, 1347}, { 276, 1347}, { 705, 1381}, 
{ 320, 1307}, { 677,  730}, { 737, 1716}, { 276, 1347}, { 500,  640}, 
{ 422, 1042}, { 676,  729}, { 736, 1713}, { 604,  691}, { 168, 1399}, 
{ 660,  715}, { 569, 1639}, { 622,  699}, { 166, 1404}, { 484,  296}, 
{ 293,  479}, { 348,  519}, { 556,  668}, { 120,  278}, { 299,  485}, 
{ 111, 1784}, {   9, 1339}, {   9, 1339}, {   9, 1339}, { 111, 1784}, 
{ 410,  408}, {  61,  159}, { 111, 1784}, { 111, 1784}, { 111, 1784}, 
{ 111, 1784}, { 111, 1784}, { 111,  999}, { 111, 1784}, { 111, 1784}, 
{ 283,  467}, { 338,  514}, { 111, 1784}, { 367,  531}, { 365,  530}, 
{ 111, 1784}, { 734, 1702}, { 182,  362}, { 111, 1784}, { 111, 1784}, 
{ 111, 1784}, { 111, 1784}, { 111, 1784}, { 111, 1784}, { 111, 1784}, 
{ 111, 1784}, { 102, 1738}, { 111, 1784}, { 111, 1784}, { 735, 1705}, 
{ 102, 1738}, { 575, 1459}, { 111, 1784}, { 102, 1738}, { 102, 1738}, 
{ 102, 1738}, { 102, 1738}, { 102, 1738}, { 102, 1738}, { 102, 1738}, 
{ 102, 1738}, { 337,  513}, { 336,  512}, { 102, 1738}, { 202,  379}, 
{ 201,  378}, { 102, 1738}, { 276, 1347}, { 276, 1347}, { 102, 1738}, 
{ 102, 1738}, { 102, 1738}, { 102, 1738}, { 102, 1738}, { 102, 1738}, 
{ 102, 1738}, { 102, 1738}, { 422, 1042}, { 102, 1738}, { 102, 1738}, 
{  81, 1066}, { 804, 1641}, { 276,  457}, { 102, 1738}, { 281, 1061}, 
{ 276,  458}, { 200,  377}, { 227,  404}, { 276, 1347}, { 228,  405}, 
{ 203,  380}, { 276, 1347}, { 181,  361}, { 276, 1347}, { 276, 1347}, 
{ 276, 1347}, {  51,  146}, { 229,  406}, { 135,  294}, {  48,  140}, 
{  38,  120}, { 323,  500}, {  37,  119}, { 770,  784}, {  32,   35}, 
{  80, 1184}, { 276, 1347}, { 350,  521}, { 322,  499}, { 206,  383}, 
{ 422, 1042}, { 422, 1042}, { 422, 1042}, { 136,  295}, { 716,  749}, 
{ 718,  751}, { 254, 1775}, { 364,  529}, { 318, 1312}, { 324,  501}, 
{ 254, 1775}, { 524, 1040}, { 170,  346}, { 254, 1775}, { 254, 1775}, 
{ 254, 1775}, { 254,  997}, { 254,  998}, { 289,  127}, { 254, 1775}, 
{ 254, 1775}, {  80,  874}, {  31, 1092}, { 254, 1775}, { 363,  528}, 
{ 617, 1262}, { 254, 1775}, { 128, 1038}, { 374, 1072}, { 254, 1775}, 
{ 254, 1775}, { 254, 1775}, { 254, 1775}, { 254, 1775}, { 254, 1775}, 
{ 254, 1775}, { 254, 1775}, { 524,  845}, { 254, 1775}, { 254, 1775}, 
{ 226,  403}, { 276, 1347}, { 317,  496}, { 254, 1775}, {  53,  149}, 
{ 198,  375}, { 173,  351}, {  73,  180}, { 276, 1347}, { 319,  497}, 
{ 395,  558}, {  69,  174}, { 276, 1347}, { 276, 1347}, {  85, 1091}, 
{ 237,  420}, { 593,  685}, {  72,  179}, { 113,  273}, { 238,  421}, 
{ 215,  393}, { 532,  656}, { 276, 1347}, { 418,  583}, { 313,  146}, 
{ 321,  498}, { 147,  313}, { 315, 1302}, { 220,  393}, { 397,  559}, 
{ 316,  495}, { 167,  344}, { 310, 1222}, { 696, 1359}, { 557, 1612}, 
{ 307,  490}, { 139,  298}, {  41, 1231}, { 138,  297}, { 169,  345}, 
{ 422, 1042}, { 422, 1042}, { 422, 1042}, { 422, 1042}, { 422, 1042}, 
{ 422, 1042}, { 422, 1042}, { 422, 1042}, { 422, 1042}, { 422, 1042}, 
{ 422, 1042}, { 422, 1042}, { 422, 1042}, { 422, 1042}, { 175,  174}, 
{ 422, 1042}, { 372,  180}, { 371,  174}, { 796,  807}, {  14,   42}, 
{ 368,  141}, { 659,  714}, { 208,  385}, { 219,  393}, { 550,  665}, 
{  80, 1184}, {  80, 1184}, {  80, 1184}, { 710, 1272}, {  49,  141}, 
{ 218,  393}, { 199,  376}, {  70,  177}, { 387, 1563}, {  71,  178}, 
{ 306,  141}, { 216,  393}, { 647,  929}, { 549,  664}, { 320, 1307}, 
{ 677, 1692}, { 524, 1040}, { 524, 1040}, { 524, 1040}, { 445,  856}, 
{ 676, 1687}, { 652,  926}, { 655,  820}, { 168, 1399}, { 422, 1042}, 
{ 422, 1042}, { 422, 1042}, { 166, 1404}, { 484, 1240}, { 293, 1283}, 
{ 348, 1295}, { 556, 1610}, { 128, 1038}, { 128, 1038}, { 128, 1038}, 
{ 114,  849}, { 302,  865}, {  95, 1791}, { 252, 1182}, { 447,  976}, 
{ 644,  924}, {  95, 1791}, { 300,  909}, { 274,  850}, {  95, 1791}, 
{  95, 1791}, {  95, 1791}, {  95, 1791}, { 111, 1784}, {  95, 1791}, 
{  95, 1791}, { 733,  761}, { 367, 1486}, { 365, 1425}, {  95, 1791}, 
{ 510,  930}, { 182, 1407}, {  95, 1791}, { 251,  871}, { 357,  945}, 
{  95, 1791}, {  95, 1791}, {  95, 1791}, {  95, 1791}, {  95, 1791}, 
{  95, 1791}, {  95, 1791}, {  95, 1791}, { 540,  870}, {  95, 1791}, 
{  95, 1791}, { 356,  524}, { 539,  886}, { 538,  885}, {  95, 1791}, 
{ 355,  523}, { 537,  884}, { 354,  522}, { 562,  949}, { 102, 1738}, 
{  80, 1184}, {  80, 1184}, {  80, 1184}, {  80, 1184}, {  80, 1184}, 
{  80, 1184}, {  80, 1184}, {  80, 1184}, {  80, 1184}, {  80, 1184}, 
{  80, 1184}, {  80, 1184}, {  80, 1184}, {  80, 1184}, { 536,  879}, 
{  80, 1184}, { 524, 1040}, { 524, 1040}, { 524, 1040}, { 524, 1040}, 
{ 524, 1040}, { 524, 1040}, { 524, 1040}, { 524, 1040}, { 524, 1040}, 
{ 524, 1040}, { 524, 1040}, { 524, 1040}, { 524, 1040}, { 524, 1040}, 
{ 742, 1002}, { 524, 1040}, { 128, 1038}, { 128, 1038}, { 128, 1038}, 
{ 128, 1038}, { 128, 1038}, { 128, 1038}, { 128, 1038}, { 128, 1038}, 
{ 128, 1038}, { 128, 1038}, { 128, 1038}, { 128, 1038}, { 128, 1038}, 
{ 128, 1038}, { 350, 1289}, { 128, 1038}, { 206, 1170}, {  80, 1184}, 
{  80, 1184}, {  80, 1184}, { 655,  821}, { 655,  822}, { 655,  823}, 
{ 640,  902}, { 364, 1421}, { 318, 1312}, { 324, 1260}, { 535,  880}, 
{ 339,  927}, { 170, 1454}, { 565,  950}, { 352,  921}, { 639,  901}, 
{ 524, 1040}, { 524, 1040}, { 524, 1040}, { 787,  965}, { 254, 1775}, 
{ 534,  878}, { 545,  661}, { 747,  764}, { 363, 1417}, { 621,  908}, 
{ 527,  919}, { 605,  978}, {  98,  855}, { 314,  494}, { 566,  951}, 
{ 610, 1779}, { 128, 1038}, { 128, 1038}, { 128, 1038}, { 610, 1779}, 
{ 553,  955}, { 509,  928}, { 610, 1779}, { 610, 1779}, { 610, 1779}, 
{ 446,  854}, { 317, 1266}, { 760,  969}, { 610, 1779}, { 610, 1779}, 
{ 173, 1429}, { 128, 1315}, { 610, 1779}, { 319, 1310}, { 395, 1584}, 
{ 610, 1779}, { 327,  504}, { 681,  967}, { 610, 1779}, { 610, 1779}, 
{ 610, 1779}, { 610, 1779}, { 610, 1779}, { 610, 1779}, { 610, 1779}, 
{ 610, 1779}, { 571,  674}, { 610, 1779}, { 610, 1779}, { 321, 1305}, 
{ 147, 1213}, { 315, 1302}, { 610, 1779}, { 397, 1582}, { 316, 1300}, 
{ 167, 1402}, { 508,  646}, { 588,  961}, { 568,  672}, { 307, 1209}, 
{ 139, 1253}, { 103,  853}, { 138, 1249}, { 169, 1397}, { 511,  932}, 
{ 585,  960}, { 731,  760}, { 655,  825}, { 655,  826}, { 655,  827}, 
{ 655,  828}, { 655,  829}, { 655,  830}, { 655,  834}, { 655,  835}, 
{ 655,  836}, { 655,  837}, { 655,  838}, { 655,  839}, { 655,  824}, 
{ 655,  841}, { 547,  952}, { 655,  840}, { 124, 1085}, { 721,  947}, 
{ 278,  914}, { 766,  780}, { 711,  846}, { 768,  782}, { 704,  894}, 
{ 513,  937}, { 567,  671}, { 580,  972}, { 512,  934}, { 798,  809}, 
{ 572,  675}, { 455,  980}, { 812,  814}, { 277,  913}, { 662,  953}, 
{ 650,  935}, { 649,  933}, { 514,  938}, { 483,  900}, { 606, 1002}, 
{ 262,  975}, { 253, 1774}, { 481,  899}, { 125,  286}, { 117,  864}, 
{ 253, 1774}, { 777,  936}, { 270,  453}, { 253, 1774}, { 253, 1774}, 
{ 253, 1774}, { 655,  831}, { 655,  832}, { 655,  833}, { 253, 1774}, 
{ 253, 1774}, { 701,  869}, {  30,   98}, { 253, 1774}, { 261,  445}, 
{ 667,  956}, { 253, 1774}, { 670,  560}, {  94,  873}, { 253, 1774}, 
{ 253, 1774}, { 253, 1774}, { 253, 1774}, { 253, 1774}, { 253, 1774}, 
{ 253, 1774}, { 253, 1774}, { 110, 1772}, { 253, 1774}, { 253, 1774}, 
{  95, 1791}, { 110, 1772}, { 666,  957}, { 253, 1774}, { 110, 1772}, 
{ 110, 1772}, { 110, 1772}, { 526,  920}, { 456,  851}, { 141,  868}, 
{ 110, 1772}, { 110, 1772}, { 707,  925}, { 163,  341}, { 110, 1772}, 
{ 159,  329}, { 488,  868}, { 110, 1772}, { 519,  347}, { 521,  349}, 
{ 110, 1772}, { 110, 1772}, { 110, 1772}, { 110, 1772}, { 110, 1772}, 
{ 110, 1772}, { 110, 1772}, { 110, 1772}, { 454, 1778}, { 110, 1772}, 
{ 110, 1772}, { 143,  896}, { 454, 1778}, { 502, 1039}, { 110, 1772}, 
{ 454, 1778}, { 454, 1778}, { 454, 1778}, { 132,  292}, { 129,  290}, 
{ 308,  895}, { 454, 1778}, { 454, 1778}, { 476,  907}, { 478,  904}, 
{ 454, 1778}, { 492,  635}, {  60,  156}, { 454, 1778}, { 503,  156}, 
{ 518,  906}, { 454, 1778}, { 454, 1778}, { 454, 1778}, { 454, 1778}, 
{ 454, 1778}, { 454, 1778}, { 454, 1778}, { 454, 1778}, { 452, 1770}, 
{ 454, 1778}, { 454, 1778}, { 520,  905}, { 452, 1770}, { 325,  903}, 
{ 454, 1778}, { 452, 1770}, { 452,  995}, { 452,  996}, { 772,  786}, 
{ 487,  866}, { 459,    6}, { 452, 1770}, { 452, 1770}, { 424,  594}, 
{ 443, 1734}, { 452, 1770}, { 632,  701}, { 459,  368}, { 452, 1770}, 
{ 282,  466}, { 165, 1459}, { 452, 1770}, { 452, 1770}, { 452, 1770}, 
{ 452, 1770}, { 452, 1770}, { 452, 1770}, { 452, 1770}, { 452, 1770}, 
{ 312,  493}, { 452, 1770}, { 452, 1770}, { 745,  763}, { 739,  762}, 
{ 719,  752}, { 452, 1770}, { 625,  700}, { 288,  470}, { 740,  692}, 
{ 284,  468}, { 109, 1769}, { 769,  783}, { 620,  698}, { 257,  979}, 
{ 109, 1769}, { 409,  573}, { 412,  574}, { 109, 1769}, {  77,  186}, 
{  89,  875}, { 116,  911}, { 494,  638}, { 404,  987}, { 109, 1769}, 
{ 109, 1769}, { 437,  852}, { 249, 1042}, { 109, 1769}, { 602, 1102}, 
{ 544,  659}, { 109, 1769}, { 661,  717}, { 610, 1779}, { 109, 1769}, 
{ 109, 1769}, { 109, 1769}, { 109, 1769}, { 109, 1769}, { 109, 1769}, 
{ 109, 1769}, { 109, 1769}, { 108, 1761}, { 109, 1769}, { 109, 1769}, 
{ 814,  816}, { 761,  717}, { 793,  805}, { 109, 1769}, { 108, 1761}, 
{ 779,  794}, { 658,  713}, { 797,  808}, { 195, 1092}, { 592,  209}, 
{ 108, 1761}, { 108, 1761}, { 459,   32}, { 459, 1342}, { 108, 1761}, 
{ 386,  546}, {  90,  207}, { 108, 1761}, {  90,  208}, {  52,  148}, 
{ 108,  991}, { 108,  988}, { 108,  993}, { 108,  990}, { 108,  992}, 
{ 108,  989}, { 108, 1761}, { 108, 1761}, { 771,  964}, { 108, 1761}, 
{ 108, 1761}, { 785, 1505}, { 724, 1505}, { 459,   61}, { 108, 1761}, 
{  90,  214}, { 459,   62}, { 725,  755}, { 459,   63}, { 459,   64}, 
{ 459,   65}, { 451, 1762}, { 759,  963}, { 461,  616}, { 612,  694}, 
{ 451,  994}, { 462,  912}, { 123,  282}, { 451, 1762}, {  90,  227}, 
{ 504,  643}, { 459,   68}, {  90,  228}, { 646,  708}, { 451, 1762}, 
{ 451, 1762}, {  90,  229}, { 675,  728}, { 451, 1762}, { 370,  163}, 
{ 584,  235}, { 451, 1762}, { 732,  237}, { 756,  775}, { 757, 1659}, 
{ 243,  427}, { 245,  431}, { 244,  429}, { 242,  425}, { 689,  737}, 
{ 451, 1762}, { 451, 1762}, { 688,  736}, { 451, 1762}, { 451, 1762}, 
{ 690,  738}, { 686,  734}, { 687,  735}, { 451, 1762}, { 253, 1774}, 
{ 246,  433}, { 738,  966}, { 234, 1718}, { 753, 1541}, { 600, 1546}, 
{ 671,   27}, { 118,   27}, { 398, 1598}, { 465,   27}, { 115,   27}, 
{ 458,   27}, { 457,   27}, { 533,   27}, { 212, 1552}, { 211, 1549}, 
{  92,   27}, { 459,   69}, { 394, 1586}, { 396, 1580}, { 439,   27}, 
{  90,  232}, { 433,   27}, {  90,  233}, { 459,   73}, { 431,   27}, 
{ 429,   27}, { 611,   27}, { 459,   74}, { 459,   75}, { 427,   27}, 
{ 110, 1772}, {  90,  234}, {  90,  235}, {  90,  236}, {  90,  237}, 
{  90,  238}, { 106, 1751}, { 459,   76}, { 425,   27}, { 614,   27}, 
{ 615,   27}, { 415,   27}, { 672,   27}, { 106, 1751}, {  40,   27}, 
{  39,   27}, { 695,   27}, {  28,   27}, { 189,   27}, { 106, 1751}, 
{ 106, 1751}, { 748,   27}, { 191,   27}, { 106, 1751}, { 193,   27}, 
{ 750,   27}, { 106, 1751}, { 105, 1747}, { 197,   27}, {  58, 1257}, 
{ 764,   27}, { 454, 1778}, { 373,   27}, {  26,   27}, { 105, 1747}, 
{ 106,  986}, { 106, 1751}, { 790,   27}, { 106, 1751}, { 106, 1751}, 
{ 105, 1747}, { 105, 1747}, { 791,   27}, { 106, 1751}, { 105, 1747}, 
{  67, 1287}, { 388, 1550}, { 105, 1747}, {  66, 1293}, {  90, 1719}, 
{ 389, 1553}, { 806,   27}, { 809,   27}, { 674,   27}, { 450, 1752}, 
{ 817,   27}, { 248,   27}, { 105,  984}, { 805, 1043}, { 105, 1747}, 
{ 105, 1747}, { 450, 1752}, { 452, 1770}, { 231, 1555}, { 105,  985}, 
{ 239,   27}, { 230, 1557}, { 450, 1752}, { 450, 1752}, {   5,   27}, 
{ 196, 1090}, { 450, 1752}, { 192, 1069}, {  90,  239}, { 450, 1752}, 
{ 190, 1065}, { 464, 1060}, { 188, 1056}, { 148, 1615}, { 694, 1337}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 450, 1752}, 
{   0,    0}, { 450, 1752}, { 450, 1752}, {   0,    0}, {   0,    0}, 
{   0,    0}, { 450, 1752}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 109, 1769}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 108, 1761}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 451, 1762}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 106, 1751}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{ 105, 1747}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, { 450, 1752}, 
};
static	yytNComb	yyNComb		[yyNTableMax - yyLastTerminal] = {
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, { 466,  617}, 
{ 667,  552}, { 233, 1694}, { 171, 1297}, { 684,  587}, { 505, 1444}, 
{   4, 1010}, {   4,   16}, {   4, 1047}, {   4,   17}, {  93,   15}, 
{   4, 1051}, { 498,  320}, {   4, 1048}, {   4,   18}, {  42,  124}, 
{   4, 1049}, {   0,    0}, {   4,   19}, { 241,  424}, {   4,   20}, 
{ 507,  256}, { 626, 1331}, { 150,  315}, { 616, 1361}, {   4, 1050}, 
{   4,   21}, { 602, 1104}, { 602,   18}, {  68, 1431}, { 602, 1105}, 
{   4,   22}, { 602,   19}, { 497,  318}, { 602,   20}, { 383,  205}, 
{  42,  125}, {  42, 1080}, { 627,  475}, {  42, 1079}, {   4,   24}, 
{  90,  240}, {  93,   23}, {  93, 1124}, {  93, 1123}, {  93, 1122}, 
{  93,   80}, { 602, 1103}, { 602,  602}, { 487, 1130}, { 487,  303}, 
{  15, 1147}, { 296,  134}, { 296,  135}, { 296,  136}, {  93, 1141}, 
{  93,   26}, { 141,  302}, { 141, 1128}, { 141,  303}, { 141, 1127}, 
{ 262,  256}, { 297, 1251}, {   0,    0}, {  15, 1155}, {  93, 1146}, 
{ 496, 1268}, {  15, 1156}, { 479, 1285}, { 121, 1354}, { 121,   18}, 
{  15, 1152}, { 121, 1355}, { 406,  569}, { 121,   19}, { 146, 1720}, 
{ 121,   20}, { 440,  569}, { 466, 1237}, { 466, 1230}, { 466,  618}, 
{  15, 1149}, {  93, 1143}, { 574, 1694}, { 698,  619}, {  18,   81}, 
{  15, 1157}, { 383, 1171}, { 383,  206}, {  15, 1159}, { 154, 1262}, 
{ 654, 1274}, {  15, 1150}, {   0,    0}, { 466, 1236}, {  15, 1161}, 
{ 692,  619}, { 346, 1456}, {  15, 1167}, { 296,  484}, { 140,  299}, 
{  15, 1160}, {  18,   25}, {  18, 1140}, { 530, 1427}, {  15, 1163}, 
{ 638, 1383}, { 114, 1097}, {  15, 1164}, {  33, 1075}, { 543,  438}, 
{  15, 1165}, { 729, 1689}, { 402,  561}, {  15, 1151}, { 171, 1294}, 
{ 171,  348}, {  15, 1166}, { 232, 1689}, {   0,    0}, {  15, 1162}, 
{  30,  101}, { 142,  306}, {  15, 1153}, { 468,  283}, {  33,   23}, 
{  33, 1124}, {  33, 1123}, {  33, 1122}, {  33,   33}, { 498, 1306}, 
{ 498,  321}, {  15, 1148}, { 488, 1135}, { 488,  304}, { 488, 1133}, 
{ 114,  274}, { 114,  275}, { 150, 1299}, { 150,  316}, { 694, 1338}, 
{  93, 1144}, {   0,    0}, { 613,   23}, { 613, 1124}, { 613, 1123}, 
{ 613, 1122}, { 613,   80}, {  93, 1145}, { 297, 1250}, { 297,  138}, 
{   0,    0}, {  15, 1158}, { 626, 1329}, { 497, 1311}, { 497,  319}, 
{  15, 1168}, {  15, 1169}, {  15, 1384}, { 579,  414}, { 362,  181}, 
{  15, 1385}, { 496, 1267}, { 496,  317}, {  15, 1392}, { 217, 1609}, 
{ 613,  611}, { 627, 1325}, { 627,  477}, { 172, 1291}, {  15, 1393}, 
{ 616,  695}, { 616,  696}, {  15, 1394}, { 479, 1284}, { 479,  293}, 
{  15, 1395}, { 499,  639}, { 499, 1367}, {  15, 1390}, { 526, 1412}, 
{ 186,  366}, {  15, 1391}, { 154, 1258}, { 154,  324}, {  94,  251}, 
{  15, 1386}, { 142, 1208}, { 142,  307}, { 544, 1639}, { 654, 1271}, 
{ 654,  710}, { 505, 1441}, { 505,  328}, {  15, 1388}, {   0,    0}, 
{   0,    0}, {  15, 1387}, { 145,  309}, { 121,  279}, { 121,  280}, 
{ 233, 1691}, { 468,  284}, { 233,  411}, { 422,  592}, {  15, 1389}, 
{ 438, 1509}, { 529, 1423}, {  15,   77}, {  68, 1428}, {  68,  173}, 
{ 698,  620}, { 698, 1322}, { 507,  644}, { 507,  645}, {   0,    0}, 
{   0,    0}, { 795, 1044}, { 782, 1653}, { 528, 1419}, { 782, 1531}, 
{ 629,  480}, { 795,  806}, { 782, 1525}, { 782, 1536}, { 782, 1527}, 
{ 782, 1535}, { 782, 1530}, { 782, 1528}, { 782, 1524}, { 782, 1529}, 
{ 782, 1534}, { 782, 1526}, { 140,  300}, { 140,  301}, { 782, 1533}, 
{ 782, 1573}, { 782, 1571}, { 782, 1572}, { 782, 1574}, { 782, 1575}, 
{ 782, 1576}, { 782, 1577}, { 782, 1578}, { 782, 1579}, { 613, 1343}, 
{ 613,  613}, { 157, 1280}, { 667, 1601}, { 667,  554}, { 345,  168}, 
{ 370, 1503}, {  15, 1154}, { 370,  165}, { 344,  166}, { 558, 1585}, 
{ 558,  556}, {  90, 1511}, {  90, 1516}, {  90, 1512}, { 638, 1377}, 
{ 638,  705}, { 370, 1492}, { 613,  614}, { 613,  615}, { 613, 1384}, 
{ 684, 1634}, { 684,  589}, { 613, 1385}, { 782, 1532}, { 145,  311}, 
{ 613, 1392}, { 782, 1537}, { 408,  330}, { 241, 1521}, { 241, 1617}, 
{ 694, 1336}, { 613, 1393}, { 172, 1288}, { 172,  350}, { 613, 1394}, 
{ 530, 1426}, { 530,  365}, { 613, 1395}, { 213,  391}, { 426,   90}, 
{ 613, 1390}, { 287,  469}, { 233,  412}, { 613, 1391}, { 233,  413}, 
{ 346, 1455}, { 346,  170}, { 613, 1386}, { 391,  550}, {  90, 1513}, 
{  90, 1520}, {  90, 1617}, {  90,  241}, { 691, 1743}, {  90, 1712}, 
{ 613, 1388}, {  90, 1715}, { 298, 1255}, { 613, 1387}, { 629, 1245}, 
{ 629,  482}, { 684,  590}, { 684,  591}, { 287, 1082}, { 287,  126}, 
{  90, 1523}, { 613, 1389}, { 667,  555}, {  90, 1517}, { 613,   77}, 
{  90, 1518}, { 558,  557}, { 487,  631}, { 543,  658}, { 543,  439}, 
{ 543, 1508}, {  90, 1515}, { 526,  360}, {  90, 1514}, { 362, 1408}, 
{ 362,  182}, { 141,  305}, { 507, 1452}, { 507, 1730}, { 112,  102}, 
{  90,  242}, { 271, 1788}, { 507,  260}, {  90,  243}, { 438, 1510}, 
{  90, 1704}, { 112, 1787}, { 406,  570}, {  90,  244}, { 406, 1622}, 
{  90,  245}, { 499, 1376}, {  90,  246}, { 499, 1375}, { 691,  739}, 
{ 499, 1374}, { 402, 1561}, { 499, 1373}, { 698,  622}, { 499, 1372}, 
{ 157,  326}, { 499, 1371}, { 271, 1781}, { 499, 1370}, { 271,  111}, 
{ 271,  112}, { 499, 1369}, { 626, 1800}, { 499, 1368}, { 626, 1330}, 
{ 692,  604}, { 112,  113}, { 112, 1739}, { 112, 1792}, { 800, 1665}, 
{ 800,  788}, { 262,  447}, { 262,  258}, { 262, 1730}, { 574, 1675}, 
{ 574,  677}, {  10, 1363}, { 262,  260}, { 627, 1800}, { 414,  577}, 
{ 627, 1327}, { 414,  578}, { 146,  312}, { 146, 1722}, { 146, 1721}, 
{ 529, 1422}, { 529,  364}, { 326,  503}, { 217, 1606}, { 406,  571}, 
{ 186, 1485}, { 186,  367}, { 440,  605}, { 440,  606}, { 528, 1418}, 
{ 528,  363}, { 444, 1733}, { 298, 1254}, { 298,  139}, { 444,  609}, 
{ 729, 1688}, { 729,  676}, { 800,  789}, { 269,  452}, { 488,  632}, 
{ 232,  409}, { 269,  110}, { 232,  410}, { 525, 1411}, { 525,  358}, 
{ 525,  359}, { 692, 1742}, { 692,  740}, { 345, 1398}, { 345,  169}, 
{ 414,  579}, { 222, 1594}, { 222, 1595}, { 217,  397}, { 579, 1626}, 
{ 344, 1403}, { 344,  167}, { 267, 1756}, { 267,  107}, { 267, 1758}, 
{ 289, 1316}, { 289,  128}, { 289,  129}, { 701,  633}, { 402,  564}, 
{ 701,  104}, { 673,  726}, { 673,  259}, { 670, 1567}, { 670,  563}, 
{ 780, 1648}, { 780,  719}, {  30,  103}, { 725,  756}, { 725,  757}, 
{ 175, 1432}, { 310,  492}, { 175,  176}, {  94,  252}, { 264,  448}, 
{ 265,  449}, { 264,  105}, { 265,  106}, { 266,  450}, { 107, 1759}, 
{ 266, 1755}, { 107,  108}, { 268,  451}, { 674,  727}, { 268,  109}, 
{  51, 1212}, {  51,  147}, {   1,    3}, { 544,  660}, {   1,    4}, 
{ 270, 1773}, { 270,  454}, { 453,  610}, {   5, 1088}, { 453, 1780}, 
{   5,   28}, { 408, 1685}, { 515, 1470}, { 515,  340}, { 472, 1801}, 
{ 472, 1792}, { 176, 1433}, { 176,  353}, { 384,  543}, { 222,  398}, 
{  50,  144}, {  50,  145}, { 384,  544}, { 187, 1490}, { 187,   78}, 
{  24,   88}, {  24,   89}, { 276,  459}, { 276,  460}, {  80,   88}, 
{  80,   89}, { 422, 1670}, { 326, 1275}, { 411, 1690}, { 411, 1460}, 
{  87,  204}, {  87, 1190}, { 279,  462}, { 279,  463}, { 665,  548}, 
{  25,   91}, { 423, 1522}, { 665,  721}, {  25,   92}, {  61,  160}, 
{ 426, 1676}, { 423, 1519}, { 291, 1319}, { 291,  130}, { 221, 1592}, 
{ 221, 1593}, {  62,  164}, { 213, 1539}, { 223, 1590}, { 223, 1591}, 
{ 215,  394}, { 592, 1671}, { 310, 1219}, { 215,  395}, { 679, 1711}, 
{ 683, 1631}, { 127,  288}, { 391, 1540}, { 584, 1697}, { 714,  747}, 
{ 679,  581}, { 623, 1328}, { 416,  580}, { 720,  753}, { 697, 1235}, 
{  10,   39}, { 801,  810}, { 420,  585}, { 511,  648}, { 811, 1652}, 
{ 727,  759}, { 595,  686}, { 250, 1504}, { 666,  722}, { 261,  446}, 
{ 603, 1506}, { 803, 1661}, { 709,  745}, { 493,  637}, { 763,  777}, 
{ 596,  687}, { 818,  819}, { 421,  588}, { 765,  779}, { 767,  781}, 
{ 597,  688}, { 802, 1662}, { 583,  681}, { 513,  650}, { 703,  743}, 
{ 599,  690}, { 598,  689}, {  45,  137}, { 512,  649}, { 584,  682}, 
{ 778,  793}, { 405,  568}, { 510,  647}, { 683,  586}, { 290,  476}, 
{ 685,  733}, { 514,  651}, { 212,  389}, { 211,  388}, { 404,  567}, 
{ 400, 1559}, { 699, 1323}, { 715,  748}, { 693, 1732}, { 183, 1416}, 
{ 443,  608}, { 772,  787}, { 401,  565}, { 403,  566}, { 155, 1259}, 
{ 758, 1642}, { 501, 1261}, { 394, 1587}, { 396, 1581}, { 573, 1673}, 
{ 531, 1487}, { 393,  553}, {   8, 1076}, { 399,  562}, { 559, 1583}, 
{ 668, 1611}, { 331,  508}, { 547,  662}, { 459,  612}, { 361,  527}, 
{ 495, 1301}, { 592,  247}, { 180,  357}, {  46, 1248}, {  88, 1183}, 
{ 152, 1309}, { 295,  483}, { 153, 1304}, { 442, 1727}, { 517,  652}, 
{ 100,  257}, { 680,  731}, {  16, 1046}, { 486, 1334}, { 707, 1450}, 
{ 653, 1270}, { 381,  540}, { 490, 1210}, { 741, 1360}, { 151, 1265}, 
{  64, 1396}, {  63, 1401}, { 375,  534}, { 185, 1424}, {  65, 1453}, 
{ 377,  536}, { 724,  754}, { 785, 1657}, { 351, 1430}, { 184, 1420}, 
{ 407,  572}, {  73, 1406}, {  69,  175}, { 792,  804}, { 294,  481}, 
{ 132, 1282}, { 521, 1290}, { 519, 1296}, { 158,  327}, { 671,  724}, 
{ 813,  815}, { 730, 1693}, { 746, 1273}, { 655, 1269}, {  47, 1252}, 
{ 744, 1382}, { 456, 1096}, { 108,  268}, {  13, 1077}, { 286, 1078}, 
{ 390,  549}, { 749,  766}, { 663, 1545}, {  99,  255}, { 470,  621}, 
{ 786,  799}, {  43, 1314}, { 751,  768}, { 807,  812}, { 119,  277}, 
{ 272, 1785}, { 762,  776}, { 434,  600}, { 436, 1101}, { 280, 1353}, 
{ 435,  601}, { 575, 1674}, { 385,  545}, { 273,  455}, {  96,  253}, 
{  97,  254}, {  19,   82}, { 430, 1680}, {  21,   85}, { 332, 1439}, 
{ 571, 1644}, { 432, 1682}, { 428, 1678}, { 634, 1223}, { 311, 1218}, 
{  17,   79}, { 353, 1435}, { 708, 1438}, { 706, 1278}, { 122,  281}, 
{ 641, 1277}, { 702, 1224}, { 159, 1500}, { 674, 1645}, { 643, 1501}, 
{ 678, 1625}, { 578, 1628}, { 485,  630}, { 144,  310}, { 577, 1627}, 
{  61, 1437}, { 700,  742}, { 808, 1649}, { 333,  509}, { 794, 1620}, 
{ 162,  339}, { 636,  702}, { 127,  131}, { 816,  817}, { 775, 1658}, 
{ 174,  352}, { 728, 1686}, { 774,  791}, { 773,  790}, { 717,  750}, 
{ 313, 1214}, { 502,  641}, { 669,  723}, {  62, 1457}, { 713, 1621}, 
{ 371, 1499}, { 460, 1348}, { 784,  798}, { 165, 1502}, { 343, 1458}, 
{ 491,  634}, { 441,  607}, { 463, 1357}, {  49,  142}, { 657,  712}, 
{ 642,  706}, { 474,  625}, { 230, 1556}, { 239,  422}, { 231, 1554}, 
{ 757, 1660}, { 805, 1619}, { 234,  415}, { 647,  264}, { 216,  396}, 
{ 306, 1211}, { 252,  264}, { 218, 1588}, { 219, 1589}, { 368, 1497}, 
{ 220, 1596}, { 733,  264}, { 770,  785}, { 506, 1446}, {   6, 1120}, 
{ 781,  797}, { 743, 1217}, {  23, 1121}, { 664,  720}, { 207,  384}, 
{   9,   36}, { 111,  272}, { 524,  655}, { 128,  289}, { 742,  264}, 
{ 254,  271}, {   2, 1013}, { 610,  271}, { 253,  271}, { 110,  271}, 
{ 210,  387}, { 454,  271}, { 376,  535}, { 545,  264}, { 747,  264}, 
{ 392,  551}, { 452,  270}, { 109,  270}, {  27, 1011}, { 451,  269}, 
{ 106,  267}, {   7,   31}, { 105,  266}, { 446,  264}, { 450,  267}, 
{ 449,  266}, { 214,  392}, { 448,  265}, { 235, 1707}, { 292,  478}, 
{ 568,  264}, { 103,  264}, { 104,  265}, { 609,  264}, { 516, 1462}, 
{ 382,  542}, { 330, 1445}, { 342, 1461}, { 473, 1803}, { 766,  264}, 
{ 360,  264}, { 768,  264}, { 789,  264}, { 305,  264}, { 567,  264}, 
{ 815, 1656}, {  12,   41}, { 798,  264}, {  11,   40}, { 455,  264}, 
{ 812,  264}, { 156,  325}, { 260,  264}, { 607,  264}, { 819, 1651}, 
{ 149,  314}, {  34,  116}, { 606,  264}, {  36,  118}, { 564,  264}, 
{ 542, 1172}, { 776,  264}, { 723,  264}, { 309, 1221}, {  59,  155}, 
{ 366, 1488}, { 341,  516}, {  84,  195}, {  29, 1119}, { 648,  264}, 
{ 560, 1570}, { 752,  769}, { 209,  386}, { 783, 1647}, { 413,  575}, 
{ 163,  342}, { 205,  382}, {  22, 1052}, { 631,  264}, { 810,  264}, 
{ 143,  308}, { 255,  264}, { 722,  264}, { 555,  264}, { 349,  520}, 
{ 630,  264}, { 637,  704}, { 492,  636}, {  60,  157}, { 503,  642}, 
{  83,  194}, { 347,  518}, { 551, 1616}, { 799,  264}, { 633,  264}, 
{ 651,  264}, { 726, 1643}, { 632,  264}, { 204, 1188}, {  35,  117}, 
{ 194,  373}, { 541, 1176}, { 739,  264}, { 417,  582}, { 625,  264}, 
{ 754,  771}, { 740,  264}, { 284, 1232}, { 755,  774}, { 594, 1618}, 
{ 628, 1247}, {  91,  249}, { 369, 1491}, { 410, 1672}, { 236,  419}, 
{ 736, 1681}, { 576,  678}, { 737, 1683}, { 263, 1723}, { 249,  437}, 
{ 734, 1677}, { 601,  264}, { 315, 1303}, { 712,  264}, {  44,  132}, 
{ 635,  308}, {  31,  115}, { 546, 1548}, { 557,  264}, { 195,  374}, 
{ 523,  654}, { 522,  653}, {  52, 1613}, {  41, 1229}, {  79,  189}, 
{  81,  191}, {  57,  153}, {  56,  152}, {  82,  193}, {  55,  151}, 
{  85,  197}, {  54,  150}, {  74,  183}, { 804,  264}, {  75,  184}, 
{ 320, 1308}, { 281,  465}, { 732, 1698}, { 735, 1679}, { 467, 1233}, 
{ 243,  428}, { 245,  432}, { 244,  430}, { 242,  426}, { 168, 1400}, 
{ 164,  343}, { 166, 1405}, { 329,  506}, { 484, 1241}, {  76,  185}, 
{ 137, 1239}, { 656,  711}, { 753,  264}, { 600,  264}, { 374,  533}, 
{ 118,  276}, { 318, 1313}, { 465, 1058}, { 115, 1054}, { 458, 1350}, 
{ 457, 1349}, { 533, 1071}, { 148, 1614}, { 188, 1055}, {  92,  250}, 
{ 464, 1059}, { 190, 1064}, { 439,  603}, { 433,  599}, { 431,  598}, 
{ 429,  597}, { 611, 1344}, { 427,  596}, { 425,  595}, { 614, 1345}, 
{ 615, 1346}, { 415, 1623}, { 672,  725}, {  40,  122}, {  39,  121}, 
{ 695, 1358}, {  28, 1087}, { 189, 1053}, { 748,  765}, { 191, 1062}, 
{ 193, 1067}, { 750,  767}, { 197, 1086}, {  58,  154}, { 764,  778}, 
{ 373, 1063}, {  26,   93}, { 790,  802}, { 791,  803}, {  67,  172}, 
{ 388,  264}, {  66,  171}, { 389,  264}, { 806,  811}, { 809,  813}, 
{ 192, 1068}, { 817,  818}, { 248,  436}, { 196, 1089}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, 
};
static	yytComb *	yyTBasePtr	[yyLastReadState + 1] = { 0,
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [ 834], 
& yyTComb [1669], & yyTComb [ 410], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [ 886], & yyTComb [ 589], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1306], & yyTComb [ 632], & yyTComb [   3], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [ 202], 
& yyTComb [   0], & yyTComb [   2], & yyTComb [ 507], & yyTComb [ 685], 
& yyTComb [ 737], & yyTComb [1633], & yyTComb [ 204], & yyTComb [1617], 
& yyTComb [ 352], & yyTComb [1575], & yyTComb [ 987], & yyTComb [1201], 
& yyTComb [ 418], & yyTComb [ 137], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1199], & yyTComb [1197], & yyTComb [1615], & yyTComb [1614], 
& yyTComb [1042], & yyTComb [   0], & yyTComb [   0], & yyTComb [ 838], 
& yyTComb [   3], & yyTComb [   0], & yyTComb [   0], & yyTComb [1196], 
& yyTComb [1316], & yyTComb [ 834], & yyTComb [1193], & yyTComb [1678], 
& yyTComb [1251], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1629], & yyTComb [ 399], & yyTComb [1639], 
& yyTComb [ 979], & yyTComb [ 311], & yyTComb [ 864], & yyTComb [1026], 
& yyTComb [ 628], & yyTComb [1648], & yyTComb [1645], & yyTComb [ 834], 
& yyTComb [1258], & yyTComb [1319], & yyTComb [1321], & yyTComb [1264], 
& yyTComb [1254], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1692], & yyTComb [ 801], & yyTComb [ 840], & yyTComb [1214], 
& yyTComb [ 935], & yyTComb [ 841], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1019], & yyTComb [   4], & yyTComb [ 186], & yyTComb [   0], 
& yyTComb [1693], & yyTComb [1692], & yyTComb [ 724], & yyTComb [1585], 
& yyTComb [ 204], & yyTComb [1581], & yyTComb [1355], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1468], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [ 904], & yyTComb [1149], & yyTComb [1517], & yyTComb [ 739], 
& yyTComb [1875], & yyTComb [1854], & yyTComb [   0], & yyTComb [1735], 
& yyTComb [1704], & yyTComb [1600], & yyTComb [1118], & yyTComb [ 514], 
& yyTComb [1265], & yyTComb [1346], & yyTComb [1579], & yyTComb [1694], 
& yyTComb [1565], & yyTComb [1576], & yyTComb [   0], & yyTComb [1113], 
& yyTComb [ 623], & yyTComb [   0], & yyTComb [1654], & yyTComb [1539], 
& yyTComb [1564], & yyTComb [ 658], & yyTComb [   0], & yyTComb [1246], 
& yyTComb [1631], & yyTComb [ 615], & yyTComb [ 806], & yyTComb [1630], 
& yyTComb [  91], & yyTComb [  10], & yyTComb [1195], & yyTComb [1210], 
& yyTComb [   0], & yyTComb [1277], & yyTComb [1275], & yyTComb [   0], 
& yyTComb [1602], & yyTComb [   0], & yyTComb [1623], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [1265], & yyTComb [1678], 
& yyTComb [  37], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [1608], & yyTComb [ 720], 
& yyTComb [ 216], & yyTComb [   0], & yyTComb [1606], & yyTComb [   0], 
& yyTComb [1670], & yyTComb [1097], & yyTComb [1270], & yyTComb [1093], 
& yyTComb [1278], & yyTComb [1211], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1245], & yyTComb [   0], & yyTComb [1301], & yyTComb [ 232], 
& yyTComb [ 590], & yyTComb [ 775], & yyTComb [ 676], & yyTComb [   0], 
& yyTComb [1189], & yyTComb [1126], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [ 173], & yyTComb [1677], 
& yyTComb [1618], & yyTComb [1675], & yyTComb [1622], & yyTComb [1672], 
& yyTComb [1624], & yyTComb [   0], & yyTComb [1676], & yyTComb [1670], 
& yyTComb [1628], & yyTComb [1252], & yyTComb [1318], & yyTComb [1183], 
& yyTComb [1162], & yyTComb [1161], & yyTComb [1187], & yyTComb [ 691], 
& yyTComb [ 437], & yyTComb [1198], & yyTComb [ 763], & yyTComb [1309], 
& yyTComb [  47], & yyTComb [   0], & yyTComb [1584], & yyTComb [1583], 
& yyTComb [ 361], & yyTComb [   0], & yyTComb [1267], & yyTComb [1323], 
& yyTComb [   7], & yyTComb [1317], & yyTComb [1310], & yyTComb [1275], 
& yyTComb [   0], & yyTComb [ 581], & yyTComb [   0], & yyTComb [ 701], 
& yyTComb [ 745], & yyTComb [1247], & yyTComb [1184], & yyTComb [1186], 
& yyTComb [1194], & yyTComb [1666], & yyTComb [1663], & yyTComb [ 754], 
& yyTComb [   0], & yyTComb [1615], & yyTComb [ 420], & yyTComb [ 461], 
& yyTComb [1262], & yyTComb [1266], & yyTComb [1665], & yyTComb [ 210], 
& yyTComb [ 817], & yyTComb [1603], & yyTComb [1600], & yyTComb [1602], 
& yyTComb [1601], & yyTComb [1613], & yyTComb [ 149], & yyTComb [1656], 
& yyTComb [1659], & yyTComb [ 774], & yyTComb [1369], & yyTComb [1349], 
& yyTComb [1569], & yyTComb [1219], & yyTComb [ 779], & yyTComb [  79], 
& yyTComb [1690], & yyTComb [ 568], & yyTComb [1034], & yyTComb [  93], 
& yyTComb [1577], & yyTComb [1561], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [ 217], & yyTComb [1566], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1354], & yyTComb [ 981], & yyTComb [1047], 
& yyTComb [1554], & yyTComb [1541], & yyTComb [ 610], & yyTComb [   0], 
& yyTComb [ 939], & yyTComb [1670], & yyTComb [1128], & yyTComb [1689], 
& yyTComb [ 531], & yyTComb [   0], & yyTComb [ 575], & yyTComb [1687], 
& yyTComb [1225], & yyTComb [  18], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1099], & yyTComb [   0], & yyTComb [   0], & yyTComb [  73], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [1114], & yyTComb [1353], 
& yyTComb [ 992], & yyTComb [1347], & yyTComb [ 975], & yyTComb [ 972], 
& yyTComb [ 436], & yyTComb [1322], & yyTComb [1274], & yyTComb [1632], 
& yyTComb [ 579], & yyTComb [1037], & yyTComb [   0], & yyTComb [1679], 
& yyTComb [1271], & yyTComb [1469], & yyTComb [1266], & yyTComb [1269], 
& yyTComb [1241], & yyTComb [1207], & yyTComb [1248], & yyTComb [1084], 
& yyTComb [1264], & yyTComb [1205], & yyTComb [1198], & yyTComb [1208], 
& yyTComb [1656], & yyTComb [ 370], & yyTComb [1492], & yyTComb [ 998], 
& yyTComb [   0], & yyTComb [   1], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [ 563], & yyTComb [ 554], & yyTComb [1159], 
& yyTComb [1158], & yyTComb [1128], & yyTComb [1451], & yyTComb [1028], 
& yyTComb [ 526], & yyTComb [ 233], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [1100], 
& yyTComb [   0], & yyTComb [1196], & yyTComb [   0], & yyTComb [1454], 
& yyTComb [   0], & yyTComb [1388], & yyTComb [1386], & yyTComb [1382], 
& yyTComb [1370], & yyTComb [ 995], & yyTComb [ 489], & yyTComb [ 156], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [1223], & yyTComb [1206], 
& yyTComb [1123], & yyTComb [ 661], & yyTComb [1122], & yyTComb [1307], 
& yyTComb [ 916], & yyTComb [1645], & yyTComb [1304], & yyTComb [1303], 
& yyTComb [1632], & yyTComb [ 993], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [ 497], & yyTComb [ 265], & yyTComb [ 493], 
& yyTComb [   0], & yyTComb [ 198], & yyTComb [   0], & yyTComb [ 781], 
& yyTComb [   0], & yyTComb [1681], & yyTComb [1078], & yyTComb [1646], 
& yyTComb [1650], & yyTComb [ 245], & yyTComb [ 162], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1587], & yyTComb [1249], & yyTComb [1588], 
& yyTComb [1268], & yyTComb [1577], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [1680], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [ 561], & yyTComb [   0], 
& yyTComb [1689], & yyTComb [ 978], & yyTComb [ 405], & yyTComb [1690], 
& yyTComb [  30], & yyTComb [ 673], & yyTComb [1611], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1270], & yyTComb [ 203], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1109], & yyTComb [  13], & yyTComb [1664], 
& yyTComb [1608], & yyTComb [ 716], & yyTComb [1599], & yyTComb [   0], 
& yyTComb [1595], & yyTComb [   0], & yyTComb [1594], & yyTComb [   0], 
& yyTComb [1591], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1658], & yyTComb [ 905], & yyTComb [1589], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [1665], & yyTComb [   0], 
& yyTComb [1330], & yyTComb [1481], & yyTComb [1350], & yyTComb [ 608], 
& yyTComb [ 428], & yyTComb [1902], & yyTComb [1779], & yyTComb [1662], 
& yyTComb [ 784], & yyTComb [1631], & yyTComb [1552], & yyTComb [1601], 
& yyTComb [1581], & yyTComb [1580], & yyTComb [1627], & yyTComb [   0], 
& yyTComb [1663], & yyTComb [1658], & yyTComb [   0], & yyTComb [1676], 
& yyTComb [1578], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1057], & yyTComb [   0], & yyTComb [  58], & yyTComb [ 351], 
& yyTComb [  70], & yyTComb [   0], & yyTComb [ 210], & yyTComb [1635], 
& yyTComb [ 575], & yyTComb [1636], & yyTComb [   0], & yyTComb [ 117], 
& yyTComb [1563], & yyTComb [ 910], & yyTComb [1559], & yyTComb [1098], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [1660], & yyTComb [1609], 
& yyTComb [ 655], & yyTComb [   0], & yyTComb [   0], & yyTComb [1638], 
& yyTComb [   0], & yyTComb [1695], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [ 627], & yyTComb [1099], 
& yyTComb [   0], & yyTComb [1625], & yyTComb [1641], & yyTComb [1643], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [1512], 
& yyTComb [1477], & yyTComb [1366], & yyTComb [1520], & yyTComb [1549], 
& yyTComb [1546], & yyTComb [1558], & yyTComb [ 847], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1642], & yyTComb [1610], & yyTComb [1654], 
& yyTComb [1611], & yyTComb [   0], & yyTComb [   0], & yyTComb [1230], 
& yyTComb [   0], & yyTComb [1600], & yyTComb [1466], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [1268], 
& yyTComb [1582], & yyTComb [1461], & yyTComb [1450], & yyTComb [1405], 
& yyTComb [1387], & yyTComb [1384], & yyTComb [1383], & yyTComb [1379], 
& yyTComb [   0], & yyTComb [ 169], & yyTComb [ 467], & yyTComb [1660], 
& yyTComb [1462], & yyTComb [   0], & yyTComb [1537], & yyTComb [1030], 
& yyTComb [1324], & yyTComb [1311], & yyTComb [   0], & yyTComb [ 663], 
& yyTComb [1476], & yyTComb [ 891], & yyTComb [ 833], & yyTComb [1101], 
& yyTComb [1039], & yyTComb [   0], & yyTComb [   0], & yyTComb [ 211], 
& yyTComb [ 366], & yyTComb [1389], & yyTComb [ 740], & yyTComb [  56], 
& yyTComb [1453], & yyTComb [1470], & yyTComb [1547], & yyTComb [1514], 
& yyTComb [1106], & yyTComb [ 943], & yyTComb [1502], & yyTComb [1551], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [ 906], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [  21], & yyTComb [1548], 
& yyTComb [ 874], & yyTComb [  12], & yyTComb [   0], & yyTComb [1640], 
& yyTComb [1521], & yyTComb [ 876], & yyTComb [ 491], & yyTComb [1513], 
& yyTComb [ 928], & yyTComb [ 537], & yyTComb [ 525], & yyTComb [1676], 
& yyTComb [1263], & yyTComb [ 861], & yyTComb [ 203], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [1574], 
& yyTComb [ 816], & yyTComb [1661], & yyTComb [  46], & yyTComb [1103], 
& yyTComb [1467], & yyTComb [1560], & yyTComb [ 269], & yyTComb [ 224], 
& yyTComb [ 816], & yyTComb [1478], & yyTComb [1596], & yyTComb [1658], 
& yyTComb [   0], & yyTComb [1609], & yyTComb [1610], & yyTComb [   0], 
& yyTComb [ 990], & yyTComb [ 490], & yyTComb [   0], & yyTComb [1692], 
& yyTComb [1465], & yyTComb [1107], & yyTComb [ 169], & yyTComb [ 253], 
& yyTComb [1686], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [ 882], & yyTComb [ 431], & yyTComb [1667], 
& yyTComb [1025], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [ 911], & yyTComb [   0], & yyTComb [1455], & yyTComb [1446], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [1351], 
& yyTComb [1027], & yyTComb [1646], & yyTComb [1323], & yyTComb [ 314], 
& yyTComb [1557], & yyTComb [1556], & yyTComb [ 452], & yyTComb [1332], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [1346], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1676], & yyTComb [1308], & yyTComb [1105], 
& yyTComb [1660], & yyTComb [1555], & yyTComb [   3], & yyTComb [ 528], 
& yyTComb [  36], & yyTComb [1595], & yyTComb [1578], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1580], & yyTComb [1575], & yyTComb [1612], 
& yyTComb [1025], & yyTComb [1653], & yyTComb [1650], & yyTComb [1090], 
& yyTComb [1085], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1493], & yyTComb [ 413], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1610], & yyTComb [1611], & yyTComb [1606], 
& yyTComb [1603], & yyTComb [1609], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [ 603], & yyTComb [1679], & yyTComb [1616], & yyTComb [1038], 
& yyTComb [ 570], & yyTComb [   0], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1574], & yyTComb [   0], & yyTComb [   0], & yyTComb [1545], 
& yyTComb [ 849], & yyTComb [   0], & yyTComb [1605], & yyTComb [   0], 
& yyTComb [   0], & yyTComb [1073], & yyTComb [1543], & yyTComb [ 817], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [1211], 
& yyTComb [   0], & yyTComb [1212], & yyTComb [1684], & yyTComb [   0], 
& yyTComb [1540], & yyTComb [ 805], & yyTComb [ 422], & yyTComb [1673], 
& yyTComb [1676], & yyTComb [1029], & yyTComb [  93], & yyTComb [   0], 
& yyTComb [ 302], & yyTComb [   0], & yyTComb [1522], & yyTComb [1640], 
& yyTComb [1362], & yyTComb [ 891], & yyTComb [ 904], & yyTComb [ 857], 
& yyTComb [ 852], & yyTComb [1614], & yyTComb [1683], & yyTComb [1688], 
& yyTComb [   0], & yyTComb [1421], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1682], & yyTComb [   0], & yyTComb [1463], & yyTComb [1621], 
& yyTComb [   0], & yyTComb [1625], & yyTComb [   0], & yyTComb [  84], 
& yyTComb [1573], & yyTComb [ 582], & yyTComb [  28], & yyTComb [1603], 
& yyTComb [1604], & yyTComb [   0], & yyTComb [1673], & yyTComb [1483], 
& yyTComb [1674], & yyTComb [   0], & yyTComb [   0], & yyTComb [1630], 
& yyTComb [   0], & yyTComb [1542], & yyTComb [   0], & yyTComb [1544], 
& yyTComb [1691], & yyTComb [1200], & yyTComb [1670], & yyTComb [1659], 
& yyTComb [   0], & yyTComb [   0], & yyTComb [   0], & yyTComb [ 398], 
& yyTComb [1567], & yyTComb [   0], & yyTComb [1675], & yyTComb [ 207], 
& yyTComb [   0], & yyTComb [ 399], & yyTComb [   6], & yyTComb [   0], 
& yyTComb [1673], & yyTComb [   0], & yyTComb [1459], & yyTComb [ 757], 
& yyTComb [ 312], & yyTComb [1637], & yyTComb [1642], & yyTComb [   0], 
& yyTComb [1672], & yyTComb [   0], & yyTComb [   0], & yyTComb [1305], 
& yyTComb [1676], & yyTComb [1550], & yyTComb [ 996], & yyTComb [   0], 
& yyTComb [ 888], & yyTComb [   0], & yyTComb [ 783], & yyTComb [ 936], 
& yyTComb [1658], & yyTComb [1651], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1652], & yyTComb [ 741], & yyTComb [ 580], & yyTComb [1553], 
& yyTComb [   0], & yyTComb [1673], & yyTComb [   0], & yyTComb [   0], 
& yyTComb [1655], & yyTComb [ 433], & yyTComb [ 249], 
};
static	yytNComb *	yyNBasePtr	[yyLastReadState + 1] = { 0,
& yyNComb [ 200], & yyNComb [ 487], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 205], & yyNComb [ 439], & yyNComb [ 501], & yyNComb [ 302], 
& yyNComb [ 343], & yyNComb [ 116], & yyNComb [ 528], & yyNComb [ 526], 
& yyNComb [ 358], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 336], 
& yyNComb [ 379], & yyNComb [-202], & yyNComb [ 370], & yyNComb [-256], 
& yyNComb [ 372], & yyNComb [ 558], & yyNComb [ 442], & yyNComb [ 160], 
& yyNComb [  23], & yyNComb [ 683], & yyNComb [ 499], & yyNComb [ 673], 
& yyNComb [ 491], & yyNComb [-135], & yyNComb [ 578], & yyNComb [-256], 
& yyNComb [-167], & yyNComb [ 473], & yyNComb [ 579], & yyNComb [ 538], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 671], & yyNComb [ 670], 
& yyNComb [ 536], & yyNComb [-241], & yyNComb [ 262], & yyNComb [ 601], 
& yyNComb [ 209], & yyNComb [ 246], & yyNComb [ 284], & yyNComb [-256], 
& yyNComb [ 450], & yyNComb [ 141], & yyNComb [ 127], & yyNComb [ 359], 
& yyNComb [-256], & yyNComb [ 618], & yyNComb [ 616], & yyNComb [ 614], 
& yyNComb [ 613], & yyNComb [ 675], & yyNComb [ 541], & yyNComb [ 465], 
& yyNComb [ 238], & yyNComb [ 245], & yyNComb [ 189], & yyNComb [ 191], 
& yyNComb [ 159], & yyNComb [ 683], & yyNComb [ 681], & yyNComb [-227], 
& yyNComb [ 362], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 196], & yyNComb [ 619], & yyNComb [ 621], & yyNComb [ 636], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 604], & yyNComb [ 164], 
& yyNComb [ 600], & yyNComb [ 601], & yyNComb [ 570], & yyNComb [ 547], 
& yyNComb [ 593], & yyNComb [-256], & yyNComb [ 168], & yyNComb [ 282], 
& yyNComb [-256], & yyNComb [-215], & yyNComb [ 559], & yyNComb [ 656], 
& yyNComb [-250], & yyNComb [-129], & yyNComb [-256], & yyNComb [  70], 
& yyNComb [  71], & yyNComb [-256], & yyNComb [  71], & yyNComb [  34], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 198], & yyNComb [ 197], 
& yyNComb [ 185], & yyNComb [ 181], & yyNComb [-133], & yyNComb [  54], 
& yyNComb [ 170], & yyNComb [ 159], & yyNComb [ 149], & yyNComb [-229], 
& yyNComb [-256], & yyNComb [-149], & yyNComb [ 650], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 647], & yyNComb [ 239], & yyNComb [-256], 
& yyNComb [-200], & yyNComb [ 383], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 129], & yyNComb [ 481], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 259], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 558], & yyNComb [-256], & yyNComb [-256], & yyNComb [-156], 
& yyNComb [-241], & yyNComb [-134], & yyNComb [ 560], & yyNComb [ 351], 
& yyNComb [ -58], & yyNComb [-181], & yyNComb [-256], & yyNComb [ 399], 
& yyNComb [ 382], & yyNComb [-233], & yyNComb [ 253], & yyNComb [ 214], 
& yyNComb [ 219], & yyNComb [-166], & yyNComb [ 221], & yyNComb [ 531], 
& yyNComb [  -9], & yyNComb [ 180], & yyNComb [ 227], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 227], & yyNComb [ 554], & yyNComb [ 433], 
& yyNComb [ 249], & yyNComb [ 595], & yyNComb [-256], & yyNComb [ 593], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-253], & yyNComb [ -87], 
& yyNComb [-256], & yyNComb [ 232], & yyNComb [  -3], & yyNComb [  27], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 165], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 138], & yyNComb [ 185], 
& yyNComb [ 176], & yyNComb [ -76], & yyNComb [  10], & yyNComb [ 653], 
& yyNComb [ 674], & yyNComb [ 656], & yyNComb [ 676], & yyNComb [ 690], 
& yyNComb [ 677], & yyNComb [ 552], & yyNComb [ 581], & yyNComb [ 693], 
& yyNComb [ 679], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 517], 
& yyNComb [ 502], & yyNComb [-256], & yyNComb [ 215], & yyNComb [-256], 
& yyNComb [ 333], & yyNComb [ 490], & yyNComb [  -9], & yyNComb [ -10], 
& yyNComb [  28], & yyNComb [ 506], & yyNComb [   4], & yyNComb [ 218], 
& yyNComb [ -91], & yyNComb [ 221], & yyNComb [ 222], & yyNComb [ 224], 
& yyNComb [  -1], & yyNComb [ -89], & yyNComb [   3], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 457], & yyNComb [ 459], & yyNComb [-139], 
& yyNComb [-255], & yyNComb [ 204], & yyNComb [ 212], & yyNComb [ 303], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 460], & yyNComb [-256], 
& yyNComb [-237], & yyNComb [ 635], & yyNComb [ 632], & yyNComb [ 634], 
& yyNComb [ 633], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 694], 
& yyNComb [ 595], & yyNComb [  59], & yyNComb [-256], & yyNComb [ 153], 
& yyNComb [ 158], & yyNComb [ 155], & yyNComb [ 248], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 219], 
& yyNComb [ -38], & yyNComb [-195], & yyNComb [ 598], & yyNComb [-130], 
& yyNComb [-131], & yyNComb [-130], & yyNComb [-158], & yyNComb [-132], 
& yyNComb [-183], & yyNComb [-128], & yyNComb [-234], & yyNComb [  59], 
& yyNComb [  86], & yyNComb [-256], & yyNComb [-256], & yyNComb [  82], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [  87], & yyNComb [ 251], 
& yyNComb [ 614], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 510], 
& yyNComb [-256], & yyNComb [ 359], & yyNComb [  31], & yyNComb [-256], 
& yyNComb [  41], & yyNComb [ 170], & yyNComb [ 116], & yyNComb [ 509], 
& yyNComb [-256], & yyNComb [ 280], & yyNComb [ 252], & yyNComb [-240], 
& yyNComb [-194], & yyNComb [  47], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 210], & yyNComb [ 424], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 502], & yyNComb [ 179], & yyNComb [ 336], & yyNComb [-256], 
& yyNComb [ 372], & yyNComb [-256], & yyNComb [ 561], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 605], & yyNComb [-256], & yyNComb [ 584], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 125], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 636], & yyNComb [ 325], & yyNComb [ 138], & yyNComb [ 214], 
& yyNComb [ 225], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 545], & yyNComb [ 316], & yyNComb [ 250], & yyNComb [  -2], 
& yyNComb [  -6], & yyNComb [-160], & yyNComb [ 571], & yyNComb [-256], 
& yyNComb [ 564], & yyNComb [-256], & yyNComb [ 178], & yyNComb [-256], 
& yyNComb [ 227], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 207], 
& yyNComb [ 162], & yyNComb [ -96], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 491], & yyNComb [-256], & yyNComb [ 428], 
& yyNComb [ 382], & yyNComb [-205], & yyNComb [ 262], & yyNComb [-256], 
& yyNComb [ 682], & yyNComb [ 625], & yyNComb [ 310], & yyNComb [ 339], 
& yyNComb [ 313], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 304], & yyNComb [ 460], & yyNComb [-221], & yyNComb [ 215], 
& yyNComb [  85], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 372], 
& yyNComb [ 374], & yyNComb [ 158], & yyNComb [  36], & yyNComb [ 467], 
& yyNComb [  74], & yyNComb [  67], & yyNComb [-256], & yyNComb [  68], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [  90], & yyNComb [  71], 
& yyNComb [  79], & yyNComb [-143], & yyNComb [  80], & yyNComb [  -8], 
& yyNComb [ -16], & yyNComb [-183], & yyNComb [ 172], & yyNComb [  16], 
& yyNComb [-256], & yyNComb [ 309], & yyNComb [  29], & yyNComb [-256], 
& yyNComb [ 352], & yyNComb [-140], & yyNComb [ 668], & yyNComb [ -35], 
& yyNComb [ 583], & yyNComb [-256], & yyNComb [-256], & yyNComb [   7], 
& yyNComb [  20], & yyNComb [ -56], & yyNComb [ -34], & yyNComb [-256], 
& yyNComb [ 665], & yyNComb [  25], & yyNComb [ 664], & yyNComb [ 192], 
& yyNComb [ 662], & yyNComb [ 187], & yyNComb [ 661], & yyNComb [ 191], 
& yyNComb [ 660], & yyNComb [  80], & yyNComb [  83], & yyNComb [ 360], 
& yyNComb [-256], & yyNComb [-173], & yyNComb [ 659], & yyNComb [-179], 
& yyNComb [ 139], & yyNComb [  32], & yyNComb [   1], & yyNComb [-173], 
& yyNComb [-256], & yyNComb [ 190], & yyNComb [-256], & yyNComb [ 192], 
& yyNComb [ 188], & yyNComb [ 185], & yyNComb [ 174], & yyNComb [ 169], 
& yyNComb [-127], & yyNComb [ 161], & yyNComb [ 216], & yyNComb [ 347], 
& yyNComb [ 652], & yyNComb [ 651], & yyNComb [ 190], & yyNComb [ 306], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 307], & yyNComb [ 655], 
& yyNComb [ 649], & yyNComb [-256], & yyNComb [ 629], & yyNComb [-132], 
& yyNComb [-256], & yyNComb [ 256], & yyNComb [-256], & yyNComb [-127], 
& yyNComb [ 181], & yyNComb [ 144], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-188], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 556], 
& yyNComb [ 110], & yyNComb [ 210], & yyNComb [-250], & yyNComb [-168], 
& yyNComb [-256], & yyNComb [ 282], & yyNComb [ 378], & yyNComb [ 493], 
& yyNComb [ -25], & yyNComb [-256], & yyNComb [ 215], & yyNComb [-190], 
& yyNComb [-223], & yyNComb [-244], & yyNComb [-229], & yyNComb [-256], 
& yyNComb [ 223], & yyNComb [ 337], & yyNComb [ 466], & yyNComb [-256], 
& yyNComb [-252], & yyNComb [ 282], & yyNComb [-235], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ -15], & yyNComb [ -44], & yyNComb [ -10], 
& yyNComb [ -15], & yyNComb [ -11], & yyNComb [   4], & yyNComb [ 313], 
& yyNComb [  33], & yyNComb [-256], & yyNComb [ 255], & yyNComb [-256], 
& yyNComb [ 257], & yyNComb [ 608], & yyNComb [ 607], & yyNComb [ 479], 
& yyNComb [ -19], & yyNComb [-245], & yyNComb [-256], & yyNComb [ -37], 
& yyNComb [ -49], & yyNComb [-152], & yyNComb [ 114], & yyNComb [-256], 
& yyNComb [ 653], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 524], & yyNComb [ 484], & yyNComb [-150], & yyNComb [ -67], 
& yyNComb [ 180], & yyNComb [ 607], & yyNComb [  94], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 553], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 250], & yyNComb [-256], 
& yyNComb [ 295], & yyNComb [-251], & yyNComb [  74], & yyNComb [ 331], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 226], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 211], & yyNComb [ 197], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 137], & yyNComb [-256], 
& yyNComb [  34], & yyNComb [-174], & yyNComb [ 197], & yyNComb [ 305], 
& yyNComb [ 166], & yyNComb [ 163], & yyNComb [ -99], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ -16], & yyNComb [  -1], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [  28], 
& yyNComb [-256], & yyNComb [ 333], & yyNComb [  58], & yyNComb [  67], 
& yyNComb [  72], & yyNComb [  78], & yyNComb [  77], & yyNComb [ 330], 
& yyNComb [ 288], & yyNComb [-242], & yyNComb [  62], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 224], & yyNComb [ 220], & yyNComb [-256], 
& yyNComb [ 200], & yyNComb [ 157], & yyNComb [ 663], & yyNComb [-256], 
& yyNComb [-149], & yyNComb [ 666], & yyNComb [ 667], & yyNComb [-232], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 130], & yyNComb [-256], 
& yyNComb [ 271], & yyNComb [-234], & yyNComb [-218], & yyNComb [ 590], 
& yyNComb [ -35], & yyNComb [ 252], & yyNComb [ 245], & yyNComb [ 264], 
& yyNComb [ 261], & yyNComb [ 335], & yyNComb [ 605], & yyNComb [ 359], 
& yyNComb [ 496], & yyNComb [-150], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 313], & yyNComb [ 351], & yyNComb [ 229], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 150], & yyNComb [ 236], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 262], & yyNComb [-256], 
& yyNComb [ 246], & yyNComb [-165], & yyNComb [ 274], & yyNComb [ 641], 
& yyNComb [ 142], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [ 160], & yyNComb [ 476], 
& yyNComb [  15], & yyNComb [ -39], & yyNComb [-255], & yyNComb [  75], 
& yyNComb [ 130], & yyNComb [ -60], & yyNComb [ 371], & yyNComb [ 669], 
& yyNComb [-137], & yyNComb [ 195], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 162], & yyNComb [ -43], & yyNComb [  35], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [  -5], & yyNComb [-252], 
& yyNComb [ -12], & yyNComb [-256], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [-256], & yyNComb [-223], & yyNComb [-160], 
& yyNComb [  -1], & yyNComb [-116], & yyNComb [ 672], & yyNComb [-256], 
& yyNComb [ 185], & yyNComb [-172], & yyNComb [  40], & yyNComb [ 114], 
& yyNComb [-144], & yyNComb [ 343], & yyNComb [ -14], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 311], & yyNComb [ 152], & yyNComb [ 222], 
& yyNComb [ -26], & yyNComb [-256], & yyNComb [-256], & yyNComb [ 290], 
& yyNComb [ 439], & yyNComb [ -53], & yyNComb [  41], & yyNComb [-256], 
& yyNComb [ 434], & yyNComb [-256], & yyNComb [-256], & yyNComb [ -49], 
& yyNComb [-256], & yyNComb [ 249], & yyNComb [ 229], & yyNComb [ 144], 
& yyNComb [ -98], & yyNComb [ 308], & yyNComb [  57], & yyNComb [ 246], 
& yyNComb [-145], & yyNComb [  83], & yyNComb [-256], & yyNComb [ 368], 
& yyNComb [ 158], & yyNComb [ 308], & yyNComb [ 334], & yyNComb [ 296], 
& yyNComb [ 296], & yyNComb [-256], & yyNComb [ 269], & yyNComb [ 273], 
& yyNComb [ 201], & yyNComb [ 171], & yyNComb [ 406], & yyNComb [ 221], 
& yyNComb [-256], & yyNComb [ 273], & yyNComb [ 181], & yyNComb [ 675], 
& yyNComb [  69], & yyNComb [ 678], & yyNComb [  75], & yyNComb [ 332], 
& yyNComb [ 329], & yyNComb [ 311], & yyNComb [ 310], & yyNComb [-256], 
& yyNComb [ 184], & yyNComb [  48], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [  79], & yyNComb [ -24], & yyNComb [ 681], 
& yyNComb [  70], & yyNComb [ 206], & yyNComb [  71], & yyNComb [ 208], 
& yyNComb [-256], & yyNComb [ 474], & yyNComb [-256], & yyNComb [  32], 
& yyNComb [ 433], & yyNComb [ 432], & yyNComb [ 429], & yyNComb [ 228], 
& yyNComb [-256], & yyNComb [  82], & yyNComb [-256], & yyNComb [ -43], 
& yyNComb [ 204], & yyNComb [-256], & yyNComb [ 334], & yyNComb [ 135], 
& yyNComb [ 145], & yyNComb [  73], & yyNComb [-256], & yyNComb [-256], 
& yyNComb [ 209], & yyNComb [ 684], & yyNComb [ 685], & yyNComb [  51], 
& yyNComb [-256], & yyNComb [ 424], & yyNComb [ -39], & yyNComb [-256], 
& yyNComb [-256], & yyNComb [ 214], & yyNComb [ 260], & yyNComb [-170], 
& yyNComb [ -46], & yyNComb [  73], & yyNComb [  63], & yyNComb [ 310], 
& yyNComb [ 456], & yyNComb [ 690], & yyNComb [  76], & yyNComb [ 422], 
& yyNComb [ 691], & yyNComb [ 246], & yyNComb [  56], & yyNComb [ 217], 
& yyNComb [ 158], & yyNComb [-256], & yyNComb [ 251], & yyNComb [ 428], 
& yyNComb [ 693], & yyNComb [  68], & yyNComb [ 263], 
};
# ifdef YYTDefault
static	unsigned short	yyTDefault	[yyLastReadState + 1] = { 0,
    0,    27,     0,    93,   805,   133,   655,    33,    32,   697, 
  655,   655,    33,     0,     0,     4,    93,    93,    93,     0, 
   93,     1,     6,    80,   426,     0,    22,     0,     0,   526, 
    0,     0,   296,     0,   655,   655,     0,     0,     0,     0, 
    0,   287,   289,   524,   296,   655,   655,     0,   524,     0, 
    0,     0,     0,   524,   524,   524,   524,    59,   524,     0, 
  729,   370,    64,   655,   729,    44,    44,    64,   289,     0, 
    0,     0,    69,   524,   524,   524,     0,     0,     0,   204, 
    0,     0,   655,   655,     0,     0,    34,   655,     0,   782, 
    0,     0,    45,   526,   471,   453,   453,     0,   404,   673, 
    0,   131,   648,   448,     0,     0,   269,   451,   452,   254, 
    0,   222,     0,   456,     0,     0,     0,     0,   499,     0, 
   33,    93,   655,   469,     0,     0,   289,   391,     0,     0, 
  312,   655,     0,     0,     0,     0,   484,     0,     0,   655, 
  487,   655,   521,   655,   655,   655,     0,    52,     0,   655, 
  655,   655,   655,   697,   697,   655,   655,   407,   729,     0, 
    0,   515,   159,   413,   411,   168,     0,   306,     0,     0, 
  519,   521,     0,   515,     0,   371,     0,     0,     0,   526, 
    0,     0,   655,   655,   655,   729,     0,   805,     0,   805, 
    0,   805,     0,    31,    31,   805,     0,     0,     0,     0, 
    0,     0,     0,     0,   366,     0,     0,     0,     0,   655, 
  212,   404,   222,   655,   217,     0,   287,     0,     0,     0, 
  222,    69,   222,     0,     0,     0,     0,     0,     0,   805, 
  805,    61,    62,   579,     0,     0,     0,     0,     0,     0, 
  655,   245,   245,   245,   239,     0,   590,     0,     0,   724, 
    0,   648,   254,     0,   555,   552,     0,     0,     0,   609, 
  526,   673,   655,   404,   404,   404,   404,   269,   270,   453, 
  453,   453,   404,     0,     0,     0,     0,     0,     0,   121, 
    0,     0,     0,    41,     0,    33,   655,     0,   655,   623, 
  289,   655,     0,   655,   655,     0,   655,   655,     0,     0, 
    0,     0,     0,     0,   555,     0,     0,     0,   168,   326, 
  310,   590,     0,     0,   168,     0,     0,   168,     0,   168, 
    0,     0,     0,     0,     0,     0,     0,     0,   729,     0, 
  407,   159,   515,     0,     0,     0,     0,     0,     0,     0, 
   65,     0,   575,   655,   655,   729,   655,     0,   655,     0, 
  655,     0,   176,     0,     0,     0,     0,     0,     0,   305, 
  526,   655,     0,     0,     0,     0,     0,     0,     0,   413, 
    0,     0,     0,     0,   141,   149,   141,     0,     0,     0, 
  141,     0,   655,     5,   404,     0,     0,   601,   601,     0, 
    0,   195,   667,   212,     0,   212,     0,   590,   670,   670, 
  670,   670,   670,   269,   404,   404,   163,   159,     0,     0, 
    0,     0,     0,   584,     0,   655,   655,     0,     0,   655, 
  655,     0,   594,     0,     0,   422,     0,   426,     0,   426, 
    0,   426,     0,   404,   404,    33,     0,    90,     0,   404, 
  404,   673,   693,   693,     0,   648,     0,     0,   105,   106, 
    0,     0,   112,   254,   648,   655,     0,     0,   296,   276, 
    0,     0,   279,   805,     0,   697,   655,   655,     0,   289, 
  624,   473,     0,   404,     0,     0,     0,     0,   132,     0, 
    0,     0,     0,     0,   404,   655,   772,   526,   701,   655, 
  502,     0,   655,     0,   655,   655,   655,   655,     0,     0, 
  697,   132,     0,     0,   407,   330,   707,     0,     0,   404, 
  510,   513,   655,   510,     0,   342,   673,     0,   502,     0, 
  519,   524,   524,     0,   526,   667,     0,   655,   655,   655, 
  729,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
   29,     0,   426,   655,   648,   655,   670,     0,     0,     0, 
  374,   101,     0,     0,   606,     0,   651,   404,   404,     0, 
  552,     0,     0,   723,     0,     0,   648,   648,   552,     0, 
  648,     0,   729,   729,     0,   236,   579,   579,     0,     0, 
  637,     0,   655,   732,     0,   637,     0,     0,     0,     0, 
    0,   655,     0,     0,   426,   595,   595,   595,   595,   601, 
    0,    33,   250,     0,     0,   740,   555,     0,   305,   254, 
    0,     0,   459,     0,     0,   655,   283,     0,     0,     0, 
    0,     0,   222,     0,   651,   623,   290,   655,   655,   555, 
    0,   305,   555,   310,   655,   655,   312,   655,     0,     0, 
  326,   655,   159,     0,     0,     0,   648,     0,   777,   777, 
    0,     0,   655,   655,     0,   655,   404,     0,     0,     0, 
  780,     0,     0,     0,     0,   526,   670,   404,   404,   404, 
  782,     0,   772,   592,     0,     0,     0,   579,   655,   673, 
  777,     0,   655,   655,   404,     0,     0,     0,     0,     0, 
  404,   404,   801,   805,     0,     0,   655,   289,   404,   404, 
  526,   310,   655,     0,     0,   326,   673,   159,   655,     0, 
    0,   557,   805,   404,   404,     0,   805,     0,     0,   404, 
    0,   555,   555,   785,     0,     0,   426,   159,     0,   729, 
    0,     0,   648,     0,     0,     0,     0,     0,   651,   651, 
  655,   648,   637,   655,   312,   655,   648,     0,   404,     0, 
  404,     0,   601,     0,     0,     0,   725,   404,     0,     0, 
    0,   404,   655,     0,   543,   648,   818,   648,     0,   239, 
    0,   404,   805,   805,   805,   723,   590,   543,     0,   782, 
  819,   592,     0,   404,   426,   404,     0,     0,   305,     0, 
    0,   404,     0,   805,   805,     0,     0,   648,   555,   772, 
  510,   803,   426,   648,   655,     0,   404,   805,     0,   555, 
  426,   648,   724,     0,   754,   805,     0,   811,     0, 
};
# endif
# ifdef YYNDefault
static	unsigned short	yyNDefault	[yyLastReadState + 1] = { 0,
    0,     0,     0,    18,     0,     0,     0,    33,     0,     0, 
    0,     0,    33,     0,   187,     4,    18,    93,    18,     0, 
   18,     0,     0,    33,   426,     0,     0,     0,     0,   404, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,   287,   289,     0,   296,   297,   298,     0,   368,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
  369,   370,   344,   345,   346,     0,     0,     0,   371,     0, 
    0,     0,   362,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,   383,     0,   782, 
    0,     0,     0,   404,     0,   453,   453,     0,   404,   262, 
    0,     0,     0,     0,     0,     0,   268,   451,     0,     0, 
    0,   146,     0,     0,     0,     0,     0,     0,   499,     0, 
   33,    18,   468,     0,     0,     0,   146,     0,     0,     0, 
    0,   479,     0,     0,     0,     0,     0,     0,     0,     0, 
  488,     0,     0,   145,     0,     0,     0,     0,     0,     0, 
  496,   497,   498,     0,   154,     0,     0,   505,   408,     0, 
    0,   515,     0,     0,   411,     0,     0,     0,     0,     0, 
    0,     0,     0,   515,     0,     0,     0,     0,     0,   525, 
    0,     0,   528,   529,   530,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
  404,   404,     0,     0,   217,     0,     0,     0,     0,     0, 
  222,   146,   222,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,   579,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,   543, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
  404,   673,     0,   265,   266,   267,   107,   269,   453,   453, 
  112,   271,   404,     0,     0,     0,     0,     0,     0,   121, 
    0,     0,     0,     0,     0,    33,     0,     0,   291,   627, 
  127,     0,     0,   629,   629,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
  310,     0,    51,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
  505,   408,   515,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,   411,     0,     0,     0,     0,     0,     0,     0, 
   68,     0,   176,     0,     0,     0,     0,     0,     0,     0, 
  525,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
  175,     0,     0,     0,   141,     0,   141,     0,     0,     0, 
  141,     0,     0,     0,   404,     0,     0,     0,     0,   665, 
    0,     0,   667,   558,     0,   558,     0,     0,   670,   402, 
  670,   404,   670,   701,   404,   404,   505,     0,     0,     0, 
    0,     0,     0,     0,     0,   679,     0,     0,     0,   683, 
  684,     0,   594,     0,     0,     0,     0,   426,     0,   426, 
    0,   426,     0,   404,   404,   602,     0,    90,     0,   692, 
  404,   262,   444,   404,     0,     0,     0,     0,     0,     0, 
    0,     0,   271,     0,     0,   114,     0,     0,   613,   276, 
    0,     0,   279,     0,     0,     0,     0,     0,     0,   698, 
    0,     0,     0,   404,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,   404,   140,   404,   404,   701,   142, 
  145,     0,   146,     0,   150,     0,     0,     0,     0,     0, 
  154,   157,     0,     0,     0,     0,   673,     0,     0,   404, 
  404,   146,   146,   404,     0,     0,   262,     0,   171,     0, 
  172,     0,     0,     0,   526,   404,     0,     0,     0,     0, 
  186,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,   670,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,   404,   558,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
  647,     0,   729,     0,   411,     0,   579,   579,     0,     0, 
    0,     0,   146,     0,     0,     0,     0,     0,     0,     0, 
    0,   146,     0,     0,   543,   543,   543,   543,   543,     0, 
    0,    33,   543,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,   187,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,   626,     0,     0,   472,   472,     0,     0,     0, 
    0,     0,     0,   310,     0,   145,     0,     0,     0,     0, 
  326,   157,   408,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,   654,     0,   654,     0,   404,     0,     0,     0, 
  780,     0,   665,     0,     0,   404,   404,   558,   404,   402, 
  782,     0,   444,   592,     0,     0,     0,   579,   146,   262, 
    0,     0,   146,   146,   404,     0,     0,     0,     0,     0, 
  404,   404,   444,     0,     0,     0,   466,   127,   691,   404, 
  264,   310,   146,     0,     0,   326,   507,   408,   146,     0, 
    0,     0,   795,   404,   691,     0,   795,     0,     0,   404, 
    0,     0,     0,    25,     0,     0,   543,   408,     0,   574, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
  616,     0,     0,   638,     0,   654,     0,     0,   404,     0, 
  404,     0,     0,     0,     0,     0,   725,   406,     0,     0, 
    0,   404,   146,     0,   543,     0,   543,     0,     0,     0, 
    0,   800,   795,   795,   795,     0,     0,   543,     0,   782, 
    0,   592,     0,   404,    25,   404,     0,     0,     0,     0, 
    0,   404,     0,   795,     0,     0,     0,     0,     0,   404, 
  404,   543,   543,     0,   795,     0,   404,   795,     0,     0, 
  543,     0,    25,     0,     0,   795,     0,   543,     0, 
};
# endif
# if ! defined NO_RECOVER | defined YYDEC_TABLE
static	unsigned char	yyLength	[yyLastReduceState - yyFirstReduceState
							+ 1] = {
    2,     2,     2,     0,     2,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1,     1,     0, 
    1,     0,     1,     0,     0,     1,     1,     2,     1,     1, 
    1,     1,     1,     2,     4,     4,     2,     1,     0,     6, 
    2,     1,     0,     4,     5,     2,     1,     0,     4,     2, 
    1,     0,     6,     0,     4,     0,     2,     2,     2,     5, 
    1,     1,     1,     3,     3,     1,     1,     4,     3,     2, 
    2,     1,     0,     0,     2,     3,     1,     3,     1,     1, 
    5,     0,     3,     1,     2,     1,     1,     3,     5,     3, 
    5,     1,     1,     1,     1,     1,     3,     1,     1,     1, 
    3,     2,     2,     1,     1,     1,     4,     3,     1,     1, 
    1,     3,     1,     2,     1,     1,     3,     1,     3,     1, 
    3,     1,     3,     0,     1,     1,     1,     1,     2,     1, 
    1,     1,     1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     3,     4,     0,     3,     0,     2,     0,     2, 
    3,     1,     1,     1,     3,     0,     1,     2,     2,     3, 
    1,     1,     1,     4,     4,     4,     1,     1,     1,     4, 
    4,     4,     1,     1,     1,     1,     1,     1,     1,     3, 
    1,     3,     2,     2,     1,     3,     6,     0,     3,     4, 
    4,     1,     2,     0,     3,     4,     3,     2,     1,     0, 
    3,     6,     0,     3,     3,     1,     3,     1,     1,     2, 
    3,     0,     3,     4,     4,     1,     3,     1,     3,     2, 
    1,     3,     1,     2,     1,     3,     1,     1,     1,     3, 
    3,     1,     3,     1,     4,     4,     3,     1,     3,     1, 
    6,     6,     6,     1,     3,     1,     4,     0,     3,     4, 
    3,     1,     1,     3,     1,     3,     1,     3,     1,     3, 
    1,     3,     1,     3,     1,     3,     1,     3,     1,     3, 
    3,     1,     3,     1,     2,     3,     1,     3,     1,     2, 
    3,     1,     3,     1,     2,     2,     1,     3,     4,     1, 
    3,     1,     5,     3,     3,     1,     3,     1,     1,     3, 
    3,     1,     1,     4,     1,     3,     3,     8,     0,     1, 
    0,     1,     3,     0,     2,     2,     2,     2,     0,     2, 
    2,     2,     6,     0,     2,     1,     1,     0,     2,     4, 
    1,     3,     1,     0,     1,     4,     4,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1,     6,     1, 
    1,     1,     1,     3,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     2,     1,     3, 
    1,     2,     2,     1,     3,     1,     2,     2,     1,     3, 
    4,     1,     3,     3,     1,     1,     1,     3,     1,     3, 
    1,     3,     1,     3,     1,     3,     1,     3,     1,     2, 
    1,     3,     1,     3,     2,     0,     2,     3,     2,     6, 
    3,     1,     3,     1,     1,     1,     2,     3,     0,     3, 
    1,     3,     1,     1,     2,     1,     3,     1,     2,     3, 
    0,     1,     3,     4,     2,     0,     3,     3,     4,     1, 
    1,     3,     1,     4,     3,     1,     4,     3,     4,     3, 
    4,     8,     3,     3,     1,     1,     3,     1,     3,     2, 
    1,     3,     2,     2,     1,     1,     1,     1,     2,     4, 
    2,     2,     5,     2,     1,     3,     0,     3,     0,     1, 
    2,     2,     2,     1,     1,     1,     1,     1,     1,     1, 
    3,     1,     2,     3,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,     1,     1,     1,     1,     1,     1,     1, 
    2,     3,     6,     0,     4,     1,     3,     3,     3,     4, 
    1,     2,     1,     1,     2,     2,     1,     2,     1,     4, 
    3,     4,     3,     4,     2,     4,     5,     1,     3,     3, 
    1,     2,     1,     1,     1,     1,     1,     1,     1,     1, 
    1,     2,     3,     2,     4,     2,     4,     2,     3,     2, 
    2,     2,     2,     2,     2,     2,     2,     2,     1,     1, 
    3,     1,     3,     1,     3,     1,     3,     1,     1,     1, 
    1,     1,     3,     1,     2,     2,     1,     4,     1,     3, 
   11,    10,     6,     3,     3,     0,     4,     3,     3,     3, 
    4,     1,     3,     4,     1,     3,     1,     1,     0,     1, 
    1,     3,     5,     5,     4,     2,     2,     4,     9,     5, 
   11,     0,     9,     4,     5,     8,     0,     7,     3,     8, 
    1,     2,     5,     5,     3,     1,     3,     1,     2,     2, 
    3,     3,     2,     3,     4,     4,     4,     3,     6,     3, 
    6,     3,     6,     3,     6,     6,     2,     5,     1,     3, 
    1,     2,     1,     1,     3,     1,     2,     4,     4,     6, 
    4,     3,     6,     0,     1,     1,     0,     1,     2,     0, 
    3,     1,     3,     1,     0,     1,     1,     0,     1,     1, 
    0,     1,     1,     1,     3,     3,     4,     1,     3,     1, 
    3,     1,     3,     5,     3,     0,     1,     3,     5,     1, 
    1,     3,     4,     3,     3,     3,     1,     1,     1,     3, 
    1,     1,     1,     3,     1,     1,     1,     3,     1,     1, 
    2,     1,     1,     3,     1,     1,     1,     1,     1,     1, 
    1,     3,     1,     1,     3,     2,     2,     1,     1,     1, 
    2,     1,     3,     1,     1,     1,     3,     1,     2,     1, 
    1,     1,     1,     1,     5,     1,     1,     1,     2,     1, 
    1,     1,     2,     2,     2, 
};
static	yytNonterminal	yyLeftHandSide	[yyLastReduceState - yyFirstReduceState
							+ 1] = {
yyNT0_intern,
yyNTfortran,
yyNTCR1,
yyNTCR0,
yyNTCR0,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTPIdent,
yyNTHPFIdent,
yyNTHPFIdent,
yyNTopt_comma,
yyNTopt_comma,
yyNTopt_dcolon,
yyNTopt_dcolon,
yyNTopt_label,
yyNTopt_ident,
yyNTopt_ident,
yyNTprogram_units,
yyNTprogram_units,
yyNTprogram_unit,
yyNTprogram_unit,
yyNTprogram_unit,
yyNTprogram_unit,
yyNTprogram_unit,
yyNTmain_program,
yyNTmain_program,
yyNTprogram_definition,
yyNTprogram_token,
yyNTprogram_token,
yyNTprogram_token,
yyNTmodule,
yyNTmodule_token,
yyNTmodule_token,
yyNTmodule_token,
yyNTsubroutine_subprogram,
yyNTsubroutine_definition,
yyNTsubroutine_token,
yyNTsubroutine_token,
yyNTsubroutine_token,
yyNTfunction_subprogram,
yyNTfunction_token,
yyNTfunction_token,
yyNTfunction_token,
yyNTfunction_definition,
yyNTfunction_result,
yyNTfunction_result,
yyNTprefix,
yyNTprefix,
yyNTprefix,
yyNTprefix,
yyNTprefix,
yyNTextrinsic_spec,
yyNTextrinsic_spec,
yyNTextrinsic_spec_arg_list,
yyNTextrinsic_spec_arg_list,
yyNTextrinsic_spec_arg,
yyNTextrinsic_spec_arg,
yyNTextrinsic_kind_keyword,
yyNTblock_data,
yyNTblock_data_definition,
yyNTblock_data_definition,
yyNTblock_data_token,
yyNTblock_data_token,
yyNTblock_data_token,
yyNTdummy_arguments,
yyNTdummy_arguments,
yyNTdummy_arguments,
yyNTunit_param_list,
yyNTunit_param_list,
yyNTunit_param,
yyNTunit_param,
yyNTblock,
yyNTinternal_subprogram_part,
yyNTinternal_subprogram_part,
yyNTinternal_subprograms,
yyNTinternal_subprograms,
yyNTinternal_subprogram,
yyNTinternal_subprogram,
yyNTkind_selector,
yyNTkind_selector,
yyNTkind_selector,
yyNTkind_selector,
yyNTbasic_num_type,
yyNTbasic_num_type,
yyNTbasic_num_type,
yyNTbasic_num_type,
yyNTnum_type,
yyNTnum_type,
yyNTnum_type,
yyNTnum_type,
yyNTchar_type,
yyNTchar_type,
yyNTkind_type,
yyNTkind_type,
yyNTtype_spec,
yyNTtype_spec,
yyNTtype_spec,
yyNTtype_spec,
yyNTDimSpec,
yyNTDimIndexes,
yyNTDimIndexes,
yyNTDyn_Specifications,
yyNTDyn_Specifications,
yyNTDyn_Spec,
yyNTDyn_Spec,
yyNTIndex_Typen,
yyNTIndex_Typen,
yyNTIndex_Typen,
yyNTexplicit_shape,
yyNTexplicit_shape,
yyNTLastBegrenzer,
yyNTLastBegrenzer,
yyNTspecification_part,
yyNTdecl_constructs,
yyNTdecl_constructs,
yyNTdeclaration_construct,
yyNTdeclaration_construct,
yyNTdeclaration_construct,
yyNTdeclaration_construct,
yyNTdeclaration_construct,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTdefinition,
yyNTentity_decl_list,
yyNTentity_decl_list,
yyNTentity_decl,
yyNTopt_array_spec,
yyNTopt_array_spec,
yyNTopt_char_length,
yyNTopt_char_length,
yyNTopt_init_expr,
yyNTopt_init_expr,
yyNTchar_length,
yyNTchar_length,
yyNTtype_param_value,
yyNTtype_param_value,
yyNTtype_declaration_stmt,
yyNToptional_attributes,
yyNToptional_attributes,
yyNToptional_attributes,
yyNTattribute_list,
yyNTattribute_list,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTattr_spec,
yyNTaccess_spec,
yyNTaccess_spec,
yyNTaccess_spec,
yyNTdimension_definition,
yyNTArraySpecList,
yyNTArraySpecList,
yyNTArraySpec,
yyNTequivalence_definition,
yyNTeqvblocks,
yyNTeqvblocks,
yyNTeqvblock,
yyNTmore_eqvs,
yyNTmore_eqvs,
yyNTcommon_definition,
yyNTcommon_definition,
yyNTcommon_object,
yyNTcommon_object,
yyNTcommon_cont,
yyNTcommon_cont,
yyNTcommon_cont,
yyNTnamed_common,
yyNTblank_common,
yyNTblank_common,
yyNTblank_common,
yyNTuse_stmt,
yyNTuse_stmt,
yyNTrename_list,
yyNTrename_list,
yyNTrename,
yyNTonly_list,
yyNTonly_list,
yyNTonly,
yyNTonly,
yyNTimplicit_definition,
yyNTimplicit_definition,
yyNTmore_implicit_decl,
yyNTmore_implicit_decl,
yyNTimplicit_decl,
yyNTimplicit_decl,
yyNTletter_list,
yyNTletter_list,
yyNTletter_spec,
yyNTletter_spec,
yyNTexternal_definition,
yyNTExtIdentList,
yyNTExtIdentList,
yyNTExtIdent,
yyNTintrinsic_definition,
yyNTIntIdentList,
yyNTIntIdentList,
yyNTIntrinsic_Ident,
yyNTaccess_definition,
yyNTaccess_definition,
yyNTaccess_definition,
yyNTaccess_definition,
yyNTaccess_id_list,
yyNTaccess_id_list,
yyNTaccess_id,
yyNTaccess_id,
yyNTaccess_id,
yyNToptional_definition,
yyNToptional_id_list,
yyNToptional_id_list,
yyNToptional_ident,
yyNTmap_definition,
yyNTmap_definition,
yyNTmap_definition,
yyNTmap_id_list,
yyNTmap_id_list,
yyNTmap_ident,
yyNTnamelist_definition,
yyNTnamelist_cont,
yyNTnamelist_cont,
yyNTnamelist_cont,
yyNTnamelist_groupid,
yyNTnamelist_object,
yyNTsave_definition,
yyNTsave_definition,
yyNTsave_var_list,
yyNTsave_var_list,
yyNTsave_var,
yyNTsave_var,
yyNTsequ_definition,
yyNTsequ_definition,
yyNTsequ_var_list,
yyNTsequ_var_list,
yyNTsequ_var,
yyNTsequ_var,
yyNTnsequ_definition,
yyNTnsequ_definition,
yyNTnsequ_var_list,
yyNTnsequ_var_list,
yyNTnsequ_var,
yyNTnsequ_var,
yyNTallocatable_definition,
yyNTallocatable_var_list,
yyNTallocatable_var_list,
yyNTallocatable_var,
yyNTallocatable_var,
yyNTtarget_definition,
yyNTtarget_var_list,
yyNTtarget_var_list,
yyNTtarget_var,
yyNTtarget_var,
yyNTpointer_definition,
yyNTpointer_var_list,
yyNTpointer_var_list,
yyNTpointer_var,
yyNTpointer_var,
yyNTdata_statement,
yyNTdata_defs,
yyNTdata_defs,
yyNTdata_def,
yyNTdata_liste,
yyNTdata_liste,
yyNTdata_elem,
yyNTdata_elem,
yyNTimpl_do_var,
yyNTimpl_do_var,
yyNTdata_values,
yyNTdata_values,
yyNTdata_value,
yyNTdata_value,
yyNTdata_value,
yyNTdata_value,
yyNTdata_real_value,
yyNTdata_real_value,
yyNTparameter_definition,
yyNTnamed_constant_def_list,
yyNTnamed_constant_def_list,
yyNTnamed_constant_def,
yyNTderived_type_def,
yyNToptional_id,
yyNToptional_id,
yyNTopt_access_spec,
yyNTopt_access_spec,
yyNTopt_access_spec,
yyNTderived_type_components,
yyNTderived_type_components,
yyNTcomponent_def_stmt,
yyNTcomponent_def_stmt,
yyNTcomponent_def_stmt,
yyNTprivate_sequence_stmts,
yyNTprivate_sequence_stmts,
yyNTprivate_sequence_stmt,
yyNTprivate_sequence_stmt,
yyNTinterface_block,
yyNTinterface_body_list,
yyNTinterface_body_list,
yyNTinterface_body,
yyNTinterface_body,
yyNTmodule_procedure_stmt_list,
yyNTmodule_procedure_stmt_list,
yyNTmodule_procedure_stmt,
yyNTprocedure_name_list,
yyNTprocedure_name_list,
yyNTprocedure_name,
yyNTgeneric_spec,
yyNTgeneric_spec,
yyNTgeneric_spec,
yyNTgeneric_spec,
yyNTdefined_operator,
yyNTdefined_operator,
yyNTintrinsic_operator,
yyNTintrinsic_operator,
yyNTintrinsic_operator,
yyNTintrinsic_operator,
yyNTintrinsic_operator,
yyNTintrinsic_operator,
yyNTintrinsic_operator,
yyNTintrinsic_operator,
yyNTintrinsic_operator,
yyNTintent_definition,
yyNTintent_spec,
yyNTintent_spec,
yyNTintent_spec,
yyNTintent_list,
yyNTintent_list,
yyNTintent_item,
yyNThpf_directive,
yyNThpf_directive,
yyNThpf_directive,
yyNThpf_directive,
yyNThpf_directive,
yyNThpf_directive,
yyNThpf_directive,
yyNThpf_directive,
yyNThpf_directive,
yyNTadp_directive,
yyNTadp_directive,
yyNTadp_directive,
yyNTtemplate_directive,
yyNTtemplate_decl_list,
yyNTtemplate_decl_list,
yyNTtemplate_decl,
yyNTtemplate_decl,
yyNTprocessors_directive,
yyNTprocessors_decl_list,
yyNTprocessors_decl_list,
yyNTprocessors_decl,
yyNTprocessors_decl,
yyNTshadow_directive,
yyNTshadow_decl_list,
yyNTshadow_decl_list,
yyNTshadow_decl,
yyNTshadow_spec_list,
yyNTshadow_spec_list,
yyNTshadow_spec,
yyNTshadow_spec,
yyNTshadow_width,
yyNTshadow_width,
yyNTtrace_directive,
yyNTtrace_id_list,
yyNTtrace_id_list,
yyNTtrace_id,
yyNTtree_directive,
yyNTtree_id_list,
yyNTtree_id_list,
yyNTtree_id,
yyNTnodsp_directive,
yyNTnodsp_id_list,
yyNTnodsp_id_list,
yyNTnodsp_id,
yyNTinherit_directive,
yyNTinherit_decl_list,
yyNTinherit_decl_list,
yyNTinherit_decl,
yyNTrange_directive,
yyNTrange_attr_stuff_list,
yyNTrange_attr_continue,
yyNTrange_attr_continue,
yyNTrange_attr_stuff,
yyNTalign_directive,
yyNTsingle_align_stuff,
yyNTsingle_align_stuff,
yyNTalign_source_list,
yyNTalign_source_list,
yyNTalign_source,
yyNTalign_source,
yyNTalign_source,
yyNTalign_spec,
yyNTalign_spec,
yyNTopt_align_subscript_list,
yyNTopt_align_subscript_list,
yyNTalign_subscript_list,
yyNTalign_subscript_list,
yyNTalign_subscript,
yyNTalign_subscript,
yyNTdynamic_directive,
yyNTdynamic_list,
yyNTdynamic_list,
yyNTdynamic_var,
yyNTdistribute_directive,
yyNTsingle_dist_stuff,
yyNTopt_onto,
yyNTopt_onto,
yyNTdist_onto_clause,
yyNTdist_onto_clause,
yyNTdist_onto_clause,
yyNTopt_section_subscript_list,
yyNTopt_section_subscript_list,
yyNTdist_format_clause,
yyNTdist_format_clause,
yyNTdist_format_clause,
yyNTdist_format_list,
yyNTdist_format_list,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTdist_format,
yyNTcombined_directive,
yyNTobject_name_list,
yyNTobject_name_list,
yyNTobject_name,
yyNTcombined_att_list,
yyNTcombined_att_list,
yyNTcombined_att,
yyNTcombined_att,
yyNTcombined_att,
yyNTcombined_att,
yyNTcombined_att,
yyNTcombined_att,
yyNTcombined_att,
yyNTcombined_att,
yyNTcombined_att,
yyNTalign_attribute_stuff,
yyNTalign_attribute_stuff,
yyNTdist_attribute_stuff,
yyNTdist_attribute_stuff,
yyNTexecution_part,
yyNTexecution_part,
yyNTexecution_block,
yyNTexecution_block,
yyNTexecution_part_construct,
yyNTexecution_part_construct,
yyNTexecution_part_construct,
yyNTexecutable_construct,
yyNTstatement,
yyNTstatement,
yyNTstatement,
yyNTstatement,
yyNTstatement,
yyNTstructured_statement,
yyNTstructured_statement,
yyNTstructured_statement,
yyNTstructured_statement,
yyNTstructured_statement,
yyNTstructured_statement,
yyNTstructured_statement,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTaction_stmt,
yyNTused_label,
yyNTgoto_statement,
yyNTgoto_statement,
yyNTgoto_statement,
yyNTassigned_labels,
yyNTassigned_labels,
yyNTlabel_list,
yyNTlabel_list,
yyNTassignment_statement,
yyNTassignment_statement,
yyNTassignment_statement,
yyNTstop_statement,
yyNTstop_statement,
yyNTcontinue_statement,
yyNTreturn_statement,
yyNTreturn_statement,
yyNTexit_statement,
yyNTexit_statement,
yyNTexit_statement,
yyNTcycle_statement,
yyNTallocate_statement,
yyNTallocate_statement,
yyNTdeallocate_statement,
yyNTdeallocate_statement,
yyNTnullify_statement,
yyNTcall_statement,
yyNTcall_statement,
yyNTcall_statement,
yyNTparams,
yyNTparams,
yyNTparam,
yyNTparam,
yyNTparam,
yyNTio_statement,
yyNTio_statement,
yyNTio_statement,
yyNTio_statement,
yyNTio_statement,
yyNTio_statement,
yyNTio_statement,
yyNTio_statement,
yyNTio_statement,
yyNTwrite_statement,
yyNTwrite_statement,
yyNTprint_statement,
yyNTprint_statement,
yyNTread_statement,
yyNTread_statement,
yyNTread_statement,
yyNTread_statement,
yyNTopen_statement,
yyNTclose_statement,
yyNTrewind_statement,
yyNTrewind_statement,
yyNTbackspace_statement,
yyNTbackspace_statement,
yyNTendfile_statement,
yyNTendfile_statement,
yyNTinquire_statement,
yyNTexternal_file_unit,
yyNTexternal_file_unit,
yyNTio_specification,
yyNTio_spec_list,
yyNTio_spec_list,
yyNTio_spec,
yyNTio_spec,
yyNTio_spec,
yyNTio_spec,
yyNTformat_identifier,
yyNTformat_identifier,
yyNTformat_identifier,
yyNTformat_identifier,
yyNTio_list,
yyNTio_list,
yyNTio_item,
yyNTformat_statement,
yyNTformat_list,
yyNTformat_list,
yyNTentry_statement,
yyNTstruct_loop_statement,
yyNTstruct_loop_statement,
yyNTloop_statement,
yyNTloop_statement,
yyNTloop_statement,
yyNTloop_statement,
yyNTindependent_clause,
yyNTind_clauses,
yyNTind_clauses,
yyNTind_clauses,
yyNTind_clauses,
yyNTind_clauses,
yyNTnew_clause,
yyNTnew_var_list,
yyNTnew_var_list,
yyNTreduction_clause,
yyNTreduction_var_list,
yyNTreduction_var_list,
yyNTreduction_var,
yyNTreduction_var,
yyNTForLabel,
yyNTForLabel,
yyNTLaufvariable,
yyNTDoRange,
yyNTDoRange,
yyNTforall_cont,
yyNTforall_cont,
yyNTforall_cont,
yyNTforall_end,
yyNTforall_end,
yyNTif_statement,
yyNTif_statement,
yyNTif_construct,
yyNTelse_part,
yyNTelse_part,
yyNTelse_part,
yyNTwhere_statement,
yyNTwhere_construct,
yyNTelsewhere_part,
yyNTelsewhere_part,
yyNTelsewhere_part,
yyNTcase_construct,
yyNTcase_list,
yyNTcase_list,
yyNTcase_item,
yyNTcase_item,
yyNTcase_selector,
yyNTcase_value_range_list,
yyNTcase_value_range_list,
yyNTcase_value_range,
yyNTcase_value_range,
yyNTcase_value_range,
yyNTcase_value_range,
yyNTadp_statement,
yyNTatomic_construct,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNThpf_statement,
yyNTrealign_attribute_stuff,
yyNTrealign_attribute_stuff,
yyNTrealignee_list,
yyNTrealignee_list,
yyNTrealignee,
yyNTredist_attribute_stuff,
yyNTredist_attribute_stuff,
yyNTredistributee_list,
yyNTredistributee_list,
yyNTredistributee,
yyNTsimple_on_directive,
yyNTsimple_on_directive,
yyNTsimple_on_directive,
yyNTsimple_on_directive,
yyNThome_expr,
yyNThome_expr,
yyNThome_expr,
yyNTopt_hpf_on,
yyNTopt_hpf_on,
yyNTsimple_resident_directive,
yyNTopt_hpf_resident,
yyNTopt_hpf_resident,
yyNTresident_clause,
yyNTopt_local_var_list,
yyNTopt_local_var_list,
yyNTlocal_var_list,
yyNTlocal_var_list,
yyNTsimple_new_directive,
yyNTopt_hpf_new,
yyNTopt_hpf_new,
yyNTsimple_reduction_directive,
yyNTopt_hpf_reduction,
yyNTopt_hpf_reduction,
yyNTtask_flag,
yyNTtask_flag,
yyNTvariable,
yyNTvariable,
yyNTvariable,
yyNTstructure_component,
yyNTindex_var,
yyNTindex_var,
yyNTsection_subscript_list,
yyNTsection_subscript_list,
yyNTIndex_Elem,
yyNTIndex_Elem,
yyNTIndex_Elem,
yyNTSlice,
yyNTSlice,
yyNTSlice,
yyNTdumexpression,
yyNTdumexpression,
yyNTprimary,
yyNTprimary,
yyNTprimary,
yyNTprimary,
yyNTprimary,
yyNTprimary,
yyNTimpl_do_exp,
yyNTimpl_do_exp,
yyNTexpression,
yyNTexpression,
yyNTdefined_binary_op,
yyNTlevel5_expr,
yyNTlevel5_expr,
yyNTequiv_op,
yyNTequiv_op,
yyNTequiv_operand,
yyNTequiv_operand,
yyNTor_op,
yyNTor_op,
yyNTor_operand,
yyNTor_operand,
yyNTand_op,
yyNTand_operand,
yyNTand_operand,
yyNTnot_op,
yyNTlevel4_expr,
yyNTlevel4_expr,
yyNTrel_op,
yyNTrel_op,
yyNTrel_op,
yyNTrel_op,
yyNTrel_op,
yyNTrel_op,
yyNTlevel3_expr,
yyNTlevel3_expr,
yyNTconcat_op,
yyNTlevel2_expr,
yyNTlevel2_expr,
yyNTlevel2_expr,
yyNTlevel2_expr,
yyNTadd_op,
yyNTadd_op,
yyNTsigned_add_operand,
yyNTsigned_add_operand,
yyNTadd_operand,
yyNTadd_operand,
yyNTmult_op,
yyNTmult_op,
yyNTmult_operand,
yyNTmult_operand,
yyNTpower_op,
yyNTlevel1_expr,
yyNTlevel1_expr,
yyNTdefined_unary_op,
yyNTPReal,
yyNTKonstante,
yyNTKonstante,
yyNTKonstante,
yyNTKonstante,
yyNTKonstante,
yyNTKonstante,
yyNTRealKonstante,
yyNTRealKonstante,
yyNTRealKonstante,
yyNTSignedKonstante,
yyNTSignedKonstante,
yyNTSignedKonstante,
yyNTSignedKonstante,
};
# endif
# ifndef NO_RECOVER
static	yySymbolRange	yyContinuation	[yyLastReadState + 1] = { 0,
    1,     0,     0,     1,   255,     1,     1,    66,    13,   255, 
    1,     1,    66,    13,   145,     0,     1,     1,     1,    66, 
    1,     0,     1,     1,    68,   255,     0,   255,     2,     1, 
  255,    13,    66,   201,     1,     1,    13,    13,   255,   255, 
  255,     1,     1,   255,     1,     1,     1,    13,    13,     1, 
   13,    86,    13,     1,     1,     1,     1,   255,   255,    18, 
  152,     1,     1,     1,     1,   255,   255,     1,    13,    13, 
   13,    13,    13,     1,     1,     1,    27,    27,   255,     1, 
  255,   255,     1,     1,   255,     2,   192,     1,    27,    81, 
   68,   255,     1,    17,   255,     1,     1,    14,     1,     1, 
   10,   255,    14,   255,   255,   255,     1,   255,   255,   255, 
  255,     1,    13,    14,   255,    27,    14,   255,     7,    10, 
  133,     1,   138,    14,    14,    14,     1,   255,    18,    18, 
   21,     1,    13,    13,    13,    13,   255,   255,   255,     1, 
   17,     1,    18,     1,     1,     1,   255,   255,   111,     1, 
    1,     1,     1,     1,     1,     1,     1,    20,     1,   152, 
  255,   160,     1,    17,    21,   255,   255,   255,   255,   255, 
    1,     1,   255,   160,    13,   255,     5,     5,     5,    17, 
   13,   255,     1,     1,     1,     1,   158,   255,   255,   255, 
  255,   255,   255,   255,   255,   255,   255,    13,    13,    13, 
   13,    13,    13,    27,   255,   255,   255,    13,     2,     1, 
  255,   255,     2,     1,     2,    13,     2,    13,    13,    13, 
    2,     2,     2,   226,   226,    13,    13,    13,    13,   255, 
  255,     1,     1,   212,   255,    13,    13,    13,   255,    10, 
   69,   255,   255,   255,   255,   212,    10,   255,    68,    68, 
   14,    14,   255,   255,    21,     7,    24,    14,    20,    21, 
    1,    14,     1,     1,     1,     1,     1,     1,     1,     1, 
    1,     1,     1,    14,    14,    50,    14,    14,   133,   133, 
  255,    20,    12,   255,     5,    66,     5,    21,     1,     1, 
    1,     1,   255,     1,     1,    51,     1,     1,    10,    14, 
   14,    14,    14,    14,    20,    13,   255,    18,   255,   255, 
  255,    21,    13,    14,   255,   255,   255,   255,   255,   255, 
  255,    13,    13,   255,    18,   255,    14,    14,     1,   255, 
   20,     1,   160,    21,    21,    13,    13,    13,    14,    14, 
  255,   255,   255,     1,     1,     1,     1,   255,     1,   255, 
    1,    14,   255,    14,    14,    14,    14,    14,    21,    20, 
   17,     1,   255,   255,   255,   255,   255,    13,   152,    17, 
   13,    13,   255,   255,    17,   111,    17,     5,     5,     5, 
   17,   255,     1,   255,     1,    79,   255,   255,   255,     2, 
  255,   255,     1,   255,   255,   255,   255,   255,     1,     1, 
    1,     1,     1,     1,     1,     1,    20,     1,    27,   152, 
   27,    27,    17,   165,   255,     1,     1,    13,   255,     1, 
    1,     1,    69,    20,   255,     1,   255,     1,   255,     1, 
  255,     1,   255,     1,     1,    66,    68,    81,   255,     1, 
    1,     1,    20,    21,    14,    14,    14,   255,   255,   255, 
  255,   255,     1,   255,    14,     1,   255,   255,   131,    50, 
  125,   133,   133,   255,   255,     1,     1,     1,    10,     1, 
   21,     2,     2,     1,    21,    18,    18,    18,     1,    21, 
   14,    14,    14,   255,     1,     1,    20,    17,    17,     1, 
    1,    18,     1,    27,     1,     1,     1,     1,     7,    10, 
    1,     1,    18,   152,    20,   255,    17,    14,    14,    14, 
   14,    14,    14,    14,   160,   255,     1,    18,     1,    18, 
    1,     1,     1,     1,    17,    17,    14,     1,     1,     1, 
    1,    13,   255,    14,    14,    14,    14,    14,    14,    14, 
    2,   255,    75,    70,    14,     1,    14,    14,    14,    13, 
  255,     7,    14,    14,    21,   255,   255,     1,     1,     2, 
  255,    14,    14,   255,    14,    14,    14,    14,     7,    10, 
   14,    14,     1,     1,   255,    13,   255,   255,   255,    14, 
   14,    14,     1,   165,    14,    14,    21,    14,    14,    29, 
   21,     1,    13,    69,   211,   211,   211,   211,   211,   255, 
  255,    68,    68,    10,    14,    14,    21,    21,    20,   255, 
  255,   131,   131,   255,   255,     1,   255,   255,    10,    21, 
   14,    10,     2,    21,    21,     2,     1,     1,     1,    21, 
   20,    20,    21,   255,     1,     1,    14,     1,    14,    14, 
  255,     1,     1,    14,    14,   152,    14,    14,    14,    14, 
   21,    14,     1,     1,     1,     1,     1,    75,    13,    10, 
   81,    14,     2,     1,     2,     1,     1,     1,     1,     1, 
   81,   255,    20,   255,   152,   255,   255,   255,     1,     1, 
   14,   255,     1,     1,     1,   211,   211,   211,   211,   211, 
    1,     1,    21,   255,   255,   255,     1,     1,     1,     1, 
   17,   255,     1,    14,   255,   255,    17,     1,     1,   255, 
   14,   255,   255,     1,     1,    13,   255,    13,    21,     1, 
   14,    21,   255,   103,   106,    14,   114,     1,     1,     1, 
   14,   167,    14,   255,   255,   255,   255,   212,    21,    21, 
    1,    14,    14,     1,    21,     1,    14,   255,     1,   255, 
    1,     2,   255,   103,   107,   205,   205,     1,   114,    14, 
   72,     1,     1,   255,    75,    14,    73,    14,    21,   255, 
  103,     1,   255,   255,   255,   255,    14,    75,    75,    81, 
   76,    81,     2,     1,   103,     1,    14,    14,    21,   255, 
  255,     1,    75,   255,   255,    13,    76,    14,    21,     1, 
   21,   205,   205,   255,   255,   255,     1,   255,   255,    21, 
   76,    14,   103,    72,   103,   255,   255,    73,    76, 
};
static	unsigned short	yyCondition	[yyLastState - yyLastReduceState + 1] =
{ 0,
};
# endif
static	unsigned short	yyFinalToProd	[yyLastReadReduceState -
						yyFirstReadReduceState + 2] = {
 1014,  1015,  1016,  1017,  1018,  1019,  1020,  1021,  1022,  1023, 
 1024,  1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033, 
 1034,  1035,  1036,  1037,  1039,  1041,  1073,  1083,  1084,  1093, 
 1094,  1098,  1099,  1106,  1107,  1108,  1109,  1110,  1111,  1112, 
 1113,  1115,  1116,  1117,  1125,  1126,  1131,  1132,  1138,  1139, 
 1174,  1179,  1180,  1181,  1185,  1186,  1189,  1191,  1192,  1193, 
 1194,  1195,  1196,  1197,  1198,  1199,  1200,  1201,  1202,  1203, 
 1204,  1205,  1206,  1207,  1215,  1225,  1226,  1227,  1238,  1242, 
 1243,  1263,  1264,  1279,  1286,  1292,  1298,  1317,  1321,  1332, 
 1340,  1341,  1351,  1364,  1365,  1366,  1378,  1379,  1380,  1409, 
 1414,  1436,  1442,  1443,  1448,  1451,  1465,  1466,  1467,  1472, 
 1473,  1475,  1476,  1477,  1478,  1479,  1480,  1481,  1482,  1483, 
 1484,  1493,  1494,  1495,  1496,  1498,  1538,  1543,  1551,  1558, 
 1560,  1562,  1564,  1565,  1597,  1599,  1604,  1605,  1607,  1608, 
 1629,  1632,  1638,  1646,  1654,  1663,  1684,  1699,  1700,  1701, 
 1703,  1706,  1709,  1714,  1717,  1724,  1725,  1736,  1737,  1740, 
 1741,  1746,  1749,  1750,  1753,  1754,  1757,  1760,  1763,  1764, 
 1765,  1766,  1767,  1768,  1771,  1776,  1777,  1782,  1783,  1786, 
 1789,  1790,  1793,  1794,  1795,  1796,  1797,  1798,  1799, 
0
};
static	unsigned short	yyStartLine	[yyLastStopState - yyFirstReduceState
							+ 2] = { 0,
327,
};
# ifdef YYaccDefault

static	unsigned long *	yyDefaultLook	[yyLastReadState + 1] = { 0,
};
# endif

static	int	yyParse			ARGS ((yyStateRange yyStartSymbol,
				yySymbolRange yyToken, int yyLine));

# ifndef NO_RECOVER
static	yyStateRange yyNext		ARGS ((yyStateRange yyState,
				yySymbolRange yySymbol));
static	void	yyErrorRecovery		ARGS ((yySymbolRange * yyTerminal,
				yyStateRange * yyStateStack, short yyStackPtr));
static	void	yyComputeContinuation	ARGS ((yyStateRange * yyStack,
				short yyStackPtr, tSet * yyContinueSet, rbool));
static	rbool	yyIsContinuation	ARGS ((yySymbolRange yyTerminal,
				yyStateRange * yyStateStack, short yyStackPtr,
				rbool));
static	void	yyComputeRestartPoints	ARGS ((yyStateRange * yyStateStack,
				short yyStackPtr, tSet * yyRestartSet));
# endif

# if defined YYTrialParse | defined YYReParse | defined YYGetLook

# ifndef yyInitBufferSize
# define yyInitBufferSize 100
# endif
# ifndef TOKENOP
# define TOKENOP
# endif
# ifndef BEFORE_TRIAL
# define BEFORE_TRIAL
# endif
# ifndef AFTER_TRIAL
# define AFTER_TRIAL
# endif

typedef struct { yySymbolRange	yyToken;
		 tScanAttribute	yyAttribute;
# ifdef YYMemoParse
		 short		yyStart;
# endif
	       } yytBuffer;

static yytBuffer *	yyBuffer	;
static unsigned long	yyBufferSize	= yyInitBufferSize;
static long		yyBufferNext	= 1;
static long		yyBufferLast	= 1;
static rbool		yyBufferClear	= rtrue;
static unsigned short	yyParseLevel	= 0;

static void yyBufferSet
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange yyToken)
# else
   (yyToken) yySymbolRange yyToken;
# endif
{
   if (yyBufferNext == yyBufferLast) {
      if (yyBufferClear) yyBufferLast = 0;
      if (++ yyBufferLast >= (long) yyBufferSize) {
	 ExtendArray ((char * *) & yyBuffer, & yyBufferSize,
			  (unsigned long) sizeof (yytBuffer));
# ifdef YYDEBUG
	 if (Debug) {
	    yyPrintState (0);
	    (void) fprintf (yyTrace, "extend  token buffer from %ld to %ld",
		yyBufferSize / 2, yyBufferSize); yyNl ();
	 }
# endif
      }
      yyBuffer [yyBufferLast].yyToken	= yyToken;
      yyBuffer [yyBufferLast].yyAttribute= Attribute;
# ifdef YYMemoParse
      yyBuffer [yyBufferLast].yyStart	= 0;
# endif
      yyBufferNext = yyBufferLast;
   }
}

static int yyGetToken ARGS ((void))
{
   register yySymbolRange yyToken;

   if (yyBufferNext < yyBufferLast) {
      yyToken = yyBuffer [++ yyBufferNext].yyToken;
      Attribute = yyBuffer [yyBufferNext].yyAttribute;
   } else {
      yyToken = GetToken ();
      if ((yytrial | yybuffer) & yyControl.yyMode) {
	 if (++ yyBufferLast >= (long) yyBufferSize) {
	    ExtendArray ((char * *) & yyBuffer, & yyBufferSize,
			     (unsigned long) sizeof (yytBuffer));
# ifdef YYDEBUG
	    if (Debug) {
	       yyPrintState (0);
	       (void) fprintf (yyTrace, "extend  token buffer from %ld to %ld",
		  yyBufferSize / 2, yyBufferSize); yyNl ();
	    }
# endif
	 }
	 yyBuffer [yyBufferLast].yyToken = yyToken;
	 yyBuffer [yyBufferLast].yyAttribute = Attribute;
# ifdef YYMemoParse
	 yyBuffer [yyBufferLast].yyStart = 0;
# endif
	 yyBufferNext = yyBufferLast;
      }
   }
   TOKENOP
   return yyToken;
}

# else
# define yyGetToken GetToken
# endif

# ifdef YYGetLook

static int yyGetLookahead
# if defined __STDC__ | defined __cplusplus
   (int yyk, yySymbolRange yyToken)
# else
   (yyk, yyToken) int yyk; yySymbolRange yyToken;
# endif
{
   if (yyk == 0) return yyToken;
   if (yyControl.yyMode == yystandard) yyBufferSet (yyToken);
   while (yyBufferNext + yyk > yyBufferLast) {
      if (yyBuffer [yyBufferLast].yyToken == EofToken) return EofToken;
      if (++ yyBufferLast >= (long) yyBufferSize) {
	 ExtendArray ((char * *) & yyBuffer, & yyBufferSize,
			  (unsigned long) sizeof (yytBuffer));
# ifdef YYDEBUG
	 if (Debug) {
	    yyPrintState (0);
	    (void) fprintf (yyTrace, "extend  token buffer from %ld to %ld",
	       yyBufferSize / 2, yyBufferSize); yyNl ();
	 }
# endif
      }
      yyBuffer [yyBufferLast].yyToken = GetToken ();
      yyBuffer [yyBufferLast].yyAttribute = Attribute;
# ifdef YYMemoParse
      yyBuffer [yyBufferLast].yyStart = 0;
# endif
   }
   Attribute = yyBuffer [yyBufferNext].yyAttribute;
   return yyBuffer [yyBufferNext + yyk].yyToken;
}

static void xxGetAttribute
# if defined __STDC__ | defined __cplusplus
   (int yyk, yySymbolRange yyToken, tScanAttribute * yyAttribute)
# else
   (yyk, yyToken, yyAttribute)
   int yyk; yySymbolRange yyToken; tScanAttribute * yyAttribute;
# endif
{
   if (yyk == 0) * yyAttribute = Attribute;
   else {
      (void) yyGetLookahead (yyk, yyToken);
      * yyAttribute =
	 yyBuffer [Min (yyBufferNext + yyk, yyBufferLast)].yyAttribute;
   }
}

# endif

# ifdef YYReParse

# define BufferOn(Actions, Messages) yyBufferOn (Actions, Messages, yyTerminal)
# define BufferPosition	yyBufferNext

static yytControl yyPrevControl;

static long yyBufferOn
# if defined __STDC__ | defined __cplusplus
   (rbool yyActions, rbool yyMessages, yySymbolRange yyToken)
# else
   (yyActions, yyMessages, yyToken)
   rbool yyActions, yyMessages; yySymbolRange yyToken;
# endif
{
   if (yyControl.yyMode == yystandard) {
      yyPrevControl		= yyControl;
      yyControl.yyMode		= yybuffer;
      yyControl.yyActions	= yyActions;
      yyControl.yyMessages	= yyMessages;
      yyBufferSet (yyToken);
      yyBufferClear		= rfalse;
   }
   return yyBufferNext;
}

static long BufferOff ARGS ((void))
{
   if (yyControl.yyMode == yybuffer) yyControl = yyPrevControl;
   return yyBufferNext;
}

static void BufferClear ARGS ((void))
{
   yyBufferClear = rtrue;
}

# endif

# if defined YYDEBUG | defined YYDCRP

static void yyNl ARGS ((void))
{ (void) putc ('\n', yyTrace); (void) fflush (yyTrace); }

# endif

# ifdef YYDEBUG

static void yyPrintState
# if defined __STDC__ | defined __cplusplus
   (yyStateRange yyState)
# else
   (yyState) yyStateRange yyState;
# endif
{
   (void) fprintf (yyTrace, "%4ld:", ++ yyCount);
   WritePosition  (yyTrace, Attribute.Position);
   (void) fprintf (yyTrace, ":%5d  %c  ", yyState,
      " ST-B---R" [yyControl.yyMode]);
# if defined YYTrialParse | defined YYReParse
   if (yyParseLevel > 0) {
      register int yyi = yyParseLevel;
      (void) fprintf (yyTrace, "%2d  ", yyi);
      do (void) fputs ("  ", yyTrace); while (-- yyi);
   } else
# endif
   (void) fputs ("    ", yyTrace);
}

static rbool yyPrintResult
# if defined __STDC__ | defined __cplusplus
   (yyStateRange yyState, int yyLine, rbool yyCondition)
# else
   (yyState, yyLine, yyCondition)
   yyStateRange	yyState;
   int		yyLine;
   rbool	yyCondition;
# endif
{
   if (Debug) {
      yyPrintState (yyState);
      (void) fprintf (yyTrace, "check   predicate in line %d, result = %d",
	 yyLine, yyCondition); yyNl ();
   }
   return yyCondition;
}

# else
# define yyPrintResult(State, Line, Condition) Condition
# endif

# if defined YYDEBUG | defined YYDEC_TABLE
# define yyGotoReduce(State, Rule)	{ yyState = State; goto yyReduce; }
# define yyGotoRead(State)		{ yyState = State; goto yyRead; }
# else
# define yyGotoReduce(State, Rule)	goto Rule;
# define yyGotoRead(State)		{ yyState = State; goto yyRead; }
# endif

static unsigned long	yyStateStackSize	= yyInitStackSize;
static yyStateRange *	yyStateStack		;
static yyStateRange *	yyEndOfStack		;
static unsigned long	yyAttrStackSize 	= yyInitStackSize;
static tParsAttribute * yyAttributeStack	;
# if defined YYTrialParse | defined YYReParse
static yyStateRange *	yyStateStackPtr 	;
static tParsAttribute * yyAttrStackPtr		;
# endif
static yyStateRange *	yyIsContStackPtr	;
static unsigned long	yyIsContStackSize	= yyInitStackSize;
static yyStateRange *	yyCompResStackPtr	;
static unsigned long	yyCompResStackSize	= yyInitStackSize;

int Parser ARGS ((void))
   {
      return Parser2 (yyStartState);
   }

int Parser2
# if defined __STDC__ | defined __cplusplus
   (int yyStartSymbol)
# else
   (yyStartSymbol) int yyStartSymbol;
# endif
   {
      int		yyErrorCount;
# if defined YYDEBUG | defined YYDCRP
      yyTrace		= stdout;
# endif
      BeginParser ();
      MakeArray ((char * *) & yyStateStack, & yyStateStackSize,
		     (unsigned long) sizeof (yyStateRange));
      MakeArray ((char * *) & yyAttributeStack, & yyAttrStackSize,
		     (unsigned long) sizeof (tParsAttribute));
      MakeArray ((char * *) & yyIsContStackPtr, & yyIsContStackSize,
		     (unsigned long) sizeof (yyStateRange));
      MakeArray ((char * *) & yyCompResStackPtr, & yyCompResStackSize,
		     (unsigned long) sizeof (yyStateRange));
# if defined YYTrialParse | defined YYReParse | defined YYGetLook
      MakeArray ((char * *) & yyBuffer, & yyBufferSize,
		     (unsigned long) sizeof (yytBuffer));
# endif
      yyEndOfStack	= & yyStateStack [yyStateStackSize - 1];
# if defined YYTrialParse | defined YYReParse
      yyStateStackPtr	= yyStateStack;
      yyAttrStackPtr	= yyAttributeStack;
      yyBufferNext	= 1;
      yyBufferLast	= 1;
      yyParseLevel	= 0;
# endif
# ifdef YYDEBUG
      if (Debug) {
	 (void) fprintf (yyTrace,
      "  # |Position|State|Mod|Lev|Action |Terminal and Lookahead or Rule\n");
	 yyNl ();
      }
# endif
      yyControl.yyMode		= yystandard;
      yyControl.yyActions	= rtrue;
      yyControl.yyMessages	= rtrue;
      yyErrorCount = yyParse ((yyStateRange) yyStartSymbol,
	 (yySymbolRange) yyGetToken (), (int) yyStartLine [yyStartSymbol]);
      ReleaseArray ((char * *) & yyStateStack, & yyStateStackSize,
			(unsigned long) sizeof (yyStateRange));
      ReleaseArray ((char * *) & yyAttributeStack, & yyAttrStackSize,
			(unsigned long) sizeof (tParsAttribute));
      ReleaseArray ((char * *) & yyIsContStackPtr, & yyIsContStackSize,
			(unsigned long) sizeof (yyStateRange));
      ReleaseArray ((char * *) & yyCompResStackPtr, & yyCompResStackSize,
			(unsigned long) sizeof (yyStateRange));
# if defined YYTrialParse | defined YYReParse | defined YYGetLook
      ReleaseArray ((char * *) & yyBuffer, & yyBufferSize,
			(unsigned long) sizeof (yytBuffer));
# endif
      return yyErrorCount;
   }

# ifdef YYTrialParse

# ifdef YYMemoParse
# define MemoryClear(Position) yyBuffer [Position].yyStart = 0
# endif

static int yyTrialParse
# if defined __STDC__ | defined __cplusplus
   (yyStateRange yyStartSymbol, yySymbolRange yyToken, int yyLine)
# else
   (yyStartSymbol, yyToken, yyLine)
   yyStateRange		yyStartSymbol	;
   yySymbolRange	yyToken		;
   int			yyLine		;
# endif
   {
      int	yyErrorCount		;
      unsigned long yyPrevStateStackPtr	= yyStateStackPtr - yyStateStack;
      unsigned long yyPrevAttrStackPtr	= yyAttrStackPtr - yyAttributeStack;
      long	yyPrevBufferNext	;
      yytControl yyPrevControl		;

      BEFORE_TRIAL
# ifdef YYMemoParse
      if (yyBuffer [yyBufferNext].yyStart ==   yyStartSymbol) return 0;
      if (yyBuffer [yyBufferNext].yyStart == - yyStartSymbol) return 1;
# endif
      yyPrevControl		= yyControl;
      yyStateStackPtr		++;
      yyAttrStackPtr		++;
      yyParseLevel		++;
      if (yyControl.yyMode == yystandard) yyBufferSet (yyToken);
      yyPrevBufferNext		= yyBufferNext;
      yyControl.yyMode		= yytrial;
      yyControl.yyActions	= rfalse;
      yyControl.yyMessages	= rfalse;
      yyErrorCount		= yyParse (yyStartSymbol, yyToken, yyLine);
# ifdef YYMemoParse
      yyBuffer [yyPrevBufferNext].yyStart = yyErrorCount ?
					- yyStartSymbol : yyStartSymbol;
# endif
      yyStateStackPtr		= yyStateStack + yyPrevStateStackPtr;
      yyAttrStackPtr		= yyAttributeStack + yyPrevAttrStackPtr;
      yyBufferNext		= yyPrevBufferNext;
      yyControl			= yyPrevControl;
      yyParseLevel		--;
      Attribute		= yyBuffer [yyBufferNext].yyAttribute;
      AFTER_TRIAL
      return yyErrorCount;
   }

# endif

# ifdef YYReParse

static int ReParse
# if defined __STDC__ | defined __cplusplus
   (yyStateRange yyStartSymbol, int yyFrom, int yyTo, rbool yyActions,
      rbool yyMessages)
# else
   (yyStartSymbol, yyFrom, yyTo, yyActions, yyMessages)
   yyStateRange	yyStartSymbol		;
   int		yyFrom, yyTo		;
   rbool	yyActions, yyMessages	;
# endif
   {
      int yyErrorCount = 1;

      if (1 <= yyFrom && yyFrom <= yyTo && yyTo <= yyBufferLast) {
	 unsigned long yyPrevStateStackPtr = yyStateStackPtr - yyStateStack;
	 unsigned long yyPrevAttrStackPtr = yyAttrStackPtr - yyAttributeStack;
	 long	yyPrevBufferNext	= yyBufferNext;
	 int	yyToToken		= yyBuffer [yyTo].yyToken;
	 yytControl yyPrevControl	;

	 yyPrevControl		= yyControl;
	 yyStateStackPtr	++;
	 yyAttrStackPtr		++;
	 yyParseLevel		++;
	 yyBufferNext		= yyFrom - 1;
	 yyBuffer [yyTo].yyToken= EofToken;
	 yyControl.yyMode	= yyreparse;
	 yyControl.yyActions	= yyActions;
	 yyControl.yyMessages	= yyMessages;
	 yyErrorCount		= yyParse (yyStartSymbol,
	    (yySymbolRange) yyGetToken (), (int) yyStartLine [yyStartSymbol]);
	 yyStateStackPtr	= yyStateStack + yyPrevStateStackPtr;
	 yyAttrStackPtr		= yyAttributeStack + yyPrevAttrStackPtr;
	 yyBufferNext		= yyPrevBufferNext;
	 yyControl		= yyPrevControl;
	 yyParseLevel		--;
	 yyBuffer [yyTo].yyToken= yyToToken;
	 Attribute		= yyBuffer [yyBufferNext].yyAttribute;
      } else {
      Message ("invalid call of ReParse", xxError, Attribute.Position);
      }
      return yyErrorCount;
   }

# endif

static char * yyGetTokenName
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange yyTerminal)
# else
   (yyTerminal) yySymbolRange yyTerminal;
# endif
   {
      if (yyTerminal <= yyLastTerminal && TokenName [yyTerminal])
         return TokenName [yyTerminal];
      else
         return "_unknown_";
   }

static int yyParse
# if defined __STDC__ | defined __cplusplus
   (yyStateRange yyStartSymbol, yySymbolRange yyToken, int yyLine)
# else
   (yyStartSymbol, yyToken, yyLine)
   yyStateRange		yyStartSymbol	;
   yySymbolRange	yyToken		;
   int			yyLine		;
# endif
   {
      register	yyStateRange	yyState		= yyStartSymbol;
      register	yySymbolRange	yyTerminal	= yyToken;
      register	rbool		yyIsRepairing	= rfalse;
		tParsAttribute	yySynAttribute	;   /* synthesized attribute */
		int		yyErrorCount	= 0;
# if ! (defined YYTrialParse | defined YYReParse)
      register	yyStateRange *	yyStateStackPtr	= yyStateStack;
      register	tParsAttribute *yyAttrStackPtr	= yyAttributeStack;
# endif
# ifdef YYDEBUG
		long		yyStartCount	= yyCount + 1;
		yySymbolRange	yyPrevTerminal	= yyToken;
# endif
# ifdef YYGetLook
		yySymbolRange	yy2;
# endif

/* line 64 "fortran.lalr" */

#include "Tree.h"
#include <stdio.h>

char Word [256];

tTree global_objects, 
      global_groups;     /* used for COMMON, NAMELIST */



# ifdef YYDEBUG
      if (Debug) {
	 yyPrintState (yyStartSymbol);
	 (void) fprintf (yyTrace,
	    "parse   for predicate in line %d, lookahead: %s", yyLine,
	    yyGetTokenName (yyTerminal)); yyNl ();
      }
# endif

   yyParseLoop:
      for (;;) {
	 if (yyStateStackPtr >= yyEndOfStack) {
	    unsigned long yyyStateStackPtr = yyStateStackPtr - yyStateStack;
	    unsigned long yyyAttrStackPtr = yyAttrStackPtr - yyAttributeStack;
	    ExtendArray ((char * *) & yyStateStack, & yyStateStackSize,
			     (unsigned long) sizeof (yyStateRange));
	    ExtendArray ((char * *) & yyAttributeStack, & yyAttrStackSize,
			     (unsigned long) sizeof (tParsAttribute));
	    yyStateStackPtr	= yyStateStack + yyyStateStackPtr;
	    yyAttrStackPtr	= yyAttributeStack + yyyAttrStackPtr;
	    yyEndOfStack	= & yyStateStack [yyStateStackSize - 1];
# ifdef YYDEBUG
	    if (Debug) {
	       yyPrintState (yyState);
	       (void) fprintf (yyTrace, "extend  stack from %ld to %ld",
		  yyStateStackSize / 2, yyStateStackSize); yyNl ();
	    }
# endif
	 }
	 * yyStateStackPtr = yyState;

   yyTermTrans:
	 for (;;) { /* SPEC State = Next (State, Terminal); terminal transit */
	    register yytComb * yyTCombPtr = yyTBasePtr [yyState] + yyTerminal;
# if defined YYTDefault & defined YYaccDefault
	    register unsigned long * yylp;
# endif
	    if (yyTCombPtr->Check == yyState) {
	       yyState = yyTCombPtr->Next; break;
	    }
# ifdef YYTDefault
#    ifdef YYaccDefault
	    if ((yylp = yyDefaultLook [yyState]) &&
	       (yylp [yyTerminal >> 5] >> (yyTerminal & 0x1f)) & 1) {
	       yyState = yyTDefault [yyState]; break;
	    }
#    else
	    if ((yyState = yyTDefault [yyState]) != yyNoState) goto yyTermTrans;
#    endif
# endif

							/* syntax error */
	    if (! yyIsRepairing) {			/* report and recover */
	       yySymbolRange yyyTerminal = (yySymbolRange) yyTerminal;

# ifdef YYTrialParse
	       if (yyControl.yyMode == yytrial) YYABORT;
# endif
	       ERROR
# ifndef NO_RECOVER
	       yyErrorCount ++;
	       yyErrorRecovery (& yyyTerminal, yyStateStack,
				yyStateStackPtr - yyStateStack);
	       yyTerminal = yyyTerminal;
	       yyIsRepairing = rtrue;
# else
	       YYABORT;
# endif
	    }
# ifndef NO_RECOVER
	    yyState = * yyStateStackPtr;
	    for (;;) {
	       yySymbolRange	yyRepairToken;
	       tScanAttribute	yyRepairAttribute;
	       yyStateRange	yyNextState =
	          yyNext (yyState, (yySymbolRange) yyTerminal);
	       if (yyNextState != yyNoState &&	/* read or read reduce ? */
		   yyNextState <= yyLastReadReduceState) {
		  yyState = yyNextState;	/* restart point reached */
		  yyIsRepairing = rfalse;	/* stop error recovery */
		  goto yyFinal;
	       }
	       yyRepairToken = yyContinuation [yyState];	/* repair */
	       yyState = yyNext (yyState, yyRepairToken);
	       if (yyState > yyLastReduceState) {		/* dynamic ? */
		  yyState = yyCondition [yyState - yyLastReduceState];
	       }
	       if (yyState <= yyLastReadReduceState) {
						/* read or read reduce ? */
		  ErrorAttribute ((int) yyRepairToken,
					& yyRepairAttribute);
		  if (yyControl.yyMessages)
		     ErrorMessageI (xxTokenInserted, xxRepair,
			Attribute.Position, xxString,
			yyGetTokenName (yyRepairToken));
# ifdef YYDEBUG
		  if (Debug) {
		     yyPrintState (* yyStateStackPtr);
		     (void) fprintf (yyTrace, "insert  %s",
			yyGetTokenName (yyRepairToken)); yyNl ();
		     yyPrintState (* yyStateStackPtr);
		     (void) fprintf (yyTrace, "shift   %s, lookahead: %s",
			yyGetTokenName (yyRepairToken),
			yyGetTokenName (yyTerminal)); yyNl ();
		  }
# endif
		  if (yyState >= yyFirstFinalState) { /* avoid second push */
		     yyState =
			yyFinalToProd [yyState - yyFirstReadReduceState];
		  }
		  yyGetAttribute (yyAttrStackPtr ++, yyRepairAttribute);
		  * ++ yyStateStackPtr = yyState;
	       }
	       if (yyState >= yyFirstFinalState) goto yyFinal;
							/* final state ? */
	    }
# endif
	 }

   yyFinal:
	 if (yyState >= yyFirstFinalState) {		/* final state ? */
	    if (yyState <= yyLastReadReduceState) {	/* read reduce ? */
	       yyStateStackPtr ++;
	       yyGetAttribute (yyAttrStackPtr ++, Attribute);
	       yyTerminal = yyGetToken ();
# ifdef YYDEBUG
	       if (Debug) {
		  yyStateStackPtr [0] = yyStateStackPtr [-1];
		  yyPrintState (* yyStateStackPtr);
		  (void) fprintf (yyTrace, "shift   %s, lookahead: %s",
		     yyGetTokenName (yyPrevTerminal),
		     yyGetTokenName (yyTerminal)); yyNl ();
		  yyPrevTerminal = yyTerminal;
	       }
# endif
	       yyIsRepairing = rfalse;
	    }

	    for (;;) {
	       register yytNonterminal yyNonterminal;	/* left-hand side */

   yyReduce:
# ifdef YYDEBUG
	       if (Debug) {
		  if (yyState <= yyLastReadReduceState)	/* read reduce ? */
		     yyState = yyFinalToProd [yyState - yyFirstReadReduceState];
		  yyPrintState (* yyStateStackPtr);
		  if (yyState <= yyLastReduceState) {
		     (void) fprintf (yyTrace, "reduce  %s",
			yyRule [yyState - yyLastReadReduceState]); yyNl ();
		  } else {
		     (void) fprintf (yyTrace, "dynamic decision %d",
			yyState - yyLastReduceState); yyNl ();
		  }
	       }
# endif
# ifdef YYDEC_TABLE
	       if (yyLastStopState < yyState && yyState <= yyLastReduceState) {
		  register int yyd = yyLength [yyState - yyFirstReduceState];
		  yyStateStackPtr -= yyd;
		  yyAttrStackPtr  -= yyd;
		  yyNonterminal = yyLeftHandSide [yyState - yyFirstReduceState];
	       }
# endif
switch (yyState) {
case 1009:
YYACCEPT;
case 1010: /* fortran : CR0 program_units */
yyDecrement (2) yySetNT (yyNTfortran) {
/* line 329 "fortran.lalr" */
 TreeRoot = mCOMP_UNIT (yyA [1].Tree, mUNIT_EMPTY());
       if (verbose_flag)
          printf ("Compilation ready\n");  
     
} break;
case 1011: /* CR1 : NewLine CR0 */
yyDecrement (2) yySetNT (yyNTCR1) {
} break;
case 1012: /* CR0 : */
yySetNT (yyNTCR0) {
} break;
case 1013: /* CR0 : NewLine CR0 */
yyDecrement (2) yySetNT (yyNTCR0) {
} break;
case 1014:
case 820: /* PIdent : Ident */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 348 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan;
       yyS.Label = NLine(yyA [0]); 
} break;
case 1015:
case 821: /* PIdent : IN */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 353 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("IN");
       yyS.Label = NLine(yyA [0]); 
} break;
case 1016:
case 822: /* PIdent : OUT */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 357 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("OUT");
       yyS.Label = NLine(yyA [0]); 
} break;
case 1017:
case 823: /* PIdent : INOUT */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 361 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("INOUT");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1018:
case 824: /* PIdent : ALLOCATABLE1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 365 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("ALLOCATABLE");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1019:
case 825: /* PIdent : DIMENSION1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 369 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("DIMENSION");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1020:
case 826: /* PIdent : PARAMETER1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 373 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("PARAMETER");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1021:
case 827: /* PIdent : INTENT1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 377 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("INTENT");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1022:
case 828: /* PIdent : EXTERNAL1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 381 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("EXTERNAL");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1023:
case 829: /* PIdent : INTRINSIC1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 385 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("INTRINSIC");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1024:
case 830: /* PIdent : OPTIONAL1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 389 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("OPTIONAL");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1025:
case 831: /* PIdent : LAYOUT1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 393 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("LAYOUT");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1026:
case 832: /* PIdent : PASS_BY1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 397 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("PASS_BY");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1027:
case 833: /* PIdent : MAP_TO1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 401 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("MAP_TO");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1028:
case 834: /* PIdent : POINTER1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 405 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("POINTER");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1029:
case 835: /* PIdent : SAVE1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 409 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("SAVE");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1030:
case 836: /* PIdent : TARGET1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 413 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("TARGET");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1031:
case 837: /* PIdent : DATA1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 417 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("DATA");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1032:
case 838: /* PIdent : PUBLIC1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 421 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("PUBLIC");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1033:
case 839: /* PIdent : PRIVATE1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 425 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("PRIVATE");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1034:
case 840: /* PIdent : SEQUENCE1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 429 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("SEQUENCE");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1035:
case 841: /* PIdent : ARRAY1 */
yyDecrement (1) yySetNT (yyNTPIdent) {
/* line 433 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("ARRAY");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1036:
case 842: /* HPFIdent : Ident */
yyDecrement (1) yySetNT (yyNTHPFIdent) {
/* line 443 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan;
       yyS.Label = NLine(yyA [0]); 
} break;
case 1037:
case 843: /* HPFIdent : NEW */
yyDecrement (1) yySetNT (yyNTHPFIdent) {
/* line 447 "fortran.lalr" */
 yyS.Scan = yyA [0].Scan; yyS.Scan.Ident = IsIdent ("NEW");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1038: /* opt_comma : */
yySetNT (yyNTopt_comma) {
} break;
case 1039:
case 844: /* opt_comma : ',' */
yyDecrement (1) yySetNT (yyNTopt_comma) {
} break;
case 1040: /* opt_dcolon : */
yySetNT (yyNTopt_dcolon) {
} break;
case 1041:
case 845: /* opt_dcolon : '::' */
yyDecrement (1) yySetNT (yyNTopt_dcolon) {
} break;
case 1042: /* opt_label : */
yySetNT (yyNTopt_label) {
/* line 458 "fortran.lalr" */
 yyS.Label = GetTheLabel (); 
} break;
case 1043: /* opt_ident : */
yySetNT (yyNTopt_ident) {
} break;
case 1044: /* opt_ident : PIdent */
yyDecrement (1) yySetNT (yyNTopt_ident) {
} break;
case 1045: /* program_units : program_unit */
yyDecrement (1) yySetNT (yyNTprogram_units) {
/* line 471 "fortran.lalr" */
 yyS.Tree = mUNIT_LIST (yyA [0].Tree, mUNIT_EMPTY()); 
} break;
case 1046: /* program_units : program_unit program_units */
yyDecrement (2) yySetNT (yyNTprogram_units) {
/* line 475 "fortran.lalr" */
 yyS.Tree = mUNIT_LIST (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1047: /* program_unit : main_program */
yyDecrement (1) yySetNT (yyNTprogram_unit) {
/* line 479 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1048: /* program_unit : subroutine_subprogram */
yyDecrement (1) yySetNT (yyNTprogram_unit) {
/* line 483 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1049: /* program_unit : function_subprogram */
yyDecrement (1) yySetNT (yyNTprogram_unit) {
/* line 487 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1050: /* program_unit : block_data */
yyDecrement (1) yySetNT (yyNTprogram_unit) {
/* line 491 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1051: /* program_unit : module */
yyDecrement (1) yySetNT (yyNTprogram_unit) {
/* line 495 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1052: /* main_program : block CR0 */
yyDecrement (2) yySetNT (yyNTmain_program) {
/* line 506 "fortran.lalr" */
 yyS.Tree = mPROGRAM_DECL (IsIdent ("no_name"), 0,
                 mDECL_EMPTY (), yyA [0].Tree); 
       InitLabels ();
     
} break;
case 1053: /* main_program : program_definition block program_token \
CR1 */
yyDecrement (4) yySetNT (yyNTmain_program) {
/* line 516 "fortran.lalr" */
 yyA [0].Tree->PROGRAM_DECL.PROGRAM_BODY = yyA [1].Tree; 
       yyS.Tree = yyA [0].Tree; 
       InitLabels ();
       CheckSameIdent (yyA [0].Tree->PROGRAM_DECL.Ident, yyA [2].Label);
     
} break;
case 1054: /* program_definition : PROGRAM PIdent dummy_arguments CR1 */
yyDecrement (4) yySetNT (yyNTprogram_definition) {
/* line 525 "fortran.lalr" */
 yyS.Tree = mPROGRAM_DECL (yyA [1].Scan.Ident, yyA [1].Label, yyA [2].Tree, NoTree); 
} break;
case 1055: /* program_token : PROGRAM PIdent */
yyDecrement (2) yySetNT (yyNTprogram_token) {
/* line 530 "fortran.lalr" */
 yyS.Label = yyA [1].Scan.Ident; 
} break;
case 1056: /* program_token : PROGRAM */
yyDecrement (1) yySetNT (yyNTprogram_token) {
/* line 534 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1057: /* program_token : */
yySetNT (yyNTprogram_token) {
/* line 538 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1058: /* module : MODULE PIdent CR1 block module_token CR1 */
yyDecrement (6) yySetNT (yyNTmodule) {
/* line 551 "fortran.lalr" */
 yyS.Tree = mMODULE_DECL (yyA [1].Scan.Ident, yyA [1].Label, yyA [3].Tree); 
       CheckSameIdent (yyA [1].Scan.Ident, yyA [4].Label);
     
} break;
case 1059: /* module_token : MODULE PIdent */
yyDecrement (2) yySetNT (yyNTmodule_token) {
/* line 558 "fortran.lalr" */
 yyS.Label = yyA [1].Scan.Ident; 
} break;
case 1060: /* module_token : MODULE */
yyDecrement (1) yySetNT (yyNTmodule_token) {
/* line 562 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1061: /* module_token : */
yySetNT (yyNTmodule_token) {
/* line 566 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1062: /* subroutine_subprogram : subroutine_definition block \
subroutine_token CR1 */
yyDecrement (4) yySetNT (yyNTsubroutine_subprogram) {
/* line 578 "fortran.lalr" */
 yyA [0].Tree->PROC_DECL.PROC_BODY = yyA [1].Tree; 
       yyS.Tree = yyA [0].Tree; 
       InitLabels ();
       CheckSameIdent (yyA [0].Tree->PROC_DECL.Ident, yyA [2].Label);
     
} break;
case 1063: /* subroutine_definition : prefix SUBROUTINE PIdent \
dummy_arguments CR1 */
yyDecrement (5) yySetNT (yyNTsubroutine_definition) {
/* line 587 "fortran.lalr" */
 yyS.Tree = mPROC_DECL (yyA [2].Scan.Ident, yyA [2].Label, 
                             yyA [3].Tree, NoTree); 

       yyS.Tree->PROC_DECL.IsRecursive  = (yyA [0].Label & 16);
       yyS.Tree->PROC_DECL.IsPure       = (yyA [0].Label & 8 );
       yyS.Tree->PROC_DECL.HPFExtrinsic = yyA [0].Line;
     
} break;
case 1064: /* subroutine_token : SUBROUTINE PIdent */
yyDecrement (2) yySetNT (yyNTsubroutine_token) {
/* line 598 "fortran.lalr" */
 yyS.Label = yyA [1].Scan.Ident; 
} break;
case 1065: /* subroutine_token : SUBROUTINE */
yyDecrement (1) yySetNT (yyNTsubroutine_token) {
/* line 602 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1066: /* subroutine_token : */
yySetNT (yyNTsubroutine_token) {
/* line 606 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1067: /* function_subprogram : function_definition block \
function_token CR1 */
yyDecrement (4) yySetNT (yyNTfunction_subprogram) {
/* line 619 "fortran.lalr" */
 yyA [0].Tree->FUNC_DECL.FUNC_BODY = yyA [1].Tree; 
       yyS.Tree = yyA [0].Tree;
       InitLabels ();
       CheckSameIdent (yyA [0].Tree->FUNC_DECL.Ident, yyA [2].Label);
     
} break;
case 1068: /* function_token : FUNCTION PIdent */
yyDecrement (2) yySetNT (yyNTfunction_token) {
/* line 628 "fortran.lalr" */
 yyS.Label = yyA [1].Scan.Ident; 
} break;
case 1069: /* function_token : FUNCTION */
yyDecrement (1) yySetNT (yyNTfunction_token) {
/* line 632 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1070: /* function_token : */
yySetNT (yyNTfunction_token) {
/* line 636 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1071: /* function_definition : prefix FUNCTION PIdent \
dummy_arguments function_result CR1 */
yyDecrement (6) yySetNT (yyNTfunction_definition) {
/* line 641 "fortran.lalr" */
 yyS.Tree = mFUNC_DECL (yyA [2].Scan.Ident, yyA [2].Label,  /* name, pos */
                             yyA [3].Tree,     /* formals */
                             NoTree,      /* body is set later */
                             yyA [0].Tree,     /* result_type */
                             yyA [4].Line > 0, /* has_res_id  */
                             yyA [4].Label);   /* result_id   */ 

       yyS.Tree->FUNC_DECL.IsRecursive  = (yyA [0].Label & 16);
       yyS.Tree->FUNC_DECL.IsPure       = (yyA [0].Label & 8 );
       yyS.Tree->FUNC_DECL.HPFExtrinsic = yyA [0].Line;   
     
} break;
case 1072: /* function_result : */
yySetNT (yyNTfunction_result) {
/* line 655 "fortran.lalr" */
 yyS.Label = DefaultId (); 
       yyS.Line  = 0;
     
} break;
case 1073:
case 846: /* function_result : RESULT '(' PIdent ')' */
yyDecrement (4) yySetNT (yyNTfunction_result) {
/* line 661 "fortran.lalr" */
 yyS.Label = yyA [2].Scan.Ident;
       yyS.Line  = 1;
     
} break;
case 1074: /* prefix : */
yySetNT (yyNTprefix) {
/* line 669 "fortran.lalr" */
 yyS.Tree = mDUMMY_TYPE (); 
       yyS.Label = 0;      /* is nothing */    
       yyS.Line  = DefaultId();    /* no EXTRINSIC */
     
} break;
case 1075: /* prefix : type_spec prefix */
yyDecrement (2) yySetNT (yyNTprefix) {
/* line 676 "fortran.lalr" */
 yyS.Tree  = yyA [0].Tree; 
       yyS.Label = yyA [1].Label;
       yyS.Line  = yyA [1].Line;
     
} break;
case 1076: /* prefix : RECURSIVE prefix */
yyDecrement (2) yySetNT (yyNTprefix) {
/* line 684 "fortran.lalr" */
 yyS.Tree  = yyA [1].Tree; 
       yyS.Label = (yyA [1].Label | 16) ;
       yyS.Line  = yyA [1].Line;
     
} break;
case 1077: /* prefix : PURE prefix */
yyDecrement (2) yySetNT (yyNTprefix) {
/* line 692 "fortran.lalr" */
 yyS.Tree  = yyA [1].Tree;
       yyS.Label = (yyA [1].Label |  8);
       yyS.Line  = yyA [1].Line;
     
} break;
case 1078: /* prefix : EXTRINSIC '(' extrinsic_spec ')' prefix */
yyDecrement (5) yySetNT (yyNTprefix) {
/* line 700 "fortran.lalr" */
 yyS.Tree  = yyA [4].Tree;
       yyS.Label = yyA [4].Label;
       yyS.Line  = yyA [2].Line;
     
} break;
case 1079: /* extrinsic_spec : extrinsic_kind_keyword */
yyDecrement (1) yySetNT (yyNTextrinsic_spec) {
/* line 716 "fortran.lalr" */
 yyS.Line = yyA [0].Line; 
} break;
case 1080: /* extrinsic_spec : extrinsic_spec_arg_list */
yyDecrement (1) yySetNT (yyNTextrinsic_spec) {
/* line 720 "fortran.lalr" */
 yyS.Line = DecodeExtrinsic (yyA [0].Line); 
} break;
case 1081: /* extrinsic_spec_arg_list : extrinsic_spec_arg */
yyDecrement (1) yySetNT (yyNTextrinsic_spec_arg_list) {
/* line 724 "fortran.lalr" */
 yyS.Line = yyA [0].Line; 
} break;
case 1082: /* extrinsic_spec_arg_list : extrinsic_spec_arg ',' \
extrinsic_spec_arg_list */
yyDecrement (3) yySetNT (yyNTextrinsic_spec_arg_list) {
/* line 728 "fortran.lalr" */
 yyS.Line = MixExtrinsic (yyA [0].Line, yyA [2].Line); 
} break;
case 1083:
case 847: /* extrinsic_spec_arg : PIdent '=' StringConst */
yyDecrement (3) yySetNT (yyNTextrinsic_spec_arg) {
/* line 732 "fortran.lalr" */
 yyS.Line = CodeExtrinsic1 (yyA [0].Scan.Ident, yyA [2].Scan.StringConst); 
} break;
case 1084:
case 848: /* extrinsic_spec_arg : StringConst */
yyDecrement (1) yySetNT (yyNTextrinsic_spec_arg) {
/* line 736 "fortran.lalr" */
 yyS.Line = CodeExtrinsic (yyA [0].Scan.StringConst); 
} break;
case 1085: /* extrinsic_kind_keyword : PIdent */
yyDecrement (1) yySetNT (yyNTextrinsic_kind_keyword) {
/* line 740 "fortran.lalr" */
 yyS.Line = yyA [0].Scan.Ident; 
} break;
case 1086: /* block_data : block_data_definition block \
block_data_token CR1 */
yyDecrement (4) yySetNT (yyNTblock_data) {
/* line 751 "fortran.lalr" */
 yyA [0].Tree->BLOCK_DATA_DECL.DATA_BODY = yyA [1].Tree; 
       yyS.Tree = yyA [0].Tree; 
       InitLabels ();
       CheckSameIdent (yyA [0].Tree->BLOCK_DATA_DECL.Ident, yyA [2].Label);
     
} break;
case 1087: /* block_data_definition : BLOCKDATA PIdent CR1 */
yyDecrement (3) yySetNT (yyNTblock_data_definition) {
/* line 760 "fortran.lalr" */
 yyS.Tree = mBLOCK_DATA_DECL (yyA [1].Scan.Ident, yyA [1].Label, NoTree); 
} break;
case 1088: /* block_data_definition : BLOCKDATA CR1 */
yyDecrement (2) yySetNT (yyNTblock_data_definition) {
/* line 765 "fortran.lalr" */
 yyS.Tree = mBLOCK_DATA_DECL (IsIdent("_block_data"), 
                                   NLine(yyA [0]), NoTree); 
} break;
case 1089: /* block_data_token : BLOCKDATA PIdent */
yyDecrement (2) yySetNT (yyNTblock_data_token) {
/* line 771 "fortran.lalr" */
 yyS.Label = yyA [1].Scan.Ident; 
} break;
case 1090: /* block_data_token : BLOCKDATA */
yyDecrement (1) yySetNT (yyNTblock_data_token) {
/* line 775 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1091: /* block_data_token : */
yySetNT (yyNTblock_data_token) {
/* line 779 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1092: /* dummy_arguments : */
yySetNT (yyNTdummy_arguments) {
/* line 787 "fortran.lalr" */
 yyS.Tree = mDECL_EMPTY (); 
} break;
case 1093:
case 849: /* dummy_arguments : '(' ')' */
yyDecrement (2) yySetNT (yyNTdummy_arguments) {
/* line 790 "fortran.lalr" */
 yyS.Tree = mDECL_EMPTY (); 
} break;
case 1094:
case 850: /* dummy_arguments : '(' unit_param_list ')' */
yyDecrement (3) yySetNT (yyNTdummy_arguments) {
/* line 793 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1095: /* unit_param_list : unit_param */
yyDecrement (1) yySetNT (yyNTunit_param_list) {
/* line 796 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree , mDECL_EMPTY ()); 
} break;
case 1096: /* unit_param_list : unit_param ',' unit_param_list */
yyDecrement (3) yySetNT (yyNTunit_param_list) {
/* line 799 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1097: /* unit_param : PIdent */
yyDecrement (1) yySetNT (yyNTunit_param) {
/* line 802 "fortran.lalr" */
 yyS.Tree = mVAR_PARAM_DECL (yyA [0].Scan.Ident, yyA [0].Label, mDUMMY_TYPE ()); 
} break;
case 1098:
case 851: /* unit_param : '*' */
yyDecrement (1) yySetNT (yyNTunit_param) {
/* line 806 "fortran.lalr" */
 yyS.Tree = mRET_PARAM_DECL (DefaultId(), NLine(yyA [0])); 
} break;
case 1099:
case 852: /* block : specification_part execution_part \
internal_subprogram_part opt_label END */
yyDecrement (5) yySetNT (yyNTblock) {
/* line 820 "fortran.lalr" */
 yyS.Tree = mBODY_NODE (CompleteDecls (yyA [0].Tree),  /* append DECL_EMPTY */
                             mDECL_EMPTY (),
                             yyA [1].Tree, yyA [2].Tree); 

       Spec_Exec_Separation (yyS.Tree);
       LabelForEnd (yyS.Tree, yyA [3].Label, NLine (yyA [4]));

     
} break;
case 1100: /* internal_subprogram_part : */
yySetNT (yyNTinternal_subprogram_part) {
/* line 831 "fortran.lalr" */
 yyS.Tree = mUNIT_EMPTY (); 
} break;
case 1101: /* internal_subprogram_part : CONTAINS CR1 \
internal_subprograms */
yyDecrement (3) yySetNT (yyNTinternal_subprogram_part) {
/* line 835 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1102: /* internal_subprograms : internal_subprogram */
yyDecrement (1) yySetNT (yyNTinternal_subprograms) {
/* line 839 "fortran.lalr" */
 yyS.Tree = mUNIT_LIST (yyA [0].Tree, mUNIT_EMPTY() ); 
} break;
case 1103: /* internal_subprograms : internal_subprogram \
internal_subprograms */
yyDecrement (2) yySetNT (yyNTinternal_subprograms) {
/* line 843 "fortran.lalr" */
 yyS.Tree = mUNIT_LIST (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1104: /* internal_subprogram : subroutine_subprogram */
yyDecrement (1) yySetNT (yyNTinternal_subprogram) {
/* line 847 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1105: /* internal_subprogram : function_subprogram */
yyDecrement (1) yySetNT (yyNTinternal_subprogram) {
/* line 851 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1106:
case 853: /* kind_selector : '(' expression ')' */
yyDecrement (3) yySetNT (yyNTkind_selector) {
/* line 861 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1107:
case 854: /* kind_selector : '(' PIdent '=' expression ')' */
yyDecrement (5) yySetNT (yyNTkind_selector) {
/* line 865 "fortran.lalr" */
 yyS.Tree = yyA [3].Tree; 
} break;
case 1108:
case 855: /* kind_selector : '(' '*' ')' */
yyDecrement (3) yySetNT (yyNTkind_selector) {
/* line 869 "fortran.lalr" */
 yyS.Tree = mDUMMY_EXP (); 
} break;
case 1109:
case 856: /* kind_selector : '(' PIdent '=' '*' ')' */
yyDecrement (5) yySetNT (yyNTkind_selector) {
/* line 873 "fortran.lalr" */
 yyS.Tree = mDUMMY_EXP (); 
} break;
case 1110:
case 857: /* basic_num_type : REAL */
yyDecrement (1) yySetNT (yyNTbasic_num_type) {
/* line 886 "fortran.lalr" */
 yyS.Tree = mREAL_TYPE (NoTree); 
} break;
case 1111:
case 858: /* basic_num_type : INTEGER */
yyDecrement (1) yySetNT (yyNTbasic_num_type) {
/* line 891 "fortran.lalr" */
 yyS.Tree = mINTEGER_TYPE (NoTree); 
} break;
case 1112:
case 859: /* basic_num_type : COMPLEX */
yyDecrement (1) yySetNT (yyNTbasic_num_type) {
/* line 896 "fortran.lalr" */
 yyS.Tree = mCOMPLEX_TYPE (NoTree); 
} break;
case 1113:
case 860: /* basic_num_type : LOGICAL */
yyDecrement (1) yySetNT (yyNTbasic_num_type) {
/* line 901 "fortran.lalr" */
 yyS.Tree = mBOOLEAN_TYPE (NoTree); 
} break;
case 1114: /* num_type : basic_num_type */
yyDecrement (1) yySetNT (yyNTnum_type) {
/* line 908 "fortran.lalr" */
 yyS.Tree = SetDefaultSize (yyA [0].Tree); 
} break;
case 1115:
case 861: /* num_type : basic_num_type '*' IntConst */
yyDecrement (3) yySetNT (yyNTnum_type) {
/* line 913 "fortran.lalr" */
 yyS.Tree = SetTypeSize (yyA [0].Tree, yyA [2].Scan.IntConst); 
} break;
case 1116:
case 862: /* num_type : DOUBLE_PRECISION */
yyDecrement (1) yySetNT (yyNTnum_type) {
/* line 918 "fortran.lalr" */
 yyS.Tree = mREAL_TYPE (mCONST_EXP (
                               mINT_CONSTANT (2*default_real_size)));
     
} break;
case 1117:
case 863: /* num_type : DOUBLE_COMPLEX */
yyDecrement (1) yySetNT (yyNTnum_type) {
/* line 925 "fortran.lalr" */
 yyS.Tree = mCOMPLEX_TYPE (mCONST_EXP (
                                  mINT_CONSTANT (4*default_real_size)));
     
} break;
case 1118: /* char_type : CHARACTER */
yyDecrement (1) yySetNT (yyNTchar_type) {
/* line 934 "fortran.lalr" */
 yyS.Tree = mSTRING_TYPE (mCONST_EXP (mINT_CONSTANT (1))); 
} break;
case 1119: /* char_type : CHARACTER '*' char_length */
yyDecrement (3) yySetNT (yyNTchar_type) {
/* line 939 "fortran.lalr" */
 yyS.Tree = mSTRING_TYPE (yyA [2].Tree); 
} break;
case 1120: /* kind_type : CHARACTER kind_selector */
yyDecrement (2) yySetNT (yyNTkind_type) {
/* line 946 "fortran.lalr" */
 yyS.Tree = mSTRING_TYPE (yyA [1].Tree); 
} break;
case 1121: /* kind_type : basic_num_type kind_selector */
yyDecrement (2) yySetNT (yyNTkind_type) {
/* line 951 "fortran.lalr" */
 yyS.Tree = SetTypeKind (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1122: /* type_spec : kind_type */
yyDecrement (1) yySetNT (yyNTtype_spec) {
/* line 958 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1123: /* type_spec : char_type */
yyDecrement (1) yySetNT (yyNTtype_spec) {
/* line 963 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1124: /* type_spec : num_type */
yyDecrement (1) yySetNT (yyNTtype_spec) {
/* line 968 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1125:
case 864: /* type_spec : TYPE '(' PIdent ')' */
yyDecrement (4) yySetNT (yyNTtype_spec) {
/* line 972 "fortran.lalr" */
 yyS.Tree = mTYPE_OBJ (yyA [2].Scan.Ident);
       yyS.Tree = mTYPE_ID (yyS.Tree);   
} break;
case 1126:
case 865: /* DimSpec : '(' DimIndexes ')' */
yyDecrement (3) yySetNT (yyNTDimSpec) {
/* line 985 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1127: /* DimIndexes : Index_Typen */
yyDecrement (1) yySetNT (yyNTDimIndexes) {
/* line 989 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1128: /* DimIndexes : Dyn_Specifications */
yyDecrement (1) yySetNT (yyNTDimIndexes) {
/* line 993 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1129: /* Dyn_Specifications : Dyn_Spec */
yyDecrement (1) yySetNT (yyNTDyn_Specifications) {
/* line 997 "fortran.lalr" */
 yyS.Tree = mSHAPE_LIST (yyA [0].Tree, mSHAPE_EMPTY()); 
} break;
case 1130: /* Dyn_Specifications : Dyn_Spec ',' Dyn_Specifications */
yyDecrement (3) yySetNT (yyNTDyn_Specifications) {
/* line 1002 "fortran.lalr" */
 yyS.Tree = mSHAPE_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1131:
case 866: /* Dyn_Spec : ':' */
yyDecrement (1) yySetNT (yyNTDyn_Spec) {
/* line 1007 "fortran.lalr" */
 yyS.Tree = mDEFERRED_SHAPE (); 
} break;
case 1132:
case 867: /* Dyn_Spec : expression ':' */
yyDecrement (2) yySetNT (yyNTDyn_Spec) {
/* line 1012 "fortran.lalr" */
 yyS.Tree = mASSUMED_SHAPE (yyA [0].Tree); 
} break;
case 1133: /* Index_Typen : LastBegrenzer */
yyDecrement (1) yySetNT (yyNTIndex_Typen) {
/* line 1016 "fortran.lalr" */
 yyS.Tree = mSHAPE_LIST (yyA [0].Tree, mSHAPE_EMPTY()); 
} break;
case 1134: /* Index_Typen : explicit_shape */
yyDecrement (1) yySetNT (yyNTIndex_Typen) {
/* line 1021 "fortran.lalr" */
 yyS.Tree = mSHAPE_LIST (yyA [0].Tree, mSHAPE_EMPTY()); 
} break;
case 1135: /* Index_Typen : explicit_shape ',' Index_Typen */
yyDecrement (3) yySetNT (yyNTIndex_Typen) {
/* line 1026 "fortran.lalr" */
 yyS.Tree = mSHAPE_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1136: /* explicit_shape : expression */
yyDecrement (1) yySetNT (yyNTexplicit_shape) {
/* line 1031 "fortran.lalr" */
 yyS.Tree = mEXPLICIT_SHAPE (mCONST_EXP(mINT_CONSTANT(1)), yyA [0].Tree); 
} break;
case 1137: /* explicit_shape : expression ':' expression */
yyDecrement (3) yySetNT (yyNTexplicit_shape) {
/* line 1036 "fortran.lalr" */
 yyS.Tree = mEXPLICIT_SHAPE (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1138:
case 868: /* LastBegrenzer : '*' */
yyDecrement (1) yySetNT (yyNTLastBegrenzer) {
/* line 1041 "fortran.lalr" */
 yyS.Tree = mASSUMED_SIZE (mCONST_EXP(mINT_CONSTANT(1))); 
} break;
case 1139:
case 869: /* LastBegrenzer : expression ':' '*' */
yyDecrement (3) yySetNT (yyNTLastBegrenzer) {
/* line 1046 "fortran.lalr" */
 yyS.Tree = mASSUMED_SIZE (yyA [0].Tree); 
} break;
case 1140: /* specification_part : decl_constructs */
yyDecrement (1) yySetNT (yyNTspecification_part) {
/* line 1056 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1141: /* decl_constructs : declaration_construct CR1 \
decl_constructs */
yyDecrement (3) yySetNT (yyNTdecl_constructs) {
/* line 1060 "fortran.lalr" */
 yyS.Tree = ConcatDecls (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1142: /* decl_constructs : */
yySetNT (yyNTdecl_constructs) {
/* line 1064 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1143: /* declaration_construct : use_stmt */
yyDecrement (1) yySetNT (yyNTdeclaration_construct) {
/* line 1068 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1144: /* declaration_construct : derived_type_def */
yyDecrement (1) yySetNT (yyNTdeclaration_construct) {
/* line 1072 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1145: /* declaration_construct : interface_block */
yyDecrement (1) yySetNT (yyNTdeclaration_construct) {
/* line 1076 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1146: /* declaration_construct : type_declaration_stmt */
yyDecrement (1) yySetNT (yyNTdeclaration_construct) {
/* line 1080 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1147: /* declaration_construct : opt_label definition */
yyDecrement (2) yySetNT (yyNTdeclaration_construct) {
/* line 1084 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree;
       /* some definitions will use the label */
       SetDefinitionLabel (yyS.Tree, yyA [0].Label);
     
} break;
case 1148: /* definition : parameter_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1092 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1149: /* definition : implicit_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1093 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1150: /* definition : access_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1097 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1151: /* definition : allocatable_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1098 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1152: /* definition : common_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1099 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1153: /* definition : data_statement */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1100 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1154: /* definition : format_statement */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1101 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1155: /* definition : dimension_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1102 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1156: /* definition : equivalence_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1103 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1157: /* definition : external_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1104 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1158: /* definition : intent_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1105 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1159: /* definition : intrinsic_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1106 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1160: /* definition : namelist_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1107 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1161: /* definition : optional_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1108 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1162: /* definition : pointer_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1109 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1163: /* definition : save_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1110 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1164: /* definition : sequ_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1111 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1165: /* definition : nsequ_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1112 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1166: /* definition : target_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1113 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1167: /* definition : map_definition */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1115 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1168: /* definition : hpf_directive */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1117 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1169: /* definition : adp_directive */
yyDecrement (1) yySetNT (yyNTdefinition) {
/* line 1118 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1170: /* entity_decl_list : entity_decl */
yyDecrement (1) yySetNT (yyNTentity_decl_list) {
/* line 1127 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1171: /* entity_decl_list : entity_decl ',' entity_decl_list */
yyDecrement (3) yySetNT (yyNTentity_decl_list) {
/* line 1131 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1172: /* entity_decl : PIdent opt_array_spec opt_char_length \
opt_init_expr */
yyDecrement (4) yySetNT (yyNTentity_decl) {
/* line 1135 "fortran.lalr" */
 yyS.Tree = mDECL_EMPTY();
      if (yyA [3].Tree != NoTree)
         yyS.Tree = mDECL_LIST (yyA [3].Tree, yyS.Tree);
      if (yyA [2].Tree != NoTree)
         yyS.Tree = mDECL_LIST (yyA [2].Tree, yyS.Tree);
      if (yyA [1].Tree != NoTree)
         yyS.Tree = mDECL_LIST (yyA [1].Tree, yyS.Tree);
      yyS.Tree = mENTITY_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyS.Tree); 
} break;
case 1173: /* opt_array_spec : */
yySetNT (yyNTopt_array_spec) {
/* line 1146 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1174:
case 870: /* opt_array_spec : '(' DimIndexes ')' */
yyDecrement (3) yySetNT (yyNTopt_array_spec) {
/* line 1150 "fortran.lalr" */
 yyS.Tree = mDIMENSION_DECL (DefaultId(), 0, yyA [1].Tree); 
} break;
case 1175: /* opt_char_length : */
yySetNT (yyNTopt_char_length) {
/* line 1154 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1176: /* opt_char_length : '*' char_length */
yyDecrement (2) yySetNT (yyNTopt_char_length) {
/* line 1158 "fortran.lalr" */
 yyS.Tree = mTYPESPEC_DECL (DefaultId(), 0, mSTRING_TYPE (yyA [1].Tree)); 
} break;
case 1177: /* opt_init_expr : */
yySetNT (yyNTopt_init_expr) {
/* line 1162 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1178: /* opt_init_expr : '=' expression */
yyDecrement (2) yySetNT (yyNTopt_init_expr) {
/* line 1166 "fortran.lalr" */
 yyS.Tree = mINIT_DATA_DECL (DefaultId(), 0, yyA [1].Tree); 
} break;
case 1179:
case 871: /* char_length : '(' type_param_value ')' */
yyDecrement (3) yySetNT (yyNTchar_length) {
/* line 1174 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1180:
case 872: /* char_length : IntConst */
yyDecrement (1) yySetNT (yyNTchar_length) {
/* line 1178 "fortran.lalr" */
 yyS.Tree = mCONST_EXP (mINT_CONSTANT (yyA [0].Scan.IntConst)); 
} break;
case 1181:
case 873: /* type_param_value : '*' */
yyDecrement (1) yySetNT (yyNTtype_param_value) {
/* line 1182 "fortran.lalr" */
 yyS.Tree = mCONST_EXP (mINT_CONSTANT (-1)); 
} break;
case 1182: /* type_param_value : expression */
yyDecrement (1) yySetNT (yyNTtype_param_value) {
/* line 1186 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree;   
} break;
case 1183: /* type_declaration_stmt : type_spec optional_attributes \
entity_decl_list */
yyDecrement (3) yySetNT (yyNTtype_declaration_stmt) {
/* line 1196 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree;
       yyA [0].Tree = mDECL_LIST (mTYPESPEC_DECL (DefaultId(), 0, yyA [0].Tree), yyA [1].Tree);
       /* set all Attributes to Entity Declaration Attributes */
       SetAttributes (yyA [0].Tree, yyS.Tree); 
} break;
case 1184: /* optional_attributes : */
yySetNT (yyNToptional_attributes) {
/* line 1205 "fortran.lalr" */
 yyS.Tree = NoTree;  
} break;
case 1185:
case 874: /* optional_attributes : '::' */
yyDecrement (1) yySetNT (yyNToptional_attributes) {
/* line 1209 "fortran.lalr" */
 yyS.Tree = NoTree;  
} break;
case 1186:
case 875: /* optional_attributes : attribute_list '::' */
yyDecrement (2) yySetNT (yyNToptional_attributes) {
/* line 1213 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1187: /* attribute_list : ',' attr_spec */
yyDecrement (2) yySetNT (yyNTattribute_list) {
/* line 1217 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [1].Tree, NoTree); 
} break;
case 1188: /* attribute_list : ',' attr_spec attribute_list */
yyDecrement (3) yySetNT (yyNTattribute_list) {
/* line 1221 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [1].Tree, yyA [2].Tree); 
} break;
case 1189:
case 876: /* attr_spec : PARAMETER1 */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1225 "fortran.lalr" */
 yyS.Tree = mPARAMETER_DECL (DefaultId(), 0, mDUMMY_EXP()); 
} break;
case 1190: /* attr_spec : access_spec */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1229 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1191:
case 877: /* attr_spec : ALLOCATABLE1 */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1233 "fortran.lalr" */
 yyS.Tree = mALLOCATABLE_DECL (DefaultId(), 0); 
} break;
case 1192:
case 878: /* attr_spec : DIMENSION1 '(' DimIndexes ')' */
yyDecrement (4) yySetNT (yyNTattr_spec) {
/* line 1237 "fortran.lalr" */
 yyS.Tree = mDIMENSION_DECL (DefaultId(), 0, yyA [2].Tree); 
} break;
case 1193:
case 879: /* attr_spec : ARRAY1 '(' DimIndexes ')' */
yyDecrement (4) yySetNT (yyNTattr_spec) {
/* line 1241 "fortran.lalr" */
 yyS.Tree = mDIMENSION_DECL (DefaultId(), 0, yyA [2].Tree); 
} break;
case 1194:
case 880: /* attr_spec : INTENT1 '(' intent_spec ')' */
yyDecrement (4) yySetNT (yyNTattr_spec) {
/* line 1245 "fortran.lalr" */
 yyS.Tree = mINTENT_DECL (DefaultId(), 0, yyA [2].Label); 
} break;
case 1195:
case 881: /* attr_spec : EXTERNAL1 */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1249 "fortran.lalr" */
 yyS.Tree = mEXTERNAL_DECL (DefaultId(), 0); 
} break;
case 1196:
case 882: /* attr_spec : INTRINSIC1 */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1253 "fortran.lalr" */
 yyS.Tree = mINTRINSIC_DECL (DefaultId(), DefaultId(), 0, 0, 0); 
} break;
case 1197:
case 883: /* attr_spec : OPTIONAL1 */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1257 "fortran.lalr" */
 yyS.Tree = mOPTIONAL_DECL (DefaultId(), 0); 
} break;
case 1198:
case 884: /* attr_spec : LAYOUT1 '(' StringConst ')' */
yyDecrement (4) yySetNT (yyNTattr_spec) {
/* line 1261 "fortran.lalr" */
 yyS.Tree = mLAYOUT_DECL (DefaultId(), 0, yyA [2].Scan.StringConst); 
} break;
case 1199:
case 885: /* attr_spec : PASS_BY1 '(' StringConst ')' */
yyDecrement (4) yySetNT (yyNTattr_spec) {
/* line 1265 "fortran.lalr" */
 yyS.Tree = mPASS_BY_DECL (DefaultId(), 0, yyA [2].Scan.StringConst); 
} break;
case 1200:
case 886: /* attr_spec : MAP_TO1 '(' StringConst ')' */
yyDecrement (4) yySetNT (yyNTattr_spec) {
/* line 1269 "fortran.lalr" */
 yyS.Tree = mMAP_TO_DECL (DefaultId(), 0, yyA [2].Scan.StringConst); 
} break;
case 1201:
case 887: /* attr_spec : POINTER1 */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1273 "fortran.lalr" */
 yyS.Tree = mPOINTER_DECL (DefaultId(), 0); 
} break;
case 1202:
case 888: /* attr_spec : SAVE1 */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1277 "fortran.lalr" */
 yyS.Tree = mSAVE_DECL (DefaultId(), 0); 
} break;
case 1203:
case 889: /* attr_spec : TARGET1 */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1281 "fortran.lalr" */
 yyS.Tree = mTARGET_DECL (DefaultId(), 0); 
} break;
case 1204:
case 890: /* attr_spec : DATA1 */
yyDecrement (1) yySetNT (yyNTattr_spec) {
/* line 1285 "fortran.lalr" */
 yyS.Tree = mINIT_DATA_DECL (DefaultId(), 0, mDUMMY_EXP()); 
} break;
case 1205:
case 891: /* access_spec : PUBLIC1 */
yyDecrement (1) yySetNT (yyNTaccess_spec) {
/* line 1289 "fortran.lalr" */
 yyS.Tree = mPUBLIC_DECL (DefaultId(), 0); 
} break;
case 1206:
case 892: /* access_spec : PRIVATE1 */
yyDecrement (1) yySetNT (yyNTaccess_spec) {
/* line 1293 "fortran.lalr" */
 yyS.Tree = mPRIVATE_DECL (DefaultId(), 0); 
} break;
case 1207:
case 893: /* access_spec : SEQUENCE1 */
yyDecrement (1) yySetNT (yyNTaccess_spec) {
/* line 1297 "fortran.lalr" */
 yyS.Tree = mSEQUENCE_DECL (DefaultId(), 0); 
} break;
case 1208: /* dimension_definition : DIMENSION opt_dcolon \
ArraySpecList */
yyDecrement (3) yySetNT (yyNTdimension_definition) {
/* line 1307 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1209: /* ArraySpecList : ArraySpec */
yyDecrement (1) yySetNT (yyNTArraySpecList) {
/* line 1311 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1210: /* ArraySpecList : ArraySpec ',' ArraySpecList */
yyDecrement (3) yySetNT (yyNTArraySpecList) {
/* line 1315 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1211: /* ArraySpec : PIdent DimSpec */
yyDecrement (2) yySetNT (yyNTArraySpec) {
/* line 1319 "fortran.lalr" */
 yyS.Tree = mDIMENSION_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [1].Tree); 
} break;
case 1212: /* equivalence_definition : EQUIVALENCE eqvblocks */
yyDecrement (2) yySetNT (yyNTequivalence_definition) {
/* line 1329 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1213: /* eqvblocks : eqvblock */
yyDecrement (1) yySetNT (yyNTeqvblocks) {
/* line 1333 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1214: /* eqvblocks : eqvblock ',' eqvblocks */
yyDecrement (3) yySetNT (yyNTeqvblocks) {
/* line 1337 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1215:
case 894: /* eqvblock : '(' variable ',' variable more_eqvs ')' */
yyDecrement (6) yySetNT (yyNTeqvblock) {
/* line 1341 "fortran.lalr" */
 yyS.Tree = mEQV_DECL (DefaultId(), NLine (yyA [5]), 
                  mBTV_LIST (yyA [1].Tree, mBTV_LIST (yyA [3].Tree, yyA [4].Tree))); 
} break;
case 1216: /* more_eqvs : */
yySetNT (yyNTmore_eqvs) {
/* line 1346 "fortran.lalr" */
 yyS.Tree = mBTV_EMPTY (); 
} break;
case 1217: /* more_eqvs : ',' variable more_eqvs */
yyDecrement (3) yySetNT (yyNTmore_eqvs) {
/* line 1350 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [1].Tree, yyA [2].Tree); 
} break;
case 1218: /* common_definition : COMMON blank_common common_object \
common_cont */
yyDecrement (4) yySetNT (yyNTcommon_definition) {
/* line 1360 "fortran.lalr" */
 global_objects = mDECL_LIST (yyA [2].Tree, global_objects);
       yyA [1].Tree->COMMON_DECL.IDS = global_objects;
       yyS.Tree = mDECL_LIST (yyA [1].Tree, global_groups);         
     
} break;
case 1219: /* common_definition : COMMON named_common common_object \
common_cont */
yyDecrement (4) yySetNT (yyNTcommon_definition) {
/* line 1366 "fortran.lalr" */
 global_objects = mDECL_LIST (yyA [2].Tree, global_objects);
       yyA [1].Tree->COMMON_DECL.IDS = global_objects;
       yyS.Tree = mDECL_LIST (yyA [1].Tree, global_groups);         
     
} break;
case 1220: /* common_object : PIdent */
yyDecrement (1) yySetNT (yyNTcommon_object) {
/* line 1372 "fortran.lalr" */
 yyS.Tree = mVAR_DECL (yyA [0].Scan.Ident, yyA [0].Label, mDUMMY_TYPE()); 
     
} break;
case 1221: /* common_object : PIdent DimSpec */
yyDecrement (2) yySetNT (yyNTcommon_object) {
/* line 1376 "fortran.lalr" */
 yyS.Tree = mVAR_DECL (yyA [0].Scan.Ident, yyA [0].Label,
                   mARRAY_TYPE (yyA [1].Tree, mDUMMY_TYPE()));  
     
} break;
case 1222: /* common_cont : */
yySetNT (yyNTcommon_cont) {
/* line 1381 "fortran.lalr" */
 global_objects = mDECL_EMPTY   (); 
       global_groups  = mDECL_EMPTY ();
     
} break;
case 1223: /* common_cont : ',' common_object common_cont */
yyDecrement (3) yySetNT (yyNTcommon_cont) {
/* line 1386 "fortran.lalr" */
 global_objects = mDECL_LIST (yyA [1].Tree, global_objects); 
} break;
case 1224: /* common_cont : opt_comma named_common common_object \
common_cont */
yyDecrement (4) yySetNT (yyNTcommon_cont) {
/* line 1390 "fortran.lalr" */
 global_objects = mDECL_LIST (yyA [2].Tree, global_objects);
       yyA [1].Tree->COMMON_DECL.IDS = global_objects;
       global_groups  = mDECL_LIST (yyA [1].Tree, global_groups); 
       global_objects = mDECL_EMPTY ();                         
} break;
case 1225:
case 895: /* named_common : '/' PIdent '/' */
yyDecrement (3) yySetNT (yyNTnamed_common) {
/* line 1397 "fortran.lalr" */
  yyS.Tree = mCOMMON_DECL (yyA [1].Scan.Ident, yyA [1].Label, mDECL_EMPTY () ); 
} break;
case 1226:
case 896: /* blank_common : '/' '/' */
yyDecrement (2) yySetNT (yyNTblank_common) {
/* line 1401 "fortran.lalr" */
 yyS.Tree = mCOMMON_DECL (DefaultId(), NLine (yyA [0]), mDECL_EMPTY () ); 
} break;
case 1227:
case 897: /* blank_common : '//' */
yyDecrement (1) yySetNT (yyNTblank_common) {
/* line 1405 "fortran.lalr" */
 yyS.Tree = mCOMMON_DECL (DefaultId(), NLine (yyA [0]), mDECL_EMPTY () ); 
} break;
case 1228: /* blank_common : */
yySetNT (yyNTblank_common) {
/* line 1409 "fortran.lalr" */
 yyS.Tree = mCOMMON_DECL (DefaultId(), 0, mDECL_EMPTY () );   
} break;
case 1229: /* use_stmt : USE PIdent rename_list */
yyDecrement (3) yySetNT (yyNTuse_stmt) {
/* line 1419 "fortran.lalr" */
 yyS.Tree = mUSE_DECL (DefaultId(), NLine(yyA [0]), yyA [1].Scan.Ident, yyA [2].Tree);
       yyS.Tree = mDECL_LIST (yyS.Tree, NoTree);                       
} break;
case 1230: /* use_stmt : USE PIdent ',' ONLY ':' only_list */
yyDecrement (6) yySetNT (yyNTuse_stmt) {
/* line 1423 "fortran.lalr" */
 yyS.Tree = mONLY_USE_DECL (DefaultId(), NLine (yyA [0]), 
                                 yyA [1].Scan.Ident, yyA [5].Tree);
       yyS.Tree = mDECL_LIST (yyS.Tree, NoTree);                       
} break;
case 1231: /* rename_list : */
yySetNT (yyNTrename_list) {
/* line 1428 "fortran.lalr" */
 yyS.Tree = mDECL_EMPTY (); 
} break;
case 1232: /* rename_list : ',' rename rename_list */
yyDecrement (3) yySetNT (yyNTrename_list) {
/* line 1431 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [1].Tree, yyA [2].Tree); 
} break;
case 1233: /* rename : PIdent '=>' PIdent */
yyDecrement (3) yySetNT (yyNTrename) {
/* line 1434 "fortran.lalr" */
 yyS.Tree = mRENAME_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [2].Scan.Ident); 
} break;
case 1234: /* only_list : only */
yyDecrement (1) yySetNT (yyNTonly_list) {
/* line 1437 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, mDECL_EMPTY ()); 
} break;
case 1235: /* only_list : only ',' only_list */
yyDecrement (3) yySetNT (yyNTonly_list) {
/* line 1440 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1236: /* only : access_id */
yyDecrement (1) yySetNT (yyNTonly) {
/* line 1443 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1237: /* only : rename */
yyDecrement (1) yySetNT (yyNTonly) {
/* line 1446 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1238:
case 898: /* implicit_definition : IMPLICIT Ident */
yyDecrement (2) yySetNT (yyNTimplicit_definition) {
/* line 1455 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (mIMPLICIT_DECL (DefaultId(), NLine (yyA [0]),
                            IsIdent ("A"), IsIdent ("Z"),
                            mDUMMY_TYPE ()),
             NoTree ); 
} break;
case 1239: /* implicit_definition : IMPLICIT implicit_decl \
more_implicit_decl */
yyDecrement (3) yySetNT (yyNTimplicit_definition) {
/* line 1461 "fortran.lalr" */
 yyS.Tree = ConcatDecls (yyA [1].Tree, yyA [2].Tree); 
} break;
case 1240: /* more_implicit_decl : */
yySetNT (yyNTmore_implicit_decl) {
/* line 1463 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1241: /* more_implicit_decl : ',' implicit_decl \
more_implicit_decl */
yyDecrement (3) yySetNT (yyNTmore_implicit_decl) {
/* line 1466 "fortran.lalr" */
 yyS.Tree = ConcatDecls (yyA [1].Tree, yyA [2].Tree); 
} break;
case 1242:
case 899: /* implicit_decl : num_type '(' letter_list ')' */
yyDecrement (4) yySetNT (yyNTimplicit_decl) {
/* line 1470 "fortran.lalr" */
 SetImplicitType (yyA [2].Tree, yyA [0].Tree); 
      yyS.Tree = yyA [2].Tree;                    
} break;
case 1243:
case 900: /* implicit_decl : char_type '(' letter_list ')' */
yyDecrement (4) yySetNT (yyNTimplicit_decl) {
/* line 1475 "fortran.lalr" */
 SetImplicitType (yyA [2].Tree, yyA [0].Tree); 
      yyS.Tree = yyA [2].Tree;                    
} break;
case 1244: /* letter_list : letter_spec */
yyDecrement (1) yySetNT (yyNTletter_list) {
/* line 1480 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1245: /* letter_list : letter_spec ',' letter_list */
yyDecrement (3) yySetNT (yyNTletter_list) {
/* line 1484 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1246: /* letter_spec : PIdent */
yyDecrement (1) yySetNT (yyNTletter_spec) {
/* line 1488 "fortran.lalr" */
 yyS.Tree = mIMPLICIT_DECL (IsIdent (" "), yyA [0].Label, 
                  yyA [0].Scan.Ident, yyA [0].Scan.Ident, NoTree); 
} break;
case 1247: /* letter_spec : PIdent '-' PIdent */
yyDecrement (3) yySetNT (yyNTletter_spec) {
/* line 1493 "fortran.lalr" */
 yyS.Tree = mIMPLICIT_DECL (IsIdent (" "), yyA [0].Label,
                  yyA [0].Scan.Ident, yyA [2].Scan.Ident, NoTree); 
} break;
case 1248: /* external_definition : EXTERNAL ExtIdentList */
yyDecrement (2) yySetNT (yyNTexternal_definition) {
/* line 1504 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1249: /* ExtIdentList : ExtIdent */
yyDecrement (1) yySetNT (yyNTExtIdentList) {
/* line 1507 "fortran.lalr" */
 yyS.Tree=mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1250: /* ExtIdentList : ExtIdent ',' ExtIdentList */
yyDecrement (3) yySetNT (yyNTExtIdentList) {
/* line 1511 "fortran.lalr" */
 yyS.Tree=mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1251: /* ExtIdent : PIdent */
yyDecrement (1) yySetNT (yyNTExtIdent) {
/* line 1515 "fortran.lalr" */
 yyS.Tree= mEXTERNAL_DECL (yyA [0].Scan.Ident, yyA [0].Label); 
} break;
case 1252: /* intrinsic_definition : INTRINSIC IntIdentList */
yyDecrement (2) yySetNT (yyNTintrinsic_definition) {
/* line 1519 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1253: /* IntIdentList : Intrinsic_Ident */
yyDecrement (1) yySetNT (yyNTIntIdentList) {
/* line 1523 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1254: /* IntIdentList : Intrinsic_Ident ',' IntIdentList */
yyDecrement (3) yySetNT (yyNTIntIdentList) {
/* line 1527 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1255: /* Intrinsic_Ident : PIdent */
yyDecrement (1) yySetNT (yyNTIntrinsic_Ident) {
/* line 1531 "fortran.lalr" */
 yyS.Tree = mINTRINSIC_DECL (yyA [0].Scan.Ident, yyA [0].Label, DefaultId (), 0, 0); 
} break;
case 1256: /* access_definition : PRIVATE */
yyDecrement (1) yySetNT (yyNTaccess_definition) {
/* line 1541 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (mPRIVATE_DECL (DefaultId(), 0),
                             mDECL_EMPTY ()); 
} break;
case 1257: /* access_definition : PUBLIC */
yyDecrement (1) yySetNT (yyNTaccess_definition) {
/* line 1545 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (mPUBLIC_DECL (DefaultId(), 0),
                             mDECL_EMPTY ()); 
} break;
case 1258: /* access_definition : PUBLIC opt_dcolon access_id_list */
yyDecrement (3) yySetNT (yyNTaccess_definition) {
/* line 1549 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree;
       MakePublicDecls (yyS.Tree);
     
} break;
case 1259: /* access_definition : PRIVATE opt_dcolon access_id_list */
yyDecrement (3) yySetNT (yyNTaccess_definition) {
/* line 1554 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree;
       MakePrivateDecls (yyS.Tree);
     
} break;
case 1260: /* access_id_list : access_id */
yyDecrement (1) yySetNT (yyNTaccess_id_list) {
/* line 1565 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1261: /* access_id_list : access_id ',' access_id_list */
yyDecrement (3) yySetNT (yyNTaccess_id_list) {
/* line 1568 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1262: /* access_id : PIdent */
yyDecrement (1) yySetNT (yyNTaccess_id) {
/* line 1571 "fortran.lalr" */
 yyS.Tree = mNAME_DECL (yyA [0].Scan.Ident, yyA [0].Label); 
} break;
case 1263:
case 901: /* access_id : OPERATOR '(' defined_operator ')' */
yyDecrement (4) yySetNT (yyNTaccess_id) {
/* line 1574 "fortran.lalr" */
 yyS.Tree = mNAME_DECL (DefaultId(), NLine(yyA [1]) ); 
} break;
case 1264:
case 902: /* access_id : ASSIGNMENT '(' '=' ')' */
yyDecrement (4) yySetNT (yyNTaccess_id) {
/* line 1577 "fortran.lalr" */
 yyS.Tree = mNAME_DECL (DefaultId(), NLine(yyA [1]) ); 
} break;
case 1265: /* optional_definition : OPTIONAL opt_dcolon \
optional_id_list */
yyDecrement (3) yySetNT (yyNToptional_definition) {
/* line 1586 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1266: /* optional_id_list : optional_ident */
yyDecrement (1) yySetNT (yyNToptional_id_list) {
/* line 1589 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1267: /* optional_id_list : optional_ident ',' optional_id_list */
yyDecrement (3) yySetNT (yyNToptional_id_list) {
/* line 1592 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1268: /* optional_ident : PIdent */
yyDecrement (1) yySetNT (yyNToptional_ident) {
/* line 1595 "fortran.lalr" */
 yyS.Tree = mOPTIONAL_DECL (yyA [0].Scan.Ident, yyA [0].Label); 
} break;
case 1269: /* map_definition : MAP_TO '(' StringConst ')' opt_dcolon \
map_id_list */
yyDecrement (6) yySetNT (yyNTmap_definition) {
/* line 1605 "fortran.lalr" */
 SetMapKind (kMAP_TO_DECL, yyA [2].Scan.StringConst, yyA [5].Tree); 
       yyS.Tree = yyA [5].Tree;
     
} break;
case 1270: /* map_definition : LAYOUT '(' StringConst ')' opt_dcolon \
map_id_list */
yyDecrement (6) yySetNT (yyNTmap_definition) {
/* line 1611 "fortran.lalr" */
 SetMapKind (kLAYOUT_DECL, yyA [2].Scan.StringConst, yyA [5].Tree); 
       yyS.Tree = yyA [5].Tree;
     
} break;
case 1271: /* map_definition : PASS_BY '(' StringConst ')' opt_dcolon \
map_id_list */
yyDecrement (6) yySetNT (yyNTmap_definition) {
/* line 1617 "fortran.lalr" */
 SetMapKind (kPASS_BY_DECL, yyA [2].Scan.StringConst, yyA [5].Tree); 
       yyS.Tree = yyA [5].Tree;
     
} break;
case 1272: /* map_id_list : map_ident */
yyDecrement (1) yySetNT (yyNTmap_id_list) {
/* line 1622 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1273: /* map_id_list : map_ident ',' map_id_list */
yyDecrement (3) yySetNT (yyNTmap_id_list) {
/* line 1625 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1274: /* map_ident : PIdent */
yyDecrement (1) yySetNT (yyNTmap_ident) {
/* line 1628 "fortran.lalr" */
 yyS.Tree = mMAP_TO_DECL (yyA [0].Scan.Ident, yyA [0].Label, 0); 
} break;
case 1275: /* namelist_definition : NAMELIST namelist_groupid \
namelist_object namelist_cont */
yyDecrement (4) yySetNT (yyNTnamelist_definition) {
/* line 1637 "fortran.lalr" */
 global_objects = mDECL_LIST (yyA [2].Tree, global_objects);
       yyA [1].Tree->COMMON_DECL.IDS = global_objects;
       global_groups = mDECL_LIST (yyA [1].Tree, global_groups); 
       yyS.Tree = global_groups;                               
} break;
case 1276: /* namelist_cont : */
yySetNT (yyNTnamelist_cont) {
/* line 1643 "fortran.lalr" */
 global_objects = mDECL_EMPTY();
       global_groups  = mDECL_EMPTY();  
} break;
case 1277: /* namelist_cont : ',' namelist_object namelist_cont */
yyDecrement (3) yySetNT (yyNTnamelist_cont) {
/* line 1647 "fortran.lalr" */
 global_objects = mDECL_LIST (yyA [1].Tree, global_objects); 
} break;
case 1278: /* namelist_cont : opt_comma namelist_groupid \
namelist_object namelist_cont */
yyDecrement (4) yySetNT (yyNTnamelist_cont) {
/* line 1650 "fortran.lalr" */
 global_objects = mDECL_LIST (yyA [2].Tree, global_objects);
       yyA [1].Tree->NAMELIST_DECL.IDS = global_objects;
       global_groups   = mDECL_LIST (yyA [1].Tree, global_groups); 
       global_objects  = mDECL_EMPTY ();                         
} break;
case 1279:
case 903: /* namelist_groupid : '/' PIdent '/' */
yyDecrement (3) yySetNT (yyNTnamelist_groupid) {
/* line 1656 "fortran.lalr" */
 yyS.Tree = mNAMELIST_DECL (yyA [1].Scan.Ident, yyA [1].Label, NoTree); 
} break;
case 1280: /* namelist_object : PIdent */
yyDecrement (1) yySetNT (yyNTnamelist_object) {
/* line 1659 "fortran.lalr" */
 yyS.Tree = mVAR_DECL (yyA [0].Scan.Ident, yyA [0].Label, mDUMMY_TYPE()); 
} break;
case 1281: /* save_definition : SAVE */
yyDecrement (1) yySetNT (yyNTsave_definition) {
/* line 1668 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (mSAVE_DECL (DefaultId(), yyA [0].Label), 
                             NoTree); 
} break;
case 1282: /* save_definition : SAVE opt_dcolon save_var_list */
yyDecrement (3) yySetNT (yyNTsave_definition) {
/* line 1673 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1283: /* save_var_list : save_var */
yyDecrement (1) yySetNT (yyNTsave_var_list) {
/* line 1677 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1284: /* save_var_list : save_var ',' save_var_list */
yyDecrement (3) yySetNT (yyNTsave_var_list) {
/* line 1681 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree);  
} break;
case 1285: /* save_var : PIdent */
yyDecrement (1) yySetNT (yyNTsave_var) {
/* line 1685 "fortran.lalr" */
 yyS.Tree = mSAVE_DECL (yyA [0].Scan.Ident, yyA [0].Label); 
} break;
case 1286:
case 904: /* save_var : '/' PIdent '/' */
yyDecrement (3) yySetNT (yyNTsave_var) {
/* line 1689 "fortran.lalr" */
 yyS.Tree = mSAVE_DECL (yyA [1].Scan.Ident, yyA [1].Label); 
} break;
case 1287: /* sequ_definition : HPFSEQUENCE */
yyDecrement (1) yySetNT (yyNTsequ_definition) {
/* line 1699 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (mHPF_SEQUENCE_DECL (DefaultId(), yyA [0].Label), 
                             NoTree); 
} break;
case 1288: /* sequ_definition : HPFSEQUENCE opt_dcolon sequ_var_list */
yyDecrement (3) yySetNT (yyNTsequ_definition) {
/* line 1704 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1289: /* sequ_var_list : sequ_var */
yyDecrement (1) yySetNT (yyNTsequ_var_list) {
/* line 1708 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1290: /* sequ_var_list : sequ_var ',' sequ_var_list */
yyDecrement (3) yySetNT (yyNTsequ_var_list) {
/* line 1712 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree);  
} break;
case 1291: /* sequ_var : PIdent */
yyDecrement (1) yySetNT (yyNTsequ_var) {
/* line 1716 "fortran.lalr" */
 yyS.Tree = mHPF_SEQUENCE_DECL (yyA [0].Scan.Ident, yyA [0].Label); 
} break;
case 1292:
case 905: /* sequ_var : '/' PIdent '/' */
yyDecrement (3) yySetNT (yyNTsequ_var) {
/* line 1720 "fortran.lalr" */
 yyS.Tree = mHPF_SEQUENCE_DECL (yyA [1].Scan.Ident, yyA [1].Label); 
} break;
case 1293: /* nsequ_definition : NOSEQUENCE */
yyDecrement (1) yySetNT (yyNTnsequ_definition) {
/* line 1730 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (mNOSEQUENCE_DECL (DefaultId(), yyA [0].Label), 
                             NoTree); 
} break;
case 1294: /* nsequ_definition : NOSEQUENCE opt_dcolon nsequ_var_list */
yyDecrement (3) yySetNT (yyNTnsequ_definition) {
/* line 1735 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1295: /* nsequ_var_list : nsequ_var */
yyDecrement (1) yySetNT (yyNTnsequ_var_list) {
/* line 1739 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1296: /* nsequ_var_list : nsequ_var ',' nsequ_var_list */
yyDecrement (3) yySetNT (yyNTnsequ_var_list) {
/* line 1743 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree);  
} break;
case 1297: /* nsequ_var : PIdent */
yyDecrement (1) yySetNT (yyNTnsequ_var) {
/* line 1747 "fortran.lalr" */
 yyS.Tree = mNOSEQUENCE_DECL (yyA [0].Scan.Ident, yyA [0].Label); 
} break;
case 1298:
case 906: /* nsequ_var : '/' PIdent '/' */
yyDecrement (3) yySetNT (yyNTnsequ_var) {
/* line 1751 "fortran.lalr" */
 yyS.Tree = mNOSEQUENCE_DECL (yyA [1].Scan.Ident, yyA [1].Label); 
} break;
case 1299: /* allocatable_definition : ALLOCATABLE opt_dcolon \
allocatable_var_list */
yyDecrement (3) yySetNT (yyNTallocatable_definition) {
/* line 1761 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1300: /* allocatable_var_list : allocatable_var */
yyDecrement (1) yySetNT (yyNTallocatable_var_list) {
/* line 1765 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1301: /* allocatable_var_list : allocatable_var ',' \
allocatable_var_list */
yyDecrement (3) yySetNT (yyNTallocatable_var_list) {
/* line 1769 "fortran.lalr" */
 yyS.Tree = ConcatDecls (yyA [0].Tree, yyA [2].Tree);  
} break;
case 1302: /* allocatable_var : PIdent */
yyDecrement (1) yySetNT (yyNTallocatable_var) {
/* line 1773 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (
                    mALLOCATABLE_DECL (yyA [0].Scan.Ident, yyA [0].Label),
                    NoTree); 
} break;
case 1303: /* allocatable_var : PIdent DimSpec */
yyDecrement (2) yySetNT (yyNTallocatable_var) {
/* line 1779 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (
                    mDIMENSION_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [1].Tree),
                    mDECL_LIST (mALLOCATABLE_DECL (yyA [0].Scan.Ident, yyA [0].Label),
                                NoTree)); 
} break;
case 1304: /* target_definition : TARGET opt_dcolon target_var_list */
yyDecrement (3) yySetNT (yyNTtarget_definition) {
/* line 1792 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1305: /* target_var_list : target_var */
yyDecrement (1) yySetNT (yyNTtarget_var_list) {
/* line 1796 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1306: /* target_var_list : target_var ',' target_var_list */
yyDecrement (3) yySetNT (yyNTtarget_var_list) {
/* line 1800 "fortran.lalr" */
 yyS.Tree = ConcatDecls (yyA [0].Tree, yyA [2].Tree);  
} break;
case 1307: /* target_var : PIdent */
yyDecrement (1) yySetNT (yyNTtarget_var) {
/* line 1804 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (
                    mTARGET_DECL (yyA [0].Scan.Ident, yyA [0].Label),
                    NoTree); 
} break;
case 1308: /* target_var : PIdent DimSpec */
yyDecrement (2) yySetNT (yyNTtarget_var) {
/* line 1810 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (
                  mDIMENSION_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [1].Tree),
                   mDECL_LIST( mPOINTER_DECL (yyA [0].Scan.Ident, yyA [0].Label),
                               NoTree)); 
} break;
case 1309: /* pointer_definition : POINTER opt_dcolon pointer_var_list */
yyDecrement (3) yySetNT (yyNTpointer_definition) {
/* line 1823 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1310: /* pointer_var_list : pointer_var */
yyDecrement (1) yySetNT (yyNTpointer_var_list) {
/* line 1827 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1311: /* pointer_var_list : pointer_var ',' pointer_var_list */
yyDecrement (3) yySetNT (yyNTpointer_var_list) {
/* line 1831 "fortran.lalr" */
 yyS.Tree = ConcatDecls (yyA [0].Tree, yyA [2].Tree);  
} break;
case 1312: /* pointer_var : PIdent */
yyDecrement (1) yySetNT (yyNTpointer_var) {
/* line 1835 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (
                    mPOINTER_DECL (yyA [0].Scan.Ident, yyA [0].Label),
                    NoTree); 
} break;
case 1313: /* pointer_var : PIdent DimSpec */
yyDecrement (2) yySetNT (yyNTpointer_var) {
/* line 1841 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (
                  mDIMENSION_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [1].Tree),
                   mDECL_LIST( mPOINTER_DECL (yyA [0].Scan.Ident, yyA [0].Label),
                               NoTree)); 
} break;
case 1314: /* data_statement : DATA data_defs */
yyDecrement (2) yySetNT (yyNTdata_statement) {
/* line 1854 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1315: /* data_defs : data_def */
yyDecrement (1) yySetNT (yyNTdata_defs) {
/* line 1858 "fortran.lalr" */
 yyS.Tree=mDECL_LIST (yyA [0].Tree, NoTree);  
} break;
case 1316: /* data_defs : data_def opt_comma data_defs */
yyDecrement (3) yySetNT (yyNTdata_defs) {
/* line 1862 "fortran.lalr" */
 yyS.Tree=mDECL_LIST (yyA [0].Tree, yyA [2].Tree);  
} break;
case 1317:
case 907: /* data_def : data_liste '/' data_values '/' */
yyDecrement (4) yySetNT (yyNTdata_def) {
/* line 1866 "fortran.lalr" */
 yyS.Tree = mDATA_DECL (DefaultId(), NLine (yyA [3]), yyA [0].Tree, yyA [2].Tree); 
} break;
case 1318: /* data_liste : data_elem */
yyDecrement (1) yySetNT (yyNTdata_liste) {
/* line 1870 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, mBTV_EMPTY()); 
} break;
case 1319: /* data_liste : data_elem ',' data_liste */
yyDecrement (3) yySetNT (yyNTdata_liste) {
/* line 1874 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1320: /* data_elem : variable */
yyDecrement (1) yySetNT (yyNTdata_elem) {
/* line 1878 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1321:
case 908: /* data_elem : '(' data_elem ',' impl_do_var ')' */
yyDecrement (5) yySetNT (yyNTdata_elem) {
/* line 1882 "fortran.lalr" */
 yyA [3].Tree->DO_VAR.BODY = 
         mBTV_LIST (yyA [1].Tree, yyA [3].Tree->DO_VAR.BODY); 
       yyS.Tree = yyA [3].Tree; 
} break;
case 1322: /* impl_do_var : data_elem ',' impl_do_var */
yyDecrement (3) yySetNT (yyNTimpl_do_var) {
/* line 1888 "fortran.lalr" */
 yyA [2].Tree->DO_VAR.BODY = 
         mBTV_LIST (yyA [0].Tree, yyA [2].Tree->DO_VAR.BODY); 
       yyS.Tree = yyA [2].Tree; 
} break;
case 1323: /* impl_do_var : Laufvariable '=' DoRange */
yyDecrement (3) yySetNT (yyNTimpl_do_var) {
/* line 1894 "fortran.lalr" */
 yyS.Tree = mDO_VAR (yyA [0].Tree, yyA [2].Tree, mBTV_EMPTY()); 
} break;
case 1324: /* data_values : data_value */
yyDecrement (1) yySetNT (yyNTdata_values) {
/* line 1898 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, mBTE_EMPTY()); 
} break;
case 1325: /* data_values : data_value ',' data_values */
yyDecrement (3) yySetNT (yyNTdata_values) {
/* line 1902 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1326: /* data_value : PIdent */
yyDecrement (1) yySetNT (yyNTdata_value) {
/* line 1906 "fortran.lalr" */
 yyS.Tree = mVAR_EXP (mUSED_VAR (
                               mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident))); 
} break;
case 1327: /* data_value : SignedKonstante */
yyDecrement (1) yySetNT (yyNTdata_value) {
/* line 1911 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1328: /* data_value : IntConst '*' data_real_value */
yyDecrement (3) yySetNT (yyNTdata_value) {
/* line 1915 "fortran.lalr" */
 yyS.Tree = mOP_EXP (mOP_TIMES(), 
                           mCONST_EXP (mINT_CONSTANT (yyA [0].Scan.IntConst)),
                           yyA [2].Tree); 
} break;
case 1329: /* data_value : PIdent '*' data_real_value */
yyDecrement (3) yySetNT (yyNTdata_value) {
/* line 1920 "fortran.lalr" */
 yyS.Tree = mOP_EXP (mOP_TIMES(), 
                           mVAR_EXP (mUSED_VAR (
                               mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident))),
                           yyA [2].Tree); 
} break;
case 1330: /* data_real_value : SignedKonstante */
yyDecrement (1) yySetNT (yyNTdata_real_value) {
/* line 1926 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1331: /* data_real_value : PIdent */
yyDecrement (1) yySetNT (yyNTdata_real_value) {
/* line 1930 "fortran.lalr" */
 yyS.Tree = mVAR_EXP (mUSED_VAR (
                      mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident)));
      
} break;
case 1332:
case 909: /* parameter_definition : PARAMETER '(' \
named_constant_def_list ')' */
yyDecrement (4) yySetNT (yyNTparameter_definition) {
/* line 1942 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1333: /* named_constant_def_list : named_constant_def */
yyDecrement (1) yySetNT (yyNTnamed_constant_def_list) {
/* line 1946 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1334: /* named_constant_def_list : named_constant_def ',' \
named_constant_def_list */
yyDecrement (3) yySetNT (yyNTnamed_constant_def_list) {
/* line 1950 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1335: /* named_constant_def : PIdent '=' expression */
yyDecrement (3) yySetNT (yyNTnamed_constant_def) {
/* line 1954 "fortran.lalr" */
 yyS.Tree = mPARAMETER_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [2].Tree); 
} break;
case 1336: /* derived_type_def : TYPE opt_access_spec PIdent CR1 \
private_sequence_stmts derived_type_components ENDTYPE optional_id */
yyDecrement (8) yySetNT (yyNTderived_type_def) {
/* line 1970 "fortran.lalr" */
 yyS.Tree = mRECORD_TYPE (yyA [2].Scan.Ident, 
                      CompleteDecls (ConcatDecls(yyA [4].Tree, yyA [5].Tree)));
        yyS.Tree = mTYPE_DECL (yyA [2].Scan.Ident, yyA [2].Label, yyS.Tree);
        yyS.Tree = mDECL_LIST (yyS.Tree, NoTree);            
        CheckSameIdent (yyA [2].Scan.Ident, yyA [7].Label);
      
} break;
case 1337: /* optional_id : */
yySetNT (yyNToptional_id) {
/* line 1980 "fortran.lalr" */
 yyS.Label = DefaultId(); 
} break;
case 1338: /* optional_id : PIdent */
yyDecrement (1) yySetNT (yyNToptional_id) {
/* line 1985 "fortran.lalr" */
 yyS.Label = yyA [0].Scan.Ident; 
} break;
case 1339: /* opt_access_spec : */
yySetNT (yyNTopt_access_spec) {
/* line 1990 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1340:
case 910: /* opt_access_spec : '::' */
yyDecrement (1) yySetNT (yyNTopt_access_spec) {
/* line 1994 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1341:
case 911: /* opt_access_spec : ',' access_spec '::' */
yyDecrement (3) yySetNT (yyNTopt_access_spec) {
/* line 1998 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1342: /* derived_type_components : */
yySetNT (yyNTderived_type_components) {
/* line 2002 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1343: /* derived_type_components : component_def_stmt \
derived_type_components */
yyDecrement (2) yySetNT (yyNTderived_type_components) {
/* line 2006 "fortran.lalr" */
 yyS.Tree = ConcatDecls (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1344: /* component_def_stmt : type_declaration_stmt CR1 */
yyDecrement (2) yySetNT (yyNTcomponent_def_stmt) {
/* line 2010 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1345: /* component_def_stmt : hpf_directive CR1 */
yyDecrement (2) yySetNT (yyNTcomponent_def_stmt) {
/* line 2014 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1346: /* component_def_stmt : adp_directive CR1 */
yyDecrement (2) yySetNT (yyNTcomponent_def_stmt) {
/* line 2018 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1347: /* private_sequence_stmts : */
yySetNT (yyNTprivate_sequence_stmts) {
/* line 2022 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1348: /* private_sequence_stmts : private_sequence_stmt \
private_sequence_stmts */
yyDecrement (2) yySetNT (yyNTprivate_sequence_stmts) {
/* line 2026 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1349: /* private_sequence_stmt : PRIVATE CR1 */
yyDecrement (2) yySetNT (yyNTprivate_sequence_stmt) {
/* line 2030 "fortran.lalr" */
 yyS.Tree = mPRIVATE_DECL (DefaultId(), 0); 
} break;
case 1350: /* private_sequence_stmt : SEQUENCE CR1 */
yyDecrement (2) yySetNT (yyNTprivate_sequence_stmt) {
/* line 2034 "fortran.lalr" */
 yyS.Tree = mSEQUENCE_DECL (DefaultId(), 0); 
} break;
case 1351:
case 912: /* interface_block : INTERFACE generic_spec CR1 \
interface_body_list module_procedure_stmt_list ENDINTERFACE */
yyDecrement (6) yySetNT (yyNTinterface_block) {
/* line 2047 "fortran.lalr" */
 yyS.Tree = mINTERFACE_DECL  (DefaultId(), NLine (yyA [0]), yyA [1].Tree, 
                         CompleteUnits (ConcatUnits (yyA [3].Tree, yyA [4].Tree)));
       yyS.Tree = mDECL_LIST (yyS.Tree, NoTree);                      
} break;
case 1352: /* interface_body_list : */
yySetNT (yyNTinterface_body_list) {
/* line 2053 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1353: /* interface_body_list : interface_body interface_body_list */
yyDecrement (2) yySetNT (yyNTinterface_body_list) {
/* line 2057 "fortran.lalr" */
 yyS.Tree = mUNIT_LIST (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1354: /* interface_body : subroutine_subprogram */
yyDecrement (1) yySetNT (yyNTinterface_body) {
/* line 2061 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1355: /* interface_body : function_subprogram */
yyDecrement (1) yySetNT (yyNTinterface_body) {
/* line 2065 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1356: /* module_procedure_stmt_list : */
yySetNT (yyNTmodule_procedure_stmt_list) {
/* line 2069 "fortran.lalr" */
 yyS.Tree = NoTree; 
} break;
case 1357: /* module_procedure_stmt_list : module_procedure_stmt \
module_procedure_stmt_list */
yyDecrement (2) yySetNT (yyNTmodule_procedure_stmt_list) {
/* line 2073 "fortran.lalr" */
 yyS.Tree = ConcatUnits (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1358: /* module_procedure_stmt : MODULE PROCEDURE \
procedure_name_list CR1 */
yyDecrement (4) yySetNT (yyNTmodule_procedure_stmt) {
/* line 2077 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1359: /* procedure_name_list : procedure_name */
yyDecrement (1) yySetNT (yyNTprocedure_name_list) {
/* line 2081 "fortran.lalr" */
 yyS.Tree = mUNIT_LIST (yyA [0].Tree, NoTree); 
} break;
case 1360: /* procedure_name_list : procedure_name ',' \
procedure_name_list */
yyDecrement (3) yySetNT (yyNTprocedure_name_list) {
/* line 2085 "fortran.lalr" */
 yyS.Tree = mUNIT_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1361: /* procedure_name : PIdent */
yyDecrement (1) yySetNT (yyNTprocedure_name) {
/* line 2089 "fortran.lalr" */
 yyS.Tree = mMODULE_PROC_DECL (yyA [0].Scan.Ident, yyA [0].Label); 
} break;
case 1362: /* generic_spec : */
yySetNT (yyNTgeneric_spec) {
/* line 2093 "fortran.lalr" */
 yyS.Tree = mNO_GENERIC_SPEC (); 
} break;
case 1363: /* generic_spec : PIdent */
yyDecrement (1) yySetNT (yyNTgeneric_spec) {
/* line 2096 "fortran.lalr" */
 yyS.Tree = mID_GENERIC_SPEC (yyA [0].Scan.Ident); 
} break;
case 1364:
case 913: /* generic_spec : OPERATOR '(' defined_operator ')' */
yyDecrement (4) yySetNT (yyNTgeneric_spec) {
/* line 2099 "fortran.lalr" */
 yyS.Tree = mOP_GENERIC_SPEC (yyA [2].Tree); 
} break;
case 1365:
case 914: /* generic_spec : ASSIGNMENT '(' '=' ')' */
yyDecrement (4) yySetNT (yyNTgeneric_spec) {
/* line 2102 "fortran.lalr" */
 yyS.Tree = mASSIGN_GENERIC_SPEC (); 
} break;
case 1366:
case 915: /* defined_operator : UserOp */
yyDecrement (1) yySetNT (yyNTdefined_operator) {
/* line 2105 "fortran.lalr" */
 yyS.Tree = mOP_DEFINED (yyA [0].Scan.Ident); 
} break;
case 1367: /* defined_operator : intrinsic_operator */
yyDecrement (1) yySetNT (yyNTdefined_operator) {
/* line 2108 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1368: /* intrinsic_operator : power_op */
yyDecrement (1) yySetNT (yyNTintrinsic_operator) {
/* line 2110 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1369: /* intrinsic_operator : mult_op */
yyDecrement (1) yySetNT (yyNTintrinsic_operator) {
/* line 2111 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1370: /* intrinsic_operator : add_op */
yyDecrement (1) yySetNT (yyNTintrinsic_operator) {
/* line 2112 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1371: /* intrinsic_operator : concat_op */
yyDecrement (1) yySetNT (yyNTintrinsic_operator) {
/* line 2113 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1372: /* intrinsic_operator : rel_op */
yyDecrement (1) yySetNT (yyNTintrinsic_operator) {
/* line 2114 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1373: /* intrinsic_operator : not_op */
yyDecrement (1) yySetNT (yyNTintrinsic_operator) {
/* line 2115 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1374: /* intrinsic_operator : and_op */
yyDecrement (1) yySetNT (yyNTintrinsic_operator) {
/* line 2116 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1375: /* intrinsic_operator : or_op */
yyDecrement (1) yySetNT (yyNTintrinsic_operator) {
/* line 2117 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1376: /* intrinsic_operator : equiv_op */
yyDecrement (1) yySetNT (yyNTintrinsic_operator) {
/* line 2118 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1377: /* intent_definition : INTENT '(' intent_spec ')' '::' \
intent_list */
yyDecrement (6) yySetNT (yyNTintent_definition) {
/* line 2127 "fortran.lalr" */
 yyS.Tree = yyA [5].Tree; 
        SetIntent (yyS.Tree, yyA [2].Label); 
} break;
case 1378:
case 916: /* intent_spec : IN */
yyDecrement (1) yySetNT (yyNTintent_spec) {
/* line 2132 "fortran.lalr" */
 yyS.Label = IntentIn; 
} break;
case 1379:
case 917: /* intent_spec : OUT */
yyDecrement (1) yySetNT (yyNTintent_spec) {
/* line 2136 "fortran.lalr" */
 yyS.Label = IntentOut; 
} break;
case 1380:
case 918: /* intent_spec : INOUT */
yyDecrement (1) yySetNT (yyNTintent_spec) {
/* line 2140 "fortran.lalr" */
 yyS.Label = IntentInOut; 
} break;
case 1381: /* intent_list : intent_item */
yyDecrement (1) yySetNT (yyNTintent_list) {
/* line 2144 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1382: /* intent_list : intent_item ',' intent_list */
yyDecrement (3) yySetNT (yyNTintent_list) {
/* line 2148 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1383: /* intent_item : PIdent */
yyDecrement (1) yySetNT (yyNTintent_item) {
/* line 2152 "fortran.lalr" */
 yyS.Tree = mINTENT_DECL (yyA [0].Scan.Ident, yyA [0].Label, 0); 
} break;
case 1384: /* hpf_directive : template_directive */
yyDecrement (1) yySetNT (yyNThpf_directive) {
/* line 2162 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1385: /* hpf_directive : processors_directive */
yyDecrement (1) yySetNT (yyNThpf_directive) {
/* line 2166 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1386: /* hpf_directive : align_directive */
yyDecrement (1) yySetNT (yyNThpf_directive) {
/* line 2170 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1387: /* hpf_directive : distribute_directive */
yyDecrement (1) yySetNT (yyNThpf_directive) {
/* line 2174 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1388: /* hpf_directive : dynamic_directive */
yyDecrement (1) yySetNT (yyNThpf_directive) {
/* line 2178 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1389: /* hpf_directive : combined_directive */
yyDecrement (1) yySetNT (yyNThpf_directive) {
/* line 2182 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1390: /* hpf_directive : inherit_directive */
yyDecrement (1) yySetNT (yyNThpf_directive) {
/* line 2186 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1391: /* hpf_directive : range_directive */
yyDecrement (1) yySetNT (yyNThpf_directive) {
/* line 2190 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1392: /* hpf_directive : shadow_directive */
yyDecrement (1) yySetNT (yyNThpf_directive) {
/* line 2194 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1393: /* adp_directive : trace_directive */
yyDecrement (1) yySetNT (yyNTadp_directive) {
/* line 2204 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1394: /* adp_directive : tree_directive */
yyDecrement (1) yySetNT (yyNTadp_directive) {
/* line 2208 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1395: /* adp_directive : nodsp_directive */
yyDecrement (1) yySetNT (yyNTadp_directive) {
/* line 2212 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1396: /* template_directive : TEMPLATE template_decl_list */
yyDecrement (2) yySetNT (yyNTtemplate_directive) {
/* line 2222 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1397: /* template_decl_list : template_decl */
yyDecrement (1) yySetNT (yyNTtemplate_decl_list) {
/* line 2226 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1398: /* template_decl_list : template_decl ',' \
template_decl_list */
yyDecrement (3) yySetNT (yyNTtemplate_decl_list) {
/* line 2230 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1399: /* template_decl : PIdent */
yyDecrement (1) yySetNT (yyNTtemplate_decl) {
/* line 2234 "fortran.lalr" */
 yyS.Tree = mTEMPLATE_DECL (yyA [0].Scan.Ident, yyA [0].Label, mSHAPE_EMPTY()); 
} break;
case 1400: /* template_decl : PIdent DimSpec */
yyDecrement (2) yySetNT (yyNTtemplate_decl) {
/* line 2238 "fortran.lalr" */
 yyS.Tree = mTEMPLATE_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [1].Tree); 
} break;
case 1401: /* processors_directive : PROCESSORS processors_decl_list */
yyDecrement (2) yySetNT (yyNTprocessors_directive) {
/* line 2248 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1402: /* processors_decl_list : processors_decl */
yyDecrement (1) yySetNT (yyNTprocessors_decl_list) {
/* line 2252 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1403: /* processors_decl_list : processors_decl ',' \
processors_decl_list */
yyDecrement (3) yySetNT (yyNTprocessors_decl_list) {
/* line 2256 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1404: /* processors_decl : PIdent */
yyDecrement (1) yySetNT (yyNTprocessors_decl) {
/* line 2260 "fortran.lalr" */
 yyS.Tree = mPROCESSORS_DECL (yyA [0].Scan.Ident, yyA [0].Label, mSHAPE_EMPTY()); 
} break;
case 1405: /* processors_decl : PIdent DimSpec */
yyDecrement (2) yySetNT (yyNTprocessors_decl) {
/* line 2264 "fortran.lalr" */
 yyS.Tree = mPROCESSORS_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [1].Tree); 
} break;
case 1406: /* shadow_directive : SHADOW shadow_decl_list */
yyDecrement (2) yySetNT (yyNTshadow_directive) {
/* line 2275 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1407: /* shadow_decl_list : shadow_decl */
yyDecrement (1) yySetNT (yyNTshadow_decl_list) {
/* line 2280 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1408: /* shadow_decl_list : shadow_decl ',' shadow_decl_list */
yyDecrement (3) yySetNT (yyNTshadow_decl_list) {
/* line 2285 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1409:
case 919: /* shadow_decl : PIdent '(' shadow_spec_list ')' */
yyDecrement (4) yySetNT (yyNTshadow_decl) {
/* line 2290 "fortran.lalr" */
 yyS.Tree = mSHADOW_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [2].Tree); 
} break;
case 1410: /* shadow_spec_list : shadow_spec */
yyDecrement (1) yySetNT (yyNTshadow_spec_list) {
/* line 2295 "fortran.lalr" */
 yyS.Tree = mSHADOW_LIST (yyA [0].Tree, mSHADOW_EMPTY()); 
} break;
case 1411: /* shadow_spec_list : shadow_spec ',' shadow_spec_list */
yyDecrement (3) yySetNT (yyNTshadow_spec_list) {
/* line 2300 "fortran.lalr" */
 yyS.Tree = mSHADOW_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1412: /* shadow_spec : shadow_width ':' shadow_width */
yyDecrement (3) yySetNT (yyNTshadow_spec) {
/* line 2308 "fortran.lalr" */
 yyS.Tree = mSHADOW_SPEC (1, yyA [0].Tree, yyA [2].Tree, 0, 0, 0, 0);  
} break;
case 1413: /* shadow_spec : shadow_width */
yyDecrement (1) yySetNT (yyNTshadow_spec) {
/* line 2313 "fortran.lalr" */
 yyS.Tree = mSHADOW_SPEC (1, yyA [0].Tree, CopyTree(yyA [0].Tree), 0, 0, 0, 0); 
} break;
case 1414:
case 920: /* shadow_width : '*' */
yyDecrement (1) yySetNT (yyNTshadow_width) {
/* line 2318 "fortran.lalr" */
 yyS.Tree = mDUMMY_EXP (); 
} break;
case 1415: /* shadow_width : expression */
yyDecrement (1) yySetNT (yyNTshadow_width) {
/* line 2323 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1416: /* trace_directive : TRACE opt_dcolon trace_id_list */
yyDecrement (3) yySetNT (yyNTtrace_directive) {
/* line 2334 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1417: /* trace_id_list : trace_id */
yyDecrement (1) yySetNT (yyNTtrace_id_list) {
/* line 2339 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1418: /* trace_id_list : trace_id ',' trace_id_list */
yyDecrement (3) yySetNT (yyNTtrace_id_list) {
/* line 2344 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1419: /* trace_id : PIdent */
yyDecrement (1) yySetNT (yyNTtrace_id) {
/* line 2349 "fortran.lalr" */
 yyS.Tree = mTRACE_DECL (yyA [0].Scan.Ident, yyA [0].Label);  
} break;
case 1420: /* tree_directive : TREE opt_dcolon tree_id_list */
yyDecrement (3) yySetNT (yyNTtree_directive) {
/* line 2360 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1421: /* tree_id_list : tree_id */
yyDecrement (1) yySetNT (yyNTtree_id_list) {
/* line 2365 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1422: /* tree_id_list : tree_id ',' tree_id_list */
yyDecrement (3) yySetNT (yyNTtree_id_list) {
/* line 2370 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1423: /* tree_id : PIdent */
yyDecrement (1) yySetNT (yyNTtree_id) {
/* line 2375 "fortran.lalr" */
 yyS.Tree = mTREE_DECL (yyA [0].Scan.Ident, yyA [0].Label);  
} break;
case 1424: /* nodsp_directive : NODESCRIPTOR opt_dcolon nodsp_id_list */
yyDecrement (3) yySetNT (yyNTnodsp_directive) {
/* line 2386 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1425: /* nodsp_id_list : nodsp_id */
yyDecrement (1) yySetNT (yyNTnodsp_id_list) {
/* line 2391 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1426: /* nodsp_id_list : nodsp_id ',' nodsp_id_list */
yyDecrement (3) yySetNT (yyNTnodsp_id_list) {
/* line 2396 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1427: /* nodsp_id : PIdent */
yyDecrement (1) yySetNT (yyNTnodsp_id) {
/* line 2401 "fortran.lalr" */
 yyS.Tree = mNODSP_DECL (yyA [0].Scan.Ident, yyA [0].Label);  
} break;
case 1428: /* inherit_directive : INHERIT inherit_decl_list */
yyDecrement (2) yySetNT (yyNTinherit_directive) {
/* line 2411 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1429: /* inherit_decl_list : inherit_decl */
yyDecrement (1) yySetNT (yyNTinherit_decl_list) {
/* line 2415 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1430: /* inherit_decl_list : inherit_decl ',' inherit_decl_list */
yyDecrement (3) yySetNT (yyNTinherit_decl_list) {
/* line 2419 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1431: /* inherit_decl : PIdent */
yyDecrement (1) yySetNT (yyNTinherit_decl) {
/* line 2423 "fortran.lalr" */
 yyS.Tree = mINHERIT_DECL (yyA [0].Scan.Ident, yyA [0].Label); 
} break;
case 1432: /* range_directive : RANGE PIdent range_attr_stuff_list */
yyDecrement (3) yySetNT (yyNTrange_directive) {
/* line 2434 "fortran.lalr" */
 yyA [2].Tree = mRANGE_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [2].Tree) ; 
        yyS.Tree = mDECL_LIST (yyA [2].Tree, NoTree);
      
} break;
case 1433: /* range_attr_stuff_list : range_attr_stuff \
range_attr_continue */
yyDecrement (2) yySetNT (yyNTrange_attr_stuff_list) {
/* line 2441 "fortran.lalr" */
 yyS.Tree = mRANGE_LIST (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1434: /* range_attr_continue : */
yySetNT (yyNTrange_attr_continue) {
/* line 2446 "fortran.lalr" */
 yyS.Tree = mRANGE_EMPTY(); 
} break;
case 1435: /* range_attr_continue : range_attr_stuff \
range_attr_continue */
yyDecrement (2) yySetNT (yyNTrange_attr_continue) {
/* line 2451 "fortran.lalr" */
 yyS.Tree = mRANGE_LIST (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1436:
case 921: /* range_attr_stuff : '(' dist_format_list ')' */
yyDecrement (3) yySetNT (yyNTrange_attr_stuff) {
/* line 2456 "fortran.lalr" */
 yyS.Tree = mNODE_DISTRIBUTION (0, yyA [1].Tree); 
} break;
case 1437: /* align_directive : ALIGN single_align_stuff */
yyDecrement (2) yySetNT (yyNTalign_directive) {
/* line 2466 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [1].Tree, NoTree); 
} break;
case 1438: /* single_align_stuff : HPFIdent '(' align_source_list ')' \
WITH align_spec */
yyDecrement (6) yySetNT (yyNTsingle_align_stuff) {
/* line 2470 "fortran.lalr" */
 yyS.Tree = mALIGN_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyA [2].Tree, yyA [5].Tree); 
} break;
case 1439: /* single_align_stuff : HPFIdent WITH align_spec */
yyDecrement (3) yySetNT (yyNTsingle_align_stuff) {
/* line 2474 "fortran.lalr" */
 yyS.Tree = mALIGN_DECL (yyA [0].Scan.Ident,yyA [0].Label,mBTE_EMPTY(),yyA [2].Tree); 
} break;
case 1440: /* align_source_list : align_source */
yyDecrement (1) yySetNT (yyNTalign_source_list) {
/* line 2478 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, mBTE_EMPTY()); 
} break;
case 1441: /* align_source_list : align_source ',' align_source_list */
yyDecrement (3) yySetNT (yyNTalign_source_list) {
/* line 2482 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1442:
case 922: /* align_source : ':' */
yyDecrement (1) yySetNT (yyNTalign_source) {
/* line 2486 "fortran.lalr" */
 yyS.Tree = mSLICE_EXP (mDUMMY_EXP(), mDUMMY_EXP(), mDUMMY_EXP()); 
} break;
case 1443:
case 923: /* align_source : '*' */
yyDecrement (1) yySetNT (yyNTalign_source) {
/* line 2490 "fortran.lalr" */
 yyS.Tree = mDUMMY_EXP (); 
} break;
case 1444: /* align_source : HPFIdent */
yyDecrement (1) yySetNT (yyNTalign_source) {
/* line 2494 "fortran.lalr" */
 yyS.Tree = mVAR_EXP (mUSED_VAR (mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident))); 
} break;
case 1445: /* align_spec : HPFIdent opt_align_subscript_list */
yyDecrement (2) yySetNT (yyNTalign_spec) {
/* line 2502 "fortran.lalr" */
 yyS.Tree = mALIGN_SPEC (0, mTEMP_OBJ (yyA [0].Scan.Ident), yyA [1].Tree); 
} break;
case 1446: /* align_spec : '*' HPFIdent opt_align_subscript_list */
yyDecrement (3) yySetNT (yyNTalign_spec) {
/* line 2506 "fortran.lalr" */
 yyS.Tree = mALIGN_SPEC (1, mTEMP_OBJ (yyA [1].Scan.Ident), yyA [2].Tree); 
} break;
case 1447: /* opt_align_subscript_list : */
yySetNT (yyNTopt_align_subscript_list) {
/* line 2510 "fortran.lalr" */
 yyS.Tree = mBTE_EMPTY (); 
} break;
case 1448:
case 924: /* opt_align_subscript_list : '(' align_subscript_list ')' */
yyDecrement (3) yySetNT (yyNTopt_align_subscript_list) {
/* line 2514 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1449: /* align_subscript_list : align_subscript */
yyDecrement (1) yySetNT (yyNTalign_subscript_list) {
/* line 2518 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, mBTE_EMPTY()); 
} break;
case 1450: /* align_subscript_list : align_subscript ',' \
align_subscript_list */
yyDecrement (3) yySetNT (yyNTalign_subscript_list) {
/* line 2522 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1451:
case 925: /* align_subscript : '*' */
yyDecrement (1) yySetNT (yyNTalign_subscript) {
/* line 2526 "fortran.lalr" */
 yyS.Tree = mDUMMY_EXP (); 
} break;
case 1452: /* align_subscript : Index_Elem */
yyDecrement (1) yySetNT (yyNTalign_subscript) {
/* line 2530 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1453: /* dynamic_directive : DYNAMIC dynamic_list */
yyDecrement (2) yySetNT (yyNTdynamic_directive) {
/* line 2543 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1454: /* dynamic_list : dynamic_var */
yyDecrement (1) yySetNT (yyNTdynamic_list) {
/* line 2548 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1455: /* dynamic_list : dynamic_var ',' dynamic_list */
yyDecrement (3) yySetNT (yyNTdynamic_list) {
/* line 2553 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1456: /* dynamic_var : HPFIdent */
yyDecrement (1) yySetNT (yyNTdynamic_var) {
/* line 2558 "fortran.lalr" */
 yyS.Tree = mDYNAMIC_DECL (yyA [0].Scan.Ident, yyA [0].Label); 
} break;
case 1457: /* distribute_directive : DISTRIBUTE single_dist_stuff */
yyDecrement (2) yySetNT (yyNTdistribute_directive) {
/* line 2568 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [1].Tree, NoTree); 
} break;
case 1458: /* single_dist_stuff : HPFIdent dist_format_clause opt_onto */
yyDecrement (3) yySetNT (yyNTsingle_dist_stuff) {
/* line 2572 "fortran.lalr" */
 yyS.Tree = mDISTRIBUTE_DECL(yyA [0].Scan.Ident, yyA [0].Label, 
                     yyA [1].Tree, yyA [2].Tree); 
} break;
case 1459: /* opt_onto : */
yySetNT (yyNTopt_onto) {
/* line 2577 "fortran.lalr" */
 yyS.Tree = mDEFAULT_PROCESSOR_ARRAY (); 
} break;
case 1460: /* opt_onto : dist_onto_clause */
yyDecrement (1) yySetNT (yyNTopt_onto) {
/* line 2581 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1461: /* dist_onto_clause : ONTO HPFIdent \
opt_section_subscript_list */
yyDecrement (3) yySetNT (yyNTdist_onto_clause) {
/* line 2585 "fortran.lalr" */
 SetProcessorId (yyA [2].Tree, mTOP_OBJ(yyA [1].Scan.Ident)); 
       yyS.Tree = yyA [2].Tree;
     
} break;
case 1462: /* dist_onto_clause : ONTO '*' HPFIdent \
opt_section_subscript_list */
yyDecrement (4) yySetNT (yyNTdist_onto_clause) {
/* line 2590 "fortran.lalr" */
 SetProcessorId (yyA [3].Tree, mTOP_OBJ(yyA [2].Scan.Ident)); 
       yyS.Tree = yyA [3].Tree;
     
} break;
case 1463: /* dist_onto_clause : ONTO '*' */
yyDecrement (2) yySetNT (yyNTdist_onto_clause) {
/* line 2595 "fortran.lalr" */
 yyS.Tree = mANY_PROCESSOR_ARRAY (); 
} break;
case 1464: /* opt_section_subscript_list : */
yySetNT (yyNTopt_section_subscript_list) {
/* line 2600 "fortran.lalr" */
 yyS.Tree = mPROCESSOR_ARRAY (NoTree); 
} break;
case 1465:
case 926: /* opt_section_subscript_list : '(' section_subscript_list \
')' */
yyDecrement (3) yySetNT (yyNTopt_section_subscript_list) {
/* line 2605 "fortran.lalr" */
 yyS.Tree = mPROCESSOR_SUBSET (NoTree, NoTree, yyA [1].Tree); 
} break;
case 1466:
case 927: /* dist_format_clause : '(' dist_format_list ')' */
yyDecrement (3) yySetNT (yyNTdist_format_clause) {
/* line 2615 "fortran.lalr" */
 yyS.Tree = mNODE_DISTRIBUTION (0, yyA [1].Tree); 
} break;
case 1467:
case 928: /* dist_format_clause : '*' '(' dist_format_list ')' */
yyDecrement (4) yySetNT (yyNTdist_format_clause) {
/* line 2621 "fortran.lalr" */
 yyS.Tree = mNODE_DISTRIBUTION (1, yyA [2].Tree); 
} break;
case 1468: /* dist_format_clause : '*' */
yyDecrement (1) yySetNT (yyNTdist_format_clause) {
/* line 2626 "fortran.lalr" */
 yyS.Tree = mANY_DISTRIBUTION (1);  
} break;
case 1469: /* dist_format_list : dist_format */
yyDecrement (1) yySetNT (yyNTdist_format_list) {
/* line 2637 "fortran.lalr" */
 yyS.Tree = mDIST_LIST (yyA [0].Tree, mDIST_EMPTY()); 
} break;
case 1470: /* dist_format_list : dist_format ',' dist_format_list */
yyDecrement (3) yySetNT (yyNTdist_format_list) {
/* line 2642 "fortran.lalr" */
 yyS.Tree = mDIST_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1471: /* dist_format : BLOCK */
yyDecrement (1) yySetNT (yyNTdist_format) {
/* line 2647 "fortran.lalr" */
 yyS.Tree = mBLOCK_DISTRIBUTION (mDUMMY_EXP ()); 
} break;
case 1472:
case 929: /* dist_format : BLOCK '(' expression ')' */
yyDecrement (4) yySetNT (yyNTdist_format) {
/* line 2652 "fortran.lalr" */
 yyS.Tree = mBLOCK_DISTRIBUTION (yyA [2].Tree); 
} break;
case 1473:
case 930: /* dist_format : BLOCK '(' ')' */
yyDecrement (3) yySetNT (yyNTdist_format) {
/* line 2657 "fortran.lalr" */
 yyS.Tree = mANY_BLOCK_DISTRIBUTION (); 
} break;
case 1474: /* dist_format : CYCLIC */
yyDecrement (1) yySetNT (yyNTdist_format) {
/* line 2662 "fortran.lalr" */
 yyS.Tree = mCYCLIC_DISTRIBUTION (mDUMMY_EXP ()); 
} break;
case 1475:
case 931: /* dist_format : CYCLIC '(' expression ')' */
yyDecrement (4) yySetNT (yyNTdist_format) {
/* line 2667 "fortran.lalr" */
 yyS.Tree = mCYCLIC_DISTRIBUTION (yyA [2].Tree); 
} break;
case 1476:
case 932: /* dist_format : CYCLIC '(' ')' */
yyDecrement (3) yySetNT (yyNTdist_format) {
/* line 2672 "fortran.lalr" */
 yyS.Tree = mANY_CYCLIC_DISTRIBUTION (); 
} break;
case 1477:
case 933: /* dist_format : GEN_BLOCK '(' variable ')' */
yyDecrement (4) yySetNT (yyNTdist_format) {
/* line 2677 "fortran.lalr" */
 yyS.Tree = mGEN_BLOCK_DISTRIBUTION (yyA [2].Tree); 
} break;
case 1478:
case 934: /* dist_format : GEN_BLOCK '(' ')' */
yyDecrement (3) yySetNT (yyNTdist_format) {
/* line 2682 "fortran.lalr" */
 yyS.Tree = mANY_GEN_BLOCK_DISTRIBUTION (); 
} break;
case 1479:
case 935: /* dist_format : INDIRECT '(' variable ')' */
yyDecrement (4) yySetNT (yyNTdist_format) {
/* line 2687 "fortran.lalr" */
 yyS.Tree = mINDIRECT_DISTRIBUTION (yyA [2].Tree); 
} break;
case 1480:
case 936: /* dist_format : ARBITRARY '(' expression ',' variable ',' \
variable ')' */
yyDecrement (8) yySetNT (yyNTdist_format) {
/* line 2692 "fortran.lalr" */
 yyS.Tree = mARBITRARY_DISTRIBUTION (yyA [2].Tree, yyA [4].Tree, yyA [6].Tree); 
} break;
case 1481:
case 937: /* dist_format : INDIRECT '(' ')' */
yyDecrement (3) yySetNT (yyNTdist_format) {
/* line 2697 "fortran.lalr" */
 yyS.Tree = mANY_INDIRECT_DISTRIBUTION (); 
} break;
case 1482:
case 938: /* dist_format : ARBITRARY '(' ')' */
yyDecrement (3) yySetNT (yyNTdist_format) {
/* line 2702 "fortran.lalr" */
 yyS.Tree = mANY_ARBITRARY_DISTRIBUTION (); 
} break;
case 1483:
case 939: /* dist_format : '*' */
yyDecrement (1) yySetNT (yyNTdist_format) {
/* line 2707 "fortran.lalr" */
 yyS.Tree = mSERIAL_DISTRIBUTION (); 
} break;
case 1484:
case 940: /* dist_format : ALL */
yyDecrement (1) yySetNT (yyNTdist_format) {
/* line 2712 "fortran.lalr" */
 yyS.Tree = mANY_DIM_DISTRIBUTION (); 
} break;
case 1485: /* combined_directive : combined_att_list '::' \
object_name_list */
yyDecrement (3) yySetNT (yyNTcombined_directive) {
/* line 2722 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree;
       /* set all Attributes to Entity Declaration Attributes */
       SetAttributes (yyA [0].Tree, yyS.Tree); 
     
} break;
case 1486: /* object_name_list : object_name */
yyDecrement (1) yySetNT (yyNTobject_name_list) {
/* line 2729 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1487: /* object_name_list : object_name ',' object_name_list */
yyDecrement (3) yySetNT (yyNTobject_name_list) {
/* line 2733 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1488: /* object_name : HPFIdent opt_array_spec */
yyDecrement (2) yySetNT (yyNTobject_name) {
/* line 2738 "fortran.lalr" */
 yyS.Tree = mDECL_EMPTY ();
      if (yyA [1].Tree != NoTree)
         yyS.Tree = mDECL_LIST (yyA [1].Tree, yyS.Tree);
      yyS.Tree = mENTITY_DECL (yyA [0].Scan.Ident, yyA [0].Label, yyS.Tree); 
} break;
case 1489: /* combined_att_list : combined_att */
yyDecrement (1) yySetNT (yyNTcombined_att_list) {
/* line 2745 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, NoTree); 
} break;
case 1490: /* combined_att_list : combined_att ',' combined_att_list */
yyDecrement (3) yySetNT (yyNTcombined_att_list) {
/* line 2749 "fortran.lalr" */
 yyS.Tree = mDECL_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1491: /* combined_att : ALIGN align_attribute_stuff */
yyDecrement (2) yySetNT (yyNTcombined_att) {
/* line 2753 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1492: /* combined_att : DISTRIBUTE dist_attribute_stuff */
yyDecrement (2) yySetNT (yyNTcombined_att) {
/* line 2765 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1493:
case 941: /* combined_att : DYNAMIC */
yyDecrement (1) yySetNT (yyNTcombined_att) {
/* line 2780 "fortran.lalr" */
 yyS.Tree = mDYNAMIC_DECL (DefaultId(), 0); 
} break;
case 1494:
case 942: /* combined_att : INHERIT */
yyDecrement (1) yySetNT (yyNTcombined_att) {
/* line 2784 "fortran.lalr" */
 yyS.Tree = mINHERIT_DECL (DefaultId(), 0); 
} break;
case 1495:
case 943: /* combined_att : TEMPLATE */
yyDecrement (1) yySetNT (yyNTcombined_att) {
/* line 2797 "fortran.lalr" */
 yyS.Tree = mTEMPLATE_DECL (DefaultId(), 0, mSHAPE_EMPTY()); 
} break;
case 1496:
case 944: /* combined_att : PROCESSORS */
yyDecrement (1) yySetNT (yyNTcombined_att) {
/* line 2801 "fortran.lalr" */
 yyS.Tree = mPROCESSORS_DECL (DefaultId(), 0, mSHAPE_EMPTY()); 
} break;
case 1497: /* combined_att : DIMENSION DimSpec */
yyDecrement (2) yySetNT (yyNTcombined_att) {
/* line 2805 "fortran.lalr" */
 yyS.Tree = mDIMENSION_DECL (DefaultId(), 0, yyA [1].Tree); 
} break;
case 1498:
case 945: /* combined_att : SHADOW '(' shadow_spec_list ')' */
yyDecrement (4) yySetNT (yyNTcombined_att) {
/* line 2810 "fortran.lalr" */
 yyS.Tree = mSHADOW_DECL (DefaultId(), 0, yyA [2].Tree); 
} break;
case 1499: /* combined_att : RANGE range_attr_stuff_list */
yyDecrement (2) yySetNT (yyNTcombined_att) {
/* line 2815 "fortran.lalr" */
 yyS.Tree = mRANGE_DECL (DefaultId(), 0,  yyA [1].Tree); 
} break;
case 1500: /* align_attribute_stuff : WITH align_spec */
yyDecrement (2) yySetNT (yyNTalign_attribute_stuff) {
/* line 2757 "fortran.lalr" */
 yyS.Tree = mALIGN_DECL (DefaultId(), 0, mBTE_EMPTY(), yyA [1].Tree); 
} break;
case 1501: /* align_attribute_stuff : '(' align_source_list ')' WITH \
align_spec */
yyDecrement (5) yySetNT (yyNTalign_attribute_stuff) {
/* line 2761 "fortran.lalr" */
 yyS.Tree = mALIGN_DECL (DefaultId(), 0, yyA [1].Tree, yyA [4].Tree); 
} break;
case 1502: /* dist_attribute_stuff : dist_format_clause opt_onto */
yyDecrement (2) yySetNT (yyNTdist_attribute_stuff) {
/* line 2769 "fortran.lalr" */
 yyS.Tree = mDISTRIBUTE_DECL (DefaultId(), 0, yyA [0].Tree, yyA [1].Tree); 
} break;
case 1503: /* dist_attribute_stuff : dist_onto_clause */
yyDecrement (1) yySetNT (yyNTdist_attribute_stuff) {
/* line 2774 "fortran.lalr" */
 yyS.Tree = mDEFAULT_DISTRIBUTION (0);
       yyS.Tree = mDISTRIBUTE_DECL (DefaultId(), 0, yyS.Tree, yyA [0].Tree);
     
} break;
case 1504: /* execution_part : executable_construct CR1 \
execution_block */
yyDecrement (3) yySetNT (yyNTexecution_part) {
/* line 2829 "fortran.lalr" */
 yyS.Tree = mACF_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1505: /* execution_part : */
yySetNT (yyNTexecution_part) {
/* line 2833 "fortran.lalr" */
 yyS.Tree = mACF_EMPTY (); 
} break;
case 1506: /* execution_block : execution_part_construct CR1 \
execution_block */
yyDecrement (3) yySetNT (yyNTexecution_block) {
/* line 2837 "fortran.lalr" */
 yyS.Tree = mACF_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1507: /* execution_block : */
yySetNT (yyNTexecution_block) {
/* line 2841 "fortran.lalr" */
 yyS.Tree = mACF_EMPTY (); 
} break;
case 1508: /* execution_part_construct : executable_construct */
yyDecrement (1) yySetNT (yyNTexecution_part_construct) {
/* line 2845 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1509: /* execution_part_construct : opt_label data_statement */
yyDecrement (2) yySetNT (yyNTexecution_part_construct) {
/* line 2849 "fortran.lalr" */
 /* label will be ignored */
       yyS.Tree = yyA [1].Tree; 
     
} break;
case 1510: /* execution_part_construct : opt_label format_statement */
yyDecrement (2) yySetNT (yyNTexecution_part_construct) {
/* line 2855 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
       SetDefinitionLabel (yyS.Tree, yyA [0].Label);
     
} break;
case 1511: /* executable_construct : opt_label statement */
yyDecrement (2) yySetNT (yyNTexecutable_construct) {
/* line 2864 "fortran.lalr" */
  /* not the same : SetACFNode (yyA [1].Tree, yyA [0].Label, yyA [1].Line); */

        SetACFNodeLine (yyA [1].Tree, yyA [1].Line);
        SetACFNodeLabel (yyA [1].Tree, yyA [0].Label);

        yyS.Tree = yyA [1].Tree; 
     
} break;
case 1512: /* statement : action_stmt */
yyDecrement (1) yySetNT (yyNTstatement) {
/* line 2874 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree;
       yyS.Line = yyA [0].Line; 
} break;
case 1513: /* statement : entry_statement */
yyDecrement (1) yySetNT (yyNTstatement) {
/* line 2880 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree;
       yyS.Line = yyA [0].Line;
     
} break;
case 1514: /* statement : hpf_statement */
yyDecrement (1) yySetNT (yyNTstatement) {
/* line 2886 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
       yyS.Line = yyA [0].Line;
     
} break;
case 1515: /* statement : adp_statement */
yyDecrement (1) yySetNT (yyNTstatement) {
/* line 2892 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
       yyS.Line = yyA [0].Line;
     
} break;
case 1516: /* statement : structured_statement */
yyDecrement (1) yySetNT (yyNTstatement) {
/* line 2898 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
       yyS.Line = yyA [0].Line;
     
} break;
case 1517: /* structured_statement : where_construct */
yyDecrement (1) yySetNT (yyNTstructured_statement) {
/* line 2910 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1518: /* structured_statement : case_construct */
yyDecrement (1) yySetNT (yyNTstructured_statement) {
/* line 2915 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1519: /* structured_statement : PIdent ':' case_construct */
yyDecrement (3) yySetNT (yyNTstructured_statement) {
/* line 2920 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree;
       yyS.Line = yyA [2].Line;
       yyS.Tree->ACF_NODE.Label = - (yyA [0].Scan.Ident);
       /* negative label stands for tIdent */
     
} break;
case 1520: /* structured_statement : struct_loop_statement */
yyDecrement (1) yySetNT (yyNTstructured_statement) {
/* line 3444 "fortran.lalr" */
 SetSerial (yyA [0].Tree);   /* set info in ACF_DO, ACF_FORALL */

        yyS.Tree = yyA [0].Tree;
        yyS.Line = yyA [0].Line;
      
} break;
case 1521: /* structured_statement : independent_clause \
struct_loop_statement */
yyDecrement (2) yySetNT (yyNTstructured_statement) {
/* line 3453 "fortran.lalr" */
 SetIndependent (yyA [1].Tree);  

        SetACFNodeLine (yyA [1].Tree, yyA [1].Line);
        yyS.Tree = ApplyParInfo (yyA [1].Tree, yyA [0].Tree, yyA [0].Line);
        yyS.Line = yyA [0].Line;
      
} break;
case 1522: /* structured_statement : PIdent ':' if_construct */
yyDecrement (3) yySetNT (yyNTstructured_statement) {
/* line 3683 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree;
        yyS.Line = yyA [2].Line;
        yyS.Tree->ACF_NODE.Label = - (yyA [0].Scan.Ident);
        /* negative label stands for tIdent */
      
} break;
case 1523: /* structured_statement : if_construct */
yyDecrement (1) yySetNT (yyNTstructured_statement) {
/* line 3691 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1524: /* action_stmt : allocate_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2934 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;             
} break;
case 1525: /* action_stmt : assignment_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2939 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree);
       yyS.Line = yyA [0].Line;                
} break;
case 1526: /* action_stmt : call_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2944 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       SetACFNode (yyS.Tree, 0, yyA [0].Line);
       yyS.Line = yyA [0].Line;             
} break;
case 1527: /* action_stmt : continue_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2950 "fortran.lalr" */
 yyS.Tree = mACF_DUMMY (); 
       yyS.Line = yyA [0].Line;             
} break;
case 1528: /* action_stmt : cycle_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2955 "fortran.lalr" */
 yyS.Tree = mACF_BASIC (yyA [0].Tree);
       yyS.Line = yyA [0].Line;             
} break;
case 1529: /* action_stmt : deallocate_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2960 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;            
} break;
case 1530: /* action_stmt : exit_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2965 "fortran.lalr" */
 yyS.Tree = mACF_BASIC (yyA [0].Tree);
       yyS.Line = yyA [0].Line;             
} break;
case 1531: /* action_stmt : goto_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2970 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree;
       yyS.Line = yyA [0].Line;  
} break;
case 1532: /* action_stmt : if_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2975 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree;
       yyS.Line = yyA [0].Line;             
} break;
case 1533: /* action_stmt : io_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2980 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
       yyS.Line = yyA [0].Line;             
} break;
case 1534: /* action_stmt : nullify_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2985 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;             
} break;
case 1535: /* action_stmt : return_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2990 "fortran.lalr" */
 yyS.Tree = mACF_BASIC (yyA [0].Tree); 
       yyS.Line = yyA [0].Line;             
} break;
case 1536: /* action_stmt : stop_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 2995 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;             
} break;
case 1537: /* action_stmt : where_statement */
yyDecrement (1) yySetNT (yyNTaction_stmt) {
/* line 3000 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree;
       yyS.Line = yyA [0].Line;             
} break;
case 1538:
case 946: /* used_label : IntConst */
yyDecrement (1) yySetNT (yyNTused_label) {
/* line 3011 "fortran.lalr" */
 LabelUse (yyA [0].Scan.IntConst);
       yyS.Label = yyA [0].Scan.IntConst;            
} break;
case 1539: /* goto_statement : GOTO used_label */
yyDecrement (2) yySetNT (yyNTgoto_statement) {
/* line 3015 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(mGOTO_STMT ( yyA [1].Label )); 
       yyS.Line = NLine(yyA [0]);                                            
} break;
case 1540: /* goto_statement : GOTO PIdent assigned_labels */
yyDecrement (3) yySetNT (yyNTgoto_statement) {
/* line 3020 "fortran.lalr" */
 yyA [1].Tree = mUSED_VAR (mVAR_OBJ (yyA [1].Label, yyA [1].Scan.Ident));
       yyS.Tree = mACF_BASIC(mASS_GOTO_STMT (yyA [1].Tree, yyA [2].Tree)); 
       yyS.Line = NLine(yyA [0]);                                            
} break;
case 1541: /* goto_statement : GOTO '(' label_list ')' opt_comma \
expression */
yyDecrement (6) yySetNT (yyNTgoto_statement) {
/* line 3038 "fortran.lalr" */
 yyS.Tree = mACF_BASIC (mCOMP_GOTO_STMT(yyA [2].Tree, yyA [5].Tree)); 
       yyS.Line = NLine(yyA [0]);
     
} break;
case 1542: /* assigned_labels : */
yySetNT (yyNTassigned_labels) {
/* line 3026 "fortran.lalr" */
 yyS.Tree = mLABEL_EMPTY (); 
} break;
case 1543:
case 947: /* assigned_labels : opt_comma '(' label_list ')' */
yyDecrement (4) yySetNT (yyNTassigned_labels) {
/* line 3029 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1544: /* label_list : used_label */
yyDecrement (1) yySetNT (yyNTlabel_list) {
/* line 3032 "fortran.lalr" */
 yyS.Tree = mLABEL_LIST (yyA [0].Label, mLABEL_EMPTY ()); 
} break;
case 1545: /* label_list : used_label ',' label_list */
yyDecrement (3) yySetNT (yyNTlabel_list) {
/* line 3035 "fortran.lalr" */
 yyS.Tree = mLABEL_LIST (yyA [0].Label, yyA [2].Tree); 
} break;
case 1546: /* assignment_statement : variable '=' expression */
yyDecrement (3) yySetNT (yyNTassignment_statement) {
/* line 3043 "fortran.lalr" */
 yyS.Tree = mASSIGN_STMT (yyA [0].Tree, yyA [2].Tree); 
       yyS.Line = NLine(yyA [1]);            
} break;
case 1547: /* assignment_statement : variable '=>' expression */
yyDecrement (3) yySetNT (yyNTassignment_statement) {
/* line 3048 "fortran.lalr" */
 yyS.Tree = mPTR_ASSIGN_STMT (yyA [0].Tree, yyA [2].Tree); 
       yyS.Line = NLine(yyA [1]);            
} break;
case 1548: /* assignment_statement : ASSIGN used_label TO PIdent */
yyDecrement (4) yySetNT (yyNTassignment_statement) {
/* line 3053 "fortran.lalr" */
 yyA [3].Tree = mUSED_VAR (mVAR_OBJ (yyA [3].Label, yyA [3].Scan.Ident)); 
       yyS.Tree = mLABEL_ASSIGN_STMT (yyA [1].Label, yyA [3].Tree); 
       yyS.Line = NLine(yyA [0]);            
} break;
case 1549: /* stop_statement : STOP */
yyDecrement (1) yySetNT (yyNTstop_statement) {
/* line 3059 "fortran.lalr" */
 yyS.Tree = mSTOP_STMT (mDUMMY_EXP()); 
       yyS.Line = NLine(yyA [0]);     
} break;
case 1550: /* stop_statement : STOP expression */
yyDecrement (2) yySetNT (yyNTstop_statement) {
/* line 3064 "fortran.lalr" */
 yyS.Tree = mSTOP_STMT (yyA [1].Tree); 
       yyS.Line = NLine(yyA [0]);  
} break;
case 1551:
case 948: /* continue_statement : CONTINUE */
yyDecrement (1) yySetNT (yyNTcontinue_statement) {
/* line 3069 "fortran.lalr" */
 yyS.Line = NLine(yyA [0]); 
} break;
case 1552: /* return_statement : RETURN */
yyDecrement (1) yySetNT (yyNTreturn_statement) {
/* line 3073 "fortran.lalr" */
 yyS.Tree = mRETURN_STMT (mDUMMY_EXP()); 
       yyS.Line = NLine(yyA [0]);         
} break;
case 1553: /* return_statement : RETURN expression */
yyDecrement (2) yySetNT (yyNTreturn_statement) {
/* line 3078 "fortran.lalr" */
 yyS.Tree = mRETURN_STMT (yyA [1].Tree); 
       yyS.Line = NLine(yyA [0]);         
} break;
case 1554: /* exit_statement : EXIT PIdent */
yyDecrement (2) yySetNT (yyNTexit_statement) {
/* line 3083 "fortran.lalr" */
 yyS.Tree = mEXIT_STMT (yyA [1].Scan.Ident);
       yyS.Line = NLine(yyA [0]);         
} break;
case 1555: /* exit_statement : EXIT */
yyDecrement (1) yySetNT (yyNTexit_statement) {
/* line 3088 "fortran.lalr" */
 yyS.Tree = mEXIT_STMT (DefaultId());
       yyS.Line = NLine(yyA [0]);         
} break;
case 1556: /* exit_statement : CYCLE PIdent */
yyDecrement (2) yySetNT (yyNTexit_statement) {
/* line 3093 "fortran.lalr" */
 yyS.Tree = mCYCLE_STMT (yyA [1].Scan.Ident);
       yyS.Line = NLine(yyA [0]);         
} break;
case 1557: /* cycle_statement : CYCLE */
yyDecrement (1) yySetNT (yyNTcycle_statement) {
/* line 3098 "fortran.lalr" */
 yyS.Tree = mCYCLE_STMT (DefaultId());
       yyS.Line = NLine(yyA [0]);         
} break;
case 1558:
case 949: /* allocate_statement : ALLOCATE '(' params ')' */
yyDecrement (4) yySetNT (yyNTallocate_statement) {
/* line 3103 "fortran.lalr" */
 yyS.Tree = mALLOCATE_STMT (yyA [2].Tree, mDUMMY_VAR()); 
       yyS.Line = NLine(yyA [0]);                   
} break;
case 1559: /* allocate_statement : ALLOCATE TREE param */
yyDecrement (3) yySetNT (yyNTallocate_statement) {
/* line 3108 "fortran.lalr" */
 yyS.Tree = mALLOCATE_STMT (mBTP_LIST (yyA [2].Tree, mBTP_EMPTY()), mDUMMY_VAR()); 
       yyS.Line = NLine(yyA [0]);                   
} break;
case 1560:
case 950: /* deallocate_statement : DEALLOCATE '(' params ')' */
yyDecrement (4) yySetNT (yyNTdeallocate_statement) {
/* line 3113 "fortran.lalr" */
 yyS.Tree = mDEALLOCATE_STMT (yyA [2].Tree, mDUMMY_VAR()); 
       yyS.Line = NLine(yyA [0]);                     
} break;
case 1561: /* deallocate_statement : DEALLOCATE TREE param */
yyDecrement (3) yySetNT (yyNTdeallocate_statement) {
/* line 3118 "fortran.lalr" */
 yyS.Tree = mDEALLOCATE_STMT (mBTP_LIST (yyA [2].Tree, mBTP_EMPTY()), mDUMMY_VAR()); 
       yyS.Line = NLine(yyA [0]);                   
} break;
case 1562:
case 951: /* nullify_statement : NULLIFY '(' params ')' */
yyDecrement (4) yySetNT (yyNTnullify_statement) {
/* line 3123 "fortran.lalr" */
 yyS.Tree = mNULLIFY_STMT (yyA [2].Tree); 
       yyS.Line = NLine(yyA [0]);                     
} break;
case 1563: /* call_statement : CALL PIdent */
yyDecrement (2) yySetNT (yyNTcall_statement) {
/* line 3128 "fortran.lalr" */
 yyS.Tree = mCALL_STMT (mPROC_OBJ (yyA [1].Scan.Ident), mBTP_EMPTY()); 
       yyS.Line = NLine(yyA [0]);      
} break;
case 1564:
case 952: /* call_statement : CALL PIdent '(' ')' */
yyDecrement (4) yySetNT (yyNTcall_statement) {
/* line 3132 "fortran.lalr" */
 yyS.Tree = mCALL_STMT (mPROC_OBJ (yyA [1].Scan.Ident), mBTP_EMPTY()); 
       yyS.Line = NLine(yyA [0]);      
} break;
case 1565:
case 953: /* call_statement : CALL PIdent '(' params ')' */
yyDecrement (5) yySetNT (yyNTcall_statement) {
/* line 3136 "fortran.lalr" */
 yyS.Tree = mCALL_STMT (mPROC_OBJ (yyA [1].Scan.Ident), yyA [3].Tree); 
       yyS.Line = NLine(yyA [0]);      
} break;
case 1566: /* params : param */
yyDecrement (1) yySetNT (yyNTparams) {
/* line 3140 "fortran.lalr" */
 yyS.Tree = mBTP_LIST (yyA [0].Tree, mBTP_EMPTY()); 
} break;
case 1567: /* params : param ',' params */
yyDecrement (3) yySetNT (yyNTparams) {
/* line 3143 "fortran.lalr" */
 yyS.Tree = mBTP_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1568: /* param : PIdent '=' expression */
yyDecrement (3) yySetNT (yyNTparam) {
/* line 3146 "fortran.lalr" */
 yyS.Tree = mNAMED_PARAM (yyA [0].Scan.Ident, mVALUE_PARAM (yyA [2].Tree)); 
} break;
case 1569: /* param : expression */
yyDecrement (1) yySetNT (yyNTparam) {
/* line 3149 "fortran.lalr" */
 yyS.Tree = mVALUE_PARAM (yyA [0].Tree); 
} break;
case 1570: /* param : '*' used_label */
yyDecrement (2) yySetNT (yyNTparam) {
/* line 3152 "fortran.lalr" */
 yyS.Tree = mRETURN_PARAM (yyA [1].Label); 
} break;
case 1571: /* io_statement : print_statement */
yyDecrement (1) yySetNT (yyNTio_statement) {
/* line 3161 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;              
} break;
case 1572: /* io_statement : read_statement */
yyDecrement (1) yySetNT (yyNTio_statement) {
/* line 3166 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;              
} break;
case 1573: /* io_statement : write_statement */
yyDecrement (1) yySetNT (yyNTio_statement) {
/* line 3171 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;              
} break;
case 1574: /* io_statement : open_statement */
yyDecrement (1) yySetNT (yyNTio_statement) {
/* line 3176 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;              
} break;
case 1575: /* io_statement : close_statement */
yyDecrement (1) yySetNT (yyNTio_statement) {
/* line 3181 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;              
} break;
case 1576: /* io_statement : rewind_statement */
yyDecrement (1) yySetNT (yyNTio_statement) {
/* line 3186 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;              
} break;
case 1577: /* io_statement : backspace_statement */
yyDecrement (1) yySetNT (yyNTio_statement) {
/* line 3191 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;              
} break;
case 1578: /* io_statement : endfile_statement */
yyDecrement (1) yySetNT (yyNTio_statement) {
/* line 3196 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;              
} break;
case 1579: /* io_statement : inquire_statement */
yyDecrement (1) yySetNT (yyNTio_statement) {
/* line 3201 "fortran.lalr" */
 yyS.Tree = mACF_BASIC(yyA [0].Tree); 
       yyS.Line = yyA [0].Line;              
} break;
case 1580: /* write_statement : WRITE io_specification */
yyDecrement (2) yySetNT (yyNTwrite_statement) {
/* line 3206 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent ("WRITE")),
                           yyA [1].Tree, mBTP_EMPTY ()    );   
       yyS.Line = NLine(yyA [0]);   
} break;
case 1581: /* write_statement : WRITE io_specification io_list */
yyDecrement (3) yySetNT (yyNTwrite_statement) {
/* line 3212 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent ("WRITE")),
                           yyA [1].Tree, yyA [2].Tree);                 
       yyS.Line = NLine(yyA [0]);   
} break;
case 1582: /* print_statement : PRINT format_identifier */
yyDecrement (2) yySetNT (yyNTprint_statement) {
/* line 3218 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("PRINT")),
                           mBTP_LIST(yyA [1].Tree, mBTP_EMPTY ()), 
                           mBTP_EMPTY ()     );
       yyS.Line = NLine(yyA [0]);   
} break;
case 1583: /* print_statement : PRINT format_identifier ',' io_list */
yyDecrement (4) yySetNT (yyNTprint_statement) {
/* line 3225 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("PRINT")),
                           mBTP_LIST(yyA [1].Tree, mBTP_EMPTY ()), 
                           yyA [3].Tree     );    
       yyS.Line = NLine(yyA [0]);   
} break;
case 1584: /* read_statement : READ format_identifier */
yyDecrement (2) yySetNT (yyNTread_statement) {
/* line 3232 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("READ")),
                           mBTP_LIST(yyA [1].Tree, mBTP_EMPTY ()), 
                           mBTP_EMPTY ()     );    
       yyS.Line = NLine(yyA [0]);   
} break;
case 1585: /* read_statement : READ format_identifier ',' io_list */
yyDecrement (4) yySetNT (yyNTread_statement) {
/* line 3239 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("READ")),
                           mBTP_LIST(yyA [1].Tree, mBTP_EMPTY ()), 
                           yyA [3].Tree     );    
       yyS.Line = NLine(yyA [0]);                
} break;
case 1586: /* read_statement : READ io_specification */
yyDecrement (2) yySetNT (yyNTread_statement) {
/* line 3246 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("READ")),
                           yyA [1].Tree, mBTP_EMPTY ()    );    
       yyS.Line = NLine(yyA [0]);                
} break;
case 1587: /* read_statement : READ io_specification io_list */
yyDecrement (3) yySetNT (yyNTread_statement) {
/* line 3252 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("READ")),
                           yyA [1].Tree, yyA [2].Tree);
       yyS.Line = NLine(yyA [0]);                
} break;
case 1588: /* open_statement : OPEN io_specification */
yyDecrement (2) yySetNT (yyNTopen_statement) {
/* line 3258 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("OPEN")),
                           yyA [1].Tree, mBTP_EMPTY());
       yyS.Line = NLine(yyA [0]);                
} break;
case 1589: /* close_statement : CLOSE io_specification */
yyDecrement (2) yySetNT (yyNTclose_statement) {
/* line 3264 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("CLOSE")),
                           yyA [1].Tree, mBTP_EMPTY());
       yyS.Line = NLine(yyA [0]);                
} break;
case 1590: /* rewind_statement : REWIND external_file_unit */
yyDecrement (2) yySetNT (yyNTrewind_statement) {
/* line 3270 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("REWIND")),
                           mBTP_LIST (yyA [1].Tree, mBTP_EMPTY()),
                           mBTP_EMPTY ())   ;
       yyS.Line = NLine(yyA [0]);                
} break;
case 1591: /* rewind_statement : REWIND io_specification */
yyDecrement (2) yySetNT (yyNTrewind_statement) {
/* line 3278 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("REWIND")),
                           yyA [1].Tree, mBTP_EMPTY ())   ;
       yyS.Line = NLine(yyA [0]);                
} break;
case 1592: /* backspace_statement : BACKSPACE external_file_unit */
yyDecrement (2) yySetNT (yyNTbackspace_statement) {
/* line 3284 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("BACKSPACE")),
                           mBTP_LIST (yyA [1].Tree, mBTP_EMPTY()),
                           mBTP_EMPTY ())   ;
       yyS.Line = NLine(yyA [0]);                
} break;
case 1593: /* backspace_statement : BACKSPACE io_specification */
yyDecrement (2) yySetNT (yyNTbackspace_statement) {
/* line 3291 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("BACKSPACE")),
                           yyA [1].Tree, mBTP_EMPTY ())   ;
       yyS.Line = NLine(yyA [0]);                
} break;
case 1594: /* endfile_statement : ENDFILE external_file_unit */
yyDecrement (2) yySetNT (yyNTendfile_statement) {
/* line 3297 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("ENDFILE")),
                           mBTP_LIST (yyA [1].Tree, mBTP_EMPTY()),
                           mBTP_EMPTY ())   ;
       yyS.Line = NLine(yyA [0]);                
} break;
case 1595: /* endfile_statement : ENDFILE io_specification */
yyDecrement (2) yySetNT (yyNTendfile_statement) {
/* line 3304 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("ENDFILE")),
                           yyA [1].Tree, mBTP_EMPTY ())   ;
       yyS.Line = NLine(yyA [0]);                
} break;
case 1596: /* inquire_statement : INQUIRE io_specification */
yyDecrement (2) yySetNT (yyNTinquire_statement) {
/* line 3310 "fortran.lalr" */
 yyS.Tree = mIO_STMT (mPROC_OBJ (IsIdent("INQUIRE")),
                           yyA [1].Tree, mBTP_EMPTY());
       yyS.Line = NLine(yyA [0]);                
} break;
case 1597:
case 954: /* external_file_unit : IntConst */
yyDecrement (1) yySetNT (yyNTexternal_file_unit) {
/* line 3316 "fortran.lalr" */
 yyS.Tree = mVALUE_PARAM (mCONST_EXP (mINT_CONSTANT (yyA [0].Scan.IntConst))); 
} break;
case 1598: /* external_file_unit : variable */
yyDecrement (1) yySetNT (yyNTexternal_file_unit) {
/* line 3320 "fortran.lalr" */
 yyS.Tree = mVAR_PARAM (yyA [0].Tree); 
} break;
case 1599:
case 955: /* io_specification : '(' io_spec_list ')' */
yyDecrement (3) yySetNT (yyNTio_specification) {
/* line 3330 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1600: /* io_spec_list : io_spec */
yyDecrement (1) yySetNT (yyNTio_spec_list) {
/* line 3334 "fortran.lalr" */
 yyS.Tree = mBTP_LIST (yyA [0].Tree, mBTP_EMPTY ()); 
} break;
case 1601: /* io_spec_list : io_spec ',' io_spec_list */
yyDecrement (3) yySetNT (yyNTio_spec_list) {
/* line 3338 "fortran.lalr" */
 yyS.Tree = mBTP_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1602: /* io_spec : expression */
yyDecrement (1) yySetNT (yyNTio_spec) {
/* line 3342 "fortran.lalr" */
 yyS.Tree = mVALUE_PARAM (yyA [0].Tree); 
} break;
case 1603: /* io_spec : PIdent '=' expression */
yyDecrement (3) yySetNT (yyNTio_spec) {
/* line 3346 "fortran.lalr" */
 yyS.Tree = mNAMED_PARAM (yyA [0].Scan.Ident, mVALUE_PARAM (yyA [2].Tree)); 
} break;
case 1604:
case 956: /* io_spec : '*' */
yyDecrement (1) yySetNT (yyNTio_spec) {
/* line 3350 "fortran.lalr" */
 yyS.Tree = mVALUE_PARAM (mDUMMY_EXP()); 
} break;
case 1605:
case 957: /* io_spec : PIdent '=' '*' */
yyDecrement (3) yySetNT (yyNTio_spec) {
/* line 3354 "fortran.lalr" */
 yyS.Tree = mNAMED_PARAM (yyA [0].Scan.Ident, mVALUE_PARAM (mDUMMY_EXP())); 
} break;
case 1606: /* format_identifier : used_label */
yyDecrement (1) yySetNT (yyNTformat_identifier) {
/* line 3358 "fortran.lalr" */
 yyA [0].Tree = mCONST_EXP (mINT_CONSTANT (yyA [0].Label));
       yyS.Tree = mVALUE_PARAM (yyA [0].Tree); 
} break;
case 1607:
case 958: /* format_identifier : '*' */
yyDecrement (1) yySetNT (yyNTformat_identifier) {
/* line 3363 "fortran.lalr" */
 yyS.Tree = mVALUE_PARAM (mDUMMY_EXP()); 
} break;
case 1608:
case 959: /* format_identifier : StringConst */
yyDecrement (1) yySetNT (yyNTformat_identifier) {
/* line 3367 "fortran.lalr" */
 yyA [0].Tree = mCONST_EXP (mSTRING_CONSTANT (yyA [0].Scan.StringConst)); 
       yyS.Tree = mVALUE_PARAM (yyA [0].Tree); 
} break;
case 1609: /* format_identifier : PIdent */
yyDecrement (1) yySetNT (yyNTformat_identifier) {
/* line 3372 "fortran.lalr" */
 yyA [0].Tree = mUSED_VAR (mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident)); 
       yyS.Tree = mVALUE_PARAM (mVAR_EXP(yyA [0].Tree)); 
} break;
case 1610: /* io_list : io_item */
yyDecrement (1) yySetNT (yyNTio_list) {
/* line 3377 "fortran.lalr" */
 yyS.Tree = mBTP_LIST (yyA [0].Tree, mBTP_EMPTY ()); 
} break;
case 1611: /* io_list : io_item ',' io_list */
yyDecrement (3) yySetNT (yyNTio_list) {
/* line 3381 "fortran.lalr" */
 yyS.Tree = mBTP_LIST (yyA [0].Tree, yyA [2].Tree);  
} break;
case 1612: /* io_item : expression */
yyDecrement (1) yySetNT (yyNTio_item) {
/* line 3385 "fortran.lalr" */
 yyS.Tree = mVALUE_PARAM (yyA [0].Tree); 
} break;
case 1613: /* format_statement : FORMAT format_list */
yyDecrement (2) yySetNT (yyNTformat_statement) {
/* line 3397 "fortran.lalr" */
 yyS.Tree = mFORMAT_DECL (DefaultId(), NLine (yyA [0]), 0, yyA [1].Tree);    
       yyS.Tree = mDECL_LIST (yyS.Tree, NoTree);
     
} break;
case 1614: /* format_list : FORMAT_ARG format_list */
yyDecrement (2) yySetNT (yyNTformat_list) {
/* line 3403 "fortran.lalr" */
 yyS.Tree = mBTP_LIST (mFORMAT_PARAM (yyA [0].Scan.StringConst),
                              yyA [1].Tree); 
     
} break;
case 1615: /* format_list : FORMAT_ARG */
yyDecrement (1) yySetNT (yyNTformat_list) {
/* line 3409 "fortran.lalr" */
 yyS.Tree = mBTP_LIST (mFORMAT_PARAM (yyA [0].Scan.StringConst),
                              mBTP_EMPTY());
     
} break;
case 1616: /* entry_statement : ENTRY PIdent dummy_arguments \
function_result */
yyDecrement (4) yySetNT (yyNTentry_statement) {
/* line 3422 "fortran.lalr" */
 yyS.Tree = mFUNC_DECL (yyA [1].Scan.Ident, yyA [1].Label, 
                             yyA [2].Tree,          /* formals */
                             mBODY_NODE( mDECL_EMPTY(),
                                         mDECL_EMPTY(),
                                         mACF_EMPTY(),
                                         mUNIT_EMPTY() ),
                             mDUMMY_TYPE(),    /* result_type   */
                             yyA [3].Line > 0,      /* has_res_id    */
                             yyA [3].Label);        /* result_id     */

       yyS.Tree = mACF_ENTRY (yyS.Tree);
       yyS.Line = NLine(yyA [0]);   
     
} break;
case 1617: /* struct_loop_statement : loop_statement */
yyDecrement (1) yySetNT (yyNTstruct_loop_statement) {
/* line 3463 "fortran.lalr" */
 yyS.Tree  = yyA [0].Tree;
        yyS.Line  = yyA [0].Line;
      
} break;
case 1618: /* struct_loop_statement : PIdent ':' loop_statement */
yyDecrement (3) yySetNT (yyNTstruct_loop_statement) {
/* line 3470 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
        yyS.Line = yyA [2].Line;
        yyS.Tree->ACF_NODE.Label = - (yyA [0].Scan.Ident);

        /* negative label stands for tIdent */
      
} break;
case 1619: /* loop_statement : DO ForLabel opt_comma WHILE '(' \
expression ')' CR1 execution_block ENDDO opt_ident */
yyDecrement (11) yySetNT (yyNTloop_statement) {
/* line 3481 "fortran.lalr" */
 yyS.Tree = mACF_WHILE (yyA [5].Tree, yyA [8].Tree); 
        yyS.Line = NLine(yyA [0]);    
} break;
case 1620: /* loop_statement : DO ForLabel opt_comma Laufvariable '=' \
DoRange CR1 execution_block ENDDO opt_ident */
yyDecrement (10) yySetNT (yyNTloop_statement) {
/* line 3488 "fortran.lalr" */
 yyS.Tree = mACF_DO (yyA [3].Tree, yyA [5].Tree, yyA [7].Tree, 
                  mSERIAL_INFO(), mNO_HOME_INFO ()); 

        yyS.Line = NLine(yyA [3]);    
      
} break;
case 1621: /* loop_statement : DO ForLabel CR1 execution_block ENDDO \
opt_ident */
yyDecrement (6) yySetNT (yyNTloop_statement) {
/* line 3581 "fortran.lalr" */
 yyS.Tree = mACF_LOOP (yyA [3].Tree); 
        yyS.Line = NLine(yyA [0]);    
} break;
case 1622: /* loop_statement : FORALL '(' forall_cont */
yyDecrement (3) yySetNT (yyNTloop_statement) {
/* line 3615 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
        yyS.Line = NLine(yyA [0]);
      
} break;
case 1623: /* independent_clause : INDEPENDENT ind_clauses CR1 */
yyDecrement (3) yySetNT (yyNTindependent_clause) {
/* line 3505 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
        yyS.Line = NLine (yyA [0]);
      
} break;
case 1624: /* ind_clauses : */
yySetNT (yyNTind_clauses) {
/* line 3512 "fortran.lalr" */
 yyS.Tree = mPARALLEL_INFO (NoTree, NoTree, NoTree, NoTree); 
} break;
case 1625: /* ind_clauses : opt_comma ON home_expr ind_clauses */
yyDecrement (4) yySetNT (yyNTind_clauses) {
/* line 3517 "fortran.lalr" */
 yyS.Tree = SetParInfoHome (yyA [3].Tree, yyA [2].Tree); 
} break;
case 1626: /* ind_clauses : opt_comma resident_clause ind_clauses */
yyDecrement (3) yySetNT (yyNTind_clauses) {
/* line 3522 "fortran.lalr" */
 yyS.Tree = SetParInfoResident (yyA [2].Tree, yyA [1].Tree); 
} break;
case 1627: /* ind_clauses : opt_comma new_clause ind_clauses */
yyDecrement (3) yySetNT (yyNTind_clauses) {
/* line 3527 "fortran.lalr" */
 yyS.Tree = SetParInfoNew (yyA [2].Tree, yyA [1].Tree); 
} break;
case 1628: /* ind_clauses : opt_comma reduction_clause ind_clauses */
yyDecrement (3) yySetNT (yyNTind_clauses) {
/* line 3532 "fortran.lalr" */
 yyS.Tree = SetParInfoReduction (yyA [2].Tree, yyA [1].Tree); 
} break;
case 1629:
case 960: /* new_clause : NEW '(' new_var_list ')' */
yyDecrement (4) yySetNT (yyNTnew_clause) {
/* line 3542 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1630: /* new_var_list : variable */
yyDecrement (1) yySetNT (yyNTnew_var_list) {
/* line 3546 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, mBTV_EMPTY ()); 
} break;
case 1631: /* new_var_list : variable ',' new_var_list */
yyDecrement (3) yySetNT (yyNTnew_var_list) {
/* line 3550 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1632:
case 961: /* reduction_clause : REDUCTION '(' reduction_var_list ')' */
yyDecrement (4) yySetNT (yyNTreduction_clause) {
/* line 3560 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1633: /* reduction_var_list : reduction_var */
yyDecrement (1) yySetNT (yyNTreduction_var_list) {
/* line 3564 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, mBTV_EMPTY ()); 
} break;
case 1634: /* reduction_var_list : reduction_var ',' \
reduction_var_list */
yyDecrement (3) yySetNT (yyNTreduction_var_list) {
/* line 3568 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1635: /* reduction_var : PIdent */
yyDecrement (1) yySetNT (yyNTreduction_var) {
/* line 3572 "fortran.lalr" */
 yyS.Tree = mUSED_VAR (mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident)); 
} break;
case 1636: /* reduction_var : structure_component */
yyDecrement (1) yySetNT (yyNTreduction_var) {
/* line 3576 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1637: /* ForLabel : */
yySetNT (yyNTForLabel) {
} break;
case 1638:
case 962: /* ForLabel : IntConst */
yyDecrement (1) yySetNT (yyNTForLabel) {
/* line 3588 "fortran.lalr" */
 LabelDo (yyA [0].Scan.IntConst); 
} break;
case 1639: /* Laufvariable : PIdent */
yyDecrement (1) yySetNT (yyNTLaufvariable) {
/* line 3592 "fortran.lalr" */
 yyS.Tree = mLOOP_VAR (mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident)); 
} break;
case 1640: /* DoRange : expression ',' expression */
yyDecrement (3) yySetNT (yyNTDoRange) {
/* line 3596 "fortran.lalr" */
 yyS.Tree = mSLICE_EXP (yyA [0].Tree, yyA [2].Tree, mDUMMY_EXP()); 
} break;
case 1641: /* DoRange : expression ',' expression ',' expression */
yyDecrement (5) yySetNT (yyNTDoRange) {
/* line 3600 "fortran.lalr" */
 yyS.Tree = mSLICE_EXP (yyA [0].Tree, yyA [2].Tree, yyA [4].Tree); 
} break;
case 1642: /* forall_cont : Laufvariable '=' Slice ',' forall_cont */
yyDecrement (5) yySetNT (yyNTforall_cont) {
/* line 3624 "fortran.lalr" */
 yyS.Tree = mACF_FORALL (yyA [0].Tree, yyA [2].Tree,  
                               mACF_LIST (yyA [4].Tree, mACF_EMPTY()), 
                               NoTree, mNO_HOME_INFO ());

        yyS.Tree->ACF_NODE.Line = NLine(yyA [1]);
      
} break;
case 1643: /* forall_cont : Laufvariable '=' Slice forall_end */
yyDecrement (4) yySetNT (yyNTforall_cont) {
/* line 3633 "fortran.lalr" */
 yyS.Tree = mACF_FORALL (yyA [0].Tree, yyA [2].Tree, yyA [3].Tree, 
                               NoTree, mNO_HOME_INFO()); 
        yyS.Tree->ACF_NODE.Line = NLine(yyA [1]);
      
} break;
case 1644: /* forall_cont : expression forall_end */
yyDecrement (2) yySetNT (yyNTforall_cont) {
/* line 3640 "fortran.lalr" */
 yyS.Tree = mACF_IF (yyA [0].Tree, yyA [1].Tree, mACF_EMPTY ());
        yyS.Tree->ACF_NODE.Line = yyA [1].Line; /* from ')' */ 
      
} break;
case 1645: /* forall_end : ')' assignment_statement */
yyDecrement (2) yySetNT (yyNTforall_end) {
/* line 3647 "fortran.lalr" */
 yyA [1].Tree = mACF_BASIC (yyA [1].Tree);
        yyA [1].Tree->ACF_NODE.Line = NLine(yyA [0]);
        yyS.Tree = mACF_LIST ( yyA [1].Tree, mACF_EMPTY() );  
        yyS.Line = NLine(yyA [0]);
      
} break;
case 1646:
case 963: /* forall_end : ')' CR1 execution_block ENDFORALL */
yyDecrement (4) yySetNT (yyNTforall_end) {
/* line 3655 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
        yyS.Line = NLine(yyA [0]);        
      
} break;
case 1647: /* if_statement : IF '(' expression ')' used_label ',' \
used_label ',' used_label */
yyDecrement (9) yySetNT (yyNTif_statement) {
/* line 3668 "fortran.lalr" */
 yyS.Tree = mACF_BASIC( mCOMP_IF_STMT (yyA [2].Tree, 
                           yyA [4].Label, yyA [6].Label, yyA [8].Label));
        yyS.Line = NLine(yyA [0]);  
} break;
case 1648: /* if_statement : IF '(' expression ')' action_stmt */
yyDecrement (5) yySetNT (yyNTif_statement) {
/* line 3674 "fortran.lalr" */
 /* at first set label and line correctly */
        SetACFNode (yyA [4].Tree, 0, yyA [4].Line);
        yyS.Tree = mACF_IF (yyA [2].Tree, 
                           mACF_LIST (yyA [4].Tree, mACF_EMPTY()),
                           mACF_EMPTY()); 
        yyS.Line = NLine(yyA [0]);  
} break;
case 1649: /* if_construct : IF '(' expression ')' THEN opt_ident CR1 \
execution_block else_part ENDIF opt_ident */
yyDecrement (11) yySetNT (yyNTif_construct) {
/* line 3699 "fortran.lalr" */
 yyS.Tree = mACF_IF (yyA [2].Tree, yyA [7].Tree, yyA [8].Tree); 
        yyS.Line = NLine(yyA [0]);  
} break;
case 1650: /* else_part : */
yySetNT (yyNTelse_part) {
/* line 3703 "fortran.lalr" */
 yyS.Tree = mACF_EMPTY (); 
} break;
case 1651: /* else_part : ELSEIF '(' expression ')' THEN opt_ident CR1 \
execution_block else_part */
yyDecrement (9) yySetNT (yyNTelse_part) {
/* line 3708 "fortran.lalr" */
 yyA [7].Tree = mACF_IF (yyA [2].Tree,yyA [7].Tree,yyA [8].Tree);
        yyA [7].Tree->ACF_NODE.Line = NLine(yyA [0]);
        yyS.Tree = mACF_LIST (yyA [7].Tree, mACF_EMPTY());
      
} break;
case 1652: /* else_part : ELSE opt_ident CR1 execution_block */
yyDecrement (4) yySetNT (yyNTelse_part) {
/* line 3715 "fortran.lalr" */
 yyS.Tree = yyA [3].Tree; 
} break;
case 1653: /* where_statement : WHERE '(' expression ')' action_stmt */
yyDecrement (5) yySetNT (yyNTwhere_statement) {
/* line 3720 "fortran.lalr" */
 /* at first set label and line correctly */
        SetACFNode (yyA [4].Tree, 0, yyA [4].Line);
        yyS.Tree = mACF_WHERE (yyA [2].Tree,
                           mACF_LIST (yyA [4].Tree, mACF_EMPTY()),
                           mACF_EMPTY()); 
        yyS.Line = NLine(yyA [0]);
      
} break;
case 1654:
case 964: /* where_construct : WHERE '(' expression ')' CR1 \
execution_part elsewhere_part ENDWHERE */
yyDecrement (8) yySetNT (yyNTwhere_construct) {
/* line 3734 "fortran.lalr" */
 yyS.Tree = mACF_WHERE (yyA [2].Tree, yyA [5].Tree, yyA [6].Tree); 
        yyS.Line = NLine(yyA [0]); 
      
} break;
case 1655: /* elsewhere_part : */
yySetNT (yyNTelsewhere_part) {
/* line 3739 "fortran.lalr" */
 yyS.Tree = mACF_EMPTY (); 
} break;
case 1656: /* elsewhere_part : ELSEWHERE '(' expression ')' CR1 \
execution_part elsewhere_part */
yyDecrement (7) yySetNT (yyNTelsewhere_part) {
/* line 3745 "fortran.lalr" */
 yyA [6].Tree = mACF_WHERE (yyA [2].Tree, yyA [5].Tree, yyA [6].Tree); 
        yyA [6].Tree->ACF_NODE.Line = NLine(yyA [0]);
        yyS.Tree = mACF_LIST (yyA [6].Tree, mACF_EMPTY());
      
} break;
case 1657: /* elsewhere_part : ELSEWHERE CR1 execution_part */
yyDecrement (3) yySetNT (yyNTelsewhere_part) {
/* line 3752 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1658: /* case_construct : SELECTCASE '(' expression ')' CR1 \
case_list ENDSELECT opt_ident */
yyDecrement (8) yySetNT (yyNTcase_construct) {
/* line 3768 "fortran.lalr" */
 yyS.Tree = mACF_CASE (yyA [2].Tree, yyA [5].Tree);
      yyS.Line = NLine (yyA [0]); 
    
} break;
case 1659: /* case_list : case_item */
yyDecrement (1) yySetNT (yyNTcase_list) {
/* line 3775 "fortran.lalr" */
 yyS.Tree = mSELECTED_ACF_LIST (yyA [0].Tree, mSELECTED_ACF_EMPTY ()); 
} break;
case 1660: /* case_list : case_item case_list */
yyDecrement (2) yySetNT (yyNTcase_list) {
/* line 3780 "fortran.lalr" */
 yyS.Tree = mSELECTED_ACF_LIST (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1661: /* case_item : CASE case_selector opt_ident CR1 \
execution_block */
yyDecrement (5) yySetNT (yyNTcase_item) {
/* line 3785 "fortran.lalr" */
 yyS.Tree = mSELECTED_ACF_NODE (yyA [1].Tree, yyA [4].Tree); 
} break;
case 1662: /* case_item : CASE DEFAULT opt_ident CR1 execution_block */
yyDecrement (5) yySetNT (yyNTcase_item) {
/* line 3790 "fortran.lalr" */
 yyS.Tree = mSELECTED_ACF_NODE (mBTE_EMPTY (), yyA [4].Tree); 
} break;
case 1663:
case 965: /* case_selector : '(' case_value_range_list ')' */
yyDecrement (3) yySetNT (yyNTcase_selector) {
/* line 3794 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1664: /* case_value_range_list : case_value_range */
yyDecrement (1) yySetNT (yyNTcase_value_range_list) {
/* line 3798 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, mBTE_EMPTY()); 
} break;
case 1665: /* case_value_range_list : case_value_range ',' \
case_value_range_list */
yyDecrement (3) yySetNT (yyNTcase_value_range_list) {
/* line 3802 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1666: /* case_value_range : expression */
yyDecrement (1) yySetNT (yyNTcase_value_range) {
/* line 3806 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1667: /* case_value_range : expression ':' */
yyDecrement (2) yySetNT (yyNTcase_value_range) {
/* line 3810 "fortran.lalr" */
 yyS.Tree = mSLICE_EXP (yyA [0].Tree, mDUMMY_EXP (), mDUMMY_EXP ()); 
} break;
case 1668: /* case_value_range : ':' expression */
yyDecrement (2) yySetNT (yyNTcase_value_range) {
/* line 3814 "fortran.lalr" */
 yyS.Tree = mSLICE_EXP (mDUMMY_EXP (), yyA [1].Tree, mDUMMY_EXP ()); 
} break;
case 1669: /* case_value_range : expression ':' expression */
yyDecrement (3) yySetNT (yyNTcase_value_range) {
/* line 3818 "fortran.lalr" */
 yyS.Tree = mSLICE_EXP (yyA [0].Tree, yyA [2].Tree, mDUMMY_EXP ()); 
} break;
case 1670: /* adp_statement : ATOMIC CR1 atomic_construct */
yyDecrement (3) yySetNT (yyNTadp_statement) {
/* line 3829 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree; 
} break;
case 1671: /* atomic_construct : opt_label assignment_statement */
yyDecrement (2) yySetNT (yyNTatomic_construct) {
/* line 3836 "fortran.lalr" */
  /* not the same : SetACFNode (yyA [1].Tree, yyA [0].Label, yyA [1].Line); */

        yyA [1].Tree->Kind = kATOMIC_STMT;

        yyA [1].Tree = mACF_BASIC (yyA [1].Tree);

        SetACFNodeLine (yyA [1].Tree, yyA [1].Line);
        SetACFNodeLabel (yyA [1].Tree, yyA [0].Label);

        yyS.Tree = yyA [1].Tree;
     
} break;
case 1672: /* hpf_statement : REALIGN realignee \
realign_attribute_stuff */
yyDecrement (3) yySetNT (yyNThpf_statement) {
/* line 3860 "fortran.lalr" */
 yyS.Tree = yyA [2].Tree;
      yyS.Tree->REALIGN_STMT.ALIGNEE = mBTV_LIST (yyA [1].Tree, mBTV_EMPTY());
      yyS.Tree = mACF_BASIC (yyA [2].Tree);
      yyS.Line = NLine(yyA [0]);                  
    
} break;
case 1673: /* hpf_statement : REALIGN realign_attribute_stuff '::' \
realignee_list */
yyDecrement (4) yySetNT (yyNThpf_statement) {
/* line 3868 "fortran.lalr" */
 yyS.Tree =  yyA [1].Tree;
      yyS.Tree->REALIGN_STMT.ALIGNEE = yyA [3].Tree; 
      yyS.Tree = mACF_BASIC (yyS.Tree);
      yyS.Line = NLine(yyA [0]);                  
    
} break;
case 1674: /* hpf_statement : REDISTRIBUTE redistributee \
dist_format_clause opt_onto */
yyDecrement (4) yySetNT (yyNThpf_statement) {
/* line 3905 "fortran.lalr" */
 yyA [1].Tree = mBTV_LIST (yyA [1].Tree, mBTV_EMPTY ());
      yyA [1].Tree = mREDISTRIBUTE_STMT (yyA [1].Tree, yyA [2].Tree, yyA [3].Tree);
      yyS.Tree = mACF_BASIC(yyA [1].Tree);
      yyS.Line = NLine (yyA [0]);                         
    
} break;
case 1675: /* hpf_statement : REDISTRIBUTE redist_attribute_stuff '::' \
redistributee_list */
yyDecrement (4) yySetNT (yyNThpf_statement) {
/* line 3913 "fortran.lalr" */
  yyS.Tree =  yyA [1].Tree;
       yyS.Tree->REDISTRIBUTE_STMT.DISTRIBUTEE = yyA [3].Tree; 
       yyS.Tree = mACF_BASIC (yyS.Tree);
    
} break;
case 1676: /* hpf_statement : simple_on_directive CR1 \
executable_construct */
yyDecrement (3) yySetNT (yyNThpf_statement) {
/* line 3948 "fortran.lalr" */
 yyA [2].Tree = mACF_LIST (yyA [2].Tree, mACF_EMPTY()); 
         SetBody (yyA [0].Tree, yyA [2].Tree);
         yyS.Tree = yyA [0].Tree;
         yyS.Line = yyA [0].Line;
       
} break;
case 1677: /* hpf_statement : simple_on_directive HPF_BEGIN CR1 \
execution_block HPF_END opt_hpf_on */
yyDecrement (6) yySetNT (yyNThpf_statement) {
/* line 3958 "fortran.lalr" */
 SetBody (yyA [0].Tree, yyA [3].Tree);
         yyS.Tree = yyA [0].Tree; 
         yyS.Line = yyA [0].Line;
       
} break;
case 1678: /* hpf_statement : simple_resident_directive CR1 \
executable_construct */
yyDecrement (3) yySetNT (yyNThpf_statement) {
/* line 4020 "fortran.lalr" */
 yyA [2].Tree = mACF_LIST (yyA [2].Tree, mACF_EMPTY()); 
         yyA [0].Tree->ACF_RESIDENT.RESIDENT_BODY = yyA [2].Tree; 
         yyS.Tree = yyA [0].Tree;
         yyS.Line = yyA [0].Line;
       
} break;
case 1679: /* hpf_statement : simple_resident_directive HPF_BEGIN CR1 \
execution_block HPF_END opt_hpf_resident */
yyDecrement (6) yySetNT (yyNThpf_statement) {
/* line 4030 "fortran.lalr" */
 yyA [0].Tree->ACF_RESIDENT.RESIDENT_BODY = yyA [3].Tree; 
         yyS.Tree = yyA [0].Tree; 
         yyS.Line = yyA [0].Line;
       
} break;
case 1680: /* hpf_statement : simple_new_directive CR1 \
executable_construct */
yyDecrement (3) yySetNT (yyNThpf_statement) {
/* line 4086 "fortran.lalr" */
 yyA [2].Tree = mACF_LIST (yyA [2].Tree, mACF_EMPTY()); 
         yyA [0].Tree->ACF_NEW.NEW_BODY = yyA [2].Tree; 
         yyS.Tree = yyA [0].Tree;
         yyS.Line = yyA [0].Line;
       
} break;
case 1681: /* hpf_statement : simple_new_directive HPF_BEGIN CR1 \
execution_block HPF_END opt_hpf_new */
yyDecrement (6) yySetNT (yyNThpf_statement) {
/* line 4096 "fortran.lalr" */
 yyA [0].Tree->ACF_NEW.NEW_BODY = yyA [3].Tree; 
         yyS.Tree = yyA [0].Tree; 
         yyS.Line = yyA [0].Line;
       
} break;
case 1682: /* hpf_statement : simple_reduction_directive CR1 \
executable_construct */
yyDecrement (3) yySetNT (yyNThpf_statement) {
/* line 4118 "fortran.lalr" */
 yyA [2].Tree = mACF_LIST (yyA [2].Tree, mACF_EMPTY()); 
         yyA [0].Tree->ACF_REDUCTION.REDUCTION_BODY = yyA [2].Tree; 
         yyS.Tree = BuildSingleReductions (yyA [0].Tree);
         yyS.Line = yyA [0].Line;
       
} break;
case 1683: /* hpf_statement : simple_reduction_directive HPF_BEGIN CR1 \
execution_block HPF_END opt_hpf_reduction */
yyDecrement (6) yySetNT (yyNThpf_statement) {
/* line 4128 "fortran.lalr" */
 yyA [0].Tree->ACF_REDUCTION.REDUCTION_BODY = yyA [3].Tree; 
         yyS.Tree = BuildSingleReductions (yyA [0].Tree);
         yyS.Line = yyA [0].Line;
       
} break;
case 1684:
case 966: /* hpf_statement : task_flag TASK_REGION CR1 \
execution_block HPF_END TASK_REGION */
yyDecrement (6) yySetNT (yyNThpf_statement) {
/* line 4153 "fortran.lalr" */
 yyS.Tree = mACF_TASK_REGION (yyA [0].Line, yyA [3].Tree);
         yyS.Line = NLine (yyA [1]);
       
} break;
case 1685: /* realign_attribute_stuff : WITH align_spec */
yyDecrement (2) yySetNT (yyNTrealign_attribute_stuff) {
/* line 3876 "fortran.lalr" */
 yyS.Tree = mREALIGN_STMT (NoTree, mBTE_EMPTY(), yyA [1].Tree); 
} break;
case 1686: /* realign_attribute_stuff : '(' align_source_list ')' WITH \
align_spec */
yyDecrement (5) yySetNT (yyNTrealign_attribute_stuff) {
/* line 3880 "fortran.lalr" */
 yyS.Tree = mREALIGN_STMT (NoTree, yyA [1].Tree, yyA [4].Tree); 
} break;
case 1687: /* realignee_list : realignee */
yyDecrement (1) yySetNT (yyNTrealignee_list) {
/* line 3884 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, mBTV_EMPTY()); 
} break;
case 1688: /* realignee_list : realignee ',' realignee_list */
yyDecrement (3) yySetNT (yyNTrealignee_list) {
/* line 3888 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1689: /* realignee : HPFIdent */
yyDecrement (1) yySetNT (yyNTrealignee) {
/* line 3892 "fortran.lalr" */
 yyS.Tree = mUSED_VAR (mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident)); 
} break;
case 1690: /* redist_attribute_stuff : dist_format_clause opt_onto */
yyDecrement (2) yySetNT (yyNTredist_attribute_stuff) {
/* line 3920 "fortran.lalr" */
 yyS.Tree = mREDISTRIBUTE_STMT (NoTree, yyA [0].Tree, yyA [1].Tree); 
} break;
case 1691: /* redist_attribute_stuff : dist_onto_clause */
yyDecrement (1) yySetNT (yyNTredist_attribute_stuff) {
/* line 3924 "fortran.lalr" */
 yyS.Tree = mDEFAULT_DISTRIBUTION (0);
      yyS.Tree = mREDISTRIBUTE_STMT (NoTree, yyS.Tree, yyA [0].Tree);
    
} break;
case 1692: /* redistributee_list : redistributee */
yyDecrement (1) yySetNT (yyNTredistributee_list) {
/* line 3930 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, mBTV_EMPTY()); 
} break;
case 1693: /* redistributee_list : redistributee ',' \
redistributee_list */
yyDecrement (3) yySetNT (yyNTredistributee_list) {
/* line 3934 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1694: /* redistributee : HPFIdent */
yyDecrement (1) yySetNT (yyNTredistributee) {
/* line 3938 "fortran.lalr" */
 yyS.Tree = mUSED_VAR (mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident)); 
} break;
case 1695: /* simple_on_directive : ON home_expr */
yyDecrement (2) yySetNT (yyNTsimple_on_directive) {
/* line 3965 "fortran.lalr" */
 yyS.Tree = mACF_HOME (yyA [1].Tree, rtrue, NoTree);
         yyS.Line = NLine (yyA [0]);
       
} break;
case 1696: /* simple_on_directive : ON home_expr ',' resident_clause */
yyDecrement (4) yySetNT (yyNTsimple_on_directive) {
/* line 3971 "fortran.lalr" */
 yyS.Line = NLine (yyA [0]);
         yyS.Tree = mACF_HOME (yyA [1].Tree, rtrue, NoTree);
         ApplyResidentClause (yyS.Tree, yyA [3].Tree, yyS.Line);
       
} break;
case 1697: /* simple_on_directive : ON home_expr ',' new_clause */
yyDecrement (4) yySetNT (yyNTsimple_on_directive) {
/* line 3978 "fortran.lalr" */
 yyS.Line = NLine (yyA [0]);
         yyS.Tree = mACF_HOME (yyA [1].Tree, rtrue, NoTree);
         ApplyNewClause (yyS.Tree, yyA [3].Tree, yyS.Line);
       
} break;
case 1698: /* simple_on_directive : ON home_expr ',' resident_clause \
',' new_clause */
yyDecrement (6) yySetNT (yyNTsimple_on_directive) {
/* line 3985 "fortran.lalr" */
 yyS.Line = NLine (yyA [0]);
         yyS.Tree = mACF_HOME (yyA [1].Tree, rtrue, NoTree);
         ApplyResidentClause (yyS.Tree, yyA [3].Tree, yyS.Line);
         ApplyNewClause      (yyS.Tree, yyA [5].Tree, yyS.Line);
       
} break;
case 1699:
case 967: /* home_expr : HOME '(' variable ')' */
yyDecrement (4) yySetNT (yyNThome_expr) {
/* line 3993 "fortran.lalr" */
 yyS.Tree = mON_VAR_CLAUSE (yyA [2].Tree); 
} break;
case 1700:
case 968: /* home_expr : '(' PIdent ')' */
yyDecrement (3) yySetNT (yyNThome_expr) {
/* line 3998 "fortran.lalr" */
 yyA [1].Tree = mPROCESSOR_ARRAY (mTOP_OBJ (yyA [1].Scan.Ident));
         yyS.Tree = mON_PROC_CLAUSE (yyA [1].Tree); 
       
} break;
case 1701:
case 969: /* home_expr : '(' PIdent '(' section_subscript_list ')' \
')' */
yyDecrement (6) yySetNT (yyNThome_expr) {
/* line 4004 "fortran.lalr" */
 yyA [1].Tree = mTOP_OBJ (yyA [1].Scan.Ident);
         yyA [1].Tree = mPROCESSOR_SUBSET (CopyTree (yyA [1].Tree), yyA [1].Tree, yyA [3].Tree);
         yyS.Tree = mON_PROC_CLAUSE (yyA [1].Tree); 
       
} break;
case 1702: /* opt_hpf_on : */
yySetNT (yyNTopt_hpf_on) {
} break;
case 1703:
case 970: /* opt_hpf_on : ON */
yyDecrement (1) yySetNT (yyNTopt_hpf_on) {
} break;
case 1704: /* simple_resident_directive : resident_clause */
yyDecrement (1) yySetNT (yyNTsimple_resident_directive) {
/* line 4037 "fortran.lalr" */
 yyS.Tree = mACF_RESIDENT (yyA [0].Tree, NoTree); 
        yyS.Line = yyA [0].Line;
      
} break;
case 1705: /* opt_hpf_resident : */
yySetNT (yyNTopt_hpf_resident) {
} break;
case 1706:
case 971: /* opt_hpf_resident : RESIDENT */
yyDecrement (1) yySetNT (yyNTopt_hpf_resident) {
} break;
case 1707: /* resident_clause : RESIDENT opt_local_var_list */
yyDecrement (2) yySetNT (yyNTresident_clause) {
/* line 4052 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree;
         yyS.Line = NLine(yyA [0]);
       
} break;
case 1708: /* opt_local_var_list : */
yySetNT (yyNTopt_local_var_list) {
/* line 4060 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (mDUMMY_VAR(), mBTV_EMPTY ()); 
} break;
case 1709:
case 972: /* opt_local_var_list : '(' local_var_list ')' */
yyDecrement (3) yySetNT (yyNTopt_local_var_list) {
/* line 4065 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1710: /* local_var_list : variable */
yyDecrement (1) yySetNT (yyNTlocal_var_list) {
/* line 4070 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, mBTV_EMPTY ()); 
} break;
case 1711: /* local_var_list : variable ',' local_var_list */
yyDecrement (3) yySetNT (yyNTlocal_var_list) {
/* line 4075 "fortran.lalr" */
 yyS.Tree = mBTV_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1712: /* simple_new_directive : new_clause */
yyDecrement (1) yySetNT (yyNTsimple_new_directive) {
/* line 4103 "fortran.lalr" */
 yyS.Tree = mACF_NEW (yyA [0].Tree, NoTree); 
        yyS.Line = yyA [0].Line;
      
} break;
case 1713: /* opt_hpf_new : */
yySetNT (yyNTopt_hpf_new) {
} break;
case 1714:
case 973: /* opt_hpf_new : NEW */
yyDecrement (1) yySetNT (yyNTopt_hpf_new) {
} break;
case 1715: /* simple_reduction_directive : reduction_clause */
yyDecrement (1) yySetNT (yyNTsimple_reduction_directive) {
/* line 4135 "fortran.lalr" */
 yyS.Tree = mACF_REDUCTION (kDEFAULT_REDUCTION, yyA [0].Tree, 
                                  mPROC_OBJ (DefaultId()), NoTree); 
        yyS.Line = yyA [0].Line;
      
} break;
case 1716: /* opt_hpf_reduction : */
yySetNT (yyNTopt_hpf_reduction) {
} break;
case 1717:
case 974: /* opt_hpf_reduction : REDUCTION */
yyDecrement (1) yySetNT (yyNTopt_hpf_reduction) {
} break;
case 1718: /* task_flag : INDEPENDENT */
yyDecrement (1) yySetNT (yyNTtask_flag) {
/* line 4159 "fortran.lalr" */
 yyS.Line = 1; 
} break;
case 1719: /* task_flag : */
yySetNT (yyNTtask_flag) {
/* line 4163 "fortran.lalr" */
 yyS.Line = 0; 
} break;
case 1720: /* variable : PIdent */
yyDecrement (1) yySetNT (yyNTvariable) {
/* line 4173 "fortran.lalr" */
 yyS.Tree = mUSED_VAR (mVAR_OBJ (yyA [0].Label, yyA [0].Scan.Ident)); 
} break;
case 1721: /* variable : index_var */
yyDecrement (1) yySetNT (yyNTvariable) {
/* line 4177 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree ; 
} break;
case 1722: /* variable : structure_component */
yyDecrement (1) yySetNT (yyNTvariable) {
/* line 4181 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1723: /* structure_component : variable '%' PIdent */
yyDecrement (3) yySetNT (yyNTstructure_component) {
/* line 4185 "fortran.lalr" */
 yyS.Tree = mSELECTED_VAR (yyA [0].Tree, mREC_COMP (yyA [2].Scan.Ident)); 
} break;
case 1724:
case 975: /* index_var : variable '(' ')' */
yyDecrement (3) yySetNT (yyNTindex_var) {
/* line 4189 "fortran.lalr" */
 yyS.Tree = mINDEXED_VAR ( yyA [0].Tree, mBTE_EMPTY() ); 
} break;
case 1725:
case 976: /* index_var : variable '(' section_subscript_list ')' */
yyDecrement (4) yySetNT (yyNTindex_var) {
/* line 4193 "fortran.lalr" */
 yyS.Tree = mINDEXED_VAR ( yyA [0].Tree, yyA [2].Tree ); 
} break;
case 1726: /* section_subscript_list : Index_Elem */
yyDecrement (1) yySetNT (yyNTsection_subscript_list) {
/* line 4197 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, mBTE_EMPTY ()); 
} break;
case 1727: /* section_subscript_list : Index_Elem ',' \
section_subscript_list */
yyDecrement (3) yySetNT (yyNTsection_subscript_list) {
/* line 4201 "fortran.lalr" */
 yyS.Tree = mBTE_LIST (yyA [0].Tree, yyA [2].Tree); 
} break;
case 1728: /* Index_Elem : expression */
yyDecrement (1) yySetNT (yyNTIndex_Elem) {
/* line 4205 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1729: /* Index_Elem : PIdent '=' expression */
yyDecrement (3) yySetNT (yyNTIndex_Elem) {
/* line 4211 "fortran.lalr" */
 yyS.Tree = mNAMED_EXP (yyA [0].Scan.Ident, yyA [2].Tree); 
} break;
case 1730: /* Index_Elem : Slice */
yyDecrement (1) yySetNT (yyNTIndex_Elem) {
/* line 4215 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1731: /* Slice : dumexpression ':' dumexpression */
yyDecrement (3) yySetNT (yyNTSlice) {
/* line 4219 "fortran.lalr" */
 yyS.Tree = mSLICE_EXP (yyA [0].Tree, yyA [2].Tree, mDUMMY_EXP ()); 
} break;
case 1732: /* Slice : dumexpression ':' dumexpression ':' \
dumexpression */
yyDecrement (5) yySetNT (yyNTSlice) {
/* line 4223 "fortran.lalr" */
 yyS.Tree = mSLICE_EXP (yyA [0].Tree, yyA [2].Tree, yyA [4].Tree); 
} break;
case 1733: /* Slice : dumexpression '::' dumexpression */
yyDecrement (3) yySetNT (yyNTSlice) {
/* line 4227 "fortran.lalr" */
 yyS.Tree = mSLICE_EXP (yyA [0].Tree, mDUMMY_EXP(), yyA [2].Tree); 
} break;
case 1734: /* dumexpression : */
yySetNT (yyNTdumexpression) {
/* line 4231 "fortran.lalr" */
 yyS.Tree = mDUMMY_EXP (); 
} break;
case 1735: /* dumexpression : expression */
yyDecrement (1) yySetNT (yyNTdumexpression) {
/* line 4235 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1736:
case 977: /* primary : '(' expression ')' */
yyDecrement (3) yySetNT (yyNTprimary) {
/* line 4245 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1737:
case 978: /* primary : '(' expression ',' impl_do_exp ')' */
yyDecrement (5) yySetNT (yyNTprimary) {
/* line 4249 "fortran.lalr" */
 yyA [3].Tree->DO_EXP.BODY = 
         mBTE_LIST (yyA [1].Tree, yyA [3].Tree->DO_EXP.BODY); 
       yyS.Tree = yyA [3].Tree; 
} break;
case 1738: /* primary : variable */
yyDecrement (1) yySetNT (yyNTprimary) {
/* line 4390 "fortran.lalr" */
 yyS.Tree = mVAR_EXP (yyA [0].Tree); 
} break;
case 1739: /* primary : Konstante */
yyDecrement (1) yySetNT (yyNTprimary) {
/* line 4393 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1740:
case 979: /* primary : '[' section_subscript_list ']' */
yyDecrement (3) yySetNT (yyNTprimary) {
/* line 4396 "fortran.lalr" */
 yyS.Tree = mARRAY_EXP (yyA [1].Tree); 
} break;
case 1741:
case 980: /* primary : PReal '(' expression ')' */
yyDecrement (4) yySetNT (yyNTprimary) {
/* line 4399 "fortran.lalr" */
 yyS.Tree = mVAR_EXP ( mINDEXED_VAR (
                        mUSED_VAR (mVAR_OBJ(yyA [0].Label, yyA [0].Scan.Ident)),
                        mBTE_LIST (yyA [2].Tree, mBTE_EMPTY ()))); 
} break;
case 1742: /* impl_do_exp : expression ',' impl_do_exp */
yyDecrement (3) yySetNT (yyNTimpl_do_exp) {
/* line 4255 "fortran.lalr" */
 yyA [2].Tree->DO_EXP.BODY = 
         mBTE_LIST (yyA [0].Tree, yyA [2].Tree->DO_EXP.BODY); 
       yyS.Tree = yyA [2].Tree; 
} break;
case 1743: /* impl_do_exp : Laufvariable '=' DoRange */
yyDecrement (3) yySetNT (yyNTimpl_do_exp) {
/* line 4261 "fortran.lalr" */
 yyS.Tree = mDO_EXP (yyA [0].Tree, yyA [2].Tree, mBTE_EMPTY()); 
} break;
case 1744: /* expression : expression defined_binary_op level5_expr */
yyDecrement (3) yySetNT (yyNTexpression) {
/* line 4269 "fortran.lalr" */
 yyS.Tree = mOP_EXP (yyA [1].Tree, yyA [0].Tree, yyA [2].Tree); 
} break;
case 1745: /* expression : level5_expr */
yyDecrement (1) yySetNT (yyNTexpression) {
/* line 4276 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1746:
case 981: /* defined_binary_op : UserOp */
yyDecrement (1) yySetNT (yyNTdefined_binary_op) {
/* line 4273 "fortran.lalr" */
 yyS.Tree = mOP_DEFINED (yyA [0].Scan.Ident); 
} break;
case 1747: /* level5_expr : equiv_operand */
yyDecrement (1) yySetNT (yyNTlevel5_expr) {
/* line 4280 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1748: /* level5_expr : level5_expr equiv_op equiv_operand */
yyDecrement (3) yySetNT (yyNTlevel5_expr) {
/* line 4284 "fortran.lalr" */
 yyS.Tree = mOP_EXP (yyA [1].Tree, yyA [0].Tree, yyA [2].Tree); 
} break;
case 1749:
case 982: /* equiv_op : EQV */
yyDecrement (1) yySetNT (yyNTequiv_op) {
/* line 4287 "fortran.lalr" */
 yyS.Tree = mOP_EQV(); 
} break;
case 1750:
case 983: /* equiv_op : NEQV */
yyDecrement (1) yySetNT (yyNTequiv_op) {
/* line 4288 "fortran.lalr" */
 yyS.Tree = mOP_NEQV(); 
} break;
case 1751: /* equiv_operand : or_operand */
yyDecrement (1) yySetNT (yyNTequiv_operand) {
/* line 4291 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1752: /* equiv_operand : equiv_operand or_op or_operand */
yyDecrement (3) yySetNT (yyNTequiv_operand) {
/* line 4295 "fortran.lalr" */
 yyS.Tree = mOP_EXP (yyA [1].Tree, yyA [0].Tree, yyA [2].Tree); 
} break;
case 1753:
case 984: /* or_op : OR */
yyDecrement (1) yySetNT (yyNTor_op) {
/* line 4298 "fortran.lalr" */
 yyS.Tree = mOP_OR(); 
} break;
case 1754:
case 985: /* or_op : XOR */
yyDecrement (1) yySetNT (yyNTor_op) {
/* line 4299 "fortran.lalr" */
 yyS.Tree = mOP_XOR(); 
} break;
case 1755: /* or_operand : and_operand */
yyDecrement (1) yySetNT (yyNTor_operand) {
/* line 4302 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1756: /* or_operand : or_operand and_op and_operand */
yyDecrement (3) yySetNT (yyNTor_operand) {
/* line 4306 "fortran.lalr" */
 yyS.Tree = mOP_EXP (yyA [1].Tree, yyA [0].Tree, yyA [2].Tree); 
} break;
case 1757:
case 986: /* and_op : AND */
yyDecrement (1) yySetNT (yyNTand_op) {
/* line 4309 "fortran.lalr" */
 yyS.Tree = mOP_AND(); 
} break;
case 1758: /* and_operand : level4_expr */
yyDecrement (1) yySetNT (yyNTand_operand) {
/* line 4312 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1759: /* and_operand : not_op level4_expr */
yyDecrement (2) yySetNT (yyNTand_operand) {
/* line 4316 "fortran.lalr" */
 yyS.Tree = mOP1_EXP (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1760:
case 987: /* not_op : NOT */
yyDecrement (1) yySetNT (yyNTnot_op) {
/* line 4319 "fortran.lalr" */
 yyS.Tree = mOP1_NOT(); 
} break;
case 1761: /* level4_expr : level3_expr */
yyDecrement (1) yySetNT (yyNTlevel4_expr) {
/* line 4322 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1762: /* level4_expr : level3_expr rel_op level3_expr */
yyDecrement (3) yySetNT (yyNTlevel4_expr) {
/* line 4326 "fortran.lalr" */
 yyS.Tree = mOP_EXP (yyA [1].Tree, yyA [0].Tree, yyA [2].Tree); 
} break;
case 1763:
case 988: /* rel_op : '==' */
yyDecrement (1) yySetNT (yyNTrel_op) {
/* line 4328 "fortran.lalr" */
 yyS.Tree = mOP_EQ(); 
} break;
case 1764:
case 989: /* rel_op : '<=' */
yyDecrement (1) yySetNT (yyNTrel_op) {
/* line 4329 "fortran.lalr" */
 yyS.Tree = mOP_LE(); 
} break;
case 1765:
case 990: /* rel_op : '>=' */
yyDecrement (1) yySetNT (yyNTrel_op) {
/* line 4330 "fortran.lalr" */
 yyS.Tree = mOP_GE(); 
} break;
case 1766:
case 991: /* rel_op : '<>' */
yyDecrement (1) yySetNT (yyNTrel_op) {
/* line 4331 "fortran.lalr" */
 yyS.Tree = mOP_NE(); 
} break;
case 1767:
case 992: /* rel_op : '<' */
yyDecrement (1) yySetNT (yyNTrel_op) {
/* line 4332 "fortran.lalr" */
 yyS.Tree = mOP_LT(); 
} break;
case 1768:
case 993: /* rel_op : '>' */
yyDecrement (1) yySetNT (yyNTrel_op) {
/* line 4333 "fortran.lalr" */
 yyS.Tree = mOP_GT(); 
} break;
case 1769: /* level3_expr : level2_expr */
yyDecrement (1) yySetNT (yyNTlevel3_expr) {
/* line 4336 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1770: /* level3_expr : level3_expr concat_op level2_expr */
yyDecrement (3) yySetNT (yyNTlevel3_expr) {
/* line 4340 "fortran.lalr" */
 yyS.Tree = mOP_EXP (yyA [1].Tree, yyA [0].Tree, yyA [2].Tree); 
} break;
case 1771:
case 994: /* concat_op : '//' */
yyDecrement (1) yySetNT (yyNTconcat_op) {
/* line 4343 "fortran.lalr" */
 yyS.Tree = mOP_CONCAT (); 
} break;
case 1772: /* level2_expr : add_operand */
yyDecrement (1) yySetNT (yyNTlevel2_expr) {
/* line 4346 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1773: /* level2_expr : level2_expr add_op signed_add_operand */
yyDecrement (3) yySetNT (yyNTlevel2_expr) {
/* line 4350 "fortran.lalr" */
 yyS.Tree = mOP_EXP (yyA [1].Tree, yyA [0].Tree, yyA [2].Tree); 
} break;
case 1774: /* level2_expr : '+' add_operand */
yyDecrement (2) yySetNT (yyNTlevel2_expr) {
/* line 4352 "fortran.lalr" */
 yyS.Tree = mOP1_EXP (mOP1_PSIGN(), yyA [1].Tree); 
} break;
case 1775: /* level2_expr : '-' add_operand */
yyDecrement (2) yySetNT (yyNTlevel2_expr) {
/* line 4354 "fortran.lalr" */
 yyS.Tree = mOP1_EXP (mOP1_SIGN(), yyA [1].Tree); 
} break;
case 1776:
case 995: /* add_op : '+' */
yyDecrement (1) yySetNT (yyNTadd_op) {
/* line 4356 "fortran.lalr" */
 yyS.Tree = mOP_PLUS();  
} break;
case 1777:
case 996: /* add_op : '-' */
yyDecrement (1) yySetNT (yyNTadd_op) {
/* line 4357 "fortran.lalr" */
 yyS.Tree = mOP_MINUS();  
} break;
case 1778: /* signed_add_operand : add_operand */
yyDecrement (1) yySetNT (yyNTsigned_add_operand) {
/* line 4360 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1779: /* signed_add_operand : '-' add_operand */
yyDecrement (2) yySetNT (yyNTsigned_add_operand) {
/* line 4363 "fortran.lalr" */
 yyS.Tree = mOP1_EXP(mOP1_SIGN(), yyA [1].Tree); 
} break;
case 1780: /* add_operand : mult_operand */
yyDecrement (1) yySetNT (yyNTadd_operand) {
/* line 4366 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1781: /* add_operand : add_operand mult_op mult_operand */
yyDecrement (3) yySetNT (yyNTadd_operand) {
/* line 4368 "fortran.lalr" */
 yyS.Tree = mOP_EXP (yyA [1].Tree, yyA [0].Tree, yyA [2].Tree); 
} break;
case 1782:
case 997: /* mult_op : '*' */
yyDecrement (1) yySetNT (yyNTmult_op) {
/* line 4370 "fortran.lalr" */
 yyS.Tree = mOP_TIMES();  
} break;
case 1783:
case 998: /* mult_op : '/' */
yyDecrement (1) yySetNT (yyNTmult_op) {
/* line 4371 "fortran.lalr" */
 yyS.Tree = mOP_DIVIDE(); 
} break;
case 1784: /* mult_operand : level1_expr */
yyDecrement (1) yySetNT (yyNTmult_operand) {
/* line 4374 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1785: /* mult_operand : level1_expr power_op mult_operand */
yyDecrement (3) yySetNT (yyNTmult_operand) {
/* line 4376 "fortran.lalr" */
 yyS.Tree = mOP_EXP (yyA [1].Tree, yyA [0].Tree, yyA [2].Tree); 
} break;
case 1786:
case 999: /* power_op : '**' */
yyDecrement (1) yySetNT (yyNTpower_op) {
/* line 4378 "fortran.lalr" */
 yyS.Tree = mOP_EXPO(); 
} break;
case 1787: /* level1_expr : defined_unary_op primary */
yyDecrement (2) yySetNT (yyNTlevel1_expr) {
/* line 4381 "fortran.lalr" */
 yyS.Tree = mOP1_EXP (yyA [0].Tree, yyA [1].Tree); 
} break;
case 1788: /* level1_expr : primary */
yyDecrement (1) yySetNT (yyNTlevel1_expr) {
/* line 4387 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1789:
case 1000: /* defined_unary_op : UserOp */
yyDecrement (1) yySetNT (yyNTdefined_unary_op) {
/* line 4384 "fortran.lalr" */
 yyS.Tree = mOP_DEFINED (yyA [0].Scan.Ident); 
} break;
case 1790:
case 1001: /* PReal : REAL */
yyDecrement (1) yySetNT (yyNTPReal) {
/* line 4404 "fortran.lalr" */
 yyS.Scan.Ident = IsIdent ("REAL");
       yyS.Label = NLine (yyA [0]); 
} break;
case 1791: /* Konstante : IntConst */
yyDecrement (1) yySetNT (yyNTKonstante) {
/* line 4415 "fortran.lalr" */
 yyS.Tree = mCONST_EXP (mINT_CONSTANT (yyA [0].Scan.IntConst)); 
} break;
case 1792: /* Konstante : RealKonstante */
yyDecrement (1) yySetNT (yyNTKonstante) {
/* line 4418 "fortran.lalr" */
 yyS.Tree = mCONST_EXP (yyA [0].Tree); 
} break;
case 1793:
case 1002: /* Konstante : '(' expression ',' expression ')' */
yyDecrement (5) yySetNT (yyNTKonstante) {
/* line 4422 "fortran.lalr" */
 yyS.Tree = mCONST_EXP (MakeComplexConstant (yyA [1].Tree, yyA [3].Tree)); 
} break;
case 1794:
case 1003: /* Konstante : StringConst */
yyDecrement (1) yySetNT (yyNTKonstante) {
/* line 4436 "fortran.lalr" */
 yyS.Tree = mCONST_EXP (mSTRING_CONSTANT (yyA [0].Scan.StringConst)); 
} break;
case 1795:
case 1004: /* Konstante : TRUE */
yyDecrement (1) yySetNT (yyNTKonstante) {
/* line 4439 "fortran.lalr" */
 yyS.Tree = mCONST_EXP (mBOOL_CONSTANT (1)); 
} break;
case 1796:
case 1005: /* Konstante : FALSE */
yyDecrement (1) yySetNT (yyNTKonstante) {
/* line 4442 "fortran.lalr" */
 yyS.Tree = mCONST_EXP (mBOOL_CONSTANT (0)); 
} break;
case 1797:
case 1006: /* RealKonstante : IntConst '.' */
yyDecrement (2) yySetNT (yyNTRealKonstante) {
/* line 4426 "fortran.lalr" */
 yyS.Tree = mREAL_CONSTANT (MakeIntToReal (yyA [0].Scan.IntConst),
                                 default_real_size); 
} break;
case 1798:
case 1007: /* RealKonstante : RealConst */
yyDecrement (1) yySetNT (yyNTRealKonstante) {
/* line 4430 "fortran.lalr" */
 yyS.Tree = mREAL_CONSTANT (yyA [0].Scan.StringConst, - yyA [0].Scan.Ident); 
} break;
case 1799:
case 1008: /* RealKonstante : DRealConst */
yyDecrement (1) yySetNT (yyNTRealKonstante) {
/* line 4433 "fortran.lalr" */
 yyS.Tree = mREAL_CONSTANT (yyA [0].Scan.StringConst, 2*default_real_size); 
} break;
case 1800: /* SignedKonstante : Konstante */
yyDecrement (1) yySetNT (yyNTSignedKonstante) {
/* line 4447 "fortran.lalr" */
 yyS.Tree = yyA [0].Tree; 
} break;
case 1801: /* SignedKonstante : '+' Konstante */
yyDecrement (2) yySetNT (yyNTSignedKonstante) {
/* line 4450 "fortran.lalr" */
 yyS.Tree = yyA [1].Tree; 
} break;
case 1802: /* SignedKonstante : '-' IntConst */
yyDecrement (2) yySetNT (yyNTSignedKonstante) {
/* line 4453 "fortran.lalr" */
 yyS.Tree = mCONST_EXP (mINT_CONSTANT (- yyA [1].Scan.IntConst)); 
} break;
case 1803: /* SignedKonstante : '-' RealKonstante */
yyDecrement (2) yySetNT (yyNTSignedKonstante) {
/* line 4456 "fortran.lalr" */
 yyS.Tree = mOP1_EXP (mOP1_SIGN(), mCONST_EXP (yyA [1].Tree)); 
} break;
default: switch (yyState) {
case 1: goto yyAbort;
case 2: goto yyRead;
case 3: goto yyReduce;
}
}

       /* SPEC State = Next (Top (), Nonterminal); nonterminal transition */
# ifdef YYNDefault
	       yyState = * yyStateStackPtr ++;
	       for (;;) {
		  register yytComb * yyNCombPtr =
				yyNBasePtr [yyState] + (int) yyNonterminal;
		  if (yyNCombPtr->Check == yyState) {
		     yyState = yyNCombPtr->Next; break;
		  }
		  yyState = yyNDefault [yyState];
	       }
# else
	       yyState = yyNBasePtr [* yyStateStackPtr ++] [yyNonterminal];
# endif
	       * yyAttrStackPtr ++ = yySynAttribute;
	       if (yyState < yyFirstFinalState) goto yyParseLoop;
							/* read reduce ? */
# ifdef YYDEBUG
	       yyStateStackPtr [0] = yyStateStackPtr [-1];
# endif
	    }

	 } else {					/* read */
   yyRead:  yyStateStackPtr ++;
	    yyGetAttribute (yyAttrStackPtr ++, Attribute);
	    yyTerminal = yyGetToken ();
# ifdef YYDEBUG
	    if (Debug) {
	       yyPrintState (yyStateStackPtr [-1]);
	       (void) fprintf (yyTrace, "shift   %s, lookahead: %s",
		  yyGetTokenName (yyPrevTerminal),
		  yyGetTokenName (yyTerminal)); yyNl ();
	       yyPrevTerminal = yyTerminal;
	    }
# endif
	    yyIsRepairing = rfalse;
	 }
      }

   yyAbort:
# ifdef YYDEBUG
      if (Debug) {
	 yyPrintState (* yyStateStackPtr);
	 (void) fprintf (yyTrace, "fail    parse started at %ld", yyStartCount);
	 yyNl ();
      }
# endif
      return ++ yyErrorCount;

   yyAccept:
# ifdef YYDEBUG
      if (Debug) {
	 yyPrintState (* yyStateStackPtr);
	 (void) fprintf (yyTrace, "accept  parse started at %ld", yyStartCount);
	 yyNl ();
      }
# endif
      return yyErrorCount;
   }

# ifndef NO_RECOVER
static void yyErrorRecovery
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange * yyTerminal, yyStateRange * yyStateStack, short yyStackPtr)
# else
   (yyTerminal, yyStateStack, yyStackPtr)
   yySymbolRange *	yyTerminal	;
   yyStateRange *	yyStateStack	;
   short		yyStackPtr	;
# endif
   {
#     define	yyContinueSize	5000
      rbool	yyTokensSkipped	;
      tSet	yyContinueSet	;
      tSet	yyRestartSet	;
      int	yyLength	;
      char	yyContinueString [yyContinueSize + 2];

      if (yyControl.yyMessages) {
   /* 1. report an error */
	 ErrorMessage (xxSyntaxError, xxError, Attribute.Position);

   /* 2. report the offending token */
	 (void) strcpy (yyContinueString, yyGetTokenName (* yyTerminal));
# ifdef SPELLING
	 if (strncmp (yyContinueString, TokenPtr, TokenLength)) {
	    yyContinueString [yyLength = strlen (yyContinueString)] = ' ';
	    (void) GetWord (& yyContinueString [++ yyLength]);
	 }
# endif
	 ErrorMessageI (xxTokenFound, xxInformation, Attribute.Position,
	    xxString, yyContinueString);

   /* 3. report the set of expected terminal symbols */
	 MakeSet (& yyContinueSet, (short) yyLastTerminal);
	 yyComputeContinuation (yyStateStack, yyStackPtr, & yyContinueSet,
	    rtrue);
	 yyLength = 0;
	 yyContinueString [0] = '\0';
	 while (! IsEmpty (& yyContinueSet)) {
	    char * yyTokenString = yyGetTokenName (Extract (& yyContinueSet));
	    int yyl = strlen (yyTokenString);
	    if (yyLength + yyl >= yyContinueSize) break;
	    (void) strcpy (& yyContinueString [yyLength], yyTokenString);
	    yyLength += yyl;
	    yyContinueString [yyLength ++] = ' ';
	 }
	 yyContinueString [-- yyLength] = '\0';
	 ErrorMessageI (xxExpectedTokens, xxInformation, Attribute.Position,
	    xxString, yyContinueString);
	 ReleaseSet (& yyContinueSet);
      }

   /* 4. compute the set of terminal symbols for restart of the parse */
      MakeSet (& yyRestartSet, (short) yyLastTerminal);
      yyComputeRestartPoints (yyStateStack, yyStackPtr, & yyRestartSet);

   /* 5. skip terminal symbols until a restart point is reached */
      yyTokensSkipped = rfalse;
      while (! IsElement (* yyTerminal, & yyRestartSet)) {
# ifdef YYDEBUG
	 yySymbolRange yyPrevTerminal = * yyTerminal;
# endif
	 * yyTerminal = yyGetToken ();
	 yyTokensSkipped = rtrue;
# ifdef YYDEBUG
	 if (Debug) {
	    yyPrintState (yyStateStack [yyStackPtr]);
	    (void) fprintf (yyTrace, "skip    %s, lookahead: %s",
	       yyGetTokenName (yyPrevTerminal),
	       yyGetTokenName (* yyTerminal)); yyNl ();
	 }
# endif
      }
      ReleaseSet (& yyRestartSet);

   /* 6. report the restart point */
      if (yyTokensSkipped & yyControl.yyMessages)
	 ErrorMessage (xxRestartPoint, xxInformation, Attribute.Position);
   }

/*
   compute the set of terminal symbols that can be accepted (read)
   in a given stack configuration (eventually after reduce actions)
*/

static void yyComputeContinuation
# if defined __STDC__ | defined __cplusplus
   (yyStateRange * yyStack, short yyStackPtr, tSet * yyContinueSet,
    rbool yyreduce)
# else
   (yyStack, yyStackPtr, yyContinueSet, yyreduce)
   yyStateRange *	yyStack		;
   short		yyStackPtr	;
   tSet *		yyContinueSet	;
   rbool		yyreduce	;
# endif
   {
      register yySymbolRange	yyTerminal;
      register yyStateRange	yyState = yyStack [yyStackPtr];

      AssignEmpty (yyContinueSet);
      for (yyTerminal = yyFirstTerminal; yyTerminal <= yyLastTerminal;
							yyTerminal ++) {
	 if (yyNext (yyState, yyTerminal) != yyNoState &&
	    yyIsContinuation (yyTerminal, yyStack, yyStackPtr, yyreduce)) {
	    Include (yyContinueSet, (short) yyTerminal);
	 }
      }
   }

/*
   check whether a given terminal symbol can be accepted (read)
   in a certain stack configuration (eventually after reduce actions)
*/

static rbool yyIsContinuation
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange yyTerminal, yyStateRange * yyStateStack, short yyStackPtr,
    rbool yyreduce)
# else
   (yyTerminal, yyStateStack, yyStackPtr, yyreduce)
   yySymbolRange	yyTerminal	;
   yyStateRange *	yyStateStack	;
   short		yyStackPtr	;
   rbool		yyreduce	;
# endif
   {
      register yyStateRange	yState		;
      register yytNonterminal	yyNonterminal	;

      while (yyStackPtr >= (short) yyIsContStackSize)  /* pass Stack by value */
	 ExtendArray ((char * *) & yyIsContStackPtr, & yyIsContStackSize,
			  (unsigned long) sizeof (yyStateRange));
# ifdef BCOPY
      bcopy ((char *) yyStateStack, (char *) yyIsContStackPtr,
		 (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# else
      (void) memcpy ((char *) yyIsContStackPtr, (char *) yyStateStack,
			 (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# endif

      yState = yyIsContStackPtr [yyStackPtr];
      for (;;) {
	 yyIsContStackPtr [yyStackPtr] = yState;
	 yState = yyNext (yState, yyTerminal);
	 if (yState == yyNoState) return rfalse;

	 do {						/* reduce */
	    if (yState > yyLastReduceState) {		/* dynamic ? */
	       yState = yyCondition [yState - yyLastReduceState];
	    }
	    if (yState <= yyLastStopState) { /* read, read reduce, or accept? */
	       return rtrue;
	    } else if (yyreduce) {			/* reduce */
	       yyStackPtr -= yyLength [yState - yyFirstReduceState];
	       yyNonterminal = yyLeftHandSide [yState - yyFirstReduceState];
	    } else {
	       return rfalse;
	    }

	    yState = yyNext (yyIsContStackPtr [yyStackPtr],
				(yySymbolRange) yyNonterminal);
	    yyStackPtr ++;
	    if (yyStackPtr >= (short) yyIsContStackSize) {
	       ExtendArray ((char * *) & yyIsContStackPtr, & yyIsContStackSize,
				(unsigned long) sizeof (yyStateRange));
	       if (yyStackPtr >= 1000) return rfalse; /* EMERGENCY break !!! */
	    }
	 } while (yState >= yyFirstFinalState);
      }
   }

/*
   compute a set of terminal symbols that can be used to restart
   parsing in a given stack configuration. we simulate parsing until
   end of file using a suffix program synthesized by the function (array)
   yyContinuation. All symbols acceptable in the states reached during
   the simulation can be used to restart parsing.
*/

static void yyComputeRestartPoints
# if defined __STDC__ | defined __cplusplus
   (yyStateRange * yyStateStack, short yyStackPtr, tSet * yyRestartSet)
# else
   (yyStateStack, yyStackPtr, yyRestartSet)
   yyStateRange *	yyStateStack	;
   short		yyStackPtr	;
   tSet *		yyRestartSet	;
# endif
   {
      register yyStateRange	yState		;
      register yytNonterminal	yyNonterminal	;
	       tSet		yyContinueSet	;

      while (yyStackPtr >= (short) yyCompResStackSize) /* pass Stack by value */
	 ExtendArray ((char * *) & yyCompResStackPtr, & yyCompResStackSize,
			  (unsigned long) sizeof (yyStateRange));
# ifdef BCOPY
      bcopy ((char *) yyStateStack, (char *) yyCompResStackPtr,
		 (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# else
      (void) memcpy ((char *) yyCompResStackPtr, (char *) yyStateStack,
			 (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# endif

      MakeSet (& yyContinueSet, (short) yyLastTerminal);
      AssignEmpty (yyRestartSet);
      yState = yyCompResStackPtr [yyStackPtr];

      for (;;) {
	 if (yyStackPtr >= (short) yyCompResStackSize)
	    ExtendArray ((char * *) & yyCompResStackPtr, & yyCompResStackSize,
			     (unsigned long) sizeof (yyStateRange));
	 yyCompResStackPtr [yyStackPtr] = yState;
	 yyComputeContinuation (yyCompResStackPtr, yyStackPtr, & yyContinueSet,
	    rfalse);
	 Union (yyRestartSet, & yyContinueSet);
# ifdef YYDCRP
	 {
	    int yyLength = 0;
	    char yyContinueString [yyContinueSize + 2];
	    yyContinueString [0] = '\0';
	    while (! IsEmpty (& yyContinueSet)) {
	       char * yyTokenString = yyGetTokenName (Extract (& yyContinueSet));
	       int yyl = strlen (yyTokenString);
	       if (yyLength + yyl >= yyContinueSize) break;
	       (void) strcpy (& yyContinueString [yyLength], yyTokenString);
	       yyLength += yyl;
	       yyContinueString [yyLength ++] = ' ';
	    }
	    yyContinueString [-- yyLength] = '\0';
	    (void) fprintf (yyTrace, "%5d union %s", yState, yyContinueString);
	    yyNl ();
	 }
# endif
	 yState = yyNext (yState, yyContinuation [yState]);

	 if (yState >= yyFirstFinalState) {		/* final state ? */
	    if (yState <= yyLastReadReduceState) {	/* read reduce ? */
	       yyStackPtr ++;
	       yState = yyFinalToProd [yState - yyFirstReadReduceState];
# ifdef YYDCRP
	       yyCompResStackPtr [yyStackPtr] =
					yyCompResStackPtr [yyStackPtr - 1];
	       (void) fprintf (yyTrace, "%5d shift   %s",
		  yyCompResStackPtr [yyStackPtr], yyGetTokenName
		  (yyContinuation [yyCompResStackPtr [yyStackPtr]])); yyNl ();
# endif
	    }

	    do {					/* reduce */
	       if (yState > yyLastReduceState) {	/* dynamic ? */
# ifdef YYDCRP
		  (void) fprintf (yyTrace, "%5d dynamic decision %d",
		    yyCompResStackPtr [yyStackPtr], yState - yyLastReduceState);
		  yyNl ();
# endif
		  yState = yyCondition [yState - yyLastReduceState];
	       }
	       if (yyFirstReduceState <= yState &&
		   yState <= yyLastStopState) {		/* accept */
# ifdef YYDCRP
		  (void) fprintf (yyTrace, "%5d accept",
		     yyCompResStackPtr [yyStackPtr]); yyNl ();
# endif
		  ReleaseSet (& yyContinueSet);
		  return;
	       } else if (yState < yyFirstFinalState) {	/* read */
		  goto yyRead;
	       } else {					/* reduce */
# ifdef YYDCRP
		  (void) fprintf (yyTrace, "%5d reduce  %s",
		     yyCompResStackPtr [yyStackPtr],
		     yyRule [yState - yyLastReadReduceState]); yyNl ();
# endif
		  yyStackPtr -= yyLength [yState - yyFirstReduceState];
		  yyNonterminal = yyLeftHandSide [yState - yyFirstReduceState];
	       }

	       yState = yyNext (yyCompResStackPtr [yyStackPtr],
				(yySymbolRange) yyNonterminal);
	       yyStackPtr ++;
	    } while (yState >= yyFirstFinalState);
	 } else {					/* read */
yyRead:
# ifdef YYDCRP
	    (void) fprintf (yyTrace, "%5d shift   %s",
	       yyCompResStackPtr [yyStackPtr], yyGetTokenName
	       (yyContinuation [yyCompResStackPtr [yyStackPtr]])); yyNl ();
# endif
	    yyStackPtr ++;
	 }
      }
   }

/* access the parse table:   Next : State x Symbol -> Action */

static yyStateRange yyNext
# if defined __STDC__ | defined __cplusplus
   (yyStateRange yyState, yySymbolRange yySymbol)
# else
   (yyState, yySymbol) yyStateRange yyState; yySymbolRange yySymbol;
# endif
   {
      if (yySymbol <= yyLastTerminal) {
	 for (;;) {
	    register yytComb * yyTCombPtr = yyTBasePtr [yyState] + yySymbol;
# if defined YYTDefault & defined YYaccDefault
	    register unsigned long * yylp;
# endif
	    if (yyTCombPtr->Check == yyState) return yyTCombPtr->Next;
# ifdef YYTDefault
#    ifdef YYaccDefault
	    return (yylp = yyDefaultLook [yyState]) &&
	       (yylp [yySymbol >> 5] >> (yySymbol & 0x1f)) & 1 ?
		  yyTDefault [yyState] : yyNoState;
#    else
	    if ((yyState = yyTDefault [yyState]) == yyNoState) return yyNoState;
#    endif
# else
	    return yyNoState;
# endif
	 }
      }
# ifdef YYNDefault
      for (;;) {
	 register yytComb * yyNCombPtr = yyNBasePtr [yyState] + yySymbol;
	 if (yyNCombPtr->Check == yyState) return yyNCombPtr->Next;
	 yyState = yyNDefault [yyState];
      }
# else
      return yyNBasePtr [yyState] [yySymbol];
# endif
   }
# endif

void BeginParser ARGS ((void))
   {
/* line 75 "fortran.lalr" */

  BeginScanner ();

   }

void CloseParser ARGS ((void))
   {
   }

