# include "ParNest.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 37 "ParNest.puma" */


# undef DEBUG

# include "Idents.h"
# include "protocol.h"

# include "Nesting.h"
# include "Expressions.h"
# include "Shapes.h"
# include "TreeOps.h"          /* TreeVarName */

# define MODULE "ParNest"

# define MAXConstructs 100

/*********************************************************************
*                                                                    * 
*  Global Data for ParNest                                           * 
*                                                                    * 
*  ParNest[0]          DO     I1 = ...                               *
*  ParNest[1]          DO     I2 = ...                               *
*  ...                                                               *
*  ParNest[ParNesting-1]  FORALL Ik = ...                            *
*                                                                    *
*    stmt      :         A(I1,I2,...,Ik)  = ....                     *
*                                                                    *
*********************************************************************/

static int ParNesting = 0;            /* actual depth of nesting          */
static tTree ParNest[MAXConstructs];  /* actual stmts of parallel nesting */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyParNest.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ParNest_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ParNest, routine %s failed\n",
  yyFunction);
 ParNest_Exit ();
}

void IncParNesting ARGS ((tTree stmt));
void DecParNesting ARGS ((tTree stmt));
int GetParNestingDepth ARGS ((void));
tTree GetParNestACF ARGS ((int n));
rbool HasUserHome ARGS ((void));
tTree GetUserHome ARGS ((void));
rbool UserIndependent ARGS ((void));
rbool InTaskRegion ARGS ((void));
static rbool IsTaskRegionStmt ARGS ((tTree stmt));
rbool IsParallelMasked ARGS ((void));
static rbool IsConditionalStmt ARGS ((tTree stmt));
static rbool IsHomeStmt ARGS ((tTree stmt));
static rbool IsUserIndependentLoop ARGS ((tTree stmt));
static rbool IsUserHomeStmt ARGS ((tTree stmt));
static tTree GetHomeVar ARGS ((tTree stmt));
rbool IsNewVariable ARGS ((tTree var));
rbool IsResidentVariable ARGS ((tTree var));
static rbool IsNewDefined ARGS ((tTree var, tTree stmt));
static rbool IsResidentDefined ARGS ((tTree var, tTree stmt));
static rbool IsSubVarInVarList ARGS ((tTree v, tTree vlist));
static rbool IsSubVar ARGS ((tTree selected_var, tTree full_var));

void IncParNesting
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
/* line 81 "ParNest.puma" */
  {
/* line 83 "ParNest.puma" */
   if (! ((IsCountLoop (stmt)))) goto yyL1;
  {
/* line 84 "ParNest.puma" */
   IncLoopNesting (stmt);
/* line 85 "ParNest.puma" */
   goto yyL1;
  }
  }
yyL1:;

/* line 88 "ParNest.puma" */
  {
/* line 90 "ParNest.puma" */
 if (ParNesting >= MAXConstructs)  
       simple_error_protocol ("to deep nesting within parallel constructs");
      else
       { ParNest [ParNesting] = stmt;
         ParNesting += 1;
       }
   
  }
   return;

;
}

void DecParNesting
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
/* line 101 "ParNest.puma" */
  {
/* line 103 "ParNest.puma" */
   if (! ((IsCountLoop (stmt)))) goto yyL1;
  {
/* line 104 "ParNest.puma" */
   DecLoopNesting (stmt);
/* line 105 "ParNest.puma" */
   goto yyL1;
  }
  }
yyL1:;

/* line 108 "ParNest.puma" */
  {
/* line 110 "ParNest.puma" */
 if (ParNesting == 0)  
       simple_error_protocol ("ParNest : no construct to be quit");
      else if (ParNest[ParNesting-1] != stmt)
       simple_error_protocol ("ParNest : wrong stmt to be quit");
      else
       ParNesting -= 1;
   
  }
   return;

;
}

int GetParNestingDepth
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 121 "ParNest.puma" */
   return ParNesting;

}

tTree GetParNestACF
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
/* line 127 "ParNest.puma" */
  {
/* line 128 "ParNest.puma" */
   if (! ((n >= 1))) goto yyL1;
  {
/* line 129 "ParNest.puma" */
   if (! ((n <= ParNesting))) goto yyL1;
  }
  }
   return ParNest [n - 1];
yyL1:;

/* line 133 "ParNest.puma" */
  {
/* line 135 "ParNest.puma" */
 char msg[100];
      sprintf (msg, "GetParNestACF, index = %d must be >= 1 and <= %d\n",
                     n, ParNesting);
      failure_protocol (MODULE, msg, NoTree);
    
  }
   return NoTree;

}

rbool HasUserHome
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 155 "ParNest.puma" */
 {
  rbool user_home;
  {
/* line 159 "ParNest.puma" */
 int i;

     user_home = rfalse;

     for (i=0; i<ParNesting; i++)

       if (IsUserHomeStmt (ParNest[i]))
       
          user_home = rtrue;
   
/* line 170 "ParNest.puma" */
   if (! ((user_home))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

tTree GetUserHome
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 175 "ParNest.puma" */
 {
  tTree user_home;
  {
/* line 179 "ParNest.puma" */
 int i;

     for (i=0; i<ParNesting; i++)

       if (IsUserHomeStmt (ParNest[i]))
       
          user_home = GetHomeVar (ParNest[i]);
   
  }
   return user_home;
 }

}

rbool UserIndependent
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 201 "ParNest.puma" */
 {
  rbool is_independent;
  {
/* line 205 "ParNest.puma" */
 int i;

     is_independent = rfalse;

     for (i=0; i<ParNesting; i++)

       if (IsUserIndependentLoop (ParNest[i]))
       
          is_independent = rtrue;
   
/* line 216 "ParNest.puma" */
   if (! ((is_independent))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

rbool InTaskRegion
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 227 "ParNest.puma" */
 {
  rbool is_task;
  {
/* line 231 "ParNest.puma" */
 int i;

     is_task = rfalse;

     for (i=0; i<ParNesting; i++)

       if (IsTaskRegionStmt (ParNest[i]))
       
          is_task = rtrue;
   
/* line 242 "ParNest.puma" */
   if (! ((is_task))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static rbool IsTaskRegionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_TASK_REGION) {
/* line 247 "ParNest.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsParallelMasked
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 258 "ParNest.puma" */
 {
  rbool masked;
  {
/* line 262 "ParNest.puma" */
 int i;

     masked = rfalse;

     for (i=0; i<ParNesting; i++)

       if (IsConditionalStmt (ParNest[i]))
       
          masked = rtrue;
   
/* line 273 "ParNest.puma" */
   if (! ((masked))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static rbool IsConditionalStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_IF) {
/* line 278 "ParNest.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsHomeStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
/* line 283 "ParNest.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsUserIndependentLoop
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_DO) {
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 288 "ParNest.puma" */
  {
/* line 290 "ParNest.puma" */
   if (! ((stmt->ACF_DO.DO_DEP_INFO->INDEP_INFO.user_independent))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static rbool IsUserHomeStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
/* line 295 "ParNest.puma" */
  {
/* line 297 "ParNest.puma" */
   if (! ((stmt->ACF_HOME.user_home))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static tTree GetHomeVar
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
/* line 302 "ParNest.puma" */
   return stmt->ACF_HOME.HOME_VAR;

  }
/* line 307 "ParNest.puma" */
  {
/* line 309 "ParNest.puma" */
   failure_protocol (MODULE, "GetHomeVar", stmt);
  }
   return NoTree;

}

rbool IsNewVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 336 "ParNest.puma" */
 {
  rbool found;
  {
/* line 340 "ParNest.puma" */
 int  i;
     rbool stop;

#ifdef DEBUG
     printf ("IsNewVariable (");
     FileUnparse (stdout, var);
#endif

     found = rfalse;
     i     = ParNesting;   
     stop  = (i <= 0);

     while (!stop) 

       { i--;

         

         if (IsHomeStmt (ParNest[i])) stop = rtrue;
         if (IsNewDefined (var, ParNest[i])) found = rtrue;
         if (i == 0) stop = rtrue;
       }

   
/* line 365 "ParNest.puma" */
   if (! ((found))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

rbool IsResidentVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 376 "ParNest.puma" */
 {
  rbool found;
  {
/* line 381 "ParNest.puma" */
 int  i;
     rbool stop;

     found = rfalse;
     i     = ParNesting;   
     stop  = (i <= 0);

     while (!stop) 

       { i--;

         

         if (IsHomeStmt (ParNest[i])) stop = rtrue;
         if (IsResidentDefined (var, ParNest[i])) found = rtrue;
         if (i == 0) stop = rtrue;
       }

   
/* line 401 "ParNest.puma" */
   if (! ((found))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static rbool IsNewDefined
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt)
# else
(var, stmt)
 register tTree var;
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_NEW) {
/* line 416 "ParNest.puma" */
  {
/* line 418 "ParNest.puma" */
   if (! ((IsSubVarInVarList (var, stmt->ACF_NEW.NEW_VAR)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool IsResidentDefined
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt)
# else
(var, stmt)
 register tTree var;
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_RESIDENT) {
/* line 429 "ParNest.puma" */
  {
/* line 431 "ParNest.puma" */
   if (! ((IsSubVarInVarList (var, stmt->ACF_RESIDENT.RESIDENT_VAR)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool IsSubVarInVarList
# if defined __STDC__ | defined __cplusplus
(register tTree v, register tTree vlist)
# else
(v, vlist)
 register tTree v;
 register tTree vlist;
# endif
{
/* line 442 "ParNest.puma" */
  {
/* line 444 "ParNest.puma" */
   if (! ((vlist == NoTree))) goto yyL1;
  {
/* line 445 "ParNest.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (vlist->Kind == kBTV_LIST) {
  if (vlist->BTV_LIST.Elem->Kind == kDUMMY_VAR) {
  if (vlist->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 448 "ParNest.puma" */
   return rtrue;

  }
  }
/* line 451 "ParNest.puma" */
  {
/* line 453 "ParNest.puma" */
   if (! ((IsSubVar (v, vlist->BTV_LIST.Elem)))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 456 "ParNest.puma" */
  {
/* line 458 "ParNest.puma" */
   if (! ((IsSubVarInVarList (v, vlist->BTV_LIST.Next)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static rbool IsSubVar
# if defined __STDC__ | defined __cplusplus
(register tTree selected_var, register tTree full_var)
# else
(selected_var, full_var)
 register tTree selected_var;
 register tTree full_var;
# endif
{
  if (full_var->Kind == kINDEXED_VAR) {
/* line 478 "ParNest.puma" */
  {
/* line 480 "ParNest.puma" */
   if (! ((IsWholeVar (full_var)))) goto yyL1;
  {
/* line 481 "ParNest.puma" */
   if (! ((IsSubVar (selected_var, full_var->INDEXED_VAR.IND_VAR)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  if (selected_var->Kind == kUSED_VAR) {
  if (full_var->Kind == kUSED_VAR) {
/* line 484 "ParNest.puma" */
  {
/* line 486 "ParNest.puma" */
   if (! ((TreeVarName (selected_var->USED_VAR.VARNAME) == TreeVarName (full_var->USED_VAR.VARNAME)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  if (selected_var->Kind == kINDEXED_VAR) {
  if (full_var->Kind == kUSED_VAR) {
/* line 489 "ParNest.puma" */
  {
/* line 491 "ParNest.puma" */
   if (! ((IsSubVar (selected_var->INDEXED_VAR.IND_VAR, full_var)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (full_var->Kind == kINDEXED_VAR) {
/* line 499 "ParNest.puma" */
  {
/* line 501 "ParNest.puma" */
   if (! ((IsSubVar (selected_var->INDEXED_VAR.IND_VAR, full_var->INDEXED_VAR.IND_VAR)))) goto yyL5;
  {
/* line 502 "ParNest.puma" */
   if (! ((EqualIndexes (selected_var->INDEXED_VAR.IND_EXPS, full_var->INDEXED_VAR.IND_EXPS)))) goto yyL5;
  }
  }
   return rtrue;
yyL5:;

  }
  }
  if (selected_var->Kind == kSELECTED_VAR) {
  if (full_var->Kind == kUSED_VAR) {
/* line 494 "ParNest.puma" */
  {
/* line 496 "ParNest.puma" */
   if (! ((IsSubVar (selected_var->SELECTED_VAR.SELEC_VAR, full_var)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  }
  return rfalse;
}

void BeginParNest ARGS ((void))
{
}

void CloseParNest ARGS ((void))
{
}
