# include "PTreeOps.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 24 "PTreeOps.puma" */


# define MODULE "TreeOps"

# include "Idents.h"
# include "protocol.h"

# include "Shapes.h"        /* IsWholeVar */
# include "TreeOps.h"       /* TreeVarName */
# include "Expressions.h"   /* EqualIndexes */


# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyPTreeOps.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* PTreeOps_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module PTreeOps, routine %s failed\n",
  yyFunction);
 PTreeOps_Exit ();
}

rbool IsNewDefined ARGS ((tTree var, tTree stmt));
rbool IsResidentDefined ARGS ((tTree var, tTree stmt));
static rbool IsSubVarInVarList ARGS ((tTree v, tTree vlist));
static rbool IsSubVar ARGS ((tTree selected_var, tTree full_var));
rbool IsVarUsed ARGS ((tTree var, tTree stmt));

rbool IsNewDefined
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt)
# else
(var, stmt)
 register tTree var;
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_NEW) {
/* line 46 "PTreeOps.puma" */
  {
/* line 48 "PTreeOps.puma" */
   if (! ((IsSubVarInVarList (var, stmt->ACF_NEW.NEW_VAR)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

rbool IsResidentDefined
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt)
# else
(var, stmt)
 register tTree var;
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_RESIDENT) {
/* line 59 "PTreeOps.puma" */
  {
/* line 61 "PTreeOps.puma" */
   if (! ((IsSubVarInVarList (var, stmt->ACF_RESIDENT.RESIDENT_VAR)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool IsSubVarInVarList
# if defined __STDC__ | defined __cplusplus
(register tTree v, register tTree vlist)
# else
(v, vlist)
 register tTree v;
 register tTree vlist;
# endif
{
/* line 73 "PTreeOps.puma" */
  {
/* line 75 "PTreeOps.puma" */
   if (! ((vlist == NoTree))) goto yyL1;
  {
/* line 76 "PTreeOps.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (vlist->Kind == kBTV_LIST) {
  if (vlist->BTV_LIST.Elem->Kind == kDUMMY_VAR) {
  if (vlist->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 79 "PTreeOps.puma" */
   return rtrue;

  }
  }
/* line 82 "PTreeOps.puma" */
  {
/* line 84 "PTreeOps.puma" */
   if (! ((IsSubVar (v, vlist->BTV_LIST.Elem)))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 87 "PTreeOps.puma" */
  {
/* line 89 "PTreeOps.puma" */
   if (! ((IsSubVarInVarList (v, vlist->BTV_LIST.Next)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static rbool IsSubVar
# if defined __STDC__ | defined __cplusplus
(register tTree selected_var, register tTree full_var)
# else
(selected_var, full_var)
 register tTree selected_var;
 register tTree full_var;
# endif
{
  if (full_var->Kind == kINDEXED_VAR) {
/* line 109 "PTreeOps.puma" */
  {
/* line 111 "PTreeOps.puma" */
   if (! ((IsWholeVar (full_var)))) goto yyL1;
  {
/* line 112 "PTreeOps.puma" */
   if (! ((IsSubVar (selected_var, full_var->INDEXED_VAR.IND_VAR)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  if (selected_var->Kind == kUSED_VAR) {
  if (full_var->Kind == kUSED_VAR) {
/* line 115 "PTreeOps.puma" */
  {
/* line 117 "PTreeOps.puma" */
   if (! ((TreeVarName (selected_var->USED_VAR.VARNAME) == TreeVarName (full_var->USED_VAR.VARNAME)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  if (selected_var->Kind == kINDEXED_VAR) {
  if (full_var->Kind == kUSED_VAR) {
/* line 120 "PTreeOps.puma" */
  {
/* line 122 "PTreeOps.puma" */
   if (! ((IsSubVar (selected_var->INDEXED_VAR.IND_VAR, full_var)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (full_var->Kind == kINDEXED_VAR) {
/* line 130 "PTreeOps.puma" */
  {
/* line 132 "PTreeOps.puma" */
   if (! ((IsSubVar (selected_var->INDEXED_VAR.IND_VAR, full_var->INDEXED_VAR.IND_VAR)))) goto yyL5;
  {
/* line 133 "PTreeOps.puma" */
   if (! ((EqualIndexes (selected_var->INDEXED_VAR.IND_EXPS, full_var->INDEXED_VAR.IND_EXPS)))) goto yyL5;
  }
  }
   return rtrue;
yyL5:;

  }
  }
  if (selected_var->Kind == kSELECTED_VAR) {
  if (full_var->Kind == kUSED_VAR) {
/* line 125 "PTreeOps.puma" */
  {
/* line 127 "PTreeOps.puma" */
   if (! ((IsSubVar (selected_var->SELECTED_VAR.SELEC_VAR, full_var)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  }
  return rfalse;
}

rbool IsVarUsed
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt)
# else
(var, stmt)
 register tTree var;
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_LIST) {
/* line 150 "PTreeOps.puma" */
  {
/* line 152 "PTreeOps.puma" */
   if (! ((IsVarUsed (var, stmt->ACF_LIST.Elem)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 155 "PTreeOps.puma" */
  {
/* line 157 "PTreeOps.puma" */
   if (! ((IsVarUsed (var, stmt->ACF_LIST.Next)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 160 "PTreeOps.puma" */
  {
/* line 160 "PTreeOps.puma" */
   return rfalse;
  }

  }
  if (stmt->Kind == kACF_EMPTY) {
/* line 162 "PTreeOps.puma" */
  {
/* line 162 "PTreeOps.puma" */
   return rfalse;
  }

  }
  if (stmt->Kind == kACF_IF) {
/* line 168 "PTreeOps.puma" */
  {
/* line 170 "PTreeOps.puma" */
   if (! ((IsVarInExp (TreeVarName (var), stmt->ACF_IF.IF_EXP)))) goto yyL5;
  }
   return rtrue;
yyL5:;

/* line 173 "PTreeOps.puma" */
  {
/* line 175 "PTreeOps.puma" */
   if (! ((IsVarUsed (var, stmt->ACF_IF.THEN_PART)))) goto yyL6;
  }
   return rtrue;
yyL6:;

/* line 178 "PTreeOps.puma" */
  {
/* line 180 "PTreeOps.puma" */
   if (! ((IsVarUsed (var, stmt->ACF_IF.ELSE_PART)))) goto yyL7;
  }
   return rtrue;
yyL7:;

/* line 183 "PTreeOps.puma" */
  {
/* line 183 "PTreeOps.puma" */
   return rfalse;
  }

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 189 "PTreeOps.puma" */
  {
/* line 191 "PTreeOps.puma" */
   if (! ((TreeVarName (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) == TreeVarName (var)))) goto yyL9;
  }
   return rtrue;
yyL9:;

/* line 194 "PTreeOps.puma" */
  {
/* line 196 "PTreeOps.puma" */
   if (! ((IsVarInExp (TreeVarName (var), stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL10;
  }
   return rtrue;
yyL10:;

/* line 199 "PTreeOps.puma" */
  {
/* line 199 "PTreeOps.puma" */
   return rfalse;
  }

  }
  }
  if (Tree_IsType (stmt, kBT_EXP)) {
/* line 203 "PTreeOps.puma" */
  {
/* line 205 "PTreeOps.puma" */
   if (! ((IsVarInExp (TreeVarName (var), stmt)))) goto yyL12;
  }
   return rtrue;
yyL12:;

/* line 208 "PTreeOps.puma" */
  {
/* line 208 "PTreeOps.puma" */
   return rfalse;
  }

  }
/* line 210 "PTreeOps.puma" */
   return rtrue;

}

void BeginPTreeOps ARGS ((void))
{
}

void ClosePTreeOps ARGS ((void))
{
}
