# include "OverlapUpdate.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 58 "OverlapUpdate.puma" */


# define MODULE "OverlapUpdate"

# include "Idents.h"
# include "StringM.h"
# include "DynArray.h"
# include "protocol.h"

# include "Types.h"
# include "Transform.h"             /* ReplaceACF                     */
# include "Expressions.h"           /* MakeConstant                   */
# include "Shapes.h"                /* MakeFullShape                  */
# include "TreeOps.h"               /* TreeVarName                    */

# include "VectorMove.h"            /* VectorizeVar                   */

/*********************************************************************
*                                                                    * 
*    local INTERFACES                                                *
*                                                                    * 
*********************************************************************/

static rbool EqualSections ARGS((tTree v1, tTree v2));
static rbool IsSubSection ARGS((tTree v1, tTree v2));
static tTree MakeOverlapReset ARGS((tTree var));
static tTree UnionSection ARGS((tTree v1, tTree v2));
 
/*********************************************************************
*                                                                    * 
*    Functions for optimizing overlap updates                        *
*                                                                    * 
*********************************************************************/

# define UPDATE_SIZE 25

static int  UpdateCounter = 0;
static unsigned long UpdateMax     = 0;   /* must be long */

typedef struct

  { tTree    var;
    int      rank;
    int      left  [MAX_DIMENSIONS];
    int      right [MAX_DIMENSIONS];

  } overlap_update;

static overlap_update *all_updates;

static void VerifyUpdateArray ()

{ if (all_updates == (overlap_update *) 0)
    { printf ("Could not extend overlap updates array to size %d\n", UpdateMax);
      printf ("Internal Error\n");
      exit (-1);
    }

} /* VerifyUpdateArray */

       /******************************************************
       *                                                     * 
       *   InitUpdates ()                                    * 
       *                                                     * 
       ******************************************************/

static void InitUpdates ()

{ UpdateCounter = 0;

  if (UpdateMax == 0)

    { UpdateMax = UPDATE_SIZE;
      MakeArray ((char * *) &all_updates, &UpdateMax, 
                 (long) sizeof (overlap_update));
      VerifyUpdateArray ();
    }

} /* InitUpdates */

       /******************************************************
       *                                                     * 
       *   IsAnUpdate (sv)                                   * 
       *                                                     * 
       ******************************************************/

static rbool IsAnUpdate (sv)
pshift sv;

{ rbool is;
  int  i;

  is = rfalse;
  for (i=0; i<sv->shift_rank; i++)
     is = is || (sv->shift_pos[i] != 0);
 
  return (is);

} /* IsAnUpdate */

       /*******************************************************
       *                                                      * 
       * TranslateShiftToUpdate (tTree, *shift_vector,        *
       *                         *overlap_update)             * 
       *                                                      * 
       *******************************************************/

static void TranslateShiftToUpdate (var, sv, op)
tTree var;
shift_vector   *sv;
overlap_update *op;

{ int i, rank;
  int val;

  rank = sv->shift_rank;
  op->rank = rank;
  op->var  = var;

  for (i=0; i<rank; i++)

    { val = sv->shift_pos[i];

      if (val < 0)

         { /* right overlap */
           op->left[i]  = 0;
           op->right[i] = -val;
         }

       else

         { /* right overlap */
           op->left[i]  = val;
           op->right[i] = 0;
         }
    }

} /* TranslateShiftToUpdate */

       /*******************************************************
       *                                                      * 
       *  IsSmallerOverlap (overlap_update *op1, *op2)        *
       *                                                      * 
       *   - returns rtrue if op2 updates bigger than op1      * 
       *   - also rfalse if no analysis is possible            * 
       *                                                      * 
       *******************************************************/

static rbool IsSmallerOverlap (op1, op2)
overlap_update *op1;
overlap_update *op2;

{ rbool is;
  int i, rank;

  if (!IsSubSection (op1->var, op2->var))
     return (rfalse);

  rank = op1->rank;
  is   = rtrue;

  for (i=0; i<rank; i++)
    { if (op1->left[i]  > op2->left[i])  is = rfalse;
      if (op1->right[i] > op2->right[i]) is = rfalse;
    }

  return (is);

} /* IsSmallerOverlap */

       /*******************************************************
       *                                                      * 
       *  OrthogonalOverlaps (overlap_update *op1, *op2)      *
       *                                                      * 
       *   - returns rtrue if op1 and op2 have no              * 
       *     overlap dimension in common                      * 
       *                                                      * 
       *   (1:1,0:0) and (0:0,1:1) are orthogonal             * 
       *   (1:1,0:0) and (1:0,0:2) are not orthogonal         * 
       *                                                      * 
       *******************************************************/

static rbool OrthogonalOverlaps (op1, op2)
overlap_update *op1;
overlap_update *op2;

{ rbool is, nonzero1, nonzero2;
  int i, rank;

  /* different variables are orthogonal in any case */

  if (TreeVarName (op1->var) != TreeVarName (op2->var)) 
     return rtrue;

  /*
  if (!EqualSections (op1->var, op2->var))
     return (rtrue);
  */

  rank = op1->rank;
  is   = rtrue;

  for (i=0; i<rank; i++)

    { nonzero1 = (op1->right[i] != 0) || (op1->left[i] != 0);
      nonzero2 = (op2->right[i] != 0) || (op2->left[i] != 0);

      if (nonzero1 && nonzero2) is = rfalse;
    }

  return (is);

} /* OrthogonalOverlaps */

       /*******************************************************
       *                                                      * 
       *  OverlapUnion (overlap_update *op1, *op2)            *
       *                                                      * 
       *   - op1 can be removed, op2 contains the union       * 
       *   - union must really be possible                    * 
       *                                                      * 
       *******************************************************/

static void OverlapUnion (op1, op2)
overlap_update *op1;
overlap_update *op2;

{ int i, rank;

  op2->var = UnionSection (op2->var, op1->var);

  rank  = op1->rank;

  for (i=0; i<rank; i++)

    {  if (op2->left[i] < op1->left[i])
          op2->left[i] = op1->left[i];
       if (op2->right[i] < op1->right[i])
          op2->right[i] = op1->right[i];
    }

} /* OverlapUnion */

       /******************************************************
       *                                                     * 
       *   IsExistingOverlap (op)                            * 
       *                                                     * 
       *   - checks whether op does already exist in         * 
       *     the global list of overlaps                     * 
       *                                                     * 
       ******************************************************/

static rbool IsExistingOverlap (op)

overlap_update *op;

{ int  i;
  rbool found;

  found = rfalse;
  i     = 0;

  while ( (!found) && (i<UpdateCounter) )

    { /* found becomes rtrue if it can be proved that the
         new overlap op does not already exist           */

      found = IsSmallerOverlap (op, all_updates+i);
      i++;
    }

  return (found);

} /* IsExistingOverlap */

       /******************************************************
       *                                                     * 
       *   CompressExistingOverlaps (op)                     * 
       *                                                     * 
       *   - all existing op1 with op1 <= op will be         * 
       *     removed of the update list
       *                                                     * 
       ******************************************************/

static void CompressExistingOverlaps (op)

overlap_update *op;

{ int  i, j;
  rbool found;

  found = rfalse;
  i     = 0;

  while ( (!found) && (i<UpdateCounter) )

    { found = (!OrthogonalOverlaps (all_updates+i, op));

      /* all_updates[i] and *op will be combined if not orthogonal */

      if (found) 
          OverlapUnion (all_updates + i, op);
        else
          i++;
    }

  if (found)

    { /* update at position i is no longer necessary */

      for (j=i+1; j<UpdateCounter; j++)
         all_updates[j-1] = all_updates[j];

      UpdateCounter--;

      CompressExistingOverlaps (op);
   
    }

} /* CompressExsitingOverlaps */

       /******************************************************
       *                                                     * 
       *   MakeNewUpdate (op)                                * 
       *                                                     * 
       *   - sets the update in the global table             * 
       *                                                     * 
       ******************************************************/

static void MakeNewUpdate (op)

overlap_update *op;

{ overlap_update *ptr;

  if (UpdateCounter == UpdateMax)

     { ExtendArray ( (char **) &all_updates, &UpdateMax, 
                 (long) sizeof (overlap_update));
       VerifyUpdateArray ();
    }

  ptr = all_updates + UpdateCounter;

  *ptr = *op;

  UpdateCounter++;

} /* MakeNewUpdate */

       /******************************************************
       *                                                     * 
       *   SetUpdate (var, sv)                               * 
       *                                                     * 
       *   - compares with existent overlaps and makes       * 
       *     a new entry if this is necessary                * 
       *                                                     * 
       ******************************************************/

static void SetUpdate (var, sv)

tTree var;
pshift sv;

{ overlap_update op_structure;

  if (! IsAnUpdate(sv)) return;   /* update [0,0,0,...,0] */

  TranslateShiftToUpdate (var, sv, &op_structure);

  if (IsExistingOverlap (&op_structure))
     return;

  /* overlap will become a new entry, but delete at first 
     all existing updates that will become unnecessary     */

  CompressExistingOverlaps (&op_structure);

  MakeNewUpdate (&op_structure);

} /* SetUpdate */

       /******************************************************
       *                                                     * 
       *   GetArrayUpdates ()                                * 
       *                                                     * 
       ******************************************************/

static tTree GetArrayUpdates ()

{ tTree update, update_list;

  overlap_update *ptr;

  int i, j;

  update_list = NoTree;

  ptr = all_updates;

  for (i=0; i<UpdateCounter; i++)

     { update = mBTE_EMPTY();

       for (j=ptr->rank; j>=1; j--)

          update = mBTE_LIST (mSLICE_EXP (MakeConstant (ptr->left[j-1]), 
                                          MakeConstant (ptr->right[j-1]),
                                          mDUMMY_EXP()),
                              update);

       update = mREG_SHADOW_GET (ptr->var, update);
       update = mACF_BASIC (update);
       update_list = CombineACF (update_list, update);

       ptr++;
     }

  return (update_list);

}  /* GetArrayUpdates */

       /******************************************************
       *                                                     * 
       *   GetArrayResets ()                                 * 
       *                                                     * 
       ******************************************************/

static tTree GetArrayResets ()

{ tTree reset, reset_list, stm;
  rbool found;

  overlap_update *ptr, *ptr1;

  int i, j;

  reset_list = NoTree;
  ptr = all_updates;

  for (i=0; i<UpdateCounter; i++)

     { /* check whether there is another entry for this variable */

       ptr1 = ptr + 1;
       found = rfalse;
       for (j=i+1; j<UpdateCounter; j++)
          if (TreeVarName (ptr->var) == TreeVarName ((ptr1++)->var))
             found = rtrue;

       if (!found)
         reset_list = CombineACF (reset_list, MakeOverlapReset (ptr->var));

       ptr++;
     }

  return (reset_list);

}  /* GetArrayResets */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyOverlapUpdate.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* OverlapUpdate_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module OverlapUpdate, routine %s failed\n",
  yyFunction);
 OverlapUpdate_Exit ();
}

void InitOverlapUpdates ARGS ((void));
tTree GetOverlapUpdates ARGS ((void));
tTree GetOverlapResets ARGS ((void));
void SetOverlapUpdate ARGS ((tTree v, pshift sv));
void SetShiftOverlapUpdate ARGS ((tTree v, pshift sv));
rbool IsOverlapUpdate ARGS ((pshift sv));
static void ShiftSection ARGS ((tTree v, pshift sv));
static void ShiftIndexes ARGS ((tTree indexes, pshift sv, int pos));
static void ShiftSection1 ARGS ((tTree v, pshift sv));
static void ShiftIndexes1 ARGS ((tTree indexes, pshift sv, int pos));
static void NormalizeSection ARGS ((tTree exp));
static rbool EqualSections ARGS ((tTree v1, tTree v2));
static rbool IsSubSection ARGS ((tTree v1, tTree v2));
static rbool SubIndexes ARGS ((tTree indexes1, tTree indexes2));
static rbool SubExpression ARGS ((tTree e1, tTree e2));
static rbool IsSimpleExpression ARGS ((tTree e));
static rbool ExpLE ARGS ((tTree e1, tTree e2));
static void CommonSliceIncrement ARGS ((tTree slice1, tTree slice2, rbool * yyP2, int * yyP1));
static tTree UnionSection ARGS ((tTree v1, tTree v2));
static void UnionIndexes ARGS ((tTree indexes1, tTree indexes2));
static tTree UnionSlices ARGS ((tTree e1, tTree e2));
static tTree MakeOverlapReset ARGS ((tTree var));
void VectorizeOverlapUpdates ARGS ((tTree id, tTree slice));

void InitOverlapUpdates
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 530 "OverlapUpdate.puma" */
  {
/* line 531 "OverlapUpdate.puma" */
   InitUpdates ();
  }
   return;

;
}

tTree GetOverlapUpdates
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 536 "OverlapUpdate.puma" */
   return GetArrayUpdates ();

}

tTree GetOverlapResets
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 542 "OverlapUpdate.puma" */
   return GetArrayResets ();

}

void SetOverlapUpdate
# if defined __STDC__ | defined __cplusplus
(register tTree v, pshift sv)
# else
(v, sv)
 register tTree v;
 pshift sv;
# endif
{
  if (v->Kind == kINDEXED_VAR) {
/* line 548 "OverlapUpdate.puma" */
 {
  tTree new_var;
  {
/* line 552 "OverlapUpdate.puma" */
   new_var = CopyTree (v);
/* line 553 "OverlapUpdate.puma" */
   NormalizeSection (new_var);
/* line 555 "OverlapUpdate.puma" */
   tree_protocol ("SetOverlapUpdate, var = ", new_var);
/* line 557 "OverlapUpdate.puma" */
   ShiftSection (new_var, sv);
/* line 559 "OverlapUpdate.puma" */
   tree_protocol ("SetOverlapUpdate, shifted = ", new_var);
/* line 561 "OverlapUpdate.puma" */
   SetUpdate (new_var, sv);
  }
   return;
 }

  }
/* line 564 "OverlapUpdate.puma" */
  {
/* line 565 "OverlapUpdate.puma" */
   failure_protocol (MODULE, "SetOverlapUpdate", v);
  }
   return;

;
}

void SetShiftOverlapUpdate
# if defined __STDC__ | defined __cplusplus
(register tTree v, pshift sv)
# else
(v, sv)
 register tTree v;
 pshift sv;
# endif
{
  if (v->Kind == kINDEXED_VAR) {
/* line 570 "OverlapUpdate.puma" */
 {
  tTree new_var;
  {
/* line 574 "OverlapUpdate.puma" */
   new_var = CopyTree (v);
/* line 576 "OverlapUpdate.puma" */
   tree_protocol ("SetShiftOverlapUpdate, var = ", new_var);
/* line 578 "OverlapUpdate.puma" */
   ShiftSection1 (new_var, sv);
/* line 580 "OverlapUpdate.puma" */
   tree_protocol ("SetShiftOverlapUpdate, shifted = ", new_var);
/* line 582 "OverlapUpdate.puma" */
   SetUpdate (new_var, sv);
  }
   return;
 }

  }
/* line 585 "OverlapUpdate.puma" */
  {
/* line 586 "OverlapUpdate.puma" */
   failure_protocol (MODULE, "SetShiftOverlapUpdate", v);
  }
   return;

;
}

rbool IsOverlapUpdate
# if defined __STDC__ | defined __cplusplus
(pshift sv)
# else
(sv)
 pshift sv;
# endif
{
/* line 591 "OverlapUpdate.puma" */
  {
/* line 592 "OverlapUpdate.puma" */
   if (! ((IsAnUpdate (sv)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

static void ShiftSection
# if defined __STDC__ | defined __cplusplus
(register tTree v, pshift sv)
# else
(v, sv)
 register tTree v;
 pshift sv;
# endif
{
  if (v->Kind == kINDEXED_VAR) {
/* line 603 "OverlapUpdate.puma" */
  {
/* line 604 "OverlapUpdate.puma" */
   ShiftIndexes (v->INDEXED_VAR.IND_EXPS, sv, 0);
  }
   return;

  }
/* line 607 "OverlapUpdate.puma" */
  {
/* line 608 "OverlapUpdate.puma" */
   failure_protocol (MODULE, "ShiftSection", v);
  }
   return;

;
}

static void ShiftIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, pshift sv, register int pos)
# else
(indexes, sv, pos)
 register tTree indexes;
 pshift sv;
 register int pos;
# endif
{
 yyRecursion:
  if (indexes->Kind == kBTE_EMPTY) {
/* line 614 "OverlapUpdate.puma" */
   return;

  }
  if (indexes->Kind == kBTE_LIST) {
/* line 617 "OverlapUpdate.puma" */
  {
/* line 619 "OverlapUpdate.puma" */
 indexes->BTE_LIST.Elem = AddConstant (indexes->BTE_LIST.Elem, sv->shift_pos[pos]); 
/* line 621 "OverlapUpdate.puma" */
   indexes = indexes->BTE_LIST.Next;
   pos = pos + 1;
   goto yyRecursion;
  }

  }
/* line 624 "OverlapUpdate.puma" */
  {
/* line 625 "OverlapUpdate.puma" */
   failure_protocol (MODULE, "ShiftIndexes", indexes);
  }
   return;

;
}

static void ShiftSection1
# if defined __STDC__ | defined __cplusplus
(register tTree v, pshift sv)
# else
(v, sv)
 register tTree v;
 pshift sv;
# endif
{
  if (v->Kind == kINDEXED_VAR) {
/* line 638 "OverlapUpdate.puma" */
  {
/* line 639 "OverlapUpdate.puma" */
   ShiftIndexes1 (v->INDEXED_VAR.IND_EXPS, sv, 0);
  }
   return;

  }
/* line 642 "OverlapUpdate.puma" */
  {
/* line 643 "OverlapUpdate.puma" */
   failure_protocol (MODULE, "ShiftSection1", v);
  }
   return;

;
}

static void ShiftIndexes1
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, pshift sv, register int pos)
# else
(indexes, sv, pos)
 register tTree indexes;
 pshift sv;
 register int pos;
# endif
{
 yyRecursion:
  if (indexes->Kind == kBTE_EMPTY) {
/* line 649 "OverlapUpdate.puma" */
   return;

  }
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 652 "OverlapUpdate.puma" */
 {
  int shift;
  {
/* line 656 "OverlapUpdate.puma" */
 shift = sv->shift_pos[pos]; 
/* line 658 "OverlapUpdate.puma" */
   if (! ((shift > 0))) goto yyL2;
  {
/* line 660 "OverlapUpdate.puma" */
 indexes->BTE_LIST.Elem->SLICE_EXP.STOP = AddConstant (indexes->BTE_LIST.Elem->SLICE_EXP.STOP, shift); 
/* line 662 "OverlapUpdate.puma" */
   indexes = indexes->BTE_LIST.Next;
   pos = pos + 1;
   goto yyRecursion;
  }
  }
 }
yyL2:;

/* line 665 "OverlapUpdate.puma" */
 {
  int shift;
  {
/* line 669 "OverlapUpdate.puma" */
 shift = sv->shift_pos[pos]; 
/* line 671 "OverlapUpdate.puma" */
   if (! ((shift < 0))) goto yyL3;
  {
/* line 673 "OverlapUpdate.puma" */
 indexes->BTE_LIST.Elem->SLICE_EXP.FIRST = AddConstant (indexes->BTE_LIST.Elem->SLICE_EXP.FIRST, shift); 
/* line 675 "OverlapUpdate.puma" */
   indexes = indexes->BTE_LIST.Next;
   pos = pos + 1;
   goto yyRecursion;
  }
  }
 }
yyL3:;

  }
/* line 678 "OverlapUpdate.puma" */
  {
/* line 680 "OverlapUpdate.puma" */
 indexes->BTE_LIST.Elem = AddConstant (indexes->BTE_LIST.Elem, sv->shift_pos[pos]); 
/* line 682 "OverlapUpdate.puma" */
   indexes = indexes->BTE_LIST.Next;
   pos = pos + 1;
   goto yyRecursion;
  }

  }
/* line 685 "OverlapUpdate.puma" */
  {
/* line 686 "OverlapUpdate.puma" */
   failure_protocol (MODULE, "ShiftIndexes", indexes);
  }
   return;

;
}

static void NormalizeSection
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
 yyRecursion:
  if (exp->Kind == kINDEXED_VAR) {
/* line 702 "OverlapUpdate.puma" */
  {
/* line 704 "OverlapUpdate.puma" */
   NormalizeSection (exp->INDEXED_VAR.IND_EXPS);
/* line 705 "OverlapUpdate.puma" */
   MakeFullShape (exp);
  }
   return;

  }
  if (exp->Kind == kBTE_LIST) {
/* line 708 "OverlapUpdate.puma" */
  {
/* line 709 "OverlapUpdate.puma" */
   NormalizeSection (exp->BTE_LIST.Elem);
/* line 710 "OverlapUpdate.puma" */
   exp = exp->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (exp->Kind == kSLICE_EXP) {
/* line 713 "OverlapUpdate.puma" */
 {
  rbool found;
  int val;
  {
/* line 718 "OverlapUpdate.puma" */
   SliceIncrement (exp, & found, & val);
/* line 720 "OverlapUpdate.puma" */
 if (!found)
 
        { exp->SLICE_EXP.FIRST  = mDUMMY_EXP();
          exp->SLICE_EXP.STOP  = mDUMMY_EXP();
          exp->SLICE_EXP.INC = mDUMMY_EXP();
        }

      else if (val < 0)

        { tTree h;
          h   = exp->SLICE_EXP.FIRST;
          exp->SLICE_EXP.FIRST  = exp->SLICE_EXP.STOP;
          exp->SLICE_EXP.STOP  = h;
          exp->SLICE_EXP.INC = MinusExpression (exp->SLICE_EXP.INC);
        }
    
  }
   return;
 }

  }
;
}

static rbool EqualSections
# if defined __STDC__ | defined __cplusplus
(register tTree v1, register tTree v2)
# else
(v1, v2)
 register tTree v1;
 register tTree v2;
# endif
{
  if (v1->Kind == kINDEXED_VAR) {
  if (v2->Kind == kINDEXED_VAR) {
/* line 748 "OverlapUpdate.puma" */
  {
/* line 749 "OverlapUpdate.puma" */
   if (! ((TreeVarName (v1->INDEXED_VAR.IND_VAR) == TreeVarName (v2->INDEXED_VAR.IND_VAR)))) goto yyL1;
  {
/* line 750 "OverlapUpdate.puma" */
   if (! ((EqualIndexes (v1->INDEXED_VAR.IND_EXPS, v2->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static rbool IsSubSection
# if defined __STDC__ | defined __cplusplus
(register tTree v1, register tTree v2)
# else
(v1, v2)
 register tTree v1;
 register tTree v2;
# endif
{
  if (v1->Kind == kINDEXED_VAR) {
  if (v2->Kind == kINDEXED_VAR) {
/* line 763 "OverlapUpdate.puma" */
  {
/* line 764 "OverlapUpdate.puma" */
   if (! ((TreeVarName (v1->INDEXED_VAR.IND_VAR) == TreeVarName (v2->INDEXED_VAR.IND_VAR)))) goto yyL1;
  {
/* line 765 "OverlapUpdate.puma" */
   if (! ((SubIndexes (v1->INDEXED_VAR.IND_EXPS, v2->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static rbool SubIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes1, register tTree indexes2)
# else
(indexes1, indexes2)
 register tTree indexes1;
 register tTree indexes2;
# endif
{
  if (indexes1->Kind == kBTE_LIST) {
  if (indexes2->Kind == kBTE_LIST) {
/* line 770 "OverlapUpdate.puma" */
  {
/* line 771 "OverlapUpdate.puma" */
   if (! ((SubExpression (indexes1->BTE_LIST.Elem, indexes2->BTE_LIST.Elem)))) goto yyL1;
  {
/* line 772 "OverlapUpdate.puma" */
   if (! ((SubIndexes (indexes1->BTE_LIST.Next, indexes2->BTE_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  if (indexes1->Kind == kBTE_EMPTY) {
  if (indexes2->Kind == kBTE_EMPTY) {
/* line 775 "OverlapUpdate.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static rbool SubExpression
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2)
# else
(e1, e2)
 register tTree e1;
 register tTree e2;
# endif
{
  if (e1->Kind == kSLICE_EXP) {
  if (e2->Kind == kSLICE_EXP) {
/* line 780 "OverlapUpdate.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 784 "OverlapUpdate.puma" */
   CommonSliceIncrement (e1, e2, & yyV1, & yyV2);
/* line 786 "OverlapUpdate.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 787 "OverlapUpdate.puma" */
   if (! ((yyV2 > 0))) goto yyL1;
  {
/* line 789 "OverlapUpdate.puma" */
   if (! ((ExpLE (e2->SLICE_EXP.FIRST, e1->SLICE_EXP.FIRST)))) goto yyL1;
  {
/* line 790 "OverlapUpdate.puma" */
   if (! ((ExpLE (e1->SLICE_EXP.STOP, e2->SLICE_EXP.STOP)))) goto yyL1;
  }
  }
  }
  }
   return rtrue;
 }
yyL1:;

/* line 793 "OverlapUpdate.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 797 "OverlapUpdate.puma" */
   CommonSliceIncrement (e1, e2, & yyV1, & yyV2);
/* line 799 "OverlapUpdate.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 800 "OverlapUpdate.puma" */
   if (! ((yyV2 < 0))) goto yyL2;
  {
/* line 802 "OverlapUpdate.puma" */
   if (! ((ExpLE (e1->SLICE_EXP.FIRST, e2->SLICE_EXP.FIRST)))) goto yyL2;
  {
/* line 803 "OverlapUpdate.puma" */
   if (! ((ExpLE (e2->SLICE_EXP.STOP, e1->SLICE_EXP.STOP)))) goto yyL2;
  }
  }
  }
  }
   return rtrue;
 }
yyL2:;

  }
  }
  if (e2->Kind == kSLICE_EXP) {
/* line 808 "OverlapUpdate.puma" */
  {
/* line 809 "OverlapUpdate.puma" */
   if (! ((IsSimpleExpression (e1)))) goto yyL3;
  {
/* line 810 "OverlapUpdate.puma" */
   if (! ((ExpLE (e2->SLICE_EXP.FIRST, e1)))) goto yyL3;
  {
/* line 811 "OverlapUpdate.puma" */
   if (! ((ExpLE (e1, e2->SLICE_EXP.STOP)))) goto yyL3;
  }
  }
  }
   return rtrue;
yyL3:;

  }
/* line 814 "OverlapUpdate.puma" */
  {
/* line 815 "OverlapUpdate.puma" */
   if (! ((EqualExpression (e1, e2)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  return rfalse;
}

static rbool IsSimpleExpression
# if defined __STDC__ | defined __cplusplus
(register tTree e)
# else
(e)
 register tTree e;
# endif
{
  if (e->Kind == kSLICE_EXP) {
/* line 820 "OverlapUpdate.puma" */
  {
/* line 821 "OverlapUpdate.puma" */
   return rfalse;
  }

  }
/* line 824 "OverlapUpdate.puma" */
   return rtrue;

}

static rbool ExpLE
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2)
# else
(e1, e2)
 register tTree e1;
 register tTree e2;
# endif
{
/* line 829 "OverlapUpdate.puma" */
 {
  rbool found;
  int val;
  {
/* line 834 "OverlapUpdate.puma" */
   GetConstDifference (e1, e2, & found, & val);
/* line 835 "OverlapUpdate.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 836 "OverlapUpdate.puma" */
   if (! ((val <= 0))) goto yyL1;
  }
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static void CommonSliceIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree slice1, register tTree slice2, register rbool * yyP2, register int * yyP1)
# else
(slice1, slice2, yyP2, yyP1)
 register tTree slice1;
 register tTree slice2;
 register rbool * yyP2;
 register int * yyP1;
# endif
{
/* line 841 "OverlapUpdate.puma" */
 {
  rbool found;
  int val1;
  int val2;
  {
/* line 847 "OverlapUpdate.puma" */
   SliceIncrement (slice1, & found, & val1);
/* line 848 "OverlapUpdate.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 849 "OverlapUpdate.puma" */
   SliceIncrement (slice2, & found, & val2);
/* line 850 "OverlapUpdate.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 851 "OverlapUpdate.puma" */
   if (! ((val1 == val2))) goto yyL1;
  }
  }
  }
   * yyP2 = found;
   * yyP1 = val1;
   return;
 }
yyL1:;

/* line 854 "OverlapUpdate.puma" */
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

;
}

static tTree UnionSection
# if defined __STDC__ | defined __cplusplus
(register tTree v1, register tTree v2)
# else
(v1, v2)
 register tTree v1;
 register tTree v2;
# endif
{
  if (v1->Kind == kINDEXED_VAR) {
  if (v2->Kind == kINDEXED_VAR) {
/* line 873 "OverlapUpdate.puma" */
  {
/* line 875 "OverlapUpdate.puma" */
   if (! ((TreeVarName (v1) == TreeVarName (v2)))) goto yyL1;
  {
/* line 877 "OverlapUpdate.puma" */
   UnionIndexes (v1->INDEXED_VAR.IND_EXPS, v2->INDEXED_VAR.IND_EXPS);
  }
  }
   return MakeFullShape (v1);
yyL1:;

  }
  }
/* line 882 "OverlapUpdate.puma" */
  {
/* line 883 "OverlapUpdate.puma" */
   failure2_protocol (MODULE, "UnionSection", v1, v2);
  }
   return NoTree;

}

static void UnionIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes1, register tTree indexes2)
# else
(indexes1, indexes2)
 register tTree indexes1;
 register tTree indexes2;
# endif
{
 yyRecursion:
  if (indexes1->Kind == kBTE_LIST) {
  if (indexes2->Kind == kBTE_LIST) {
/* line 895 "OverlapUpdate.puma" */
  {
/* line 897 "OverlapUpdate.puma" */
 indexes1->BTE_LIST.Elem = UnionSlices (indexes1->BTE_LIST.Elem, indexes2->BTE_LIST.Elem); 
/* line 898 "OverlapUpdate.puma" */
   indexes1 = indexes1->BTE_LIST.Next;
   indexes2 = indexes2->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (indexes1->Kind == kBTE_EMPTY) {
  if (indexes2->Kind == kBTE_EMPTY) {
/* line 901 "OverlapUpdate.puma" */
   return;

  }
  }
/* line 904 "OverlapUpdate.puma" */
  {
/* line 905 "OverlapUpdate.puma" */
   failure2_protocol (MODULE, "UnionIndexes", indexes1, indexes2);
  }
   return;

;
}

static tTree UnionSlices
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2)
# else
(e1, e2)
 register tTree e1;
 register tTree e2;
# endif
{
/* line 916 "OverlapUpdate.puma" */
  {
/* line 917 "OverlapUpdate.puma" */
   if (! ((EqualExpression (e1, e2)))) goto yyL1;
  }
   return e1;
yyL1:;

  if (e1->Kind == kSLICE_EXP) {
  if (e2->Kind == kSLICE_EXP) {
/* line 921 "OverlapUpdate.puma" */
  {
/* line 923 "OverlapUpdate.puma" */
   if (! ((ExpLE (e1, e2)))) goto yyL2;
  {
/* line 924 "OverlapUpdate.puma" */
 e1->SLICE_EXP.STOP = e2->SLICE_EXP.STOP; 
  }
  }
   return e1;
yyL2:;

/* line 928 "OverlapUpdate.puma" */
  {
/* line 930 "OverlapUpdate.puma" */
   if (! ((ExpLE (e2, e1)))) goto yyL3;
  {
/* line 931 "OverlapUpdate.puma" */
 e1->SLICE_EXP.FIRST = e2->SLICE_EXP.FIRST; 
  }
  }
   return e1;
yyL3:;

  }
  }
/* line 935 "OverlapUpdate.puma" */
  {
/* line 936 "OverlapUpdate.puma" */
   if (! ((ExpLE (e1, e2)))) goto yyL4;
  }
   return mSLICE_EXP (e1, e2, mDUMMY_EXP ());
yyL4:;

/* line 940 "OverlapUpdate.puma" */
  {
/* line 941 "OverlapUpdate.puma" */
   if (! ((ExpLE (e2, e1)))) goto yyL5;
  }
   return mSLICE_EXP (e2, e1, mDUMMY_EXP ());
yyL5:;

/* line 947 "OverlapUpdate.puma" */
   return mSLICE_EXP (mDUMMY_EXP (), mDUMMY_EXP (), mDUMMY_EXP ());

}

static tTree MakeOverlapReset
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 961 "OverlapUpdate.puma" */
 {
  tTree reset;
  {
/* line 965 "OverlapUpdate.puma" */
 reset = mBTE_EMPTY ();
     reset = mREG_SHADOW_GET (CopyTree (var->INDEXED_VAR.IND_VAR), reset);
     reset = mACF_BASIC (reset);
   
  }
   return reset;
 }

  }
/* line 972 "OverlapUpdate.puma" */
  {
/* line 973 "OverlapUpdate.puma" */
   failure_protocol (MODULE, "MakeOverlapReset", var);
  }
   return NoTree;

}

void VectorizeOverlapUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree id, register tTree slice)
# else
(id, slice)
 register tTree id;
 register tTree slice;
# endif
{
/* line 990 "OverlapUpdate.puma" */
 {
  int i;
  {
/* line 996 "OverlapUpdate.puma" */
 for (i=0; i<UpdateCounter; i++)

       { VectorizeVar (all_updates[i].var, id, slice);
         NormalizeSection (all_updates[i].var);
       }

   
  }
   return;
 }

;
}

void BeginOverlapUpdate ARGS ((void))
{
}

void CloseOverlapUpdate ARGS ((void))
{
}
