# include "Optimization.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 21 "Optimization.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Traverse.h"
# include "Fusion.h"
# include "Interchange.h"

# define MODULE "Optimization"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyOptimization.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Optimization_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Optimization, routine %s failed\n",
  yyFunction);
 Optimization_Exit ();
}

void Optimization ARGS ((tTree t));
static void ApplyOptimization ARGS ((tTree t));
static rbool StopOptimization ARGS ((tTree t));
static void OptimizeStmtList ARGS ((tTree stats, int no_opt));
static void OptimizeStmt ARGS ((tTree t));
static void LoopInterchanging ARGS ((tTree t));

void Optimization
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
/* line 45 "Optimization.puma" */
  {
/* line 47 "Optimization.puma" */
   TraverseAST (t, StopOptimization, ApplyOptimization);
  }
   return;

  }
;
}

static void ApplyOptimization
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 58 "Optimization.puma" */
  {
/* line 60 "Optimization.puma" */
   if (! ((optimization == 0))) goto yyL1;
  }
   return;
yyL1:;

/* line 63 "Optimization.puma" */
  {
/* line 65 "Optimization.puma" */
   OptimizeStmtList (t->BODY_NODE.STATS, 0);
/* line 66 "Optimization.puma" */
   TraverseAST (t->BODY_NODE.INTERNALS, StopOptimization, ApplyOptimization);
  }
   return;

  }
;
}

static rbool StopOptimization
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 71 "Optimization.puma" */
   return rtrue;

  }
  return rfalse;
}

static void OptimizeStmtList
# if defined __STDC__ | defined __cplusplus
(register tTree stats, register int no_opt)
# else
(stats, no_opt)
 register tTree stats;
 register int no_opt;
# endif
{
 yyRecursion:
  if (stats->Kind == kACF_EMPTY) {
/* line 82 "Optimization.puma" */
   return;

  }
  if (stats->Kind == kACF_LIST) {
  if (stats->ACF_LIST.Next->Kind == kACF_LIST) {
/* line 85 "Optimization.puma" */
  {
/* line 87 "Optimization.puma" */
 if (no_opt < 1) OptimizeStmt (stats->ACF_LIST.Elem); 
/* line 88 "Optimization.puma" */
 if (no_opt < 2) OptimizeStmt (stats->ACF_LIST.Next->ACF_LIST.Elem); 
/* line 90 "Optimization.puma" */
   if (! ((CanBeFused (stats->ACF_LIST.Elem, stats->ACF_LIST.Next->ACF_LIST.Elem)))) goto yyL2;
  {
/* line 92 "Optimization.puma" */
 print_protocol ("fusion of statements");
     tree_protocol ("stmt1 :\n", stats->ACF_LIST.Elem);
     tree_protocol ("stmt2 :\n", stats->ACF_LIST.Next->ACF_LIST.Elem);
     stats->ACF_LIST.Elem = Fusion (stats->ACF_LIST.Elem, stats->ACF_LIST.Next->ACF_LIST.Elem);
     tree_protocol ("result :\n", stats->ACF_LIST.Elem);

     stats->ACF_LIST.Next = stats->ACF_LIST.Next->ACF_LIST.Next;
   
/* line 103 "Optimization.puma" */
   no_opt = 0;
   goto yyRecursion;
  }
  }
yyL2:;

/* line 106 "Optimization.puma" */
  {
/* line 110 "Optimization.puma" */
   stats = stats->ACF_LIST.Next;
   no_opt = 1;
   goto yyRecursion;
  }

  }
  if (stats->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 113 "Optimization.puma" */
  {
/* line 115 "Optimization.puma" */
 if (no_opt < 1) OptimizeStmt (stats->ACF_LIST.Elem); 
  }
   return;

  }
  }
/* line 118 "Optimization.puma" */
  {
/* line 120 "Optimization.puma" */
   failure_protocol (MODULE, "OptimizeStmtList", stats);
  }
   return;

;
}

static void OptimizeStmt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_WHILE) {
/* line 131 "Optimization.puma" */
  {
/* line 133 "Optimization.puma" */
   OptimizeStmtList (t->ACF_WHILE.WHILE_BODY, 0);
  }
   return;

  }
  if (t->Kind == kACF_IF) {
/* line 136 "Optimization.puma" */
  {
/* line 138 "Optimization.puma" */
   OptimizeStmtList (t->ACF_IF.THEN_PART, 0);
/* line 139 "Optimization.puma" */
   OptimizeStmtList (t->ACF_IF.ELSE_PART, 0);
  }
   return;

  }
  if (t->Kind == kACF_DO) {
/* line 142 "Optimization.puma" */
  {
/* line 144 "Optimization.puma" */
   OptimizeStmtList (t->ACF_DO.DO_BODY, 0);
/* line 145 "Optimization.puma" */
   LoopInterchanging (t);
  }
   return;

  }
  if (t->Kind == kACF_ON) {
/* line 148 "Optimization.puma" */
  {
/* line 150 "Optimization.puma" */
   OptimizeStmtList (t->ACF_ON.ON_BODY, 0);
  }
   return;

  }
;
}

static void LoopInterchanging
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 155 "Optimization.puma" */
  {
/* line 157 "Optimization.puma" */
   if (! ((CanBeInterchanged (t)))) goto yyL1;
  }
   return;
yyL1:;

;
}

void BeginOptimization ARGS ((void))
{
}

void CloseOptimization ARGS ((void))
{
}
