# include "Objects.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 81 "Objects.puma" */


# define MODULE "Objects"

# include "Idents.h"

# include "protocol.h"

# include "DefTable.h"
# include "TreeOps.h"
# include "Intrinsics.h"

# define DEFAULT_TREE_ATT        rfalse
# define DEFAULT_SEQUENCE_ATT    0
# define DEFAULT_SELECT_ATT      NoTree
# define DEFAULT_SHADOW_ATT      NoTree
# define DEFAULT_VAR_USE         mVarUse (0, 0, 0)
# define DEFAULT_MAPPING mMapping (0,kDEFAULT_SHARED,mMapDefault(),mRangeDefault())  



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyObjects.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Objects_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Objects, routine %s failed\n",
  yyFunction);
 Objects_Exit ();
}

tDefinitions MakeNewObject ARGS ((tTree decl, tDefinitions unit));
tDefinitions MakeResultObject ARGS ((tTree decl, tDefinitions unit));
rbool IsFuncObj ARGS ((tDefinitions v));
rbool IsModuleObj ARGS ((tDefinitions v));
rbool IsTypeObj ARGS ((tDefinitions v));
tTree GetObjDimension ARGS ((tDefinitions obj));
rbool IsVarCommon ARGS ((tDefinitions v));
tIdent GetCommonBlockId ARGS ((tDefinitions v));
rbool IsVarDummy ARGS ((tDefinitions v));
rbool IsVarResult ARGS ((tDefinitions v));
rbool IsVarParameter ARGS ((tDefinitions v));
rbool IsVarLocal ARGS ((tDefinitions v));
rbool IsVarTraced ARGS ((tDefinitions v));
rbool IsVarSave ARGS ((tDefinitions v));
rbool IsPointerObject ARGS ((tDefinitions v));
rbool IsTreeObject ARGS ((tDefinitions v));
rbool IsRaggedVarObject ARGS ((tDefinitions v));
rbool IsTemplate ARGS ((tDefinitions v));
rbool IsTopology ARGS ((tDefinitions v));
rbool IsOptional ARGS ((tDefinitions v));
rbool IsHPFDynamic ARGS ((tDefinitions obj));
rbool IsVarAllocatable ARGS ((tDefinitions v));
rbool IsVarAssumedShape ARGS ((tDefinitions v));
rbool IsVarAssumedSize ARGS ((tDefinitions v));
rbool IsVarExplicitShape ARGS ((tDefinitions v));
tTree GetVarShadow ARGS ((tDefinitions v));
int GetVarSharedKind ARGS ((tDefinitions v));
rbool IsUserCall ARGS ((tTree t));
rbool IsIntrCall ARGS ((tTree t));
rbool IsMainUnit ARGS ((tTree t));
rbool IsPureUnit ARGS ((tTree t));
static rbool IsElementalUnit ARGS ((tTree t));
rbool IsTaskUnit ARGS ((tTree t));
rbool IsLocalUnit ARGS ((tTree t));
rbool IsSerialUnit ARGS ((tTree t));
rbool IsF77Unit ARGS ((tTree t));
rbool IsStmtCall ARGS ((tTree t));
rbool IsStmtFunction ARGS ((tDefinitions obj));
rbool IsSerialCall ARGS ((tTree t));
static rbool IsSerialObj ARGS ((tDefinitions obj));
rbool IsLocalCall ARGS ((tTree t));
static rbool IsLocalObj ARGS ((tDefinitions obj));
rbool IsPureCall ARGS ((tTree t));
static rbool IsPureObj ARGS ((tDefinitions v));
rbool IsElementalCall ARGS ((tTree t));
static rbool IsElementalObj ARGS ((tDefinitions v));
rbool IsF77Call ARGS ((tTree t));
static rbool IsF77Obj ARGS ((tDefinitions obj));
tDefinitions GetFuncVarObj ARGS ((tDefinitions f));
void GetDummies ARGS ((tDefinitions obj, tTree * yyP2, tDefinitions * yyP1));
tDefinitions GetReferenceObject ARGS ((tDefinitions obj));
static tDefinitions ChooseReferenceObj ARGS ((tDefinitions interface_obj, tDefinitions global_obj));
rbool NoInterfaceObj ARGS ((tDefinitions v));
static rbool IsDummyRoutine ARGS ((tDefinitions v));
static rbool IsUserRoutine ARGS ((tDefinitions v));
rbool FunctionBecomesSubroutine ARGS ((tTree f));
rbool IsUsedObject ARGS ((tDefinitions obj, tDefinitions unit));
rbool IsGlobalVar ARGS ((tTree var, tDefinitions unit));

tDefinitions MakeNewObject
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions unit)
# else
(decl, unit)
 register tTree decl;
 register tDefinitions unit;
# endif
{

  switch (decl->Kind) {
  case kPROCESSORS_DECL:
/* line 115 "Objects.puma" */
 {
  register tDefinitions yyV1;
   yyALLOC (tDefinitions,Definitions_PoolFreePtr,Definitions_PoolStartPtr,
    Definitions_Alloc,yTopologyObject,MakeDefinitions,yyV1,kTopologyObject,Definitions_InitHead)
    yyV1->TopologyObject.Ident = decl->PROCESSORS_DECL.Ident;
    yyV1->TopologyObject.decl = mPROCESSORS_DECL (decl->PROCESSORS_DECL.Ident, decl->PROCESSORS_DECL.Line, decl->PROCESSORS_DECL.DIMENSIONS);
    yyV1->TopologyObject.private = Default;
    yyV1->TopologyObject.in = unit;
    yyV1->TopologyObject.rank = TreeListLength (decl->PROCESSORS_DECL.DIMENSIONS);
    yyV1->TopologyObject.target = NoTree;
    yyV1->TopologyObject.active = 0;
    yyV1->TopologyObject.defined = 0;
   return yyV1;
 }

  case kPROCESSOR_SUBSET:
/* line 127 "Objects.puma" */
 {
  register tDefinitions yyV1;
   yyALLOC (tDefinitions,Definitions_PoolFreePtr,Definitions_PoolStartPtr,
    Definitions_Alloc,yTopologyObject,MakeDefinitions,yyV1,kTopologyObject,Definitions_InitHead)
    yyV1->TopologyObject.Ident = decl->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Ident;
    yyV1->TopologyObject.decl = mSUB_PROCS_DECL (decl->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Ident, 0, decl->PROCESSOR_SUBSET.FULLTOP, decl->PROCESSOR_SUBSET.SUBSCRIPTS);
    yyV1->TopologyObject.private = Default;
    yyV1->TopologyObject.in = unit;
    yyV1->TopologyObject.rank = - 1;
    yyV1->TopologyObject.target = NoTree;
    yyV1->TopologyObject.active = 0;
    yyV1->TopologyObject.defined = 0;
   return yyV1;
 }

  case kTEMPLATE_DECL:
/* line 142 "Objects.puma" */
 {
  register tDefinitions yyV1;
   yyALLOC (tDefinitions,Definitions_PoolFreePtr,Definitions_PoolStartPtr,
    Definitions_Alloc,yTemplateObject,MakeDefinitions,yyV1,kTemplateObject,Definitions_InitHead)
    yyV1->TemplateObject.Ident = decl->TEMPLATE_DECL.Ident;
    yyV1->TemplateObject.decl = mTEMPLATE_DECL (decl->TEMPLATE_DECL.Ident, decl->TEMPLATE_DECL.Line, decl->TEMPLATE_DECL.DIMENSIONS);
    yyV1->TemplateObject.private = Default;
    yyV1->TemplateObject.in = unit;
    yyV1->TemplateObject.select = DEFAULT_SELECT_ATT;
    yyV1->TemplateObject.Dist = DEFAULT_MAPPING;
   return yyV1;
 }

  case kVAR_DECL:
/* line 153 "Objects.puma" */
 {
  register tDefinitions yyV1;
   yyALLOC (tDefinitions,Definitions_PoolFreePtr,Definitions_PoolStartPtr,
    Definitions_Alloc,yVarObject,MakeDefinitions,yyV1,kVarObject,Definitions_InitHead)
    yyV1->VarObject.Ident = decl->VAR_DECL.Ident;
    yyV1->VarObject.decl = mVAR_DECL (decl->VAR_DECL.Ident, decl->VAR_DECL.Line, decl->VAR_DECL.VAL);
    yyV1->VarObject.private = Default;
    yyV1->VarObject.in = unit;
    yyV1->VarObject.Kind = mVarLocal (0);
    yyV1->VarObject.arr_kind = arr_default;
    yyV1->VarObject.target = rfalse;
    yyV1->VarObject.trace = rfalse;
    yyV1->VarObject.tree = DEFAULT_TREE_ATT;
    yyV1->VarObject.dsp_kind = kDEFAULT_DSP;
    yyV1->VarObject.sequence = DEFAULT_SEQUENCE_ATT;
    yyV1->VarObject.select = DEFAULT_SELECT_ATT;
    yyV1->VarObject.shadow = DEFAULT_SHADOW_ATT;
    yyV1->VarObject.uses = DEFAULT_VAR_USE;
    yyV1->VarObject.Dist = DEFAULT_MAPPING;
   return yyV1;
 }

  case kVAR_PARAM_DECL:
/* line 174 "Objects.puma" */
 {
  register tDefinitions yyV1;
   yyALLOC (tDefinitions,Definitions_PoolFreePtr,Definitions_PoolStartPtr,
    Definitions_Alloc,yVarObject,MakeDefinitions,yyV1,kVarObject,Definitions_InitHead)
    yyV1->VarObject.Ident = decl->VAR_PARAM_DECL.Ident;
    yyV1->VarObject.decl = mVAR_PARAM_DECL (decl->VAR_PARAM_DECL.Ident, decl->VAR_PARAM_DECL.Line, decl->VAR_PARAM_DECL.VAL);
    yyV1->VarObject.private = Default;
    yyV1->VarObject.in = unit;
   {register tDefinitions yyW1;
    yyALLOC (tDefinitions,Definitions_PoolFreePtr,Definitions_PoolStartPtr,
     Definitions_Alloc,yVarDummy,MakeDefinitions,yyW1,kVarDummy,Definitions_InitHead)
    yyV1->VarObject.Kind = yyW1;
    yyW1->VarDummy.Intent = IntentNo;
    yyW1->VarDummy.function = NoTree;
    yyW1->VarDummy.optional = rfalse;
    yyW1->VarDummy.layout = 0;
    yyW1->VarDummy.pass_by = 0;
    yyW1->VarDummy.map_to = 0;
   }
    yyV1->VarObject.arr_kind = arr_default;
    yyV1->VarObject.target = rfalse;
    yyV1->VarObject.trace = rfalse;
    yyV1->VarObject.tree = DEFAULT_TREE_ATT;
    yyV1->VarObject.dsp_kind = kDEFAULT_DSP;
    yyV1->VarObject.sequence = DEFAULT_SEQUENCE_ATT;
    yyV1->VarObject.select = DEFAULT_SELECT_ATT;
    yyV1->VarObject.shadow = DEFAULT_SHADOW_ATT;
    yyV1->VarObject.uses = DEFAULT_VAR_USE;
    yyV1->VarObject.Dist = DEFAULT_MAPPING;
   return yyV1;
 }

  case kPROGRAM_DECL:
/* line 198 "Objects.puma" */
   return mProcObject (decl->PROGRAM_DECL.Ident, decl, Default, unit, UserRoutine, mENTRY_EMPTY ());

  case kPROC_DECL:
/* line 204 "Objects.puma" */
   return mProcObject (decl->PROC_DECL.Ident, decl, Default, unit, UserRoutine, mENTRY_EMPTY ());

  case kFUNC_DECL:
/* line 210 "Objects.puma" */
   return mFuncObject (decl->FUNC_DECL.Ident, decl, Default, unit, UserRoutine, mENTRY_EMPTY ());

  case kMODULE_DECL:
/* line 216 "Objects.puma" */
   return mModuleObject (decl->MODULE_DECL.Ident, decl, Default, unit, 0, mENTRY_EMPTY ());

  case kBLOCK_DATA_DECL:
/* line 221 "Objects.puma" */
   return mBlockObject (decl->BLOCK_DATA_DECL.Ident, decl, Default, unit, 0, mENTRY_EMPTY ());

  case kTYPE_DECL:
/* line 226 "Objects.puma" */
   return mTypeObject (decl->TYPE_DECL.Ident, decl, Default, unit, NoEntries);

  }

/* line 231 "Objects.puma" */
  {
/* line 233 "Objects.puma" */
   failure_protocol (MODULE, "MakeNewObject", decl);
  }
   return NoObject;

}

tDefinitions MakeResultObject
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions unit)
# else
(decl, unit)
 register tTree decl;
 register tDefinitions unit;
# endif
{
  if (decl->Kind == kFUNC_DECL) {
/* line 249 "Objects.puma" */
 {
  register tDefinitions yyV1;
   yyALLOC (tDefinitions,Definitions_PoolFreePtr,Definitions_PoolStartPtr,
    Definitions_Alloc,yVarObject,MakeDefinitions,yyV1,kVarObject,Definitions_InitHead)
    yyV1->VarObject.Ident = decl->FUNC_DECL.RESULT_ID;
    yyV1->VarObject.decl = mVAR_PARAM_DECL (decl->FUNC_DECL.RESULT_ID, decl->FUNC_DECL.Line, decl->FUNC_DECL.RESULT_TYPE);
    yyV1->VarObject.private = Default;
    yyV1->VarObject.in = unit;
   {register tDefinitions yyW1;
    yyALLOC (tDefinitions,Definitions_PoolFreePtr,Definitions_PoolStartPtr,
     Definitions_Alloc,yVarDummy,MakeDefinitions,yyW1,kVarDummy,Definitions_InitHead)
    yyV1->VarObject.Kind = yyW1;
    yyW1->VarDummy.Intent = IntentOut;
    yyW1->VarDummy.function = decl;
    yyW1->VarDummy.optional = rfalse;
    yyW1->VarDummy.layout = 0;
    yyW1->VarDummy.pass_by = 0;
    yyW1->VarDummy.map_to = 0;
   }
    yyV1->VarObject.arr_kind = arr_default;
    yyV1->VarObject.target = rfalse;
    yyV1->VarObject.trace = rfalse;
    yyV1->VarObject.tree = DEFAULT_TREE_ATT;
    yyV1->VarObject.dsp_kind = kDEFAULT_DSP;
    yyV1->VarObject.sequence = DEFAULT_SEQUENCE_ATT;
    begintTree (yyV1->VarObject.select)
    yyV1->VarObject.shadow = DEFAULT_SHADOW_ATT;
    yyV1->VarObject.uses = DEFAULT_VAR_USE;
    yyV1->VarObject.Dist = DEFAULT_MAPPING;
   return yyV1;
 }

  }
/* line 273 "Objects.puma" */
  {
/* line 275 "Objects.puma" */
   failure_protocol (MODULE, "MakeResultDef", decl);
  }
   return NoObject;

}

rbool IsFuncObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 287 "Objects.puma" */
  {
/* line 288 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 289 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
/* line 292 "Objects.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsModuleObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 297 "Objects.puma" */
  {
/* line 298 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 299 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kModuleObject) {
/* line 302 "Objects.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsTypeObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 307 "Objects.puma" */
  {
/* line 308 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 309 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kTypeObject) {
/* line 312 "Objects.puma" */
   return rtrue;

  }
  return rfalse;
}

tTree GetObjDimension
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 326 "Objects.puma" */
  {
/* line 328 "Objects.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
/* line 332 "Objects.puma" */
   return obj->TemplateObject.decl->TEMPLATE_DECL.DIMENSIONS;

  }
  }
  if (obj->Kind == kRaggedObject) {
  if (obj->RaggedObject.decl->Kind == kRAGGED_DECL) {
/* line 337 "Objects.puma" */
   return obj->RaggedObject.decl->RAGGED_DECL.DIMENSIONS;

  }
  }
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
  if (obj->VarObject.decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 342 "Objects.puma" */
   return obj->VarObject.decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES;

  }
  }
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (obj->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 347 "Objects.puma" */
   return obj->VarObject.decl->VAR_PARAM_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES;

  }
  }
  }
  if (obj->Kind == kTopologyObject) {
  if (obj->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
/* line 352 "Objects.puma" */
   return obj->TopologyObject.decl->PROCESSORS_DECL.DIMENSIONS;

  }
  }
/* line 357 "Objects.puma" */
   return NoTree;

}

rbool IsVarCommon
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarCommon) {
/* line 370 "Objects.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

tIdent GetCommonBlockId
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarCommon) {
/* line 375 "Objects.puma" */
   return v->VarObject.Kind->VarCommon.Block;

  }
  }
/* line 380 "Objects.puma" */
   return DefaultId ();

}

rbool IsVarDummy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
/* line 387 "Objects.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool IsVarResult
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
/* line 392 "Objects.puma" */
  {
/* line 393 "Objects.puma" */
   if (! ((v->VarObject.Kind->VarDummy.function == NoTree))) goto yyL1;
  {
/* line 394 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 397 "Objects.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool IsVarParameter
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarParameter) {
/* line 402 "Objects.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool IsVarLocal
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarLocal) {
/* line 407 "Objects.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool IsVarTraced
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 412 "Objects.puma" */
  {
/* line 414 "Objects.puma" */
   if (! ((v->VarObject.trace))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

rbool IsVarSave
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 419 "Objects.puma" */
  {
/* line 421 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 422 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarLocal) {
/* line 425 "Objects.puma" */
  {
/* line 427 "Objects.puma" */
   if (! ((v->VarObject.Kind->VarLocal.save))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

rbool IsPointerObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 432 "Objects.puma" */
  {
/* line 434 "Objects.puma" */
   if (! ((v->VarObject.arr_kind == arr_pointer))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

rbool IsTreeObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 439 "Objects.puma" */
  {
/* line 441 "Objects.puma" */
   if (! ((v->VarObject.tree))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (v->Kind == kRaggedObject) {
/* line 444 "Objects.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsRaggedVarObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 449 "Objects.puma" */
  {
/* line 451 "Objects.puma" */
   if (! ((v->VarObject.in == NoObject))) goto yyL1;
  {
/* line 452 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->VarObject.in->Kind == kRaggedObject) {
/* line 455 "Objects.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool IsTemplate
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kTemplateObject) {
/* line 460 "Objects.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsTopology
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kTopologyObject) {
/* line 465 "Objects.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsOptional
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
/* line 470 "Objects.puma" */
  {
/* line 471 "Objects.puma" */
   if (! ((v->VarObject.Kind->VarDummy.optional))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

rbool IsHPFDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 480 "Objects.puma" */
  {
/* line 481 "Objects.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 483 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
/* line 486 "Objects.puma" */
  {
/* line 488 "Objects.puma" */
   if (! ((obj->VarObject.Dist->Mapping.dynamic))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (obj->Kind == kTemplateObject) {
/* line 491 "Objects.puma" */
  {
/* line 493 "Objects.puma" */
   if (! ((obj->TemplateObject.Dist->Mapping.dynamic))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

rbool IsVarAllocatable
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 504 "Objects.puma" */
  {
/* line 506 "Objects.puma" */
   if (! ((v->VarObject.arr_kind == arr_pointer))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 509 "Objects.puma" */
  {
/* line 511 "Objects.puma" */
   if (! ((v->VarObject.arr_kind == arr_allocatable))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

rbool IsVarAssumedShape
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
/* line 522 "Objects.puma" */
  {
/* line 524 "Objects.puma" */
   if (! ((IsAssumedShape (GetObjDimension (v))))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

rbool IsVarAssumedSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
/* line 529 "Objects.puma" */
  {
/* line 531 "Objects.puma" */
   if (! ((IsAssumedSize (GetObjDimension (v))))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

rbool IsVarExplicitShape
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 536 "Objects.puma" */
  {
/* line 538 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 540 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kVarObject) {
/* line 543 "Objects.puma" */
  {
/* line 545 "Objects.puma" */
   if (! ((IsExplicitShape (GetObjDimension (v))))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

tTree GetVarShadow
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 556 "Objects.puma" */
   return v->VarObject.shadow;

  }
/* line 561 "Objects.puma" */
   return NoTree;

}

int GetVarSharedKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 573 "Objects.puma" */
  {
/* line 575 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  }
   return kNOT_SHARED;
yyL1:;

  if (v->Kind == kVarObject) {
/* line 580 "Objects.puma" */
   return v->VarObject.Dist->Mapping.shared;

  }
/* line 585 "Objects.puma" */
   return kNOT_SHARED;

}

rbool IsUserCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 601 "Objects.puma" */
  {
/* line 602 "Objects.puma" */
   if (! ((IsUserCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
/* line 605 "Objects.puma" */
  {
/* line 606 "Objects.puma" */
   if (! ((IsUserCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
/* line 609 "Objects.puma" */
  {
/* line 610 "Objects.puma" */
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
/* line 611 "Objects.puma" */
   return rfalse;
  }
  }
yyL3:;

  if (t->PROC_OBJ.Object->Kind == kFuncObject) {
  if (t->PROC_OBJ.Object->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 614 "Objects.puma" */
   return rtrue;

  }
  }
  if (t->PROC_OBJ.Object->Kind == kProcObject) {
  if (t->PROC_OBJ.Object->ProcObject.decl->Kind == kPROC_DECL) {
/* line 617 "Objects.puma" */
   return rtrue;

  }
  }
  }
  return rfalse;
}

rbool IsIntrCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 628 "Objects.puma" */
  {
/* line 629 "Objects.puma" */
   if (! ((IsIntrCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
/* line 632 "Objects.puma" */
  {
/* line 633 "Objects.puma" */
   if (! ((IsIntrCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
/* line 636 "Objects.puma" */
  {
/* line 637 "Objects.puma" */
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
/* line 638 "Objects.puma" */
   return rfalse;
  }
  }
yyL3:;

  if (t->PROC_OBJ.Object->Kind == kProcObject) {
  if (t->PROC_OBJ.Object->ProcObject.decl->Kind == kINTRINSIC_DECL) {
/* line 641 "Objects.puma" */
   return rtrue;

  }
  }
  if (t->PROC_OBJ.Object->Kind == kFuncObject) {
  if (t->PROC_OBJ.Object->FuncObject.decl->Kind == kINTRINSIC_DECL) {
/* line 644 "Objects.puma" */
   return rtrue;

  }
  }
  }
  return rfalse;
}

rbool IsMainUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROGRAM_DECL) {
/* line 655 "Objects.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsPureUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
/* line 660 "Objects.puma" */
  {
/* line 661 "Objects.puma" */
   if (! ((t->PROC_DECL.IsPure))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
/* line 664 "Objects.puma" */
  {
/* line 665 "Objects.puma" */
   if (! ((t->FUNC_DECL.IsPure))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static rbool IsElementalUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 670 "Objects.puma" */
  {
/* line 670 "Objects.puma" */
   return rfalse;
  }

}

rbool IsTaskUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
/* line 674 "Objects.puma" */
  {
/* line 676 "Objects.puma" */
   if (! ((t->PROC_DECL.HPFExtrinsic == IsIdent ("HPF_TASK")))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
/* line 679 "Objects.puma" */
  {
/* line 681 "Objects.puma" */
   if (! ((t->FUNC_DECL.HPFExtrinsic == IsIdent ("HPF_TASK")))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

rbool IsLocalUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
/* line 686 "Objects.puma" */
  {
/* line 688 "Objects.puma" */
   if (! (((t->PROC_DECL.HPFExtrinsic == IsIdent ("HPF_LOCAL")) || (t->PROC_DECL.HPFExtrinsic == IsIdent ("F77_LOCAL"))))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
/* line 691 "Objects.puma" */
  {
/* line 693 "Objects.puma" */
   if (! (((t->FUNC_DECL.HPFExtrinsic == IsIdent ("HPF_LOCAL")) || (t->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_LOCAL"))))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

rbool IsSerialUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
/* line 698 "Objects.puma" */
  {
/* line 700 "Objects.puma" */
   if (! (((t->PROC_DECL.HPFExtrinsic == IsIdent ("HPF_SERIAL")) || (t->PROC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
/* line 703 "Objects.puma" */
  {
/* line 705 "Objects.puma" */
   if (! (((t->FUNC_DECL.HPFExtrinsic == IsIdent ("HPF_SERIAL")) || (t->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

rbool IsF77Unit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
/* line 710 "Objects.puma" */
  {
/* line 712 "Objects.puma" */
   if (! (((t->PROC_DECL.HPFExtrinsic == IsIdent ("F77_LOCAL")) || (t->PROC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
/* line 715 "Objects.puma" */
  {
/* line 717 "Objects.puma" */
   if (! (((t->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_LOCAL")) || (t->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

rbool IsStmtCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 728 "Objects.puma" */
  {
/* line 729 "Objects.puma" */
   if (! ((IsStmtCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kPROC_OBJ) {
/* line 732 "Objects.puma" */
  {
/* line 733 "Objects.puma" */
   if (! ((IsStmtFunction (t->PROC_OBJ.Object)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

rbool IsStmtFunction
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 738 "Objects.puma" */
  {
/* line 739 "Objects.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 740 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 743 "Objects.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool IsSerialCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 764 "Objects.puma" */
  {
/* line 765 "Objects.puma" */
   if (! ((IsSerialCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
/* line 768 "Objects.puma" */
  {
/* line 769 "Objects.puma" */
   if (! ((IsSerialCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
/* line 772 "Objects.puma" */
  {
/* line 773 "Objects.puma" */
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
/* line 774 "Objects.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 777 "Objects.puma" */
  {
/* line 778 "Objects.puma" */
   if (! ((IsIntrCall (t)))) goto yyL4;
  {
/* line 779 "Objects.puma" */
   if (! ((IntrSerialRoutine (t->PROC_OBJ.Ident)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

/* line 782 "Objects.puma" */
  {
/* line 783 "Objects.puma" */
   if (! ((IsSerialObj (GetReferenceObject (t->PROC_OBJ.Object))))) goto yyL5;
  }
   return rtrue;
yyL5:;

  }
  return rfalse;
}

static rbool IsSerialObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 788 "Objects.puma" */
  {
/* line 789 "Objects.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 790 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 793 "Objects.puma" */
  {
/* line 795 "Objects.puma" */
   if (! (((obj->FuncObject.decl->FUNC_DECL.HPFExtrinsic == IsIdent ("HPF_SERIAL")) || (obj->FuncObject.decl->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kPROC_DECL) {
/* line 798 "Objects.puma" */
  {
/* line 800 "Objects.puma" */
   if (! (((obj->ProcObject.decl->PROC_DECL.HPFExtrinsic == IsIdent ("HPF_SERIAL")) || (obj->ProcObject.decl->PROC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  }
  return rfalse;
}

rbool IsLocalCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 820 "Objects.puma" */
  {
/* line 821 "Objects.puma" */
   if (! ((IsLocalCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
/* line 824 "Objects.puma" */
  {
/* line 825 "Objects.puma" */
   if (! ((IsLocalCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
/* line 828 "Objects.puma" */
  {
/* line 829 "Objects.puma" */
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
/* line 830 "Objects.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 833 "Objects.puma" */
  {
/* line 834 "Objects.puma" */
   if (! ((IsLocalObj (GetReferenceObject (t->PROC_OBJ.Object))))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static rbool IsLocalObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 839 "Objects.puma" */
  {
/* line 840 "Objects.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 841 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
/* line 844 "Objects.puma" */
  {
/* line 845 "Objects.puma" */
   if (! ((IsLocalUnit (obj->FuncObject.decl)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (obj->Kind == kProcObject) {
/* line 848 "Objects.puma" */
  {
/* line 849 "Objects.puma" */
   if (! ((IsLocalUnit (obj->ProcObject.decl)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

rbool IsPureCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 869 "Objects.puma" */
  {
/* line 870 "Objects.puma" */
   if (! ((IsPureCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
/* line 873 "Objects.puma" */
  {
/* line 874 "Objects.puma" */
   if (! ((IsPureCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
/* line 877 "Objects.puma" */
  {
/* line 878 "Objects.puma" */
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
/* line 879 "Objects.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 882 "Objects.puma" */
  {
/* line 883 "Objects.puma" */
   if (! ((IsIntrCall (t)))) goto yyL4;
  {
/* line 884 "Objects.puma" */
   if (! ((IntrPureRoutine (t->PROC_OBJ.Ident)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

/* line 887 "Objects.puma" */
  {
/* line 888 "Objects.puma" */
   if (! ((IsPureObj (GetReferenceObject (t->PROC_OBJ.Object))))) goto yyL5;
  }
   return rtrue;
yyL5:;

  }
  return rfalse;
}

static rbool IsPureObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 893 "Objects.puma" */
  {
/* line 894 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 895 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
/* line 898 "Objects.puma" */
  {
/* line 899 "Objects.puma" */
   if (! ((IsPureUnit (v->FuncObject.decl)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (v->Kind == kProcObject) {
/* line 902 "Objects.puma" */
  {
/* line 903 "Objects.puma" */
   if (! ((IsPureUnit (v->ProcObject.decl)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

rbool IsElementalCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 916 "Objects.puma" */
  {
/* line 918 "Objects.puma" */
   if (! ((IsElementalCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
/* line 921 "Objects.puma" */
  {
/* line 923 "Objects.puma" */
   if (! ((IsElementalCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
/* line 926 "Objects.puma" */
  {
/* line 928 "Objects.puma" */
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
/* line 929 "Objects.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 932 "Objects.puma" */
  {
/* line 934 "Objects.puma" */
   if (! ((IsIntrCall (t)))) goto yyL4;
  {
/* line 935 "Objects.puma" */
   if (! ((IntrFuncElemental (t->PROC_OBJ.Ident)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

/* line 938 "Objects.puma" */
  {
/* line 940 "Objects.puma" */
   if (! ((IsElementalObj (GetReferenceObject (t->PROC_OBJ.Object))))) goto yyL5;
  }
   return rtrue;
yyL5:;

  }
  return rfalse;
}

static rbool IsElementalObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 945 "Objects.puma" */
  {
/* line 946 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 947 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
/* line 950 "Objects.puma" */
  {
/* line 952 "Objects.puma" */
   if (! ((IsElementalUnit (v->FuncObject.decl)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (v->Kind == kProcObject) {
/* line 955 "Objects.puma" */
  {
/* line 957 "Objects.puma" */
   if (! ((IsElementalUnit (v->ProcObject.decl)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

rbool IsF77Call
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 972 "Objects.puma" */
  {
/* line 973 "Objects.puma" */
   if (! ((IsF77Call (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
/* line 976 "Objects.puma" */
  {
/* line 977 "Objects.puma" */
   if (! ((IsF77Call (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
/* line 980 "Objects.puma" */
  {
/* line 981 "Objects.puma" */
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
/* line 982 "Objects.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 985 "Objects.puma" */
  {
/* line 986 "Objects.puma" */
   if (! ((IsF77Obj (GetReferenceObject (t->PROC_OBJ.Object))))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static rbool IsF77Obj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 991 "Objects.puma" */
  {
/* line 992 "Objects.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 993 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
/* line 996 "Objects.puma" */
  {
/* line 997 "Objects.puma" */
   if (! ((IsF77Unit (obj->FuncObject.decl)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (obj->Kind == kProcObject) {
/* line 1000 "Objects.puma" */
  {
/* line 1001 "Objects.puma" */
   if (! ((IsF77Unit (obj->ProcObject.decl)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

tDefinitions GetFuncVarObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions f)
# else
(f)
 register tDefinitions f;
# endif
{
  if (f->Kind == kFuncObject) {
  if (f->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 1012 "Objects.puma" */
  {
/* line 1014 "Objects.puma" */
   if (! ((f->FuncObject.decl->FUNC_DECL.RESULT_ID != DefaultId ()))) goto yyL1;
  }
   return GetDeclEntry (f->FuncObject.decl->FUNC_DECL.RESULT_ID, f->FuncObject.Declarations);
yyL1:;

  }
  }
/* line 1019 "Objects.puma" */
  {
/* line 1020 "Objects.puma" */
   failure_protocol (MODULE, "GetFuncVarObj", f->Object.decl);
  }
   return NoObject;

}

void GetDummies
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree * yyP2, register tDefinitions * yyP1)
# else
(obj, yyP2, yyP1)
 register tDefinitions obj;
 register tTree * yyP2;
 register tDefinitions * yyP1;
# endif
{
/* line 1032 "Objects.puma" */
  {
/* line 1033 "Objects.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 1034 "Objects.puma" */
   failure_protocol (MODULE, "GetDummies: no object", NoTree);
  }
  }
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;
yyL1:;

  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kPROC_DECL) {
/* line 1037 "Objects.puma" */
   * yyP2 = obj->ProcObject.decl->PROC_DECL.FORMALS;
   * yyP1 = obj->ProcObject.Declarations;
   return;

  }
  if (obj->ProcObject.decl->Kind == kPROGRAM_DECL) {
/* line 1053 "Objects.puma" */
   * yyP2 = NoTree;
   * yyP1 = obj->ProcObject.Declarations;
   return;

  }
  if (obj->ProcObject.decl->Kind == kINTRINSIC_DECL) {
/* line 1057 "Objects.puma" */
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 1041 "Objects.puma" */
   * yyP2 = obj->FuncObject.decl->FUNC_DECL.FORMALS;
   * yyP1 = obj->FuncObject.Declarations;
   return;

  }
  if (obj->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 1047 "Objects.puma" */
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;

  }
  if (obj->FuncObject.decl->Kind == kINTRINSIC_DECL) {
/* line 1061 "Objects.puma" */
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;

  }
  }
/* line 1065 "Objects.puma" */
  {
/* line 1067 "Objects.puma" */
   obj_error_protocol ("could not get dummies for this object", obj);
/* line 1068 "Objects.puma" */
   failure_protocol (MODULE, "GetDummies", obj->Object.decl);
  }
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;

;
}

tDefinitions GetReferenceObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1081 "Objects.puma" */
  {
/* line 1083 "Objects.puma" */
   if (! ((obj == GetIntrinsicObject (obj->Object.Ident)))) goto yyL1;
  }
   return NoObject;
yyL1:;

/* line 1088 "Objects.puma" */
   return ChooseReferenceObj (obj, GetDeclEntry (obj->Object.Ident, GetUnitEntries ()));

}

static tDefinitions ChooseReferenceObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions interface_obj, register tDefinitions global_obj)
# else
(interface_obj, global_obj)
 register tDefinitions interface_obj;
 register tDefinitions global_obj;
# endif
{
/* line 1105 "Objects.puma" */
  {
/* line 1109 "Objects.puma" */
   if (! ((IsDummyRoutine (interface_obj)))) goto yyL1;
  {
/* line 1110 "Objects.puma" */
   if (! ((NoInterfaceObj (interface_obj)))) goto yyL1;
  }
  }
   return NoObject;
yyL1:;

/* line 1114 "Objects.puma" */
  {
/* line 1118 "Objects.puma" */
   if (! ((IsDummyRoutine (interface_obj)))) goto yyL2;
  }
   return interface_obj;
yyL2:;

/* line 1122 "Objects.puma" */
  {
/* line 1124 "Objects.puma" */
   if (! ((IsUserRoutine (global_obj)))) goto yyL3;
  }
   return global_obj;
yyL3:;

/* line 1128 "Objects.puma" */
  {
/* line 1130 "Objects.puma" */
   if (! ((NoInterfaceObj (interface_obj)))) goto yyL4;
  }
   return NoObject;
yyL4:;

/* line 1134 "Objects.puma" */
   return interface_obj;

}

rbool NoInterfaceObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 1151 "Objects.puma" */
  {
/* line 1153 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 1154 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kExternalObject) {
/* line 1157 "Objects.puma" */
   return rtrue;

  }
  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 1160 "Objects.puma" */
  {
/* line 1161 "Objects.puma" */
   if (! ((v->FuncObject.decl->FUNC_DECL.FUNC_BODY == NoTree))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  }
  if (v->Kind == kProcObject) {
  if (v->ProcObject.decl->Kind == kPROC_DECL) {
/* line 1164 "Objects.puma" */
  {
/* line 1165 "Objects.puma" */
   if (! ((v->ProcObject.decl->PROC_DECL.PROC_BODY == NoTree))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  }
  return rfalse;
}

static rbool IsDummyRoutine
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 1170 "Objects.puma" */
  {
/* line 1171 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 1172 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 1175 "Objects.puma" */
  {
/* line 1176 "Objects.puma" */
   if (! ((v->FuncObject.Kind == DummyRoutine))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  if (v->Kind == kProcObject) {
  if (v->ProcObject.decl->Kind == kPROC_DECL) {
/* line 1179 "Objects.puma" */
  {
/* line 1180 "Objects.puma" */
   if (! ((v->ProcObject.Kind == DummyRoutine))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  }
  return rfalse;
}

static rbool IsUserRoutine
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 1185 "Objects.puma" */
  {
/* line 1186 "Objects.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 1187 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 1190 "Objects.puma" */
   return rtrue;

  }
  }
  if (v->Kind == kProcObject) {
  if (v->ProcObject.decl->Kind == kPROC_DECL) {
/* line 1193 "Objects.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool FunctionBecomesSubroutine
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kPROC_OBJ) {
/* line 1206 "Objects.puma" */
  {
/* line 1211 "Objects.puma" */
   if (! ((IsIntrCall (f)))) goto yyL1;
  {
/* line 1212 "Objects.puma" */
   if (! ((IntrFuncDalib (f->PROC_OBJ.Ident)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 1215 "Objects.puma" */
  {
/* line 1217 "Objects.puma" */
   if (! ((IsUserCall (f)))) goto yyL2;
  {
/* line 1218 "Objects.puma" */
   if (! ((! IsF77Call (f)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

rbool IsUsedObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions unit)
# else
(obj, unit)
 register tDefinitions obj;
 register tDefinitions unit;
# endif
{
/* line 1231 "Objects.puma" */
  {
/* line 1233 "Objects.puma" */
   if (! ((unit == NoObject))) goto yyL1;
  {
/* line 1234 "Objects.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
/* line 1237 "Objects.puma" */
  {
/* line 1240 "Objects.puma" */
   if (! ((unit == obj))) goto yyL2;
  {
/* line 1241 "Objects.puma" */
   return rfalse;
  }
  }
yyL2:;

  }
/* line 1246 "Objects.puma" */
  {
/* line 1248 "Objects.puma" */
   if (! ((obj->Object.in == NoObject))) goto yyL3;
  {
/* line 1250 "Objects.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 1253 "Objects.puma" */
  {
/* line 1255 "Objects.puma" */
   if (! ((obj->Object.in != unit))) goto yyL4;
  }
   return rtrue;
yyL4:;

  return rfalse;
}

rbool IsGlobalVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions unit)
# else
(var, unit)
 register tTree var;
 register tDefinitions unit;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 1268 "Objects.puma" */
  {
/* line 1270 "Objects.puma" */
   if (! ((IsGlobalVar (var->INDEXED_VAR.IND_VAR, unit)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 1273 "Objects.puma" */
  {
/* line 1275 "Objects.puma" */
   if (! ((IsGlobalVar (var->SELECTED_VAR.SELEC_VAR, unit)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 1278 "Objects.puma" */
  {
/* line 1280 "Objects.puma" */
   if (! ((IsGlobalVar (var->SUBSTRING_VAR.IND_VAR, unit)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (var->Kind == kUSED_VAR) {
/* line 1283 "Objects.puma" */
  {
/* line 1285 "Objects.puma" */
   if (! ((IsGlobalVar (var->USED_VAR.VARNAME, unit)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  if (var->Kind == kLOOP_VAR) {
/* line 1288 "Objects.puma" */
  {
/* line 1290 "Objects.puma" */
   if (! ((IsGlobalVar (var->LOOP_VAR.LOOP_VARNAME, unit)))) goto yyL5;
  }
   return rtrue;
yyL5:;

  }
  if (var->Kind == kVAR_OBJ) {
/* line 1293 "Objects.puma" */
  {
/* line 1295 "Objects.puma" */
   if (! ((IsUsedObject (var->VAR_OBJ.Object, unit)))) goto yyL6;
  }
   return rtrue;
yyL6:;

  if (var->VAR_OBJ.Object->Kind == kVarObject) {
  if (var->VAR_OBJ.Object->VarObject.Kind->Kind == kVarCommon) {
/* line 1298 "Objects.puma" */
   return rtrue;

  }
  }
  }
  return rfalse;
}

void BeginObjects ARGS ((void))
{
}

void CloseObjects ARGS ((void))
{
}
