# include "Normalization.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 34 "Normalization.puma" */


# include "Idents.h"
# include "StringM.h"

# include "protocol.h"
# include "Nesting.h"

# include "DefTable.h"

# include "Objects.h"
# include "ArrayData.h"       /* SetActualOverlap                       */
# include "Shapes.h"          /* MakeFullShape, ...                     */

# include "Reaching.h"         /* reaching allocates */
# include "InitAllocate.h"     /* generate allocates */
# include "Inquiry.h"          /* translate inquirys */
# include "Traverse.h"         /* ReplaceAST         */
# include "Rank.h"

# include "MakeRagged.h"      

# include "FArguments.h"       /* IsPointerActual    */
# include "Distributions.h"    /* GetTopologyObj     */

# define MODULE "Normalization"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyNormalization.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Normalization_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Normalization, routine %s failed\n",
  yyFunction);
 Normalization_Exit ();
}

void Normalization ARGS ((tTree t));
static void NormalizationBody ARGS ((tTree body, tTree unit));
static tTree SortDeclarations ARGS ((tTree t));
static void TryMoveDeclaration ARGS ((tTree decl, rbool * yyP2, tTree * yyP1));
static tIdent GetTopologyId ARGS ((tDefinitions obj));
static void MoveDecl ARGS ((tIdent id, tTree decl));
static rbool FoundDeclaration ARGS ((tIdent id, tTree list));
static rbool IsDeclaration ARGS ((tIdent id, tTree decl));
static void NormalShape ARGS ((tTree body));
static tTree NormalShapeAST ARGS ((tTree t));
static rbool shape_pred ARGS ((tTree t));
static tTree shape_func ARGS ((tTree t));
static void MakeFullAllocParams ARGS ((tTree params));
static tTree MakeFullShapeFunc ARGS ((tTree t));
static void MakeFullShapeProc ARGS ((tTree t));
static void NormalNotFullParam ARGS ((tTree t));
static tTree MakeRaggedArrays ARGS ((tTree t));
static rbool ragged_pred ARGS ((tTree t));
static tTree ragged_func ARGS ((tTree t));

void Normalization
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 73 "Normalization.puma" */
  {
/* line 75 "Normalization.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 78 "Normalization.puma" */
   return;

  case kUNIT_LIST:
/* line 81 "Normalization.puma" */
  {
/* line 83 "Normalization.puma" */
   Normalization (t->UNIT_LIST.Elem);
/* line 84 "Normalization.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kPROGRAM_DECL:
/* line 87 "Normalization.puma" */
  {
/* line 89 "Normalization.puma" */
   NestOpenUnit (t);
/* line 90 "Normalization.puma" */
   NormalizationBody (t->PROGRAM_DECL.PROGRAM_BODY, t);
/* line 91 "Normalization.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 94 "Normalization.puma" */
  {
/* line 96 "Normalization.puma" */
   NestOpenUnit (t);
/* line 97 "Normalization.puma" */
   NormalizationBody (t->PROC_DECL.PROC_BODY, t);
/* line 98 "Normalization.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 101 "Normalization.puma" */
  {
/* line 103 "Normalization.puma" */
   NestOpenUnit (t);
/* line 104 "Normalization.puma" */
   NormalizationBody (t->FUNC_DECL.FUNC_BODY, t);
/* line 105 "Normalization.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 108 "Normalization.puma" */
  {
/* line 110 "Normalization.puma" */
   NestOpenUnit (t);
/* line 111 "Normalization.puma" */
   NormalizationBody (t->BLOCK_DATA_DECL.DATA_BODY, t);
/* line 112 "Normalization.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 115 "Normalization.puma" */
  {
/* line 117 "Normalization.puma" */
   NestOpenUnit (t);
/* line 118 "Normalization.puma" */
   NormalizationBody (t->MODULE_DECL.MODULE_BODY, t);
/* line 119 "Normalization.puma" */
   NestCloseUnit (t);
  }
   return;

  }

/* line 122 "Normalization.puma" */
  {
/* line 123 "Normalization.puma" */
   failure_protocol (MODULE, "Normalization", t);
  }
   return;

;
}

static void NormalizationBody
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree unit)
# else
(body, unit)
 register tTree body;
 register tTree unit;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 138 "Normalization.puma" */
  {
/* line 140 "Normalization.puma" */
 body->BODY_NODE.DECLS = SortDeclarations (body->BODY_NODE.DECLS); 
/* line 142 "Normalization.puma" */
 body->BODY_NODE.DECLS = MakeRaggedArrays (body->BODY_NODE.DECLS);
      body->BODY_NODE.STATS = MakeRaggedArrays (body->BODY_NODE.STATS);
    
/* line 146 "Normalization.puma" */
   ReachingAllocate (body);
/* line 150 "Normalization.puma" */
   NormalShape (body);
/* line 156 "Normalization.puma" */
   InitAllocate (body, unit);
/* line 158 "Normalization.puma" */
   Normalization (body->BODY_NODE.INTERNALS);
  }
   return;

  }
/* line 161 "Normalization.puma" */
  {
/* line 163 "Normalization.puma" */
   failure_protocol (MODULE, "NormalizationBody", body);
  }
   return;

;
}

static tTree SortDeclarations
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kDECL_EMPTY) {
/* line 181 "Normalization.puma" */
   return t;

  }
  if (t->Kind == kDECL_LIST) {
/* line 185 "Normalization.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  {
/* line 186 "Normalization.puma" */
   TryMoveDeclaration (t, & yyV1, & yyV2);
/* line 187 "Normalization.puma" */
   if (! ((yyV1))) goto yyL2;
  }
   t = yyV2;
   goto yyRecursion;
 }
yyL2:;

/* line 191 "Normalization.puma" */
  {
/* line 192 "Normalization.puma" */
 t->DECL_LIST.Next = SortDeclarations (t->DECL_LIST.Next); 
  }
   return t;

  }
 yyAbort ("SortDeclarations");
 { tTree yyDummy; return yyDummy; }
}

static void TryMoveDeclaration
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register rbool * yyP2, register tTree * yyP1)
# else
(decl, yyP2, yyP1)
 register tTree decl;
 register rbool * yyP2;
 register tTree * yyP1;
# endif
{
  if (decl->Kind == kDECL_LIST) {
  if (decl->DECL_LIST.Elem->Kind == kDISTRIBUTE_DECL) {
/* line 204 "Normalization.puma" */
  {
/* line 207 "Normalization.puma" */
   if (! ((FoundDeclaration (decl->DECL_LIST.Elem->DISTRIBUTE_DECL.Ident, decl->DECL_LIST.Next)))) goto yyL1;
  {
/* line 208 "Normalization.puma" */
   MoveDecl (decl->DECL_LIST.Elem->DISTRIBUTE_DECL.Ident, decl);
  }
  }
   * yyP2 = rtrue;
   * yyP1 = decl;
   return;
yyL1:;

  }
  if (decl->DECL_LIST.Elem->Kind == kTEMPLATE_DECL) {
/* line 213 "Normalization.puma" */
 {
  tDefinitions proc_obj;
  tIdent proc_id;
  {
/* line 219 "Normalization.puma" */
   proc_obj = GetTopologyObj (GetGlobalObject (decl->DECL_LIST.Elem->TEMPLATE_DECL.Ident));
/* line 221 "Normalization.puma" */
   proc_id = GetTopologyId (proc_obj);
/* line 223 "Normalization.puma" */
   if (! ((proc_id != DefaultId ()))) goto yyL2;
  {
/* line 225 "Normalization.puma" */
   if (! ((FoundDeclaration (proc_id, decl->DECL_LIST.Next)))) goto yyL2;
  {
/* line 226 "Normalization.puma" */
   MoveDecl (proc_id, decl);
  }
  }
  }
   * yyP2 = rtrue;
   * yyP1 = decl;
   return;
 }
yyL2:;

  }
  if (decl->DECL_LIST.Elem->Kind == kVAR_DECL) {
/* line 231 "Normalization.puma" */
 {
  tDefinitions proc_obj;
  tIdent proc_id;
  {
/* line 237 "Normalization.puma" */
   proc_obj = GetTopologyObj (GetGlobalObject (decl->DECL_LIST.Elem->VAR_DECL.Ident));
/* line 239 "Normalization.puma" */
   proc_id = GetTopologyId (proc_obj);
/* line 241 "Normalization.puma" */
   if (! ((proc_id != DefaultId ()))) goto yyL3;
  {
/* line 242 "Normalization.puma" */
   if (! ((FoundDeclaration (proc_id, decl->DECL_LIST.Next)))) goto yyL3;
  {
/* line 243 "Normalization.puma" */
   MoveDecl (proc_id, decl);
  }
  }
  }
   * yyP2 = rtrue;
   * yyP1 = decl;
   return;
 }
yyL3:;

/* line 257 "Normalization.puma" */
 {
  tDefinitions temp_obj;
  tIdent temp_id;
  {
/* line 263 "Normalization.puma" */
   temp_obj = GetTemplateObj (GetGlobalObject (decl->DECL_LIST.Elem->VAR_DECL.Ident));
/* line 264 "Normalization.puma" */
   temp_id = temp_obj->Object.Ident;
/* line 266 "Normalization.puma" */
   if (! (((temp_id != DefaultId ()) && (temp_id != decl->DECL_LIST.Elem->VAR_DECL.Ident)))) goto yyL5;
  {
/* line 267 "Normalization.puma" */
   if (! ((FoundDeclaration (temp_id, decl->DECL_LIST.Next)))) goto yyL5;
  {
/* line 268 "Normalization.puma" */
   MoveDecl (temp_id, decl);
  }
  }
  }
   * yyP2 = rtrue;
   * yyP1 = decl;
   return;
 }
yyL5:;

  }
  if (decl->DECL_LIST.Elem->Kind == kALIGN_DECL) {
/* line 248 "Normalization.puma" */
  {
/* line 251 "Normalization.puma" */
   if (! ((FoundDeclaration (decl->DECL_LIST.Elem->ALIGN_DECL.Ident, decl->DECL_LIST.Next)))) goto yyL4;
  {
/* line 252 "Normalization.puma" */
   MoveDecl (decl->DECL_LIST.Elem->ALIGN_DECL.Ident, decl);
  }
  }
   * yyP2 = rtrue;
   * yyP1 = decl;
   return;
yyL4:;

  }
  }
/* line 273 "Normalization.puma" */
   * yyP2 = rfalse;
   * yyP1 = decl;
   return;

;
}

static tIdent GetTopologyId
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 287 "Normalization.puma" */
  {
/* line 289 "Normalization.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return DefaultId ();
yyL1:;

  if (obj->Kind == kTopologyObject) {
/* line 294 "Normalization.puma" */
  {
/* line 296 "Normalization.puma" */
   if (! ((obj->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  }
   return obj->TopologyObject.Ident;
yyL2:;

  if (obj->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
/* line 301 "Normalization.puma" */
   return obj->TopologyObject.Ident;

  }
  if (obj->TopologyObject.decl->Kind == kSUB_PROCS_DECL) {
/* line 306 "Normalization.puma" */
   return obj->TopologyObject.decl->SUB_PROCS_DECL.TOP->TOP_OBJ.Ident;

  }
  }
/* line 311 "Normalization.puma" */
   return DefaultId ();

}

static void MoveDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree decl)
# else
(id, decl)
 register tIdent id;
 register tTree decl;
# endif
{
 yyRecursion:
  if (decl->Kind == kDECL_LIST) {
  if (decl->DECL_LIST.Next->Kind == kDECL_LIST) {
/* line 326 "Normalization.puma" */
 {
  tTree h;
  {
/* line 328 "Normalization.puma" */
   if (! ((IsDeclaration (id, decl->DECL_LIST.Next->DECL_LIST.Elem)))) goto yyL1;
  {
/* line 332 "Normalization.puma" */
 h = decl->DECL_LIST.Elem;
     decl->DECL_LIST.Elem = decl->DECL_LIST.Next->DECL_LIST.Elem;
     decl->DECL_LIST.Next->DECL_LIST.Elem = h;
   
  }
  }
   return;
 }
yyL1:;

/* line 338 "Normalization.puma" */
 {
  tTree h;
  {
/* line 342 "Normalization.puma" */
 h = decl->DECL_LIST.Elem;
     decl->DECL_LIST.Elem = decl->DECL_LIST.Next->DECL_LIST.Elem;
     decl->DECL_LIST.Next->DECL_LIST.Elem = h;
   
/* line 346 "Normalization.puma" */
   decl = decl->DECL_LIST.Next;
   goto yyRecursion;
  }
 }

  }
  }
/* line 349 "Normalization.puma" */
  {
/* line 350 "Normalization.puma" */
   failure_protocol (MODULE, "MoveDecl", decl);
  }
   return;

;
}

static rbool FoundDeclaration
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree list)
# else
(id, list)
 register tIdent id;
 register tTree list;
# endif
{
  if (list->Kind == kDECL_LIST) {
/* line 363 "Normalization.puma" */
  {
/* line 364 "Normalization.puma" */
   if (! ((IsDeclaration (id, list->DECL_LIST.Elem)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 367 "Normalization.puma" */
  {
/* line 368 "Normalization.puma" */
   if (! ((FoundDeclaration (id, list->DECL_LIST.Next)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static rbool IsDeclaration
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree decl)
# else
(id, decl)
 register tIdent id;
 register tTree decl;
# endif
{
  if (decl->Kind == kTEMPLATE_DECL) {
/* line 379 "Normalization.puma" */
  {
/* line 380 "Normalization.puma" */
   if (! ((id == decl->TEMPLATE_DECL.Ident))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (decl->Kind == kPROCESSORS_DECL) {
/* line 383 "Normalization.puma" */
  {
/* line 384 "Normalization.puma" */
   if (! ((id == decl->PROCESSORS_DECL.Ident))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (decl->Kind == kVAR_DECL) {
/* line 387 "Normalization.puma" */
  {
/* line 388 "Normalization.puma" */
   if (! ((id == decl->VAR_DECL.Ident))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static void NormalShape
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 409 "Normalization.puma" */
  {
/* line 411 "Normalization.puma" */
 body->BODY_NODE.DECLS = NormalShapeAST (body->BODY_NODE.DECLS); 
      body->BODY_NODE.STATS = NormalShapeAST (body->BODY_NODE.STATS); 
    
  }
   return;

  }
/* line 416 "Normalization.puma" */
  {
/* line 418 "Normalization.puma" */
   failure_protocol (MODULE, "NormalShape", body);
  }
   return;

;
}

static tTree NormalShapeAST
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 423 "Normalization.puma" */
   return ReplaceAST (t, shape_pred, shape_func);

}

static rbool shape_pred
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kINDEXED_VAR:
/* line 443 "Normalization.puma" */
   return rtrue;

  case kSELECTED_VAR:
/* line 446 "Normalization.puma" */
   return rtrue;

  case kCALL_STMT:
/* line 449 "Normalization.puma" */
   return rtrue;

  case kIO_STMT:
/* line 452 "Normalization.puma" */
   return rtrue;

  case kFUNC_CALL_EXP:
/* line 455 "Normalization.puma" */
   return rtrue;

  case kDEALLOCATE_STMT:
/* line 458 "Normalization.puma" */
   return rtrue;

  case kALLOCATE_STMT:
/* line 461 "Normalization.puma" */
   return rtrue;

  case kCREATE_DSP_STMT:
/* line 464 "Normalization.puma" */
   return rtrue;

  case kINHERIT_DSP_STMT:
/* line 467 "Normalization.puma" */
   return rtrue;

  case kFREE_DSP_STMT:
/* line 470 "Normalization.puma" */
   return rtrue;

  case kPTR_ASSIGN_STMT:
/* line 473 "Normalization.puma" */
   return rtrue;

  }

/* line 476 "Normalization.puma" */
  {
/* line 477 "Normalization.puma" */
   return rfalse;
  }

}

static tTree shape_func
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kIO_STMT:
/* line 490 "Normalization.puma" */
  {
/* line 492 "Normalization.puma" */
   MakeFullShapeProc (t);
  }
   return t;

  case kCALL_STMT:
/* line 497 "Normalization.puma" */
  {
/* line 499 "Normalization.puma" */
   MakeFullShapeProc (t);
  }
   return t;

  case kUSED_VAR:
/* line 504 "Normalization.puma" */
 {
  tTree new;
  {
/* line 508 "Normalization.puma" */
   if (! ((TreeRank (t) > 0))) goto yyL3;
  {
/* line 510 "Normalization.puma" */
   new = MakeFullShape (t);
  }
  }
   return new;
 }
yyL3:;

  break;
  case kSELECTED_VAR:
/* line 515 "Normalization.puma" */
  {
/* line 517 "Normalization.puma" */
   if (! ((VarRank (t->SELECTED_VAR.SELECTOR->REC_COMP.Object) == 0))) goto yyL4;
  {
/* line 519 "Normalization.puma" */
 t->SELECTED_VAR.SELEC_VAR = NormalShapeAST (t->SELECTED_VAR.SELEC_VAR); 
  }
  }
   return t;
yyL4:;

/* line 524 "Normalization.puma" */
 {
  tTree new;
  {
/* line 528 "Normalization.puma" */
   tree_protocol ("make full shape of selected var : ", t);
/* line 530 "Normalization.puma" */
 t->SELECTED_VAR.SELEC_VAR = NormalShapeAST (t->SELECTED_VAR.SELEC_VAR); 
/* line 532 "Normalization.puma" */
   new = MakeFullShape (t);
/* line 534 "Normalization.puma" */
   tree_protocol ("full shape of selected var  now : ", new);
  }
   return new;
 }

  case kINDEXED_VAR:
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 539 "Normalization.puma" */
 {
  tTree new;
  {
/* line 543 "Normalization.puma" */
   tree_protocol ("make full shape of indexed var : ", t);
/* line 547 "Normalization.puma" */
 t->INDEXED_VAR.IND_EXPS = NormalShapeAST (t->INDEXED_VAR.IND_EXPS); 
/* line 549 "Normalization.puma" */
   new = MakeFullShape (t);
/* line 551 "Normalization.puma" */
   tree_protocol ("full shape of indexed var now : ", new);
  }
   return new;
 }

  }
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 556 "Normalization.puma" */
 {
  tTree new;
  {
/* line 560 "Normalization.puma" */
   tree_protocol ("make full shape of sel indexed var : ", t);
/* line 562 "Normalization.puma" */
 t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR = NormalShapeAST (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR);
     t->INDEXED_VAR.IND_EXPS = NormalShapeAST (t->INDEXED_VAR.IND_EXPS); 
   
/* line 566 "Normalization.puma" */
   new = MakeFullShape (t);
/* line 568 "Normalization.puma" */
   tree_protocol ("full shape of sel indexed var now : ", new);
  }
   return new;
 }

  }
  break;
  case kFUNC_CALL_EXP:
/* line 573 "Normalization.puma" */
   return MakeFullShapeFunc (t);

  case kALLOCATE_STMT:
/* line 578 "Normalization.puma" */
  {
/* line 580 "Normalization.puma" */
 t->ALLOCATE_STMT.STATUS = NormalShapeAST (t->ALLOCATE_STMT.STATUS); 
     MakeFullAllocParams (t->ALLOCATE_STMT.PARAMS); 
   
  }
   return t;

  case kPTR_ASSIGN_STMT:
  if (t->PTR_ASSIGN_STMT.ASSIGN_VAR->Kind == kUSED_VAR) {
/* line 587 "Normalization.puma" */
  {
/* line 589 "Normalization.puma" */
 t->PTR_ASSIGN_STMT.ASSIGN_EXP = NormalShapeAST (t->PTR_ASSIGN_STMT.ASSIGN_EXP); 
  }
   return t;

  }
  if (t->PTR_ASSIGN_STMT.ASSIGN_VAR->Kind == kSELECTED_VAR) {
/* line 594 "Normalization.puma" */
  {
/* line 596 "Normalization.puma" */
 t->PTR_ASSIGN_STMT.ASSIGN_VAR->SELECTED_VAR.SELEC_VAR  = NormalShapeAST (t->PTR_ASSIGN_STMT.ASSIGN_VAR->SELECTED_VAR.SELEC_VAR); 
     t->PTR_ASSIGN_STMT.ASSIGN_EXP = NormalShapeAST (t->PTR_ASSIGN_STMT.ASSIGN_EXP);
   
  }
   return t;

  }
  break;
  }

/* line 603 "Normalization.puma" */
   return t;

}

static void MakeFullAllocParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
 yyRecursion:
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
/* line 609 "Normalization.puma" */
  {
/* line 611 "Normalization.puma" */
   params = params->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  }
/* line 614 "Normalization.puma" */
  {
/* line 616 "Normalization.puma" */
 params->BTP_LIST.Elem = NormalShapeAST (params->BTP_LIST.Elem); 
/* line 618 "Normalization.puma" */
   params = params->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
;
}

static tTree MakeFullShapeFunc
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 648 "Normalization.puma" */
  {
/* line 650 "Normalization.puma" */
   if (! ((IsIntrCall (t)))) goto yyL1;
  {
/* line 651 "Normalization.puma" */
   if (! ((t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("PRESENT")))) goto yyL1;
  }
  }
   return t;
yyL1:;

/* line 656 "Normalization.puma" */
  {
/* line 658 "Normalization.puma" */
   if (! ((IsIntrCall (t)))) goto yyL2;
  {
/* line 660 "Normalization.puma" */
 t->FUNC_CALL_EXP.FUNC_PARAMS = NormalShapeAST (t->FUNC_CALL_EXP.FUNC_PARAMS); 
  }
  }
   return TranslateInquiryCall (t);
yyL2:;

/* line 665 "Normalization.puma" */
  {
/* line 667 "Normalization.puma" */
   NormalNotFullParam (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return t;

  }
 yyAbort ("MakeFullShapeFunc");
 { tTree yyDummy; return yyDummy; }
}

static void MakeFullShapeProc
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCALL_STMT) {
/* line 680 "Normalization.puma" */
  {
/* line 681 "Normalization.puma" */
   NormalNotFullParam (t->CALL_STMT.CALL_PARAMS);
  }
   return;

  }
  if (t->Kind == kIO_STMT) {
/* line 684 "Normalization.puma" */
  {
/* line 685 "Normalization.puma" */
   NormalNotFullParam (t->IO_STMT.IO_ITEMS);
  }
   return;

  }
;
}

static void NormalNotFullParam
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_LIST) {
/* line 696 "Normalization.puma" */
  {
/* line 697 "Normalization.puma" */
   NormalNotFullParam (t->BTP_LIST.Elem);
/* line 698 "Normalization.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTP_EMPTY) {
/* line 701 "Normalization.puma" */
   return;

  }
  if (t->Kind == kVAR_PARAM) {
/* line 716 "Normalization.puma" */
  {
/* line 718 "Normalization.puma" */
 t->VAR_PARAM.V = NormalShapeAST (t->VAR_PARAM.V); 
  }
   return;

  }
  if (t->Kind == kFUNC_PARAM) {
/* line 721 "Normalization.puma" */
   return;

  }
  if (t->Kind == kPROC_PARAM) {
/* line 724 "Normalization.puma" */
   return;

  }
  if (t->Kind == kNO_PARAM) {
/* line 727 "Normalization.puma" */
   return;

  }
/* line 730 "Normalization.puma" */
  {
/* line 731 "Normalization.puma" */
   failure_protocol (MODULE, "NormalNotFullParam", t);
  }
   return;

;
}

static tTree MakeRaggedArrays
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 737 "Normalization.puma" */
   return ReplaceAST (t, ragged_pred, ragged_func);

}

static rbool ragged_pred
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 743 "Normalization.puma" */
  {
/* line 744 "Normalization.puma" */
   if (! ((IsTreeAccess (t)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
/* line 747 "Normalization.puma" */
   return rtrue;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
/* line 750 "Normalization.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static tTree ragged_func
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
/* line 755 "Normalization.puma" */
   return MakeRaggedDecls (t, GetLocalObject (t->VAR_DECL.Ident));

  }
  if (t->Kind == kTREE_DECL) {
/* line 760 "Normalization.puma" */
   return NoTree;

  }
  if (Tree_IsType (t, kBT_VAR)) {
/* line 765 "Normalization.puma" */
  {
/* line 767 "Normalization.puma" */
   if (! ((IsTreeAccess (t)))) goto yyL3;
  }
   return MakeRaggedAccess (t);
yyL3:;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
/* line 772 "Normalization.puma" */
   return MakeRaggedAllocates (t);

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
/* line 777 "Normalization.puma" */
   return MakeRaggedDeallocates (t);

  }
  }
/* line 782 "Normalization.puma" */
   return t;

}

void BeginNormalization ARGS ((void))
{
}

void CloseNormalization ARGS ((void))
{
}
