# include "NormalDefs.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 28 "NormalDefs.puma" */


# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "DefTable.h"

# include "Transform.h"
# include "Types.h"         /* GetObjectType */
# include "Rank.h"

# include "Nesting.h"

#define MODULE "NormalDefs"

    /*****************************************************
    *                                                    *
    *    Global Variables in Making Definitions          *
    *                                                    *
    *    ProgramCounter : counts PROGRAM_DECL            *
    *                                                    *
    *****************************************************/

static tTree Entity;
static tTree NewEntityDecls;   /* global use for translating an entity */
static rbool  HasParameterAttribute;
static tTree InitialValue;

static tTree stmtfuncs;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyNormalDefs.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* NormalDefs_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module NormalDefs, routine %s failed\n",
  yyFunction);
 NormalDefs_Exit ();
}

static tTree ReverseDeclList ARGS ((tTree list, tTree newlist));
tTree Normal1Definitions ARGS ((tTree t));
static tTree TranslateCommonDECL ARGS ((tTree idlist));
static void TranslateEntityDecl ARGS ((tIdent id, int pos, tTree attributes, tTree current_entity));
static void UpdateEntityVal ARGS ((tTree decl, tTree newval));
static void UpdateEntityDims ARGS ((tTree decl, tTree newdims));
tTree Normal2Definitions ARGS ((tTree t));
void StatementFunctions ARGS ((tTree body));
static tTree ExtractStatementFunctions ARGS ((tTree t));
static rbool IsStatementFunction ARGS ((tTree t));
static rbool NoIndexAllowed ARGS ((tDefinitions obj));
static tTree MakeStmtFuncDecl ARGS ((tTree var, tTree exp));
static tTree MakeStmtFuncFormals ARGS ((tTree Parameters));
static rbool IsDummyArgName ARGS ((tTree t));
static rbool IsDummyArgNameList ARGS ((tTree t));
static tTree MakeDataItems ARGS ((tTree val));

static tTree ReverseDeclList
# if defined __STDC__ | defined __cplusplus
(register tTree list, register tTree newlist)
# else
(list, newlist)
 register tTree list;
 register tTree newlist;
# endif
{
/* line 72 "NormalDefs.puma" */
  {
/* line 73 "NormalDefs.puma" */
   if (! ((list == NoTree))) goto yyL1;
  }
   return newlist;
yyL1:;

  if (list->Kind == kDECL_LIST) {
/* line 77 "NormalDefs.puma" */
 {
  tTree help;
  {
/* line 81 "NormalDefs.puma" */
 help = list->DECL_LIST.Next;
     list->DECL_LIST.Next = newlist;
   
  }
   return ReverseDeclList (help, list);
 }

  }
 yyAbort ("ReverseDeclList");
 { tTree yyDummy; return yyDummy; }
}

tTree Normal1Definitions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDECL_LIST) {
/* line 113 "NormalDefs.puma" */
 {
  tTree newdecl;
  {
/* line 117 "NormalDefs.puma" */
 set_protocol_stmt (t->DECL_LIST.Elem);  

     newdecl = Normal1Definitions (t->DECL_LIST.Elem);
     t->DECL_LIST.Next    = Normal1Definitions (t->DECL_LIST.Next);
     newdecl = ReplaceDECL (t, newdecl, t->DECL_LIST.Next);
   
  }
   return newdecl;
 }

  }
  if (t->Kind == kDECL_EMPTY) {
/* line 127 "NormalDefs.puma" */
   return t;

  }
  if (t->Kind == kENTITY_DECL) {
/* line 139 "NormalDefs.puma" */
  {
/* line 141 "NormalDefs.puma" */
   Entity = NoTree;
/* line 142 "NormalDefs.puma" */
   NewEntityDecls = NoTree;
/* line 143 "NormalDefs.puma" */
   HasParameterAttribute = rfalse;
/* line 144 "NormalDefs.puma" */
   InitialValue = NoTree;
/* line 146 "NormalDefs.puma" */
   TranslateEntityDecl (t->ENTITY_DECL.Ident, t->ENTITY_DECL.Line, t->ENTITY_DECL.ATTRIBUTES, t);
  }
   return NewEntityDecls;

  }
  if (t->Kind == kCOMMON_DECL) {
/* line 151 "NormalDefs.puma" */
 {
  tTree newdecl;
  {
/* line 157 "NormalDefs.puma" */
 newdecl = TranslateCommonDECL (t->COMMON_DECL.IDS);
     if (newdecl == NoTree)
        newdecl = t;
      else
        newdecl = mDECL_LIST (t, newdecl);
   
  }
   return newdecl;
 }

  }
/* line 168 "NormalDefs.puma" */
   return t;

}

static tTree TranslateCommonDECL
# if defined __STDC__ | defined __cplusplus
(register tTree idlist)
# else
(idlist)
 register tTree idlist;
# endif
{
/* line 186 "NormalDefs.puma" */

tTree newdecl;

  if (idlist->Kind == kDECL_LIST) {
/* line 190 "NormalDefs.puma" */
  {
/* line 191 "NormalDefs.puma" */
 newdecl = TranslateCommonDECL (idlist->DECL_LIST.Elem);
     if (newdecl == NoTree)
        newdecl = TranslateCommonDECL (idlist->DECL_LIST.Next);
      else
        newdecl = mDECL_LIST (newdecl, TranslateCommonDECL (idlist->DECL_LIST.Next));
   
  }
   return newdecl;

  }
  if (idlist->Kind == kDECL_EMPTY) {
/* line 200 "NormalDefs.puma" */
   return NoTree;

  }
  if (idlist->Kind == kVAR_DECL) {
  if (idlist->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 204 "NormalDefs.puma" */
  {
/* line 205 "NormalDefs.puma" */
 newdecl = mDIMENSION_DECL (idlist->VAR_DECL.Ident, idlist->VAR_DECL.Line, idlist->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES); 
     idlist->VAR_DECL.VAL = idlist->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE;
   
  }
   return newdecl;

  }
/* line 213 "NormalDefs.puma" */
   return NoTree;

  }
 yyAbort ("TranslateCommonDECL");
 { tTree yyDummy; return yyDummy; }
}

static void TranslateEntityDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int pos, register tTree attributes, register tTree current_entity)
# else
(id, pos, attributes, current_entity)
 register tIdent id;
 register int pos;
 register tTree attributes;
 register tTree current_entity;
# endif
{
/* line 228 "NormalDefs.puma" */

tTree newdecl;

 yyRecursion:
  if (attributes->Kind == kDECL_EMPTY) {
/* line 234 "NormalDefs.puma" */
  {
/* line 238 "NormalDefs.puma" */
 if (HasParameterAttribute && (InitialValue == NoTree))

      error_protocol ("initialization must appear with PARAMETER attribute");

    

    NewEntityDecls = ReverseDeclList (NewEntityDecls, NoTree);

    

    if (Entity != NoTree)
       NewEntityDecls = mDECL_LIST (Entity, NewEntityDecls);

  
  }
   return;

  }
  if (attributes->Kind == kDECL_LIST) {

  switch (attributes->DECL_LIST.Elem->Kind) {
  case kTYPESPEC_DECL:
/* line 254 "NormalDefs.puma" */
  {
/* line 256 "NormalDefs.puma" */
 if (Entity == NoTree)
      Entity = mVAR_DECL (id, pos, attributes->DECL_LIST.Elem->TYPESPEC_DECL.VAL);
     else 
      UpdateEntityVal (Entity, attributes->DECL_LIST.Elem->TYPESPEC_DECL.VAL);
  
/* line 261 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kDIMENSION_DECL:
/* line 264 "NormalDefs.puma" */
  {
/* line 266 "NormalDefs.puma" */
 if (Entity == NoTree)
      Entity = mVAR_DECL (id, pos, mARRAY_TYPE (attributes->DECL_LIST.Elem->DIMENSION_DECL.INDEXES, mDUMMY_TYPE()));
     else 
      UpdateEntityDims (Entity, attributes->DECL_LIST.Elem->DIMENSION_DECL.INDEXES);
  
/* line 271 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kINIT_DATA_DECL:
/* line 274 "NormalDefs.puma" */
  {
/* line 276 "NormalDefs.puma" */
  InitialValue = attributes->DECL_LIST.Elem->INIT_DATA_DECL.VAL;
     if (HasParameterAttribute)
       { newdecl = mPARAMETER_DECL (id, pos, attributes->DECL_LIST.Elem->INIT_DATA_DECL.VAL);
         NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
       }
      else
       
       { newdecl = mDATA_DECL (DefaultId(), pos, 
                      mBTV_LIST (mUSED_VAR (mVAR_OBJ (pos, id)), 
                                 mBTV_EMPTY ()),
                      MakeDataItems (attributes->DECL_LIST.Elem->INIT_DATA_DECL.VAL));
         NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
       }
  
/* line 290 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kSAVE_DECL:
/* line 293 "NormalDefs.puma" */
  {
/* line 295 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->SAVE_DECL.Ident = id; attributes->DECL_LIST.Elem->SAVE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 298 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kEXTERNAL_DECL:
/* line 301 "NormalDefs.puma" */
  {
/* line 303 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->EXTERNAL_DECL.Ident = id; attributes->DECL_LIST.Elem->EXTERNAL_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 306 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kINTRINSIC_DECL:
/* line 309 "NormalDefs.puma" */
  {
/* line 311 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->INTRINSIC_DECL.Ident = id; attributes->DECL_LIST.Elem->INTRINSIC_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 314 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kINTENT_DECL:
/* line 317 "NormalDefs.puma" */
  {
/* line 319 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->INTENT_DECL.Ident = id; attributes->DECL_LIST.Elem->INTENT_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 322 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kOPTIONAL_DECL:
/* line 325 "NormalDefs.puma" */
  {
/* line 327 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->OPTIONAL_DECL.Ident = id; attributes->DECL_LIST.Elem->OPTIONAL_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 330 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kALLOCATABLE_DECL:
/* line 333 "NormalDefs.puma" */
  {
/* line 335 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->ALLOCATABLE_DECL.Ident = id; attributes->DECL_LIST.Elem->ALLOCATABLE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 338 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kPOINTER_DECL:
/* line 341 "NormalDefs.puma" */
  {
/* line 343 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->POINTER_DECL.Ident = id; attributes->DECL_LIST.Elem->POINTER_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 346 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kTARGET_DECL:
/* line 349 "NormalDefs.puma" */
  {
/* line 351 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->TARGET_DECL.Ident = id; attributes->DECL_LIST.Elem->TARGET_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 355 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kPUBLIC_DECL:
/* line 358 "NormalDefs.puma" */
  {
/* line 360 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PUBLIC_DECL.Ident = id; attributes->DECL_LIST.Elem->PUBLIC_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 364 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kPRIVATE_DECL:
/* line 367 "NormalDefs.puma" */
  {
/* line 369 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PRIVATE_DECL.Ident = id; attributes->DECL_LIST.Elem->PRIVATE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 373 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kPARAMETER_DECL:
/* line 376 "NormalDefs.puma" */
  {
/* line 378 "NormalDefs.puma" */
 HasParameterAttribute = rtrue; 
/* line 380 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kTEMPLATE_DECL:
/* line 383 "NormalDefs.puma" */
  {
/* line 385 "NormalDefs.puma" */
 if (Entity == NoTree)
      { Entity = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->TEMPLATE_DECL.Ident = id; attributes->DECL_LIST.Elem->TEMPLATE_DECL.Line = pos; }
     else 
      tree_error_protocol ("Illegal TEMPLATE", current_entity);
  
/* line 391 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kPROCESSORS_DECL:
/* line 394 "NormalDefs.puma" */
  {
/* line 396 "NormalDefs.puma" */
 if (Entity == NoTree)
      { Entity = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PROCESSORS_DECL.Ident = id; attributes->DECL_LIST.Elem->PROCESSORS_DECL.Line = pos; }
     else 
      tree_error_protocol ("Illegal PROCESSORS", current_entity);
  
/* line 402 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kALIGN_DECL:
/* line 405 "NormalDefs.puma" */
  {
/* line 407 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->ALIGN_DECL.Ident = id; attributes->DECL_LIST.Elem->ALIGN_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 411 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kDYNAMIC_DECL:
/* line 414 "NormalDefs.puma" */
  {
/* line 416 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->DYNAMIC_DECL.Ident = id; attributes->DECL_LIST.Elem->DYNAMIC_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 420 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kDISTRIBUTE_DECL:
/* line 423 "NormalDefs.puma" */
  {
/* line 425 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->DISTRIBUTE_DECL.Ident = id; attributes->DECL_LIST.Elem->DISTRIBUTE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 429 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kSHADOW_DECL:
/* line 432 "NormalDefs.puma" */
  {
/* line 434 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->SHADOW_DECL.Ident = id; attributes->DECL_LIST.Elem->SHADOW_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 438 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kINHERIT_DECL:
/* line 441 "NormalDefs.puma" */
  {
/* line 443 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->INHERIT_DECL.Ident = id; attributes->DECL_LIST.Elem->INHERIT_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 447 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kSHARED_DECL:
/* line 450 "NormalDefs.puma" */
  {
/* line 452 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->SHARED_DECL.Ident = id; attributes->DECL_LIST.Elem->SHARED_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 456 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kRANGE_DECL:
/* line 459 "NormalDefs.puma" */
  {
/* line 461 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->RANGE_DECL.Ident = id; attributes->DECL_LIST.Elem->RANGE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 465 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kLAYOUT_DECL:
/* line 468 "NormalDefs.puma" */
  {
/* line 470 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->LAYOUT_DECL.Ident = id; attributes->DECL_LIST.Elem->LAYOUT_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 474 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kPASS_BY_DECL:
/* line 477 "NormalDefs.puma" */
  {
/* line 479 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PASS_BY_DECL.Ident = id; attributes->DECL_LIST.Elem->PASS_BY_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 483 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kMAP_TO_DECL:
/* line 486 "NormalDefs.puma" */
  {
/* line 488 "NormalDefs.puma" */
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->MAP_TO_DECL.Ident = id; attributes->DECL_LIST.Elem->MAP_TO_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
/* line 492 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  }

/* line 495 "NormalDefs.puma" */
  {
/* line 497 "NormalDefs.puma" */
   tree_error_protocol ("Unknown Attribute", attributes->DECL_LIST.Elem);
/* line 498 "NormalDefs.puma" */
   attributes = attributes->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
;
}

static void UpdateEntityVal
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tTree newval)
# else
(decl, newval)
 register tTree decl;
 register tTree newval;
# endif
{
  if (decl->Kind == kVAR_DECL) {
  if (decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 503 "NormalDefs.puma" */
  {
/* line 504 "NormalDefs.puma" */
 decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE = newval; 
  }
   return;

  }
/* line 507 "NormalDefs.puma" */
  {
/* line 508 "NormalDefs.puma" */
 decl->VAR_DECL.VAL = newval; 
  }
   return;

  }
;
}

static void UpdateEntityDims
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tTree newdims)
# else
(decl, newdims)
 register tTree decl;
 register tTree newdims;
# endif
{
  if (decl->Kind == kVAR_DECL) {
  if (decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 513 "NormalDefs.puma" */
  {
/* line 514 "NormalDefs.puma" */
 decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES = newdims; 
  }
   return;

  }
/* line 517 "NormalDefs.puma" */
  {
/* line 518 "NormalDefs.puma" */
 decl->VAR_DECL.VAL = mARRAY_TYPE (newdims, decl->VAR_DECL.VAL); 
  }
   return;

  }
  if (decl->Kind == kTEMPLATE_DECL) {
/* line 521 "NormalDefs.puma" */
  {
/* line 522 "NormalDefs.puma" */
 decl->TEMPLATE_DECL.DIMENSIONS = newdims; 
  }
   return;

  }
  if (decl->Kind == kPROCESSORS_DECL) {
/* line 525 "NormalDefs.puma" */
  {
/* line 526 "NormalDefs.puma" */
 decl->PROCESSORS_DECL.DIMENSIONS = newdims; 
  }
   return;

  }
;
}

tTree Normal2Definitions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 546 "NormalDefs.puma" */

tTree newdecl;

  if (t->Kind == kDECL_LIST) {
/* line 550 "NormalDefs.puma" */
  {
/* line 551 "NormalDefs.puma" */
 newdecl = Normal2Definitions (t->DECL_LIST.Elem);
     t->DECL_LIST.Next    = Normal2Definitions (t->DECL_LIST.Next);
     newdecl = ReplaceDECL (t, newdecl, t->DECL_LIST.Next);
   
  }
   return newdecl;

  }
  if (t->Kind == kDECL_EMPTY) {
/* line 558 "NormalDefs.puma" */
   return t;

  }
  if (t->Kind == kDIMENSION_DECL) {
/* line 562 "NormalDefs.puma" */
 {
  tTree type;
  {
/* line 568 "NormalDefs.puma" */
 type = GetBaseType (GetObjectType (GetLocalObject (t->DIMENSION_DECL.Ident)));
      type = mARRAY_TYPE (t->DIMENSION_DECL.INDEXES, type);
      t->Kind = kVAR_DECL;
      t->VAR_DECL.VAL = type;
    
  }
   return t;
 }

  }
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 576 "NormalDefs.puma" */
   return t;

  }
/* line 583 "NormalDefs.puma" */
 {
  tTree newdecl;
  tDefinitions obj;
  int rank;
  {
/* line 591 "NormalDefs.puma" */
 obj = GetLocalObject (t->VAR_DECL.Ident);
      if (obj != NoObject)
         rank = VarRank (obj);
        else
         rank = 0;
      if (rank == 0)
         newdecl = t;
       else
         newdecl = NoTree;
    
  }
   return newdecl;
 }

  }
/* line 606 "NormalDefs.puma" */
   return t;

}

void StatementFunctions
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 618 "NormalDefs.puma" */
  {
/* line 620 "NormalDefs.puma" */
 
      

      stmtfuncs = mDECL_EMPTY ();

      

      body->BODY_NODE.STATS = ExtractStatementFunctions (body->BODY_NODE.STATS);  

      body->BODY_NODE.DECLS = AppendDECLS (body->BODY_NODE.DECLS, stmtfuncs);  

    
  }
   return;

  }
;
}

static tTree ExtractStatementFunctions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 649 "NormalDefs.puma" */

tTree StmtFuncDecl;
tTree NextList;

  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_BASIC) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 654 "NormalDefs.puma" */
  {
/* line 656 "NormalDefs.puma" */
   if (! ((IsStatementFunction (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  {
/* line 658 "NormalDefs.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 660 "NormalDefs.puma" */
   stmt_protocol ("this is a statement function");
/* line 666 "NormalDefs.puma" */
 StmtFuncDecl = MakeStmtFuncDecl (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
      NextList     = ExtractStatementFunctions (t->ACF_LIST.Next);
      stmtfuncs    = mDECL_LIST (StmtFuncDecl, stmtfuncs);
    
  }
  }
   return NextList;
yyL1:;

  }
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kFORMAT_STMT) {
/* line 674 "NormalDefs.puma" */
  {
/* line 678 "NormalDefs.puma" */
 t->ACF_LIST.Next = ExtractStatementFunctions (t->ACF_LIST.Next); 
  }
   return t;

  }
  }
/* line 683 "NormalDefs.puma" */
   return t;

  }
  if (t->Kind == kACF_EMPTY) {
/* line 690 "NormalDefs.puma" */
   return t;

  }
 yyAbort ("ExtractStatementFunctions");
 { tTree yyDummy; return yyDummy; }
}

static rbool IsStatementFunction
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 702 "NormalDefs.puma" */
  {
/* line 709 "NormalDefs.puma" */
   if (! ((IsDummyArgNameList (t->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  {
/* line 710 "NormalDefs.puma" */
   if (! ((NoIndexAllowed (GetGlobalObject (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident))))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static rbool NoIndexAllowed
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 715 "NormalDefs.puma" */
  {
/* line 717 "NormalDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 720 "NormalDefs.puma" */
  {
/* line 722 "NormalDefs.puma" */
   if (! ((obj->VarObject.in == GetCurrentUnitObject ()))) goto yyL2;
  {
/* line 724 "NormalDefs.puma" */
   if (! ((VarRank (obj) == 0))) goto yyL2;
  {
/* line 725 "NormalDefs.puma" */
   if (! ((! IsStringType (GetObjectType (obj))))) goto yyL2;
  }
  }
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

static tTree MakeStmtFuncDecl
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
/* line 737 "NormalDefs.puma" */

   tObject OldObj, NewObj;
   tTree   ResType, Decl, Formals;

  if (var->Kind == kINDEXED_VAR) {
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 742 "NormalDefs.puma" */
  {
/* line 744 "NormalDefs.puma" */
 Formals = MakeStmtFuncFormals (var->INDEXED_VAR.IND_EXPS);

    OldObj = GetLocalObject (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);

    if (OldObj == NoObject)
       ResType = mDUMMY_TYPE ();
     else
       { if (OldObj->Object.decl->Kind != kVAR_DECL)
            printf ("Error in MakeStmtFuncDecl\n");
         ResType = CopyTree(OldObj->Object.decl->VAR_DECL.VAL);  
       }

    

    Decl   = mSTMT_FUNC_DECL (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Pos, Formals, ResType, exp);

    NewObj = mFuncObject (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, Decl, Default, NoObject,
                          UserRoutine, mENTRY_EMPTY ());

    if (OldObj != NoObject)
       ChangeEntry (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, NewObj);
     else
       InsertEntry (NewObj);
    
  }
   return Decl;

  }
  }
 yyAbort ("MakeStmtFuncDecl");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeStmtFuncFormals
# if defined __STDC__ | defined __cplusplus
(register tTree Parameters)
# else
(Parameters)
 register tTree Parameters;
# endif
{
 yyRecursion:
  if (Parameters->Kind == kBTE_LIST) {
  if (Parameters->BTE_LIST.Elem->Kind == kVAR_EXP) {
  if (Parameters->BTE_LIST.Elem->VAR_EXP.V->Kind == kUSED_VAR) {
/* line 779 "NormalDefs.puma" */
 {
  tTree P;
  {
/* line 783 "NormalDefs.puma" */
   P = mVAR_PARAM_DECL (Parameters->BTE_LIST.Elem->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident, Parameters->BTE_LIST.Elem->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Pos, mDUMMY_TYPE ());
  }
   return mDECL_LIST (P, MakeStmtFuncFormals (Parameters->BTE_LIST.Next));
 }

  }
  }
/* line 788 "NormalDefs.puma" */
  {
/* line 792 "NormalDefs.puma" */
   error_protocol ("Illegal Statement Function");
/* line 793 "NormalDefs.puma" */
   tree_protocol ("Not a legal parameter : ", Parameters->BTE_LIST.Elem);
  }
   Parameters = Parameters->BTE_LIST.Next;
   goto yyRecursion;

  }
  if (Parameters->Kind == kBTE_EMPTY) {
/* line 797 "NormalDefs.puma" */
   return mDECL_EMPTY ();

  }
 yyAbort ("MakeStmtFuncFormals");
 { tTree yyDummy; return yyDummy; }
}

static rbool IsDummyArgName
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
/* line 809 "NormalDefs.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsDummyArgNameList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_EMPTY) {
/* line 816 "NormalDefs.puma" */
   return rtrue;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kVAR_EXP) {
/* line 819 "NormalDefs.puma" */
  {
/* line 820 "NormalDefs.puma" */
   if (! ((IsDummyArgName (t->BTE_LIST.Elem->VAR_EXP.V)))) goto yyL2;
  {
/* line 821 "NormalDefs.puma" */
   if (! ((IsDummyArgNameList (t->BTE_LIST.Next)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

static tTree MakeDataItems
# if defined __STDC__ | defined __cplusplus
(register tTree val)
# else
(val)
 register tTree val;
# endif
{
  if (val->Kind == kARRAY_EXP) {
/* line 838 "NormalDefs.puma" */
   return val->ARRAY_EXP.ELEMENTS;

  }
/* line 843 "NormalDefs.puma" */
   return mBTE_LIST (val, mBTE_EMPTY ());

}

void BeginNormalDefs ARGS ((void))
{
}

void CloseNormalDefs ARGS ((void))
{
}
