# include "NewStatements.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 21 "NewStatements.puma" */


# undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Types.h"
# include "Transform.h"    /* ReplaceACF, ... */
# include "Expressions.h"  /* MakeNotExp, ... */

# include "TreeOps.h"      /* IsVarInExp      */
# include "Loops.h"        /* IsParallelLoop  */
# include "Rank.h"         /* TreeRank        */

# include "Nesting.h"

# define MODULE "NewStatements"

static tTree par_info = NoTree;   /* reuse one Tree for many purposes */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyNewStatements.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* NewStatements_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module NewStatements, routine %s failed\n",
  yyFunction);
 NewStatements_Exit ();
}

void ExpandNewStatements ARGS ((tTree t, tTree loop, int line));
void MaskNewStatements ARGS ((tTree t, tTree mask, rbool rtrue_flag, int line));
static rbool NotBeMasked ARGS ((tTree stmt));
static rbool MustBeMasked ARGS ((tTree stmt));
static tTree MakeOuterLoop ARGS ((tTree loop, tTree body));
static tTree CopyInfo ARGS ((tTree info));
static void GetExpansionInfo ARGS ((tTree loop, int * yyP5, tTree * yyP4, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static rbool IsBodyInvariant ARGS ((tTree body, tTree loopvar));
static tTree MakeOuterMask ARGS ((tTree mask, rbool rtrue_flag, tTree body));

void ExpandNewStatements
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree loop, register int line)
# else
(t, loop, line)
 register tTree t;
 register tTree loop;
 register int line;
# endif
{
 yyRecursion:
/* line 80 "NewStatements.puma" */
  {
/* line 81 "NewStatements.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_BASIC) {

  switch (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind) {
  case kALLOCATE_STMT:
/* line 84 "NewStatements.puma" */
  {
/* line 88 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kDEALLOCATE_STMT:
/* line 91 "NewStatements.puma" */
  {
/* line 95 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kCREATE_DSP_STMT:
/* line 98 "NewStatements.puma" */
  {
/* line 100 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kFREE_DSP_STMT:
/* line 103 "NewStatements.puma" */
  {
/* line 105 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kIND_SHADOW_CREATE:
/* line 108 "NewStatements.puma" */
  {
/* line 110 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kIND_SHADOW_FREE:
/* line 113 "NewStatements.puma" */
  {
/* line 115 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kIND_SHADOW_GET:
/* line 118 "NewStatements.puma" */
  {
/* line 120 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kIND_SHADOW_SET:
/* line 123 "NewStatements.puma" */
  {
/* line 125 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kIND_SHADOW_PUT:
/* line 128 "NewStatements.puma" */
  {
/* line 130 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kASSIGN_STMT:
/* line 133 "NewStatements.puma" */
  {
/* line 135 "NewStatements.puma" */
   t->ACF_LIST.Elem->ACF_BASIC.Line = line;
/* line 136 "NewStatements.puma" */
  t->ACF_LIST.Elem = MakeOuterLoop (loop, t->ACF_LIST.Elem); 
/* line 138 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kREDUCE_STMT:
/* line 141 "NewStatements.puma" */
  {
/* line 143 "NewStatements.puma" */
   t->ACF_LIST.Elem->ACF_BASIC.Line = line;
/* line 144 "NewStatements.puma" */
  t->ACF_LIST.Elem = MakeOuterLoop (loop, t->ACF_LIST.Elem); 
/* line 146 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  }

  }
  if (t->ACF_LIST.Elem->Kind == kACF_FORALL) {
/* line 149 "NewStatements.puma" */
  {
/* line 151 "NewStatements.puma" */
   t->ACF_LIST.Elem->ACF_FORALL.Line = line;
/* line 153 "NewStatements.puma" */
  t->ACF_LIST.Elem = MakeOuterLoop (loop, t->ACF_LIST.Elem); 
/* line 155 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->ACF_LIST.Elem->Kind == kACF_HOME) {
/* line 158 "NewStatements.puma" */
  {
/* line 160 "NewStatements.puma" */
   ExpandNewStatements (t->ACF_LIST.Next, t->ACF_LIST.Elem->ACF_HOME.HOME_BODY, line);
  }
   return;

  }
  if (t->ACF_LIST.Elem->Kind == kACF_DO) {
/* line 163 "NewStatements.puma" */
  {
/* line 165 "NewStatements.puma" */
   t->ACF_LIST.Elem->ACF_DO.Line = line;
/* line 166 "NewStatements.puma" */
  t->ACF_LIST.Elem = MakeOuterLoop (loop, t->ACF_LIST.Elem); 
/* line 168 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->ACF_LIST.Elem->Kind == kACF_IF) {
/* line 171 "NewStatements.puma" */
  {
/* line 173 "NewStatements.puma" */
   t->ACF_LIST.Elem->ACF_IF.Line = line;
/* line 174 "NewStatements.puma" */
  t->ACF_LIST.Elem = MakeOuterLoop (loop, t->ACF_LIST.Elem); 
/* line 176 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (t->Kind == kACF_EMPTY) {
/* line 179 "NewStatements.puma" */
   return;

  }
/* line 182 "NewStatements.puma" */
  {
/* line 183 "NewStatements.puma" */
   failure_protocol (MODULE, "ExpandNewStatements", t);
  }
   return;

;
}

void MaskNewStatements
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree mask, register rbool rtrue_flag, register int line)
# else
(t, mask, rtrue_flag, line)
 register tTree t;
 register tTree mask;
 register rbool rtrue_flag;
 register int line;
# endif
{
 yyRecursion:
/* line 220 "NewStatements.puma" */
  {
/* line 222 "NewStatements.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kACF_LIST) {
/* line 225 "NewStatements.puma" */
  {
/* line 227 "NewStatements.puma" */
   if (! ((MustBeMasked (t->ACF_LIST.Elem)))) goto yyL2;
  {
/* line 229 "NewStatements.puma" */
   t->ACF_LIST.Elem->ACF_NODE.Line = line;
/* line 231 "NewStatements.puma" */
 t->ACF_LIST.Elem = MakeOuterMask (mask, rtrue_flag, t->ACF_LIST.Elem); 
/* line 233 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }
  }
yyL2:;

/* line 236 "NewStatements.puma" */
  {
/* line 238 "NewStatements.puma" */
   if (! ((NotBeMasked (t->ACF_LIST.Elem)))) goto yyL3;
  {
/* line 240 "NewStatements.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }
  }
yyL3:;

  }
  if (t->Kind == kACF_EMPTY) {
/* line 243 "NewStatements.puma" */
   return;

  }
/* line 246 "NewStatements.puma" */
  {
/* line 248 "NewStatements.puma" */
   failure_protocol (MODULE, "MaskNewStatements", t);
  }
   return;

;
}

static rbool NotBeMasked
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {

  switch (stmt->ACF_BASIC.BASIC_STMT->Kind) {
  case kALLOCATE_STMT:
/* line 253 "NewStatements.puma" */
   return rtrue;

  case kDEALLOCATE_STMT:
/* line 256 "NewStatements.puma" */
   return rtrue;

  case kCREATE_DSP_STMT:
/* line 259 "NewStatements.puma" */
   return rtrue;

  case kFREE_DSP_STMT:
/* line 262 "NewStatements.puma" */
   return rtrue;

  case kIND_SHADOW_CREATE:
/* line 265 "NewStatements.puma" */
   return rtrue;

  case kIND_SHADOW_FREE:
/* line 268 "NewStatements.puma" */
   return rtrue;

  case kIND_SHADOW_SET:
/* line 271 "NewStatements.puma" */
   return rtrue;

  case kIND_SHADOW_PUT:
/* line 274 "NewStatements.puma" */
   return rtrue;

  case kIND_SHADOW_GET:
/* line 277 "NewStatements.puma" */
   return rtrue;

  }

  }
  return rfalse;
}

static rbool MustBeMasked
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 282 "NewStatements.puma" */
   return rtrue;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 285 "NewStatements.puma" */
   return rtrue;

  }
  }
  if (stmt->Kind == kACF_FORALL) {
/* line 288 "NewStatements.puma" */
   return rtrue;

  }
  if (stmt->Kind == kACF_DO) {
/* line 291 "NewStatements.puma" */
  {
/* line 293 "NewStatements.puma" */
   if (! ((IsParallelLoop (stmt)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  if (stmt->Kind == kACF_IF) {
/* line 296 "NewStatements.puma" */
   return rtrue;

  }
  if (stmt->Kind == kACF_WHERE) {
/* line 299 "NewStatements.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree MakeOuterLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop, register tTree body)
# else
(loop, body)
 register tTree loop;
 register tTree body;
# endif
{
/* line 325 "NewStatements.puma" */
 {
  int yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
/* line 327 "NewStatements.puma" */
   GetExpansionInfo (loop, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
/* line 329 "NewStatements.puma" */
   if (! ((yyV3 != NoTree))) goto yyL1;
  {
/* line 331 "NewStatements.puma" */
   if (! ((IsBodyInvariant (body, yyV2)))) goto yyL1;
  }
  }
   return body;
 }
yyL1:;

/* line 336 "NewStatements.puma" */
 {
  int yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree new;
  tTree dep_info1;
  tTree home_info1;
  {
/* line 338 "NewStatements.puma" */
   GetExpansionInfo (loop, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
/* line 340 "NewStatements.puma" */
   if (! ((yyV3 != NoTree))) goto yyL2;
  {
/* line 346 "NewStatements.puma" */
 new = mACF_LIST (body, mACF_EMPTY ());

     if (yyV4 == NoTree)
         dep_info1  = mINDEP_INFO (rfalse, 0, NoTree, NoTree);
      else
         dep_info1 = CopyInfo (yyV4);

     if (yyV5 == NoTree)
         home_info1  = mNO_HOME_INFO ();
      else
         home_info1 = CopyInfo (yyV5);

     new = mACF_FORALL (CopyTree(yyV2), CopyTree(yyV3), new, 
                        dep_info1, home_info1);

     new->ACF_NODE.Line = yyV1;
     new->ACF_NODE.Label = 0;    
   
  }
  }
   return new;
 }
yyL2:;

/* line 368 "NewStatements.puma" */
  {
/* line 370 "NewStatements.puma" */
   failure_protocol (MODULE, "MakeOuterLoop", loop);
  }
   return NoTree;

}

static tTree CopyInfo
# if defined __STDC__ | defined __cplusplus
(register tTree info)
# else
(info)
 register tTree info;
# endif
{
  if (info->Kind == kINDEP_INFO) {
/* line 391 "NewStatements.puma" */
   return mINDEP_INFO (info->INDEP_INFO.user_independent, info->INDEP_INFO.selection, NoTree, NoTree);

  }
  if (info->Kind == kSERIAL_INFO) {
/* line 396 "NewStatements.puma" */
   return mSERIAL_INFO ();

  }
  if (info->Kind == kNO_HOME_INFO) {
/* line 401 "NewStatements.puma" */
   return mNO_HOME_INFO ();

  }
  if (info->Kind == kCOMM_INFO) {
/* line 406 "NewStatements.puma" */
   return mCOMM_INFO (CopyTree (info->COMM_INFO.home_var), info->COMM_INFO.is_local);

  }
/* line 411 "NewStatements.puma" */
  {
/* line 413 "NewStatements.puma" */
   failure_protocol (MODULE, "CopyInfo", info);
  }
   return NoTree;

}

static void GetExpansionInfo
# if defined __STDC__ | defined __cplusplus
(register tTree loop, register int * yyP5, register tTree * yyP4, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(loop, yyP5, yyP4, yyP3, yyP2, yyP1)
 register tTree loop;
 register int * yyP5;
 register tTree * yyP4;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (loop->Kind == kACF_FORALL) {
/* line 425 "NewStatements.puma" */
   * yyP5 = loop->ACF_FORALL.Line;
   * yyP4 = loop->ACF_FORALL.FORALL_ID;
   * yyP3 = loop->ACF_FORALL.FORALL_RANGE;
   * yyP2 = loop->ACF_FORALL.FORALL_DEP_INFO;
   * yyP1 = loop->ACF_FORALL.FORALL_HOME_INFO;
   return;

  }
  if (loop->Kind == kACF_DO) {
/* line 430 "NewStatements.puma" */
   * yyP5 = loop->ACF_DO.Line;
   * yyP4 = loop->ACF_DO.DO_ID;
   * yyP3 = loop->ACF_DO.DO_RANGE;
   * yyP2 = loop->ACF_DO.DO_DEP_INFO;
   * yyP1 = loop->ACF_DO.DO_HOME_INFO;
   return;

  }
  if (loop->Kind == kDO_EXP) {
/* line 435 "NewStatements.puma" */
   * yyP5 = 0;
   * yyP4 = loop->DO_EXP.DO_ID;
   * yyP3 = loop->DO_EXP.RANGE;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  }
  if (loop->Kind == kDO_VAR) {
/* line 438 "NewStatements.puma" */
   * yyP5 = 0;
   * yyP4 = loop->DO_VAR.DO_ID;
   * yyP3 = loop->DO_VAR.RANGE;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  }
/* line 441 "NewStatements.puma" */
   * yyP5 = 0;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static rbool IsBodyInvariant
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree loopvar)
# else
(body, loopvar)
 register tTree body;
 register tTree loopvar;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 446 "NewStatements.puma" */
  {
/* line 448 "NewStatements.puma" */
   if (! ((IsBodyInvariant (body->ACF_LIST.Elem, loopvar)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  if (body->Kind == kACF_FORALL) {
/* line 451 "NewStatements.puma" */
  {
/* line 453 "NewStatements.puma" */
   if (! ((IsBodyInvariant (body->ACF_FORALL.FORALL_BODY, loopvar)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (body->Kind == kACF_BASIC) {
  if (body->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (loopvar->Kind == kLOOP_VAR) {
/* line 456 "NewStatements.puma" */
 {
  rbool invariant;
  {
/* line 460 "NewStatements.puma" */
 invariant = (IsVarInExp (TreeVarName (loopvar), body->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) == 0);

     if (invariant)
 
        { 
          
          invariant = (IsVarInExp (TreeVarName (loopvar), body->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP) == 0);
 
          if (!invariant)

           { error_protocol ("temporary not sufficient");
             tree_protocol ("invariant lhs : ", body->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
             tree_protocol ("non invariant rhs : ", body->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
             tree_protocol ("missing loop var : ", loopvar);
           }
        }

   
/* line 479 "NewStatements.puma" */
   if (! ((invariant))) goto yyL3;
  }
   return rtrue;
 }
yyL3:;

  }
/* line 482 "NewStatements.puma" */
  {
/* line 483 "NewStatements.puma" */
   return rfalse;
  }

  }
  }
  return rfalse;
}

static tTree MakeOuterMask
# if defined __STDC__ | defined __cplusplus
(register tTree mask, register rbool rtrue_flag, register tTree body)
# else
(mask, rtrue_flag, body)
 register tTree mask;
 register rbool rtrue_flag;
 register tTree body;
# endif
{
/* line 500 "NewStatements.puma" */
 {
  tTree new;
  {
/* line 502 "NewStatements.puma" */
   if (! ((rtrue_flag))) goto yyL1;
  {
/* line 506 "NewStatements.puma" */
 new = mACF_LIST (body, mACF_EMPTY ());
     if (TreeRank (mask) == 0)
        new = mACF_IF (CopyTree (mask), new, mACF_EMPTY ());
      else
        new = mACF_WHERE (CopyTree (mask), new, mACF_EMPTY ());
   
  }
  }
   return new;
 }
yyL1:;

/* line 515 "NewStatements.puma" */
 {
  tTree new;
  {
/* line 519 "NewStatements.puma" */
 new = mACF_LIST (body, mACF_EMPTY ());
     if (TreeRank (mask) == 0)
        new = mACF_IF (MakeNotExp (CopyTree (mask)), new, mACF_EMPTY ());
      else
        new = mACF_WHERE (MakeNotExp (CopyTree (mask)), new, mACF_EMPTY ());
   
  }
   return new;
 }

}

void BeginNewStatements ARGS ((void))
{
}

void CloseNewStatements ARGS ((void))
{
}
