# include "Nesting.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 57 "Nesting.puma" */


# undef DEBUG

# include "Idents.h"
# include "protocol.h"
# include "DefTable.h"   /* OpenScope, CloseScope, ... */
# include "Objects.h"
# include "Expressions.h"

# define MODULE "Nesting"

# define MAXLoops 20
# define MAXUnits 20

/*********************************************************************
*                                                                    * 
*  Global Data for Nesting                                           * 
*                                                                    * 
*  Nest[0]          DO     I1 = ...                                  *
*  Nest[1]          DO     I2 = ...                                  *
*  ...                                                               *
*  Nest[Nesting-1]  FORALL Ik = ...                                  *
*                                                                    *
*    stmt      :         A(I1,I2,...,Ik)  = ....                     *
*                                                                    *
*********************************************************************/

static int Nesting = 0;       /* actual depth of nesting      */
static tTree Nest[MAXLoops];  /* actual loops of loop nesting */

static tTree   UnitNest [MAXUnits];
static tObject UnitObjNest [MAXUnits];
static int     UnitNesting = 0;       /* actual depth of unit nesting */

static void IncUnitNest (unit, obj)
tTree  unit;
tObject obj;

{ if (UnitNesting >= MAXUnits)  
       simple_error_protocol ("to deep unit nesting");
      else
       { UnitNest [UnitNesting] = unit;
         UnitObjNest [UnitNesting] = obj;
         UnitNesting += 1;
       }

#ifdef DEBUG
   printf ("IncUnitNest, Nesting = %d\n", UnitNesting);
   printf ("GetCurrentModel = %d\n", GetCurrentModel());
#endif 

}  /* IncUnitNest */

static void DecUnitNest (unit)
tTree unit;

{ if (UnitNesting == 0)  
     simple_error_protocol ("Nesting : no unit to be quit");
    else if (UnitNest[UnitNesting-1] != unit)
     { simple_error_protocol ("Nesting : wrong unit to be quit");
       tree_protocol ("this unit is quitted :\n", unit);
       tree_protocol ("this unit should be quitted :\n", 
                       UnitNest[UnitNesting-1]);
       failure_protocol (MODULE, "DecUnitNest : illegal", NoTree);
     }
    else
     UnitNesting -= 1;

#ifdef DEBUG
   printf ("DecUnitNest, Nesting = %d\n", UnitNesting);
#endif 

 }  /* DecUnitNest */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyNesting.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Nesting_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Nesting, routine %s failed\n",
  yyFunction);
 Nesting_Exit ();
}

static void NestInit ARGS ((tTree t));
static void NestExit ARGS ((tTree t));
static rbool ValidObject ARGS ((tDefinitions obj, tTree t));
void NestOpenUnit ARGS ((tTree t));
void NestOpenUnitObj ARGS ((tDefinitions unit_obj));
void NestCloseUnit ARGS ((tTree t));
void NestCloseUnitObj ARGS ((tDefinitions unit_obj));
static tDefinitions CloseUnitScope ARGS ((tTree t));
static void SetNewUnitEntries ARGS ((tDefinitions unit_obj, tDefinitions new_entries));
tTree GetCurrentUnit ARGS ((void));
tDefinitions GetCurrentUnitObject ARGS ((void));
int GetCurrentModel ARGS ((void));
void NestOpenType ARGS ((tTree t));
void NestCloseType ARGS ((tTree t));
void IncLoopNesting ARGS ((tTree loop));
void DecLoopNesting ARGS ((tTree loop));
int OuterLoops ARGS ((void));
tTree GetOuterLoop ARGS ((int n));
ptree GetAllOuterLoops ARGS ((void));
rbool IsCurrentLoopVar ARGS ((tTree t));
static rbool IsLoopVarHere ARGS ((tTree v, tTree loop));
rbool IsCountLoop ARGS ((tTree loop));
tTree GetLoopId ARGS ((tTree loop));
tTree GetLoopSlice ARGS ((tTree loop));
void GetLoopIncrement ARGS ((tTree t, rbool * yyP2, int * yyP1));

static void NestInit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 136 "Nesting.puma" */
  {
/* line 138 "Nesting.puma" */
 if (Nesting != 0)
         simple_error_protocol ("NestInit: nested loops not closed");
    
/* line 141 "Nesting.puma" */
   Nesting = 0;
  }
   return;

;
}

static void NestExit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 146 "Nesting.puma" */
  {
/* line 148 "Nesting.puma" */
 if (Nesting != 0)
         simple_error_protocol ("NestExit: nested loops not closed");
    
/* line 151 "Nesting.puma" */
   Nesting = 0;
  }
   return;

;
}

static rbool ValidObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree t)
# else
(obj, t)
 register tDefinitions obj;
 register tTree t;
# endif
{
/* line 162 "Nesting.puma" */
  {
/* line 163 "Nesting.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 164 "Nesting.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kProcObject) {
  if (t->Kind == kPROGRAM_DECL) {
/* line 167 "Nesting.puma" */
   return rtrue;

  }
  if (t->Kind == kPROC_DECL) {
/* line 170 "Nesting.puma" */
   return rtrue;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (t->Kind == kFUNC_DECL) {
/* line 173 "Nesting.puma" */
   return rtrue;

  }
  }
  if (obj->Kind == kBlockObject) {
  if (t->Kind == kBLOCK_DATA_DECL) {
/* line 176 "Nesting.puma" */
   return rtrue;

  }
  }
  if (obj->Kind == kModuleObject) {
  if (t->Kind == kMODULE_DECL) {
/* line 179 "Nesting.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

void NestOpenUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kUNIT_NODE)) {
/* line 190 "Nesting.puma" */
  {
/* line 192 "Nesting.puma" */
   if (! ((ValidObject (t->UNIT_NODE.Object, t)))) goto yyL1;
  {
/* line 194 "Nesting.puma" */
   NestOpenUnitObj (t->UNIT_NODE.Object);
  }
  }
   return;
yyL1:;

/* line 197 "Nesting.puma" */
  {
/* line 199 "Nesting.puma" */
   tree_error_protocol ("no valid object for this unit", t);
/* line 200 "Nesting.puma" */
   obj_error_protocol ("object for unit was : ", t->UNIT_NODE.Object);
/* line 202 "Nesting.puma" */
   failure_protocol (MODULE, "GetUnitObject: not valid", t);
/* line 204 "Nesting.puma" */
 t->UNIT_NODE.Object = mProcObject (t->UNIT_NODE.Ident, t, Default, NoObject,
                         UserRoutine, mENTRY_EMPTY ());
    
/* line 207 "Nesting.puma" */
   NestOpenUnitObj (t->UNIT_NODE.Object);
  }
   return;

  }
/* line 210 "Nesting.puma" */
  {
/* line 211 "Nesting.puma" */
   failure_protocol (MODULE, "NestOpenUnit", t);
  }
   return;

;
}

void NestOpenUnitObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions unit_obj)
# else
(unit_obj)
 register tDefinitions unit_obj;
# endif
{
  if (unit_obj->Kind == kProcObject) {
/* line 222 "Nesting.puma" */
  {
/* line 224 "Nesting.puma" */
   set_protocol_unit (unit_obj->ProcObject.decl);
/* line 225 "Nesting.puma" */
   IncUnitNest (unit_obj->ProcObject.decl, unit_obj);
/* line 226 "Nesting.puma" */
   OpenScope (unit_obj->ProcObject.Declarations);
/* line 227 "Nesting.puma" */
   NestInit (unit_obj->ProcObject.decl);
  }
   return;

  }
  if (unit_obj->Kind == kFuncObject) {
/* line 230 "Nesting.puma" */
  {
/* line 232 "Nesting.puma" */
   set_protocol_unit (unit_obj->FuncObject.decl);
/* line 233 "Nesting.puma" */
   IncUnitNest (unit_obj->FuncObject.decl, unit_obj);
/* line 234 "Nesting.puma" */
   OpenScope (unit_obj->FuncObject.Declarations);
/* line 235 "Nesting.puma" */
   NestInit (unit_obj->FuncObject.decl);
  }
   return;

  }
  if (unit_obj->Kind == kBlockObject) {
/* line 238 "Nesting.puma" */
  {
/* line 240 "Nesting.puma" */
   set_protocol_unit (unit_obj->BlockObject.decl);
/* line 241 "Nesting.puma" */
   IncUnitNest (unit_obj->BlockObject.decl, unit_obj);
/* line 242 "Nesting.puma" */
   OpenScope (unit_obj->BlockObject.Declarations);
/* line 243 "Nesting.puma" */
   NestInit (unit_obj->BlockObject.decl);
  }
   return;

  }
  if (unit_obj->Kind == kModuleObject) {
/* line 246 "Nesting.puma" */
  {
/* line 248 "Nesting.puma" */
   set_protocol_unit (unit_obj->ModuleObject.decl);
/* line 249 "Nesting.puma" */
   IncUnitNest (unit_obj->ModuleObject.decl, unit_obj);
/* line 250 "Nesting.puma" */
   OpenScope (unit_obj->ModuleObject.Declarations);
/* line 251 "Nesting.puma" */
   NestInit (unit_obj->ModuleObject.decl);
  }
   return;

  }
/* line 254 "Nesting.puma" */
  {
/* line 255 "Nesting.puma" */
   failure_protocol (MODULE, "NestOpenUnitObj", unit_obj->Object.decl);
  }
   return;

;
}

void NestCloseUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 270 "Nesting.puma" */
 {
  tDefinitions unit_obj;
  {
/* line 274 "Nesting.puma" */
   unit_obj = GetCurrentUnitObject ();
/* line 276 "Nesting.puma" */
   SetNewUnitEntries (unit_obj, CloseUnitScope (t));
  }
   return;
 }

;
}

void NestCloseUnitObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions unit_obj)
# else
(unit_obj)
 register tDefinitions unit_obj;
# endif
{
/* line 287 "Nesting.puma" */
  {
/* line 289 "Nesting.puma" */
   SetNewUnitEntries (unit_obj, CloseUnitScope (unit_obj->Object.decl));
  }
   return;

;
}

static tDefinitions CloseUnitScope
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 307 "Nesting.puma" */
 {
  tDefinitions Scope;
  {
/* line 311 "Nesting.puma" */
   NestExit (t);
/* line 312 "Nesting.puma" */
   Scope = GetCurrentScope ();
/* line 313 "Nesting.puma" */
   CloseScope ();
/* line 314 "Nesting.puma" */
   DecUnitNest (t);
  }
   return Scope;
 }

}

static void SetNewUnitEntries
# if defined __STDC__ | defined __cplusplus
(register tDefinitions unit_obj, register tDefinitions new_entries)
# else
(unit_obj, new_entries)
 register tDefinitions unit_obj;
 register tDefinitions new_entries;
# endif
{
  if (unit_obj->Kind == kProcObject) {
/* line 327 "Nesting.puma" */
  {
/* line 329 "Nesting.puma" */
   unit_obj->ProcObject.Declarations = new_entries;
  }
   return;

  }
  if (unit_obj->Kind == kFuncObject) {
/* line 332 "Nesting.puma" */
  {
/* line 334 "Nesting.puma" */
   unit_obj->FuncObject.Declarations = new_entries;
  }
   return;

  }
  if (unit_obj->Kind == kBlockObject) {
/* line 337 "Nesting.puma" */
  {
/* line 339 "Nesting.puma" */
   unit_obj->BlockObject.Declarations = new_entries;
  }
   return;

  }
  if (unit_obj->Kind == kModuleObject) {
/* line 342 "Nesting.puma" */
  {
/* line 344 "Nesting.puma" */
   unit_obj->ModuleObject.Declarations = new_entries;
  }
   return;

  }
/* line 347 "Nesting.puma" */
  {
/* line 348 "Nesting.puma" */
   failure_protocol (MODULE, "SetNewUnitEntries", unit_obj->Object.decl);
  }
   return;

;
}

tTree GetCurrentUnit
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 359 "Nesting.puma" */
  {
/* line 360 "Nesting.puma" */
   if (! ((UnitNesting == 0))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 364 "Nesting.puma" */
   return UnitNest [UnitNesting - 1];

}

tDefinitions GetCurrentUnitObject
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 370 "Nesting.puma" */
  {
/* line 371 "Nesting.puma" */
   if (! ((UnitNesting == 0))) goto yyL1;
  }
   return NoObject;
yyL1:;

/* line 375 "Nesting.puma" */
   return UnitObjNest [UnitNesting - 1];

}

int GetCurrentModel
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 381 "Nesting.puma" */
  {
/* line 382 "Nesting.puma" */
   if (! ((target_model == HPF_SERIAL))) goto yyL1;
  }
   return target_model;
yyL1:;

/* line 386 "Nesting.puma" */
  {
/* line 387 "Nesting.puma" */
   if (! ((UnitNesting == 0))) goto yyL2;
  }
   return target_model;
yyL2:;

/* line 391 "Nesting.puma" */
  {
/* line 392 "Nesting.puma" */
   if (! ((IsSerialUnit (UnitNest [UnitNesting - 1])))) goto yyL3;
  }
   return HPF_SERIAL;
yyL3:;

/* line 396 "Nesting.puma" */
  {
/* line 397 "Nesting.puma" */
   if (! ((IsLocalUnit (UnitNest [UnitNesting - 1])))) goto yyL4;
  }
   return HPF_LOCAL;
yyL4:;

/* line 401 "Nesting.puma" */
  {
/* line 402 "Nesting.puma" */
   if (! ((IsTaskUnit (UnitNest [UnitNesting - 1])))) goto yyL5;
  }
   return HPF_TASK;
yyL5:;

/* line 406 "Nesting.puma" */
   return HPF_GLOBAL;

}

void NestOpenType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kRECORD_TYPE) {
/* line 419 "Nesting.puma" */
 {
  tDefinitions tobj;
  {
/* line 423 "Nesting.puma" */
   tobj = GetGlobalObject (t->RECORD_TYPE.Name);
/* line 425 "Nesting.puma" */
   OpenScope (tobj->TypeObject.Components);
  }
   return;
 }

  }
/* line 428 "Nesting.puma" */
  {
/* line 429 "Nesting.puma" */
   failure_protocol (MODULE, "NestOpenType", t);
  }
   return;

;
}

void NestCloseType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kRECORD_TYPE) {
/* line 434 "Nesting.puma" */
  {
/* line 436 "Nesting.puma" */
   CloseScope ();
  }
   return;

  }
/* line 439 "Nesting.puma" */
  {
/* line 440 "Nesting.puma" */
   failure_protocol (MODULE, "NestCloseType", t);
  }
   return;

;
}

void IncLoopNesting
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
/* line 453 "Nesting.puma" */
  {
/* line 455 "Nesting.puma" */
 if (Nesting >= MAXLoops)  
       simple_error_protocol ("to deep loop nesting");
      else
       { Nest [Nesting] = loop;
         Nesting += 1;
       }
   
  }
   return;

;
}

void DecLoopNesting
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
/* line 466 "Nesting.puma" */
  {
/* line 468 "Nesting.puma" */
 if (Nesting == 0)  
       simple_error_protocol ("Nesting : no loop to be quit");
      else if (Nest[Nesting-1] != loop)
       simple_error_protocol ("Nesting : wrong loop to be quit");
      else
       Nesting -= 1;
   
  }
   return;

;
}

int OuterLoops
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 479 "Nesting.puma" */
   return Nesting;

}

tTree GetOuterLoop
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
/* line 485 "Nesting.puma" */
  {
/* line 486 "Nesting.puma" */
   if (! ((n >= 1))) goto yyL1;
  {
/* line 487 "Nesting.puma" */
   if (! ((n <= Nesting))) goto yyL1;
  }
  }
   return Nest [n - 1];
yyL1:;

/* line 491 "Nesting.puma" */
  {
/* line 492 "Nesting.puma" */
   failure_protocol (MODULE, "GetOuterLoop : illegal index", NoTree);
  }
   return NoTree;

}

ptree GetAllOuterLoops
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 498 "Nesting.puma" */
   return Nest;

}

rbool IsCurrentLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
/* line 512 "Nesting.puma" */
 {
  rbool found;
  int i;
  {
/* line 517 "Nesting.puma" */
 

      found = rfalse;
      i     = 0;
      while ((!found) && (i < Nesting))
         { found = IsLoopVarHere (t->USED_VAR.VARNAME, Nest[i]);
           i += 1;
         }
    
/* line 526 "Nesting.puma" */
   if (! (found)) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  }
  if (t->Kind == kLOOP_VAR) {
/* line 529 "Nesting.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsLoopVarHere
# if defined __STDC__ | defined __cplusplus
(register tTree v, register tTree loop)
# else
(v, loop)
 register tTree v;
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_ID->Kind == kLOOP_VAR) {
/* line 540 "Nesting.puma" */
  {
/* line 541 "Nesting.puma" */
   if (! ((EqualExpression (v, loop->ACF_DO.DO_ID->LOOP_VAR.LOOP_VARNAME)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  if (loop->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_ID->Kind == kLOOP_VAR) {
/* line 544 "Nesting.puma" */
  {
/* line 545 "Nesting.puma" */
   if (! ((EqualExpression (v, loop->ACF_FORALL.FORALL_ID->LOOP_VAR.LOOP_VARNAME)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  if (loop->Kind == kDO_EXP) {
  if (loop->DO_EXP.DO_ID->Kind == kLOOP_VAR) {
/* line 548 "Nesting.puma" */
  {
/* line 549 "Nesting.puma" */
   if (! ((EqualExpression (v, loop->DO_EXP.DO_ID->LOOP_VAR.LOOP_VARNAME)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  }
  if (loop->Kind == kDO_VAR) {
  if (loop->DO_VAR.DO_ID->Kind == kLOOP_VAR) {
/* line 552 "Nesting.puma" */
  {
/* line 553 "Nesting.puma" */
   if (! ((EqualExpression (v, loop->DO_VAR.DO_ID->LOOP_VAR.LOOP_VARNAME)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  }
  return rfalse;
}

rbool IsCountLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 566 "Nesting.puma" */
   return rtrue;

  }
  if (loop->Kind == kACF_FORALL) {
/* line 567 "Nesting.puma" */
   return rtrue;

  }
  if (loop->Kind == kDO_EXP) {
/* line 568 "Nesting.puma" */
   return rtrue;

  }
  if (loop->Kind == kDO_VAR) {
/* line 569 "Nesting.puma" */
   return rtrue;

  }
  return rfalse;
}

tTree GetLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 573 "Nesting.puma" */
   return loop->ACF_DO.DO_ID;

  }
  if (loop->Kind == kACF_FORALL) {
/* line 574 "Nesting.puma" */
   return loop->ACF_FORALL.FORALL_ID;

  }
  if (loop->Kind == kDO_EXP) {
/* line 575 "Nesting.puma" */
   return loop->DO_EXP.DO_ID;

  }
  if (loop->Kind == kDO_VAR) {
/* line 576 "Nesting.puma" */
   return loop->DO_VAR.DO_ID;

  }
/* line 578 "Nesting.puma" */
  {
/* line 579 "Nesting.puma" */
   failure_protocol (MODULE, "GetLoopId", loop);
  }
   return NoTree;

}

tTree GetLoopSlice
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 585 "Nesting.puma" */
   return loop->ACF_DO.DO_RANGE;

  }
  if (loop->Kind == kACF_FORALL) {
/* line 586 "Nesting.puma" */
   return loop->ACF_FORALL.FORALL_RANGE;

  }
  if (loop->Kind == kDO_EXP) {
/* line 587 "Nesting.puma" */
   return loop->DO_EXP.RANGE;

  }
  if (loop->Kind == kDO_VAR) {
/* line 588 "Nesting.puma" */
   return loop->DO_VAR.RANGE;

  }
/* line 590 "Nesting.puma" */
  {
/* line 591 "Nesting.puma" */
   failure_protocol (MODULE, "GetLoopSlice", loop);
  }
   return NoTree;

}

void GetLoopIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree t, register rbool * yyP2, register int * yyP1)
# else
(t, yyP2, yyP1)
 register tTree t;
 register rbool * yyP2;
 register int * yyP1;
# endif
{
  if (t->Kind == kSLICE_EXP) {
/* line 603 "Nesting.puma" */
  {
/* line 605 "Nesting.puma" */
   if (! ((t->SLICE_EXP.INC == NoTree))) goto yyL1;
  }
   * yyP2 = rtrue;
   * yyP1 = 1;
   return;
yyL1:;

  if (t->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
/* line 608 "Nesting.puma" */
   * yyP2 = rtrue;
   * yyP1 = 1;
   return;

  }
/* line 611 "Nesting.puma" */
 {
  rbool found;
  int val;
  {
/* line 615 "Nesting.puma" */
   GetIntConstValue (t->SLICE_EXP.INC, & found, & val);
/* line 616 "Nesting.puma" */
   if (! ((found))) goto yyL3;
  }
   * yyP2 = rtrue;
   * yyP1 = val;
   return;
 }
yyL3:;

/* line 619 "Nesting.puma" */
   * yyP2 = rfalse;
   * yyP1 = 1;
   return;

  }
  if (t->Kind == kACF_DO) {
/* line 622 "Nesting.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 624 "Nesting.puma" */
   GetLoopIncrement (t->ACF_DO.DO_RANGE, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (t->Kind == kACF_FORALL) {
/* line 627 "Nesting.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 629 "Nesting.puma" */
   GetLoopIncrement (t->ACF_FORALL.FORALL_RANGE, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
/* line 632 "Nesting.puma" */
  {
/* line 634 "Nesting.puma" */
   failure_protocol (MODULE, "GetLoopIncrement", t);
  }
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

;
}

void BeginNesting ARGS ((void))
{
}

void CloseNesting ARGS ((void))
{
}
