# include "MoveDescriptor.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 52 "MoveDescriptor.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "TreeOps.h"        /* IsSelector         */
# include "Rank.h"
# include "AlignCheck.h"     /* GetSimpleAlignment */

# include "Descriptor.h"     /* MakeTemplateDescriptor */
# include "Expressions.h"    /* IsStride1              */
# include "HomeDescriptor.h"

# define MODULE "MoveDescriptor"

# undef DEBUG

/********************************************************************
*                                                                   *
*  IndexDifference (A1(..., l1:u1:s1, ...], A2(...,l2:u2:s2,...)    *
*                                                                   *
*  - tries to find an compile time constant for the difference      *
*    between the two index expressions                              *
*                                                                   *
*  - important : if index expressions are slices they must          *
*                have the same rank position                        *
*                                                                   *
********************************************************************/

static rbool ActShapeIsSlice (vd, ind)

pvar vd;
int  ind;

/* returns rtrue if actual index at position ind (1..act_rank) is slice */

{ tTree lb;

  lb = vd->actual_shape[ind-1][0];

  if (lb == NoTree) return (rtrue);       /* full shape             */

  if (IsSelector (lb)) return (rfalse);   /* selection of component */

  if (lb != vd->actual_shape[ind-1][1])
     return (rtrue);
  if (TreeRank (lb) > 0)
     return (rtrue);
  return (rfalse);

} /* ActShapeIsSlice */

/* help function : returns rank position of index

   0                       : if actual index is scalar
   1 <= val <= actual_rank : if actual index is slice

*/

/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/

static int IndexRankPos (vd, ind)

pvar vd;
int  ind;

{ int i, act_rank, pos_rank;;

  pos_rank = 0;
  act_rank = 0;

  for (i=0; i<vd->formal_rank; i++)

    { /* increase act_rank if slice */

      if (ActShapeIsSlice (vd, i+1))
         { act_rank ++;
           if (ind-1 == i)
              pos_rank = act_rank;
         }
    } /* for loop */

  if (act_rank != vd->actual_rank)
     { printf ("serious error for actual rank of array descriptor\n");
       PrintVarDescriptor (vd);
       printf ("index : %d, act_rank = %d, pos_rank = %d, \n",
               ind, act_rank, pos_rank);
       kill_in_protocol ();
     }

  return (pos_rank);

} /* IndexRankPos */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMoveDescriptor.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MoveDescriptor_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MoveDescriptor, routine %s failed\n",
  yyFunction);
 MoveDescriptor_Exit ();
}

void PrintShifting ARGS ((pshift s));
rbool VDIsShifting ARGS ((pvar d1, pvar d2, pshift sv));
rbool VDIsSame ARGS ((pvar d1, pvar d2));
rbool VDIsSubSet ARGS ((pvar vard1, pvar vard2));
void VDIsTopDimAligned ARGS ((pvar vard1, pvar vard2, int top_dim, rbool * yyP2, int * yyP1));
static void IndexDifference ARGS ((pvar vard1, int idim1, pvar vard2, int idim2, rbool * yyP4, int * yyP3));
rbool VDIsSubTopDim ARGS ((pvar vard1, pvar vard2, int top_dim));
static rbool VDHasFullIndexDim ARGS ((pvar vard, int index_dim));
static rbool IsTheFormalRange ARGS ((tTree actual, tTree formal));
rbool VDIsAligned ARGS ((pvar vard1, pvar vard2));
static rbool VDFullAlignedDim ARGS ((pvar vard1, pvar vard2, int top_dim));
static rbool SameDistribution ARGS ((pvar vard1, pvar vard2, int top_dim));
static rbool SameDistributionKind ARGS ((int kind1, int kind2));
static rbool SameDistributionSize ARGS ((tTree size1, tTree size2));

void PrintShifting
# if defined __STDC__ | defined __cplusplus
(pshift s)
# else
(s)
 pshift s;
# endif
{
/* line 163 "MoveDescriptor.puma" */
 {
  int i;
  {
/* line 166 "MoveDescriptor.puma" */
 printf ("Shifting, rank = %d, pos = [", s->shift_rank);
     for (i=0; i<s->shift_rank; i++)
         printf (" %d", s->shift_pos[i]);
     printf (" ]\n");
   
  }
   return;
 }

;
}

rbool VDIsShifting
# if defined __STDC__ | defined __cplusplus
(pvar d1, pvar d2, pshift sv)
# else
(d1, d2, sv)
 pvar d1;
 pvar d2;
 pshift sv;
# endif
{
/* line 191 "MoveDescriptor.puma" */
 {
  int top_rank;
  int top_dim;
  rbool found;
  {
/* line 201 "MoveDescriptor.puma" */
   if (! ((SameDescriptorTopology (d1, d2)))) goto yyL1;
  {
/* line 205 "MoveDescriptor.puma" */
   MakeTemplateDescriptor (d1);
/* line 206 "MoveDescriptor.puma" */
   MakeTemplateDescriptor (d2);
/* line 214 "MoveDescriptor.puma" */
 found = rtrue;
 
    sv->shift_rank = d2->formal_rank;

    for (top_dim = 0; top_dim < sv->shift_rank; top_dim++)
       sv->shift_pos [top_dim] = 0;

    top_rank = d2->topology_rank;

    for (top_dim = 0; top_dim < top_rank; top_dim++)

      { int  val;
        rbool ok;

        VDIsTopDimAligned (d1, d2, top_dim+1, &ok, &val);

#ifdef DEBUG
        printf ("top dim align of top_dim = %d returns ok = %d, val = %d\n",
                 top_dim, ok, val);
#endif
 
        

        if (ok && (val != 0))

           { int ind2;

             ind2 = d2->on_index_dim[top_dim];

             switch (d2->distribution_kind[ind2-1]) {

             case kBLOCK_DIM         :  sv->shift_pos[ind2-1] = val; break;
             case kGEN_BLOCK_DIM     :  sv->shift_pos[ind2-1] = val; break;
             case kANY_GEN_BLOCK_DIM :  sv->shift_pos[ind2-1] = val; break;
             case kANY_BLOCK_DIM     :  sv->shift_pos[ind2-1] = val; break;

             default : ok = rfalse;

             } 

           }

        found = found && ok;                
      }
 
  
/* line 261 "MoveDescriptor.puma" */
   if (! ((found))) goto yyL1;
  }
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

rbool VDIsSame
# if defined __STDC__ | defined __cplusplus
(pvar d1, pvar d2)
# else
(d1, d2)
 pvar d1;
 pvar d2;
# endif
{
/* line 272 "MoveDescriptor.puma" */
  {
/* line 274 "MoveDescriptor.puma" */
   if (! ((VDIsSubSet (d1, d2)))) goto yyL1;
  {
/* line 275 "MoveDescriptor.puma" */
   if (! ((VDIsSubSet (d2, d1)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool VDIsSubSet
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
/* line 291 "MoveDescriptor.puma" */
  {
/* line 294 "MoveDescriptor.puma" */
   if (! ((IsReplicatedDescriptor (vard2)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 297 "MoveDescriptor.puma" */
  {
/* line 299 "MoveDescriptor.puma" */
   if (! ((IsNoDescriptor (vard1)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 302 "MoveDescriptor.puma" */
  {
/* line 304 "MoveDescriptor.puma" */
   if (! ((IsNoDescriptor (vard2)))) goto yyL3;
  {
/* line 306 "MoveDescriptor.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 309 "MoveDescriptor.puma" */
 {
  rbool okay;
  int dim;
  int rank;
  {
/* line 311 "MoveDescriptor.puma" */
   if (! ((SameDescriptorTopology (vard1, vard2)))) goto yyL4;
  {
/* line 315 "MoveDescriptor.puma" */
   MakeTemplateDescriptor (vard1);
/* line 316 "MoveDescriptor.puma" */
   MakeTemplateDescriptor (vard2);
/* line 322 "MoveDescriptor.puma" */
 okay = rtrue;

#ifdef DEBUG
     printf ("VDIsSubset vard1 of vard2\n");
     PrintVarDescriptor (vard1);
     PrintVarDescriptor (vard2);
#endif

     rank = vard1->topology_rank;

     if (vard1->topology_obj != NoObject)

       { if (rank != VarRank (vard1->topology_obj))

           { printf ("vard->rank = %d, vard->topology = %d (rank = %d)\n",
             rank, vard1->topology_obj, VarRank (vard1->topology_obj));
             obj_protocol ("illegal topolgy : ", vard1->topology_obj);
             failure_protocol (MODULE, "VDIsSubset", NoTree);
           }
       };

     for (dim = 1; dim <= rank; dim ++)

      { 

        okay = okay && VDIsSubTopDim (vard1, vard2, dim);

      }

#ifdef DEBUG
      printf ("is subset = %d\n", okay);
#endif

   
/* line 357 "MoveDescriptor.puma" */
   if (! ((okay))) goto yyL4;
  }
  }
   return rtrue;
 }
yyL4:;

  return rfalse;
}

void VDIsTopDimAligned
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim, register rbool * yyP2, register int * yyP1)
# else
(vard1, vard2, top_dim, yyP2, yyP1)
 pvar vard1;
 pvar vard2;
 register int top_dim;
 register rbool * yyP2;
 register int * yyP1;
# endif
{
/* line 374 "MoveDescriptor.puma" */
  {
/* line 378 "MoveDescriptor.puma" */
   if (! ((vard2 -> on_index_dim [top_dim - 1] == 0))) goto yyL1;
  }
   * yyP2 = rtrue;
   * yyP1 = 0;
   return;
yyL1:;

/* line 381 "MoveDescriptor.puma" */
 {
  int idim2;
  {
/* line 385 "MoveDescriptor.puma" */
   idim2 = vard2 -> on_index_dim [top_dim - 1];
/* line 387 "MoveDescriptor.puma" */
   if (! (VDHasFullIndexDim (vard2, idim2))) goto yyL2;
  }
   * yyP2 = rtrue;
   * yyP1 = 0;
   return;
 }
yyL2:;

/* line 390 "MoveDescriptor.puma" */
 {
  int idim1;
  int idim2;
  rbool yyV1;
  int yyV2;
  {
/* line 392 "MoveDescriptor.puma" */
   if (! ((vard1 -> on_kind [top_dim - 1] == vard2 -> on_kind [top_dim - 1]))) goto yyL3;
  {
/* line 397 "MoveDescriptor.puma" */
   idim1 = vard1 -> on_index_dim [top_dim - 1];
/* line 398 "MoveDescriptor.puma" */
   idim2 = vard2 -> on_index_dim [top_dim - 1];
/* line 400 "MoveDescriptor.puma" */
   if (! ((idim1 > 0))) goto yyL3;
  {
/* line 401 "MoveDescriptor.puma" */
   if (! ((idim2 > 0))) goto yyL3;
  {
/* line 403 "MoveDescriptor.puma" */
   IndexDifference (vard1, idim1, vard2, idim2, & yyV1, & yyV2);
  }
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

/* line 406 "MoveDescriptor.puma" */
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

;
}

static void IndexDifference
# if defined __STDC__ | defined __cplusplus
(pvar vard1, register int idim1, pvar vard2, register int idim2, register rbool * yyP4, register int * yyP3)
# else
(vard1, idim1, vard2, idim2, yyP4, yyP3)
 pvar vard1;
 register int idim1;
 pvar vard2;
 register int idim2;
 register rbool * yyP4;
 register int * yyP3;
# endif
{
/* line 412 "MoveDescriptor.puma" */
 {
  rbool found;
  int val;
  {
/* line 414 "MoveDescriptor.puma" */
   if (! ((IndexRankPos (vard1, idim1) == IndexRankPos (vard2, idim2)))) goto yyL1;
  {
/* line 419 "MoveDescriptor.puma" */
   GetSimpleAlignment (vard1, idim1, vard2, idim2, & found, & val);
  }
  }
   * yyP4 = found;
   * yyP3 = val;
   return;
 }
yyL1:;

/* line 422 "MoveDescriptor.puma" */
   * yyP4 = rfalse;
   * yyP3 = 0;
   return;

;
}

rbool VDIsSubTopDim
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim)
# else
(vard1, vard2, top_dim)
 pvar vard1;
 pvar vard2;
 register int top_dim;
# endif
{
/* line 433 "MoveDescriptor.puma" */
  {
/* line 435 "MoveDescriptor.puma" */
   if (! ((vard2 -> on_index_dim [top_dim - 1] == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 438 "MoveDescriptor.puma" */
 {
  int idim2;
  {
/* line 442 "MoveDescriptor.puma" */
   idim2 = vard2 -> on_index_dim [top_dim - 1];
/* line 444 "MoveDescriptor.puma" */
   if (! (VDHasFullIndexDim (vard2, idim2))) goto yyL2;
  }
   return rtrue;
 }
yyL2:;

/* line 447 "MoveDescriptor.puma" */
 {
  int idim1;
  int idim2;
  rbool found;
  int val;
  {
/* line 449 "MoveDescriptor.puma" */
   if (! ((vard1 -> on_kind [top_dim - 1] == vard2 -> on_kind [top_dim - 1]))) goto yyL3;
  {
/* line 454 "MoveDescriptor.puma" */
   idim1 = vard1 -> on_index_dim [top_dim - 1];
/* line 455 "MoveDescriptor.puma" */
   idim2 = vard2 -> on_index_dim [top_dim - 1];
/* line 457 "MoveDescriptor.puma" */
   if (! ((idim1 > 0))) goto yyL3;
  {
/* line 458 "MoveDescriptor.puma" */
   if (! ((idim2 > 0))) goto yyL3;
  {
/* line 463 "MoveDescriptor.puma" */
   GetSimpleAlignment (vard1, idim1, vard2, idim2, & found, & val);
/* line 465 "MoveDescriptor.puma" */
   if (! ((found))) goto yyL3;
  {
/* line 466 "MoveDescriptor.puma" */
   if (! ((val == 0))) goto yyL3;
  }
  }
  }
  }
  }
   return rtrue;
 }
yyL3:;

  return rfalse;
}

static rbool VDHasFullIndexDim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int index_dim)
# else
(vard, index_dim)
 pvar vard;
 register int index_dim;
# endif
{
/* line 477 "MoveDescriptor.puma" */
 {
  rbool okay;
  {
/* line 483 "MoveDescriptor.puma" */
 tTree a_lb, a_ub, a_inc;
     tTree f_lb, f_ub;

     a_lb  = vard->actual_shape[index_dim-1][0];
     a_ub  = vard->actual_shape[index_dim-1][1];
     a_inc = vard->actual_shape[index_dim-1][2];

     f_lb  = vard->formal_shape[index_dim-1][0];
     f_ub  = vard->formal_shape[index_dim-1][1];

     okay = IsTheFormalRange (a_lb, f_lb) &&
            IsTheFormalRange (a_ub, f_ub) &&
            IsStride1 (a_inc);

   
/* line 499 "MoveDescriptor.puma" */
   if (! ((okay))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static rbool IsTheFormalRange
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree formal)
# else
(actual, formal)
 register tTree actual;
 register tTree formal;
# endif
{
/* line 525 "MoveDescriptor.puma" */
  {
/* line 527 "MoveDescriptor.puma" */
   if (! ((formal == NoTree))) goto yyL1;
  {
/* line 529 "MoveDescriptor.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 532 "MoveDescriptor.puma" */
  {
/* line 534 "MoveDescriptor.puma" */
   if (! ((actual == NoTree))) goto yyL2;
  }
   return rtrue;
yyL2:;

  if (actual->Kind == kDUMMY_EXP) {
/* line 537 "MoveDescriptor.puma" */
   return rtrue;

  }
/* line 540 "MoveDescriptor.puma" */
  {
/* line 542 "MoveDescriptor.puma" */
   if (! ((EqualExpression (actual, formal)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  return rfalse;
}

rbool VDIsAligned
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
/* line 562 "MoveDescriptor.puma" */
  {
/* line 564 "MoveDescriptor.puma" */
   if (! ((IsReplicatedDescriptor (vard1)))) goto yyL1;
  {
/* line 565 "MoveDescriptor.puma" */
   if (! ((IsReplicatedDescriptor (vard2)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 568 "MoveDescriptor.puma" */
  {
/* line 570 "MoveDescriptor.puma" */
   if (! ((IsHostDescriptor (vard1)))) goto yyL2;
  {
/* line 571 "MoveDescriptor.puma" */
   if (! ((IsHostDescriptor (vard2)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 574 "MoveDescriptor.puma" */
 {
  rbool okay;
  int dim;
  {
/* line 576 "MoveDescriptor.puma" */
   if (! ((SameDescriptorTopology (vard1, vard2)))) goto yyL3;
  {
/* line 582 "MoveDescriptor.puma" */
   MakeTemplateDescriptor (vard1);
/* line 583 "MoveDescriptor.puma" */
   MakeTemplateDescriptor (vard2);
/* line 588 "MoveDescriptor.puma" */
 okay = rtrue;

     for (dim = 1; dim <= vard1->topology_rank; dim ++)

      { 

        okay = okay && VDFullAlignedDim (vard1, vard2, dim);

      }

   
/* line 600 "MoveDescriptor.puma" */
   if (! ((okay))) goto yyL3;
  }
  }
   return rtrue;
 }
yyL3:;

  return rfalse;
}

static rbool VDFullAlignedDim
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim)
# else
(vard1, vard2, top_dim)
 pvar vard1;
 pvar vard2;
 register int top_dim;
# endif
{
/* line 605 "MoveDescriptor.puma" */
  {
/* line 609 "MoveDescriptor.puma" */
   if (! ((vard1 -> on_val [top_dim - 1] == NoTree))) goto yyL1;
  {
/* line 610 "MoveDescriptor.puma" */
   if (! ((vard2 -> on_val [top_dim - 1] == NoTree))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 613 "MoveDescriptor.puma" */
 {
  int idim1;
  int idim2;
  rbool yyV1;
  int yyV2;
  {
/* line 615 "MoveDescriptor.puma" */
   if (! ((SameDistribution (vard1, vard2, top_dim)))) goto yyL2;
  {
/* line 620 "MoveDescriptor.puma" */
   idim1 = vard1 -> on_index_dim [top_dim - 1];
/* line 621 "MoveDescriptor.puma" */
   idim2 = vard2 -> on_index_dim [top_dim - 1];
/* line 623 "MoveDescriptor.puma" */
   if (! ((idim1 > 0))) goto yyL2;
  {
/* line 624 "MoveDescriptor.puma" */
   if (! ((idim2 > 0))) goto yyL2;
  {
/* line 626 "MoveDescriptor.puma" */
   IndexDifference (vard1, idim1, vard2, idim2, & yyV1, & yyV2);
/* line 628 "MoveDescriptor.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 629 "MoveDescriptor.puma" */
   if (! ((yyV2 == 0))) goto yyL2;
  }
  }
  }
  }
  }
   return rtrue;
 }
yyL2:;

  return rfalse;
}

static rbool SameDistribution
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim)
# else
(vard1, vard2, top_dim)
 pvar vard1;
 pvar vard2;
 register int top_dim;
# endif
{
/* line 640 "MoveDescriptor.puma" */
  {
/* line 642 "MoveDescriptor.puma" */
   if (! ((vard1 -> template_obj == vard2 -> template_obj))) goto yyL1;
  {
/* line 643 "MoveDescriptor.puma" */
   if (! ((vard1 -> template_obj != NoObject))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 646 "MoveDescriptor.puma" */
  {
/* line 648 "MoveDescriptor.puma" */
   if (! ((vard1 -> topology_obj == vard2 -> topology_obj))) goto yyL2;
  {
/* line 649 "MoveDescriptor.puma" */
   if (! ((vard1 -> topology_obj != NoObject))) goto yyL2;
  {
/* line 651 "MoveDescriptor.puma" */
   if (! ((SameDistributionKind (vard1 -> on_kind [top_dim - 1], vard2 -> on_kind [top_dim - 1])))) goto yyL2;
  {
/* line 654 "MoveDescriptor.puma" */
   if (! ((SameDistributionSize (vard1 -> on_size [top_dim - 1], vard2 -> on_size [top_dim - 1])))) goto yyL2;
  }
  }
  }
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static rbool SameDistributionKind
# if defined __STDC__ | defined __cplusplus
(register int kind1, register int kind2)
# else
(kind1, kind2)
 register int kind1;
 register int kind2;
# endif
{
/* line 668 "MoveDescriptor.puma" */
  {
/* line 670 "MoveDescriptor.puma" */
   if (! ((kind1 == kBLOCK_DIM))) goto yyL1;
  {
/* line 671 "MoveDescriptor.puma" */
   if (! ((kind2 == kBLOCK_DIM))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 674 "MoveDescriptor.puma" */
  {
/* line 676 "MoveDescriptor.puma" */
   if (! ((kind1 == kCYCLIC_DIM))) goto yyL2;
  {
/* line 677 "MoveDescriptor.puma" */
   if (! ((kind2 == kCYCLIC_DIM))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 680 "MoveDescriptor.puma" */
  {
/* line 682 "MoveDescriptor.puma" */
   if (! ((kind1 == kGEN_BLOCK_DIM))) goto yyL3;
  {
/* line 683 "MoveDescriptor.puma" */
   if (! ((kind2 == kGEN_BLOCK_DIM))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

/* line 686 "MoveDescriptor.puma" */
  {
/* line 688 "MoveDescriptor.puma" */
   if (! ((kind1 == kINDIRECT_DIM))) goto yyL4;
  {
/* line 689 "MoveDescriptor.puma" */
   if (! ((kind2 == kINDIRECT_DIM))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

  return rfalse;
}

static rbool SameDistributionSize
# if defined __STDC__ | defined __cplusplus
(register tTree size1, register tTree size2)
# else
(size1, size2)
 register tTree size1;
 register tTree size2;
# endif
{
/* line 702 "MoveDescriptor.puma" */
  {
/* line 704 "MoveDescriptor.puma" */
   if (! ((size1 == NoTree))) goto yyL1;
  {
/* line 705 "MoveDescriptor.puma" */
   if (! ((size2 == NoTree))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 708 "MoveDescriptor.puma" */
  {
/* line 710 "MoveDescriptor.puma" */
   if (! ((size1 != NoTree))) goto yyL2;
  {
/* line 711 "MoveDescriptor.puma" */
   if (! ((size2 != NoTree))) goto yyL2;
  {
/* line 712 "MoveDescriptor.puma" */
   if (! ((EqualExpression (size1, size2)))) goto yyL2;
  }
  }
  }
   return rtrue;
yyL2:;

  return rfalse;
}

void BeginMoveDescriptor ARGS ((void))
{
}

void CloseMoveDescriptor ARGS ((void))
{
}
