# include "MoveControl.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 94 "MoveControl.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "Types.h"
# include "Distributions.h"

# include "DefTable.h"

# include "Expressions.h"    /* AddConstant        */
# include "Types.h"          /* ArrayFormals       */

# include "AlignCheck.h"     /* GetSimpleAlignment */
# include "Nesting.h"        /* GetCurrentUnit     */
# include "Intrinsics.h"     /* IntrFuncElemental  */

# include "Descriptor.h"
# include "ExpDescriptor.h"   /*  GetVarDescriptor     */
# include "MoveDescriptor.h"  /*  VDIsShifting, pshift */
# include "HomeDescriptor.h"  /*  VDIsShifting, pshift */
# include "Objects.h"
# include "Rank.h"
# include "protocol.h"

# define MODULE "MoveControl"

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMoveControl.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MoveControl_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MoveControl, routine %s failed\n",
  yyFunction);
 MoveControl_Exit ();
}

static rbool EnoughVDOverlapArea ARGS ((pvar vard, pshift pv));
rbool VDHasLocalCopy ARGS ((pvar home, pvar var));
rbool VDIsOwner ARGS ((pvar home, pvar var));
rbool VDIsSingleOwner ARGS ((pvar home, pvar var));
int CountCommunication ARGS ((pvar home, tTree exp));
static int CountVarIndexCommunication ARGS ((pvar home, tTree var));
int CountMovements ARGS ((tTree var, tTree exp));
static int CountSpreadMovements ARGS ((tTree var, tTree params));
static int CountSpreadVarMovements ARGS ((tTree var, tTree array, int dim));
rbool SpreadAligned ARGS ((tTree var, tTree maj_var, int dim));
void GetMajorityVar ARGS ((tTree exp, int * flag, tTree * var));
void GetMajorityVar2 ARGS ((tTree exp1, tTree exp2, int * yyP2, tTree * yyP1));
static void MergeMajorityVars ARGS ((int yyP6, tTree yyP5, int yyP4, tTree yyP3, int * yyP8, tTree * yyP7));
static rbool HigherRank ARGS ((tTree var1, tTree var2));
int CountVarMovements ARGS ((tTree var, tTree var1));
static rbool IsLocalAssignment ARGS ((tTree lvar, int lvardist, tTree rvar, int rvardist));
rbool VDIsLocalAssignment ARGS ((pvar lvar, pvar rvar));
static rbool ReplicatedIndexes ARGS ((tTree var));
void GetShifting ARGS ((tTree lvar, tTree rvar, rbool * yyP10, shift_vector * yyP9));
void GetCircularShifting ARGS ((tTree exp, rbool * yyP13, tTree * yyP12, shift_vector * yyP11));
static void ResolveCShiftParams ARGS ((tTree params, tTree * yyP16, int * yyP15, int * yyP14));
static void FindVarShift ARGS ((tTree var, rbool * yyP19, tTree * yyP18, shift_vector * yyP17));
static rbool AreDimsShiftable ARGS ((tTree var, pshift sv));
static rbool ActualEqFormal ARGS ((tTree formal_exp, tTree actual_exp));
static int GetIndexPosition ARGS ((tTree indexes, int dim));
rbool EnoughOverlapArea ARGS ((tTree var, pshift pos));
static rbool IsEnoughVarOverlap ARGS ((tTree shadow_specs, int dim, pshift pos));
static rbool SufficientOverlapIndex ARGS ((tTree index, int pos));
rbool SameDistribution ARGS ((tDefinitions actual, tDefinitions formal));
static rbool SameDescriptorDistribution ARGS ((pvar vard1, pvar vard2));
static void FindLegalVarDescriptor ARGS ((tTree var, rbool * yyP21, var_descriptor * yyP20));

static rbool EnoughVDOverlapArea
# if defined __STDC__ | defined __cplusplus
(pvar vard, pshift pv)
# else
(vard, pv)
 pvar vard;
 pshift pv;
# endif
{
/* line 136 "MoveControl.puma" */
  {
/* line 138 "MoveControl.puma" */
   if (! ((IsZeroShifting (pv)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 141 "MoveControl.puma" */
  {
/* line 143 "MoveControl.puma" */
   if (! ((vard -> var_tree != NoTree))) goto yyL2;
  {
/* line 144 "MoveControl.puma" */
   if (! ((EnoughOverlapArea (vard -> var_tree, pv)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  return rfalse;
}

rbool VDHasLocalCopy
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar var)
# else
(home, var)
 pvar home;
 pvar var;
# endif
{
/* line 164 "MoveControl.puma" */
  {
/* line 166 "MoveControl.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 169 "MoveControl.puma" */
  {
/* line 171 "MoveControl.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 174 "MoveControl.puma" */
  {
/* line 178 "MoveControl.puma" */
   if (! ((var -> topology_obj == GetDefaultTopology (0)))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 181 "MoveControl.puma" */
  {
/* line 185 "MoveControl.puma" */
   if (! ((var -> shared == 1))) goto yyL4;
  }
   return rtrue;
yyL4:;

/* line 188 "MoveControl.puma" */
 {
  shift_vector pv;
  {
/* line 190 "MoveControl.puma" */
   if (! ((home -> topology_rank > 0))) goto yyL5;
  {
/* line 191 "MoveControl.puma" */
   if (! ((var -> topology_rank > 0))) goto yyL5;
  {
/* line 195 "MoveControl.puma" */
   if (! ((VDIsShifting (home, var, & pv)))) goto yyL5;
  {
/* line 197 "MoveControl.puma" */

#ifdef DEBUG
   print_shift ("VDShifting found", &pv);
#endif
   
/* line 203 "MoveControl.puma" */
   if (! (EnoughVDOverlapArea (var, & pv))) goto yyL5;
  }
  }
  }
  }
   return rtrue;
 }
yyL5:;

  return rfalse;
}

rbool VDIsOwner
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar var)
# else
(home, var)
 pvar home;
 pvar var;
# endif
{
/* line 222 "MoveControl.puma" */
  {
/* line 224 "MoveControl.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 227 "MoveControl.puma" */
  {
/* line 229 "MoveControl.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 232 "MoveControl.puma" */
  {
/* line 236 "MoveControl.puma" */
   if (! ((var -> topology_obj == GetDefaultTopology (0)))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 239 "MoveControl.puma" */
  {
/* line 243 "MoveControl.puma" */
   if (! ((var -> shared == 1))) goto yyL4;
  }
   return rtrue;
yyL4:;

/* line 246 "MoveControl.puma" */
  {
/* line 248 "MoveControl.puma" */
   if (! ((home -> topology_rank == - 1))) goto yyL5;
  {
/* line 249 "MoveControl.puma" */
   if (! ((var -> topology_rank == - 1))) goto yyL5;
  }
  }
   return rtrue;
yyL5:;

/* line 252 "MoveControl.puma" */
 {
  shift_vector pv;
  {
/* line 254 "MoveControl.puma" */
   if (! ((home -> topology_rank > 0))) goto yyL6;
  {
/* line 255 "MoveControl.puma" */
   if (! ((var -> topology_rank > 0))) goto yyL6;
  {
/* line 259 "MoveControl.puma" */
   if (! ((VDIsShifting (home, var, & pv)))) goto yyL6;
  {
/* line 260 "MoveControl.puma" */
   if (! ((IsZeroShifting (& pv)))) goto yyL6;
  }
  }
  }
  }
   return rtrue;
 }
yyL6:;

  return rfalse;
}

rbool VDIsSingleOwner
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar var)
# else
(home, var)
 pvar home;
 pvar var;
# endif
{
/* line 278 "MoveControl.puma" */
  {
/* line 280 "MoveControl.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 283 "MoveControl.puma" */
  {
/* line 285 "MoveControl.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 288 "MoveControl.puma" */
  {
/* line 290 "MoveControl.puma" */
   if (! ((home -> topology_obj == GetDefaultTopology (0)))) goto yyL3;
  {
/* line 291 "MoveControl.puma" */
   if (! ((var -> topology_obj == GetDefaultTopology (0)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

/* line 294 "MoveControl.puma" */
  {
/* line 298 "MoveControl.puma" */
   if (! ((var -> shared == 1))) goto yyL4;
  {
/* line 299 "MoveControl.puma" */
   if (! ((IsSerialDescriptor (home)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

/* line 302 "MoveControl.puma" */
 {
  shift_vector pv;
  {
/* line 304 "MoveControl.puma" */
   if (! ((home -> topology_rank > 0))) goto yyL5;
  {
/* line 305 "MoveControl.puma" */
   if (! ((var -> topology_rank > 0))) goto yyL5;
  {
/* line 309 "MoveControl.puma" */
   if (! ((VDIsShifting (home, var, & pv)))) goto yyL5;
  {
/* line 310 "MoveControl.puma" */
   if (! ((IsZeroShifting (& pv)))) goto yyL5;
  {
/* line 311 "MoveControl.puma" */
   if (! ((VDIsShifting (var, home, & pv)))) goto yyL5;
  {
/* line 312 "MoveControl.puma" */
   if (! ((IsZeroShifting (& pv)))) goto yyL5;
  }
  }
  }
  }
  }
  }
   return rtrue;
 }
yyL5:;

  return rfalse;
}

int CountCommunication
# if defined __STDC__ | defined __cplusplus
(pvar home, register tTree exp)
# else
(home, exp)
 pvar home;
 register tTree exp;
# endif
{
 yyRecursion:

  switch (exp->Kind) {
  case kADDR:
/* line 325 "MoveControl.puma" */
   exp = exp->ADDR.E;
   goto yyRecursion;

  case kBT_VAR:
  case kDUMMY_VAR:
  case kUSED_VAR:
  case kINDEXED_VAR:
  case kSUBSTRING_VAR:
  case kSELECTED_VAR:
  case kLOOP_VAR:
  case kPERM_VAR:
  case kDO_VAR:
  case kREMOTE_VAR:
/* line 330 "MoveControl.puma" */
 {
  var_descriptor vard;
  {
/* line 334 "MoveControl.puma" */
   SetVarDescriptor (exp, & vard);
/* line 336 "MoveControl.puma" */
   if (! ((VDHasLocalCopy (home, & vard)))) goto yyL2;
  }
   return CountVarIndexCommunication (home, exp);
 }
yyL2:;

/* line 341 "MoveControl.puma" */
   return 1 + CountVarIndexCommunication (home, exp);

  case kDUMMY_EXP:
/* line 348 "MoveControl.puma" */
   return 0;

  case kCONST_EXP:
/* line 353 "MoveControl.puma" */
   return 0;

  case kBOUND_EXP:
/* line 358 "MoveControl.puma" */
   return 0;

  case kRANK_EXP:
/* line 363 "MoveControl.puma" */
   return 0;

  case kARRAY_EXP:
/* line 368 "MoveControl.puma" */
   exp = exp->ARRAY_EXP.ELEMENTS;
   goto yyRecursion;

  case kTYPE_EXP:
/* line 373 "MoveControl.puma" */
   exp = exp->TYPE_EXP.ELEMENTS;
   goto yyRecursion;

  case kDO_EXP:
/* line 378 "MoveControl.puma" */
   return CountCommunication (home, exp->DO_EXP.RANGE) + CountCommunication (home, exp->DO_EXP.BODY);

  case kSLICE_EXP:
/* line 383 "MoveControl.puma" */
   return CountCommunication (home, exp->SLICE_EXP.FIRST) + CountCommunication (home, exp->SLICE_EXP.STOP) + CountCommunication (home, exp->SLICE_EXP.INC);

  case kOP_EXP:
/* line 390 "MoveControl.puma" */
   return CountCommunication (home, exp->OP_EXP.OPND1) + CountCommunication (home, exp->OP_EXP.OPND2);

  case kOP1_EXP:
/* line 395 "MoveControl.puma" */
   exp = exp->OP1_EXP.OPND;
   goto yyRecursion;

  case kPERM_EXP:
/* line 400 "MoveControl.puma" */
   return CountCommunication (home, exp->PERM_EXP.VAL) + 1;

  case kVAR_EXP:
/* line 405 "MoveControl.puma" */
   exp = exp->VAR_EXP.V;
   goto yyRecursion;

  case kFUNC_CALL_EXP:
/* line 410 "MoveControl.puma" */
   exp = exp->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;

  case kBTE_LIST:
/* line 415 "MoveControl.puma" */
   return CountCommunication (home, exp->BTE_LIST.Elem) + CountCommunication (home, exp->BTE_LIST.Next);

  case kBTE_EMPTY:
/* line 420 "MoveControl.puma" */
   return 0;

  case kBTP_LIST:
/* line 425 "MoveControl.puma" */
   return CountCommunication (home, exp->BTP_LIST.Elem) + CountCommunication (home, exp->BTP_LIST.Next);

  case kBTP_EMPTY:
/* line 430 "MoveControl.puma" */
   return 0;

  case kVAR_PARAM:
/* line 435 "MoveControl.puma" */
   exp = exp->VAR_PARAM.V;
   goto yyRecursion;

  case kNO_PARAM:
/* line 440 "MoveControl.puma" */
   return 0;

  case kFUNC_PARAM:
/* line 445 "MoveControl.puma" */
   return 0;

  case kPROC_PARAM:
/* line 450 "MoveControl.puma" */
   return 0;

  }

/* line 460 "MoveControl.puma" */
  {
/* line 462 "MoveControl.puma" */
   failure_protocol (MODULE, "CountCommunication (exp)", exp);
  }
   return 0;

}

static int CountVarIndexCommunication
# if defined __STDC__ | defined __cplusplus
(pvar home, register tTree var)
# else
(home, var)
 pvar home;
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kINDEXED_VAR) {
/* line 473 "MoveControl.puma" */
   return CountVarIndexCommunication (home, var->INDEXED_VAR.IND_VAR) + CountCommunication (home, var->INDEXED_VAR.IND_EXPS);

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 479 "MoveControl.puma" */
   return CountVarIndexCommunication (home, var->SUBSTRING_VAR.IND_VAR) + CountCommunication (home, var->SUBSTRING_VAR.IND_EXP);

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 485 "MoveControl.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;

  }
/* line 490 "MoveControl.puma" */
   return 0;

}

int CountMovements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
 yyRecursion:
  if (Tree_IsType (exp, kBT_VAR)) {
/* line 518 "MoveControl.puma" */
   return CountVarMovements (var, exp);

  }
/* line 522 "MoveControl.puma" */
  {
/* line 523 "MoveControl.puma" */
   if (! ((TreeWriteDistribution (var) == - 2))) goto yyL2;
  }
   return 1;
yyL2:;


  switch (exp->Kind) {
  case kADDR:
/* line 527 "MoveControl.puma" */
   exp = exp->ADDR.E;
   goto yyRecursion;

  case kDUMMY_EXP:
/* line 531 "MoveControl.puma" */
   return 0;

  case kCONST_EXP:
/* line 535 "MoveControl.puma" */
   return 0;

  case kBOUND_EXP:
/* line 539 "MoveControl.puma" */
   return 0;

  case kRANK_EXP:
/* line 543 "MoveControl.puma" */
   return 0;

  case kARRAY_EXP:
/* line 547 "MoveControl.puma" */
   exp = exp->ARRAY_EXP.ELEMENTS;
   goto yyRecursion;

  case kTYPE_EXP:
/* line 551 "MoveControl.puma" */
   exp = exp->TYPE_EXP.ELEMENTS;
   goto yyRecursion;

  case kDO_EXP:
/* line 555 "MoveControl.puma" */
   return CountMovements (var, exp->DO_EXP.RANGE) + CountMovements (var, exp->DO_EXP.BODY);

  case kSLICE_EXP:
/* line 559 "MoveControl.puma" */
   return CountMovements (var, exp->SLICE_EXP.FIRST) + CountMovements (var, exp->SLICE_EXP.STOP) + CountMovements (var, exp->SLICE_EXP.INC);

  case kOP_EXP:
/* line 564 "MoveControl.puma" */
   return CountMovements (var, exp->OP_EXP.OPND1) + CountMovements (var, exp->OP_EXP.OPND2);

  case kOP1_EXP:
/* line 568 "MoveControl.puma" */
   exp = exp->OP1_EXP.OPND;
   goto yyRecursion;

  case kPERM_EXP:
/* line 572 "MoveControl.puma" */
   return CountMovements (var, exp->PERM_EXP.VAL) + 1;

  case kVAR_EXP:
/* line 577 "MoveControl.puma" */
   return CountVarMovements (var, exp->VAR_EXP.V);

  case kFUNC_CALL_EXP:
/* line 581 "MoveControl.puma" */
  {
/* line 583 "MoveControl.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL16;
  {
/* line 584 "MoveControl.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("SPREAD", 6)))) goto yyL16;
  }
  }
   return CountSpreadMovements (var, exp->FUNC_CALL_EXP.FUNC_PARAMS);
yyL16:;

/* line 589 "MoveControl.puma" */
   exp = exp->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;

  case kBTE_LIST:
/* line 594 "MoveControl.puma" */
   return CountMovements (var, exp->BTE_LIST.Elem) + CountMovements (var, exp->BTE_LIST.Next);

  case kBTE_EMPTY:
/* line 598 "MoveControl.puma" */
   return 0;

  case kBTP_LIST:
/* line 602 "MoveControl.puma" */
   return CountMovements (var, exp->BTP_LIST.Elem) + CountMovements (var, exp->BTP_LIST.Next);

  case kBTP_EMPTY:
/* line 606 "MoveControl.puma" */
   return 0;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
/* line 610 "MoveControl.puma" */
   exp = exp->VAR_PARAM.V->ADDR.E;
   goto yyRecursion;

  }
/* line 614 "MoveControl.puma" */
   return CountVarMovements (var, exp->VAR_PARAM.V);

  case kNO_PARAM:
/* line 618 "MoveControl.puma" */
   return 0;

  case kFUNC_PARAM:
/* line 622 "MoveControl.puma" */
   return 0;

  case kPROC_PARAM:
/* line 626 "MoveControl.puma" */
   return 0;

  case kUSED_VAR:
/* line 630 "MoveControl.puma" */
   return CountVarMovements (var, exp);

  case kLOOP_VAR:
/* line 634 "MoveControl.puma" */
   return 0;

  case kINDEXED_VAR:
/* line 638 "MoveControl.puma" */
   return CountVarMovements (var, exp);

  }

/* line 642 "MoveControl.puma" */
  {
/* line 643 "MoveControl.puma" */
   failure_protocol (MODULE, "CountMovements (exp)", exp);
  }
   return 0;

}

static int CountSpreadMovements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree params)
# else
(var, params)
 register tTree var;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 659 "MoveControl.puma" */
 {
  int dimval;
  rbool found;
  {
/* line 664 "MoveControl.puma" */
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, & found, & dimval);
/* line 666 "MoveControl.puma" */
 if (!found) dimval = -1; 
  }
   return CountMovements (var, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem) + CountSpreadVarMovements (var, params->BTP_LIST.Elem, dimval);
 }

  }
  }
  }
  }
/* line 672 "MoveControl.puma" */
  {
/* line 673 "MoveControl.puma" */
   failure_protocol (MODULE, "CountSpreadMovements", params);
  }
   return 0;

}

static int CountSpreadVarMovements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree array, register int dim)
# else
(var, array, dim)
 register tTree var;
 register tTree array;
 register int dim;
# endif
{
/* line 679 "MoveControl.puma" */
  {
/* line 680 "MoveControl.puma" */
   if (! ((dim == - 1))) goto yyL1;
  }
   return 1;
yyL1:;

/* line 684 "MoveControl.puma" */
 {
  int count;
  int yyV1;
  tTree yyV2;
  {
/* line 688 "MoveControl.puma" */
   GetMajorityVar (array, & yyV1, & yyV2);
/* line 690 "MoveControl.puma" */
 if (yyV1 == 0) count = 0;           

       else if (yyV1 != 1) count = 1;     

       else if (SpreadAligned (var, yyV2, dim))

            count = 0;
   
       else count = 1;    
    
  }
   return count;
 }

}

rbool SpreadAligned
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree maj_var, register int dim)
# else
(var, maj_var, dim)
 register tTree var;
 register tTree maj_var;
 register int dim;
# endif
{
/* line 712 "MoveControl.puma" */
  {
/* line 716 "MoveControl.puma" */
   if (! ((TreeRank (var) != TreeRank (maj_var) + 1))) goto yyL1;
  {
/* line 717 "MoveControl.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 720 "MoveControl.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  rbool yyV3;
  var_descriptor yyV4;
  {
/* line 725 "MoveControl.puma" */
   FindLegalVarDescriptor (var, & yyV1, & yyV2);
/* line 726 "MoveControl.puma" */
   FindLegalVarDescriptor (maj_var, & yyV3, & yyV4);
/* line 728 "MoveControl.puma" */
   if (! ((yyV1 && yyV3))) goto yyL2;
  {
/* line 730 "MoveControl.puma" */
   RedVarDescriptor (& yyV2, dim);
/* line 732 "MoveControl.puma" */
   if (! ((VDIsLocalAssignment (& yyV2, & yyV4)))) goto yyL2;
  }
  }
   return rtrue;
 }
yyL2:;

  return rfalse;
}

void GetMajorityVar
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int * flag, register tTree * var)
# else
(exp, flag, var)
 register tTree exp;
 register int * flag;
 register tTree * var;
# endif
{

  switch (exp->Kind) {
  case kADDR:
/* line 743 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 744 "MoveControl.puma" */
   GetMajorityVar (exp->ADDR.E, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kDUMMY_EXP:
/* line 747 "MoveControl.puma" */
   * flag = 0;
   * var = NoTree;
   return;

  case kCONST_EXP:
/* line 750 "MoveControl.puma" */
   * flag = 0;
   * var = NoTree;
   return;

  case kARRAY_EXP:
/* line 753 "MoveControl.puma" */
  {
/* line 754 "MoveControl.puma" */
   if (! ((TreeReadDistribution (exp->ARRAY_EXP.ELEMENTS) == 0))) goto yyL4;
  }
   * flag = 0;
   * var = NoTree;
   return;
yyL4:;

/* line 757 "MoveControl.puma" */
   * flag = - 1;
   * var = NoTree;
   return;

  case kTYPE_EXP:
/* line 760 "MoveControl.puma" */
  {
/* line 761 "MoveControl.puma" */
   if (! ((TreeReadDistribution (exp->TYPE_EXP.ELEMENTS) == 0))) goto yyL6;
  }
   * flag = 0;
   * var = NoTree;
   return;
yyL6:;

/* line 764 "MoveControl.puma" */
   * flag = - 1;
   * var = NoTree;
   return;

  case kSLICE_EXP:
/* line 767 "MoveControl.puma" */
  {
/* line 768 "MoveControl.puma" */
   if (! ((TreeReadDistribution (exp->SLICE_EXP.FIRST) == 0))) goto yyL8;
  {
/* line 769 "MoveControl.puma" */
   if (! ((TreeReadDistribution (exp->SLICE_EXP.STOP) == 0))) goto yyL8;
  {
/* line 770 "MoveControl.puma" */
   if (! ((TreeReadDistribution (exp->SLICE_EXP.INC) == 0))) goto yyL8;
  }
  }
  }
   * flag = 0;
   * var = NoTree;
   return;
yyL8:;

/* line 773 "MoveControl.puma" */
   * flag = - 1;
   * var = NoTree;
   return;

  case kOP_EXP:
/* line 776 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 778 "MoveControl.puma" */
   GetMajorityVar2 (exp->OP_EXP.OPND1, exp->OP_EXP.OPND2, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kOP1_EXP:
/* line 781 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 783 "MoveControl.puma" */
   GetMajorityVar (exp->OP1_EXP.OPND, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kPERM_EXP:
/* line 786 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 788 "MoveControl.puma" */
   GetMajorityVar (exp->PERM_EXP.VAL, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kVAR_EXP:
/* line 791 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 792 "MoveControl.puma" */
   GetMajorityVar (exp->VAR_EXP.V, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kFUNC_CALL_EXP:
/* line 795 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 799 "MoveControl.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL14;
  {
/* line 800 "MoveControl.puma" */
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL14;
  {
/* line 802 "MoveControl.puma" */
   GetMajorityVar (exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }
yyL14:;

/* line 805 "MoveControl.puma" */
   * flag = - 1;
   * var = NoTree;
   return;

  case kBTE_LIST:
/* line 810 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 812 "MoveControl.puma" */
   GetMajorityVar2 (exp->BTE_LIST.Elem, exp->BTE_LIST.Next, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kBTE_EMPTY:
/* line 815 "MoveControl.puma" */
   * flag = 0;
   * var = NoTree;
   return;

  case kBTP_LIST:
/* line 819 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 821 "MoveControl.puma" */
   GetMajorityVar2 (exp->BTP_LIST.Elem, exp->BTP_LIST.Next, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kBTP_EMPTY:
/* line 824 "MoveControl.puma" */
   * flag = 0;
   * var = NoTree;
   return;

  case kVAR_PARAM:
/* line 827 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 828 "MoveControl.puma" */
   GetMajorityVar (exp->VAR_PARAM.V, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kNO_PARAM:
/* line 831 "MoveControl.puma" */
   * flag = 0;
   * var = NoTree;
   return;

  case kUSED_VAR:
/* line 834 "MoveControl.puma" */
   * flag = 1;
   * var = exp;
   return;

  case kLOOP_VAR:
/* line 837 "MoveControl.puma" */
   * flag = 1;
   * var = exp;
   return;

  case kINDEXED_VAR:
/* line 840 "MoveControl.puma" */
   * flag = 1;
   * var = exp;
   return;

  }

/* line 843 "MoveControl.puma" */
  {
/* line 844 "MoveControl.puma" */
   failure_protocol (MODULE, "GetMajorityVar", exp);
  }
   * flag = - 1;
   * var = NoTree;
   return;

;
}

void GetMajorityVar2
# if defined __STDC__ | defined __cplusplus
(register tTree exp1, register tTree exp2, register int * yyP2, register tTree * yyP1)
# else
(exp1, exp2, yyP2, yyP1)
 register tTree exp1;
 register tTree exp2;
 register int * yyP2;
 register tTree * yyP1;
# endif
{
/* line 855 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 857 "MoveControl.puma" */
   if (! ((exp2 == NoTree))) goto yyL1;
  {
/* line 858 "MoveControl.puma" */
   GetMajorityVar (exp1, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

/* line 861 "MoveControl.puma" */
 {
  int yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  tTree yyV6;
  {
/* line 863 "MoveControl.puma" */
   GetMajorityVar (exp1, & yyV1, & yyV2);
/* line 864 "MoveControl.puma" */
   GetMajorityVar (exp2, & yyV3, & yyV4);
/* line 865 "MoveControl.puma" */
   MergeMajorityVars (yyV1, yyV2, yyV3, yyV4, & yyV5, & yyV6);
  }
   * yyP2 = yyV5;
   * yyP1 = yyV6;
   return;
 }

;
}

static void MergeMajorityVars
# if defined __STDC__ | defined __cplusplus
(register int yyP6, register tTree yyP5, register int yyP4, register tTree yyP3, register int * yyP8, register tTree * yyP7)
# else
(yyP6, yyP5, yyP4, yyP3, yyP8, yyP7)
 register int yyP6;
 register tTree yyP5;
 register int yyP4;
 register tTree yyP3;
 register int * yyP8;
 register tTree * yyP7;
# endif
{
  if (equalint (yyP4, 0)) {
/* line 880 "MoveControl.puma" */
  {
/* line 881 "MoveControl.puma" */
   if (! ((HigherRank (yyP5, yyP3)))) goto yyL1;
  }
   * yyP8 = yyP6;
   * yyP7 = yyP5;
   return;
yyL1:;

  }
  if (equalint (yyP6, 0)) {
/* line 884 "MoveControl.puma" */
  {
/* line 885 "MoveControl.puma" */
   if (! ((HigherRank (yyP3, yyP5)))) goto yyL2;
  }
   * yyP8 = yyP4;
   * yyP7 = yyP3;
   return;
yyL2:;

  }
  if (equalint (yyP4, - 1)) {
/* line 888 "MoveControl.puma" */
   * yyP8 = - 1;
   * yyP7 = NoTree;
   return;

  }
  if (equalint (yyP6, - 1)) {
/* line 891 "MoveControl.puma" */
   * yyP8 = - 1;
   * yyP7 = NoTree;
   return;

  }
  if (equalint (yyP6, 1)) {
  if (equalint (yyP4, 1)) {
/* line 894 "MoveControl.puma" */
  {
/* line 895 "MoveControl.puma" */
   if (! ((CountMovements (yyP5, yyP3) == 0))) goto yyL5;
  {
/* line 896 "MoveControl.puma" */
   if (! ((HigherRank (yyP5, yyP3)))) goto yyL5;
  }
  }
   * yyP8 = 1;
   * yyP7 = yyP5;
   return;
yyL5:;

  }
  }
  if (equalint (yyP6, 1)) {
  if (equalint (yyP4, 1)) {
/* line 899 "MoveControl.puma" */
  {
/* line 900 "MoveControl.puma" */
   if (! ((CountMovements (yyP3, yyP5) == 0))) goto yyL6;
  {
/* line 901 "MoveControl.puma" */
   if (! ((HigherRank (yyP3, yyP5)))) goto yyL6;
  }
  }
   * yyP8 = 1;
   * yyP7 = yyP3;
   return;
yyL6:;

  }
  }
/* line 904 "MoveControl.puma" */
   * yyP8 = - 1;
   * yyP7 = NoTree;
   return;

;
}

static rbool HigherRank
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2)
# else
(var1, var2)
 register tTree var1;
 register tTree var2;
# endif
{
/* line 909 "MoveControl.puma" */
  {
/* line 910 "MoveControl.puma" */
   if (! ((var2 == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 913 "MoveControl.puma" */
  {
/* line 914 "MoveControl.puma" */
   if (! ((var1 == NoTree))) goto yyL2;
  {
/* line 915 "MoveControl.puma" */
   return rfalse;
  }
  }
yyL2:;

/* line 918 "MoveControl.puma" */
  {
/* line 919 "MoveControl.puma" */
   if (! ((TreeRank (var1) >= TreeRank (var2)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  return rfalse;
}

int CountVarMovements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree var1)
# else
(var, var1)
 register tTree var;
 register tTree var1;
# endif
{
  if (var1->Kind == kINDEXED_VAR) {
/* line 944 "MoveControl.puma" */
  {
/* line 946 "MoveControl.puma" */
   if (! ((TreeWriteDistribution (var1->INDEXED_VAR.IND_VAR) == 0))) goto yyL1;
  }
   return CountMovements (var, var1->INDEXED_VAR.IND_EXPS);
yyL1:;

/* line 950 "MoveControl.puma" */
  {
/* line 952 "MoveControl.puma" */
   if (! ((TreeWriteDistribution (var1->INDEXED_VAR.IND_VAR) == 2))) goto yyL2;
  }
   return CountMovements (var, var1->INDEXED_VAR.IND_EXPS);
yyL2:;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 956 "MoveControl.puma" */
  {
/* line 958 "MoveControl.puma" */
   if (! ((TreeWriteDistribution (var->INDEXED_VAR.IND_VAR) == 2))) goto yyL3;
  }
   return CountMovements (var1, var->INDEXED_VAR.IND_EXPS);
yyL3:;

  }
/* line 962 "MoveControl.puma" */
  {
/* line 971 "MoveControl.puma" */
   if (! ((IsLocalAssignment (var, TreeWriteDistribution (var), var1, TreeWriteDistribution (var1))))) goto yyL4;
  }
   return 0;
yyL4:;

/* line 976 "MoveControl.puma" */
   return 1;

}

static rbool IsLocalAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree lvar, register int lvardist, register tTree rvar, register int rvardist)
# else
(lvar, lvardist, rvar, rvardist)
 register tTree lvar;
 register int lvardist;
 register tTree rvar;
 register int rvardist;
# endif
{
/* line 992 "MoveControl.puma" */
  {
/* line 993 "MoveControl.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (equalint (rvardist, 0)) {
/* line 996 "MoveControl.puma" */
   return rtrue;

  }
  if (equalint (lvardist, - 1)) {
  if (equalint (rvardist, - 1)) {
/* line 999 "MoveControl.puma" */
   return rtrue;

  }
  }
 {
  rbool yyV1;
  shift_vector yyV2;
  if (equalint (lvardist, 1)) {
  if (equalint (rvardist, 1)) {
/* line 1002 "MoveControl.puma" */
  {
/* line 1004 "MoveControl.puma" */
   if (! (ReplicatedIndexes (lvar))) goto yyL4;
  {
/* line 1005 "MoveControl.puma" */
   if (! (ReplicatedIndexes (rvar))) goto yyL4;
  {
/* line 1007 "MoveControl.puma" */
   GetShifting (lvar, rvar, & yyV1, & yyV2);
/* line 1009 "MoveControl.puma" */
   if (! ((yyV1))) goto yyL4;
  {
/* line 1013 "MoveControl.puma" */
   if (! ((EnoughOverlapArea (rvar, & yyV2)))) goto yyL4;
  }
  }
  }
  }
   return rtrue;
yyL4:;

  }
  }
 }
  return rfalse;
}

rbool VDIsLocalAssignment
# if defined __STDC__ | defined __cplusplus
(pvar lvar, pvar rvar)
# else
(lvar, rvar)
 pvar lvar;
 pvar rvar;
# endif
{
/* line 1038 "MoveControl.puma" */
  {
/* line 1040 "MoveControl.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 1043 "MoveControl.puma" */
  {
/* line 1047 "MoveControl.puma" */
   if (! ((rvar -> topology_obj == GetDefaultTopology (0)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 1050 "MoveControl.puma" */
 {
  shift_vector pv;
  {
/* line 1052 "MoveControl.puma" */
   if (! ((lvar -> topology_rank > 0))) goto yyL3;
  {
/* line 1053 "MoveControl.puma" */
   if (! ((rvar -> topology_rank > 0))) goto yyL3;
  {
/* line 1057 "MoveControl.puma" */
   if (! ((VDIsShifting (lvar, rvar, & pv)))) goto yyL3;
  {
/* line 1059 "MoveControl.puma" */

#ifdef DEBUG
   print_shift ("VDShifting found", &pv);
#endif
   
/* line 1065 "MoveControl.puma" */
   if (! (EnoughVDOverlapArea (rvar, & pv))) goto yyL3;
  }
  }
  }
  }
   return rtrue;
 }
yyL3:;

  return rfalse;
}

static rbool ReplicatedIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 1076 "MoveControl.puma" */
   return rtrue;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 1079 "MoveControl.puma" */
  {
/* line 1080 "MoveControl.puma" */
   if (! ((TreeReadDistribution (var->INDEXED_VAR.IND_EXPS) == 0))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

void GetShifting
# if defined __STDC__ | defined __cplusplus
(register tTree lvar, register tTree rvar, register rbool * yyP10, shift_vector * yyP9)
# else
(lvar, rvar, yyP10, yyP9)
 register tTree lvar;
 register tTree rvar;
 register rbool * yyP10;
 shift_vector * yyP9;
# endif
{
/* line 1101 "MoveControl.puma" */
 {
  shift_vector sv;
  {
/* line 1105 "MoveControl.puma" */
   if (! (((TreeWriteDistribution (lvar) != 1) || (TreeWriteDistribution (rvar) != 1)))) goto yyL1;
  }
   * yyP10 = rfalse;
   * yyP9 = sv;
   return;
 }
yyL1:;

/* line 1108 "MoveControl.puma" */
 {
  shift_vector sv;
  rbool yyV1;
  var_descriptor yyV2;
  rbool yyV3;
  var_descriptor yyV4;
  {
/* line 1114 "MoveControl.puma" */
   FindLegalVarDescriptor (lvar, & yyV1, & yyV2);
/* line 1115 "MoveControl.puma" */
   FindLegalVarDescriptor (rvar, & yyV3, & yyV4);
/* line 1127 "MoveControl.puma" */
   if (! ((yyV1 && yyV3))) goto yyL2;
  {
/* line 1129 "MoveControl.puma" */
   if (! ((VDIsShifting (& yyV2, & yyV4, & sv)))) goto yyL2;
  }
  }
   * yyP10 = rtrue;
   * yyP9 = sv;
   return;
 }
yyL2:;

/* line 1132 "MoveControl.puma" */
 {
  shift_vector sv;
  {
  }
   * yyP10 = rfalse;
   * yyP9 = sv;
   return;
 }

;
}

void GetCircularShifting
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register rbool * yyP13, register tTree * yyP12, shift_vector * yyP11)
# else
(exp, yyP13, yyP12, yyP11)
 register tTree exp;
 register rbool * yyP13;
 register tTree * yyP12;
 shift_vector * yyP11;
# endif
{
/* line 1153 "MoveControl.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  shift_vector yyV3;
  {
/* line 1157 "MoveControl.puma" */
   FindVarShift (exp, & yyV1, & yyV2, & yyV3);
/* line 1159 "MoveControl.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 1164 "MoveControl.puma" */
   if (! ((AreDimsShiftable (yyV2, & yyV3)))) goto yyL1;
  }
  }
   * yyP13 = yyV1;
   * yyP12 = yyV2;
   * yyP11 = yyV3;
   return;
 }
yyL1:;

/* line 1167 "MoveControl.puma" */
 {
  shift_vector sv;
  {
  }
   * yyP13 = rfalse;
   * yyP12 = NoTree;
   * yyP11 = sv;
   return;
 }

;
}

static void ResolveCShiftParams
# if defined __STDC__ | defined __cplusplus
(register tTree params, register tTree * yyP16, register int * yyP15, register int * yyP14)
# else
(params, yyP16, yyP15, yyP14)
 register tTree params;
 register tTree * yyP16;
 register int * yyP15;
 register int * yyP14;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 1184 "MoveControl.puma" */
 {
  rbool found;
  int idim;
  int ipos;
  {
/* line 1192 "MoveControl.puma" */
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, & found, & idim);
/* line 1193 "MoveControl.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 1194 "MoveControl.puma" */
   if (! ((idim > 0))) goto yyL1;
  {
/* line 1195 "MoveControl.puma" */
   if (! ((idim <= TreeRank (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  {
/* line 1197 "MoveControl.puma" */
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, & found, & ipos);
/* line 1198 "MoveControl.puma" */
   if (! ((found))) goto yyL1;
  }
  }
  }
  }
   * yyP16 = params->BTP_LIST.Elem->VAR_PARAM.V;
   * yyP15 = idim;
   * yyP14 = ipos;
   return;
 }
yyL1:;

/* line 1201 "MoveControl.puma" */
   * yyP16 = params->BTP_LIST.Elem->VAR_PARAM.V;
   * yyP15 = 0;
   * yyP14 = 0;
   return;

  }
  }
  }
  }
  }
  }
  }
/* line 1206 "MoveControl.puma" */
  {
/* line 1207 "MoveControl.puma" */
   failure_protocol (MODULE, "ResolveCShiftParams", params);
  }
   * yyP16 = NoTree;
   * yyP15 = 0;
   * yyP14 = 0;
   return;

;
}

static void FindVarShift
# if defined __STDC__ | defined __cplusplus
(register tTree var, register rbool * yyP19, register tTree * yyP18, shift_vector * yyP17)
# else
(var, yyP19, yyP18, yyP17)
 register tTree var;
 register rbool * yyP19;
 register tTree * yyP18;
 shift_vector * yyP17;
# endif
{
  if (var->Kind == kADDR) {
/* line 1218 "MoveControl.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  shift_vector yyV3;
  {
/* line 1220 "MoveControl.puma" */
   FindVarShift (var->ADDR.E, & yyV1, & yyV2, & yyV3);
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   * yyP17 = yyV3;
   return;
 }

  }
  if (var->Kind == kFUNC_CALL_EXP) {
/* line 1223 "MoveControl.puma" */
 {
  tTree yyV1;
  int yyV2;
  int yyV3;
  rbool yyV4;
  tTree yyV5;
  shift_vector yyV6;
  int formal_dim;
  {
/* line 1225 "MoveControl.puma" */
   if (! ((IsIntrCall (var)))) goto yyL2;
  {
/* line 1226 "MoveControl.puma" */
   if (! ((var->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("CSHIFT", 6)))) goto yyL2;
  {
/* line 1228 "MoveControl.puma" */
   ResolveCShiftParams (var->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3);
/* line 1230 "MoveControl.puma" */
   if (! ((yyV2 > 0))) goto yyL2;
  {
/* line 1232 "MoveControl.puma" */
   FindVarShift (yyV1, & yyV4, & yyV5, & yyV6);
/* line 1234 "MoveControl.puma" */
   if (! ((yyV4))) goto yyL2;
  {
/* line 1237 "MoveControl.puma" */
   formal_dim = GetIndexPosition (yyV5, yyV2);
/* line 1239 "MoveControl.puma" */
 yyV6.shift_pos[formal_dim-1] -= yyV3; 
  }
  }
  }
  }
  }
   * yyP19 = yyV4;
   * yyP18 = yyV5;
   * yyP17 = yyV6;
   return;
 }
yyL2:;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 1242 "MoveControl.puma" */
 {
  shift_vector sv;
  int i;
  {
/* line 1247 "MoveControl.puma" */
 sv.shift_rank = TreeRank (var->INDEXED_VAR.IND_VAR);
    for (i=0; i< sv.shift_rank; i++) sv.shift_pos[i] = 0;
  
  }
   * yyP19 = rtrue;
   * yyP18 = var;
   * yyP17 = sv;
   return;
 }

  }
/* line 1252 "MoveControl.puma" */
 {
  shift_vector sv;
  {
  }
   * yyP19 = rfalse;
   * yyP18 = NoTree;
   * yyP17 = sv;
   return;
 }

;
}

static rbool AreDimsShiftable
# if defined __STDC__ | defined __cplusplus
(register tTree var, pshift sv)
# else
(var, sv)
 register tTree var;
 pshift sv;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 1277 "MoveControl.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  rbool okay;
  int dim;
  int rank;
  {
/* line 1279 "MoveControl.puma" */
   FindLegalVarDescriptor (var, & yyV1, & yyV2);
/* line 1280 "MoveControl.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 1286 "MoveControl.puma" */
 rank = yyV2.formal_rank;

     if (rank != sv->shift_rank) 
       { printf ("var rank = %d, shift rank = %d\n", rank, sv->shift_rank);
         failure_protocol (MODULE, "AreDimsShiftable (rank mismatch)", var);
       }

     okay = rtrue;

     for (dim = 0; dim < rank; dim ++)

     {  if (sv->shift_pos[dim] != 0)

          { okay = okay && ActualEqFormal (yyV2.formal_shape[dim][0], 
                                           yyV2.actual_shape[dim][0]);

            okay = okay && ActualEqFormal (yyV2.formal_shape[dim][1], 
                                           yyV2.actual_shape[dim][1]);

            

            okay = okay && IsStride1 (yyV2.actual_shape[dim][2]);

            if (yyV2.topology_rank > 0)
              okay = okay && (yyV2.distribution_kind[dim] != kCYCLIC_DIM);

          }

     }   

   
/* line 1317 "MoveControl.puma" */
   if (! ((okay))) goto yyL1;
  }
  }
   return rtrue;
 }
yyL1:;

  }
  return rfalse;
}

static rbool ActualEqFormal
# if defined __STDC__ | defined __cplusplus
(register tTree formal_exp, register tTree actual_exp)
# else
(formal_exp, actual_exp)
 register tTree formal_exp;
 register tTree actual_exp;
# endif
{
/* line 1330 "MoveControl.puma" */
  {
/* line 1332 "MoveControl.puma" */
   if (! ((formal_exp == NoTree))) goto yyL1;
  {
/* line 1333 "MoveControl.puma" */
   if (! ((actual_exp == NoTree))) goto yyL1;
  {
/* line 1334 "MoveControl.puma" */
   return rfalse;
  }
  }
  }
yyL1:;

/* line 1337 "MoveControl.puma" */
  {
/* line 1339 "MoveControl.puma" */
   if (! ((formal_exp != NoTree))) goto yyL2;
  {
/* line 1340 "MoveControl.puma" */
   if (! ((actual_exp != NoTree))) goto yyL2;
  {
/* line 1341 "MoveControl.puma" */
   if (! ((EqualExpression (formal_exp, actual_exp)))) goto yyL2;
  }
  }
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static int GetIndexPosition
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int dim)
# else
(indexes, dim)
 register tTree indexes;
 register int dim;
# endif
{
 yyRecursion:
  if (indexes->Kind == kINDEXED_VAR) {
/* line 1356 "MoveControl.puma" */
   indexes = indexes->INDEXED_VAR.IND_EXPS;
   goto yyRecursion;

  }
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 1360 "MoveControl.puma" */
  {
/* line 1361 "MoveControl.puma" */
   if (! ((dim == 1))) goto yyL2;
  }
   return 1;
yyL2:;

/* line 1365 "MoveControl.puma" */
   return GetIndexPosition (indexes->BTE_LIST.Next, dim - 1) + 1;

  }
/* line 1369 "MoveControl.puma" */
   return GetIndexPosition (indexes->BTE_LIST.Next, dim) + 1;

  }
/* line 1373 "MoveControl.puma" */
  {
/* line 1374 "MoveControl.puma" */
   failure_protocol (MODULE, "GetIndexPosition", indexes);
  }
   return 0;

}

rbool EnoughOverlapArea
# if defined __STDC__ | defined __cplusplus
(register tTree var, pshift pos)
# else
(var, pos)
 register tTree var;
 pshift pos;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 1388 "MoveControl.puma" */
  {
/* line 1389 "MoveControl.puma" */
   if (! ((EnoughOverlapArea (var->INDEXED_VAR.IND_VAR, pos)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (var->Kind == kUSED_VAR) {
/* line 1392 "MoveControl.puma" */
  {
/* line 1393 "MoveControl.puma" */
   if (! ((EnoughOverlapArea (var->USED_VAR.VARNAME, pos)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (var->Kind == kVAR_OBJ) {
/* line 1396 "MoveControl.puma" */
  {
/* line 1397 "MoveControl.puma" */
   if (! ((IsEnoughVarOverlap (GetVarShadow (var->VAR_OBJ.Object), 0, pos)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static rbool IsEnoughVarOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_specs, register int dim, pshift pos)
# else
(shadow_specs, dim, pos)
 register tTree shadow_specs;
 register int dim;
 pshift pos;
# endif
{
/* line 1402 "MoveControl.puma" */
  {
/* line 1404 "MoveControl.puma" */
   if (! ((shadow_specs == NoTree))) goto yyL1;
  {
/* line 1405 "MoveControl.puma" */
   if (! ((IsZeroShifting (pos)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 1408 "MoveControl.puma" */
  {
/* line 1410 "MoveControl.puma" */
   if (! ((shadow_specs == NoTree))) goto yyL2;
  {
/* line 1411 "MoveControl.puma" */
   return rfalse;
  }
  }
yyL2:;

  if (shadow_specs->Kind == kSHADOW_EMPTY) {
/* line 1414 "MoveControl.puma" */
   return rtrue;

  }
  if (shadow_specs->Kind == kSHADOW_LIST) {
/* line 1419 "MoveControl.puma" */
  {
/* line 1421 "MoveControl.puma" */
   if (! ((SufficientOverlapIndex (shadow_specs->SHADOW_LIST.Elem, pos -> shift_pos [dim])))) goto yyL4;
  {
/* line 1422 "MoveControl.puma" */
   if (! ((IsEnoughVarOverlap (shadow_specs->SHADOW_LIST.Next, dim + 1, pos)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static rbool SufficientOverlapIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index, register int pos)
# else
(index, pos)
 register tTree index;
 register int pos;
# endif
{
  if (index->Kind == kSHADOW_SPEC) {
/* line 1435 "MoveControl.puma" */
  {
/* line 1437 "MoveControl.puma" */
   if (! ((index->SHADOW_SPEC.right_update >= - pos))) goto yyL1;
  {
/* line 1438 "MoveControl.puma" */
   if (! ((index->SHADOW_SPEC.left_update >= pos))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

rbool SameDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual, register tDefinitions formal)
# else
(actual, formal)
 register tDefinitions actual;
 register tDefinitions formal;
# endif
{
/* line 1451 "MoveControl.puma" */
 {
  var_descriptor vard1;
  var_descriptor vard2;
  {
/* line 1456 "MoveControl.puma" */
   SetVarObjDescriptor (& vard1, actual, NoTree);
/* line 1457 "MoveControl.puma" */
   SetVarObjDescriptor (& vard2, formal, NoTree);
/* line 1459 "MoveControl.puma" */
   if (! ((SameDescriptorDistribution (& vard1, & vard2)))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static rbool SameDescriptorDistribution
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
/* line 1465 "MoveControl.puma" */
  {
/* line 1467 "MoveControl.puma" */
   if (! ((vard1 -> topology_rank == 0))) goto yyL1;
  {
/* line 1468 "MoveControl.puma" */
   if (! ((vard2 -> topology_rank == 0))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 1471 "MoveControl.puma" */
  {
/* line 1473 "MoveControl.puma" */
   if (! ((vard1 -> topology_rank == - 1))) goto yyL2;
  {
/* line 1474 "MoveControl.puma" */
   if (! ((vard2 -> topology_rank == - 1))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 1477 "MoveControl.puma" */
 {
  rbool equal;
  int pdim;
  {
/* line 1479 "MoveControl.puma" */
   if (! ((SameDescriptorTopology (vard1, vard2)))) goto yyL3;
  {
/* line 1484 "MoveControl.puma" */
 equal = rtrue;

      for (pdim=0; pdim < vard1->topology_rank; pdim++)

        { int kind1, kind2;

          kind1 = vard1->on_kind [pdim];
          kind2 = vard2->on_kind [pdim];

          if (kind1 != kind2) equal = rfalse;

          

          
        }

    
/* line 1501 "MoveControl.puma" */
   if (! ((equal))) goto yyL3;
  }
  }
   return rtrue;
 }
yyL3:;

  return rfalse;
}

static void FindLegalVarDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register rbool * yyP21, var_descriptor * yyP20)
# else
(var, yyP21, yyP20)
 register tTree var;
 register rbool * yyP21;
 var_descriptor * yyP20;
# endif
{
/* line 1514 "MoveControl.puma" */
 {
  var_descriptor vard;
  rbool found;
  {
/* line 1519 "MoveControl.puma" */
   GetVarDescriptor (var, & found, & vard);
  }
   * yyP21 = found;
   * yyP20 = vard;
   return;
 }

;
}

void BeginMoveControl ARGS ((void))
{
}

void CloseMoveControl ARGS ((void))
{
}
