# include "MapDefs.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 48 "MapDefs.puma" */


# include <string.h>

# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "DefTable.h"
# include "Objects.h"

# include "ChangeDefs.h"   /* GetLocalVarEntity */
# include "SetDefs.h"
# include "Expressions.h"  /* ResolveExpression */

# include "Types.h"
# include "TreeOps.h"
# include "Rank.h"
# include "DerivedTypes.h"
# include "Nesting.h"

# define MODULE "MapDefs"

/*********************************************************************
*                                                                    *
*   Global structures are used to verify that no source              *
*   dimension is used more than once                                 *
*                                                                    *
*********************************************************************/

static DistributedDimensions UsedPos;

static rbool IsNewSourcePosition (pos)

int pos;

{ int i, n;
  rbool is_new;

  if (pos <= 0) return rtrue;

  is_new = rtrue;

  n = UsedPos.no_dims;

  for (i=0; i<n; i++)

    if (pos == UsedPos.DimsArray[i])

       is_new = rfalse;

  if (is_new)

     { /* make an entry in Used Positions */

       UsedPos.DimsArray[n] = pos;
       UsedPos.no_dims      = n+1;

     }

  return (is_new);

} /* IsNewSourcePosition */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMapDefs.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MapDefs_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MapDefs, routine %s failed\n",
  yyFunction);
 MapDefs_Exit ();
}

void SetDistributions ARGS ((tTree t, tDefinitions unit));
static void SetAnyTopology ARGS ((tTree d));
void SetAlignments ARGS ((tTree t, tDefinitions unit));
void MakeRedistributeDefs ARGS ((tTree t));
static void SetRedistributees ARGS ((tTree varlist, tTree dist_spec));
void MakeRealignDefs ARGS ((tTree t));
static void SetRealignees ARGS ((tTree varlist, tTree source, tTree target));
static void SetObjDistribution ARGS ((tTree layout, tDefinitions obj));
static void SetObjAlignment ARGS ((tTree alignment, tDefinitions obj));
static void SetObjRange ARGS ((tTree layout, tDefinitions obj));
static void CheckDistributee ARGS ((tDefinitions distributee, tTree dspec));
static void DistributionDefs ARGS ((tTree dspec, tTree top));
static void SetMappingDefs ARGS ((tTree spec));
static void CheckTopology ARGS ((tTree spec));
static void VerifyTopologyObject ARGS ((tDefinitions obj));
static void CheckAlignee ARGS ((tDefinitions alignee, tTree source, tTree target));
static void AlignmentDefs ARGS ((tTree align_source, tTree align_spec));
static rbool AlignSpecDefs ARGS ((tTree align_spec));
static rbool FittingAlignment ARGS ((tTree align_sources, tTree align_subscripts));
static int FillAlignSpec ARGS ((tTree t, int n));
static tTree MakeSlices ARGS ((int rank));
static void CheckTargetSubscripts ARGS ((tTree targets, tTree sources));
static tDefinitions GetDistributeeObj ARGS ((tTree distributee));
static tDefinitions GetAligneeObj ARGS ((tTree alignee));
static rbool CanBeDistributed ARGS ((tDefinitions obj));
static rbool IsMappedTypeObj ARGS ((tDefinitions obj));
static rbool CanBeAligned ARGS ((tDefinitions obj));
void AnalTargetExp ARGS ((tTree exp, tTree free_vars, int * yyP6, rbool * yyP5, tTree * yyP4, int * yyP3, tTree * yyP2, int * yyP1));
static void FindFreeVar ARGS ((tTree exp, tTree free_vars, rbool * yyP9, int * yyP8, tTree * yyP7));
static void ResolveFreeVar ARGS ((tTree exp, tTree fvar, rbool * yyP14, tTree * yyP13, int * yyP12, tTree * yyP11, int * yyP10));
static rbool FreeVarInExp ARGS ((tTree fvar, tTree exp));
static void MakeAlignTypes ARGS ((tTree align_source));
static void MakeAlignVar ARGS ((tDefinitions obj, tTree var, tDefinitions my_unit));

void SetDistributions
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions unit)
# else
(t, unit)
 register tTree t;
 register tDefinitions unit;
# endif
{
 yyRecursion:
  if (t->Kind == kDECL_LIST) {
/* line 137 "MapDefs.puma" */
  {
/* line 139 "MapDefs.puma" */
   set_protocol_stmt (t->DECL_LIST.Elem);
/* line 141 "MapDefs.puma" */
   SetDistributions (t->DECL_LIST.Elem, unit);
/* line 142 "MapDefs.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kDISTRIBUTE_DECL) {
/* line 145 "MapDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 147 "MapDefs.puma" */
   SetAnyTopology (t);
/* line 151 "MapDefs.puma" */
   Obj = GetLocalVarEntity (t->DISTRIBUTE_DECL.Ident, t->DISTRIBUTE_DECL.Line, unit);
/* line 153 "MapDefs.puma" */
 if (IsMappedTypeObj (Obj))
        error_protocol ("variable cannot be mapped (explicitly mapped type)");
      else if (!CanBeDistributed (Obj))
        error_protocol ("this entity cannot be distributed");
   
/* line 159 "MapDefs.puma" */
   DistributionDefs (t->DISTRIBUTE_DECL.DISTRIBUTION, t->DISTRIBUTE_DECL.TARGET);
/* line 160 "MapDefs.puma" */
   CheckDistributee (Obj, t->DISTRIBUTE_DECL.DISTRIBUTION);
/* line 162 "MapDefs.puma" */
   SetObjDistribution (t, Obj);
  }
   return;
 }

  }
  if (t->Kind == kINHERIT_DECL) {
/* line 165 "MapDefs.puma" */
   return;

  }
  if (t->Kind == kRANGE_DECL) {
  if (t->RANGE_DECL.RANGES->Kind == kRANGE_LIST) {
  if (t->RANGE_DECL.RANGES->RANGE_LIST.Next->Kind == kRANGE_EMPTY) {
/* line 168 "MapDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 172 "MapDefs.puma" */
   Obj = GetLocalVarEntity (t->RANGE_DECL.Ident, t->RANGE_DECL.Line, unit);
/* line 174 "MapDefs.puma" */
 if (!CanBeDistributed (Obj))
        error_protocol ("this entity cannot be distributed");
   
/* line 178 "MapDefs.puma" */
   DistributionDefs (t->RANGE_DECL.RANGES->RANGE_LIST.Elem, NoTree);
/* line 179 "MapDefs.puma" */
   CheckDistributee (Obj, t->RANGE_DECL.RANGES->RANGE_LIST.Elem);
/* line 181 "MapDefs.puma" */
   SetObjRange (t, Obj);
  }
   return;
 }

  }
  }
/* line 184 "MapDefs.puma" */
  {
/* line 186 "MapDefs.puma" */
   error_protocol ("RANGE directive can contain only one range");
  }
   return;

  }
  if (t->Kind == kSELECT_DECL) {
/* line 189 "MapDefs.puma" */
  {
/* line 191 "MapDefs.puma" */
   MakeObjSelection (GetLocalVarEntity (t->SELECT_DECL.Ident, t->SELECT_DECL.Line, unit), t->SELECT_DECL.SELECTIONS);
  }
   return;

  }
  if (t->Kind == kSHADOW_DECL) {
/* line 194 "MapDefs.puma" */
  {
/* line 196 "MapDefs.puma" */
   MakeObjShadow (GetLocalVarEntity (t->SHADOW_DECL.Ident, t->SHADOW_DECL.Line, unit), t->SHADOW_DECL.SHADOWS);
  }
   return;

  }
/* line 199 "MapDefs.puma" */
   return;

;
}

static void SetAnyTopology
# if defined __STDC__ | defined __cplusplus
(register tTree d)
# else
(d)
 register tTree d;
# endif
{
  if (d->Kind == kDISTRIBUTE_DECL) {
  if (d->DISTRIBUTE_DECL.TARGET->Kind == kPROCESSOR_ARRAY) {
/* line 206 "MapDefs.puma" */
  {
/* line 208 "MapDefs.puma" */
   if (! ((d->DISTRIBUTE_DECL.TARGET->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident == DefaultId ()))) goto yyL1;
  {
/* line 210 "MapDefs.puma" */
 d->DISTRIBUTE_DECL.TARGET = mDEFAULT_PROCESSOR_ARRAY (); 
  }
  }
   return;
yyL1:;

  }
  }
  if (d->Kind == kREDISTRIBUTE_STMT) {
  if (d->REDISTRIBUTE_STMT.TARGET->Kind == kPROCESSOR_ARRAY) {
/* line 213 "MapDefs.puma" */
  {
/* line 215 "MapDefs.puma" */
   if (! ((d->REDISTRIBUTE_STMT.TARGET->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident == DefaultId ()))) goto yyL2;
  {
/* line 217 "MapDefs.puma" */
 d->REDISTRIBUTE_STMT.TARGET = mDEFAULT_PROCESSOR_ARRAY (); 
  }
  }
   return;
yyL2:;

  }
  }
;
}

void SetAlignments
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions unit)
# else
(t, unit)
 register tTree t;
 register tDefinitions unit;
# endif
{
 yyRecursion:
  if (t->Kind == kDECL_LIST) {
/* line 230 "MapDefs.puma" */
  {
/* line 232 "MapDefs.puma" */
   set_protocol_stmt (t->DECL_LIST.Elem);
/* line 233 "MapDefs.puma" */
   SetAlignments (t->DECL_LIST.Elem, unit);
/* line 234 "MapDefs.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kALIGN_DECL) {
/* line 237 "MapDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 241 "MapDefs.puma" */
   Obj = GetLocalVarEntity (t->ALIGN_DECL.Ident, t->ALIGN_DECL.Line, unit);
/* line 245 "MapDefs.puma" */
 if (IsMappedTypeObj (Obj))
        error_protocol ("variable cannot be mapped (explicitly mapped type)");
     if (TreeListLength (t->ALIGN_DECL.ALIGN_SOURCE) == 0)
        t->ALIGN_DECL.ALIGN_SOURCE = MakeSlices (VarRank (Obj));
   
/* line 251 "MapDefs.puma" */
   AlignmentDefs (t->ALIGN_DECL.ALIGN_SOURCE, t->ALIGN_DECL.ALIGN_TARGET);
/* line 252 "MapDefs.puma" */
   CheckAlignee (Obj, t->ALIGN_DECL.ALIGN_SOURCE, t->ALIGN_DECL.ALIGN_TARGET);
/* line 254 "MapDefs.puma" */
   SetObjAlignment (t, GetLocalVarEntity (t->ALIGN_DECL.Ident, t->ALIGN_DECL.Line, unit));
  }
   return;
 }

  }
  if (t->Kind == kTYPE_DECL) {
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
/* line 257 "MapDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 259 "MapDefs.puma" */
   if (! ((0 == 1))) goto yyL3;
  {
/* line 263 "MapDefs.puma" */
   Obj = GetLocalObject (t->TYPE_DECL.Ident);
/* line 265 "MapDefs.puma" */
   OpenScope (Obj->TypeObject.Components);
/* line 266 "MapDefs.puma" */
   SetAlignments (t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS, Obj);
/* line 267 "MapDefs.puma" */
   CloseScope ();
  }
  }
   return;
 }
yyL3:;

  }
  }
/* line 270 "MapDefs.puma" */
   return;

;
}

void MakeRedistributeDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kREDISTRIBUTE_STMT) {
/* line 285 "MapDefs.puma" */
  {
/* line 287 "MapDefs.puma" */
   SetAnyTopology (t);
/* line 289 "MapDefs.puma" */
   DistributionDefs (t->REDISTRIBUTE_STMT.DISTRIBUTION, t->REDISTRIBUTE_STMT.TARGET);
/* line 290 "MapDefs.puma" */
   SetRedistributees (t->REDISTRIBUTE_STMT.DISTRIBUTEE, t->REDISTRIBUTE_STMT.DISTRIBUTION);
  }
   return;

  }
/* line 293 "MapDefs.puma" */
  {
/* line 295 "MapDefs.puma" */
   failure_protocol (MODULE, "MakeRedistributeDefs", t);
  }
   return;

;
}

static void SetRedistributees
# if defined __STDC__ | defined __cplusplus
(register tTree varlist, register tTree dist_spec)
# else
(varlist, dist_spec)
 register tTree varlist;
 register tTree dist_spec;
# endif
{
 yyRecursion:
  if (varlist->Kind == kBTV_LIST) {
/* line 300 "MapDefs.puma" */
  {
/* line 302 "MapDefs.puma" */
   SetRedistributees (varlist->BTV_LIST.Elem, dist_spec);
/* line 303 "MapDefs.puma" */
   varlist = varlist->BTV_LIST.Next;
   goto yyRecursion;
  }

  }
  if (varlist->Kind == kBTV_EMPTY) {
/* line 306 "MapDefs.puma" */
   return;

  }
  if (varlist->Kind == kUSED_VAR) {
/* line 309 "MapDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 313 "MapDefs.puma" */
   Obj = GetDistributeeObj (varlist);
/* line 315 "MapDefs.puma" */
   CheckDistributee (Obj, dist_spec);
  }
   return;
 }

  }
;
}

void MakeRealignDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kREALIGN_STMT) {
/* line 326 "MapDefs.puma" */
  {
/* line 328 "MapDefs.puma" */
   if (! ((t->REALIGN_STMT.ALIGN_TARGET->ALIGN_SPEC.is_descriptive != 0))) goto yyL1;
  {
/* line 330 "MapDefs.puma" */
   error_protocol ("align_spec in REALIGN must not begin with *");
  }
  }
   return;
yyL1:;

  if (t->REALIGN_STMT.ALIGNEE->Kind == kBTV_LIST) {
  if (t->REALIGN_STMT.ALIGN_SOURCE->Kind == kBTE_EMPTY) {
/* line 335 "MapDefs.puma" */
  {
/* line 340 "MapDefs.puma" */
 t->REALIGN_STMT.ALIGN_SOURCE = MakeSlices (TreeRank (t->REALIGN_STMT.ALIGNEE->BTV_LIST.Elem)); 
/* line 342 "MapDefs.puma" */
   if (! ((TreeRank (t->REALIGN_STMT.ALIGNEE->BTV_LIST.Elem) > 0))) goto yyL2;
  {
/* line 344 "MapDefs.puma" */
   goto yyRecursion;
  }
  }
yyL2:;

  }
  }
/* line 347 "MapDefs.puma" */
  {
/* line 349 "MapDefs.puma" */
   AlignmentDefs (t->REALIGN_STMT.ALIGN_SOURCE, t->REALIGN_STMT.ALIGN_TARGET);
/* line 350 "MapDefs.puma" */
   SetRealignees (t->REALIGN_STMT.ALIGNEE, t->REALIGN_STMT.ALIGN_SOURCE, t->REALIGN_STMT.ALIGN_TARGET);
  }
   return;

  }
/* line 353 "MapDefs.puma" */
  {
/* line 354 "MapDefs.puma" */
   failure_protocol (MODULE, "MakeRealignDefs", t);
  }
   return;

;
}

static void SetRealignees
# if defined __STDC__ | defined __cplusplus
(register tTree varlist, register tTree source, register tTree target)
# else
(varlist, source, target)
 register tTree varlist;
 register tTree source;
 register tTree target;
# endif
{
 yyRecursion:
  if (varlist->Kind == kBTV_LIST) {
/* line 359 "MapDefs.puma" */
  {
/* line 361 "MapDefs.puma" */
   SetRealignees (varlist->BTV_LIST.Elem, source, target);
/* line 362 "MapDefs.puma" */
   varlist = varlist->BTV_LIST.Next;
   goto yyRecursion;
  }

  }
  if (varlist->Kind == kBTV_EMPTY) {
/* line 365 "MapDefs.puma" */
   return;

  }
  if (varlist->Kind == kUSED_VAR) {
/* line 368 "MapDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 372 "MapDefs.puma" */
   Obj = GetAligneeObj (varlist);
/* line 374 "MapDefs.puma" */
   CheckAlignee (Obj, source, target);
  }
   return;
 }

  }
/* line 377 "MapDefs.puma" */
  {
/* line 379 "MapDefs.puma" */
   failure_protocol (MODULE, "SetRealignees", varlist);
  }
   return;

;
}

static void SetObjDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree layout, register tDefinitions obj)
# else
(layout, obj)
 register tTree layout;
 register tDefinitions obj;
# endif
{
/* line 398 "MapDefs.puma" */
  {
/* line 400 "MapDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 402 "MapDefs.puma" */
   error_protocol ("DISTRIBUTE: unknown entity");
  }
  }
   return;
yyL1:;

/* line 405 "MapDefs.puma" */
  {
/* line 407 "MapDefs.puma" */
   if (! ((IsVarAssumedSize (obj)))) goto yyL2;
  {
/* line 408 "MapDefs.puma" */
   error_protocol ("DISTRIBUTE: not allowed for assumed size arrays");
  }
  }
   return;
yyL2:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapDefault) {
/* line 411 "MapDefs.puma" */
  {
/* line 413 "MapDefs.puma" */
 obj->VarObject.Dist->Mapping.spec = mMapDecl (layout); 
  }
   return;

  }
/* line 416 "MapDefs.puma" */
  {
/* line 418 "MapDefs.puma" */
   error_protocol ("DISTRIBUTE: already mapping specified");
/* line 419 "MapDefs.puma" */
   obj_protocol ("variable object : ", obj);
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.Dist->Mapping.spec->Kind == kMapDefault) {
/* line 422 "MapDefs.puma" */
  {
/* line 424 "MapDefs.puma" */
 obj->TemplateObject.Dist->Mapping.spec = mMapDecl (layout); 
  }
   return;

  }
/* line 427 "MapDefs.puma" */
  {
/* line 429 "MapDefs.puma" */
   error_protocol ("DISTRIBUTE : already mapping specified");
/* line 430 "MapDefs.puma" */
   obj_protocol ("template object : ", obj);
  }
   return;

  }
/* line 433 "MapDefs.puma" */
  {
/* line 435 "MapDefs.puma" */
   error_protocol ("distributed object no variable/template");
/* line 436 "MapDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
   return;

;
}

static void SetObjAlignment
# if defined __STDC__ | defined __cplusplus
(register tTree alignment, register tDefinitions obj)
# else
(alignment, obj)
 register tTree alignment;
 register tDefinitions obj;
# endif
{
/* line 447 "MapDefs.puma" */
  {
/* line 449 "MapDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 450 "MapDefs.puma" */
   error_protocol ("ALIGN: unknown entity");
  }
  }
   return;
yyL1:;

/* line 453 "MapDefs.puma" */
  {
/* line 455 "MapDefs.puma" */
   if (! ((IsVarAssumedSize (obj)))) goto yyL2;
  {
/* line 456 "MapDefs.puma" */
   error_protocol ("ALIGN: not allowed for assumed size arrays");
  }
  }
   return;
yyL2:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapDefault) {
/* line 459 "MapDefs.puma" */
  {
/* line 461 "MapDefs.puma" */
 obj->VarObject.Dist->Mapping.spec = mMapDecl (alignment); 
  }
   return;

  }
/* line 464 "MapDefs.puma" */
  {
/* line 466 "MapDefs.puma" */
   error_protocol ("variable is already distributed/aligned");
/* line 467 "MapDefs.puma" */
   obj_protocol ("variable object : ", obj);
  }
   return;

  }
/* line 470 "MapDefs.puma" */
  {
/* line 472 "MapDefs.puma" */
   error_protocol ("object cannot be aligned");
/* line 473 "MapDefs.puma" */
   tree_protocol ("align : ", alignment);
/* line 474 "MapDefs.puma" */
   obj_protocol ("alignee obj is : ", obj);
  }
   return;

;
}

static void SetObjRange
# if defined __STDC__ | defined __cplusplus
(register tTree layout, register tDefinitions obj)
# else
(layout, obj)
 register tTree layout;
 register tDefinitions obj;
# endif
{
/* line 485 "MapDefs.puma" */
  {
/* line 487 "MapDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 488 "MapDefs.puma" */
   error_protocol ("RANGE: unknown entity");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.range->Kind == kRangeDefault) {
/* line 491 "MapDefs.puma" */
  {
/* line 493 "MapDefs.puma" */
 obj->VarObject.Dist->Mapping.range = mRangeDecl (layout); 
  }
   return;

  }
/* line 496 "MapDefs.puma" */
  {
/* line 498 "MapDefs.puma" */
   error_protocol ("RANGE: already specified");
/* line 499 "MapDefs.puma" */
   obj_protocol ("variable object : ", obj);
  }
   return;

  }
/* line 502 "MapDefs.puma" */
  {
/* line 504 "MapDefs.puma" */
   error_protocol ("RANGE: object no variable");
/* line 505 "MapDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
   return;

;
}

static void CheckDistributee
# if defined __STDC__ | defined __cplusplus
(register tDefinitions distributee, register tTree dspec)
# else
(distributee, dspec)
 register tDefinitions distributee;
 register tTree dspec;
# endif
{
/* line 516 "MapDefs.puma" */
  {
/* line 518 "MapDefs.puma" */
   if (! ((distributee == NoObject))) goto yyL1;
  }
   return;
yyL1:;

/* line 521 "MapDefs.puma" */
  {
/* line 523 "MapDefs.puma" */
   if (! ((! CanBeDistributed (distributee)))) goto yyL2;
  }
   return;
yyL2:;

  if (dspec->Kind == kNODE_DISTRIBUTION) {
/* line 526 "MapDefs.puma" */
  {
/* line 528 "MapDefs.puma" */
   if (! ((TreeListLength (dspec->NODE_DISTRIBUTION.MAPPING) != VarRank (distributee)))) goto yyL3;
  {
/* line 529 "MapDefs.puma" */
   error_protocol ("illegal distribution (rank!)");
/* line 530 "MapDefs.puma" */
   obj_protocol ("this is the distributed object", distributee);
  }
  }
   return;
yyL3:;

  }
;
}

static void DistributionDefs
# if defined __STDC__ | defined __cplusplus
(register tTree dspec, register tTree top)
# else
(dspec, top)
 register tTree dspec;
 register tTree top;
# endif
{
  if (dspec->Kind == kNODE_DISTRIBUTION) {
/* line 535 "MapDefs.puma" */
  {
/* line 537 "MapDefs.puma" */
   SetMappingDefs (dspec->NODE_DISTRIBUTION.MAPPING);
/* line 538 "MapDefs.puma" */
   CheckTopology (top);
  }
   return;

  }
  if (dspec->Kind == kDEFAULT_DISTRIBUTION) {
/* line 541 "MapDefs.puma" */
  {
/* line 543 "MapDefs.puma" */
   CheckTopology (top);
  }
   return;

  }
  if (dspec->Kind == kSERIAL_DISTRIBUTION) {
/* line 546 "MapDefs.puma" */
   return;

  }
;
}

static void SetMappingDefs
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
 yyRecursion:

  switch (spec->Kind) {
  case kDIST_EMPTY:
/* line 559 "MapDefs.puma" */
   return;

  case kDIST_LIST:
/* line 562 "MapDefs.puma" */
  {
/* line 563 "MapDefs.puma" */
   SetMappingDefs (spec->DIST_LIST.Elem);
/* line 564 "MapDefs.puma" */
   spec = spec->DIST_LIST.Next;
   goto yyRecursion;
  }

  case kBLOCK_DISTRIBUTION:
/* line 567 "MapDefs.puma" */
  {
/* line 569 "MapDefs.puma" */
 spec->BLOCK_DISTRIBUTION.SIZE = CheckExp (spec->BLOCK_DISTRIBUTION.SIZE); 
  }
   return;

  case kCYCLIC_DISTRIBUTION:
/* line 572 "MapDefs.puma" */
  {
/* line 574 "MapDefs.puma" */
 spec->CYCLIC_DISTRIBUTION.SIZE = CheckExp (spec->CYCLIC_DISTRIBUTION.SIZE); 
  }
   return;

  case kGEN_BLOCK_DISTRIBUTION:
/* line 577 "MapDefs.puma" */
  {
/* line 579 "MapDefs.puma" */
   MakeVarDefs (spec->GEN_BLOCK_DISTRIBUTION.ARRAY);
  }
   return;

  case kINDIRECT_DISTRIBUTION:
/* line 582 "MapDefs.puma" */
  {
/* line 584 "MapDefs.puma" */
   MakeVarDefs (spec->INDIRECT_DISTRIBUTION.ARRAY);
  }
   return;

  case kARBITRARY_DISTRIBUTION:
/* line 587 "MapDefs.puma" */
  {
/* line 589 "MapDefs.puma" */
 spec->ARBITRARY_DISTRIBUTION.SIZE = CheckExp (spec->ARBITRARY_DISTRIBUTION.SIZE); 
/* line 591 "MapDefs.puma" */
   MakeVarDefs (spec->ARBITRARY_DISTRIBUTION.LENGTH);
/* line 592 "MapDefs.puma" */
   MakeVarDefs (spec->ARBITRARY_DISTRIBUTION.MAP);
  }
   return;

  case kSERIAL_DISTRIBUTION:
/* line 595 "MapDefs.puma" */
   return;

  case kANY_BLOCK_DISTRIBUTION:
/* line 598 "MapDefs.puma" */
   return;

  case kANY_CYCLIC_DISTRIBUTION:
/* line 601 "MapDefs.puma" */
   return;

  case kANY_GEN_BLOCK_DISTRIBUTION:
/* line 604 "MapDefs.puma" */
   return;

  case kANY_INDIRECT_DISTRIBUTION:
/* line 607 "MapDefs.puma" */
   return;

  case kANY_ARBITRARY_DISTRIBUTION:
/* line 610 "MapDefs.puma" */
   return;

  case kANY_DIM_DISTRIBUTION:
/* line 613 "MapDefs.puma" */
   return;

  }

/* line 616 "MapDefs.puma" */
  {
/* line 617 "MapDefs.puma" */
   failure_protocol (MODULE, "SetMappingDefs", spec);
  }
   return;

;
}

static void CheckTopology
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
/* line 628 "MapDefs.puma" */
  {
/* line 629 "MapDefs.puma" */
   if (! ((spec == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (spec->Kind == kANY_PROCESSOR_ARRAY) {
/* line 632 "MapDefs.puma" */
   return;

  }
  if (spec->Kind == kDEFAULT_PROCESSOR_ARRAY) {
/* line 635 "MapDefs.puma" */
   return;

  }
  if (spec->Kind == kPROCESSOR_ARRAY) {
/* line 638 "MapDefs.puma" */
  {
/* line 640 "MapDefs.puma" */
   MakeTopologyDef (spec);
  }
   return;

  }
  if (spec->Kind == kPROCESSOR_SUBSET) {
/* line 643 "MapDefs.puma" */
  {
/* line 645 "MapDefs.puma" */
   MakeTopologyDef (spec);
  }
   return;

  }
/* line 648 "MapDefs.puma" */
  {
/* line 650 "MapDefs.puma" */
   failure_protocol (MODULE, "CheckTopology", spec);
  }
   return;

;
}

static void VerifyTopologyObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 661 "MapDefs.puma" */
  {
/* line 663 "MapDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 664 "MapDefs.puma" */
   error_protocol ("processor array not defined\n");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kTopologyObject) {
/* line 667 "MapDefs.puma" */
   return;

  }
/* line 672 "MapDefs.puma" */
  {
/* line 674 "MapDefs.puma" */
   error_protocol ("distribute onto an object that is no processor array");
/* line 675 "MapDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

static void CheckAlignee
# if defined __STDC__ | defined __cplusplus
(register tDefinitions alignee, register tTree source, register tTree target)
# else
(alignee, source, target)
 register tDefinitions alignee;
 register tTree source;
 register tTree target;
# endif
{
/* line 686 "MapDefs.puma" */
  {
/* line 688 "MapDefs.puma" */
   if (! ((alignee == NoObject))) goto yyL1;
  }
   return;
yyL1:;

/* line 691 "MapDefs.puma" */
  {
/* line 693 "MapDefs.puma" */
   if (! ((TreeListLength (source) != VarRank (alignee)))) goto yyL2;
  {
/* line 695 "MapDefs.puma" */
   error_protocol ("rank error for align_source_list");
  }
  }
   return;
yyL2:;

  if (target->Kind == kALIGN_SPEC) {
/* line 698 "MapDefs.puma" */
  {
/* line 700 "MapDefs.puma" */
   if (! ((target->ALIGN_SPEC.is_descriptive))) goto yyL3;
  {
/* line 701 "MapDefs.puma" */
   if (! ((! IsVarDummy (alignee)))) goto yyL3;
  {
/* line 703 "MapDefs.puma" */
   error_protocol ("alignee must be a dummy argument");
/* line 705 "MapDefs.puma" */
   goto yyL3;
  }
  }
  }
yyL3:;

  }
;
}

static void AlignmentDefs
# if defined __STDC__ | defined __cplusplus
(register tTree align_source, register tTree align_spec)
# else
(align_source, align_spec)
 register tTree align_source;
 register tTree align_spec;
# endif
{
  if (align_spec->Kind == kALIGN_SPEC) {
/* line 711 "MapDefs.puma" */
  {
/* line 713 "MapDefs.puma" */
   if (! ((AlignSpecDefs (align_spec)))) goto yyL1;
  {
/* line 715 "MapDefs.puma" */
   if (! ((FittingAlignment (align_source, align_spec->ALIGN_SPEC.SUBSCRIPTS)))) goto yyL1;
  {
/* line 717 "MapDefs.puma" */
   MakeAlignTypes (align_source);
/* line 721 "MapDefs.puma" */
 UsedPos.no_dims = 0;   
     CheckTargetSubscripts (align_spec->ALIGN_SPEC.SUBSCRIPTS, align_source);
   
  }
  }
  }
   return;
yyL1:;

  }
;
}

static rbool AlignSpecDefs
# if defined __STDC__ | defined __cplusplus
(register tTree align_spec)
# else
(align_spec)
 register tTree align_spec;
# endif
{
  if (align_spec->Kind == kALIGN_SPEC) {
/* line 738 "MapDefs.puma" */
 {
  tDefinitions TObj;
  int len;
  rbool okay;
  {
/* line 744 "MapDefs.puma" */
   MakeIndexDefs (align_spec->ALIGN_SPEC.SUBSCRIPTS);
/* line 746 "MapDefs.puma" */
 TObj = GetGlobalObject (align_spec->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Ident);
     okay = rfalse;
     len  = TreeListLength (align_spec->ALIGN_SPEC.SUBSCRIPTS);

     if (TObj == NoObject)

        { char tname [MAX_ID_LENGTH];
          char msg   [MAX_LINE_LENGTH];
          GetString (align_spec->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Ident, tname);
          sprintf (msg, "align target %s is undefined entity", tname);
          error_protocol (msg);
        }

      else if (!CanBeDistributed (TObj))
        error_protocol ("cannot align to such an object");
      else if (IsOptional (TObj))
        error_protocol ("align target may not have the OPTIONAL attribute");
      else if (len == 0)
        { align_spec->ALIGN_SPEC.SUBSCRIPTS = MakeSlices (VarRank (TObj));
          okay = rtrue;
        }
      else if (len != VarRank (TObj))
        error_protocol ("illegal target in alignment (rank!)");
      else
        okay = rtrue;

     align_spec->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Object = TObj;

   
  }
   return okay;
 }

  }
 yyAbort ("AlignSpecDefs");
 { rbool yyDummy; return yyDummy; }
}

static rbool FittingAlignment
# if defined __STDC__ | defined __cplusplus
(register tTree align_sources, register tTree align_subscripts)
# else
(align_sources, align_subscripts)
 register tTree align_sources;
 register tTree align_subscripts;
# endif
{
/* line 792 "MapDefs.puma" */

char msg[40];

/* line 796 "MapDefs.puma" */
 {
  int n1;
  int n2;
  {
/* line 801 "MapDefs.puma" */
   n1 = FillAlignSpec (align_sources, 0);
/* line 802 "MapDefs.puma" */
   n2 = FillAlignSpec (align_subscripts, 0);
/* line 804 "MapDefs.puma" */
   if (! ((n1 != n2))) goto yyL1;
  {
/* line 805 "MapDefs.puma" */
   error_protocol ("alignment has mismatch of source/target");
/* line 806 "MapDefs.puma" */
   sprintf (msg, "source spec has %d free vars: ", n1);
/* line 807 "MapDefs.puma" */
   tree_protocol (msg, align_sources);
/* line 808 "MapDefs.puma" */
   sprintf (msg, "target spec has %d free vars: ", n2);
/* line 809 "MapDefs.puma" */
   tree_protocol (msg, align_subscripts);
  }
  }
   return rfalse;
 }
yyL1:;

/* line 813 "MapDefs.puma" */
   return rtrue;

}

static int FillAlignSpec
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int n)
# else
(t, n)
 register tTree t;
 register int n;
# endif
{
 yyRecursion:
  if (t->Kind == kINDEXED_VAR) {
/* line 832 "MapDefs.puma" */
   t = t->INDEXED_VAR.IND_EXPS;
   goto yyRecursion;

  }
  if (t->Kind == kBTE_EMPTY) {
/* line 836 "MapDefs.puma" */
   return n;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->BTE_LIST.Elem->SLICE_EXP.FIRST->Kind == kDUMMY_EXP) {
  if (t->BTE_LIST.Elem->SLICE_EXP.STOP->Kind == kDUMMY_EXP) {
  if (t->BTE_LIST.Elem->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
/* line 840 "MapDefs.puma" */
  {
/* line 842 "MapDefs.puma" */
 char name[20];
     tTree e;
     sprintf (name, "I_%d", n+1);
     e = mVAR_OBJ (0, MakeIdent (name, strlen (name)));
     e = mVAR_EXP (mUSED_VAR (e));
     t->BTE_LIST.Elem = e;
   
  }
   t = t->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;

  }
  }
  }
  }
/* line 852 "MapDefs.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;

  }
/* line 856 "MapDefs.puma" */
  {
/* line 857 "MapDefs.puma" */
   failure_protocol (MODULE, "FillAlignSpec", t);
  }
   return n;

}

static tTree MakeSlices
# if defined __STDC__ | defined __cplusplus
(register int rank)
# else
(rank)
 register int rank;
# endif
{
/* line 869 "MapDefs.puma" */
  {
/* line 870 "MapDefs.puma" */
   if (! ((rank <= 0))) goto yyL1;
  }
   return mBTE_EMPTY ();
yyL1:;

/* line 874 "MapDefs.puma" */
   return mBTE_LIST (mSLICE_EXP (mDUMMY_EXP (), mDUMMY_EXP (), mDUMMY_EXP ()), MakeSlices (rank - 1));

}

static void CheckTargetSubscripts
# if defined __STDC__ | defined __cplusplus
(register tTree targets, register tTree sources)
# else
(targets, sources)
 register tTree targets;
 register tTree sources;
# endif
{
 yyRecursion:
  if (targets->Kind == kBTE_LIST) {
  if (targets->BTE_LIST.Elem->Kind == kDUMMY_EXP) {
/* line 897 "MapDefs.puma" */
  {
/* line 899 "MapDefs.puma" */
   targets = targets->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 902 "MapDefs.puma" */
 {
  int yyV1;
  rbool yyV2;
  tTree yyV3;
  int yyV4;
  tTree yyV5;
  int yyV6;
  {
/* line 908 "MapDefs.puma" */
   AnalTargetExp (targets->BTE_LIST.Elem, sources, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5, & yyV6);
/* line 911 "MapDefs.puma" */
 if (yyV1 == -1) 

        { tree_protocol ("The following align-subscript causes an error: ", 
                          targets->BTE_LIST.Elem);
          error_protocol ("align-subscript may contain only one align-dummy");
        }

      else if (yyV1 == 0)

        {  }

      else if (!yyV2)

        { tree_protocol ("The following target causes an error: ", targets->BTE_LIST.Elem);
          error_protocol ("invalid align-subscript-use");
        }
   
      else if (!IsNewSourcePosition (yyV1))
     
        { 

          error_protocol (
             "align-dummy appears more than once in align-subscripts");
        }
    
/* line 938 "MapDefs.puma" */
   targets = targets->BTE_LIST.Next;
   goto yyRecursion;
  }
 }

  }
  if (targets->Kind == kBTE_EMPTY) {
/* line 941 "MapDefs.puma" */
   return;

  }
/* line 944 "MapDefs.puma" */
  {
/* line 945 "MapDefs.puma" */
   failure_protocol (MODULE, "CheckTargetSubscripts", targets);
  }
   return;

;
}

static tDefinitions GetDistributeeObj
# if defined __STDC__ | defined __cplusplus
(register tTree distributee)
# else
(distributee)
 register tTree distributee;
# endif
{
  if (distributee->Kind == kUSED_VAR) {
/* line 956 "MapDefs.puma" */
 {
  tDefinitions DObj;
  {
/* line 960 "MapDefs.puma" */
 DObj = GetGlobalObject (distributee->USED_VAR.VARNAME->VAR_OBJ.Ident);

     if (DObj == NoObject)
        error_protocol ("distributee is unknown entity");
      else if (!CanBeDistributed (DObj))
        error_protocol ("entity cannot be distributed");
      else if (!IsHPFDynamic (DObj))
        error_protocol ("entity is not DYNAMIC");

     distributee->USED_VAR.VARNAME->VAR_OBJ.Object = DObj;
   
  }
   return DObj;
 }

  }
/* line 975 "MapDefs.puma" */
  {
/* line 976 "MapDefs.puma" */
   failure_protocol (MODULE, "GetDistributeeObj", distributee);
  }
   return NoObject;

}

static tDefinitions GetAligneeObj
# if defined __STDC__ | defined __cplusplus
(register tTree alignee)
# else
(alignee)
 register tTree alignee;
# endif
{
  if (alignee->Kind == kUSED_VAR) {
/* line 988 "MapDefs.puma" */
 {
  tDefinitions DObj;
  {
/* line 992 "MapDefs.puma" */
 DObj = GetGlobalObject (alignee->USED_VAR.VARNAME->VAR_OBJ.Ident);

     if (DObj == NoObject)
        error_protocol ("alignee is unknown entity");
      else if (!CanBeAligned (DObj))
        error_protocol ("entity cannot be aligned");
      else if (!IsHPFDynamic (DObj))
        error_protocol ("entity is not DYNAMIC");

     alignee->USED_VAR.VARNAME->VAR_OBJ.Object = DObj;
   
  }
   return DObj;
 }

  }
/* line 1007 "MapDefs.puma" */
  {
/* line 1008 "MapDefs.puma" */
   failure_protocol (MODULE, "GetAligneeObj", alignee);
  }
   return NoObject;

}

static rbool CanBeDistributed
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1018 "MapDefs.puma" */
  {
/* line 1019 "MapDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 1020 "MapDefs.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
/* line 1023 "MapDefs.puma" */
 {
  tTree type;
  {
/* line 1027 "MapDefs.puma" */
   type = GetObjectType (obj);
/* line 1030 "MapDefs.puma" */
   if (! ((! IsExplicitlyMappedType (GetBaseType (type))))) goto yyL2;
  }
   return rtrue;
 }
yyL2:;

  }
  if (obj->Kind == kTemplateObject) {
/* line 1033 "MapDefs.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsMappedTypeObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1042 "MapDefs.puma" */
  {
/* line 1043 "MapDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 1044 "MapDefs.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
/* line 1047 "MapDefs.puma" */
  {
/* line 1049 "MapDefs.puma" */
   if (! ((IsExplicitlyMappedType (GetBaseType (GetObjectType (obj)))))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static rbool CanBeAligned
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1058 "MapDefs.puma" */
  {
/* line 1059 "MapDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 1060 "MapDefs.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
/* line 1063 "MapDefs.puma" */
 {
  tTree type;
  {
/* line 1067 "MapDefs.puma" */
   type = GetObjectType (obj);
/* line 1069 "MapDefs.puma" */
   if (! ((! IsPointerObject (obj)))) goto yyL2;
  {
/* line 1070 "MapDefs.puma" */
   if (! ((! IsExplicitlyMappedType (GetBaseType (type))))) goto yyL2;
  }
  }
   return rtrue;
 }
yyL2:;

  }
  return rfalse;
}

void AnalTargetExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree free_vars, register int * yyP6, register rbool * yyP5, register tTree * yyP4, register int * yyP3, register tTree * yyP2, register int * yyP1)
# else
(exp, free_vars, yyP6, yyP5, yyP4, yyP3, yyP2, yyP1)
 register tTree exp;
 register tTree free_vars;
 register int * yyP6;
 register rbool * yyP5;
 register tTree * yyP4;
 register int * yyP3;
 register tTree * yyP2;
 register int * yyP1;
# endif
{
/* line 1096 "MapDefs.puma" */
 {
  rbool yyV1;
  int yyV2;
  tTree yyV3;
  rbool yyV4;
  tTree yyV5;
  int yyV6;
  tTree yyV7;
  int yyV8;
  {
/* line 1098 "MapDefs.puma" */
   FindFreeVar (exp, free_vars, & yyV1, & yyV2, & yyV3);
/* line 1100 "MapDefs.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 1102 "MapDefs.puma" */
   if (! ((yyV2 > 0))) goto yyL1;
  {
/* line 1104 "MapDefs.puma" */
   ResolveFreeVar (exp, yyV3, & yyV4, & yyV5, & yyV6, & yyV7, & yyV8);
  }
  }
  }
   * yyP6 = yyV2;
   * yyP5 = yyV4;
   * yyP4 = yyV5;
   * yyP3 = yyV6;
   * yyP2 = yyV7;
   * yyP1 = yyV8;
   return;
 }
yyL1:;

/* line 1110 "MapDefs.puma" */
 {
  rbool yyV1;
  int yyV2;
  tTree yyV3;
  {
/* line 1114 "MapDefs.puma" */
   FindFreeVar (exp, free_vars, & yyV1, & yyV2, & yyV3);
/* line 1116 "MapDefs.puma" */
 if (!yyV1) yyV2 = -1; 
  }
   * yyP6 = yyV2;
   * yyP5 = rtrue;
   * yyP4 = NoTree;
   * yyP3 = 0;
   * yyP2 = NoTree;
   * yyP1 = 0;
   return;
 }

;
}

static void FindFreeVar
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree free_vars, register rbool * yyP9, register int * yyP8, register tTree * yyP7)
# else
(exp, free_vars, yyP9, yyP8, yyP7)
 register tTree exp;
 register tTree free_vars;
 register rbool * yyP9;
 register int * yyP8;
 register tTree * yyP7;
# endif
{
  if (free_vars->Kind == kBTE_LIST) {
  if (free_vars->BTE_LIST.Elem->Kind == kVAR_EXP) {
/* line 1132 "MapDefs.puma" */
 {
  rbool yyV1;
  int yyV2;
  tTree yyV3;
  {
/* line 1134 "MapDefs.puma" */
   if (! ((FreeVarInExp (free_vars->BTE_LIST.Elem->VAR_EXP.V, exp)))) goto yyL1;
  {
/* line 1136 "MapDefs.puma" */
   FindFreeVar (exp, free_vars->BTE_LIST.Next, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP9 = yyV1 && (yyV2 == 0);
   * yyP8 = 1;
   * yyP7 = free_vars->BTE_LIST.Elem->VAR_EXP.V;
   return;
 }
yyL1:;

  }
/* line 1139 "MapDefs.puma" */
 {
  rbool yyV1;
  int yyV2;
  tTree yyV3;
  {
/* line 1141 "MapDefs.puma" */
   FindFreeVar (exp, free_vars->BTE_LIST.Next, & yyV1, & yyV2, & yyV3);
/* line 1143 "MapDefs.puma" */
 if (yyV1 && (yyV2 > 0)) yyV2++; 
  }
   * yyP9 = yyV1;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

  }
  if (free_vars->Kind == kBTE_EMPTY) {
/* line 1146 "MapDefs.puma" */
   * yyP9 = rtrue;
   * yyP8 = 0;
   * yyP7 = NoTree;
   return;

  }
;
}

static void ResolveFreeVar
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree fvar, register rbool * yyP14, register tTree * yyP13, register int * yyP12, register tTree * yyP11, register int * yyP10)
# else
(exp, fvar, yyP14, yyP13, yyP12, yyP11, yyP10)
 register tTree exp;
 register tTree fvar;
 register rbool * yyP14;
 register tTree * yyP13;
 register int * yyP12;
 register tTree * yyP11;
 register int * yyP10;
# endif
{
/* line 1164 "MapDefs.puma" */
 {
  int add_const;
  int mult_const;
  rbool found;
  tTree var;
  {
/* line 1172 "MapDefs.puma" */
   ResolveExpression (exp, & found, & mult_const, & add_const, & var);
/* line 1174 "MapDefs.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 1175 "MapDefs.puma" */
   if (! ((TreeVarName (var) == TreeVarName (fvar)))) goto yyL1;
  }
  }
   * yyP14 = rtrue;
   * yyP13 = NoTree;
   * yyP12 = mult_const;
   * yyP11 = NoTree;
   * yyP10 = add_const;
   return;
 }
yyL1:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
/* line 1178 "MapDefs.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  {
/* line 1181 "MapDefs.puma" */
   if (! ((! FreeVarInExp (fvar, exp->OP_EXP.OPND2)))) goto yyL2;
  {
/* line 1183 "MapDefs.puma" */
   ResolveFreeVar (exp->OP_EXP.OPND1, fvar, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
/* line 1185 "MapDefs.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 1186 "MapDefs.puma" */
   if (! ((yyV2 == NoTree))) goto yyL2;
  {
/* line 1187 "MapDefs.puma" */
   if (! ((yyV4 == NoTree))) goto yyL2;
  }
  }
  }
  }
   * yyP14 = yyV1;
   * yyP13 = exp->OP_EXP.OPND2;
   * yyP12 = yyV3;
   * yyP11 = yyV4;
   * yyP10 = yyV5 * yyV3;
   return;
 }
yyL2:;

/* line 1190 "MapDefs.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  {
/* line 1193 "MapDefs.puma" */
   if (! ((! FreeVarInExp (fvar, exp->OP_EXP.OPND1)))) goto yyL3;
  {
/* line 1195 "MapDefs.puma" */
   ResolveFreeVar (exp->OP_EXP.OPND2, fvar, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
/* line 1197 "MapDefs.puma" */
   if (! ((yyV1))) goto yyL3;
  {
/* line 1198 "MapDefs.puma" */
   if (! ((yyV2 == NoTree))) goto yyL3;
  {
/* line 1199 "MapDefs.puma" */
   if (! ((yyV4 == NoTree))) goto yyL3;
  }
  }
  }
  }
   * yyP14 = yyV1;
   * yyP13 = exp->OP_EXP.OPND1;
   * yyP12 = yyV3;
   * yyP11 = yyV4;
   * yyP10 = yyV5 * yyV3;
   return;
 }
yyL3:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
/* line 1202 "MapDefs.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  {
/* line 1205 "MapDefs.puma" */
   if (! ((! FreeVarInExp (fvar, exp->OP_EXP.OPND2)))) goto yyL4;
  {
/* line 1207 "MapDefs.puma" */
   ResolveFreeVar (exp->OP_EXP.OPND1, fvar, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
/* line 1209 "MapDefs.puma" */
   if (! ((yyV1))) goto yyL4;
  {
/* line 1210 "MapDefs.puma" */
   if (! ((yyV4 == NoTree))) goto yyL4;
  }
  }
  }
   * yyP14 = yyV1;
   * yyP13 = yyV2;
   * yyP12 = yyV3;
   * yyP11 = exp->OP_EXP.OPND2;
   * yyP10 = yyV5;
   return;
 }
yyL4:;

/* line 1213 "MapDefs.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  {
/* line 1216 "MapDefs.puma" */
   if (! ((! FreeVarInExp (fvar, exp->OP_EXP.OPND1)))) goto yyL5;
  {
/* line 1218 "MapDefs.puma" */
   ResolveFreeVar (exp->OP_EXP.OPND2, fvar, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
/* line 1220 "MapDefs.puma" */
   if (! ((yyV1))) goto yyL5;
  {
/* line 1221 "MapDefs.puma" */
   if (! ((yyV4 == NoTree))) goto yyL5;
  }
  }
  }
   * yyP14 = yyV1;
   * yyP13 = yyV2;
   * yyP12 = yyV3;
   * yyP11 = exp->OP_EXP.OPND1;
   * yyP10 = yyV5;
   return;
 }
yyL5:;

  }
  }
/* line 1226 "MapDefs.puma" */
   * yyP14 = rfalse;
   * yyP13 = NoTree;
   * yyP12 = 0;
   * yyP11 = NoTree;
   * yyP10 = 0;
   return;

;
}

static rbool FreeVarInExp
# if defined __STDC__ | defined __cplusplus
(register tTree fvar, register tTree exp)
# else
(fvar, exp)
 register tTree fvar;
 register tTree exp;
# endif
{
/* line 1239 "MapDefs.puma" */
  {
/* line 1241 "MapDefs.puma" */
   if (! ((IsVarInExp (TreeVarName (fvar), exp)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

static void MakeAlignTypes
# if defined __STDC__ | defined __cplusplus
(register tTree align_source)
# else
(align_source)
 register tTree align_source;
# endif
{
 yyRecursion:
  if (align_source->Kind == kBTE_LIST) {
/* line 1254 "MapDefs.puma" */
  {
/* line 1256 "MapDefs.puma" */
   MakeAlignTypes (align_source->BTE_LIST.Elem);
/* line 1257 "MapDefs.puma" */
   align_source = align_source->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (align_source->Kind == kVAR_EXP) {
/* line 1260 "MapDefs.puma" */
  {
/* line 1262 "MapDefs.puma" */
   align_source = align_source->VAR_EXP.V;
   goto yyRecursion;
  }

  }
  if (align_source->Kind == kUSED_VAR) {
/* line 1265 "MapDefs.puma" */
 {
  tDefinitions my_unit_obj;
  {
/* line 1269 "MapDefs.puma" */
 my_unit_obj = GetCurrentUnitObject ();

     align_source->USED_VAR.VARNAME->VAR_OBJ.Object    = GetLocalObject (align_source->USED_VAR.VARNAME->VAR_OBJ.Ident);

     

     if (align_source->USED_VAR.VARNAME->VAR_OBJ.Object == NoObject)
        align_source->USED_VAR.VARNAME->VAR_OBJ.Object = GetLocalVarEntity (align_source->USED_VAR.VARNAME->VAR_OBJ.Ident, align_source->USED_VAR.VARNAME->VAR_OBJ.Pos, my_unit_obj);

     MakeAlignVar (align_source->USED_VAR.VARNAME->VAR_OBJ.Object, align_source, my_unit_obj);

   
  }
   return;
 }

  }
  if (align_source->Kind == kBTE_EMPTY) {
/* line 1283 "MapDefs.puma" */
   return;

  }
;
}

static void MakeAlignVar
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree var, register tDefinitions my_unit)
# else
(obj, var, my_unit)
 register tDefinitions obj;
 register tTree var;
 register tDefinitions my_unit;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
  if (obj->VarObject.decl->VAR_DECL.VAL->Kind == kDUMMY_TYPE) {
/* line 1295 "MapDefs.puma" */
  {
/* line 1299 "MapDefs.puma" */
   if (! ((obj->VarObject.in == my_unit))) goto yyL1;
  {
/* line 1301 "MapDefs.puma" */
 obj->VarObject.decl->VAR_DECL.VAL = mALIGN_TYPE (); 
  }
  }
   return;
yyL1:;

  }
  if (obj->VarObject.decl->VAR_DECL.VAL->Kind == kALIGN_TYPE) {
/* line 1306 "MapDefs.puma" */
   return;

  }
  if (obj->VarObject.decl->VAR_DECL.VAL->Kind == kINTEGER_TYPE) {
/* line 1309 "MapDefs.puma" */
   return;

  }
  }
  }
/* line 1312 "MapDefs.puma" */
  {
/* line 1314 "MapDefs.puma" */
   warning_protocol ("ALIGN subscript not INTEGER");
/* line 1315 "MapDefs.puma" */
   tree_protocol ("illegal subscript is : ", var);
/* line 1316 "MapDefs.puma" */
   tree_protocol ("illegal type is : ", obj->Object.decl);
  }
   return;

;
}

void BeginMapDefs ARGS ((void))
{
}

void CloseMapDefs ARGS ((void))
{
}
