# include "MakeSerial.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 42 "MakeSerial.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "DefTable.h" 
# include "TreeOps.h"          /* IsForallLoop, IsIndepLoop    */
# include "Traverse.h"
# include "Invariant.h"
# include "Transform.h"        /* CombineACF */

# include "FindHome.h"
# include "VarDescriptor.h"
# include "ExpDescriptor.h"    /* GetExpDescriptor */
# include "Expressions.h"      /* MakeNotExp */
# include "Nesting.h"          /* GetOuterLoop */
# include "Accepted.h"

# include "NewStatements.h"
# include "TempAssigns.h"
# include "Rank.h"
# include "Expansion.h"

# define MODULE "MakeSerial"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeSerial.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeSerial_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeSerial, routine %s failed\n",
  yyFunction);
 MakeSerial_Exit ();
}

void MakeSerial ARGS ((tTree t));
static rbool StopMakeSerial ARGS ((tTree t));
static tTree DoMakeSerial ARGS ((tTree t));
static rbool NeedsSerialization ARGS ((tTree stmt));
static rbool UpdatesExpression ARGS ((tTree stmts, tTree exp));
static void NewWhereMask ARGS ((tTree t, tTree * yyP2, tTree * yyP1));
static rbool NewWhereMaskRequired ARGS ((tTree t));
static void MakeNewWhereMask ARGS ((tTree t, tTree * yyP4, tTree * yyP3));
static void NewIfMask ARGS ((tTree t, tTree * yyP6, tTree * yyP5));
static rbool NewIfMaskRequired ARGS ((tTree t));
static void MakeNewIfMask ARGS ((tTree t, tTree * yyP8, tTree * yyP7));
static void NewForallBounds ARGS ((tTree t, tTree * yyP10, tTree * yyP9));
static rbool NewForallBoundsRequired ARGS ((tTree t));
static tTree SplitWhere ARGS ((tTree where_stmt));
static tTree SplitIf ARGS ((tTree if_stmt));
static void SplitAssign ARGS ((tTree s, tTree * yyP12, tTree * yyP11));
static void MyMakeTempAssignment ARGS ((tTree exp, pvar vard, tTree * yyP15, tTree * yyP14, tTree * yyP13));
static rbool HasOuterIndependentLoop ARGS ((void));

void MakeSerial
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 80 "MakeSerial.puma" */
  {
/* line 82 "MakeSerial.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeSerial, DoMakeSerial); 
  }
   return;

  }
/* line 85 "MakeSerial.puma" */
  {
/* line 86 "MakeSerial.puma" */
   failure_protocol (MODULE, "MakeSerial", t);
  }
   return;

;
}

static rbool StopMakeSerial
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 103 "MakeSerial.puma" */
  {
/* line 104 "MakeSerial.puma" */
   return rfalse;
  }

}

static tTree DoMakeSerial
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 130 "MakeSerial.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree new;
  {
/* line 132 "MakeSerial.puma" */
   if (! ((NeedsSerialization (t)))) goto yyL1;
  {
/* line 134 "MakeSerial.puma" */
   stmt_protocol ("array assignment will be serialized");
/* line 136 "MakeSerial.puma" */
   SplitAssign (t->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
/* line 140 "MakeSerial.puma" */
   new = ComposeNewACF (yyV1, t, yyV2);
/* line 142 "MakeSerial.puma" */
   tree_protocol ("after serialization : \n", new);
  }
  }
   return new;
 }
yyL1:;

/* line 147 "MakeSerial.puma" */
   return t;

  }
  }
  if (t->Kind == kACF_WHERE) {
/* line 162 "MakeSerial.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree new;
  {
/* line 166 "MakeSerial.puma" */
   NewWhereMask (t, & yyV1, & yyV2);
/* line 170 "MakeSerial.puma" */
   new = CombineACF (yyV1, CombineACF (SplitWhere (t), yyV2));
/* line 172 "MakeSerial.puma" */
   tree_protocol ("serialized WHERE statement: \n", new);
  }
   return new;
 }

  }
  if (t->Kind == kACF_IF) {
/* line 187 "MakeSerial.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree new;
  {
/* line 189 "MakeSerial.puma" */
   if (! ((OuterLoops () > 0))) goto yyL4;
  {
/* line 191 "MakeSerial.puma" */
   if (! ((IsForallLoop (GetOuterLoop (OuterLoops ()))))) goto yyL4;
  {
/* line 195 "MakeSerial.puma" */
   NewIfMask (t, & yyV1, & yyV2);
/* line 199 "MakeSerial.puma" */
   new = CombineACF (yyV1, CombineACF (SplitIf (t), yyV2));
/* line 201 "MakeSerial.puma" */
   tree_protocol ("serialized FORALL mask statement: \n", new);
  }
  }
  }
   return new;
 }
yyL4:;

  }
  if (t->Kind == kACF_FORALL) {
/* line 229 "MakeSerial.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree new;
  {
/* line 233 "MakeSerial.puma" */
   NewForallBounds (t, & yyV1, & yyV2);
/* line 239 "MakeSerial.puma" */
   t->ACF_FORALL.FORALL_DEP_INFO = mINDEP_INFO (rfalse, 0, NoTree, NoTree);
/* line 243 "MakeSerial.puma" */
   new = t->ACF_FORALL.FORALL_BODY;
/* line 244 "MakeSerial.puma" */
   ExpandNewStatements (t->ACF_FORALL.FORALL_BODY, t, t->ACF_FORALL.Line);
/* line 245 "MakeSerial.puma" */
   new = CombineACF (yyV1, CombineACF (new, yyV2));
/* line 247 "MakeSerial.puma" */
   tree_protocol ("splitted forall : \n", new);
  }
   return new;
 }

  }
/* line 254 "MakeSerial.puma" */
   return t;

}

static rbool NeedsSerialization
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 273 "MakeSerial.puma" */
  {
/* line 275 "MakeSerial.puma" */
   if (! ((ForallVarExpDependences (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static rbool UpdatesExpression
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, register tTree exp)
# else
(stmts, exp)
 register tTree stmts;
 register tTree exp;
# endif
{
 yyRecursion:
  if (stmts->Kind == kACF_LIST) {
/* line 288 "MakeSerial.puma" */
  {
/* line 289 "MakeSerial.puma" */
   if (! (UpdatesExpression (stmts->ACF_LIST.Elem, exp))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 292 "MakeSerial.puma" */
  {
/* line 293 "MakeSerial.puma" */
   stmts = stmts->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (stmts->Kind == kACF_BASIC) {
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 296 "MakeSerial.puma" */
  {
/* line 298 "MakeSerial.puma" */
   if (! ((ForallVarExpDependences (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, exp)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  }
  if (stmts->Kind == kACF_WHERE) {
/* line 301 "MakeSerial.puma" */
  {
/* line 303 "MakeSerial.puma" */
   if (! (UpdatesExpression (stmts->ACF_WHERE.TRUE_PART, exp))) goto yyL4;
  {
/* line 304 "MakeSerial.puma" */
   stmts = stmts->ACF_WHERE.FALSE_PART;
   goto yyRecursion;
  }
  }
yyL4:;

  }
  return rfalse;
}

static void NewWhereMask
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP2, register tTree * yyP1)
# else
(t, yyP2, yyP1)
 register tTree t;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (t->Kind == kACF_WHERE) {
/* line 320 "MakeSerial.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 322 "MakeSerial.puma" */
   if (! ((NewWhereMaskRequired (t)))) goto yyL1;
  {
/* line 323 "MakeSerial.puma" */
   MakeNewWhereMask (t, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

/* line 328 "MakeSerial.puma" */
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  }
;
}

static rbool NewWhereMaskRequired
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_WHERE) {
/* line 342 "MakeSerial.puma" */
  {
/* line 344 "MakeSerial.puma" */
   if (! ((UpdatesExpression (t->ACF_WHERE.TRUE_PART, t->ACF_WHERE.WHERE_EXP)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 347 "MakeSerial.puma" */
  {
/* line 349 "MakeSerial.puma" */
   if (! ((UpdatesExpression (t->ACF_WHERE.FALSE_PART, t->ACF_WHERE.WHERE_EXP)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  if (t->ACF_WHERE.WHERE_EXP->Kind == kVAR_EXP) {
/* line 352 "MakeSerial.puma" */
  {
/* line 354 "MakeSerial.puma" */
   if (! ((IsDescriptorVar (t->ACF_WHERE.WHERE_EXP->VAR_EXP.V)))) goto yyL3;
  {
/* line 355 "MakeSerial.puma" */
   return rfalse;
  }
  }
yyL3:;

  }
/* line 358 "MakeSerial.puma" */
   return rtrue;

  }
  return rfalse;
}

static void MakeNewWhereMask
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP4, register tTree * yyP3)
# else
(t, yyP4, yyP3)
 register tTree t;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
  if (t->Kind == kACF_WHERE) {
/* line 369 "MakeSerial.puma" */
 {
  var_descriptor vard;
  rbool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 374 "MakeSerial.puma" */
   GetExpDescriptor (t->ACF_WHERE.WHERE_EXP, & found, & vard);
/* line 375 "MakeSerial.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 377 "MakeSerial.puma" */
   SetExpType (t->ACF_WHERE.WHERE_EXP, & vard);
/* line 379 "MakeSerial.puma" */
   MyMakeTempAssignment (t->ACF_WHERE.WHERE_EXP, & vard, & yyV1, & yyV2, & yyV3);
/* line 381 "MakeSerial.puma" */
 t->ACF_WHERE.WHERE_EXP = yyV1; 
  }
  }
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }
yyL1:;

  }
/* line 384 "MakeSerial.puma" */
  {
/* line 386 "MakeSerial.puma" */
   error_protocol ("no var descriptor for where statement");
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

;
}

static void NewIfMask
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP6, register tTree * yyP5)
# else
(t, yyP6, yyP5)
 register tTree t;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (t->Kind == kACF_IF) {
/* line 402 "MakeSerial.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 404 "MakeSerial.puma" */
   if (! ((NewIfMaskRequired (t)))) goto yyL1;
  {
/* line 405 "MakeSerial.puma" */
   MakeNewIfMask (t, & yyV1, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL1:;

/* line 410 "MakeSerial.puma" */
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
;
}

static rbool NewIfMaskRequired
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_IF) {
/* line 421 "MakeSerial.puma" */
  {
/* line 423 "MakeSerial.puma" */
   if (! ((UpdatesExpression (t->ACF_IF.THEN_PART, t->ACF_IF.IF_EXP)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 426 "MakeSerial.puma" */
  {
/* line 428 "MakeSerial.puma" */
   if (! ((UpdatesExpression (t->ACF_IF.ELSE_PART, t->ACF_IF.IF_EXP)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  if (t->ACF_IF.IF_EXP->Kind == kVAR_EXP) {
/* line 431 "MakeSerial.puma" */
  {
/* line 433 "MakeSerial.puma" */
   if (! ((IsDescriptorVar (t->ACF_IF.IF_EXP->VAR_EXP.V)))) goto yyL3;
  {
/* line 434 "MakeSerial.puma" */
   return rfalse;
  }
  }
yyL3:;

  }
/* line 437 "MakeSerial.puma" */
   return rtrue;

  }
  return rfalse;
}

static void MakeNewIfMask
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP8, register tTree * yyP7)
# else
(t, yyP8, yyP7)
 register tTree t;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
  if (t->Kind == kACF_IF) {
/* line 448 "MakeSerial.puma" */
 {
  var_descriptor vard;
  rbool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 453 "MakeSerial.puma" */
   GetExpDescriptor (t->ACF_IF.IF_EXP, & found, & vard);
/* line 454 "MakeSerial.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 462 "MakeSerial.puma" */
   SetExpType (t->ACF_IF.IF_EXP, & vard);
/* line 464 "MakeSerial.puma" */
   MyMakeTempAssignment (t->ACF_IF.IF_EXP, & vard, & yyV1, & yyV2, & yyV3);
/* line 466 "MakeSerial.puma" */
 t->ACF_IF.IF_EXP = yyV1; 
  }
  }
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }
yyL1:;

  }
/* line 469 "MakeSerial.puma" */
  {
/* line 471 "MakeSerial.puma" */
   error_protocol ("no var descriptor for masked forall statement");
  }
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

;
}

static void NewForallBounds
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP10, register tTree * yyP9)
# else
(t, yyP10, yyP9)
 register tTree t;
 register tTree * yyP10;
 register tTree * yyP9;
# endif
{
  if (t->Kind == kACF_FORALL) {
/* line 486 "MakeSerial.puma" */
  {
/* line 490 "MakeSerial.puma" */
   if (! ((NewForallBoundsRequired (t)))) goto yyL1;
  {
/* line 492 "MakeSerial.puma" */
   error_protocol ("cannot create new bounds for FORALL loops");
  }
  }
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;
yyL1:;

/* line 495 "MakeSerial.puma" */
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;

  }
;
}

static rbool NewForallBoundsRequired
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_FORALL) {
/* line 506 "MakeSerial.puma" */
  {
/* line 508 "MakeSerial.puma" */
   if (! ((UpdatesExpression (t->ACF_FORALL.FORALL_BODY, t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.FIRST)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 511 "MakeSerial.puma" */
  {
/* line 513 "MakeSerial.puma" */
   if (! ((UpdatesExpression (t->ACF_FORALL.FORALL_BODY, t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.STOP)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 516 "MakeSerial.puma" */
  {
/* line 518 "MakeSerial.puma" */
   if (! ((UpdatesExpression (t->ACF_FORALL.FORALL_BODY, t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.INC)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static tTree SplitWhere
# if defined __STDC__ | defined __cplusplus
(register tTree where_stmt)
# else
(where_stmt)
 register tTree where_stmt;
# endif
{
  if (where_stmt->Kind == kACF_WHERE) {
/* line 538 "MakeSerial.puma" */
  {
/* line 540 "MakeSerial.puma" */
   MaskNewStatements (where_stmt->ACF_WHERE.TRUE_PART, where_stmt->ACF_WHERE.WHERE_EXP, rtrue, where_stmt->ACF_WHERE.Line);
/* line 541 "MakeSerial.puma" */
   MaskNewStatements (where_stmt->ACF_WHERE.FALSE_PART, where_stmt->ACF_WHERE.WHERE_EXP, rfalse, where_stmt->ACF_WHERE.Line);
  }
   return CombineACF (where_stmt->ACF_WHERE.TRUE_PART, where_stmt->ACF_WHERE.FALSE_PART);

  }
/* line 546 "MakeSerial.puma" */
  {
/* line 547 "MakeSerial.puma" */
   failure_protocol (MODULE, "SplitWhere", where_stmt);
  }
   return NoTree;

}

static tTree SplitIf
# if defined __STDC__ | defined __cplusplus
(register tTree if_stmt)
# else
(if_stmt)
 register tTree if_stmt;
# endif
{
  if (if_stmt->Kind == kACF_IF) {
/* line 568 "MakeSerial.puma" */
  {
/* line 570 "MakeSerial.puma" */
   MaskNewStatements (if_stmt->ACF_IF.THEN_PART, if_stmt->ACF_IF.IF_EXP, rtrue, if_stmt->ACF_IF.Line);
/* line 571 "MakeSerial.puma" */
   MaskNewStatements (if_stmt->ACF_IF.ELSE_PART, if_stmt->ACF_IF.IF_EXP, rfalse, if_stmt->ACF_IF.Line);
  }
   return CombineACF (if_stmt->ACF_IF.THEN_PART, if_stmt->ACF_IF.ELSE_PART);

  }
/* line 576 "MakeSerial.puma" */
  {
/* line 577 "MakeSerial.puma" */
   failure_protocol (MODULE, "SplitIf", if_stmt);
  }
   return NoTree;

}

static void SplitAssign
# if defined __STDC__ | defined __cplusplus
(register tTree s, register tTree * yyP12, register tTree * yyP11)
# else
(s, yyP12, yyP11)
 register tTree s;
 register tTree * yyP12;
 register tTree * yyP11;
# endif
{
  if (s->Kind == kASSIGN_STMT) {
/* line 599 "MakeSerial.puma" */
 {
  var_descriptor vard;
  rbool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 604 "MakeSerial.puma" */
   if (! ((TreeRank (s->ASSIGN_STMT.ASSIGN_EXP) < TreeRank (s->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  {
/* line 606 "MakeSerial.puma" */
   GetExpDescriptor (s->ASSIGN_STMT.ASSIGN_EXP, & found, & vard);
/* line 607 "MakeSerial.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 609 "MakeSerial.puma" */
   MyMakeTempAssignment (s->ASSIGN_STMT.ASSIGN_EXP, & vard, & yyV1, & yyV2, & yyV3);
/* line 611 "MakeSerial.puma" */
 s->ASSIGN_STMT.ASSIGN_EXP = yyV1; 
  }
  }
  }
   * yyP12 = yyV2;
   * yyP11 = yyV3;
   return;
 }
yyL1:;

/* line 614 "MakeSerial.puma" */
 {
  var_descriptor vard;
  rbool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 619 "MakeSerial.puma" */
   GetVarDescriptor (s->ASSIGN_STMT.ASSIGN_VAR, & found, & vard);
/* line 620 "MakeSerial.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 622 "MakeSerial.puma" */
   SetExpType (s->ASSIGN_STMT.ASSIGN_EXP, & vard);
/* line 624 "MakeSerial.puma" */
   MyMakeTempAssignment (s->ASSIGN_STMT.ASSIGN_EXP, & vard, & yyV1, & yyV2, & yyV3);
/* line 626 "MakeSerial.puma" */
 s->ASSIGN_STMT.ASSIGN_EXP = yyV1; 
  }
  }
   * yyP12 = yyV2;
   * yyP11 = yyV3;
   return;
 }
yyL2:;

  }
/* line 629 "MakeSerial.puma" */
  {
/* line 631 "MakeSerial.puma" */
   error_protocol ("no home descriptor for this assignment");
  }
   * yyP12 = NoTree;
   * yyP11 = NoTree;
   return;

;
}

static void MyMakeTempAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP15, register tTree * yyP14, register tTree * yyP13)
# else
(exp, vard, yyP15, yyP14, yyP13)
 register tTree exp;
 pvar vard;
 register tTree * yyP15;
 register tTree * yyP14;
 register tTree * yyP13;
# endif
{
/* line 644 "MakeSerial.puma" */
 {
  tTree pre_stmt;
  tTree post_stmt;
  tTree new_exp;
  {
/* line 650 "MakeSerial.puma" */
   ForallExpansion (vard);
/* line 654 "MakeSerial.puma" */
 if (HasOuterIndependentLoop ())

         { vard->topology_rank = 0;
           vard->topology_obj = GetDefaultTopology (0);
         }
    
/* line 661 "MakeSerial.puma" */
   MakeTempAssignment (exp, vard, & new_exp, & pre_stmt, & post_stmt);
  }
   * yyP15 = new_exp;
   * yyP14 = pre_stmt;
   * yyP13 = post_stmt;
   return;
 }

;
}

static rbool HasOuterIndependentLoop
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 672 "MakeSerial.puma" */
 {
  rbool parloop;
  {
/* line 675 "MakeSerial.puma" */
 int i;
      parloop = rfalse;
 
      for (i=1; i<= OuterLoops(); i++)
        parloop = parloop || IsIndepDoLoop (GetOuterLoop(i));
    
/* line 681 "MakeSerial.puma" */
   if (! ((parloop))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

void BeginMakeSerial ARGS ((void))
{
}

void CloseMakeSerial ARGS ((void))
{
}
