# include "MakeRemapping.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 21 "MakeRemapping.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
 
# include "protocol.h"

# include "Traverse.h"     /* ReplaceAST, ...                      */
# include "Transform.h"    /* ComposeACF, ...                      */

# include "Rank.h"
# include "Objects.h"          /* IsLocalCall            */
# include "Distributions.h"
# include "MoveControl.h"
# include "Nesting.h"          /* GetCurrentModel        */
# include "Intrinsics.h"
# include "SpecialMap.h"
# include "VarDescriptor.h" 
# include "FindHome.h"         /* FindSerialHome         */
# include "ExpDescriptor.h"    /* GetDummyVarDescriptor  */
# include "Descriptor.h"       /* PrintableDescriptorVar */
# include "Expansion.h"        /* NoExpansion            */
# include "TempAssigns.h"      /* MakeTempVarStmt        */

# define MODULE "MakeRemapping"
 
# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeRemapping.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeRemapping_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeRemapping, routine %s failed\n",
  yyFunction);
 MakeRemapping_Exit ();
}

void MakeRemapping ARGS ((tTree t));
static rbool StopMakeRemapArgs ARGS ((tTree t));
static tTree DoMakeRemapArgs ARGS ((tTree t));
static rbool CanHaveRemapping ARGS ((tTree stmt));
static void RemappingArguments ARGS ((tTree basic_stmt, tTree * yyP2, tTree * yyP1));
static void IntrArgRemapping ARGS ((tIdent name, tTree var, tTree actuals, tTree * yyP4, tTree * yyP3));
static void AlignParamList ARGS ((tTree target, tTree params, tTree * yyP6, tTree * yyP5));
static void AlignParam ARGS ((tTree target, tTree param, tTree * yyP8, tTree * yyP7));
static void ParamListRemapping ARGS ((tTree actuals, tTree call, tTree * yyP10, tTree * yyP9));
static void ParamRemapping ARGS ((tTree actual, tTree call, tTree * yyP12, tTree * yyP11));
static void IntrResRemapping ARGS ((tIdent name, tTree assign, tTree * yyP14, tTree * yyP13));
static void NewResultTmp ARGS ((tTree assign, tTree * yyP16, tTree * yyP15));
static void MakeSerialArguments ARGS ((tTree actuals, tTree * yyP18, tTree * yyP17));
static void MakeSerialArgument ARGS ((tTree actual, tTree * yyP20, tTree * yyP19));
static void MakeSerialVar ARGS ((tTree var, tTree * yyP23, tTree * yyP22, tTree * yyP21));
static rbool AcceptedSerialVar ARGS ((tTree var));
static rbool MightBeRedistributed ARGS ((tTree p, tTree actual, tDefinitions dummy));
static void FindParamDescriptor ARGS ((tTree actual, rbool * yyP25, var_descriptor * yyP24));
static void MakeParamTemporary ARGS ((tTree actual, pvar vard, tTree * yyP27, tTree * yyP26));
static void MakeNewAssignment ARGS ((tTree exp, pvar vard, tTree * yyP30, tTree * yyP29, tTree * yyP28));

void MakeRemapping
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 60 "MakeRemapping.puma" */
  {
/* line 62 "MakeRemapping.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeRemapArgs, DoMakeRemapArgs); 
  }
   return;

  }
/* line 65 "MakeRemapping.puma" */
  {
/* line 66 "MakeRemapping.puma" */
   failure_protocol (MODULE, "MakeRemapping", t);
  }
   return;

;
}

static rbool StopMakeRemapArgs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 83 "MakeRemapping.puma" */
  {
/* line 84 "MakeRemapping.puma" */
   return rfalse;
  }

}

static tTree DoMakeRemapArgs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
/* line 95 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 97 "MakeRemapping.puma" */
   if (! ((CanHaveRemapping (t->ACF_BASIC.BASIC_STMT)))) goto yyL1;
  {
/* line 99 "MakeRemapping.puma" */
   RemappingArguments (t->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
/* line 101 "MakeRemapping.puma" */
 if (yyV1 != NoTree)

      { set_protocol_stmt (t);
        stmt_protocol ("remapping necessary for this stmt");
        tree_protocol ("pre_stmts  : \n", yyV1);
        tree_protocol ("post_stmts : \n", yyV2);
      }
  
  }
  }
   return ComposeNewACF (yyV1, t, yyV2);
 }
yyL1:;

  }
/* line 113 "MakeRemapping.puma" */
   return t;

}

static rbool CanHaveRemapping
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kCALL_STMT) {
/* line 125 "MakeRemapping.puma" */
   return rtrue;

  }
  if (stmt->Kind == kASSIGN_STMT) {
  if (stmt->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 128 "MakeRemapping.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static void RemappingArguments
# if defined __STDC__ | defined __cplusplus
(register tTree basic_stmt, register tTree * yyP2, register tTree * yyP1)
# else
(basic_stmt, yyP2, yyP1)
 register tTree basic_stmt;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (basic_stmt->Kind == kASSIGN_STMT) {
  if (basic_stmt->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 138 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 142 "MakeRemapping.puma" */
   if (! ((IsIntrCall (basic_stmt->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL1;
  {
/* line 144 "MakeRemapping.puma" */
   IntrArgRemapping (basic_stmt->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, basic_stmt->ASSIGN_STMT.ASSIGN_VAR, basic_stmt->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
/* line 145 "MakeRemapping.puma" */
   IntrResRemapping (basic_stmt->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, basic_stmt, & yyV3, & yyV4);
/* line 147 "MakeRemapping.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 148 "MakeRemapping.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

/* line 151 "MakeRemapping.puma" */
 {
  rbool found;
  var_descriptor home;
  {
/* line 155 "MakeRemapping.puma" */
   if (! ((IsSerialCall (basic_stmt->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
/* line 160 "MakeRemapping.puma" */
   FindSerialHome (basic_stmt, & home, & found);
/* line 161 "MakeRemapping.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 163 "MakeRemapping.puma" */
   stmt_protocol ("serial function call on dedicated home (no remapping)");
/* line 164 "MakeRemapping.puma" */
   tree_protocol ("home of serial call : ", PrintableDescriptorVar (& home));
  }
  }
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
 }
yyL2:;

/* line 167 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
/* line 171 "MakeRemapping.puma" */
   if (! ((IsSerialCall (basic_stmt->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL3;
  {
/* line 173 "MakeRemapping.puma" */
   stmt_protocol ("serial call will be executed on HOST");
/* line 175 "MakeRemapping.puma" */
   MakeSerialArguments (basic_stmt->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
/* line 176 "MakeRemapping.puma" */
   MakeSerialVar (basic_stmt->ASSIGN_STMT.ASSIGN_VAR, & yyV3, & yyV4, & yyV5);
/* line 178 "MakeRemapping.puma" */
 basic_stmt->ASSIGN_STMT.ASSIGN_VAR = yyV3; 
/* line 180 "MakeRemapping.puma" */
   yyV1 = CombineACF (yyV4, yyV1);
/* line 181 "MakeRemapping.puma" */
   yyV2 = CombineACF (yyV2, yyV5);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

  }
  }
  if (basic_stmt->Kind == kCALL_STMT) {
/* line 184 "MakeRemapping.puma" */
 {
  rbool found;
  var_descriptor home;
  {
/* line 186 "MakeRemapping.puma" */
   if (! ((IsSerialCall (basic_stmt)))) goto yyL4;
  {
/* line 191 "MakeRemapping.puma" */
   FindSerialHome (basic_stmt, & home, & found);
/* line 192 "MakeRemapping.puma" */
   if (! ((found))) goto yyL4;
  {
/* line 194 "MakeRemapping.puma" */
   stmt_protocol ("serial subroutine call on dedicated home (no remapping)");
/* line 195 "MakeRemapping.puma" */
   tree_protocol ("home of serial call : ", PrintableDescriptorVar (& home));
  }
  }
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
 }
yyL4:;

/* line 198 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 200 "MakeRemapping.puma" */
   if (! ((IsSerialCall (basic_stmt)))) goto yyL5;
  {
/* line 202 "MakeRemapping.puma" */
   stmt_protocol ("serial subroutine call will be executed on HOST");
/* line 204 "MakeRemapping.puma" */
   MakeSerialArguments (basic_stmt->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL5:;

/* line 207 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 209 "MakeRemapping.puma" */
   ParamListRemapping (basic_stmt->CALL_STMT.CALL_PARAMS, basic_stmt, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
/* line 212 "MakeRemapping.puma" */
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void IntrArgRemapping
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree var, register tTree actuals, register tTree * yyP4, register tTree * yyP3)
# else
(name, var, actuals, yyP4, yyP3)
 register tIdent name;
 register tTree var;
 register tTree actuals;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
  if (actuals->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (actuals->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 233 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 236 "MakeRemapping.puma" */
   if (! ((IntrFuncScatter (name)))) goto yyL1;
  {
/* line 240 "MakeRemapping.puma" */
   AlignParamList (actuals->BTP_LIST.Elem->VAR_PARAM.V, actuals->BTP_LIST.Next->BTP_LIST.Next, & yyV1, & yyV2);
  }
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }
yyL1:;

  }
  }
  }
/* line 243 "MakeRemapping.puma" */
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

;
}

static void AlignParamList
# if defined __STDC__ | defined __cplusplus
(register tTree target, register tTree params, register tTree * yyP6, register tTree * yyP5)
# else
(target, params, yyP6, yyP5)
 register tTree target;
 register tTree params;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (params->Kind == kBTP_LIST) {
/* line 255 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 257 "MakeRemapping.puma" */
   AlignParam (target, params->BTP_LIST.Elem, & yyV1, & yyV2);
/* line 258 "MakeRemapping.puma" */
   AlignParamList (target, params->BTP_LIST.Next, & yyV3, & yyV4);
/* line 260 "MakeRemapping.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 261 "MakeRemapping.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

  }
  if (params->Kind == kBTP_EMPTY) {
/* line 264 "MakeRemapping.puma" */
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
/* line 267 "MakeRemapping.puma" */
  {
/* line 269 "MakeRemapping.puma" */
   failure_protocol (MODULE, "AlignParamList", params);
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

;
}

static void AlignParam
# if defined __STDC__ | defined __cplusplus
(register tTree target, register tTree param, register tTree * yyP8, register tTree * yyP7)
# else
(target, param, yyP8, yyP7)
 register tTree target;
 register tTree param;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
  if (param->Kind == kVAR_PARAM) {
/* line 274 "MakeRemapping.puma" */
  {
/* line 278 "MakeRemapping.puma" */
   if (! ((TreeRank (param->VAR_PARAM.V) == 0))) goto yyL1;
  {
/* line 279 "MakeRemapping.puma" */
   if (! ((TreeReadDistribution (param) == 0))) goto yyL1;
  }
  }
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;
yyL1:;

/* line 282 "MakeRemapping.puma" */
 {
  var_descriptor vd1;
  var_descriptor vd2;
  rbool found;
  {
/* line 289 "MakeRemapping.puma" */
   GetVarDescriptor (target, & found, & vd1);
/* line 290 "MakeRemapping.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 291 "MakeRemapping.puma" */
   GetVarDescriptor (param->VAR_PARAM.V, & found, & vd2);
/* line 292 "MakeRemapping.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 294 "MakeRemapping.puma" */
 if (!VDIsAligned (&vd1, &vd2))
       { error_protocol ("SCATTER requires aligned parameters");
         tree_protocol ("not aligned argument is : ", param->VAR_PARAM.V);
         tree_protocol ("must be aligned to : ", target);
       }
   
  }
  }
  }
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;
 }
yyL2:;

  }
  if (param->Kind == kNO_PARAM) {
/* line 302 "MakeRemapping.puma" */
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

  }
/* line 307 "MakeRemapping.puma" */
  {
/* line 309 "MakeRemapping.puma" */
   error_protocol ("could not verify alignment in SCATTER");
/* line 310 "MakeRemapping.puma" */
   tree_protocol ("not verified argument is : ", param);
  }
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

;
}

static void ParamListRemapping
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree call, register tTree * yyP10, register tTree * yyP9)
# else
(actuals, call, yyP10, yyP9)
 register tTree actuals;
 register tTree call;
 register tTree * yyP10;
 register tTree * yyP9;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
/* line 320 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 322 "MakeRemapping.puma" */
   ParamRemapping (actuals->BTP_LIST.Elem, call, & yyV1, & yyV2);
/* line 323 "MakeRemapping.puma" */
   ParamListRemapping (actuals->BTP_LIST.Next, call, & yyV3, & yyV4);
/* line 325 "MakeRemapping.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 326 "MakeRemapping.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP10 = yyV1;
   * yyP9 = yyV2;
   return;
 }

  }
  if (actuals->Kind == kBTP_EMPTY) {
/* line 329 "MakeRemapping.puma" */
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;

  }
/* line 332 "MakeRemapping.puma" */
  {
/* line 334 "MakeRemapping.puma" */
   failure_protocol (MODULE, "ParamListRempapping", actuals);
  }
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;

;
}

static void ParamRemapping
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree call, register tTree * yyP12, register tTree * yyP11)
# else
(actual, call, yyP12, yyP11)
 register tTree actual;
 register tTree call;
 register tTree * yyP12;
 register tTree * yyP11;
# endif
{
  if (actual->Kind == kVAR_PARAM) {
/* line 339 "MakeRemapping.puma" */
 {
  rbool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  {
/* line 341 "MakeRemapping.puma" */
   if (! ((actual->VAR_PARAM.formal != NoObject))) goto yyL1;
  {
/* line 342 "MakeRemapping.puma" */
   if (! ((call != NoTree))) goto yyL1;
  {
/* line 344 "MakeRemapping.puma" */
   if (! ((IsNonLocalModel (GetCurrentModel ())))) goto yyL1;
  {
/* line 346 "MakeRemapping.puma" */
   if (! ((IsLocalCall (call)))) goto yyL1;
  {
/* line 348 "MakeRemapping.puma" */
   if (! ((MightBeRedistributed (call, actual, actual->VAR_PARAM.formal)))) goto yyL1;
  {
/* line 353 "MakeRemapping.puma" */
   GetDummyVarDescriptor (actual, actual->VAR_PARAM.formal, call, & found, & vard);
/* line 355 "MakeRemapping.puma" */
 if (!found)

       { error_protocol ("could not create dummy descriptor");
         tree_protocol ("actual", actual);
       }

     else

       { char msg[80];
         char vstr[40];
         StrUnparse (vstr, 40, actual->VAR_PARAM.V);
         sprintf (msg, "argument %s of call will be redistributed", vstr);
         serious_warning_protocol (msg);
       }

   
/* line 372 "MakeRemapping.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 374 "MakeRemapping.puma" */
   MakeParamTemporary (actual, & vard, & yyV1, & yyV2);
  }
  }
  }
  }
  }
  }
  }
   * yyP12 = yyV1;
   * yyP11 = yyV2;
   return;
 }
yyL1:;

/* line 377 "MakeRemapping.puma" */
  {
/* line 379 "MakeRemapping.puma" */
   if (! ((actual->VAR_PARAM.formal != NoObject))) goto yyL2;
  {
/* line 380 "MakeRemapping.puma" */
   if (! ((call != NoTree))) goto yyL2;
  {
/* line 384 "MakeRemapping.puma" */
 

     if (MightBeRedistributed (call, actual, actual->VAR_PARAM.formal))

        { char msg[80];
          char vstr[40];
          StrUnparse (vstr, 40, actual->VAR_PARAM.V);
          sprintf (msg, "argument %s of call might be redistributed", vstr);
          serious_warning_protocol (msg);
        }
   
  }
  }
  }
   * yyP12 = NoTree;
   * yyP11 = NoTree;
   return;
yyL2:;

  }
/* line 398 "MakeRemapping.puma" */
   * yyP12 = NoTree;
   * yyP11 = NoTree;
   return;

;
}

static void IntrResRemapping
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree assign, register tTree * yyP14, register tTree * yyP13)
# else
(name, assign, yyP14, yyP13)
 register tIdent name;
 register tTree assign;
 register tTree * yyP14;
 register tTree * yyP13;
# endif
{
/* line 410 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 412 "MakeRemapping.puma" */
   if (! ((IntrFuncRed (name) || IntrFuncLocRed (name)))) goto yyL1;
  {
/* line 414 "MakeRemapping.puma" */
   NewResultTmp (assign, & yyV1, & yyV2);
  }
  }
   * yyP14 = yyV1;
   * yyP13 = yyV2;
   return;
 }
yyL1:;

/* line 417 "MakeRemapping.puma" */
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

;
}

static void NewResultTmp
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register tTree * yyP16, register tTree * yyP15)
# else
(assign, yyP16, yyP15)
 register tTree assign;
 register tTree * yyP16;
 register tTree * yyP15;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 428 "MakeRemapping.puma" */
 {
  rbool found;
  var_descriptor vard1;
  var_descriptor vard2;
  {
/* line 436 "MakeRemapping.puma" */
   GetExpDescriptor (assign->ASSIGN_STMT.ASSIGN_EXP, & found, & vard2);
/* line 437 "MakeRemapping.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 439 "MakeRemapping.puma" */
   GetVarDescriptor (assign->ASSIGN_STMT.ASSIGN_VAR, & found, & vard1);
/* line 440 "MakeRemapping.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 442 "MakeRemapping.puma" */

#ifdef DEBUG
    if (!VDIsLocalAssignment (&vard1, &vard2))
       { printf ("temp for fn_call(1) in : ");
         FileUnparse (stdout, assign); printf ("\n");
         PrintVarDescriptor (&vard1);
         PrintVarDescriptor (&vard2);
       }
     else if (!VDIsLocalAssignment (&vard2, &vard1))
       { printf ("temp for fn_call(2) in : ");
         FileUnparse (stdout, assign); printf ("\n");
         PrintVarDescriptor (&vard1);
         PrintVarDescriptor (&vard2);
       }
#endif
   
/* line 459 "MakeRemapping.puma" */
   if (! ((VDIsLocalAssignment (& vard1, & vard2)))) goto yyL1;
  {
/* line 460 "MakeRemapping.puma" */
   if (! ((VDIsLocalAssignment (& vard2, & vard1)))) goto yyL1;
  }
  }
  }
  }
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;
 }
yyL1:;

/* line 463 "MakeRemapping.puma" */
 {
  rbool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 468 "MakeRemapping.puma" */
   GetExpDescriptor (assign->ASSIGN_STMT.ASSIGN_EXP, & found, & vard);
/* line 469 "MakeRemapping.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 471 "MakeRemapping.puma" */
   MakeNewAssignment (assign->ASSIGN_STMT.ASSIGN_EXP, & vard, & yyV1, & yyV2, & yyV3);
/* line 472 "MakeRemapping.puma" */
 assign->ASSIGN_STMT.ASSIGN_EXP = yyV1; 
  }
  }
   * yyP16 = yyV2;
   * yyP15 = yyV3;
   return;
 }
yyL2:;

/* line 475 "MakeRemapping.puma" */
  {
/* line 477 "MakeRemapping.puma" */
   error_protocol ("no descriptor for required result remapping found");
/* line 478 "MakeRemapping.puma" */
   tree_protocol ("call is : ", assign->ASSIGN_STMT.ASSIGN_EXP);
  }
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
  }
;
}

static void MakeSerialArguments
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree * yyP18, register tTree * yyP17)
# else
(actuals, yyP18, yyP17)
 register tTree actuals;
 register tTree * yyP18;
 register tTree * yyP17;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
/* line 489 "MakeRemapping.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 491 "MakeRemapping.puma" */
   MakeSerialArgument (actuals->BTP_LIST.Elem, & yyV1, & yyV2);
/* line 492 "MakeRemapping.puma" */
   MakeSerialArguments (actuals->BTP_LIST.Next, & yyV3, & yyV4);
/* line 494 "MakeRemapping.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 495 "MakeRemapping.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP18 = yyV1;
   * yyP17 = yyV2;
   return;
 }

  }
  if (actuals->Kind == kBTP_EMPTY) {
/* line 498 "MakeRemapping.puma" */
   * yyP18 = NoTree;
   * yyP17 = NoTree;
   return;

  }
;
}

static void MakeSerialArgument
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree * yyP20, register tTree * yyP19)
# else
(actual, yyP20, yyP19)
 register tTree actual;
 register tTree * yyP20;
 register tTree * yyP19;
# endif
{
  if (actual->Kind == kVAR_PARAM) {
/* line 503 "MakeRemapping.puma" */
  {
/* line 505 "MakeRemapping.puma" */
   if (! ((AcceptedSerialVar (actual->VAR_PARAM.V)))) goto yyL1;
  }
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;
yyL1:;

  }
  if (actual->Kind == kNO_PARAM) {
/* line 508 "MakeRemapping.puma" */
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

  }
  if (actual->Kind == kFUNC_PARAM) {
/* line 511 "MakeRemapping.puma" */
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

  }
  if (actual->Kind == kPROC_PARAM) {
/* line 514 "MakeRemapping.puma" */
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

  }
/* line 517 "MakeRemapping.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 519 "MakeRemapping.puma" */
   FindParamDescriptor (actual, & yyV1, & yyV2);
/* line 520 "MakeRemapping.puma" */
   if (! ((yyV1))) goto yyL5;
  {
/* line 522 "MakeRemapping.puma" */
 yyV2.topology_rank = -1;    
/* line 524 "MakeRemapping.puma" */
   MakeParamTemporary (actual, & yyV2, & yyV3, & yyV4);
  }
  }
   * yyP20 = yyV3;
   * yyP19 = yyV4;
   return;
 }
yyL5:;

/* line 527 "MakeRemapping.puma" */
  {
/* line 529 "MakeRemapping.puma" */
   error_protocol ("could not serialize actual argument");
/* line 530 "MakeRemapping.puma" */
   tree_protocol ("actual argument : ", actual);
  }
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

;
}

static void MakeSerialVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree * yyP23, register tTree * yyP22, register tTree * yyP21)
# else
(var, yyP23, yyP22, yyP21)
 register tTree var;
 register tTree * yyP23;
 register tTree * yyP22;
 register tTree * yyP21;
# endif
{
/* line 535 "MakeRemapping.puma" */
  {
/* line 537 "MakeRemapping.puma" */
   if (! ((AcceptedSerialVar (var)))) goto yyL1;
  }
   * yyP23 = var;
   * yyP22 = NoTree;
   * yyP21 = NoTree;
   return;
yyL1:;

/* line 540 "MakeRemapping.puma" */
 {
  var_descriptor vard;
  tTree pre_stmts;
  tTree post_stmts;
  tTree new_var;
  {
/* line 544 "MakeRemapping.puma" */
   SetVarDescriptor (var, & vard);
/* line 546 "MakeRemapping.puma" */
 vard.topology_rank = -1;    
/* line 553 "MakeRemapping.puma" */
   NoExpansion (& vard);
/* line 554 "MakeRemapping.puma" */
   MakeTempVarStmt (var, IntentOut, & vard, & new_var, & pre_stmts, & post_stmts);
  }
   * yyP23 = new_var;
   * yyP22 = pre_stmts;
   * yyP21 = post_stmts;
   return;
 }

;
}

static rbool AcceptedSerialVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 565 "MakeRemapping.puma" */
 {
  int dist;
  {
/* line 567 "MakeRemapping.puma" */
   if (! ((TreeRank (var) > 0))) goto yyL1;
  {
/* line 571 "MakeRemapping.puma" */
   dist = TreeWriteDistribution (var);
/* line 573 "MakeRemapping.puma" */
   if (! (((dist == 0) || (dist == - 1) || (dist == 2)))) goto yyL1;
  }
  }
   return rtrue;
 }
yyL1:;

/* line 576 "MakeRemapping.puma" */
  {
/* line 578 "MakeRemapping.puma" */
   if (! ((TreeRank (var) > 0))) goto yyL2;
  {
/* line 579 "MakeRemapping.puma" */
   return rfalse;
  }
  }
yyL2:;

/* line 582 "MakeRemapping.puma" */
   return rtrue;

}

static rbool MightBeRedistributed
# if defined __STDC__ | defined __cplusplus
(register tTree p, register tTree actual, register tDefinitions dummy)
# else
(p, actual, dummy)
 register tTree p;
 register tTree actual;
 register tDefinitions dummy;
# endif
{
/* line 595 "MakeRemapping.puma" */
 {
  rbool might_be;
  var_descriptor dummy_vard;
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 600 "MakeRemapping.puma" */
   FindParamDescriptor (actual, & yyV1, & yyV2);
/* line 602 "MakeRemapping.puma" */
 might_be = rtrue;

     if (yyV1)
 
       { SetVarObjDescriptor (&dummy_vard, dummy, NoTree);

         

         might_be = (! IsSpecialisation (&yyV2, &dummy_vard));

       }
   
/* line 615 "MakeRemapping.puma" */
   if (! ((might_be))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static void FindParamDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register rbool * yyP25, var_descriptor * yyP24)
# else
(actual, yyP25, yyP24)
 register tTree actual;
 register rbool * yyP25;
 var_descriptor * yyP24;
# endif
{
/* line 626 "MakeRemapping.puma" */
 {
  rbool found;
  var_descriptor vard;
  {
/* line 631 "MakeRemapping.puma" */
   GetParamDescriptor (actual, & found, & vard);
/* line 632 "MakeRemapping.puma" */
   if (! ((found))) goto yyL1;
  }
   * yyP25 = found;
   * yyP24 = vard;
   return;
 }
yyL1:;

/* line 635 "MakeRemapping.puma" */
 {
  var_descriptor vard;
  {
  }
   * yyP25 = rfalse;
   * yyP24 = vard;
   return;
 }

;
}

static void MakeParamTemporary
# if defined __STDC__ | defined __cplusplus
(register tTree actual, pvar vard, register tTree * yyP27, register tTree * yyP26)
# else
(actual, vard, yyP27, yyP26)
 register tTree actual;
 pvar vard;
 register tTree * yyP27;
 register tTree * yyP26;
# endif
{
  if (actual->Kind == kVAR_PARAM) {
  if (actual->VAR_PARAM.V->Kind == kADDR) {
/* line 648 "MakeRemapping.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree assign;
  tTree tmp_var;
  {
/* line 658 "MakeRemapping.puma" */
   NoExpansion (vard);
/* line 659 "MakeRemapping.puma" */
   MakeTemporaryStmt (actual->VAR_PARAM.V->ADDR.E, vard, & pre_stmts, & tmp_var, & assign, & post_stmts);
/* line 661 "MakeRemapping.puma" */
 actual->VAR_PARAM.V = tmp_var; 
  }
   * yyP27 = CombineACF (pre_stmts, assign);
   * yyP26 = post_stmts;
   return;
 }

  }
/* line 664 "MakeRemapping.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree new_var;
  {
/* line 671 "MakeRemapping.puma" */
   NoExpansion (vard);
/* line 672 "MakeRemapping.puma" */
   MakeTempVarStmt (actual->VAR_PARAM.V, actual->VAR_PARAM.intent, vard, & new_var, & pre_stmts, & post_stmts);
/* line 674 "MakeRemapping.puma" */
 actual->VAR_PARAM.V = new_var; 
  }
   * yyP27 = pre_stmts;
   * yyP26 = post_stmts;
   return;
 }

  }
/* line 677 "MakeRemapping.puma" */
  {
/* line 679 "MakeRemapping.puma" */
   failure_protocol (MODULE, "MakeParamTemporary", actual);
  }
   * yyP27 = NoTree;
   * yyP26 = NoTree;
   return;

;
}

static void MakeNewAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP30, register tTree * yyP29, register tTree * yyP28)
# else
(exp, vard, yyP30, yyP29, yyP28)
 register tTree exp;
 pvar vard;
 register tTree * yyP30;
 register tTree * yyP29;
 register tTree * yyP28;
# endif
{
/* line 690 "MakeRemapping.puma" */
 {
  tTree pre_stmt;
  tTree post_stmt;
  tTree tmp_var;
  tTree assign;
  {
/* line 698 "MakeRemapping.puma" */
   NoExpansion (vard);
/* line 700 "MakeRemapping.puma" */
   MakeTemporaryStmt (exp, vard, & pre_stmt, & tmp_var, & assign, & post_stmt);
  }
   * yyP30 = mVAR_EXP (tmp_var);
   * yyP29 = CombineACF (pre_stmt, assign);
   * yyP28 = post_stmt;
   return;
 }

;
}

void BeginMakeRemapping ARGS ((void))
{
}

void CloseMakeRemapping ARGS ((void))
{
}
