# include "MakeReductions.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 19 "MakeReductions.puma" */


# include "protocol.h"

# define MODULE "MakeReductions"

static tTree new_var;
static tIdent old_id;

# include "Transform.h"
# include "Traverse.h"
# include "DefTable.h"
# include "VarDescriptor.h"
# include "HomeDescriptor.h"   /* NoReplicationDescriptor */
# include "Temporary.h"
# include "Reductions.h"  /* InitReduction */
# include "TreeOps.h"
# include "Types.h"
# include "Nesting.h"     /* GetCurrentModel */
# include "Expansion.h"   /* NoExpansion     */

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeReductions.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeReductions_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeReductions, routine %s failed\n",
  yyFunction);
 MakeReductions_Exit ();
}

void MakeReductions ARGS ((tTree t));
static rbool StopMakeReductions ARGS ((tTree t));
static tTree DoMakeReductions ARGS ((tTree t));
static rbool NeedsLocalVariable ARGS ((tTree reduction));
static tTree MakeTempReduction ARGS ((tTree reduction));
static void ReplaceVar ARGS ((tTree body, tTree old, tTree new));
static void ReplaceVarId ARGS ((tTree t));
static void ChangeVariable ARGS ((tTree var, tIdent old_id, tTree new_var));
static tTree Get_VAR_OBJ ARGS ((tTree t));
static tTree Get_USED_VAR ARGS ((tTree t));

void MakeReductions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 52 "MakeReductions.puma" */
  {
/* line 54 "MakeReductions.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeReductions, DoMakeReductions); 
  }
   return;

  }
/* line 57 "MakeReductions.puma" */
  {
/* line 58 "MakeReductions.puma" */
   failure_protocol (MODULE, "MakeReductions", t);
  }
   return;

;
}

static rbool StopMakeReductions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
/* line 72 "MakeReductions.puma" */
   return rtrue;

  }
  if (Tree_IsType (t, kBT_EXP)) {
/* line 75 "MakeReductions.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree DoMakeReductions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_REDUCTION) {
/* line 86 "MakeReductions.puma" */
  {
/* line 88 "MakeReductions.puma" */
   if (! ((NeedsLocalVariable (t)))) goto yyL1;
  }
   return MakeTempReduction (t);
yyL1:;

  }
/* line 93 "MakeReductions.puma" */
   return t;

}

static rbool NeedsLocalVariable
# if defined __STDC__ | defined __cplusplus
(register tTree reduction)
# else
(reduction)
 register tTree reduction;
# endif
{
  if (reduction->Kind == kACF_REDUCTION) {
/* line 108 "MakeReductions.puma" */
  {
/* line 112 "MakeReductions.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  {
/* line 113 "MakeReductions.puma" */
   if (! ((! sm_parallelization))) goto yyL1;
  {
/* line 115 "MakeReductions.puma" */
   return rfalse;
  }
  }
  }
yyL1:;

/* line 118 "MakeReductions.puma" */
  {
/* line 120 "MakeReductions.puma" */
   if (! ((reduction->ACF_REDUCTION.REDUCTION_FUNC->PROC_OBJ.Ident == DefaultId ()))) goto yyL2;
  {
/* line 122 "MakeReductions.puma" */
   return rfalse;
  }
  }
yyL2:;

  }
/* line 125 "MakeReductions.puma" */
   return rtrue;

}

static tTree MakeTempReduction
# if defined __STDC__ | defined __cplusplus
(register tTree reduction)
# else
(reduction)
 register tTree reduction;
# endif
{
  if (reduction->Kind == kACF_REDUCTION) {
  if (reduction->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 156 "MakeReductions.puma" */
 {
  var_descriptor vard;
  {
/* line 162 "MakeReductions.puma" */
   if (! ((reduction->ACF_REDUCTION.red_kind == kATOMIC_REDUCTION))) goto yyL1;
  {
/* line 166 "MakeReductions.puma" */
   set_protocol_stmt (reduction);
/* line 168 "MakeReductions.puma" */
   SetVarDescriptor (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem, & vard);
/* line 170 "MakeReductions.puma" */
   if (! ((NoReplicationDescriptor (& vard)))) goto yyL1;
  }
  }
   return reduction;
 }
yyL1:;

/* line 175 "MakeReductions.puma" */
  {
/* line 178 "MakeReductions.puma" */
   if (! ((reduction->ACF_REDUCTION.red_kind == kATOMIC_REDUCTION))) goto yyL2;
  {
/* line 180 "MakeReductions.puma" */
   error_protocol ("atomic reduction on var with possible replication");
  }
  }
   return reduction;
yyL2:;

/* line 185 "MakeReductions.puma" */
  {
/* line 190 "MakeReductions.puma" */
   if (! ((reduction->ACF_REDUCTION.red_kind == kDEFAULT_REDUCTION))) goto yyL3;
  }
   return reduction;
yyL3:;

/* line 195 "MakeReductions.puma" */
 {
  var_descriptor tmp_var;
  tTree new_var;
  tTree alloc;
  tTree dealloc;
  tTree init_stmt;
  tTree red_stmt;
  tTree new_stmt;
  {
/* line 208 "MakeReductions.puma" */
   set_protocol_stmt (reduction);
/* line 210 "MakeReductions.puma" */
   stmt_protocol ("REDUCTION becomes new temporay replicated variable");
/* line 212 "MakeReductions.puma" */
 SetVarDescriptor (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem, &tmp_var);

     NoExpansion (&tmp_var);

     

     tmp_var.topology_rank = 0;
     tmp_var.topology_obj = GetDefaultTopology(0);

     new_var = GetVDTemporary (&tmp_var);

     GetMemoryStmts (&alloc, &dealloc);

     init_stmt = InitReductionStmt (CopyTree (new_var), TreeType(new_var), reduction->ACF_REDUCTION.REDUCTION_FUNC);
     red_stmt  = mACF_BASIC (GenRedAssign (CopyTree (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem),
                                     mVAR_EXP (CopyTree (new_var)), reduction->ACF_REDUCTION.REDUCTION_FUNC->PROC_OBJ.Ident));

     ReplaceVar (reduction, reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem, new_var);

     new_stmt = CombineACF (alloc,
                 CombineACF (init_stmt,
                  CombineACF (reduction, 
                   CombineACF (red_stmt,
                    CombineACF (dealloc, mACF_EMPTY ())))));

     new_stmt = mACF_NEW (mBTV_LIST (Get_USED_VAR (new_var), mBTV_EMPTY()), 
                          new_stmt);

   
/* line 242 "MakeReductions.puma" */
   tree_protocol ("generated code for REDUCTION: \n", new_stmt);
  }
   return new_stmt;
 }

  }
  }
  }
/* line 247 "MakeReductions.puma" */
  {
/* line 249 "MakeReductions.puma" */
   failure_protocol (MODULE, "MakeTempReduction", reduction);
  }
   return NoTree;

}

static void ReplaceVar
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree old, register tTree new)
# else
(body, old, new)
 register tTree body;
 register tTree old;
 register tTree new;
# endif
{
/* line 263 "MakeReductions.puma" */
  {
/* line 265 "MakeReductions.puma" */
 old_id  = TreeVarName (old);
     new_var = Get_VAR_OBJ (new);

     FullTraverseAST (body, ReplaceVarId); 
   
  }
   return;

;
}

static void ReplaceVarId
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_OBJ) {
/* line 274 "MakeReductions.puma" */
  {
/* line 276 "MakeReductions.puma" */
   ChangeVariable (t, old_id, new_var);
  }
   return;

  }
;
}

static void ChangeVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent old_id, register tTree new_var)
# else
(var, old_id, new_var)
 register tTree var;
 register tIdent old_id;
 register tTree new_var;
# endif
{
  if (var->Kind == kVAR_OBJ) {
  if (new_var->Kind == kVAR_OBJ) {
/* line 281 "MakeReductions.puma" */
  {
/* line 284 "MakeReductions.puma" */
 if (var->VAR_OBJ.Ident == old_id)

       { var->VAR_OBJ.Ident  = new_var->VAR_OBJ.Ident; 
         var->VAR_OBJ.Object = new_var->VAR_OBJ.Object;
         var->VAR_OBJ.Reaching  = new_var->VAR_OBJ.Reaching;
       }
   
  }
   return;

  }
  }
/* line 294 "MakeReductions.puma" */
  {
/* line 296 "MakeReductions.puma" */
   failure_protocol (MODULE, "ChangeVariable", var);
  }
   return;

;
}

static tTree Get_VAR_OBJ
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kUSED_VAR) {
/* line 306 "MakeReductions.puma" */
   t = t->USED_VAR.VARNAME;
   goto yyRecursion;

  }
  if (t->Kind == kVAR_OBJ) {
/* line 311 "MakeReductions.puma" */
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
/* line 316 "MakeReductions.puma" */
   t = t->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  }
/* line 321 "MakeReductions.puma" */
  {
/* line 322 "MakeReductions.puma" */
   failure_protocol (MODULE, "Get_VAR_OBJ", t);
  }
   return NoTree;

}

static tTree Get_USED_VAR
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kUSED_VAR) {
/* line 329 "MakeReductions.puma" */
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
/* line 334 "MakeReductions.puma" */
   t = t->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  }
/* line 339 "MakeReductions.puma" */
  {
/* line 340 "MakeReductions.puma" */
   failure_protocol (MODULE, "Get_USED_VAR", t);
  }
   return NoTree;

}

void BeginMakeReductions ARGS ((void))
{
}

void CloseMakeReductions ARGS ((void))
{
}
