# include "MakeRagged.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 27 "MakeRagged.puma" */


# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "DefTable.h"

# include "Objects.h"
# include "Types.h"
# include "Nesting.h"
# include "Transform.h"
# include "MapDefs.h"     /* SetDistribution */
# include "SemMap.h"      /* EvalObjSpecMapping  */
# include "BuildTree.h"   /* ConcatDecls         */
# include "Rank.h"

# define MODULE "MakeRagged"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeRagged.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeRagged_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeRagged, routine %s failed\n",
  yyFunction);
 MakeRagged_Exit ();
}

tTree MakeRaggedDecls ARGS ((tTree decl, tDefinitions obj));
static tTree TranslateTreeObject ARGS ((tDefinitions tree_obj, tDefinitions ragged_obj, int level, tIdent name, tTree type));
static tTree TranslateTypeComponents ARGS ((tDefinitions tree_obj, tDefinitions ragged_obj, int level, tIdent name, tDefinitions entries));
static tDefinitions GetTypeEntries ARGS ((tDefinitions t));
static tIdent AddId ARGS ((tIdent name, tIdent add));
static void AddRaggedObject ARGS ((tDefinitions ragged_obj, int level, tDefinitions obj));
static tDefinitions AddRaggedComponent ARGS ((tDefinitions levels, int depth, int level, tDefinitions obj));
static int GetDistributionLevel ARGS ((tDefinitions obj));
static int GetFirstDistDim ARGS ((tDefinitions dim));
static tTree MakeDistributeDecl ARGS ((tIdent name, int level, int dist_level));
rbool IsTreeAccess ARGS ((tTree t));
tTree MakeRaggedAccess ARGS ((tTree var));
static rbool IsRaggedVarAccess ARGS ((tTree var));
static tTree MakeRaggedVarAccess ARGS ((tTree var));
tTree MakeRaggedTreeAccess ARGS ((tTree var));
static tTree AppendIndexes ARGS ((tTree var, tTree indexes));
static void AppendId ARGS ((tTree var, tIdent id));
tTree MakeRaggedAllocates ARGS ((tTree stmt));
static tTree TranslateAllocParams ARGS ((tTree params));
tTree MakeRaggedDeallocates ARGS ((tTree stmt));
static tTree CheckEmptyDeallocate ARGS ((tTree stmt));
static tTree TranslateDeallocParams ARGS ((tTree params));
static void GetRaggedObject ARGS ((tTree t, tDefinitions * yyP1));
static tTree MakeAllAllocates ARGS ((tDefinitions def, tTree tail));
static tTree MakeAllDeallocates ARGS ((tDefinitions def, tTree tail));
static tTree MakeDeferredShape ARGS ((int rank));

tTree MakeRaggedDecls
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions obj)
# else
(decl, obj)
 register tTree decl;
 register tDefinitions obj;
# endif
{
/* line 56 "MakeRagged.puma" */
  {
/* line 58 "MakeRagged.puma" */
   if (! ((! IsTreeObject (obj)))) goto yyL1;
  }
   return decl;
yyL1:;

  if (decl->Kind == kVAR_DECL) {
  if (obj->Kind == kVarObject) {
/* line 63 "MakeRagged.puma" */
 {
  tDefinitions ragged_obj;
  tTree ragged_decl;
  tTree comp_decls;
  {
/* line 70 "MakeRagged.puma" */
 int i;

     ragged_obj = mRaggedObject (obj->VarObject.Ident, obj->VarObject.decl, obj->VarObject.private, obj->VarObject.in, 0, mSCOPE_EMPTY (), obj->VarObject.Dist);

     comp_decls = TranslateTreeObject (obj, ragged_obj, 0, decl->VAR_DECL.Ident, 
                                       GetObjectType (obj));

     ragged_decl = mRAGGED_DECL (decl->VAR_DECL.Ident, decl->VAR_DECL.Line, 
                                 MakeDeferredShape (ragged_obj->RaggedObject.depth));

     ragged_obj->RaggedObject.decl = ragged_decl;

     ChangeEntry (decl->VAR_DECL.Ident, ragged_obj);

   
  }
   return mDECL_LIST (ragged_decl, comp_decls);
 }

  }
  }
  if (decl->Kind == kTREE_DECL) {
/* line 89 "MakeRagged.puma" */
   return NoTree;

  }
/* line 94 "MakeRagged.puma" */
  {
/* line 96 "MakeRagged.puma" */
   failure_protocol (MODULE, "MakeRaggedDecls", decl);
  }
   return NoTree;

}

static tTree TranslateTreeObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions tree_obj, register tDefinitions ragged_obj, register int level, register tIdent name, register tTree type)
# else
(tree_obj, ragged_obj, level, name, type)
 register tDefinitions tree_obj;
 register tDefinitions ragged_obj;
 register int level;
 register tIdent name;
 register tTree type;
# endif
{
  if (type->Kind == kARRAY_TYPE) {
  if (type->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kTYPE_ID) {
/* line 110 "MakeRagged.puma" */
   return TranslateTypeComponents (tree_obj, ragged_obj, level + 1, name, GetTypeEntries (type->ARRAY_TYPE.ARRAY_COMP_TYPE->TYPE_ID.ID->TYPE_OBJ.Object));

  }
  }
  if (ragged_obj->Kind == kRaggedObject) {
/* line 116 "MakeRagged.puma" */
 {
  tTree new_decl;
  tTree new_dist;
  tTree new_type;
  tDefinitions new_obj;
  {
/* line 124 "MakeRagged.puma" */
 int i;

     if (level > ragged_obj->RaggedObject.depth) ragged_obj->RaggedObject.depth = level;

     new_type = mARRAY_TYPE (MakeDeferredShape (level), 
                             CopyTree(type));

     new_decl = mVAR_DECL (name, 0, new_type);

     new_obj = MakeNewObject (new_decl, ragged_obj);

     new_obj->VarObject.arr_kind = arr_assumed_shape;

     new_dist = MakeDistributeDecl (name, level, GetDistributionLevel (tree_obj));

     InsertEntry (new_obj);

     AddRaggedObject (ragged_obj, level, new_obj);

     SetDistributions (new_dist, GetCurrentUnitObject());
     EvalObjSpecMapping (new_obj);

   
  }
   return mDECL_LIST (new_decl, mDECL_LIST (new_dist, NoTree));
 }

  }
 yyAbort ("TranslateTreeObject");
 { tTree yyDummy; return yyDummy; }
}

static tTree TranslateTypeComponents
# if defined __STDC__ | defined __cplusplus
(register tDefinitions tree_obj, register tDefinitions ragged_obj, register int level, register tIdent name, register tDefinitions entries)
# else
(tree_obj, ragged_obj, level, name, entries)
 register tDefinitions tree_obj;
 register tDefinitions ragged_obj;
 register int level;
 register tIdent name;
 register tDefinitions entries;
# endif
{
  if (entries->Kind == kENTRY_LIST) {
/* line 156 "MakeRagged.puma" */
   return ConcatDecls (TranslateTypeComponents (tree_obj, ragged_obj, level, name, entries->ENTRY_LIST.Elem), TranslateTypeComponents (tree_obj, ragged_obj, level, name, entries->ENTRY_LIST.Next));

  }
  if (entries->Kind == kENTRY_EMPTY) {
/* line 163 "MakeRagged.puma" */
   return NoTree;

  }
  if (entries->Kind == kVarObject) {
/* line 168 "MakeRagged.puma" */
   return TranslateTreeObject (tree_obj, ragged_obj, level, AddId (name, entries->VarObject.Ident), GetObjectType (entries));

  }
 yyAbort ("TranslateTypeComponents");
 { tTree yyDummy; return yyDummy; }
}

static tDefinitions GetTypeEntries
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kTypeObject) {
/* line 180 "MakeRagged.puma" */
   return t->TypeObject.Components;

  }
 yyAbort ("GetTypeEntries");
 { tDefinitions yyDummy; return yyDummy; }
}

static tIdent AddId
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tIdent add)
# else
(name, add)
 register tIdent name;
 register tIdent add;
# endif
{
/* line 187 "MakeRagged.puma" */

char str1[MAX_ID_LENGTH], str2[MAX_ID_LENGTH], str3[MAX_ID_LENGTH]; 

/* line 191 "MakeRagged.puma" */
  {
/* line 193 "MakeRagged.puma" */
   GetString (name, str1);
/* line 194 "MakeRagged.puma" */
   GetString (add, str2);
/* line 195 "MakeRagged.puma" */
   sprintf (str3, "%s_%s", str1, str2);
  }
   return IsIdent (str3);

}

static void AddRaggedObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions ragged_obj, register int level, register tDefinitions obj)
# else
(ragged_obj, level, obj)
 register tDefinitions ragged_obj;
 register int level;
 register tDefinitions obj;
# endif
{
  if (ragged_obj->Kind == kRaggedObject) {
/* line 206 "MakeRagged.puma" */
  {
/* line 208 "MakeRagged.puma" */
 if (level > ragged_obj->RaggedObject.depth) ragged_obj->RaggedObject.depth = level;

     printf ("add ragged component at level  %d\n", level);

     ragged_obj->RaggedObject.Levels = AddRaggedComponent (ragged_obj->RaggedObject.Levels, 1, level, obj);
   
  }
   return;

  }
;
}

static tDefinitions AddRaggedComponent
# if defined __STDC__ | defined __cplusplus
(register tDefinitions levels, register int depth, register int level, register tDefinitions obj)
# else
(levels, depth, level, obj)
 register tDefinitions levels;
 register int depth;
 register int level;
 register tDefinitions obj;
# endif
{
/* line 219 "MakeRagged.puma" */
  {
/* line 221 "MakeRagged.puma" */
   printf ("add ragged component at depth %d, level %d\n", depth, level);
/* line 222 "MakeRagged.puma" */
   goto yyL1;
  }
yyL1:;

  if (levels->Kind == kSCOPE_LIST) {
/* line 225 "MakeRagged.puma" */
  {
/* line 227 "MakeRagged.puma" */
   if (! ((depth == level))) goto yyL2;
  {
/* line 229 "MakeRagged.puma" */
 levels->SCOPE_LIST.Table = mENTRY_LIST (obj, levels->SCOPE_LIST.Table); 
  }
  }
   return levels;
yyL2:;

/* line 234 "MakeRagged.puma" */
  {
/* line 236 "MakeRagged.puma" */
   if (! ((depth < level))) goto yyL3;
  {
/* line 238 "MakeRagged.puma" */
 levels->SCOPE_LIST.Hidden = AddRaggedComponent (levels->SCOPE_LIST.Hidden, depth+1, level, obj); 
  }
  }
   return levels;
yyL3:;

  }
  if (levels->Kind == kSCOPE_EMPTY) {
/* line 243 "MakeRagged.puma" */
  {
/* line 245 "MakeRagged.puma" */
   if (! ((depth == level))) goto yyL4;
  }
   return mSCOPE_LIST (mENTRY_LIST (obj, mENTRY_EMPTY ()), mSCOPE_EMPTY ());
yyL4:;

/* line 250 "MakeRagged.puma" */
  {
/* line 252 "MakeRagged.puma" */
   if (! ((depth < level))) goto yyL5;
  }
   return mSCOPE_LIST (mSCOPE_EMPTY (), AddRaggedComponent (levels, depth + 1, level, obj));
yyL5:;

  }
/* line 258 "MakeRagged.puma" */
   return levels;

}

static int GetDistributionLevel
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
 yyRecursion:
  if (obj->Kind == kVarObject) {
/* line 276 "MakeRagged.puma" */
   obj = obj->VarObject.Dist->Mapping.spec;
   goto yyRecursion;

  }
  if (obj->Kind == kMapDist) {
/* line 281 "MakeRagged.puma" */
   return GetFirstDistDim (obj->MapDist.Distribution->Distribution.ArrayList);

  }
/* line 286 "MakeRagged.puma" */
   return 0;

}

static int GetFirstDistDim
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dim)
# else
(dim)
 register tDefinitions dim;
# endif
{
  if (dim->Kind == kDIM_LIST) {
  if (dim->DIM_LIST.Elem->Kind == kDistributedDimension) {
/* line 292 "MakeRagged.puma" */
   return 1;

  }
/* line 297 "MakeRagged.puma" */
   return GetFirstDistDim (dim->DIM_LIST.Next) + 1;

  }
  if (dim->Kind == kDIM_EMPTY) {
/* line 302 "MakeRagged.puma" */
   return 1;

  }
 yyAbort ("GetFirstDistDim");
 { int yyDummy; return yyDummy; }
}

static tTree MakeDistributeDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int level, register int dist_level)
# else
(name, level, dist_level)
 register tIdent name;
 register int level;
 register int dist_level;
# endif
{
/* line 315 "MakeRagged.puma" */
 {
  tTree decl;
  {
/* line 319 "MakeRagged.puma" */
 

     int i;

     decl = mDIST_EMPTY ();

     for (i=level; i>= 1; i--)
        if (i == dist_level)
            decl = mDIST_LIST (mBLOCK_DISTRIBUTION (mDUMMY_EXP()), decl);
          else
            decl = mDIST_LIST (mSERIAL_DISTRIBUTION (), decl);

     decl = mNODE_DISTRIBUTION (0, decl);

     decl = mDISTRIBUTE_DECL (name, 0, decl,
                              mDEFAULT_PROCESSOR_ARRAY());
   
  }
   return decl;
 }

}

rbool IsTreeAccess
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
/* line 342 "MakeRagged.puma" */
  {
/* line 344 "MakeRagged.puma" */
   if (! ((IsTreeAccess (t->INDEXED_VAR.IND_VAR)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kSELECTED_VAR) {
/* line 347 "MakeRagged.puma" */
  {
/* line 349 "MakeRagged.puma" */
   if (! ((IsTreeAccess (t->SELECTED_VAR.SELEC_VAR)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kUSED_VAR) {
/* line 352 "MakeRagged.puma" */
  {
/* line 354 "MakeRagged.puma" */
   if (! ((IsTreeObject (t->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

tTree MakeRaggedAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 365 "MakeRagged.puma" */
  {
/* line 367 "MakeRagged.puma" */
   if (! ((IsRaggedVarAccess (var)))) goto yyL1;
  }
   return MakeRaggedVarAccess (var);
yyL1:;

/* line 372 "MakeRagged.puma" */
   return MakeRaggedTreeAccess (var);

}

static rbool IsRaggedVarAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kSELECTED_VAR) {
/* line 379 "MakeRagged.puma" */
  {
/* line 381 "MakeRagged.puma" */
   if (! ((VarRank (var->SELECTED_VAR.SELECTOR->REC_COMP.Object) == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static tTree MakeRaggedVarAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 386 "MakeRagged.puma" */
   return AppendIndexes (MakeRaggedVarAccess (var->INDEXED_VAR.IND_VAR), var->INDEXED_VAR.IND_EXPS);

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 391 "MakeRagged.puma" */
 {
  tTree new;
  {
/* line 395 "MakeRagged.puma" */
   new = MakeRaggedVarAccess (var->SELECTED_VAR.SELEC_VAR);
/* line 397 "MakeRagged.puma" */
   AppendId (new, var->SELECTED_VAR.SELECTOR->REC_COMP.Ident);
  }
   return new;
 }

  }
  if (var->Kind == kUSED_VAR) {
/* line 402 "MakeRagged.puma" */
   return var;

  }
/* line 407 "MakeRagged.puma" */
  {
/* line 408 "MakeRagged.puma" */
   failure_protocol (MODULE, "MakeRaggedVarAccess", var);
  }
   return NoTree;

}

tTree MakeRaggedTreeAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kINDEXED_VAR) {
/* line 420 "MakeRagged.puma" */
   return AppendIndexes (MakeRaggedTreeAccess (var->INDEXED_VAR.IND_VAR), var->INDEXED_VAR.IND_EXPS);

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 425 "MakeRagged.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;

  }
  if (var->Kind == kUSED_VAR) {
/* line 430 "MakeRagged.puma" */
  {
/* line 432 "MakeRagged.puma" */
 var->USED_VAR.VARNAME->VAR_OBJ.Object = GetGlobalObject (var->USED_VAR.VARNAME->VAR_OBJ.Ident); 
  }
   return var;

  }
/* line 437 "MakeRagged.puma" */
  {
/* line 438 "MakeRagged.puma" */
   failure_protocol (MODULE, "MakeRaggedVarAccess", var);
  }
   return NoTree;

}

static tTree AppendIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree indexes)
# else
(var, indexes)
 register tTree var;
 register tTree indexes;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 444 "MakeRagged.puma" */
   return mINDEXED_VAR (var, indexes);

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 449 "MakeRagged.puma" */
  {
/* line 451 "MakeRagged.puma" */
 var->INDEXED_VAR.IND_EXPS = AppendIndexes (var->INDEXED_VAR.IND_EXPS, indexes); 
  }
   return var;

  }
  if (var->Kind == kBTE_LIST) {
  if (var->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 456 "MakeRagged.puma" */
  {
/* line 458 "MakeRagged.puma" */
 var->BTE_LIST.Next = indexes; 
  }
   return var;

  }
/* line 463 "MakeRagged.puma" */
  {
/* line 465 "MakeRagged.puma" */
 var->BTE_LIST.Next = AppendIndexes (var->BTE_LIST.Next, indexes); 
  }
   return var;

  }
/* line 470 "MakeRagged.puma" */
  {
/* line 472 "MakeRagged.puma" */
   failure_protocol (MODULE, "AppendIndexes", var);
  }
   return NoTree;

}

static void AppendId
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent id)
# else
(var, id)
 register tTree var;
 register tIdent id;
# endif
{
 yyRecursion:
  if (var->Kind == kUSED_VAR) {
/* line 479 "MakeRagged.puma" */
  {
/* line 481 "MakeRagged.puma" */
 var->USED_VAR.VARNAME->VAR_OBJ.Ident = AddId (var->USED_VAR.VARNAME->VAR_OBJ.Ident, id);
     var->USED_VAR.VARNAME->VAR_OBJ.Object  = GetGlobalObject (var->USED_VAR.VARNAME->VAR_OBJ.Ident);
   
  }
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 486 "MakeRagged.puma" */
  {
/* line 488 "MakeRagged.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
/* line 491 "MakeRagged.puma" */
  {
/* line 493 "MakeRagged.puma" */
   failure_protocol (MODULE, "AppendId", var);
  }
   return;

;
}

tTree MakeRaggedAllocates
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
/* line 504 "MakeRagged.puma" */
  {
/* line 506 "MakeRagged.puma" */
 stmt->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS = TranslateAllocParams (stmt->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS); 
  }
   return stmt;

  }
  }
/* line 511 "MakeRagged.puma" */
  {
/* line 513 "MakeRagged.puma" */
   failure_protocol (MODULE, "MakeRaggedAllocates", stmt);
  }
   return NoTree;

}

static tTree TranslateAllocParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
/* line 526 "MakeRagged.puma" */
 {
  tDefinitions yyV1;
  {
/* line 528 "MakeRagged.puma" */
   if (! ((IsTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  {
/* line 530 "MakeRagged.puma" */
   GetRaggedObject (params->BTP_LIST.Elem->VAR_PARAM.V, & yyV1);
/* line 532 "MakeRagged.puma" */
 params->BTP_LIST.Next = MakeAllAllocates (yyV1, TranslateAllocParams (params->BTP_LIST.Next)); 
  }
  }
   return params;
 }
yyL1:;

  }
/* line 537 "MakeRagged.puma" */
  {
/* line 539 "MakeRagged.puma" */
   if (! ((IsTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL2;
  {
/* line 541 "MakeRagged.puma" */
 params->BTP_LIST.Elem->VAR_PARAM.V    = MakeRaggedTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V); 
     params->BTP_LIST.Next = TranslateAllocParams (params->BTP_LIST.Next); 
  }
  }
   return params;
yyL2:;

/* line 547 "MakeRagged.puma" */
  {
/* line 549 "MakeRagged.puma" */
 params->BTP_LIST.Next = TranslateAllocParams (params->BTP_LIST.Next); 
  }
   return params;

  }
  }
  if (params->Kind == kBTP_EMPTY) {
/* line 554 "MakeRagged.puma" */
   return params;

  }
 yyAbort ("TranslateAllocParams");
 { tTree yyDummy; return yyDummy; }
}

tTree MakeRaggedDeallocates
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
/* line 567 "MakeRagged.puma" */
  {
/* line 569 "MakeRagged.puma" */
 stmt->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS = TranslateDeallocParams (stmt->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS); 
  }
   return CheckEmptyDeallocate (stmt);

  }
  }
/* line 574 "MakeRagged.puma" */
  {
/* line 576 "MakeRagged.puma" */
   failure_protocol (MODULE, "MakeRaggedAllocates", stmt);
  }
   return NoTree;

}

static tTree CheckEmptyDeallocate
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
  if (stmt->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->Kind == kBTP_EMPTY) {
/* line 583 "MakeRagged.puma" */
   return NoTree;

  }
  }
  }
/* line 588 "MakeRagged.puma" */
   return stmt;

}

static tTree TranslateDeallocParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
 yyRecursion:
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
/* line 595 "MakeRagged.puma" */
 {
  tDefinitions yyV1;
  {
/* line 597 "MakeRagged.puma" */
   if (! ((IsTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  {
/* line 599 "MakeRagged.puma" */
 params->BTP_LIST.Next = TranslateDeallocParams (params->BTP_LIST.Next); 
/* line 601 "MakeRagged.puma" */
   GetRaggedObject (params->BTP_LIST.Elem->VAR_PARAM.V, & yyV1);
  }
  }
   return MakeAllDeallocates (yyV1, params);
 }
yyL1:;

  }
/* line 606 "MakeRagged.puma" */
  {
/* line 608 "MakeRagged.puma" */
   if (! ((IsTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL2;
  }
   params = params->BTP_LIST.Next;
   goto yyRecursion;
yyL2:;

/* line 614 "MakeRagged.puma" */
  {
/* line 616 "MakeRagged.puma" */
 params->BTP_LIST.Next = TranslateDeallocParams (params->BTP_LIST.Next); 
  }
   return params;

  }
  }
  if (params->Kind == kBTP_EMPTY) {
/* line 621 "MakeRagged.puma" */
   return params;

  }
 yyAbort ("TranslateDeallocParams");
 { tTree yyDummy; return yyDummy; }
}

static void GetRaggedObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions * yyP1)
# else
(t, yyP1)
 register tTree t;
 register tDefinitions * yyP1;
# endif
{
  if (t->Kind == kUSED_VAR) {
/* line 628 "MakeRagged.puma" */
  {
/* line 630 "MakeRagged.puma" */
 t->USED_VAR.VARNAME->VAR_OBJ.Object = GetGlobalObject (t->USED_VAR.VARNAME->VAR_OBJ.Ident); 
  }
   * yyP1 = t->USED_VAR.VARNAME->VAR_OBJ.Object;
   return;

  }
;
}

static tTree MakeAllAllocates
# if defined __STDC__ | defined __cplusplus
(register tDefinitions def, register tTree tail)
# else
(def, tail)
 register tDefinitions def;
 register tTree tail;
# endif
{
 yyRecursion:
  if (def->Kind == kRaggedObject) {
/* line 636 "MakeRagged.puma" */
   def = def->RaggedObject.Levels;
   goto yyRecursion;

  }
  if (def->Kind == kSCOPE_LIST) {
/* line 641 "MakeRagged.puma" */
  {
/* line 643 "MakeRagged.puma" */
   printf ("scope list\n");
  }
   return MakeAllAllocates (def->SCOPE_LIST.Table, MakeAllAllocates (def->SCOPE_LIST.Hidden, tail));

  }
  if (def->Kind == kSCOPE_EMPTY) {
/* line 649 "MakeRagged.puma" */
   return tail;

  }
  if (def->Kind == kENTRY_LIST) {
/* line 654 "MakeRagged.puma" */
   return MakeAllAllocates (def->ENTRY_LIST.Elem, MakeAllAllocates (def->ENTRY_LIST.Next, tail));

  }
  if (def->Kind == kENTRY_EMPTY) {
/* line 660 "MakeRagged.puma" */
   return tail;

  }
  if (def->Kind == kVarObject) {
/* line 665 "MakeRagged.puma" */
 {
  tTree stmt;
  {
/* line 667 "MakeRagged.puma" */
   printf ("make allocate for object of ragged array\n");
/* line 671 "MakeRagged.puma" */
 stmt = mVAR_OBJ (0, def->VarObject.Ident);
     stmt->VAR_OBJ.Object = def;

     stmt = mVAR_PARAM (mUSED_VAR (stmt));
     stmt = mBTP_LIST (stmt, tail);
   
  }
   return stmt;
 }

  }
 yyAbort ("MakeAllAllocates");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeAllDeallocates
# if defined __STDC__ | defined __cplusplus
(register tDefinitions def, register tTree tail)
# else
(def, tail)
 register tDefinitions def;
 register tTree tail;
# endif
{
 yyRecursion:
  if (def->Kind == kRaggedObject) {
/* line 683 "MakeRagged.puma" */
   def = def->RaggedObject.Levels;
   goto yyRecursion;

  }
  if (def->Kind == kSCOPE_LIST) {
/* line 688 "MakeRagged.puma" */
   return MakeAllDeallocates (def->SCOPE_LIST.Hidden, MakeAllDeallocates (def->SCOPE_LIST.Table, tail));

  }
  if (def->Kind == kSCOPE_EMPTY) {
/* line 694 "MakeRagged.puma" */
   return tail;

  }
  if (def->Kind == kENTRY_LIST) {
/* line 699 "MakeRagged.puma" */
   return MakeAllDeallocates (def->ENTRY_LIST.Next, MakeAllDeallocates (def->ENTRY_LIST.Elem, tail));

  }
  if (def->Kind == kENTRY_EMPTY) {
/* line 705 "MakeRagged.puma" */
   return tail;

  }
  if (def->Kind == kVarObject) {
/* line 710 "MakeRagged.puma" */
 {
  tTree params;
  {
/* line 712 "MakeRagged.puma" */
   printf ("make deallocate for object of ragged array\n");
/* line 716 "MakeRagged.puma" */
 params = mVAR_OBJ (0, def->VarObject.Ident);
     params->VAR_OBJ.Object = def;

     params = mVAR_PARAM (mUSED_VAR (params));
     params = mBTP_LIST (params, tail);
   
  }
   return params;
 }

  }
 yyAbort ("MakeAllDeallocates");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeDeferredShape
# if defined __STDC__ | defined __cplusplus
(register int rank)
# else
(rank)
 register int rank;
# endif
{
/* line 728 "MakeRagged.puma" */
  {
/* line 730 "MakeRagged.puma" */
   if (! ((rank <= 0))) goto yyL1;
  }
   return mSHAPE_EMPTY ();
yyL1:;

/* line 735 "MakeRagged.puma" */
 {
  tTree shp;
  {
/* line 739 "MakeRagged.puma" */
 shp = mDEFERRED_SHAPE (); 
  }
   return mSHAPE_LIST (shp, MakeDeferredShape (rank - 1));
 }

}

void BeginMakeRagged ARGS ((void))
{
}

void CloseMakeRagged ARGS ((void))
{
}
