# include "MakeParLoops.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 34 "MakeParLoops.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Transform.h" 
# include "Traverse.h"
# include "FindHome.h"
# include "Temporary.h"

# include "Descriptor.h"
# include "MoveDescriptor.h"

# include "MakeSerial.h"            /* MakeSerial             */
# include "TempFunctions.h"         /* MakeTempFunctions      */
# include "MakeArguments.h"         /* MakeArguments          */
# include "MakeRemapping.h"         /* MakeRemapping          */
# include "MakeOvUpdates.h"         /* MakeOvUpdates          */
# include "MakeForall.h"            /* MakeForall             */
# include "Nesting.h"
# include "Objects.h"

# define MODULE "MakeParLoops"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeParLoops.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeParLoops_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeParLoops, routine %s failed\n",
  yyFunction);
 MakeParLoops_Exit ();
}

void MakeParLoops ARGS ((tTree t));

void MakeParLoops
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 75 "MakeParLoops.puma" */
  {
/* line 77 "MakeParLoops.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_LIST:
/* line 82 "MakeParLoops.puma" */
  {
/* line 84 "MakeParLoops.puma" */
   MakeParLoops (t->UNIT_LIST.Elem);
/* line 85 "MakeParLoops.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 88 "MakeParLoops.puma" */
   return;

  case kPROGRAM_DECL:
/* line 91 "MakeParLoops.puma" */
  {
/* line 93 "MakeParLoops.puma" */
   NestOpenUnit (t);
/* line 94 "MakeParLoops.puma" */
   MakeParLoops (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 95 "MakeParLoops.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 98 "MakeParLoops.puma" */
  {
/* line 100 "MakeParLoops.puma" */
   NestOpenUnit (t);
/* line 101 "MakeParLoops.puma" */
   MakeParLoops (t->PROC_DECL.PROC_BODY);
/* line 102 "MakeParLoops.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 105 "MakeParLoops.puma" */
  {
/* line 107 "MakeParLoops.puma" */
   NestOpenUnit (t);
/* line 108 "MakeParLoops.puma" */
   MakeParLoops (t->FUNC_DECL.FUNC_BODY);
/* line 109 "MakeParLoops.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 112 "MakeParLoops.puma" */
  {
/* line 114 "MakeParLoops.puma" */
   NestOpenUnit (t);
/* line 115 "MakeParLoops.puma" */
   MakeParLoops (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 116 "MakeParLoops.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 119 "MakeParLoops.puma" */
  {
/* line 121 "MakeParLoops.puma" */
   NestOpenUnit (t);
/* line 122 "MakeParLoops.puma" */
   MakeParLoops (t->MODULE_DECL.MODULE_BODY);
/* line 123 "MakeParLoops.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
/* line 126 "MakeParLoops.puma" */
  {
/* line 128 "MakeParLoops.puma" */
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

/* line 133 "MakeParLoops.puma" */
  {
/* line 135 "MakeParLoops.puma" */
   TemporaryInit (t);
/* line 137 "MakeParLoops.puma" */
   MakeForall (t);
/* line 139 "MakeParLoops.puma" */
   TemporaryDone (t);
/* line 141 "MakeParLoops.puma" */
   t = t->BODY_NODE.INTERNALS;
   goto yyRecursion;
  }

  }

;
}

void BeginMakeParLoops ARGS ((void))
{
}

void CloseMakeParLoops ARGS ((void))
{
}
