# include "MakeOvUpdates.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 32 "MakeOvUpdates.puma" */


# define MODULE "MakeOvUpdates"

# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "Objects.h"
# include "Rank.h"
# include "Types.h"
# include "Transform.h"             /* ReplaceACF            */
# include "Expressions.h"           /* MakeConstant          */

# include "MoveControl.h"           /* GetShifting, ...      */
# include "OverlapUpdate.h"         /* SetOverlapUpdate, ... */
# include "RegShadow.h"             /* HasEnoughShadow       */




# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeOvUpdates.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeOvUpdates_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeOvUpdates, routine %s failed\n",
  yyFunction);
 MakeOvUpdates_Exit ();
}

void MakeOvUpdates ARGS ((tTree t));
static tTree OverlapUpdateACF ARGS ((tTree t));
static void OverlapUpdateParallel ARGS ((tTree stmt));
static void OverlapUpdateMask ARGS ((tTree stmt, tTree mask));
static void OverlapUpdateWHERE ARGS ((tTree stmt, tTree mask, tTree * yyP1));
static tTree ReplaceCShifts ARGS ((tTree exp));
static tTree TranslateCSHIFT ARGS ((tTree exp));
static void OverlapUpdates ARGS ((tTree var, tTree exp));
static void OverlapIndexUpdates ARGS ((tTree owner, tTree var));
static void OverlapVarUpdates ARGS ((tTree left_var, tTree right_var));
static void ApplyShiftToVar ARGS ((tTree var, pshift pos));
static void ApplyShiftToIndexes ARGS ((tTree indexes, int n, pshift pos));
static rbool ValidOverlapUpdate ARGS ((tTree var, pshift pos));

void MakeOvUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 61 "MakeOvUpdates.puma" */
  {
/* line 63 "MakeOvUpdates.puma" */
 t->BODY_NODE.STATS = OverlapUpdateACF (t->BODY_NODE.STATS); 
  }
   return;

  }
/* line 66 "MakeOvUpdates.puma" */
  {
/* line 67 "MakeOvUpdates.puma" */
   failure_protocol (MODULE, "MakeOvUpdates", t);
  }
   return;

;
}

static tTree OverlapUpdateACF
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
/* line 82 "MakeOvUpdates.puma" */
 {
  tTree newacf;
  {
/* line 86 "MakeOvUpdates.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 88 "MakeOvUpdates.puma" */
 newacf = OverlapUpdateACF (t->ACF_LIST.Elem);            
     t->ACF_LIST.Next   = OverlapUpdateACF (t->ACF_LIST.Next);            
   
/* line 92 "MakeOvUpdates.puma" */
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
   return newacf;
 }

  case kACF_EMPTY:
/* line 97 "MakeOvUpdates.puma" */
   return t;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
/* line 101 "MakeOvUpdates.puma" */
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
/* line 105 "MakeOvUpdates.puma" */
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCREATE_DSP_STMT) {
/* line 109 "MakeOvUpdates.puma" */
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kFREE_DSP_STMT) {
/* line 113 "MakeOvUpdates.puma" */
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 117 "MakeOvUpdates.puma" */
 {
  tTree OvUpdates;
  tTree NewStmt;
  {
/* line 122 "MakeOvUpdates.puma" */
 InitOverlapUpdates ();               

     

     t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = ReplaceCShifts (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

     

     OverlapUpdates (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

     

     OvUpdates = GetOverlapUpdates ();

     if (OvUpdates != NoTree)

        { NewStmt = CombineACF (t, GetOverlapResets ());
          NewStmt = CombineACF (OvUpdates, NewStmt);

          stmt_protocol ("assignment takes advantage of overlap");
          tree_protocol ("new stmt is :\n", NewStmt);
        }

      else

        NewStmt = t;

   
  }
   return NewStmt;
 }

  }
/* line 154 "MakeOvUpdates.puma" */
   return t;

  case kACF_IF:
/* line 158 "MakeOvUpdates.puma" */
  {
/* line 160 "MakeOvUpdates.puma" */
 t->ACF_IF.THEN_PART = OverlapUpdateACF (t->ACF_IF.THEN_PART);
     t->ACF_IF.ELSE_PART = OverlapUpdateACF (t->ACF_IF.ELSE_PART);
   
  }
   return t;

  case kACF_DUMMY:
/* line 166 "MakeOvUpdates.puma" */
   return t;

  case kACF_WHILE:
/* line 170 "MakeOvUpdates.puma" */
  {
/* line 172 "MakeOvUpdates.puma" */
 t->ACF_WHILE.WHILE_BODY = OverlapUpdateACF (t->ACF_WHILE.WHILE_BODY); 
  }
   return t;

  case kACF_DO:
  if (t->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 176 "MakeOvUpdates.puma" */
  {
/* line 178 "MakeOvUpdates.puma" */
 t->ACF_DO.DO_BODY = OverlapUpdateACF (t->ACF_DO.DO_BODY); 
  }
   return t;

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 250 "MakeOvUpdates.puma" */
 {
  tTree OvUpdates;
  tTree NewStmt;
  {
/* line 255 "MakeOvUpdates.puma" */
 InitOverlapUpdates ();               
 
     
 
     OverlapUpdateParallel (t->ACF_DO.DO_BODY);
 
     VectorizeOverlapUpdates (t->ACF_DO.DO_ID, t->ACF_DO.DO_RANGE);
 
     
 
     OvUpdates = GetOverlapUpdates ();
 
     if (OvUpdates != NoTree)
 
        { NewStmt = CombineACF (t, GetOverlapResets ());
          NewStmt = CombineACF (OvUpdates, NewStmt);
 
          stmt_protocol ("independent do loop takes advantage of overlap");
          tree_protocol ("new stmt is :\n", NewStmt);
        }
 
      else
 
        NewStmt = t;
 
   
  }
   return NewStmt;
 }

  }
  break;
  }

  if (t->Kind == kACF_WHERE) {
/* line 183 "MakeOvUpdates.puma" */
 {
  tTree OvUpdates;
  tTree NewStmt;
  {
/* line 190 "MakeOvUpdates.puma" */
 NewStmt = t;

     InitOverlapUpdates ();

     OverlapUpdateWHERE (t->ACF_WHERE.TRUE_PART, t->ACF_WHERE.WHERE_EXP, &t->ACF_WHERE.WHERE_EXP);
     OverlapUpdateWHERE (t->ACF_WHERE.FALSE_PART, t->ACF_WHERE.WHERE_EXP, &t->ACF_WHERE.WHERE_EXP);

     

     OvUpdates = GetOverlapUpdates ();

     if (OvUpdates != NoTree)

        { NewStmt = CombineACF (t, GetOverlapResets ());
          NewStmt = CombineACF (OvUpdates, NewStmt);

          stmt_protocol ("where takes advantage of overlap");
          tree_protocol ("new stmt is :\n", NewStmt);
        }

   
  }
   return NewStmt;
 }

  }
  if (t->Kind == kACF_FORALL) {
/* line 215 "MakeOvUpdates.puma" */
 {
  tTree OvUpdates;
  tTree NewStmt;
  {
/* line 220 "MakeOvUpdates.puma" */
 InitOverlapUpdates ();               

     

     OverlapUpdateParallel (t->ACF_FORALL.FORALL_BODY);

     VectorizeOverlapUpdates (t->ACF_FORALL.FORALL_ID, t->ACF_FORALL.FORALL_RANGE);

     

     OvUpdates = GetOverlapUpdates ();

     if (OvUpdates != NoTree)

        { NewStmt = CombineACF (t, GetOverlapResets ());
          NewStmt = CombineACF (OvUpdates, NewStmt);

          stmt_protocol ("assignment takes advantage of overlap");
          tree_protocol ("new stmt is :\n", NewStmt);
        }

      else

        NewStmt = t;

   
  }
   return NewStmt;
 }

  }
  if (Tree_IsType (t, kACF_NODE)) {
/* line 285 "MakeOvUpdates.puma" */
   return t;

  }
/* line 289 "MakeOvUpdates.puma" */
  {
/* line 290 "MakeOvUpdates.puma" */
   failure_protocol (MODULE, "OverlapUpdateACF", t);
  }
   return NoTree;

}

static void OverlapUpdateParallel
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
 yyRecursion:

  switch (stmt->Kind) {
  case kACF_EMPTY:
/* line 302 "MakeOvUpdates.puma" */
   return;

  case kACF_LIST:
/* line 305 "MakeOvUpdates.puma" */
  {
/* line 307 "MakeOvUpdates.puma" */
   OverlapUpdateParallel (stmt->ACF_LIST.Elem);
/* line 308 "MakeOvUpdates.puma" */
   stmt = stmt->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_IF:
/* line 311 "MakeOvUpdates.puma" */
  {
/* line 313 "MakeOvUpdates.puma" */
   OverlapUpdateParallel (stmt->ACF_IF.THEN_PART);
/* line 314 "MakeOvUpdates.puma" */
   OverlapUpdateParallel (stmt->ACF_IF.ELSE_PART);
/* line 315 "MakeOvUpdates.puma" */
   OverlapUpdateMask (stmt->ACF_IF.THEN_PART, stmt->ACF_IF.IF_EXP);
/* line 316 "MakeOvUpdates.puma" */
   OverlapUpdateMask (stmt->ACF_IF.ELSE_PART, stmt->ACF_IF.IF_EXP);
  }
   return;

  case kACF_WHERE:
/* line 319 "MakeOvUpdates.puma" */
  {
/* line 321 "MakeOvUpdates.puma" */
   OverlapUpdateParallel (stmt->ACF_WHERE.TRUE_PART);
/* line 322 "MakeOvUpdates.puma" */
   OverlapUpdateParallel (stmt->ACF_WHERE.FALSE_PART);
/* line 323 "MakeOvUpdates.puma" */
   OverlapUpdateMask (stmt->ACF_WHERE.TRUE_PART, stmt->ACF_WHERE.WHERE_EXP);
/* line 324 "MakeOvUpdates.puma" */
   OverlapUpdateMask (stmt->ACF_WHERE.FALSE_PART, stmt->ACF_WHERE.WHERE_EXP);
  }
   return;

  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 327 "MakeOvUpdates.puma" */
  {
/* line 329 "MakeOvUpdates.puma" */
  
/* line 331 "MakeOvUpdates.puma" */
   OverlapUpdates (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 334 "MakeOvUpdates.puma" */
   return;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 337 "MakeOvUpdates.puma" */
   return;

  }
/* line 342 "MakeOvUpdates.puma" */
   return;

  case kACF_FORALL:
/* line 345 "MakeOvUpdates.puma" */
  {
/* line 347 "MakeOvUpdates.puma" */
   OverlapUpdateParallel (stmt->ACF_FORALL.FORALL_BODY);
/* line 348 "MakeOvUpdates.puma" */
   VectorizeOverlapUpdates (stmt->ACF_FORALL.FORALL_ID, stmt->ACF_FORALL.FORALL_RANGE);
  }
   return;

  case kACF_DO:
/* line 351 "MakeOvUpdates.puma" */
  {
/* line 353 "MakeOvUpdates.puma" */
   OverlapUpdateParallel (stmt->ACF_DO.DO_BODY);
/* line 354 "MakeOvUpdates.puma" */
   VectorizeOverlapUpdates (stmt->ACF_DO.DO_ID, stmt->ACF_DO.DO_RANGE);
  }
   return;

  case kACF_HOME:
/* line 357 "MakeOvUpdates.puma" */
  {
/* line 359 "MakeOvUpdates.puma" */
   stmt = stmt->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  case kACF_NEW:
/* line 362 "MakeOvUpdates.puma" */
  {
/* line 364 "MakeOvUpdates.puma" */
   stmt = stmt->ACF_NEW.NEW_BODY;
   goto yyRecursion;
  }

  case kACF_REDUCTION:
/* line 367 "MakeOvUpdates.puma" */
  {
/* line 369 "MakeOvUpdates.puma" */
   stmt = stmt->ACF_REDUCTION.REDUCTION_BODY;
   goto yyRecursion;
  }

  case kACF_RESIDENT:
/* line 372 "MakeOvUpdates.puma" */
  {
/* line 374 "MakeOvUpdates.puma" */
   stmt = stmt->ACF_RESIDENT.RESIDENT_BODY;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 377 "MakeOvUpdates.puma" */
  {
/* line 379 "MakeOvUpdates.puma" */
   stmt = stmt->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;
  }

  case kACF_DUMMY:
/* line 382 "MakeOvUpdates.puma" */
   return;

  }

/* line 385 "MakeOvUpdates.puma" */
  {
/* line 386 "MakeOvUpdates.puma" */
   failure_protocol (MODULE, "OverlapUpdateParallel", stmt);
  }
   return;

;
}

static void OverlapUpdateMask
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree mask)
# else
(stmt, mask)
 register tTree stmt;
 register tTree mask;
# endif
{
 yyRecursion:
  if (stmt->Kind == kACF_EMPTY) {
/* line 401 "MakeOvUpdates.puma" */
   return;

  }
  if (stmt->Kind == kACF_LIST) {
/* line 404 "MakeOvUpdates.puma" */
  {
/* line 406 "MakeOvUpdates.puma" */
   OverlapUpdateMask (stmt->ACF_LIST.Elem, mask);
/* line 407 "MakeOvUpdates.puma" */
   stmt = stmt->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kACF_WHERE) {
/* line 410 "MakeOvUpdates.puma" */
  {
/* line 412 "MakeOvUpdates.puma" */
   OverlapUpdateMask (stmt->ACF_WHERE.TRUE_PART, mask);
/* line 413 "MakeOvUpdates.puma" */
   stmt = stmt->ACF_WHERE.FALSE_PART;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kACF_IF) {
/* line 416 "MakeOvUpdates.puma" */
  {
/* line 418 "MakeOvUpdates.puma" */
   OverlapUpdateMask (stmt->ACF_IF.THEN_PART, mask);
/* line 419 "MakeOvUpdates.puma" */
   stmt = stmt->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 422 "MakeOvUpdates.puma" */
  {
/* line 424 "MakeOvUpdates.puma" */
   OverlapUpdates (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, mask);
  }
   return;

  }
  }
;
}

static void OverlapUpdateWHERE
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree mask, register tTree * yyP1)
# else
(stmt, mask, yyP1)
 register tTree stmt;
 register tTree mask;
 register tTree * yyP1;
# endif
{
/* line 446 "MakeOvUpdates.puma" */
  {
/* line 448 "MakeOvUpdates.puma" */
   if (! ((stmt == NoTree))) goto yyL1;
  {
/* line 449 "MakeOvUpdates.puma" */
   failure_protocol (MODULE, "OverlapUpdateWHERE", stmt);
  }
  }
   * yyP1 = NoTree;
   return;
yyL1:;

  if (stmt->Kind == kACF_EMPTY) {
/* line 452 "MakeOvUpdates.puma" */
   * yyP1 = mask;
   return;

  }
  if (stmt->Kind == kACF_LIST) {
/* line 455 "MakeOvUpdates.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 457 "MakeOvUpdates.puma" */
   OverlapUpdateWHERE (stmt->ACF_LIST.Elem, mask, & yyV1);
/* line 458 "MakeOvUpdates.puma" */
   OverlapUpdateWHERE (stmt->ACF_LIST.Next, yyV1, & yyV2);
  }
   * yyP1 = yyV2;
   return;
 }

  }
  if (stmt->Kind == kACF_WHERE) {
/* line 461 "MakeOvUpdates.puma" */
   * yyP1 = mask;
   return;

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 466 "MakeOvUpdates.puma" */
 {
  tTree new_mask;
  {
/* line 470 "MakeOvUpdates.puma" */
 stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = ReplaceCShifts (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP); 
/* line 474 "MakeOvUpdates.puma" */
   OverlapUpdates (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
/* line 480 "MakeOvUpdates.puma" */
 new_mask = ReplaceCShifts (mask); 
/* line 484 "MakeOvUpdates.puma" */
   OverlapUpdates (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, new_mask);
  }
   * yyP1 = new_mask;
   return;
 }

  }
  }
/* line 487 "MakeOvUpdates.puma" */
  {
/* line 488 "MakeOvUpdates.puma" */
   failure_protocol (MODULE, "OverlapUpdateWHERE", stmt);
  }
   * yyP1 = NoTree;
   return;

;
}

static tTree ReplaceCShifts
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kDUMMY_EXP:
/* line 499 "MakeOvUpdates.puma" */
   return exp;

  case kCONST_EXP:
/* line 503 "MakeOvUpdates.puma" */
   return exp;

  case kBOUND_EXP:
/* line 507 "MakeOvUpdates.puma" */
   return exp;

  case kRANK_EXP:
/* line 511 "MakeOvUpdates.puma" */
   return exp;

  case kARRAY_EXP:
/* line 515 "MakeOvUpdates.puma" */
   return exp;

  case kTYPE_EXP:
/* line 519 "MakeOvUpdates.puma" */
   return exp;

  case kSLICE_EXP:
/* line 523 "MakeOvUpdates.puma" */
   return exp;

  case kOP_EXP:
/* line 527 "MakeOvUpdates.puma" */
  {
/* line 528 "MakeOvUpdates.puma" */
 exp->OP_EXP.OPND1 = ReplaceCShifts (exp->OP_EXP.OPND1);
     exp->OP_EXP.OPND2 = ReplaceCShifts (exp->OP_EXP.OPND2);
   
  }
   return exp;

  case kOP1_EXP:
/* line 534 "MakeOvUpdates.puma" */
  {
/* line 535 "MakeOvUpdates.puma" */
 exp->OP1_EXP.OPND = ReplaceCShifts (exp->OP1_EXP.OPND); 
  }
   return exp;

  case kPERM_EXP:
/* line 539 "MakeOvUpdates.puma" */
   return exp;

  case kVAR_EXP:
/* line 543 "MakeOvUpdates.puma" */
   return exp;

  case kFUNC_CALL_EXP:
/* line 547 "MakeOvUpdates.puma" */
  {
/* line 548 "MakeOvUpdates.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL12;
  {
/* line 549 "MakeOvUpdates.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("CSHIFT", 6)))) goto yyL12;
  }
  }
   return TranslateCSHIFT (exp);
yyL12:;

/* line 553 "MakeOvUpdates.puma" */
  {
/* line 555 "MakeOvUpdates.puma" */
   if (! ((IsElementalCall (exp)))) goto yyL13;
  {
/* line 556 "MakeOvUpdates.puma" */
 exp->FUNC_CALL_EXP.FUNC_PARAMS = ReplaceCShifts (exp->FUNC_CALL_EXP.FUNC_PARAMS); 
  }
  }
   return exp;
yyL13:;

/* line 588 "MakeOvUpdates.puma" */
   return exp;

  case kBTP_LIST:
/* line 560 "MakeOvUpdates.puma" */
  {
/* line 562 "MakeOvUpdates.puma" */
 exp->BTP_LIST.Elem = ReplaceCShifts (exp->BTP_LIST.Elem); 
     exp->BTP_LIST.Next = ReplaceCShifts (exp->BTP_LIST.Next); 
   
  }
   return exp;

  case kBTP_EMPTY:
/* line 568 "MakeOvUpdates.puma" */
   return exp;

  case kNO_PARAM:
/* line 573 "MakeOvUpdates.puma" */
   return exp;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
/* line 578 "MakeOvUpdates.puma" */
  {
/* line 580 "MakeOvUpdates.puma" */
 exp->VAR_PARAM.V->ADDR.E = ReplaceCShifts (exp->VAR_PARAM.V->ADDR.E); 
  }
   return exp;

  }
/* line 584 "MakeOvUpdates.puma" */
   return exp;

  }

/* line 592 "MakeOvUpdates.puma" */
  {
/* line 593 "MakeOvUpdates.puma" */
   failure_protocol (MODULE, "ReplaceCShifts", exp);
  }
   return exp;

}

static tTree TranslateCSHIFT
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
/* line 608 "MakeOvUpdates.puma" */
 {
  shift_vector pos;
  rbool found;
  tTree var;
  {
/* line 614 "MakeOvUpdates.puma" */
   GetCircularShifting (exp, & found, & var, & pos);
/* line 615 "MakeOvUpdates.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 617 "MakeOvUpdates.puma" */
   stmt_protocol ("replace CSHIFT");
/* line 619 "MakeOvUpdates.puma" */
   if (! ((ValidOverlapUpdate (var, & pos)))) goto yyL1;
  {
/* line 623 "MakeOvUpdates.puma" */
   SetShiftOverlapUpdate (var, & pos);
/* line 625 "MakeOvUpdates.puma" */
   tree_protocol ("this is updated var: ", var);
/* line 627 "MakeOvUpdates.puma" */
   ApplyShiftToVar (var, & pos);
/* line 629 "MakeOvUpdates.puma" */
   tree_protocol ("this is shifted var: ", var);
  }
  }
  }
   return mVAR_EXP (var);
 }
yyL1:;

/* line 634 "MakeOvUpdates.puma" */
   return exp;

  }
 yyAbort ("TranslateCSHIFT");
 { tTree yyDummy; return yyDummy; }
}

static void OverlapUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
 yyRecursion:

  switch (exp->Kind) {
  case kDUMMY_EXP:
/* line 646 "MakeOvUpdates.puma" */
   return;

  case kCONST_EXP:
/* line 649 "MakeOvUpdates.puma" */
   return;

  case kARRAY_EXP:
/* line 652 "MakeOvUpdates.puma" */
   return;

  case kBOUND_EXP:
/* line 655 "MakeOvUpdates.puma" */
   return;

  case kTYPE_EXP:
/* line 658 "MakeOvUpdates.puma" */
   return;

  case kSLICE_EXP:
/* line 661 "MakeOvUpdates.puma" */
   return;

  case kOP_EXP:
/* line 664 "MakeOvUpdates.puma" */
  {
/* line 665 "MakeOvUpdates.puma" */
   OverlapUpdates (var, exp->OP_EXP.OPND1);
/* line 666 "MakeOvUpdates.puma" */
   exp = exp->OP_EXP.OPND2;
   goto yyRecursion;
  }

  case kOP1_EXP:
/* line 669 "MakeOvUpdates.puma" */
  {
/* line 670 "MakeOvUpdates.puma" */
   exp = exp->OP1_EXP.OPND;
   goto yyRecursion;
  }

  case kPERM_EXP:
/* line 673 "MakeOvUpdates.puma" */
   return;

  case kVAR_EXP:
/* line 676 "MakeOvUpdates.puma" */
  {
/* line 677 "MakeOvUpdates.puma" */
   OverlapVarUpdates (var, exp->VAR_EXP.V);
/* line 678 "MakeOvUpdates.puma" */
   OverlapIndexUpdates (var, exp->VAR_EXP.V);
  }
   return;

  case kFUNC_CALL_EXP:
/* line 681 "MakeOvUpdates.puma" */
  {
/* line 683 "MakeOvUpdates.puma" */
   if (! ((IsElementalCall (exp)))) goto yyL11;
  {
/* line 685 "MakeOvUpdates.puma" */
   exp = exp->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;
  }
  }
yyL11:;

/* line 688 "MakeOvUpdates.puma" */
   return;

  case kBTP_LIST:
/* line 691 "MakeOvUpdates.puma" */
  {
/* line 692 "MakeOvUpdates.puma" */
   OverlapUpdates (var, exp->BTP_LIST.Elem);
/* line 693 "MakeOvUpdates.puma" */
   exp = exp->BTP_LIST.Next;
   goto yyRecursion;
  }

  case kBTP_EMPTY:
/* line 696 "MakeOvUpdates.puma" */
   return;

  case kBTE_LIST:
/* line 699 "MakeOvUpdates.puma" */
  {
/* line 700 "MakeOvUpdates.puma" */
   OverlapUpdates (var, exp->BTE_LIST.Elem);
/* line 701 "MakeOvUpdates.puma" */
   exp = exp->BTE_LIST.Next;
   goto yyRecursion;
  }

  case kBTE_EMPTY:
/* line 704 "MakeOvUpdates.puma" */
   return;

  case kNO_PARAM:
/* line 707 "MakeOvUpdates.puma" */
   return;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
/* line 710 "MakeOvUpdates.puma" */
  {
/* line 711 "MakeOvUpdates.puma" */
   exp = exp->VAR_PARAM.V->ADDR.E;
   goto yyRecursion;
  }

  }
/* line 714 "MakeOvUpdates.puma" */
  {
/* line 715 "MakeOvUpdates.puma" */
   OverlapVarUpdates (var, exp->VAR_PARAM.V);
  }
   return;

  }

/* line 718 "MakeOvUpdates.puma" */
  {
/* line 719 "MakeOvUpdates.puma" */
   failure_protocol (MODULE, "OverlapUpdates", exp);
  }
   return;

;
}

static void OverlapIndexUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree owner, register tTree var)
# else
(owner, var)
 register tTree owner;
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kINDEXED_VAR) {
/* line 724 "MakeOvUpdates.puma" */
  {
/* line 726 "MakeOvUpdates.puma" */
   OverlapIndexUpdates (owner, var->INDEXED_VAR.IND_VAR);
/* line 727 "MakeOvUpdates.puma" */
   OverlapUpdates (owner, var->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 730 "MakeOvUpdates.puma" */
  {
/* line 732 "MakeOvUpdates.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 735 "MakeOvUpdates.puma" */
  {
/* line 737 "MakeOvUpdates.puma" */
   OverlapIndexUpdates (owner, var->SUBSTRING_VAR.IND_VAR);
/* line 738 "MakeOvUpdates.puma" */
   OverlapUpdates (owner, var->SUBSTRING_VAR.IND_EXP);
  }
   return;

  }
;
}

static void OverlapVarUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree left_var, register tTree right_var)
# else
(left_var, right_var)
 register tTree left_var;
 register tTree right_var;
# endif
{
  if (right_var->Kind == kINDEXED_VAR) {
/* line 743 "MakeOvUpdates.puma" */
 {
  shift_vector pos;
  rbool found;
  {
/* line 748 "MakeOvUpdates.puma" */
   GetShifting (left_var, right_var, & found, & pos);
/* line 750 "MakeOvUpdates.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 752 "MakeOvUpdates.puma" */
   if (! ((ValidOverlapUpdate (right_var, & pos)))) goto yyL1;
  {
/* line 754 "MakeOvUpdates.puma" */
   SetOverlapUpdate (right_var, & pos);
  }
  }
  }
   return;
 }
yyL1:;

  }
/* line 757 "MakeOvUpdates.puma" */
   return;

;
}

static void ApplyShiftToVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, pshift pos)
# else
(var, pos)
 register tTree var;
 pshift pos;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 770 "MakeOvUpdates.puma" */
  {
/* line 772 "MakeOvUpdates.puma" */
   ApplyShiftToIndexes (var->INDEXED_VAR.IND_EXPS, 0, pos);
  }
   return;

  }
/* line 775 "MakeOvUpdates.puma" */
  {
/* line 776 "MakeOvUpdates.puma" */
   failure_protocol (MODULE, "ApplyShiftToVar", var);
  }
   return;

;
}

static void ApplyShiftToIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int n, pshift pos)
# else
(indexes, n, pos)
 register tTree indexes;
 register int n;
 pshift pos;
# endif
{
 yyRecursion:
  if (indexes->Kind == kBTE_EMPTY) {
/* line 781 "MakeOvUpdates.puma" */
  {
/* line 782 "MakeOvUpdates.puma" */
   if (! ((pos -> shift_rank == n))) goto yyL1;
  }
   return;
yyL1:;

  }
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 785 "MakeOvUpdates.puma" */
  {
/* line 787 "MakeOvUpdates.puma" */
 indexes->BTE_LIST.Elem->SLICE_EXP.FIRST = AddConstant (indexes->BTE_LIST.Elem->SLICE_EXP.FIRST, -pos->shift_pos[n]);
    indexes->BTE_LIST.Elem->SLICE_EXP.STOP  = AddConstant (indexes->BTE_LIST.Elem->SLICE_EXP.STOP , -pos->shift_pos[n]);
  
/* line 791 "MakeOvUpdates.puma" */
   indexes = indexes->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
/* line 794 "MakeOvUpdates.puma" */
  {
/* line 796 "MakeOvUpdates.puma" */
 indexes->BTE_LIST.Elem = AddConstant (indexes->BTE_LIST.Elem, pos->shift_pos[n]); 
/* line 798 "MakeOvUpdates.puma" */
   indexes = indexes->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
/* line 801 "MakeOvUpdates.puma" */
  {
/* line 802 "MakeOvUpdates.puma" */
   failure_protocol (MODULE, "ApplyShiftToIndexes", indexes);
  }
   return;

;
}

static rbool ValidOverlapUpdate
# if defined __STDC__ | defined __cplusplus
(register tTree var, pshift pos)
# else
(var, pos)
 register tTree var;
 pshift pos;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 815 "MakeOvUpdates.puma" */
  {
/* line 816 "MakeOvUpdates.puma" */
   if (! ((ValidOverlapUpdate (var->INDEXED_VAR.IND_VAR, pos)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (var->Kind == kUSED_VAR) {
/* line 819 "MakeOvUpdates.puma" */
  {
/* line 820 "MakeOvUpdates.puma" */
   if (! ((ValidOverlapUpdate (var->USED_VAR.VARNAME, pos)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (var->Kind == kVAR_OBJ) {
/* line 823 "MakeOvUpdates.puma" */
  {
/* line 825 "MakeOvUpdates.puma" */
   if (! ((VarRank (var->VAR_OBJ.Object) == pos -> shift_rank))) goto yyL3;
  {
/* line 827 "MakeOvUpdates.puma" */
   if (! ((HasEnoughShadow (var->VAR_OBJ.Object, pos)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

void BeginMakeOvUpdates ARGS ((void))
{
}

void CloseMakeOvUpdates ARGS ((void))
{
}
