# include "MakeOn.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 48 "MakeOn.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Types.h"            /* TreeListGet */
# include "Transform.h"        /* CombineACF, ReplaceACF, ExpToVarParam */
# include "Ownership.h"        /* owner_spec */

# include "Traverse.h"
# include "HomeTraverse.h"
# include "GlobalComm.h"

# include "SMParallel.h"
# include "HomeDescriptor.h"
# include "Nesting.h"

# define MODULE "MakeOn"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeOn.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeOn_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeOn, routine %s failed\n",
  yyFunction);
 MakeOn_Exit ();
}

void MakeOn ARGS ((tTree t));
static rbool StopONHOME ARGS ((tTree t));
static tTree TranslateONHOME ARGS ((tTree t));
static tTree MakeOnStmts ARGS ((tTree t, pvar home));
static tTree Translation ARGS ((tTree t, pvar home));
static tTree MakeOnStmts1 ARGS ((tTree t, pvar home));

void MakeOn
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 87 "MakeOn.puma" */
  {
/* line 89 "MakeOn.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopONHOME, TranslateONHOME); 
  }
   return;

  }
/* line 92 "MakeOn.puma" */
  {
/* line 93 "MakeOn.puma" */
   failure_protocol (MODULE, "MakeOn", t);
  }
   return;

;
}

static rbool StopONHOME
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_HOME) {
/* line 106 "MakeOn.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kPARDO_INFO) {
/* line 109 "MakeOn.puma" */
   return rtrue;

  }
  }
  if (t->Kind == kACF_PARALLEL) {
/* line 112 "MakeOn.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree TranslateONHOME
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_HOME) {
/* line 123 "MakeOn.puma" */
 {
  tTree new;
  tTree comm;
  var_descriptor owner;
  {
/* line 125 "MakeOn.puma" */
   stmt_protocol ("translate ON HOME (local accesses + global reductions)");
/* line 130 "MakeOn.puma" */
   comm = GlobalCommunication (t);
/* line 131 "MakeOn.puma" */
   set_protocol_stmt (t);
/* line 135 "MakeOn.puma" */
   MakeReplicatedDescriptor (& owner);
/* line 137 "MakeOn.puma" */
   new = MakeOnStmts (t, & owner);
/* line 139 "MakeOn.puma" */
   tree_protocol ("global comm : \n", comm);
/* line 140 "MakeOn.puma" */
   tree_protocol ("new stmt : \n", new);
  }
   return CombineACF (new, comm);
 }

  }
  if (t->Kind == kACF_RESIDENT) {
/* line 145 "MakeOn.puma" */
   return t->ACF_RESIDENT.RESIDENT_BODY;

  }
/* line 151 "MakeOn.puma" */
   return t;

}

static tTree MakeOnStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home)
# else
(t, home)
 register tTree t;
 pvar home;
# endif
{
/* line 165 "MakeOn.puma" */
   return HomeReplaceAST (t, home, Translation);

}

static tTree Translation
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home)
# else
(t, home)
 register tTree t;
 pvar home;
# endif
{
  if (t->Kind == kACF_HOME) {
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 178 "MakeOn.puma" */
 {
  var_descriptor on_home;
  {
/* line 182 "MakeOn.puma" */
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
  }
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_PROC_CLAUSE) {
/* line 193 "MakeOn.puma" */
 {
  var_descriptor on_home;
  {
/* line 197 "MakeOn.puma" */
   SetProcDescriptor (t->ACF_HOME.HOME_VAR->ON_PROC_CLAUSE.ON_PROC, & on_home);
  }
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_HOST_CLAUSE) {
/* line 208 "MakeOn.puma" */
 {
  var_descriptor on_home;
  {
/* line 212 "MakeOn.puma" */
   MakeHostDescriptor (& on_home);
  }
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
 }

  }
  }
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
/* line 223 "MakeOn.puma" */
 {
  var_descriptor home_body;
  {
/* line 227 "MakeOn.puma" */
   SetVarDescriptor (t->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, & home_body);
/* line 229 "MakeOn.puma" */
   MakeOnLoop (t, & home_body);
  }
   return MakeOnSelection (t, home, & home_body);
 }

  }
  }
  if (t->Kind == kACF_RESIDENT) {
/* line 238 "MakeOn.puma" */
   return t->ACF_RESIDENT.RESIDENT_BODY;

  }
/* line 243 "MakeOn.puma" */
   return t;

}

static tTree MakeOnStmts1
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home)
# else
(t, home)
 register tTree t;
 pvar home;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 258 "MakeOn.puma" */
 {
  tTree newacf;
  {
/* line 262 "MakeOn.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 264 "MakeOn.puma" */
 newacf = MakeOnStmts1 (t->ACF_LIST.Elem, home);         
     t->ACF_LIST.Next   = MakeOnStmts1 (t->ACF_LIST.Next, home);         
   
/* line 268 "MakeOn.puma" */
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
   return newacf;
 }

  case kACF_EMPTY:
/* line 273 "MakeOn.puma" */
   return t;

  case kACF_BASIC:
/* line 278 "MakeOn.puma" */
   return t;

  case kACF_HOME:
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 289 "MakeOn.puma" */
 {
  var_descriptor on_home;
  {
/* line 293 "MakeOn.puma" */
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
/* line 295 "MakeOn.puma" */
 t->ACF_HOME.HOME_BODY = MakeOnStmts1 (t->ACF_HOME.HOME_BODY, &on_home); 
  }
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_HOST_CLAUSE) {
/* line 306 "MakeOn.puma" */
 {
  var_descriptor on_home;
  {
/* line 310 "MakeOn.puma" */
   MakeHostDescriptor (& on_home);
/* line 312 "MakeOn.puma" */
 t->ACF_HOME.HOME_BODY = MakeOnStmts1 (t->ACF_HOME.HOME_BODY, &on_home); 
  }
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
 }

  }
  break;
  case kACF_DO:
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
/* line 323 "MakeOn.puma" */
 {
  var_descriptor home_body;
  {
/* line 329 "MakeOn.puma" */
   IncLoopNesting (t);
/* line 331 "MakeOn.puma" */
   SetVarDescriptor (t->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, & home_body);
/* line 333 "MakeOn.puma" */
 t->ACF_DO.DO_BODY = MakeOnStmts1 (t->ACF_DO.DO_BODY, &home_body); 
/* line 335 "MakeOn.puma" */
   DecLoopNesting (t);
/* line 337 "MakeOn.puma" */
   MakeOnLoop (t, & home_body);
  }
   return MakeOnSelection (t, home, & home_body);
 }

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 394 "MakeOn.puma" */
  {
/* line 396 "MakeOn.puma" */
 t->ACF_DO.DO_BODY = MakeOnStmts1 (t->ACF_DO.DO_BODY, home); 
  }
   return t;

  }
  break;
  case kACF_NEW:
/* line 350 "MakeOn.puma" */
   t = t->ACF_NEW.NEW_BODY;
   goto yyRecursion;

  case kACF_RESIDENT:
/* line 361 "MakeOn.puma" */
   t = t->ACF_RESIDENT.RESIDENT_BODY;
   goto yyRecursion;

  case kACF_REDUCTION:
/* line 374 "MakeOn.puma" */
   return t;

  case kACF_IF:
/* line 385 "MakeOn.puma" */
  {
/* line 387 "MakeOn.puma" */
 t->ACF_IF.THEN_PART = MakeOnStmts1 (t->ACF_IF.THEN_PART, home);
    t->ACF_IF.ELSE_PART = MakeOnStmts1 (t->ACF_IF.ELSE_PART, home);
  
  }
   return t;

  case kACF_WHILE:
/* line 401 "MakeOn.puma" */
  {
/* line 403 "MakeOn.puma" */
 t->ACF_WHILE.WHILE_BODY = MakeOnStmts1 (t->ACF_WHILE.WHILE_BODY, home); 
  }
   return t;

  case kACF_DUMMY:
/* line 408 "MakeOn.puma" */
   return t;

  }

/* line 413 "MakeOn.puma" */
  {
/* line 415 "MakeOn.puma" */
   failure_protocol (MODULE, "MakeOnStmts1", t);
  }
   return t;

}

void BeginMakeOn ARGS ((void))
{
}

void CloseMakeOn ARGS ((void))
{
}
