# include "MakeMovement.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 26 "MakeMovement.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Types.h"
# include "Shapes.h"        /* MakeFullShape      */
# include "MoveControl.h"   /* CountMovements     */
# include "Transform.h"     /* ExpToVarParam      */

# include "Traverse.h"      /* ReplaceAST         */
# include "VectorMove.h"    /* VectorizeMovement  */

# include "MakeHome.h"      /* DoDetermineHome    */

# define  MODULE "MakeMovement" 

# undef  VEC_COMMUNICATION



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeMovement.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeMovement_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeMovement, routine %s failed\n",
  yyFunction);
 MakeMovement_Exit ();
}

void MakeMovement ARGS ((tTree t));
static rbool StopMakeMoveStmts ARGS ((tTree t));
static tTree DoMakeMoveStmts ARGS ((tTree t));
static void IsOnAssignment ARGS ((tTree var, tTree exp, rbool * yyP2, tTree * yyP1));
int TranslateMovement ARGS ((tTree stmt));
static void TransMoveStmt ARGS ((tTree stmt, int * yyP4, tTree * yyP3));
static tTree SetMoveMask ARGS ((tTree stmt, tTree mask));
static tTree AddMask ARGS ((tTree mask1, tTree mask2));
static void TranslateAssignment ARGS ((tTree assign, int * yyP6, tTree * yyP5));
static void TranslateReduce ARGS ((tTree reduce, int * yyP8, tTree * yyP7));
static tTree TranslateIndexes ARGS ((tTree index_list));
static void MakeLocalInfo ARGS ((tTree t));

void MakeMovement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 58 "MakeMovement.puma" */
  {
/* line 60 "MakeMovement.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeMoveStmts, DoMakeMoveStmts); 
  }
   return;

  }
/* line 63 "MakeMovement.puma" */
  {
/* line 64 "MakeMovement.puma" */
   failure_protocol (MODULE, "MakeMovements", t);
  }
   return;

;
}

static rbool StopMakeMoveStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_FORALL) {
/* line 80 "MakeMovement.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_WHERE) {
/* line 83 "MakeMovement.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_HOME) {
/* line 86 "MakeMovement.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree DoMakeMoveStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_FORALL) {
/* line 91 "MakeMovement.puma" */
 {
  int code;
  tTree new;
  {
/* line 96 "MakeMovement.puma" */
   code = TranslateMovement (t);
/* line 98 "MakeMovement.puma" */
 if (code == 0)

        { new = DoDetermineHome (t);
      
          MakeLocalInfo (t);  

          set_protocol_stmt (t);
          stmt_protocol ("movement is local, home determined");
        }

      else                              

#ifdef VEC_COMMUNICATION
        new = VectorizeCommunication (t);    
#else
        new = VectorizeMovement (t);         
#endif

   
  }
   return new;
 }

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 123 "MakeMovement.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  tTree new;
  {
/* line 125 "MakeMovement.puma" */
   IsOnAssignment (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, & yyV1, & yyV2);
/* line 127 "MakeMovement.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 131 "MakeMovement.puma" */
   stmt_protocol ("statement will be executed by owner");
/* line 133 "MakeMovement.puma" */
   new = mACF_HOME (mON_VAR_CLAUSE (yyV2), rfalse, mACF_LIST (t, mACF_EMPTY ()));
/* line 137 "MakeMovement.puma" */
   tree_protocol ("new home stmt : \n", new);
  }
  }
   return new;
 }
yyL2:;

/* line 142 "MakeMovement.puma" */
 {
  int code;
  {
/* line 146 "MakeMovement.puma" */
   code = TranslateMovement (t);
  }
   return t;
 }

  }
  }
/* line 151 "MakeMovement.puma" */
   return t;

}

static void IsOnAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, register rbool * yyP2, register tTree * yyP1)
# else
(var, exp, yyP2, yyP1)
 register tTree var;
 register tTree exp;
 register rbool * yyP2;
 register tTree * yyP1;
# endif
{
  if (var->Kind == kUSED_VAR) {
  if (exp->Kind == kVAR_EXP) {
/* line 168 "MakeMovement.puma" */
  {
/* line 170 "MakeMovement.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL1;
  {
/* line 171 "MakeMovement.puma" */
   if (! ((TreeRank (exp->VAR_EXP.V) == 0))) goto yyL1;
  {
/* line 173 "MakeMovement.puma" */
   if (! ((CountMovements (var, exp->VAR_EXP.V) != 0))) goto yyL1;
  {
/* line 174 "MakeMovement.puma" */
   if (! ((CountMovements (exp->VAR_EXP.V, var) == 0))) goto yyL1;
  }
  }
  }
  }
   * yyP2 = rtrue;
   * yyP1 = exp->VAR_EXP.V;
   return;
yyL1:;

  }
  }
  if (exp->Kind == kVAR_EXP) {
  if (exp->VAR_EXP.V->Kind == kUSED_VAR) {
/* line 179 "MakeMovement.puma" */
  {
/* line 181 "MakeMovement.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL2;
  {
/* line 182 "MakeMovement.puma" */
   if (! ((TreeRank (exp->VAR_EXP.V) == 0))) goto yyL2;
  {
/* line 184 "MakeMovement.puma" */
   if (! ((CountMovements (var, exp->VAR_EXP.V) == 0))) goto yyL2;
  {
/* line 185 "MakeMovement.puma" */
   if (! ((CountMovements (exp->VAR_EXP.V, var) != 0))) goto yyL2;
  }
  }
  }
  }
   * yyP2 = rtrue;
   * yyP1 = var;
   return;
yyL2:;

  }
  }
/* line 188 "MakeMovement.puma" */
   * yyP2 = rfalse;
   * yyP1 = NoTree;
   return;

;
}

int TranslateMovement
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
/* line 235 "MakeMovement.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 237 "MakeMovement.puma" */
   stmt_protocol ("movement will be classified");
/* line 239 "MakeMovement.puma" */
   TransMoveStmt (stmt, & yyV1, & yyV2);
/* line 241 "MakeMovement.puma" */
 if (yyV1 == 0)
       tree_protocol ("is local stmt:\n", stmt);
     else
       tree_protocol ("is movement stmt :\n", stmt);
  
  }
   return yyV1;
 }

}

static void TransMoveStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register int * yyP4, register tTree * yyP3)
# else
(stmt, yyP4, yyP3)
 register tTree stmt;
 register int * yyP4;
 register tTree * yyP3;
# endif
{
  if (stmt->Kind == kACF_FORALL) {
/* line 263 "MakeMovement.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 265 "MakeMovement.puma" */
   TransMoveStmt (stmt->ACF_FORALL.FORALL_BODY, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = stmt;
   return;
 }

  }
  if (stmt->Kind == kACF_IF) {
/* line 268 "MakeMovement.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 270 "MakeMovement.puma" */
   TransMoveStmt (stmt->ACF_IF.THEN_PART, & yyV1, & yyV2);
/* line 272 "MakeMovement.puma" */
 if (yyV1 == 0)
       { 
         stmt->ACF_IF.THEN_PART = yyV2; 
         yyV2 = stmt; 
       }
     else
       yyV2 = SetMoveMask (yyV2, stmt->ACF_IF.IF_EXP);
  
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  }
  if (stmt->Kind == kACF_LIST) {
  if (stmt->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 282 "MakeMovement.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 284 "MakeMovement.puma" */
   TransMoveStmt (stmt->ACF_LIST.Elem, & yyV1, & yyV2);
/* line 285 "MakeMovement.puma" */
 stmt->ACF_LIST.Elem = yyV2; 
  }
   * yyP4 = yyV1;
   * yyP3 = stmt;
   return;
 }

  }
/* line 288 "MakeMovement.puma" */
 {
  int yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  {
/* line 292 "MakeMovement.puma" */
   TransMoveStmt (stmt->ACF_LIST.Elem, & yyV1, & yyV2);
/* line 293 "MakeMovement.puma" */
   TransMoveStmt (stmt->ACF_LIST.Next, & yyV3, & yyV4);
/* line 295 "MakeMovement.puma" */
 if (yyV1 || yyV3)
       error_protocol ("more than one movement in FORALL nest");
  
  }
   * yyP4 = 0;
   * yyP3 = stmt;
   return;
 }

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 300 "MakeMovement.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 302 "MakeMovement.puma" */
   TranslateAssignment (stmt->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
/* line 303 "MakeMovement.puma" */
 stmt->ACF_BASIC.BASIC_STMT = yyV2; 
  }
   * yyP4 = yyV1;
   * yyP3 = stmt;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 306 "MakeMovement.puma" */
 {
  int yyV1;
  tTree yyV2;
  {
/* line 308 "MakeMovement.puma" */
   TranslateReduce (stmt->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
/* line 309 "MakeMovement.puma" */
 stmt->ACF_BASIC.BASIC_STMT = yyV2; 
  }
   * yyP4 = yyV1;
   * yyP3 = stmt;
   return;
 }

  }
  }
/* line 312 "MakeMovement.puma" */
  {
/* line 313 "MakeMovement.puma" */
   failure_protocol (MODULE, "TransMoveStmt", stmt);
  }
   * yyP4 = 0;
   * yyP3 = stmt;
   return;

;
}

static tTree SetMoveMask
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree mask)
# else
(stmt, mask)
 register tTree stmt;
 register tTree mask;
# endif
{
 yyRecursion:
  if (stmt->Kind == kACF_LIST) {
  if (stmt->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 327 "MakeMovement.puma" */
   stmt = stmt->ACF_LIST.Elem;
   goto yyRecursion;

  }
  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kSCATTER_STMT) {
/* line 332 "MakeMovement.puma" */
  {
/* line 334 "MakeMovement.puma" */
 stmt->ACF_BASIC.BASIC_STMT->SCATTER_STMT.MASK = AddMask (stmt->ACF_BASIC.BASIC_STMT->SCATTER_STMT.MASK, mask); 
  }
   return stmt;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kMOVE_STMT) {
/* line 339 "MakeMovement.puma" */
  {
/* line 341 "MakeMovement.puma" */
 stmt->ACF_BASIC.BASIC_STMT->MOVE_STMT.MASK = AddMask (stmt->ACF_BASIC.BASIC_STMT->MOVE_STMT.MASK, mask); 
  }
   return stmt;

  }
  }
  if (stmt->Kind == kACF_FORALL) {
/* line 346 "MakeMovement.puma" */
  {
/* line 348 "MakeMovement.puma" */
   set_protocol_stmt (stmt);
/* line 349 "MakeMovement.puma" */
   serious_warning_protocol ("mask not applied to communication stmt");
  }
   return stmt;

  }
/* line 354 "MakeMovement.puma" */
  {
/* line 356 "MakeMovement.puma" */
   failure_protocol (MODULE, "SetMoveMask", stmt);
  }
   return NoTree;

}

static tTree AddMask
# if defined __STDC__ | defined __cplusplus
(register tTree mask1, register tTree mask2)
# else
(mask1, mask2)
 register tTree mask1;
 register tTree mask2;
# endif
{
  if (mask1->Kind == kNO_PARAM) {
/* line 369 "MakeMovement.puma" */
   return ExpToVarParam (mask2);

  }
/* line 374 "MakeMovement.puma" */
  {
/* line 375 "MakeMovement.puma" */
   error_protocol ("too many masks for data movement");
  }
   return mask1;

}

static void TranslateAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register int * yyP6, register tTree * yyP5)
# else
(assign, yyP6, yyP5)
 register tTree assign;
 register int * yyP6;
 register tTree * yyP5;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
/* line 397 "MakeMovement.puma" */
  {
/* line 399 "MakeMovement.puma" */
   if (! ((CountMovements (assign->ASSIGN_STMT.ASSIGN_VAR, assign->ASSIGN_STMT.ASSIGN_EXP) == 0))) goto yyL1;
  {
/* line 400 "MakeMovement.puma" */
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  }
  }
   * yyP6 = 0;
   * yyP5 = assign;
   return;
yyL1:;

  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 403 "MakeMovement.puma" */
   * yyP6 = 5;
   * yyP5 = assign;
   return;

  }
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
/* line 406 "MakeMovement.puma" */
  {
/* line 409 "MakeMovement.puma" */
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL3;
  {
/* line 410 "MakeMovement.puma" */
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V)))) goto yyL3;
  }
  }
   * yyP6 = 1;
   * yyP5 = mMOVE_STMT (assign->ASSIGN_STMT.ASSIGN_VAR, assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V, mNO_PARAM (kDUMMY_TYPE));
   return;
yyL3:;

  if (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V->Kind == kINDEXED_VAR) {
/* line 413 "MakeMovement.puma" */
 {
  tTree new;
  {
/* line 415 "MakeMovement.puma" */
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL4;
  {
/* line 421 "MakeMovement.puma" */
   new = mSCATTER_STMT (MakeIdent ("GET_SCATTER", 11), assign->ASSIGN_STMT.ASSIGN_VAR, MakeFullShape (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V->INDEXED_VAR.IND_VAR), TranslateIndexes (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V->INDEXED_VAR.IND_EXPS), mNO_PARAM (kDUMMY_TYPE));
  }
  }
   * yyP6 = 3;
   * yyP5 = new;
   return;
 }
yyL4:;

  }
  }
  if (assign->ASSIGN_STMT.ASSIGN_VAR->Kind == kINDEXED_VAR) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
/* line 426 "MakeMovement.puma" */
 {
  tTree new;
  {
/* line 428 "MakeMovement.puma" */
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V)))) goto yyL5;
  {
/* line 434 "MakeMovement.puma" */
   new = mSCATTER_STMT (MakeIdent ("COPY_SCATTER", 12), assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V, MakeFullShape (assign->ASSIGN_STMT.ASSIGN_VAR->INDEXED_VAR.IND_VAR), TranslateIndexes (assign->ASSIGN_STMT.ASSIGN_VAR->INDEXED_VAR.IND_EXPS), mNO_PARAM (kDUMMY_TYPE));
  }
  }
   * yyP6 = 2;
   * yyP5 = new;
   return;
 }
yyL5:;

  }
  }
  }
/* line 439 "MakeMovement.puma" */
  {
/* line 441 "MakeMovement.puma" */
   error_protocol ("could not translate/classify assignment");
  }
   * yyP6 = 0;
   * yyP5 = assign;
   return;

;
}

static void TranslateReduce
# if defined __STDC__ | defined __cplusplus
(register tTree reduce, register int * yyP8, register tTree * yyP7)
# else
(reduce, yyP8, yyP7)
 register tTree reduce;
 register int * yyP8;
 register tTree * yyP7;
# endif
{
/* line 456 "MakeMovement.puma" */

char fn_name      [20];
char scatter_name [30];

  if (reduce->Kind == kREDUCE_STMT) {
  if (reduce->REDUCE_STMT.RED_PARAMS->Kind == kBTP_LIST) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->Kind == kINDEXED_VAR) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 461 "MakeMovement.puma" */
 {
  tTree new;
  {
/* line 465 "MakeMovement.puma" */
   if (! ((IsDescriptorVar (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  {
/* line 471 "MakeMovement.puma" */
   GetString (reduce->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, fn_name);
/* line 473 "MakeMovement.puma" */
   sprintf (scatter_name, "%s_SCATTER", fn_name);
/* line 475 "MakeMovement.puma" */
   new = mSCATTER_STMT (IsIdent (scatter_name), reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, MakeFullShape (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_VAR), TranslateIndexes (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_EXPS), mNO_PARAM (kDUMMY_TYPE));
  }
  }
   * yyP8 = 2;
   * yyP7 = new;
   return;
 }
yyL1:;

  }
  }
  }
  }
  }
  }
  }
/* line 480 "MakeMovement.puma" */
  {
/* line 482 "MakeMovement.puma" */
   error_protocol ("could not translate/classify reduce");
  }
   * yyP8 = 0;
   * yyP7 = reduce;
   return;

;
}

static tTree TranslateIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree index_list)
# else
(index_list)
 register tTree index_list;
# endif
{
  if (index_list->Kind == kBTE_LIST) {
  if (index_list->BTE_LIST.Elem->Kind == kVAR_EXP) {
/* line 493 "MakeMovement.puma" */
   return mBTP_LIST (mVAR_PARAM (index_list->BTE_LIST.Elem->VAR_EXP.V), TranslateIndexes (index_list->BTE_LIST.Next));

  }
  if (index_list->BTE_LIST.Elem->Kind == kCONST_EXP) {
/* line 498 "MakeMovement.puma" */
   return mBTP_LIST (ExpToVarParam (index_list->BTE_LIST.Elem), TranslateIndexes (index_list->BTE_LIST.Next));

  }
  }
  if (index_list->Kind == kBTE_EMPTY) {
/* line 503 "MakeMovement.puma" */
   return mBTP_EMPTY ();

  }
/* line 508 "MakeMovement.puma" */
  {
/* line 509 "MakeMovement.puma" */
   failure_protocol (MODULE, "TranslateIndexes", index_list);
  }
   return NoTree;

}

static void MakeLocalInfo
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
/* line 524 "MakeMovement.puma" */
  {
/* line 526 "MakeMovement.puma" */
   MakeLocalInfo (t->ACF_DO.DO_BODY);
/* line 528 "MakeMovement.puma" */
 t->ACF_DO.DO_HOME_INFO->COMM_INFO.is_local = rtrue; 
  }
   return;

  }
  }
  if (t->Kind == kACF_IF) {
/* line 531 "MakeMovement.puma" */
  {
/* line 533 "MakeMovement.puma" */
   MakeLocalInfo (t->ACF_IF.THEN_PART);
/* line 534 "MakeMovement.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  }
  if (t->Kind == kACF_LIST) {
/* line 537 "MakeMovement.puma" */
  {
/* line 539 "MakeMovement.puma" */
   MakeLocalInfo (t->ACF_LIST.Elem);
/* line 540 "MakeMovement.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kACF_EMPTY) {
/* line 543 "MakeMovement.puma" */
   return;

  }
  if (t->Kind == kACF_BASIC) {
/* line 546 "MakeMovement.puma" */
   return;

  }
  if (t->Kind == kACF_HOME) {
/* line 549 "MakeMovement.puma" */
  {
/* line 551 "MakeMovement.puma" */
   t = t->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  }
/* line 554 "MakeMovement.puma" */
  {
/* line 556 "MakeMovement.puma" */
   failure_protocol (MODULE, "MakeLocalInfo", t);
  }
   return;

;
}

void BeginMakeMovement ARGS ((void))
{
}

void CloseMakeMovement ARGS ((void))
{
}
