# include "MakeLoops.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 39 "MakeLoops.puma" */

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Types.h"
# include "Objects.h"
# include "Rank.h"
# include "Transform.h"    /* AppendDECLS */
# include "Shapes.h"

# include "Temporary.h"    /* GetLoopTemporary */

# include "Expressions.h"

# include "IndexShapes.h"  /* FindShapeExp */
# include "ReplaceExp.h"   /* RenameLoopId */

# undef DEBUG

# define MODULE "MakeLoops"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeLoops.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeLoops_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeLoops, routine %s failed\n",
  yyFunction);
 MakeLoops_Exit ();
}

static void FreeTemporaries0 ARGS ((void));
tTree SetActualShape ARGS ((tTree t, shape s));
static tTree SetSpreadActualShape ARGS ((tTree t, shape s));
static tTree SetTransposeShape ARGS ((tTree t, shape s));
static void SetActualIndexShape ARGS ((tTree ind, shape s, int n));
tTree MakeOuterLoops ARGS ((int line, shape s, tTree body, int kind));
tTree MakeOuterLoops1 ARGS ((int nest, int line, shape s, tTree body, int kind));
static tTree MakeListBody ARGS ((tTree t));
tTree MakeOuterImpliedLoops ARGS ((shape s, tTree body));
tTree MakeOuterImpliedLoopsV ARGS ((shape s, tTree body));
static tTree MakeLoopSlice ARGS ((tTree lb, tTree ub, tTree str));
static void CheckBound ARGS ((tTree exp));

static void FreeTemporaries0
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 67 "MakeLoops.puma" */
 {
  tTree help;
  {
/* line 70 "MakeLoops.puma" */
 FreeTemporaries (&help, &help); 
  }
   return;
 }

;
}

tTree SetActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
/* line 86 "MakeLoops.puma" */

tTree newexp;


  switch (t->Kind) {
  case kACF_WHERE:
/* line 90 "MakeLoops.puma" */
  {
/* line 92 "MakeLoops.puma" */
 t->ACF_WHERE.WHERE_EXP   = SetActualShape (t->ACF_WHERE.WHERE_EXP  , s);
     t->ACF_WHERE.TRUE_PART = SetActualShape (t->ACF_WHERE.TRUE_PART, s);
     t->ACF_WHERE.FALSE_PART = SetActualShape (t->ACF_WHERE.FALSE_PART, s); 

     t->Kind = kACF_IF; 

   
  }
   return t;

  case kACF_LIST:
/* line 103 "MakeLoops.puma" */
  {
/* line 105 "MakeLoops.puma" */
 t->ACF_LIST.Elem = SetActualShape (t->ACF_LIST.Elem, s);
     t->ACF_LIST.Next = SetActualShape (t->ACF_LIST.Next, s); 
  }
   return t;

  case kACF_EMPTY:
/* line 110 "MakeLoops.puma" */
   return t;

  case kACF_BASIC:
/* line 114 "MakeLoops.puma" */
  {
/* line 115 "MakeLoops.puma" */
 t->ACF_BASIC.BASIC_STMT = SetActualShape (t->ACF_BASIC.BASIC_STMT, s); 
  }
   return t;

  case kASSIGN_STMT:
/* line 119 "MakeLoops.puma" */
  {
/* line 120 "MakeLoops.puma" */
 t->ASSIGN_STMT.ASSIGN_VAR = SetActualShape (t->ASSIGN_STMT.ASSIGN_VAR, s);
     t->ASSIGN_STMT.ASSIGN_EXP = SetActualShape (t->ASSIGN_STMT.ASSIGN_EXP, s); 
  }
   return t;

  case kOP_EXP:
/* line 125 "MakeLoops.puma" */
  {
/* line 126 "MakeLoops.puma" */
 t->OP_EXP.OPND1 = SetActualShape (t->OP_EXP.OPND1, s);
     t->OP_EXP.OPND2 = SetActualShape (t->OP_EXP.OPND2, s); 
  }
   return t;

  case kOP1_EXP:
/* line 131 "MakeLoops.puma" */
  {
/* line 132 "MakeLoops.puma" */
 t->OP1_EXP.OPND = SetActualShape (t->OP1_EXP.OPND, s); 
  }
   return t;

  case kCONST_EXP:
/* line 136 "MakeLoops.puma" */
   return t;

  case kARRAY_EXP:
  if (t->ARRAY_EXP.ELEMENTS->Kind == kBTE_LIST) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 140 "MakeLoops.puma" */
  {
/* line 141 "MakeLoops.puma" */
 if (s->rank != 1)
        { printf ("Illegal formal shape for current array expression\n");
          WriteTree (stdout, t);
          exit(-1);
        }
     newexp = mVAR_EXP (GetLoopTemporary (s->perm[0]));

     newexp = FindShapeExp (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem, s->bounds[0][0], s->bounds[0][1], 
                               s->bounds[0][2], newexp );
   
  }
   return newexp;

  }
  }
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->Kind == kDO_EXP) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.BODY->Kind == kBTE_LIST) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.BODY->BTE_LIST.Next->Kind == kBTE_EMPTY) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 154 "MakeLoops.puma" */
  {
/* line 157 "MakeLoops.puma" */
 newexp = t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.BODY->BTE_LIST.Elem;
 
     newexp = FindShapeExp (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.RANGE, s->bounds[0][0], s->bounds[0][1],
                                   s->bounds[0][2], newexp );

     

     newexp = RenameExpLoopId (newexp, t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.DO_ID, GetLoopTemporary (s->perm[0]));

   
  }
   return newexp;

  }
  }
  }
  }
  }
/* line 170 "MakeLoops.puma" */
  {
/* line 171 "MakeLoops.puma" */
   error_protocol ("cannot deal with this array expression");
/* line 172 "MakeLoops.puma" */
   tree_protocol ("array expression is : ", t);
  }
   return t;

  case kFUNC_CALL_EXP:
/* line 176 "MakeLoops.puma" */
  {
/* line 177 "MakeLoops.puma" */
 
     newexp = t;
     if (IsIntrCall (t))

      { if (IntrFuncElemental (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)) 

          { 
            t->FUNC_CALL_EXP.FUNC_PARAMS = SetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
          }
         else if (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("SPREAD", 6))
          newexp = SetSpreadActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
         else if (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("TRANSPOSE", 9))
          newexp = SetTransposeShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
         else
          error_protocol ("Illegal Intrinsic function for SetActualShape");
      }
     else if (IsPureCall (t))
      { t->FUNC_CALL_EXP.FUNC_PARAMS = SetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
      }
     else
      error_protocol ("Illegal function call in SetActualShape");
   
  }
   return newexp;

  case kBTP_LIST:
/* line 202 "MakeLoops.puma" */
  {
/* line 204 "MakeLoops.puma" */
 t->BTP_LIST.Elem = SetActualShape (t->BTP_LIST.Elem, s); 
     t->BTP_LIST.Next = SetActualShape (t->BTP_LIST.Next, s);
   
  }
   return t;

  case kBTP_EMPTY:
/* line 211 "MakeLoops.puma" */
   return t;

  case kNO_PARAM:
/* line 216 "MakeLoops.puma" */
   return t;

  case kVAR_PARAM:
/* line 221 "MakeLoops.puma" */
  {
/* line 223 "MakeLoops.puma" */
 t->VAR_PARAM.V = SetActualShape (t->VAR_PARAM.V, s); 
  }
   return t;

  case kADDR:
/* line 227 "MakeLoops.puma" */
  {
/* line 229 "MakeLoops.puma" */
 t->ADDR.E = SetActualShape (t->ADDR.E, s); 
  }
   return t;

  case kTYPE_EXP:
/* line 233 "MakeLoops.puma" */
   return t;

  case kVAR_EXP:
/* line 238 "MakeLoops.puma" */
  {
/* line 239 "MakeLoops.puma" */
 t->VAR_EXP.V = SetActualShape (t->VAR_EXP.V, s); 
  }
   return t;

  case kUSED_VAR:
/* line 243 "MakeLoops.puma" */
  {
/* line 245 "MakeLoops.puma" */
   if (! ((TreeRank (t) == 0))) goto yyL20;
  }
   return t;
yyL20:;

/* line 249 "MakeLoops.puma" */
  {
/* line 251 "MakeLoops.puma" */
   error_protocol ("array variable not in full shape !! ");
/* line 252 "MakeLoops.puma" */
   tree_protocol ("variable is ", t);
  }
   return t;

  case kLOOP_VAR:
/* line 256 "MakeLoops.puma" */
   return t;

  case kSELECTED_VAR:
/* line 260 "MakeLoops.puma" */
  {
/* line 261 "MakeLoops.puma" */
   if (! (SetActualShape (t->SELECTED_VAR.SELEC_VAR, s))) goto yyL23;
  }
   return t;
yyL23:;

  break;
  case kINDEXED_VAR:
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 265 "MakeLoops.puma" */
  {
/* line 267 "MakeLoops.puma" */
   if (! ((TreeRank (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR) > 0))) goto yyL24;
  {
/* line 268 "MakeLoops.puma" */
   if (! (SetActualShape (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR, s))) goto yyL24;
  }
  }
   return t;
yyL24:;

  }
/* line 272 "MakeLoops.puma" */
  {
/* line 274 "MakeLoops.puma" */
   SetActualIndexShape (t->INDEXED_VAR.IND_EXPS, s, 0);
  }
   return t;

  }

/* line 278 "MakeLoops.puma" */
  {
/* line 279 "MakeLoops.puma" */
   failure_protocol (MODULE, "SetActualShape", t);
  }
   return NoTree;

}

static tTree SetSpreadActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
/* line 285 "MakeLoops.puma" */

int i, k, dimval;
rbool found;
tTree newexp;
struct_shape h_shp;

  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
  if (t->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 292 "MakeLoops.puma" */
  {
/* line 297 "MakeLoops.puma" */
 

    newexp = VarParamToExp (t->BTP_LIST.Elem);

    GetIntConstValue (t->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, &found, &dimval);
    if (!found)
       error_protocol ("DIM in SPREAD only at run-time");
     else if ((dimval <= 0) || (dimval > s->rank))
       error_protocol ("DIM in SPREAD out of range");
     else
       { 
         h_shp.rank = s->rank-1;
         for (i=0;i<s->rank;i++)
           if (i != dimval-1)
               { k = i;
                 if (i>=dimval) k = i-1;
                 h_shp.bounds[k][0] = s->bounds[i][0];
                 h_shp.bounds[k][1] = s->bounds[i][1];
                 h_shp.bounds[k][2] = s->bounds[i][2];
                 h_shp.perm[k] = s->perm[i];
               }
         newexp = SetActualShape (newexp, &h_shp);
       }
  
  }
   return newexp;

  }
  }
  }
  }
  }
  }
  }
/* line 325 "MakeLoops.puma" */
  {
/* line 326 "MakeLoops.puma" */
   error_protocol ("illegal SPREAD for SetSpreadActualShape");
  }
   return t;

}

static tTree SetTransposeShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (t->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 338 "MakeLoops.puma" */
 {
  struct_shape tshape;
  {
/* line 343 "MakeLoops.puma" */
 tshape = *s;
    tshape.bounds[0][0] = s->bounds[1][0];
    tshape.bounds[0][1] = s->bounds[1][1];
    tshape.bounds[0][2] = s->bounds[1][2];
    tshape.bounds[1][0] = s->bounds[0][0];
    tshape.bounds[1][1] = s->bounds[0][1];
    tshape.bounds[1][2] = s->bounds[0][2];
    tshape.perm[0]      = s->perm[1];
    tshape.perm[1]      = s->perm[0];
    
  
  }
   return SetActualShape (VarParamToExp (t->BTP_LIST.Elem), & tshape);
 }

  }
  }
  }
  }
  }
/* line 358 "MakeLoops.puma" */
  {
/* line 360 "MakeLoops.puma" */
   error_protocol ("illegal TRANSPOSE for SetTransposeShape");
  }
   return t;

}

static void SetActualIndexShape
# if defined __STDC__ | defined __cplusplus
(register tTree ind, shape s, register int n)
# else
(ind, s, n)
 register tTree ind;
 shape s;
 register int n;
# endif
{
/* line 367 "MakeLoops.puma" */

int rank;
struct_shape h_shp;

 yyRecursion:
  if (ind->Kind == kBTE_LIST) {
  if (ind->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 372 "MakeLoops.puma" */
 {
  tTree nexp;
  {
/* line 376 "MakeLoops.puma" */
 nexp = mVAR_EXP (GetLoopTemporary (s->perm[n]));

     ind->BTE_LIST.Elem = FindShapeExp (ind->BTE_LIST.Elem, s->bounds[n][0], s->bounds[n][1], 
                               s->bounds[n][2], nexp);

     SetActualIndexShape (ind, s, n+1);
   
  }
   return;
 }

  }
/* line 385 "MakeLoops.puma" */
  {
/* line 387 "MakeLoops.puma" */
   if (! ((TreeRank (ind->BTE_LIST.Elem) == 0))) goto yyL2;
  {
/* line 389 "MakeLoops.puma" */
   ind = ind->BTE_LIST.Next;
   goto yyRecursion;
  }
  }
yyL2:;

/* line 392 "MakeLoops.puma" */
  {
/* line 394 "MakeLoops.puma" */
   if (! ((TreeRank (ind->BTE_LIST.Elem) != 1))) goto yyL3;
  {
/* line 396 "MakeLoops.puma" */
   error_protocol ("wrong indirect addressing in SetActualIndexShape");
  }
  }
   return;
yyL3:;

/* line 399 "MakeLoops.puma" */
  {
/* line 403 "MakeLoops.puma" */
 

    h_shp.rank = 1;
    h_shp.bounds[0][0] = s->bounds[n][0];
    h_shp.bounds[0][1] = s->bounds[n][1];
    h_shp.bounds[0][2] = s->bounds[n][2];
    h_shp.perm [0]     = s->perm[n];

    ind->BTE_LIST.Elem = SetActualShape (ind->BTE_LIST.Elem, &h_shp);

  
/* line 415 "MakeLoops.puma" */
   ind = ind->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
  if (ind->Kind == kBTE_EMPTY) {
/* line 418 "MakeLoops.puma" */
   return;

  }
/* line 421 "MakeLoops.puma" */
  {
/* line 423 "MakeLoops.puma" */
   failure_protocol (MODULE, "SetActualIndexShape", ind);
  }
   return;

;
}

tTree MakeOuterLoops
# if defined __STDC__ | defined __cplusplus
(register int line, shape s, register tTree body, register int kind)
# else
(line, s, body, kind)
 register int line;
 shape s;
 register tTree body;
 register int kind;
# endif
{
/* line 438 "MakeLoops.puma" */
   return MakeOuterLoops1 (0, line, s, body, kind);

}

tTree MakeOuterLoops1
# if defined __STDC__ | defined __cplusplus
(register int nest, register int line, shape s, register tTree body, register int kind)
# else
(nest, line, s, body, kind)
 register int nest;
 register int line;
 shape s;
 register tTree body;
 register int kind;
# endif
{
/* line 446 "MakeLoops.puma" */

tTree new, var, range, info;
int i;

/* line 457 "MakeLoops.puma" */
  {
/* line 459 "MakeLoops.puma" */
 new = body;
    for (i=0; i<s->rank; i++)
      { 
        if (s->bounds[i][0] != s->bounds[i][1])
          { 
            new = MakeListBody (new);
            var = GetLoopTemporary (nest+s->perm[i]);
            
            range = MakeLoopSlice (s->bounds[i][0], 
                                   s->bounds[i][1],
                                   s->bounds[i][2]);
            if (kind == GEN_DO_INDEPENDENT)
               { info = mINDEP_INFO (rfalse, 0, NoTree, NoTree);
                 new = mACF_DO (var, range, new, info, mNO_HOME_INFO ());
                 LineACFNode (new, line);
               }
             else if (kind == GEN_FORALL)
               { info = mINDEP_INFO (rfalse, 0, NoTree, NoTree);
                 new = mACF_FORALL (var, range, new, info, mNO_HOME_INFO());
                 LineACFNode (new, line);
               }
             else
               { new = mACF_DO (var, range, new, mSERIAL_INFO(), 
                                mNO_HOME_INFO());
                 LineACFNode (new, line);
               }
          }
      }
  
  }
   return new;

}

static tTree MakeListBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LIST) {
/* line 493 "MakeLoops.puma" */
   return t;

  }
  if (t->Kind == kACF_EMPTY) {
/* line 497 "MakeLoops.puma" */
   return t;

  }
  if (Tree_IsType (t, kACF_NODE)) {
/* line 501 "MakeLoops.puma" */
   return mACF_LIST (t, mACF_EMPTY ());

  }
 yyAbort ("MakeListBody");
 { tTree yyDummy; return yyDummy; }
}

tTree MakeOuterImpliedLoops
# if defined __STDC__ | defined __cplusplus
(shape s, register tTree body)
# else
(s, body)
 shape s;
 register tTree body;
# endif
{
/* line 513 "MakeLoops.puma" */

tTree new, var, range;
int i;

/* line 518 "MakeLoops.puma" */
  {
/* line 519 "MakeLoops.puma" */
 new = body;
    for (i=0; i<s->rank; i++)
      { 
        if (s->bounds[i][0] != s->bounds[i][1])
          { 
            new = mBTE_LIST (new, mBTE_EMPTY());
            var = GetLoopTemporary (i+1);
            
            range = MakeLoopSlice (s->bounds[i][0], 
                                   s->bounds[i][1],
                                   s->bounds[i][2]);
            new = mDO_EXP (var, range, new);
          }
      }
  
  }
   return new;

}

tTree MakeOuterImpliedLoopsV
# if defined __STDC__ | defined __cplusplus
(shape s, register tTree body)
# else
(s, body)
 shape s;
 register tTree body;
# endif
{
/* line 545 "MakeLoops.puma" */

tTree new, var, range;
int i;

/* line 550 "MakeLoops.puma" */
  {
/* line 551 "MakeLoops.puma" */
 new = body;
    for (i=0; i<s->rank; i++)
      { 
        if (s->bounds[i][0] != s->bounds[i][1])
          { 
            new = mBTV_LIST (new, mBTV_EMPTY());
            var = GetLoopTemporary (i+1);
            
            if (s->bounds[i][2] != NoTree)
                range = s->bounds[i][2];
              else
                range = mDUMMY_EXP();
            
            range = mSLICE_EXP (s->bounds[i][0], 
                                s->bounds[i][1], range);
            new = mDO_VAR (var, range, new);
          }
      }
  
  }
   return new;

}

static tTree MakeLoopSlice
# if defined __STDC__ | defined __cplusplus
(register tTree lb, register tTree ub, register tTree str)
# else
(lb, ub, str)
 register tTree lb;
 register tTree ub;
 register tTree str;
# endif
{
 yyRecursion:
/* line 584 "MakeLoops.puma" */
  {
/* line 586 "MakeLoops.puma" */
   if (! ((str == NoTree))) goto yyL1;
  }
   str = mDUMMY_EXP ();
   goto yyRecursion;
yyL1:;

/* line 591 "MakeLoops.puma" */
  {
/* line 593 "MakeLoops.puma" */
   CheckBound (lb);
/* line 594 "MakeLoops.puma" */
   CheckBound (ub);
  }
   return mSLICE_EXP (lb, ub, str);

}

static void CheckBound
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kBOUND_EXP) {
/* line 603 "MakeLoops.puma" */
  {
/* line 605 "MakeLoops.puma" */
 exp->BOUND_EXP.VAR = CopyTree (exp->BOUND_EXP.VAR); 
  }
   return;

  }
;
}

void BeginMakeLoops ARGS ((void))
{
}

void CloseMakeLoops ARGS ((void))
{
}
