# include "MakeLocal.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 24 "MakeLocal.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Nesting.h" 
# include "Objects.h"
# include "Temporary.h"

# include "Traverse.h"       /* ReplaceAST             */

# include "Transform.h"      /* ComposeNewACF, CombineXXX */

# include "MakeHome.h"       /* MakeNewHome               */
# include "CheckComm.h"      /* CheckCommunication        */
# include "ExtractComm.h"    /* ExtractCommunication      */

# define MODULE "MakeLocal"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeLocal.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeLocal_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeLocal, routine %s failed\n",
  yyFunction);
 MakeLocal_Exit ();
}

void MakeLocal ARGS ((tTree t));
static void MakeLocalBody ARGS ((tTree t));
static tTree LocalizeStatements ARGS ((tTree t));
static tTree ExtendLoop ARGS ((tTree t, tTree pre, tTree post));
static tTree Serialize ARGS ((tTree stmt));
static tTree GetNewHomes ARGS ((tTree body));
static tTree GetNewHome1 ARGS ((tTree stmt));

void MakeLocal
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 60 "MakeLocal.puma" */
  {
/* line 62 "MakeLocal.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_LIST:
/* line 65 "MakeLocal.puma" */
  {
/* line 67 "MakeLocal.puma" */
   MakeLocal (t->UNIT_LIST.Elem);
/* line 68 "MakeLocal.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 71 "MakeLocal.puma" */
   return;

  case kPROGRAM_DECL:
/* line 74 "MakeLocal.puma" */
  {
/* line 76 "MakeLocal.puma" */
   NestOpenUnit (t);
/* line 77 "MakeLocal.puma" */
   MakeLocal (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 78 "MakeLocal.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 81 "MakeLocal.puma" */
  {
/* line 83 "MakeLocal.puma" */
   NestOpenUnit (t);
/* line 84 "MakeLocal.puma" */
   MakeLocal (t->PROC_DECL.PROC_BODY);
/* line 85 "MakeLocal.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 88 "MakeLocal.puma" */
  {
/* line 90 "MakeLocal.puma" */
   NestOpenUnit (t);
/* line 91 "MakeLocal.puma" */
   MakeLocal (t->FUNC_DECL.FUNC_BODY);
/* line 92 "MakeLocal.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 95 "MakeLocal.puma" */
  {
/* line 97 "MakeLocal.puma" */
   NestOpenUnit (t);
/* line 98 "MakeLocal.puma" */
   MakeLocal (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 99 "MakeLocal.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 102 "MakeLocal.puma" */
  {
/* line 104 "MakeLocal.puma" */
   NestOpenUnit (t);
/* line 105 "MakeLocal.puma" */
   MakeLocal (t->MODULE_DECL.MODULE_BODY);
/* line 106 "MakeLocal.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
/* line 109 "MakeLocal.puma" */
  {
/* line 111 "MakeLocal.puma" */
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

/* line 116 "MakeLocal.puma" */
  {
/* line 118 "MakeLocal.puma" */
   TemporaryInit (t);
/* line 120 "MakeLocal.puma" */
   print_protocol ("Extract communication: \n");
/* line 122 "MakeLocal.puma" */
   MakeLocalBody (t);
/* line 124 "MakeLocal.puma" */
   TemporaryDone (t);
/* line 126 "MakeLocal.puma" */
   t = t->BODY_NODE.INTERNALS;
   goto yyRecursion;
  }

  }

;
}

static void MakeLocalBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 142 "MakeLocal.puma" */
  {
/* line 144 "MakeLocal.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return;
yyL1:;

/* line 147 "MakeLocal.puma" */
  {
/* line 149 "MakeLocal.puma" */
 t->BODY_NODE.STATS = LocalizeStatements (t->BODY_NODE.STATS); 
  }
   return;

  }
/* line 152 "MakeLocal.puma" */
  {
/* line 153 "MakeLocal.puma" */
   failure_protocol (MODULE, "MakeLocalBody", t);
  }
   return;

;
}

static tTree LocalizeStatements
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
/* line 164 "MakeLocal.puma" */
 {
  tTree newacf;
  {
/* line 168 "MakeLocal.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 170 "MakeLocal.puma" */
 newacf = LocalizeStatements (t->ACF_LIST.Elem);            
     t->ACF_LIST.Next   = LocalizeStatements (t->ACF_LIST.Next);            
   
/* line 174 "MakeLocal.puma" */
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
   return newacf;
 }

  case kACF_EMPTY:
/* line 179 "MakeLocal.puma" */
   return t;

  case kACF_WHILE:
/* line 190 "MakeLocal.puma" */
 {
  int errors;
  tTree new_exp;
  tTree pre_stmts;
  tTree post_stmts;
  {
/* line 192 "MakeLocal.puma" */
 t->ACF_WHILE.WHILE_BODY = LocalizeStatements (t->ACF_WHILE.WHILE_BODY); 
/* line 198 "MakeLocal.puma" */
   errors = CheckCommunicationExp (t->ACF_WHILE.WHILE_EXP);
/* line 200 "MakeLocal.puma" */
   if (! ((errors == 0))) goto yyL3;
  {
/* line 206 "MakeLocal.puma" */
   ExtractCommunicationExp (t->ACF_WHILE.WHILE_EXP, & new_exp, & pre_stmts, & post_stmts);
/* line 208 "MakeLocal.puma" */
 t->ACF_WHILE.WHILE_EXP = new_exp; 
  }
  }
   return ExtendLoop (t, pre_stmts, post_stmts);
 }
yyL3:;

/* line 213 "MakeLocal.puma" */
  {
/* line 215 "MakeLocal.puma" */
   error_protocol ("unresolvable communication for exp in WHILE");
  }
   return t;

  case kACF_TASK_REGION:
/* line 226 "MakeLocal.puma" */
  {
/* line 228 "MakeLocal.puma" */
 t->ACF_TASK_REGION.TASK_BODY = LocalizeStatements (t->ACF_TASK_REGION.TASK_BODY); 
  }
   return t;

  case kACF_DO:
/* line 239 "MakeLocal.puma" */
 {
  int errors;
  tTree new_exp;
  tTree pre_stmts;
  tTree post_stmts;
  {
/* line 241 "MakeLocal.puma" */
 t->ACF_DO.DO_BODY = LocalizeStatements (t->ACF_DO.DO_BODY); 
/* line 247 "MakeLocal.puma" */
   errors = CheckCommunicationExp (t->ACF_DO.DO_RANGE);
/* line 249 "MakeLocal.puma" */
   if (! ((errors == 0))) goto yyL6;
  {
/* line 255 "MakeLocal.puma" */
   ExtractCommunicationExp (t->ACF_DO.DO_RANGE, & new_exp, & pre_stmts, & post_stmts);
/* line 257 "MakeLocal.puma" */
 t->ACF_DO.DO_RANGE = new_exp; 
  }
  }
   return ExtendLoop (t, pre_stmts, post_stmts);
 }
yyL6:;

/* line 262 "MakeLocal.puma" */
  {
/* line 264 "MakeLocal.puma" */
   error_protocol ("unresolvable communication for exp in DO");
  }
   return t;

  case kACF_IF:
/* line 275 "MakeLocal.puma" */
 {
  int errors;
  tTree new_exp;
  tTree pre_stmts;
  tTree post_stmts;
  {
/* line 277 "MakeLocal.puma" */
 t->ACF_IF.THEN_PART = LocalizeStatements (t->ACF_IF.THEN_PART); 
     t->ACF_IF.ELSE_PART = LocalizeStatements (t->ACF_IF.ELSE_PART); 
   
/* line 285 "MakeLocal.puma" */
   errors = CheckCommunicationExp (t->ACF_IF.IF_EXP);
/* line 287 "MakeLocal.puma" */
   if (! ((errors == 0))) goto yyL8;
  {
/* line 293 "MakeLocal.puma" */
   ExtractCommunicationExp (t->ACF_IF.IF_EXP, & new_exp, & pre_stmts, & post_stmts);
/* line 295 "MakeLocal.puma" */
 t->ACF_IF.IF_EXP = new_exp; 
  }
  }
   return ComposeNewACF (pre_stmts, t, post_stmts);
 }
yyL8:;

/* line 300 "MakeLocal.puma" */
  {
/* line 302 "MakeLocal.puma" */
   error_protocol ("unresolvable communication for exp in IF");
  }
   return t;

  case kACF_FORALL:
/* line 313 "MakeLocal.puma" */
 {
  int errors;
  {
/* line 317 "MakeLocal.puma" */
   errors = CheckCommunication (t);
/* line 319 "MakeLocal.puma" */
   if (! ((errors == 0))) goto yyL10;
  }
   return ExtractCommunication (t);
 }
yyL10:;

/* line 324 "MakeLocal.puma" */
   return Serialize (t);

  case kACF_HOME:
/* line 335 "MakeLocal.puma" */
 {
  int errors;
  {
/* line 339 "MakeLocal.puma" */
   errors = CheckCommunication (t);
/* line 341 "MakeLocal.puma" */
   if (! ((errors == 0))) goto yyL12;
  }
   return ExtractCommunication (t);
 }
yyL12:;

  if (t->ACF_HOME.HOME_BODY->Kind == kACF_LIST) {
  if (t->ACF_HOME.HOME_BODY->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 346 "MakeLocal.puma" */
  {
/* line 348 "MakeLocal.puma" */
   if (! ((IsParallelLoop (t->ACF_HOME.HOME_BODY->ACF_LIST.Elem)))) goto yyL13;
  {
/* line 350 "MakeLocal.puma" */
   set_protocol_stmt (t->ACF_HOME.HOME_BODY->ACF_LIST.Elem);
/* line 352 "MakeLocal.puma" */
   serious_warning_protocol ("loop becomes serial");
  }
  }
   return Serialize (t->ACF_HOME.HOME_BODY->ACF_LIST.Elem);
yyL13:;

  }
  }
/* line 357 "MakeLocal.puma" */
  {
/* line 359 "MakeLocal.puma" */
   set_protocol_stmt (t);
/* line 361 "MakeLocal.puma" */
   serious_warning_protocol ("HOME directive is ignored");
  }
   return Serialize (t);

  case kACF_WHERE:
/* line 390 "MakeLocal.puma" */
  {
/* line 392 "MakeLocal.puma" */
   error_protocol ("there should be no more WHERE statements at this point");
  }
   return t;

  case kACF_REDUCTION:
/* line 397 "MakeLocal.puma" */
  {
/* line 399 "MakeLocal.puma" */
 t->ACF_REDUCTION.REDUCTION_BODY = LocalizeStatements (t->ACF_REDUCTION.REDUCTION_BODY); 
  }
   return t;

  case kACF_NEW:
/* line 404 "MakeLocal.puma" */
  {
/* line 406 "MakeLocal.puma" */
 t->ACF_NEW.NEW_BODY = LocalizeStatements (t->ACF_NEW.NEW_BODY); 
  }
   return t;

  }

/* line 411 "MakeLocal.puma" */
 {
  int errors;
  {
/* line 413 "MakeLocal.puma" */
   SetActualData (t);
/* line 417 "MakeLocal.puma" */
   errors = CheckCommunication (t);
/* line 419 "MakeLocal.puma" */
   if (! ((errors == 0))) goto yyL20;
  }
   return ExtractCommunication (t);
 }
yyL20:;

/* line 424 "MakeLocal.puma" */
  {
/* line 426 "MakeLocal.puma" */
   error_protocol ("unresolvable communication in this stmt");
  }
   return t;

}

static tTree ExtendLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree pre, register tTree post)
# else
(t, pre, post)
 register tTree t;
 register tTree pre;
 register tTree post;
# endif
{
 yyRecursion:
/* line 449 "MakeLocal.puma" */
  {
/* line 451 "MakeLocal.puma" */
   if (! ((pre == NoTree))) goto yyL1;
  {
/* line 452 "MakeLocal.puma" */
   if (! ((post == NoTree))) goto yyL1;
  }
  }
   return t;
yyL1:;

  if (t->Kind == kACF_WHILE) {
/* line 457 "MakeLocal.puma" */
  {
/* line 459 "MakeLocal.puma" */
   if (! ((post == NoTree))) goto yyL2;
  {
/* line 461 "MakeLocal.puma" */
 t->ACF_WHILE.WHILE_BODY = AppendBody (t->ACF_WHILE.WHILE_BODY, CopyTree (pre)); 
  }
  }
   return CombineACF (pre, t);
yyL2:;

  }
  if (t->Kind == kACF_DO) {
/* line 466 "MakeLocal.puma" */
  {
/* line 468 "MakeLocal.puma" */
   if (! ((post == NoTree))) goto yyL3;
  {
/* line 470 "MakeLocal.puma" */
 t->ACF_DO.DO_BODY = AppendBody (t->ACF_DO.DO_BODY, CopyTree (pre)); 
  }
  }
   return CombineACF (pre, t);
yyL3:;

  }
/* line 475 "MakeLocal.puma" */
  {
/* line 477 "MakeLocal.puma" */
   if (! ((post != NoTree))) goto yyL4;
  {
/* line 479 "MakeLocal.puma" */
   error_protocol ("DO [WHILE] requires post statements for communication");
/* line 481 "MakeLocal.puma" */
   tree_protocol ("post : ", post);
  }
  }
   post = NoTree;
   goto yyRecursion;
yyL4:;

 yyAbort ("ExtendLoop");
 { tTree yyDummy; return yyDummy; }
}

static tTree Serialize
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
/* line 499 "MakeLocal.puma" */
 {
  tTree new;
  {
/* line 503 "MakeLocal.puma" */
   new = GetNewHomes (stmt->ACF_HOME.HOME_BODY);
/* line 505 "MakeLocal.puma" */
   tree_protocol ("new homes of body are :\n", new);
/* line 507 "MakeLocal.puma" */
   new = LocalizeStatements (new);
/* line 509 "MakeLocal.puma" */
   tree_protocol ("new localization is now (ignoring home) :\n", new);
  }
   return new;
 }

  }
  if (stmt->Kind == kACF_DO) {
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 514 "MakeLocal.puma" */
 {
  tTree new;
  {
/* line 518 "MakeLocal.puma" */
 stmt->ACF_DO.DO_DEP_INFO = mSERIAL_INFO (); 
/* line 520 "MakeLocal.puma" */
   new = stmt;
/* line 522 "MakeLocal.puma" */
   tree_protocol ("DO loop now serialized : \n", new);
/* line 524 "MakeLocal.puma" */
   new = MakeNewHome (new);
/* line 526 "MakeLocal.puma" */
   tree_protocol ("DO loop with new homes : \n", new);
/* line 528 "MakeLocal.puma" */
   new = LocalizeStatements (new);
/* line 530 "MakeLocal.puma" */
   tree_protocol ("DO loop localized is now  : \n", new);
  }
   return new;
 }

  }
  }
/* line 547 "MakeLocal.puma" */
  {
/* line 549 "MakeLocal.puma" */
   failure_protocol (MODULE, "Serialize", stmt);
  }
   return NoTree;

}

static tTree GetNewHomes
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 585 "MakeLocal.puma" */
   return GetNewHome1 (body->ACF_LIST.Elem);

  }
/* line 594 "MakeLocal.puma" */
   return MakeNewHome (body);

  }
/* line 599 "MakeLocal.puma" */
  {
/* line 601 "MakeLocal.puma" */
   failure_protocol (MODULE, "GetNewHomes", body);
  }
   return NoTree;

}

static tTree GetNewHome1
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_NEW) {
/* line 607 "MakeLocal.puma" */
  {
/* line 609 "MakeLocal.puma" */
 stmt->ACF_NEW.NEW_BODY = MakeNewHome (stmt->ACF_NEW.NEW_BODY); 
  }
   return stmt;

  }
/* line 614 "MakeLocal.puma" */
  {
/* line 616 "MakeLocal.puma" */
   if (! ((IsParallelLoop (stmt)))) goto yyL2;
  }
   return Serialize (stmt);
yyL2:;

  if (stmt->Kind == kACF_DO) {
/* line 621 "MakeLocal.puma" */
  {
/* line 623 "MakeLocal.puma" */
 stmt->ACF_DO.DO_BODY = MakeNewHome (stmt->ACF_DO.DO_BODY); 
  }
   return stmt;

  }
  if (stmt->Kind == kACF_IF) {
/* line 628 "MakeLocal.puma" */
  {
/* line 630 "MakeLocal.puma" */
 stmt->ACF_IF.THEN_PART = MakeNewHome (stmt->ACF_IF.THEN_PART); 
     stmt->ACF_IF.ELSE_PART = MakeNewHome (stmt->ACF_IF.ELSE_PART);
   
  }
   return stmt;

  }
/* line 637 "MakeLocal.puma" */
   return stmt;

}

void BeginMakeLocal ARGS ((void))
{
}

void CloseMakeLocal ARGS ((void))
{
}
