# include "MakeHome.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 48 "MakeHome.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Transform.h" 
# include "Traverse.h"
# include "FindHome.h"
# include "Temporary.h"

# include "Unparse.h"             /* FileUnparse for DEBUG mode */

# include "Nesting.h"               /* NestOpen */

# include "Objects.h"

# include "Descriptor.h"
# include "HomeDescriptor.h"
# include "MoveDescriptor.h"
# include "ParNest.h"
# include "Expansion.h"             /* FullExpansion          */

# include "CheckHome.h"             /* CheckHome              */
# include "ArrayData.h"

# define MODULE "MakeHome"

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeHome.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeHome_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeHome, routine %s failed\n",
  yyFunction);
 MakeHome_Exit ();
}

void MakeHome ARGS ((tTree t));
static void DetermineHome ARGS ((tTree t));
tTree MakeNewHome ARGS ((tTree t));
static rbool StopDetermineHome ARGS ((tTree t));
tTree DoDetermineHome ARGS ((tTree t));
static tTree PropagateHome ARGS ((tTree t, pvar outer_home));
static void InfoDoLoopHome ARGS ((tTree loop, pvar iter_home));
static tTree SetNewHome ARGS ((tTree stmt, pvar outer_home, pvar inner_home));
static tTree BuildNewVarHome ARGS ((tTree stmt, pvar home));
static int GetBodyLine ARGS ((tTree stmt));
static void MakeHomeTemplate ARGS ((pvar home, pvar home1, tTree * yyP2, tTree * yyP1));
static void SetIterationsHome ARGS ((tTree loop, pvar iter_home));
static void SetSelection ARGS ((tTree loop, pvar iter_home));
static void FindNewHomeDescriptor ARGS ((tTree stmt, pvar cur_home, pvar new_home));
static void FindSerialHomeDescriptor ARGS ((tTree stmt, pvar cur_home, pvar new_home));
static void DetermineFinalHome ARGS ((pvar cur_home, pvar min_home, pvar new_home));
static void InheritTemplate ARGS ((pvar home, pvar sub_home));
static void CheckCallHome ARGS ((tTree t, pvar final_home));

void MakeHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 94 "MakeHome.puma" */
  {
/* line 96 "MakeHome.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_LIST:
/* line 101 "MakeHome.puma" */
  {
/* line 103 "MakeHome.puma" */
   MakeHome (t->UNIT_LIST.Elem);
/* line 104 "MakeHome.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 107 "MakeHome.puma" */
   return;

  case kPROGRAM_DECL:
/* line 110 "MakeHome.puma" */
  {
/* line 112 "MakeHome.puma" */
   NestOpenUnit (t);
/* line 113 "MakeHome.puma" */
   MakeHome (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 114 "MakeHome.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 117 "MakeHome.puma" */
  {
/* line 119 "MakeHome.puma" */
   NestOpenUnit (t);
/* line 120 "MakeHome.puma" */
   MakeHome (t->PROC_DECL.PROC_BODY);
/* line 121 "MakeHome.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 124 "MakeHome.puma" */
  {
/* line 126 "MakeHome.puma" */
   NestOpenUnit (t);
/* line 127 "MakeHome.puma" */
   MakeHome (t->FUNC_DECL.FUNC_BODY);
/* line 128 "MakeHome.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 131 "MakeHome.puma" */
  {
/* line 133 "MakeHome.puma" */
   NestOpenUnit (t);
/* line 134 "MakeHome.puma" */
   MakeHome (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 135 "MakeHome.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 138 "MakeHome.puma" */
  {
/* line 140 "MakeHome.puma" */
   NestOpenUnit (t);
/* line 141 "MakeHome.puma" */
   MakeHome (t->MODULE_DECL.MODULE_BODY);
/* line 142 "MakeHome.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
/* line 145 "MakeHome.puma" */
  {
/* line 147 "MakeHome.puma" */
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

/* line 152 "MakeHome.puma" */
  {
/* line 154 "MakeHome.puma" */
   TemporaryInit (t);
/* line 156 "MakeHome.puma" */
   print_protocol ("Step 1 : check home \n");
/* line 158 "MakeHome.puma" */
   CheckHome (t);
/* line 160 "MakeHome.puma" */
   print_protocol ("Step 2 : find home \n");
/* line 162 "MakeHome.puma" */
   DetermineHome (t);
/* line 164 "MakeHome.puma" */
   TemporaryDone (t);
/* line 166 "MakeHome.puma" */
   t = t->BODY_NODE.INTERNALS;
   goto yyRecursion;
  }

  }

;
}

static void DetermineHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 202 "MakeHome.puma" */
  {
/* line 204 "MakeHome.puma" */
 t->BODY_NODE.STATS = MakeNewHome (t->BODY_NODE.STATS); 
  }
   return;

  }
/* line 207 "MakeHome.puma" */
  {
/* line 208 "MakeHome.puma" */
   failure_protocol (MODULE, "DetermineHome", t);
  }
   return;

;
}

tTree MakeNewHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 213 "MakeHome.puma" */
   return ReplaceAST (t, StopDetermineHome, DoDetermineHome);

}

static rbool StopDetermineHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 231 "MakeHome.puma" */
   return rtrue;

  }
  }
  if (t->Kind == kACF_FORALL) {
  if (t->ACF_FORALL.FORALL_DEP_INFO->Kind == kINDEP_INFO) {
/* line 234 "MakeHome.puma" */
   return rtrue;

  }
  }
  if (t->Kind == kACF_HOME) {
/* line 237 "MakeHome.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_BASIC) {
/* line 240 "MakeHome.puma" */
   return rtrue;

  }
/* line 243 "MakeHome.puma" */
  {
/* line 244 "MakeHome.puma" */
   return rfalse;
  }

}

tTree DoDetermineHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 264 "MakeHome.puma" */
 {
  var_descriptor vard;
  tTree new;
  {
/* line 269 "MakeHome.puma" */
   MakeReplicatedDescriptor (& vard);
/* line 271 "MakeHome.puma" */
   new = PropagateHome (t, & vard);
/* line 273 "MakeHome.puma" */
   tree_protocol ("home of independent loop identified : \n", new);
  }
   return new;
 }

  }
  }
  if (t->Kind == kACF_FORALL) {
/* line 278 "MakeHome.puma" */
  {
/* line 280 "MakeHome.puma" */
 t->Kind = kACF_DO; 
  }
   goto yyRecursion;

  }
  if (t->Kind == kACF_HOME) {
/* line 285 "MakeHome.puma" */
 {
  var_descriptor vard;
  tTree new;
  {
/* line 290 "MakeHome.puma" */
   MakeReplicatedDescriptor (& vard);
/* line 292 "MakeHome.puma" */
   new = PropagateHome (t, & vard);
/* line 294 "MakeHome.puma" */
   tree_protocol ("homes of home stmt/block identified : \n", new);
  }
   return new;
 }

  }
  if (t->Kind == kACF_BASIC) {
/* line 299 "MakeHome.puma" */
 {
  var_descriptor vard;
  tTree new;
  {
/* line 304 "MakeHome.puma" */
   MakeReplicatedDescriptor (& vard);
/* line 306 "MakeHome.puma" */
   new = PropagateHome (t, & vard);
/* line 308 "MakeHome.puma" */
 if (new != t)
        tree_protocol ("home of basic statement found : \n", new);
   
  }
   return new;
 }

  }
/* line 315 "MakeHome.puma" */
   return t;

}

static tTree PropagateHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar outer_home)
# else
(t, outer_home)
 register tTree t;
 pvar outer_home;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 333 "MakeHome.puma" */
 {
  tTree newacf;
  {
/* line 337 "MakeHome.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 339 "MakeHome.puma" */
 newacf = PropagateHome (t->ACF_LIST.Elem, outer_home);         
     t->ACF_LIST.Next   = PropagateHome (t->ACF_LIST.Next, outer_home);         
   
/* line 343 "MakeHome.puma" */
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
   return newacf;
 }

  case kACF_EMPTY:
/* line 348 "MakeHome.puma" */
   return t;

  case kACF_FORALL:
  if (t->ACF_FORALL.FORALL_DEP_INFO->Kind == kINDEP_INFO) {
/* line 353 "MakeHome.puma" */
  {
/* line 355 "MakeHome.puma" */
 t->Kind = kACF_DO; 
  }
   goto yyRecursion;

  }
  break;
  case kACF_DO:
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 360 "MakeHome.puma" */
 {
  var_descriptor iter_home;
  tTree yyV1;
  tTree yyV2;
  rbool okay;
  {
/* line 362 "MakeHome.puma" */
   IncParNesting (t);
/* line 366 "MakeHome.puma" */
   FindNewHomeDescriptor (t->ACF_DO.DO_BODY, outer_home, & iter_home);
/* line 368 "MakeHome.puma" */
   tree_protocol ("home of loop ", PrintableDescriptorVar (outer_home));
/* line 369 "MakeHome.puma" */
   tree_protocol ("home of loop body = ", PrintableDescriptorVar (& iter_home));
/* line 371 "MakeHome.puma" */
   InfoDoLoopHome (t, & iter_home);
/* line 373 "MakeHome.puma" */
   MakeHomeTemplate (outer_home, & iter_home, & yyV1, & yyV2);
/* line 375 "MakeHome.puma" */
   SetIterationsHome (t, & iter_home);
/* line 376 "MakeHome.puma" */
   SetSelection (t, & iter_home);
/* line 378 "MakeHome.puma" */
 t->ACF_DO.DO_BODY = PropagateHome (t->ACF_DO.DO_BODY, &iter_home); 
     t->ACF_DO.DO_BODY = MakeStmtList (SetNewHome (t->ACF_DO.DO_BODY, outer_home, &iter_home));
   
/* line 384 "MakeHome.puma" */
   ExpandDescriptor (& iter_home, t->ACF_DO.DO_ID, & okay);
/* line 386 "MakeHome.puma" */
 if (!okay)

        { set_protocol_stmt(t);
          serious_warning_protocol ("could not expand descriptor");
        }

   
/* line 394 "MakeHome.puma" */
   DecParNesting (t);
  }
   return ComposeNewACF (yyV1, SetNewHome (t, outer_home, & iter_home), yyV2);
 }

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 565 "MakeHome.puma" */
  {
/* line 567 "MakeHome.puma" */
 t->ACF_DO.DO_BODY = PropagateHome (t->ACF_DO.DO_BODY, outer_home); 
  }
   return t;

  }
  break;
  case kACF_NEW:
/* line 400 "MakeHome.puma" */
  {
/* line 402 "MakeHome.puma" */
   IncParNesting (t);
/* line 403 "MakeHome.puma" */
 t->ACF_NEW.NEW_BODY = PropagateHome (t->ACF_NEW.NEW_BODY, outer_home); 
/* line 404 "MakeHome.puma" */
   DecParNesting (t);
  }
   return t;

  case kACF_RESIDENT:
/* line 409 "MakeHome.puma" */
  {
/* line 411 "MakeHome.puma" */
   IncParNesting (t);
/* line 412 "MakeHome.puma" */
 t->ACF_RESIDENT.RESIDENT_BODY = PropagateHome (t->ACF_RESIDENT.RESIDENT_BODY, outer_home); 
/* line 413 "MakeHome.puma" */
   DecParNesting (t);
  }
   return t;

  case kACF_TASK_REGION:
/* line 418 "MakeHome.puma" */
 {
  var_descriptor new_home;
  {
/* line 420 "MakeHome.puma" */
   IncParNesting (t);
/* line 424 "MakeHome.puma" */
   FindNewHomeDescriptor (t, outer_home, & new_home);
/* line 426 "MakeHome.puma" */
 t->ACF_TASK_REGION.TASK_BODY = PropagateHome (t->ACF_TASK_REGION.TASK_BODY, &new_home); 
/* line 428 "MakeHome.puma" */
   DecParNesting (t);
  }
   return SetNewHome (t, outer_home, & new_home);
 }

  case kACF_REDUCTION:
/* line 433 "MakeHome.puma" */
 {
  var_descriptor new_home;
  {
/* line 435 "MakeHome.puma" */
   IncParNesting (t);
/* line 439 "MakeHome.puma" */
   FindNewHomeDescriptor (t, outer_home, & new_home);
/* line 441 "MakeHome.puma" */
 t->ACF_REDUCTION.REDUCTION_BODY = PropagateHome (t->ACF_REDUCTION.REDUCTION_BODY, &new_home); 
/* line 443 "MakeHome.puma" */
   DecParNesting (t);
  }
   return SetNewHome (t, outer_home, & new_home);
 }

  case kACF_HOME:
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 448 "MakeHome.puma" */
 {
  var_descriptor on_home;
  {
/* line 452 "MakeHome.puma" */
   IncParNesting (t);
/* line 463 "MakeHome.puma" */
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
/* line 465 "MakeHome.puma" */
 t->ACF_HOME.HOME_BODY = PropagateHome (t->ACF_HOME.HOME_BODY, &on_home); 
/* line 467 "MakeHome.puma" */
   DecParNesting (t);
  }
   return t;
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_ALL_CLAUSE) {
/* line 472 "MakeHome.puma" */
 {
  var_descriptor on_home;
  {
/* line 476 "MakeHome.puma" */
   IncParNesting (t);
/* line 478 "MakeHome.puma" */
   MakeReplicatedDescriptor (& on_home);
/* line 480 "MakeHome.puma" */
 t->ACF_HOME.HOME_BODY = PropagateHome (t->ACF_HOME.HOME_BODY, &on_home); 
/* line 482 "MakeHome.puma" */
   DecParNesting (t);
  }
   return t;
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_PROC_CLAUSE) {
/* line 487 "MakeHome.puma" */
 {
  var_descriptor on_home;
  {
/* line 491 "MakeHome.puma" */
   IncParNesting (t);
/* line 493 "MakeHome.puma" */
   SetProcDescriptor (t->ACF_HOME.HOME_VAR->ON_PROC_CLAUSE.ON_PROC, & on_home);
/* line 495 "MakeHome.puma" */
 t->ACF_HOME.HOME_BODY = PropagateHome (t->ACF_HOME.HOME_BODY, &on_home); 
/* line 497 "MakeHome.puma" */
   DecParNesting (t);
  }
   return t;
 }

  }
  break;
  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 502 "MakeHome.puma" */
 {
  var_descriptor new_home;
  {
/* line 506 "MakeHome.puma" */
   FindSerialHomeDescriptor (t, outer_home, & new_home);
  }
   return SetNewHome (t, outer_home, & new_home);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 515 "MakeHome.puma" */
 {
  var_descriptor new_home;
  {
/* line 521 "MakeHome.puma" */
   FindNewHomeDescriptor (t, outer_home, & new_home);
  }
   return SetNewHome (t, outer_home, & new_home);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 526 "MakeHome.puma" */
 {
  var_descriptor new_home;
  {
/* line 528 "MakeHome.puma" */
   if (! ((IsSerialCall (t->ACF_BASIC.BASIC_STMT)))) goto yyL14;
  {
/* line 532 "MakeHome.puma" */
   FindSerialHomeDescriptor (t, outer_home, & new_home);
  }
  }
   return SetNewHome (t, outer_home, & new_home);
 }
yyL14:;

  }
/* line 537 "MakeHome.puma" */
 {
  var_descriptor new_home;
  {
/* line 539 "MakeHome.puma" */
   SetActualData (t);
/* line 543 "MakeHome.puma" */
   FindNewHomeDescriptor (t, outer_home, & new_home);
/* line 545 "MakeHome.puma" */
   CheckCallHome (t, & new_home);
  }
   return SetNewHome (t, outer_home, & new_home);
 }

  case kACF_IF:
/* line 556 "MakeHome.puma" */
  {
/* line 558 "MakeHome.puma" */
 t->ACF_IF.THEN_PART = PropagateHome (t->ACF_IF.THEN_PART, outer_home);
     t->ACF_IF.ELSE_PART = PropagateHome (t->ACF_IF.ELSE_PART, outer_home);
   
  }
   return t;

  case kACF_WHILE:
/* line 572 "MakeHome.puma" */
  {
/* line 574 "MakeHome.puma" */
 t->ACF_WHILE.WHILE_BODY = PropagateHome (t->ACF_WHILE.WHILE_BODY, outer_home); 
  }
   return t;

  case kACF_DUMMY:
/* line 579 "MakeHome.puma" */
   return t;

  }

/* line 584 "MakeHome.puma" */
  {
/* line 586 "MakeHome.puma" */
   error_protocol ("illegal statement to propagate home");
  }
   return t;

}

static void InfoDoLoopHome
# if defined __STDC__ | defined __cplusplus
(register tTree loop, pvar iter_home)
# else
(loop, iter_home)
 register tTree loop;
 pvar iter_home;
# endif
{
/* line 598 "MakeHome.puma" */
  {
/* line 600 "MakeHome.puma" */
   if (! ((! IsParallelHomeDescriptor (iter_home)))) goto yyL1;
  {
/* line 602 "MakeHome.puma" */
   if (! ((IsNonLocalModel (GetCurrentModel ())))) goto yyL1;
  {
/* line 604 "MakeHome.puma" */
   set_protocol_stmt (loop);
/* line 606 "MakeHome.puma" */
   warning_protocol ("no parallel home descriptor for iterations found");
/* line 607 "MakeHome.puma" */
   tree_protocol ("proposed home is : ", PrintableDescriptorVar (iter_home));
  }
  }
  }
   return;
yyL1:;

;
}

static tTree SetNewHome
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar outer_home, pvar inner_home)
# else
(stmt, outer_home, inner_home)
 register tTree stmt;
 pvar outer_home;
 pvar inner_home;
# endif
{
/* line 623 "MakeHome.puma" */
  {
/* line 625 "MakeHome.puma" */


#ifdef DEBUG
     tree_protocol ("set new home : \n", stmt);
     tree_protocol ("outer home: ", PrintableDescriptorVar (outer_home));
     tree_protocol ("inner home: ", PrintableDescriptorVar (inner_home));
#endif
   
/* line 636 "MakeHome.puma" */
   if (! ((VDIsSame (outer_home, inner_home)))) goto yyL1;
  }
   return stmt;
yyL1:;

/* line 641 "MakeHome.puma" */
  {
/* line 645 "MakeHome.puma" */
   if (! ((IsFictiveParDescriptor (inner_home)))) goto yyL2;
  }
   return stmt;
yyL2:;

/* line 650 "MakeHome.puma" */
  {
/* line 654 "MakeHome.puma" */
   if (! ((IsNoDescriptor (inner_home)))) goto yyL3;
  }
   return stmt;
yyL3:;

/* line 659 "MakeHome.puma" */
 {
  tTree home_stmt;
  {
/* line 663 "MakeHome.puma" */
   if (! ((IsReplicatedDescriptor (outer_home)))) goto yyL4;
  {
/* line 664 "MakeHome.puma" */
   if (! ((IsHostDescriptor (inner_home)))) goto yyL4;
  {
/* line 666 "MakeHome.puma" */
   home_stmt = mACF_HOME (mON_HOST_CLAUSE (), rfalse, MakeStmtList (stmt));
/* line 669 "MakeHome.puma" */
   LineACFNode (home_stmt, GetBodyLine (stmt));
  }
  }
  }
   return home_stmt;
 }
yyL4:;

/* line 674 "MakeHome.puma" */
   return BuildNewVarHome (stmt, inner_home);

}

static tTree BuildNewVarHome
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home)
# else
(stmt, home)
 register tTree stmt;
 pvar home;
# endif
{
  if (stmt->Kind == kACF_LIST) {
  if (stmt->ACF_LIST.Elem->Kind == kACF_HOME) {
  if (stmt->ACF_LIST.Elem->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
  if (stmt->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 689 "MakeHome.puma" */
  {
/* line 691 "MakeHome.puma" */
 stmt->ACF_LIST.Elem->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR = MakeDescriptorVar (home); 
  }
   return stmt;

  }
  }
  }
  }
  if (stmt->Kind == kACF_HOME) {
  if (stmt->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 696 "MakeHome.puma" */
  {
/* line 698 "MakeHome.puma" */
 stmt->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR = MakeDescriptorVar (home); 
  }
   return stmt;

  }
  }
/* line 703 "MakeHome.puma" */
 {
  tTree home_stmt;
  {
/* line 707 "MakeHome.puma" */
   home_stmt = mACF_HOME (mON_VAR_CLAUSE (MakeDescriptorVar (home)), rfalse, MakeStmtList (stmt));
/* line 711 "MakeHome.puma" */
   LineACFNode (home_stmt, GetBodyLine (stmt));
  }
   return home_stmt;
 }

}

static int GetBodyLine
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
 yyRecursion:
/* line 718 "MakeHome.puma" */
  {
/* line 719 "MakeHome.puma" */
   if (! ((stmt == NoTree))) goto yyL1;
  }
   return 0;
yyL1:;

  if (stmt->Kind == kACF_LIST) {
/* line 723 "MakeHome.puma" */
   stmt = stmt->ACF_LIST.Elem;
   goto yyRecursion;

  }
  if (Tree_IsType (stmt, kACF_NODE)) {
/* line 728 "MakeHome.puma" */
   return stmt->ACF_NODE.Line;

  }
  if (stmt->Kind == kACF_EMPTY) {
/* line 733 "MakeHome.puma" */
   return 0;

  }
/* line 737 "MakeHome.puma" */
  {
/* line 738 "MakeHome.puma" */
   failure_protocol (MODULE, "GetBodyLine", stmt);
  }
   return 0;

}

static void MakeHomeTemplate
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar home1, register tTree * yyP2, register tTree * yyP1)
# else
(home, home1, yyP2, yyP1)
 pvar home;
 pvar home1;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 758 "MakeHome.puma" */
 {
  tTree tmp_var;
  tTree allocate;
  tTree deallocate;
  {
/* line 760 "MakeHome.puma" */
   if (! ((IsReplicatedDescriptor (home)))) goto yyL1;
  {
/* line 761 "MakeHome.puma" */
   if (! ((! IsReplicatedDescriptor (home1)))) goto yyL1;
  {
/* line 762 "MakeHome.puma" */
   if (! ((! IsNoDescriptor (home1)))) goto yyL1;
  {
/* line 763 "MakeHome.puma" */
   if (! ((IsTemplateDescriptor (home1)))) goto yyL1;
  {
/* line 765 "MakeHome.puma" */
   if (! ((home1 -> var_tree == NoTree))) goto yyL1;
  {
/* line 773 "MakeHome.puma" */
 

     home1->type_kind = kDUMMY_TYPE;

     FullExpansion (home1);   

     tmp_var = GetVDTemporary (home1);

     

     SetVarDescriptor (tmp_var, home1);

     GetMemoryStmts (&allocate, &deallocate);

     tree_protocol ("template home generated, tmp_var = ", tmp_var);

   
  }
  }
  }
  }
  }
  }
   * yyP2 = allocate;
   * yyP1 = deallocate;
   return;
 }
yyL1:;

/* line 792 "MakeHome.puma" */
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void SetIterationsHome
# if defined __STDC__ | defined __cplusplus
(register tTree loop, pvar iter_home)
# else
(loop, iter_home)
 register tTree loop;
 pvar iter_home;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 810 "MakeHome.puma" */
  {
/* line 812 "MakeHome.puma" */
   if (! ((loop->ACF_DO.DO_HOME_INFO == NoTree))) goto yyL1;
  {
/* line 814 "MakeHome.puma" */
   failure_protocol (MODULE, "SetIterationsHome", NoTree);
  }
  }
   return;
yyL1:;

  if (loop->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
/* line 817 "MakeHome.puma" */
  {
/* line 819 "MakeHome.puma" */
 loop->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var = MakeDescriptorVar (iter_home); 
  }
   return;

  }
  if (loop->ACF_DO.DO_HOME_INFO->Kind == kNO_HOME_INFO) {
/* line 822 "MakeHome.puma" */
 {
  tTree hvar;
  {
/* line 826 "MakeHome.puma" */
 hvar = MakeDescriptorVar (iter_home); 
    loop->ACF_DO.DO_HOME_INFO = mCOMM_INFO (hvar, rfalse);         
  
  }
   return;
 }

  }
  }
/* line 831 "MakeHome.puma" */
  {
/* line 833 "MakeHome.puma" */
   failure_protocol (MODULE, "SetIterationsHome", loop);
  }
   return;

;
}

static void SetSelection
# if defined __STDC__ | defined __cplusplus
(register tTree loop, pvar iter_home)
# else
(loop, iter_home)
 register tTree loop;
 pvar iter_home;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 844 "MakeHome.puma" */
 {
  int dim;
  {
/* line 848 "MakeHome.puma" */
   dim = FindDescriptorDim (iter_home, loop->ACF_DO.DO_ID);
/* line 850 "MakeHome.puma" */
 if (dim > 0)
        loop->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection = iter_home->selections[dim-1];
   
  }
   return;
 }

  }
  }
;
}

static void FindNewHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar cur_home, pvar new_home)
# else
(stmt, cur_home, new_home)
 register tTree stmt;
 pvar cur_home;
 pvar new_home;
# endif
{
/* line 886 "MakeHome.puma" */
 {
  var_descriptor min_home;
  {
/* line 890 "MakeHome.puma" */
   FindHome (stmt, & min_home, new_home);
/* line 892 "MakeHome.puma" */
 if (!VDIsSubSet (&min_home, cur_home))

       { tree_protocol ("illegal home constellation :\n", stmt);
         tree_protocol  ("outer home is : ",
                          PrintableDescriptorVar (cur_home));
         tree_protocol  ("minimal home is : ",
                          PrintableDescriptorVar (&min_home));

         *new_home = *cur_home;
       }

     else

      {
#ifdef DEBUG
        printf ("Determine the final home\n");
        FileUnparse (stdout, stmt);
        printf ("outer home : ");
        FileUnparse (stdout, PrintableDescriptorVar (cur_home));
        printf ("\n");
        printf ("inner home : ");
        FileUnparse (stdout, PrintableDescriptorVar (new_home));
        printf ("\n");
        printf ("min   home : ");
        FileUnparse (stdout, PrintableDescriptorVar (&min_home));
        printf ("\n");
#endif 
        DetermineFinalHome (cur_home, &min_home, new_home);
#ifdef DEBUG
        printf ("final home : ");
        FileUnparse (stdout, PrintableDescriptorVar (new_home));
        printf ("\n");
#endif
        if (!VDIsSubSet (new_home, cur_home))

          { tree_error_protocol ("illegal home constellation :\n", stmt);
            tree_protocol  ("outer home is : ",
                             PrintableDescriptorVar (cur_home));
            tree_protocol  ("new home should be : ",
                             PrintableDescriptorVar (new_home));

            *new_home = *cur_home;
          }

      }
   
  }
   return;
 }

;
}

static void FindSerialHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar cur_home, pvar new_home)
# else
(stmt, cur_home, new_home)
 register tTree stmt;
 pvar cur_home;
 pvar new_home;
# endif
{
/* line 954 "MakeHome.puma" */
  {
/* line 958 "MakeHome.puma" */
   if (! ((! IsNonLocalModel (GetCurrentModel ())))) goto yyL1;
  {
/* line 960 "MakeHome.puma" */
 *new_home = *cur_home; 
  }
  }
   return;
yyL1:;

/* line 963 "MakeHome.puma" */
 {
  rbool done;
  {
/* line 971 "MakeHome.puma" */
   FindNewHomeDescriptor (stmt, cur_home, new_home);
/* line 972 "MakeHome.puma" */
   MakeSerialDescriptor (new_home, & done);
/* line 974 "MakeHome.puma" */
   if (! ((done))) goto yyL2;
  }
   return;
 }
yyL2:;

/* line 977 "MakeHome.puma" */
  {
/* line 979 "MakeHome.puma" */
   set_protocol_stmt (stmt);
/* line 980 "MakeHome.puma" */
   error_protocol ("illegal home for SERIAL or IO routine");
/* line 981 "MakeHome.puma" */
   tree_protocol ("home for stmt is: ", PrintableDescriptorVar (cur_home));
/* line 982 "MakeHome.puma" */
 *new_home = *cur_home; 
  }
   return;

;
}

static void DetermineFinalHome
# if defined __STDC__ | defined __cplusplus
(pvar cur_home, pvar min_home, pvar new_home)
# else
(cur_home, min_home, new_home)
 pvar cur_home;
 pvar min_home;
 pvar new_home;
# endif
{
/* line 1011 "MakeHome.puma" */
  {
/* line 1013 "MakeHome.puma" */
   if (! ((! VDIsSubSet (min_home, new_home)))) goto yyL1;
  {
/* line 1014 "MakeHome.puma" */
 *new_home = *min_home; 
  }
  }
   return;
yyL1:;

/* line 1017 "MakeHome.puma" */
  {
/* line 1019 "MakeHome.puma" */
   if (! ((IsNoDescriptor (new_home)))) goto yyL2;
  {
/* line 1020 "MakeHome.puma" */
 *new_home = *cur_home; 
  }
  }
   return;
yyL2:;

/* line 1023 "MakeHome.puma" */
  {
/* line 1028 "MakeHome.puma" */
   if (! ((IsFullLoopDescriptor (new_home)))) goto yyL3;
  {
/* line 1029 "MakeHome.puma" */
 *new_home = *cur_home; 
  }
  }
   return;
yyL3:;

/* line 1032 "MakeHome.puma" */
  {
/* line 1034 "MakeHome.puma" */
   if (! ((VDIsSubSet (new_home, cur_home)))) goto yyL4;
  {
/* line 1035 "MakeHome.puma" */
   InheritTemplate (cur_home, new_home);
  }
  }
   return;
yyL4:;

/* line 1038 "MakeHome.puma" */
  {
/* line 1040 "MakeHome.puma" */
   if (! ((IsNoDescriptor (min_home)))) goto yyL5;
  {
/* line 1041 "MakeHome.puma" */
   IntersectDescriptor (new_home, cur_home);
/* line 1045 "MakeHome.puma" */
   if (! ((! IsNoDescriptor (new_home)))) goto yyL5;
  }
  }
   return;
yyL5:;

/* line 1048 "MakeHome.puma" */
  {
/* line 1050 "MakeHome.puma" */
 *new_home = *cur_home; 
  }
   return;

;
}

static void InheritTemplate
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar sub_home)
# else
(home, sub_home)
 pvar home;
 pvar sub_home;
# endif
{
/* line 1064 "MakeHome.puma" */
  {
/* line 1066 "MakeHome.puma" */
 if (sub_home->template_obj == NoObject)

      { sub_home->template_obj = home->template_obj;
        sub_home->reach_info   = home->reach_info;
      }
   
  }
   return;

;
}

static void CheckCallHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar final_home)
# else
(t, final_home)
 register tTree t;
 pvar final_home;
# endif
{
 yyRecursion:
  if (t->Kind == kACF_BASIC) {
/* line 1086 "MakeHome.puma" */
  {
/* line 1088 "MakeHome.puma" */
   t = t->ACF_BASIC.BASIC_STMT;
   goto yyRecursion;
  }

  }
  if (t->Kind == kCALL_STMT) {
/* line 1091 "MakeHome.puma" */
  {
/* line 1093 "MakeHome.puma" */
   if (! ((! IsPureCall (t)))) goto yyL2;
  {
/* line 1094 "MakeHome.puma" */
   if (! ((! IsSerialCall (t)))) goto yyL2;
  {
/* line 1095 "MakeHome.puma" */
   if (! ((! IsReplicatedDescriptor (final_home)))) goto yyL2;
  {
/* line 1097 "MakeHome.puma" */
   serious_warning_protocol ("PURE/RESIDENT assumed for subroutine CALL");
  }
  }
  }
  }
   return;
yyL2:;

  }
;
}

void BeginMakeHome ARGS ((void))
{
}

void CloseMakeHome ARGS ((void))
{
}
