# include "MakeForall.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 36 "MakeForall.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# define  MODULE "MakeForall"

# include "Types.h"
# include "Transform.h"    /* CombineACF, ... */

# include "Nesting.h"       
# include "Traverse.h"       

# include "AdaptF77.h"
# include "Intrinsics.h"
# include "Rank.h"
# include "Objects.h"
# include "Reductions.h"   /* IsReduction     */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeForall.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeForall_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeForall, routine %s failed\n",
  yyFunction);
 MakeForall_Exit ();
}

void MakeForall ARGS ((tTree t));
static rbool StopMakeForall ARGS ((tTree t));
static tTree DoMakeForall ARGS ((tTree t));
static tTree MakeAssignForall ARGS ((tTree assign, int rankvar, int rankexp));
static tTree TranslateTypeAssigns ARGS ((tTree stmt));
static rbool IsBasicFunctionCall ARGS ((tTree exp));
static rbool IsEnumExp ARGS ((tTree exp));

void MakeForall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 68 "MakeForall.puma" */
  {
/* line 70 "MakeForall.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeForall, DoMakeForall); 
  }
   return;

  }
/* line 73 "MakeForall.puma" */
  {
/* line 74 "MakeForall.puma" */
   failure_protocol (MODULE, "MakeForall", t);
  }
   return;

;
}

static rbool StopMakeForall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_WHERE) {
/* line 88 "MakeForall.puma" */
   return rtrue;

  }
/* line 93 "MakeForall.puma" */
  {
/* line 94 "MakeForall.puma" */
   return rfalse;
  }

}

static tTree DoMakeForall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 109 "MakeForall.puma" */
   return MakeAssignForall (t, TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP));

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 114 "MakeForall.puma" */
  {
/* line 116 "MakeForall.puma" */
 t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS = F77ArrayItems (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS); 
     t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS = F77TypeItems (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS);
   
  }
   return t;

  }
  }
  if (t->Kind == kACF_WHERE) {
/* line 123 "MakeForall.puma" */
 {
  tTree newacf;
  {
/* line 127 "MakeForall.puma" */
 stmt_protocol ("Make F77 from where statement");
     newacf = F77Where (t);
     tree_protocol ("new loop :\n", newacf);
   
  }
   return newacf;
 }

  }
/* line 134 "MakeForall.puma" */
   return t;

}

static tTree MakeAssignForall
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register int rankvar, register int rankexp)
# else
(assign, rankvar, rankexp)
 register tTree assign;
 register int rankvar;
 register int rankexp;
# endif
{
/* line 146 "MakeForall.puma" */

tTree new;

  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 156 "MakeForall.puma" */
  {
/* line 159 "MakeForall.puma" */
   if (! ((IsIntrCall (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  {
/* line 160 "MakeForall.puma" */
   if (! ((assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("MERGE", 5)))) goto yyL1;
  }
  }
   return F77Merge (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS);
yyL1:;

  }
/* line 172 "MakeForall.puma" */
  {
/* line 174 "MakeForall.puma" */
   if (! ((IsReduction (assign)))) goto yyL2;
  {
/* line 176 "MakeForall.puma" */
 stmt_protocol ("Make F77 from reduction");
     new = F77Reduction (assign->ACF_BASIC.Line, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
     tree_protocol ("new reduction loop :\n", new);
   
  }
  }
   return new;
yyL2:;

/* line 190 "MakeForall.puma" */
  {
/* line 192 "MakeForall.puma" */
   if (! ((IsLocReduction (assign)))) goto yyL3;
  {
/* line 194 "MakeForall.puma" */
 stmt_protocol ("Make F77 from loc reduction");
     new = F77LocReduction (assign->ACF_BASIC.Line, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
     tree_protocol ("new loc reduction loop :\n", new);
   
  }
  }
   return new;
yyL3:;

  if (equalint (rankvar, 0)) {
  if (equalint (rankexp, 0)) {
/* line 208 "MakeForall.puma" */
   return TranslateTypeAssigns (assign);

  }
  }
  if (equalint (rankexp, 0)) {
/* line 219 "MakeForall.puma" */
  {
/* line 221 "MakeForall.puma" */
 stmt_protocol ("Make F77 from array = scalar");
     new = F77Assign (assign);
     tree_protocol ("new loops :\n", new);
   
  }
   return TranslateTypeAssigns (new);

  }
  if (equalint (rankvar, 1)) {
  if (equalint (rankexp, 1)) {
/* line 235 "MakeForall.puma" */
  {
/* line 237 "MakeForall.puma" */
   if (! ((IsEnumExp (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL6;
  {
/* line 239 "MakeForall.puma" */
 stmt_protocol ("Make F77 from array = [...]");
     new = F77ManyAssign (assign); 
     tree_protocol ("new assignments :\n", new);
   
  }
  }
   return TranslateTypeAssigns (new);
yyL6:;

  }
  }
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 255 "MakeForall.puma" */
  {
/* line 257 "MakeForall.puma" */
   if (! ((! IsBasicFunctionCall (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL7;
  }
   return assign;
yyL7:;

  }
/* line 268 "MakeForall.puma" */
  {
/* line 270 "MakeForall.puma" */
   if (! ((rankvar == rankexp))) goto yyL8;
  {
/* line 272 "MakeForall.puma" */
 stmt_protocol ("Make F77 from array = array_exp");
     new = F77Assign (assign);
     tree_protocol ("new loops :\n", new);
   
  }
  }
   return TranslateTypeAssigns (new);
yyL8:;

  }
  }
/* line 280 "MakeForall.puma" */
  {
/* line 282 "MakeForall.puma" */
   if (! ((rankvar != rankexp))) goto yyL9;
  {
/* line 284 "MakeForall.puma" */
   error_protocol ("MakeAssignForall: illegal statement (rank!)");
  }
  }
   return assign;
yyL9:;

 yyAbort ("MakeAssignForall");
 { tTree yyDummy; return yyDummy; }
}

static tTree TranslateTypeAssigns
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
/* line 306 "MakeForall.puma" */
  {
/* line 308 "MakeForall.puma" */
   if (! ((stmt == NoTree))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 313 "MakeForall.puma" */
 {
  tTree new;
  {
/* line 315 "MakeForall.puma" */
   if (! ((IsDerivedType (TreeType (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR))))) goto yyL2;
  {
/* line 319 "MakeForall.puma" */
 stmt_protocol ("Make F77 from type_var1 = ...");
     new = F77TypeAssign (stmt);
     tree_protocol ("new stmts :\n", new);

     

     new = ReplaceAST (new, StopMakeForall, DoMakeForall); 

     tree_protocol ("new stmts (after recursion 1) :\n", new);

     new = ReplaceAST (new, StopMakeForall, DoMakeForall); 

     tree_protocol ("new stmts (after recursion 1) :\n", new);

   
  }
  }
   return new;
 }
yyL2:;

  }
/* line 338 "MakeForall.puma" */
   return stmt;

  }
  if (stmt->Kind == kACF_LIST) {
/* line 343 "MakeForall.puma" */
   return CombineACF (TranslateTypeAssigns (stmt->ACF_LIST.Elem), TranslateTypeAssigns (stmt->ACF_LIST.Next));

  }
  if (stmt->Kind == kACF_EMPTY) {
/* line 349 "MakeForall.puma" */
   return stmt;

  }
  if (stmt->Kind == kACF_DO) {
/* line 354 "MakeForall.puma" */
  {
/* line 356 "MakeForall.puma" */
 stmt->ACF_DO.DO_BODY = TranslateTypeAssigns (stmt->ACF_DO.DO_BODY); 
  }
   return stmt;

  }
  if (stmt->Kind == kACF_FORALL) {
/* line 361 "MakeForall.puma" */
  {
/* line 363 "MakeForall.puma" */
 stmt->ACF_FORALL.FORALL_BODY = TranslateTypeAssigns (stmt->ACF_FORALL.FORALL_BODY); 
  }
   return stmt;

  }
/* line 368 "MakeForall.puma" */
  {
/* line 370 "MakeForall.puma" */
   failure_protocol (MODULE, "TranslateTypeAssigns", stmt);
  }
   return NoTree;

}

static rbool IsBasicFunctionCall
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
/* line 385 "MakeForall.puma" */
  {
/* line 387 "MakeForall.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL1;
  {
/* line 388 "MakeForall.puma" */
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 391 "MakeForall.puma" */
  {
/* line 393 "MakeForall.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL2;
  {
/* line 394 "MakeForall.puma" */
   if (! ((MakeIdent ("SPREAD", 6) == exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 397 "MakeForall.puma" */
  {
/* line 399 "MakeForall.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL3;
  {
/* line 400 "MakeForall.puma" */
   if (! ((MakeIdent ("TRANSPOSE", 9) == exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static rbool IsEnumExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kARRAY_EXP) {
/* line 411 "MakeForall.puma" */
  {
/* line 412 "MakeForall.puma" */
   if (! ((IsEnumExp (exp->ARRAY_EXP.ELEMENTS)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (exp->Kind == kBTE_LIST) {
/* line 415 "MakeForall.puma" */
  {
/* line 416 "MakeForall.puma" */
   if (! ((TreeRank (exp->BTE_LIST.Elem) == 0))) goto yyL2;
  {
/* line 417 "MakeForall.puma" */
   if (! ((IsEnumExp (exp->BTE_LIST.Next)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  if (exp->Kind == kBTE_EMPTY) {
/* line 420 "MakeForall.puma" */
   return rtrue;

  }
  return rfalse;
}

void BeginMakeForall ARGS ((void))
{
}

void CloseMakeForall ARGS ((void))
{
}
