# include "MakeDefs.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 43 "MakeDefs.puma" */


# include <string.h>

# include "Idents.h"
# include "StringM.h"
# include "TreeOps.h"

# include "protocol.h"

# include "DefTable.h"       /* Operations for definition table      */
# include "Transform.h"      /*  */

# include "ImplDefs.h"       /* implicit definitions / global atts   */

# include "NormalDefs.h"     /* Normal1Definitions, Normal2Definitions   */

# include "UnitDefs.h"

# include "ChangeDefs.h"     /* MakeObjType, ..., MakeObjSave, MakeObjExternal,
                                StatementFunctions                   */

# include "SetDefs.h"        /* MakeVarDefs, MakeACFDefs, CheckExp, 
                                MakeIndexDefs                        */

# include "MapDefs.h"        /* SetDistributions, SetAlignments    */

# include "Nesting.h" 

# include "Types.h"          /* GetBaseType   */

# include "Objects.h"        /* MakeNewObject */

# include "Modules.h"        /* GetModule     */

# define MODULE "MakeDefs"

    /*****************************************************
    *                                                    *
    *    Global Variables in Making Definitions          *
    *                                                    *
    *    ProgramCounter : counts PROGRAM_DECL            *
    *                                                    *
    *****************************************************/

int ProgramCounter;     /* counter for MAIN programs */

static rbool is_type_scope = rfalse;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeDefs.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeDefs_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeDefs, routine %s failed\n",
  yyFunction);
 MakeDefs_Exit ();
}

void MakeDefs ARGS ((tTree t));
void MakeUnitDefs ARGS ((tTree t));
static void MakeModuleDefs ARGS ((tTree t, tDefinitions obj));
static void MakeInternalDefs ARGS ((tTree internals));
static void MakeDefFunction ARGS ((tTree f));
static void MoveResultType ARGS ((tTree f));
static void MakeResultDef ARGS ((tTree f, tDefinitions f_obj));
static void SetFuncResultType ARGS ((tTree f));
static tTree GetDummyType ARGS ((tDefinitions obj, tTree default_type));
static tIdent MakeResultId ARGS ((tIdent id));
static rbool IsThisFunction ARGS ((tDefinitions obj, tIdent * yyP1));
static void MakeDummyDefinitions ARGS ((tTree t, tDefinitions unit));
static void MakeDECLDefs ARGS ((tTree t, tDefinitions unit));
static void MakeTYPEDefs ARGS ((tTree t));
static void InsertUseEntry ARGS ((tDefinitions obj));
static void MakeTypeScope ARGS ((tDefinitions tobj, tTree decl));
static void MakeCommons ARGS ((tTree t, tTree CommonDecl));
static void MakeInterfaceDefs ARGS ((tTree t));
static void EmptyBody ARGS ((tTree b));
static tDefinitions ReverseEntryList ARGS ((tDefinitions list, tDefinitions newlist));
static void SetExtrinsicId ARGS ((tTree unit));
static tIdent GetCurrentExtrinsic ARGS ((void));

void MakeDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kCOMP_UNIT) {
/* line 108 "MakeDefs.puma" */
  {
/* line 110 "MakeDefs.puma" */
   BeginDefTable ();
/* line 111 "MakeDefs.puma" */
   ProgramCounter = 0;
/* line 112 "MakeDefs.puma" */
   InitImplicitTable ();
/* line 113 "MakeDefs.puma" */
   DeclareUnits (t->COMP_UNIT.COMP_ELEMENTS, NoObject);
/* line 114 "MakeDefs.puma" */
   MakeDefs (t->COMP_UNIT.COMP_ELEMENTS);
/* line 115 "MakeDefs.puma" */
   CloseDefTable ();
  }
   return;

  }
  if (t->Kind == kUNIT_EMPTY) {
/* line 118 "MakeDefs.puma" */
   return;

  }
  if (t->Kind == kUNIT_LIST) {
/* line 121 "MakeDefs.puma" */
  {
/* line 122 "MakeDefs.puma" */
   MakeUnitDefs (t->UNIT_LIST.Elem);
/* line 123 "MakeDefs.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 126 "MakeDefs.puma" */
  {
/* line 127 "MakeDefs.puma" */
   failure_protocol (MODULE, "MakeDefs", t);
  }
   return;

;
}

void MakeUnitDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kUNIT_NODE)) {
/* line 140 "MakeDefs.puma" */
  {
/* line 142 "MakeDefs.puma" */
   if (! ((t->UNIT_NODE.Object == NoObject))) goto yyL1;
  {
/* line 144 "MakeDefs.puma" */
   error_protocol ("cannot make definitions in this unit");
  }
  }
   return;
yyL1:;

  }
  if (t->Kind == kPROGRAM_DECL) {
/* line 147 "MakeDefs.puma" */
  {
/* line 149 "MakeDefs.puma" */
   NestOpenUnit (t);
/* line 150 "MakeDefs.puma" */
   MakeDummyDefinitions (t->PROGRAM_DECL.FORMALS, GetCurrentUnitObject ());
/* line 151 "MakeDefs.puma" */
   MakeUnitDefs (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 152 "MakeDefs.puma" */
   NestCloseUnit (t);
  }
   return;

  }
  if (t->Kind == kPROC_DECL) {
/* line 155 "MakeDefs.puma" */
  {
/* line 157 "MakeDefs.puma" */
   NestOpenUnit (t);
/* line 158 "MakeDefs.puma" */
   SetExtrinsicId (t);
/* line 159 "MakeDefs.puma" */
   MakeDummyDefinitions (t->PROC_DECL.FORMALS, GetCurrentUnitObject ());
/* line 160 "MakeDefs.puma" */
   MakeUnitDefs (t->PROC_DECL.PROC_BODY);
/* line 161 "MakeDefs.puma" */
   NestCloseUnit (t);
  }
   return;

  }
  if (t->Kind == kFUNC_DECL) {
/* line 164 "MakeDefs.puma" */
  {
/* line 166 "MakeDefs.puma" */
   MakeDefFunction (t);
  }
   return;

  }
  if (t->Kind == kBLOCK_DATA_DECL) {
/* line 169 "MakeDefs.puma" */
  {
/* line 171 "MakeDefs.puma" */
   NestOpenUnit (t);
/* line 172 "MakeDefs.puma" */
   MakeUnitDefs (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 173 "MakeDefs.puma" */
   NestCloseUnit (t);
  }
   return;

  }
  if (t->Kind == kMODULE_DECL) {
/* line 176 "MakeDefs.puma" */
  {
/* line 178 "MakeDefs.puma" */
   NestOpenUnit (t);
/* line 180 "MakeDefs.puma" */
   MakeModuleDefs (t, GetCurrentUnitObject ());
/* line 182 "MakeDefs.puma" */
   NestCloseUnit (t);
  }
   return;

  }
  if (t->Kind == kBODY_NODE) {
/* line 185 "MakeDefs.puma" */
  {
/* line 187 "MakeDefs.puma" */
   DeclareUnits (t->BODY_NODE.INTERNALS, GetCurrentUnitObject ());
/* line 189 "MakeDefs.puma" */
   PushImplicitTable ();
/* line 191 "MakeDefs.puma" */
 t->BODY_NODE.DECLS = Normal1Definitions (t->BODY_NODE.DECLS); 
/* line 192 "MakeDefs.puma" */
   MakeDECLDefs (t->BODY_NODE.DECLS, GetCurrentUnitObject ());
/* line 193 "MakeDefs.puma" */
 t->BODY_NODE.DECLS = Normal2Definitions (t->BODY_NODE.DECLS); 
/* line 194 "MakeDefs.puma" */
   SetDistributions (t->BODY_NODE.DECLS, GetCurrentUnitObject ());
/* line 195 "MakeDefs.puma" */
   SetAlignments (t->BODY_NODE.DECLS, GetCurrentUnitObject ());
/* line 196 "MakeDefs.puma" */
   StatementFunctions (t);
/* line 198 "MakeDefs.puma" */
   MakeACFDefs (t->BODY_NODE.STATS);
/* line 199 "MakeDefs.puma" */
   MakeInternalDefs (t->BODY_NODE.INTERNALS);
/* line 203 "MakeDefs.puma" */
   CheckImplicitDecls (GetCurrentScope ());
/* line 205 "MakeDefs.puma" */
   PopImplicitTable ();
  }
   return;

  }
/* line 208 "MakeDefs.puma" */
  {
/* line 209 "MakeDefs.puma" */
   failure_protocol (MODULE, "MakeUnitDefs", t);
  }
   return;

;
}

static void MakeModuleDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kMODULE_DECL) {
  if (obj->Kind == kModuleObject) {
/* line 222 "MakeDefs.puma" */
  {
/* line 224 "MakeDefs.puma" */
   if (! ((obj->ModuleObject.uses == 0))) goto yyL1;
  {
/* line 226 "MakeDefs.puma" */
   obj->ModuleObject.uses = 1;
/* line 228 "MakeDefs.puma" */
   MakeUnitDefs (t->MODULE_DECL.MODULE_BODY);
/* line 230 "MakeDefs.puma" */
   obj->ModuleObject.uses = 2;
  }
  }
   return;
yyL1:;

/* line 233 "MakeDefs.puma" */
  {
/* line 235 "MakeDefs.puma" */
   if (! ((obj->ModuleObject.uses == 2))) goto yyL2;
  }
   return;
yyL2:;

/* line 238 "MakeDefs.puma" */
  {
/* line 240 "MakeDefs.puma" */
   if (! ((obj->ModuleObject.uses == 1))) goto yyL3;
  {
/* line 242 "MakeDefs.puma" */
   error_protocol ("module is used (in)directly by itself");
  }
  }
   return;
yyL3:;

  }
  }
;
}

static void MakeInternalDefs
# if defined __STDC__ | defined __cplusplus
(register tTree internals)
# else
(internals)
 register tTree internals;
# endif
{
 yyRecursion:
  if (internals->Kind == kUNIT_LIST) {
/* line 253 "MakeDefs.puma" */
  {
/* line 255 "MakeDefs.puma" */
   set_protocol_stmt (internals->UNIT_LIST.Elem);
/* line 257 "MakeDefs.puma" */
   MakeInternalDefs (internals->UNIT_LIST.Elem);
/* line 258 "MakeDefs.puma" */
   internals = internals->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
  if (internals->Kind == kUNIT_EMPTY) {
/* line 261 "MakeDefs.puma" */
   return;

  }
  if (internals->Kind == kPROC_DECL) {
/* line 264 "MakeDefs.puma" */
  {
/* line 266 "MakeDefs.puma" */
   MakeUnitDefs (internals);
  }
   return;

  }
  if (internals->Kind == kFUNC_DECL) {
/* line 269 "MakeDefs.puma" */
  {
/* line 271 "MakeDefs.puma" */
   MakeUnitDefs (internals);
  }
   return;

  }
/* line 274 "MakeDefs.puma" */
  {
/* line 275 "MakeDefs.puma" */
   error_protocol ("no subroutine/function in CONTAINS");
  }
   return;

;
}

static void MakeDefFunction
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kFUNC_DECL) {
/* line 294 "MakeDefs.puma" */
 {
  tDefinitions f_obj;
  {
/* line 296 "MakeDefs.puma" */
   NestOpenUnit (f);
/* line 298 "MakeDefs.puma" */
   SetExtrinsicId (f);
/* line 302 "MakeDefs.puma" */
   f_obj = GetCurrentUnitObject ();
/* line 306 "MakeDefs.puma" */
   InsertEntry (f_obj);
/* line 310 "MakeDefs.puma" */
   MoveResultType (f);
/* line 314 "MakeDefs.puma" */
   MakeDummyDefinitions (f->FUNC_DECL.FORMALS, f_obj);
/* line 318 "MakeDefs.puma" */
   MakeResultDef (f, f_obj);
/* line 320 "MakeDefs.puma" */
   f_obj->FuncObject.Declarations = GetCurrentScope ();
/* line 322 "MakeDefs.puma" */
   MakeUnitDefs (f->FUNC_DECL.FUNC_BODY);
/* line 328 "MakeDefs.puma" */
   NestCloseUnit (f);
  }
   return;
 }

  }
;
}

static void MoveResultType
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kFUNC_DECL) {
  if (f->FUNC_DECL.RESULT_TYPE->Kind == kDUMMY_TYPE) {
/* line 344 "MakeDefs.puma" */
   return;

  }
/* line 347 "MakeDefs.puma" */
 {
  tTree new;
  {
/* line 352 "MakeDefs.puma" */
 new = mVAR_DECL (f->FUNC_DECL.Ident, f->FUNC_DECL.Line, f->FUNC_DECL.RESULT_TYPE);
     new = mDECL_LIST (new, mDECL_EMPTY ());
     f->FUNC_DECL.FUNC_BODY->BODY_NODE.DECLS = AppendDECLS (f->FUNC_DECL.FUNC_BODY->BODY_NODE.DECLS, new);
     f->FUNC_DECL.RESULT_TYPE = mDUMMY_TYPE ();
   
  }
   return;
 }

  }
/* line 359 "MakeDefs.puma" */
  {
/* line 361 "MakeDefs.puma" */
   failure_protocol (MODULE, "MoveResultType", f);
  }
   return;

;
}

static void MakeResultDef
# if defined __STDC__ | defined __cplusplus
(register tTree f, register tDefinitions f_obj)
# else
(f, f_obj)
 register tTree f;
 register tDefinitions f_obj;
# endif
{
 yyRecursion:
  if (f->Kind == kFUNC_DECL) {
/* line 377 "MakeDefs.puma" */
  {
/* line 379 "MakeDefs.puma" */
   if (! ((f->FUNC_DECL.RESULT_ID == DefaultId ()))) goto yyL1;
  {
/* line 383 "MakeDefs.puma" */
   f->FUNC_DECL.RESULT_ID = MakeResultId (f->FUNC_DECL.Ident);
/* line 385 "MakeDefs.puma" */
   goto yyRecursion;
  }
  }
yyL1:;

/* line 388 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 392 "MakeDefs.puma" */
   Obj = GetLocalObject (f->FUNC_DECL.RESULT_ID);
/* line 394 "MakeDefs.puma" */
 if (Obj == NoObject)

       { Obj = MakeResultObject (f, f_obj);

         obj_protocol ("dummy result is", Obj);

         InsertEntry (Obj);
       }

      else

        tree_error_protocol ("result id already used: ", f);
   
  }
   return;
 }

  }
/* line 409 "MakeDefs.puma" */
  {
/* line 411 "MakeDefs.puma" */
   failure_protocol (MODULE, "MakeResultDef", f);
  }
   return;

;
}

static void SetFuncResultType
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kFUNC_DECL) {
/* line 425 "MakeDefs.puma" */
  {
/* line 427 "MakeDefs.puma" */
 f->FUNC_DECL.RESULT_TYPE = GetDummyType (GetLocalObject (f->FUNC_DECL.RESULT_ID), f->FUNC_DECL.RESULT_TYPE); 
  }
   return;

  }
/* line 430 "MakeDefs.puma" */
  {
/* line 431 "MakeDefs.puma" */
   failure_protocol (MODULE, "SetFuncResultType", f);
  }
   return;

;
}

static tTree GetDummyType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree default_type)
# else
(obj, default_type)
 register tDefinitions obj;
 register tTree default_type;
# endif
{
/* line 442 "MakeDefs.puma" */
  {
/* line 444 "MakeDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return default_type;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 448 "MakeDefs.puma" */
   return GetBaseType (obj->VarObject.decl->VAR_PARAM_DECL.VAL);

  }
  }
 yyAbort ("GetDummyType");
 { tTree yyDummy; return yyDummy; }
}

static tIdent MakeResultId
# if defined __STDC__ | defined __cplusplus
(register tIdent id)
# else
(id)
 register tIdent id;
# endif
{
/* line 455 "MakeDefs.puma" */

char name [100];

/* line 459 "MakeDefs.puma" */
  {
/* line 461 "MakeDefs.puma" */
   GetString (id, name);
/* line 462 "MakeDefs.puma" */
   strcat (name, "_RESULT");
  }
   return MakeIdent (name, strlen (name));

}

static rbool IsThisFunction
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tIdent * yyP1)
# else
(obj, yyP1)
 register tDefinitions obj;
 register tIdent * yyP1;
# endif
{
/* line 476 "MakeDefs.puma" */
  {
/* line 477 "MakeDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 478 "MakeDefs.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 481 "MakeDefs.puma" */
  {
/* line 484 "MakeDefs.puma" */
   if (! ((obj->FuncObject.decl->FUNC_DECL.RESULT_ID != DefaultId ()))) goto yyL2;
  {
/* line 485 "MakeDefs.puma" */
   if (! ((GetLocalObject (obj->FuncObject.decl->FUNC_DECL.RESULT_ID) == GetDeclEntry (obj->FuncObject.decl->FUNC_DECL.RESULT_ID, obj->FuncObject.Declarations)))) goto yyL2;
  }
  }
   * yyP1 = obj->FuncObject.decl->FUNC_DECL.RESULT_ID;
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

static void MakeDummyDefinitions
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions unit)
# else
(t, unit)
 register tTree t;
 register tDefinitions unit;
# endif
{
 yyRecursion:
  if (t->Kind == kDECL_LIST) {
/* line 498 "MakeDefs.puma" */
  {
/* line 500 "MakeDefs.puma" */
   set_protocol_stmt (t->DECL_LIST.Elem);
/* line 501 "MakeDefs.puma" */
   MakeDummyDefinitions (t->DECL_LIST.Elem, unit);
/* line 502 "MakeDefs.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kVAR_PARAM_DECL) {
/* line 505 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 507 "MakeDefs.puma" */
   MakeTYPEDefs (t->VAR_PARAM_DECL.VAL);
/* line 510 "MakeDefs.puma" */
   Obj = GetLocalObject (t->VAR_PARAM_DECL.Ident);
/* line 512 "MakeDefs.puma" */
 if (Obj == NoObject)

       { Obj = MakeNewObject (t, unit);
         InsertEntry (Obj); 
       }

      else 

        error_protocol ("dummy argument declared twice: ");
   
  }
   return;
 }

  }
  if (t->Kind == kRET_PARAM_DECL) {
/* line 524 "MakeDefs.puma" */
  {
/* line 526 "MakeDefs.puma" */
   error_protocol ("dummy return parameters not handled");
  }
   return;

  }
;
}

static void MakeDECLDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions unit)
# else
(t, unit)
 register tTree t;
 register tDefinitions unit;
# endif
{
 yyRecursion:
  if (t->Kind == kDECL_LIST) {
/* line 541 "MakeDefs.puma" */
  {
/* line 543 "MakeDefs.puma" */
   set_protocol_stmt (t->DECL_LIST.Elem);
/* line 544 "MakeDefs.puma" */
   MakeDECLDefs (t->DECL_LIST.Elem, unit);
/* line 545 "MakeDefs.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kDECL_EMPTY) {
/* line 548 "MakeDefs.puma" */
   return;

  }
  if (Tree_IsType (t, kDECL_NODE)) {
/* line 557 "MakeDefs.puma" */
 {
  tIdent yyV1;
  {
/* line 559 "MakeDefs.puma" */
   if (! ((IsThisFunction (GetLocalObject (t->DECL_NODE.Ident), & yyV1)))) goto yyL3;
  {
/* line 560 "MakeDefs.puma" */
   t->DECL_NODE.Ident = yyV1;
/* line 561 "MakeDefs.puma" */
   goto yyL3;
  }
  }
 }
yyL3:;

  }

  switch (t->Kind) {
  case kVAR_DECL:
/* line 572 "MakeDefs.puma" */
  {
/* line 574 "MakeDefs.puma" */
   MakeTYPEDefs (t->VAR_DECL.VAL);
/* line 576 "MakeDefs.puma" */
   MakeObjType (t->VAR_DECL.VAL, GetLocalVarEntity (t->VAR_DECL.Ident, t->VAR_DECL.Line, unit));
  }
   return;

  case kDIMENSION_DECL:
/* line 587 "MakeDefs.puma" */
  {
/* line 589 "MakeDefs.puma" */
   MakeTYPEDefs (t->DIMENSION_DECL.INDEXES);
/* line 591 "MakeDefs.puma" */
   MakeObjDimension (t->DIMENSION_DECL.INDEXES, GetLocalVarEntity (t->DIMENSION_DECL.Ident, t->DIMENSION_DECL.Line, unit));
  }
   return;

  case kSAVE_DECL:
  if (unit->Kind == kTypeObject) {
/* line 602 "MakeDefs.puma" */
   return;

  }
/* line 605 "MakeDefs.puma" */
  {
/* line 607 "MakeDefs.puma" */
   if (! ((t->SAVE_DECL.Ident == DefaultId ()))) goto yyL7;
  {
/* line 609 "MakeDefs.puma" */
 if (global_save_attribute)
       error_protocol ("only one single SAVE stmt is allowed");
     global_save_attribute = rtrue;
   
  }
  }
   return;
yyL7:;

/* line 615 "MakeDefs.puma" */
  {
/* line 617 "MakeDefs.puma" */
   MakeObjSave (GetLocalVarEntity (t->SAVE_DECL.Ident, t->SAVE_DECL.Line, unit));
  }
   return;

  case kHPF_SEQUENCE_DECL:
/* line 626 "MakeDefs.puma" */
  {
/* line 628 "MakeDefs.puma" */
   if (! ((t->HPF_SEQUENCE_DECL.Ident == DefaultId ()))) goto yyL9;
  {
/* line 630 "MakeDefs.puma" */
 if (global_sequence_attribute || global_nosequence_attribute)
       error_protocol ("only one single SEQUENCE/NOSEQUENCE stmt is allowed");
     global_sequence_attribute = rtrue;
   
  }
  }
   return;
yyL9:;

/* line 636 "MakeDefs.puma" */
  {
/* line 638 "MakeDefs.puma" */
   MakeObjSequential (GetLocalVarEntity (t->HPF_SEQUENCE_DECL.Ident, t->HPF_SEQUENCE_DECL.Line, unit));
  }
   return;

  case kNOSEQUENCE_DECL:
/* line 647 "MakeDefs.puma" */
  {
/* line 649 "MakeDefs.puma" */
   if (! ((t->NOSEQUENCE_DECL.Ident == DefaultId ()))) goto yyL11;
  {
/* line 651 "MakeDefs.puma" */
 if (global_sequence_attribute || global_nosequence_attribute)
       error_protocol ("only one single SEQUENCE/NOSEQUENCE stmt is allowed");
     global_nosequence_attribute = rtrue;
   
  }
  }
   return;
yyL11:;

/* line 657 "MakeDefs.puma" */
  {
/* line 659 "MakeDefs.puma" */
   MakeObjNoSequential (GetLocalVarEntity (t->NOSEQUENCE_DECL.Ident, t->NOSEQUENCE_DECL.Line, unit));
  }
   return;

  case kINTRINSIC_DECL:
/* line 668 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 672 "MakeDefs.puma" */
   Obj = GetIntrinsicObject (t->INTRINSIC_DECL.Ident);
/* line 674 "MakeDefs.puma" */
 if (Obj == NoObject)
       error_protocol ("INTRINSIC is unknown");
      else
       InsertEntry (Obj);  
   
  }
   return;
 }

  case kINTENT_DECL:
/* line 687 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 691 "MakeDefs.puma" */
   Obj = GetLocalObject (t->INTENT_DECL.Ident);
/* line 693 "MakeDefs.puma" */
 if (Obj == NoObject)
        error_protocol ("no dummy argument with this name");
      else 
        MakeObjIntent (Obj, t->INTENT_DECL.intent);
   
  }
   return;
 }

  case kOPTIONAL_DECL:
/* line 706 "MakeDefs.puma" */
  {
/* line 708 "MakeDefs.puma" */
   MakeObjOptional (GetLocalVarEntity (t->OPTIONAL_DECL.Ident, t->OPTIONAL_DECL.Line, unit));
  }
   return;

  case kALLOCATABLE_DECL:
/* line 717 "MakeDefs.puma" */
  {
/* line 719 "MakeDefs.puma" */
   MakeObjAllocatable (GetLocalVarEntity (t->ALLOCATABLE_DECL.Ident, t->ALLOCATABLE_DECL.Line, unit));
  }
   return;

  case kPOINTER_DECL:
/* line 728 "MakeDefs.puma" */
  {
/* line 730 "MakeDefs.puma" */
   MakeObjPointer (GetLocalVarEntity (t->POINTER_DECL.Ident, t->POINTER_DECL.Line, unit));
  }
   return;

  case kTARGET_DECL:
/* line 739 "MakeDefs.puma" */
  {
/* line 741 "MakeDefs.puma" */
   MakeObjTarget (GetLocalVarEntity (t->TARGET_DECL.Ident, t->TARGET_DECL.Line, unit));
  }
   return;

  case kPUBLIC_DECL:
  if (unit->Kind == kTypeObject) {
/* line 750 "MakeDefs.puma" */
  {
/* line 752 "MakeDefs.puma" */
   if (! ((t->PUBLIC_DECL.Ident == DefaultId ()))) goto yyL19;
  }
   return;
yyL19:;

  }
/* line 755 "MakeDefs.puma" */
  {
/* line 757 "MakeDefs.puma" */
   if (! ((t->PUBLIC_DECL.Ident == DefaultId ()))) goto yyL20;
  {
/* line 759 "MakeDefs.puma" */
 if (global_public_attribute || global_private_attribute)
       error_protocol ("only one single PUBLIC or PRIVATE stmt is allowed");
     global_public_attribute = rtrue;
   
  }
  }
   return;
yyL20:;

/* line 765 "MakeDefs.puma" */
  {
/* line 767 "MakeDefs.puma" */
   MakeObjPublic (GetLocalVarEntity (t->PUBLIC_DECL.Ident, t->PUBLIC_DECL.Line, unit));
  }
   return;

  case kPRIVATE_DECL:
  if (unit->Kind == kTypeObject) {
/* line 776 "MakeDefs.puma" */
  {
/* line 778 "MakeDefs.puma" */
   if (! ((t->PRIVATE_DECL.Ident == DefaultId ()))) goto yyL22;
  }
   return;
yyL22:;

  }
/* line 781 "MakeDefs.puma" */
  {
/* line 783 "MakeDefs.puma" */
   if (! ((t->PRIVATE_DECL.Ident == DefaultId ()))) goto yyL23;
  {
/* line 785 "MakeDefs.puma" */
 if (global_public_attribute || global_private_attribute)
       error_protocol ("only one single PUBLIC or PRIVATE stmt is allowed");
     global_private_attribute = rtrue;
   
  }
  }
   return;
yyL23:;

/* line 791 "MakeDefs.puma" */
  {
/* line 793 "MakeDefs.puma" */
   MakeObjPrivate (GetLocalVarEntity (t->PRIVATE_DECL.Ident, t->PRIVATE_DECL.Line, unit));
  }
   return;

  case kSEQUENCE_DECL:
  if (unit->Kind == kTypeObject) {
/* line 802 "MakeDefs.puma" */
   return;

  }
/* line 807 "MakeDefs.puma" */
  {
/* line 809 "MakeDefs.puma" */
   error_protocol ("SEQUENCE statement only in derived types allowed");
  }
   return;

  case kLAYOUT_DECL:
/* line 818 "MakeDefs.puma" */
  {
/* line 820 "MakeDefs.puma" */
   MakeObjLayout (t->LAYOUT_DECL.kind, GetLocalVarEntity (t->LAYOUT_DECL.Ident, t->LAYOUT_DECL.Line, unit));
  }
   return;

  case kPASS_BY_DECL:
/* line 829 "MakeDefs.puma" */
  {
/* line 831 "MakeDefs.puma" */
   MakeObjPassBy (t->PASS_BY_DECL.kind, GetLocalVarEntity (t->PASS_BY_DECL.Ident, t->PASS_BY_DECL.Line, unit));
  }
   return;

  case kMAP_TO_DECL:
/* line 840 "MakeDefs.puma" */
  {
/* line 842 "MakeDefs.puma" */
   MakeObjMapTo (t->MAP_TO_DECL.kind, GetLocalVarEntity (t->MAP_TO_DECL.Ident, t->MAP_TO_DECL.Line, unit));
  }
   return;

  case kTYPE_DECL:
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
/* line 853 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 857 "MakeDefs.puma" */
 
     
     Obj = GetLocalObject (t->TYPE_DECL.Ident);

     if (Obj == NoObject)

       { Obj = MakeNewObject (t, unit);

         InsertEntry (Obj);   
       }

   
/* line 870 "MakeDefs.puma" */
   MakeTypeScope (Obj, t);
  }
   return;
 }

  }
  break;
  case kTEMPLATE_DECL:
/* line 881 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 885 "MakeDefs.puma" */
   MakeTYPEDefs (t->TEMPLATE_DECL.DIMENSIONS);
/* line 887 "MakeDefs.puma" */
   Obj = GetLocalObject (t->TEMPLATE_DECL.Ident);
/* line 889 "MakeDefs.puma" */
 if (IsTypeObj (unit))

        error_protocol ("TEMPLATE not allowed in derived types");

     if (Obj == NoObject)

        { Obj = MakeNewObject (t, unit);
          InsertEntry (Obj);
        }

      else 

        { 
          MakeObjDimension (t->TEMPLATE_DECL.DIMENSIONS, Obj);
        }
   
  }
   return;
 }

  case kPROCESSORS_DECL:
/* line 915 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 919 "MakeDefs.puma" */
   MakeTYPEDefs (t->PROCESSORS_DECL.DIMENSIONS);
/* line 921 "MakeDefs.puma" */
 if (!IsExplicitShape (t->PROCESSORS_DECL.DIMENSIONS))
        error_protocol ("PROCESSORS : shape must be explicit");
   
/* line 925 "MakeDefs.puma" */
   Obj = GetLocalObject (t->PROCESSORS_DECL.Ident);
/* line 927 "MakeDefs.puma" */
 if (IsTypeObj (unit))

        error_protocol ("PROCESSORS directive not allowed in derived types");

     

     if (Obj == NoObject)

        { Obj = MakeNewObject (t, unit);
          InsertEntry (Obj);
        }

      else 

        { 
          MakeObjDimension (t->PROCESSORS_DECL.DIMENSIONS, Obj);
        }
   
  }
   return;
 }

  case kSHADOW_DECL:
/* line 958 "MakeDefs.puma" */
   return;

  case kFORMAT_DECL:
/* line 969 "MakeDefs.puma" */
   return;

  case kSHARED_DECL:
/* line 974 "MakeDefs.puma" */
  {
/* line 976 "MakeDefs.puma" */
   MakeObjShared (GetLocalVarEntity (t->SHARED_DECL.Ident, t->SHARED_DECL.Line, unit), t->SHARED_DECL.kind);
  }
   return;

  case kALIGN_DECL:
/* line 979 "MakeDefs.puma" */
   return;

  case kDYNAMIC_DECL:
/* line 984 "MakeDefs.puma" */
  {
/* line 986 "MakeDefs.puma" */
   MakeObjDynamic (GetLocalVarEntity (t->DYNAMIC_DECL.Ident, t->DYNAMIC_DECL.Line, unit));
  }
   return;

  case kTRACE_DECL:
/* line 989 "MakeDefs.puma" */
  {
/* line 991 "MakeDefs.puma" */
   MakeObjTrace (GetLocalVarEntity (t->TRACE_DECL.Ident, t->TRACE_DECL.Line, unit));
  }
   return;

  case kNODSP_DECL:
/* line 994 "MakeDefs.puma" */
  {
/* line 996 "MakeDefs.puma" */
   MakeObjNoDescriptor (GetLocalVarEntity (t->NODSP_DECL.Ident, t->NODSP_DECL.Line, unit));
  }
   return;

  case kTREE_DECL:
/* line 999 "MakeDefs.puma" */
  {
/* line 1001 "MakeDefs.puma" */
   MakeObjTree (GetLocalVarEntity (t->TREE_DECL.Ident, t->TREE_DECL.Line, unit));
  }
   return;

  case kSELECT_DECL:
/* line 1006 "MakeDefs.puma" */
   return;

  case kINHERIT_DECL:
/* line 1009 "MakeDefs.puma" */
  {
/* line 1011 "MakeDefs.puma" */
   MakeObjInherited (GetLocalVarEntity (t->INHERIT_DECL.Ident, t->INHERIT_DECL.Line, unit));
  }
   return;

  case kRANGE_DECL:
/* line 1014 "MakeDefs.puma" */
   return;

  case kPARAMETER_DECL:
/* line 1025 "MakeDefs.puma" */
  {
/* line 1027 "MakeDefs.puma" */
 t->PARAMETER_DECL.VAL = CheckExp (t->PARAMETER_DECL.VAL); 
/* line 1029 "MakeDefs.puma" */
   MakeObjParameter (t->PARAMETER_DECL.VAL, GetLocalVarEntity (t->PARAMETER_DECL.Ident, t->PARAMETER_DECL.Line, unit));
  }
   return;

  case kIMPLICIT_DECL:
  if (t->IMPLICIT_DECL.TYPE->Kind == kDUMMY_TYPE) {
/* line 1040 "MakeDefs.puma" */
  {
/* line 1044 "MakeDefs.puma" */
   CharSetImplicitTable ('A', 'Z', t->IMPLICIT_DECL.TYPE);
  }
   return;

  }
/* line 1047 "MakeDefs.puma" */
  {
/* line 1049 "MakeDefs.puma" */
   SetImplicitTable (t->IMPLICIT_DECL.first, t->IMPLICIT_DECL.last, t->IMPLICIT_DECL.TYPE);
  }
   return;

  case kEXTERNAL_DECL:
/* line 1058 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1061 "MakeDefs.puma" */
   Obj = GetLocalObject (t->EXTERNAL_DECL.Ident);
/* line 1063 "MakeDefs.puma" */
   if (! ((Obj != NoObject))) goto yyL47;
  {
/* line 1067 "MakeDefs.puma" */
   MakeObjExternal (Obj);
  }
  }
   return;
 }
yyL47:;

/* line 1070 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1074 "MakeDefs.puma" */
   Obj = mExternalObject (t->EXTERNAL_DECL.Ident, t, Default, unit, UserRoutine, mENTRY_EMPTY ());
/* line 1077 "MakeDefs.puma" */
   SetExternalEntry (Obj);
/* line 1078 "MakeDefs.puma" */
   InsertEntry (Obj);
  }
   return;
 }

  case kINTERFACE_DECL:
  if (t->INTERFACE_DECL.SPEC->Kind == kNO_GENERIC_SPEC) {
/* line 1089 "MakeDefs.puma" */
 {
  tDefinitions HostAssociation;
  {
/* line 1093 "MakeDefs.puma" */
   DeclareUnits (t->INTERFACE_DECL.ITEMS, NoObject);
/* line 1101 "MakeDefs.puma" */
   MakeInterfaceDefs (t->INTERFACE_DECL.ITEMS);
  }
   return;
 }

  }
/* line 1112 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  tDefinitions Scope;
  tDefinitions HostAssociation;
  {
/* line 1118 "MakeDefs.puma" */
 
 
     Obj = mGenericObject (GetGenericId (t->INTERFACE_DECL.SPEC), t, Default, unit, 
                           NoDefinitions);
     NewScope ();

     DeclareUnits (t->INTERFACE_DECL.ITEMS, Obj);   

     HostAssociation = RemoveHostAssociation ();
     MakeInterfaceDefs (t->INTERFACE_DECL.ITEMS);
     ResetHostAssociation (HostAssociation);
   
     Scope = GetCurrentScope ();
     CloseScope ();
     Obj->GenericObject.Interfaces = Scope;
     InsertEntry (Obj);

   
  }
   return;
 }

  case kCOMMON_DECL:
/* line 1138 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1142 "MakeDefs.puma" */
   Obj = GetDeclEntry (t->COMMON_DECL.Ident, GetCommonEntries ());
/* line 1144 "MakeDefs.puma" */
   MakeDECLDefs (t->COMMON_DECL.IDS, unit);
/* line 1146 "MakeDefs.puma" */
 if (Obj == NoObject)

        { Obj = mCommonObject (t->COMMON_DECL.Ident, t, Default, NoObject,
                               GetCurrentScope(),
                               0, 0, 0, 0);

          

          InsertCommonEntry (Obj);
        }

        
   
/* line 1166 "MakeDefs.puma" */
   MakeCommons (t->COMMON_DECL.IDS, t);
  }
   return;
 }

  case kNAMELIST_DECL:
/* line 1169 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1173 "MakeDefs.puma" */
   Obj = GetLocalObject (t->NAMELIST_DECL.Ident);
/* line 1175 "MakeDefs.puma" */
 if (Obj == NoObject)
        { Obj = mNameListObject (t->NAMELIST_DECL.Ident, t, Default, NoObject);
          InsertEntry (Obj);
        }
      else
        { 
          error_protocol ("illegal redefinition");
          tree_protocol ("NAMELIST Declaration is : ", t);
        }
   
/* line 1187 "MakeDefs.puma" */
   t = t->NAMELIST_DECL.IDS;
   goto yyRecursion;
  }
 }

  case kEQV_DECL:
/* line 1190 "MakeDefs.puma" */
  {
/* line 1192 "MakeDefs.puma" */
   MakeVarDefs (t->EQV_DECL.VARS);
  }
   return;

  case kDATA_DECL:
/* line 1195 "MakeDefs.puma" */
  {
/* line 1196 "MakeDefs.puma" */
   MakeVarDefs (t->DATA_DECL.VARS);
/* line 1197 "MakeDefs.puma" */
   MakeIndexDefs (t->DATA_DECL.VALS);
  }
   return;

  case kDISTRIBUTE_DECL:
/* line 1200 "MakeDefs.puma" */
   return;

  case kUSE_DECL:
/* line 1204 "MakeDefs.puma" */
  {
/* line 1208 "MakeDefs.puma" */
   UseModule (GetModule (t->USE_DECL.use), t->USE_DECL.RENAMINGS);
  }
   return;

  case kONLY_USE_DECL:
/* line 1211 "MakeDefs.puma" */
  {
/* line 1213 "MakeDefs.puma" */
   UseOnlyModule (GetModule (t->ONLY_USE_DECL.use), t->ONLY_USE_DECL.NAMES);
  }
   return;

  }

/* line 1216 "MakeDefs.puma" */
  {
/* line 1218 "MakeDefs.puma" */
   failure_protocol (MODULE, "MakeDECLDefs", t);
  }
   return;

;
}

static void MakeTYPEDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kARRAY_TYPE:
/* line 1229 "MakeDefs.puma" */
  {
/* line 1230 "MakeDefs.puma" */
   MakeTYPEDefs (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);
/* line 1231 "MakeDefs.puma" */
   t = t->ARRAY_TYPE.ARRAY_COMP_TYPE;
   goto yyRecursion;
  }

  case kSHAPE_LIST:
/* line 1234 "MakeDefs.puma" */
  {
/* line 1235 "MakeDefs.puma" */
   MakeTYPEDefs (t->SHAPE_LIST.Elem);
/* line 1236 "MakeDefs.puma" */
   t = t->SHAPE_LIST.Next;
   goto yyRecursion;
  }

  case kSHAPE_EMPTY:
/* line 1239 "MakeDefs.puma" */
   return;

  case kEXPLICIT_SHAPE:
/* line 1242 "MakeDefs.puma" */
  {
/* line 1244 "MakeDefs.puma" */
 t->EXPLICIT_SHAPE.LOWER = CheckExp (t->EXPLICIT_SHAPE.LOWER);
     t->EXPLICIT_SHAPE.UPPER = CheckExp (t->EXPLICIT_SHAPE.UPPER);
   
  }
   return;

  case kASSUMED_SHAPE:
/* line 1249 "MakeDefs.puma" */
  {
/* line 1251 "MakeDefs.puma" */
 t->ASSUMED_SHAPE.LOWER = CheckExp (t->ASSUMED_SHAPE.LOWER); 
  }
   return;

  case kDEFERRED_SHAPE:
/* line 1254 "MakeDefs.puma" */
   return;

  case kASSUMED_SIZE:
/* line 1258 "MakeDefs.puma" */
  {
/* line 1260 "MakeDefs.puma" */
 t->ASSUMED_SIZE.LOWER = CheckExp (t->ASSUMED_SIZE.LOWER); 
  }
   return;

  case kDUMMY_TYPE:
/* line 1263 "MakeDefs.puma" */
   return;

  case kINTEGER_TYPE:
/* line 1265 "MakeDefs.puma" */
  {
/* line 1265 "MakeDefs.puma" */
 t->INTEGER_TYPE.SIZE = CheckExp (t->INTEGER_TYPE.SIZE); 
  }
   return;

  case kREAL_TYPE:
/* line 1266 "MakeDefs.puma" */
  {
/* line 1266 "MakeDefs.puma" */
 t->REAL_TYPE.SIZE = CheckExp (t->REAL_TYPE.SIZE); 
  }
   return;

  case kCOMPLEX_TYPE:
/* line 1267 "MakeDefs.puma" */
  {
/* line 1267 "MakeDefs.puma" */
 t->COMPLEX_TYPE.SIZE = CheckExp (t->COMPLEX_TYPE.SIZE); 
  }
   return;

  case kBOOLEAN_TYPE:
/* line 1268 "MakeDefs.puma" */
  {
/* line 1268 "MakeDefs.puma" */
 t->BOOLEAN_TYPE.SIZE = CheckExp (t->BOOLEAN_TYPE.SIZE); 
  }
   return;

  case kSTRING_TYPE:
/* line 1270 "MakeDefs.puma" */
  {
/* line 1272 "MakeDefs.puma" */
 t->STRING_TYPE.LENGTH = CheckExp (t->STRING_TYPE.LENGTH); 
  }
   return;

  case kTYPE_ID:
/* line 1275 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1279 "MakeDefs.puma" */
   Obj = GetGlobalObject (t->TYPE_ID.ID->TYPE_OBJ.Ident);
/* line 1283 "MakeDefs.puma" */
 if (Obj == NoObject)

        { Obj = MakeNewObject (mTYPE_DECL (t->TYPE_ID.ID->TYPE_OBJ.Ident, 0, NoTree),
                               GetCurrentUnitObject());
          InsertUseEntry (Obj);
          t->TYPE_ID.ID->TYPE_OBJ.Object = Obj;
          warning_protocol ("use of not defined type (should be pointer)");
        }

      else if (Obj->Kind != kTypeObject)
        error_protocol ("identifier not id of a derived type");
      else 
        t->TYPE_ID.ID->TYPE_OBJ.Object = Obj;
   
  }
   return;
 }

  }

/* line 1299 "MakeDefs.puma" */
  {
/* line 1300 "MakeDefs.puma" */
   failure_protocol (MODULE, "MakeTYPEDefs", t);
  }
   return;

;
}

static void InsertUseEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1313 "MakeDefs.puma" */
 {
  tDefinitions Scope;
  {
/* line 1315 "MakeDefs.puma" */
   if (! ((is_type_scope))) goto yyL1;
  {
/* line 1319 "MakeDefs.puma" */
 Scope = GetCurrentScope ();
      CloseScope ();
      InsertEntry (obj);
      OpenScope (Scope);
    
  }
  }
   return;
 }
yyL1:;

/* line 1326 "MakeDefs.puma" */
  {
/* line 1327 "MakeDefs.puma" */
   InsertEntry (obj);
  }
   return;

;
}

static void MakeTypeScope
# if defined __STDC__ | defined __cplusplus
(register tDefinitions tobj, register tTree decl)
# else
(tobj, decl)
 register tDefinitions tobj;
 register tTree decl;
# endif
{
  if (tobj->Kind == kTypeObject) {
/* line 1340 "MakeDefs.puma" */
  {
/* line 1342 "MakeDefs.puma" */
   if (! ((tobj->TypeObject.Components != NoEntries))) goto yyL1;
  {
/* line 1343 "MakeDefs.puma" */
   error_protocol ("there is already such a defined type");
  }
  }
   return;
yyL1:;

  if (decl->Kind == kTYPE_DECL) {
  if (decl->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
/* line 1346 "MakeDefs.puma" */
 {
  tDefinitions Scope;
  {
/* line 1351 "MakeDefs.puma" */
 tobj->TypeObject.decl = decl;
     is_type_scope = rtrue;
     NewScope ();
     decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS = Normal1Definitions (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS);
     MakeDECLDefs (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS, tobj);
     decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS = Normal2Definitions (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS); 
     SetDistributions (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS, tobj);
     SetAlignments    (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS, tobj);
     Scope = GetCurrentScope ();
     CloseScope ();
     is_type_scope = rfalse;
     tobj->TypeObject.Components = ReverseEntryList (Scope, mENTRY_EMPTY ());
   
  }
   return;
 }

  }
  }
  }
/* line 1366 "MakeDefs.puma" */
  {
/* line 1368 "MakeDefs.puma" */
   error_protocol ("type name already in use");
/* line 1369 "MakeDefs.puma" */
   obj_protocol ("object with this name is : ", tobj);
  }
   return;

;
}

static void MakeCommons
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree CommonDecl)
# else
(t, CommonDecl)
 register tTree t;
 register tTree CommonDecl;
# endif
{
 yyRecursion:
  if (t->Kind == kDECL_EMPTY) {
/* line 1382 "MakeDefs.puma" */
   return;

  }
  if (t->Kind == kDECL_LIST) {
/* line 1385 "MakeDefs.puma" */
  {
/* line 1387 "MakeDefs.puma" */
   MakeCommons (t->DECL_LIST.Elem, CommonDecl);
/* line 1388 "MakeDefs.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kVAR_DECL) {
/* line 1391 "MakeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1395 "MakeDefs.puma" */
   Obj = GetLocalObject (t->VAR_DECL.Ident);
/* line 1397 "MakeDefs.puma" */
 if (Obj == NoObject)
         { error_protocol ("no object found for item in COMMON");
           tree_protocol ("item : ", t);
         }
       else
         MakeObjCommon (CommonDecl, Obj);
   
  }
   return;
 }

  }
  if (CommonDecl->Kind == kCOMMON_DECL) {
/* line 1406 "MakeDefs.puma" */
  {
/* line 1408 "MakeDefs.puma" */
   failure_protocol (MODULE, "MakeCommons", t);
  }
   return;

  }
;
}

static void MakeInterfaceDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kUNIT_LIST) {
/* line 1419 "MakeDefs.puma" */
  {
/* line 1421 "MakeDefs.puma" */
   set_protocol_stmt (t->UNIT_LIST.Elem);
/* line 1422 "MakeDefs.puma" */
   MakeInterfaceDefs (t->UNIT_LIST.Elem);
/* line 1423 "MakeDefs.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kUNIT_EMPTY) {
/* line 1426 "MakeDefs.puma" */
   return;

  }
  if (t->Kind == kMODULE_PROC_DECL) {
/* line 1429 "MakeDefs.puma" */
   return;

  }
  if (t->Kind == kPROC_DECL) {
/* line 1432 "MakeDefs.puma" */
  {
/* line 1434 "MakeDefs.puma" */
   MakeUnitDefs (t);
/* line 1435 "MakeDefs.puma" */
   EmptyBody (t->PROC_DECL.PROC_BODY);
  }
   return;

  }
  if (t->Kind == kFUNC_DECL) {
/* line 1438 "MakeDefs.puma" */
  {
/* line 1440 "MakeDefs.puma" */
   MakeUnitDefs (t);
/* line 1441 "MakeDefs.puma" */
   EmptyBody (t->FUNC_DECL.FUNC_BODY);
  }
   return;

  }
/* line 1444 "MakeDefs.puma" */
  {
/* line 1445 "MakeDefs.puma" */
   error_protocol ("not allowed in INTERFACE block");
  }
   return;

;
}

static void EmptyBody
# if defined __STDC__ | defined __cplusplus
(register tTree b)
# else
(b)
 register tTree b;
# endif
{
  if (b->Kind == kBODY_NODE) {
  if (b->BODY_NODE.STATS->Kind == kACF_EMPTY) {
  if (b->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
/* line 1450 "MakeDefs.puma" */
   return;

  }
  }
  if (b->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
/* line 1453 "MakeDefs.puma" */
  {
/* line 1455 "MakeDefs.puma" */
   error_protocol ("statements in INTERFACE routine not allowed");
  }
   return;

  }
  if (b->BODY_NODE.STATS->Kind == kACF_EMPTY) {
/* line 1458 "MakeDefs.puma" */
  {
/* line 1460 "MakeDefs.puma" */
   error_protocol ("internals in INTERFACE routine not allowed");
  }
   return;

  }
/* line 1463 "MakeDefs.puma" */
  {
/* line 1465 "MakeDefs.puma" */
   error_protocol ("statements/internals in INTERFACE routine not allowed");
  }
   return;

  }
;
}

static tDefinitions ReverseEntryList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions list, register tDefinitions newlist)
# else
(list, newlist)
 register tDefinitions list;
 register tDefinitions newlist;
# endif
{
  if (list->Kind == kENTRY_EMPTY) {
/* line 1484 "MakeDefs.puma" */
   return newlist;

  }
  if (list->Kind == kENTRY_LIST) {
/* line 1489 "MakeDefs.puma" */
 {
  tDefinitions help;
  {
/* line 1493 "MakeDefs.puma" */
 help = list->ENTRY_LIST.Next;
     list->ENTRY_LIST.Next = newlist;
   
  }
   return ReverseEntryList (help, list);
 }

  }
 yyAbort ("ReverseEntryList");
 { tDefinitions yyDummy; return yyDummy; }
}

static void SetExtrinsicId
# if defined __STDC__ | defined __cplusplus
(register tTree unit)
# else
(unit)
 register tTree unit;
# endif
{
  if (unit->Kind == kFUNC_DECL) {
/* line 1510 "MakeDefs.puma" */
  {
/* line 1512 "MakeDefs.puma" */
   if (! ((unit->FUNC_DECL.HPFExtrinsic == DefaultId ()))) goto yyL1;
  {
/* line 1514 "MakeDefs.puma" */
   unit->FUNC_DECL.HPFExtrinsic = GetCurrentExtrinsic ();
  }
  }
   return;
yyL1:;

  }
  if (unit->Kind == kPROC_DECL) {
/* line 1517 "MakeDefs.puma" */
  {
/* line 1519 "MakeDefs.puma" */
   if (! ((unit->PROC_DECL.HPFExtrinsic == DefaultId ()))) goto yyL2;
  {
/* line 1521 "MakeDefs.puma" */
   unit->PROC_DECL.HPFExtrinsic = GetCurrentExtrinsic ();
  }
  }
   return;
yyL2:;

  }
;
}

static tIdent GetCurrentExtrinsic
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 1526 "MakeDefs.puma" */
  {
/* line 1527 "MakeDefs.puma" */
   if (! ((target_model == HPF_GLOBAL))) goto yyL1;
  }
   return IsIdent ("HPF_GLOBAL");
yyL1:;

/* line 1531 "MakeDefs.puma" */
  {
/* line 1532 "MakeDefs.puma" */
   if (! ((target_model == HPF_SERIAL))) goto yyL2;
  }
   return IsIdent ("HPF_SERIAL");
yyL2:;

/* line 1536 "MakeDefs.puma" */
  {
/* line 1537 "MakeDefs.puma" */
   if (! ((target_model == HPF_LOCAL))) goto yyL3;
  }
   return IsIdent ("HPF_LOCAL");
yyL3:;

/* line 1541 "MakeDefs.puma" */
  {
/* line 1542 "MakeDefs.puma" */
   if (! ((target_model == HPF_TASK))) goto yyL4;
  }
   return IsIdent ("HPF_TASK");
yyL4:;

 yyAbort ("GetCurrentExtrinsic");
 { tIdent yyDummy; return yyDummy; }
}

void BeginMakeDefs ARGS ((void))
{
}

void CloseMakeDefs ARGS ((void))
{
}
