# include "MakeCalls.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 50 "MakeCalls.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
 
# include "protocol.h"

# include "Transform.h"      /* CombineACF     */
# include "DefTable.h"
# include "Objects.h"        /* IsSerialCall   */

# include "Traverse.h" 
# include "Accepted.h" 

# include "VarDescriptor.h" 
# include "Intrinsics.h"
# include "Rank.h"
# include "TreeOps.h"        /* TreeVarName     */
# include "Expressions.h"    /* EqualIndexes    */

# include "HomeDescriptor.h"  
# include "ExpDescriptor.h"  
# include "TempAssigns.h"  
# include "Expansion.h"  

# include "StrUnparse.h"

# define MODULE "MakeCalls"
 
# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeCalls.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeCalls_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeCalls, routine %s failed\n",
  yyFunction);
 MakeCalls_Exit ();
}

void MakeCalls ARGS ((tTree t));
static rbool StopMakeTempArgs ARGS ((tTree t));
static tTree DoMakeTempArgs ARGS ((tTree t));
static void IntrinsicArguments ARGS ((tIdent name, tTree actuals, tTree * yyP2, tTree * yyP1));
static void FunctionResult ARGS ((tTree assign, tTree * yyP4, tTree * yyP3));
static void IntrinsicResult ARGS ((tIdent name, tTree assign, tTree * yyP6, tTree * yyP5));
static void SplitScatter ARGS ((tTree assign, tTree * yyP7));
static rbool NoSplit ARGS ((tTree var, tTree base));
static void MakeAcceptedIOParamList ARGS ((tTree items, tTree * yyP9, tTree * yyP8));
static void MakeAcceptedIOParam ARGS ((tTree item, tTree * yyP11, tTree * yyP10));
static void MakeAcceptedLoopParamList ARGS ((tTree params, rbool serial, tTree * yyP13, tTree * yyP12));
static void MakeAcceptedLoopParam ARGS ((tTree actual, rbool serial, tTree * yyP15, tTree * yyP14));
static void MakeAcceptedParamList ARGS ((tTree actuals, tTree call, rbool serial, tTree * yyP17, tTree * yyP16));
static void MakeAcceptedParam ARGS ((tTree actual, tTree call, rbool serial, tTree * yyP19, tTree * yyP18));
static void FindParamDescriptor ARGS ((tTree actual, rbool * yyP21, var_descriptor * yyP20));
static void MakeParamTemporary ARGS ((tTree actual, pvar vard, tTree * yyP23, tTree * yyP22));
static void MakeNewAssignment ARGS ((tTree exp, pvar vard, tTree * yyP26, tTree * yyP25, tTree * yyP24));
static rbool AcceptedParameter ARGS ((tTree param));
static rbool AcceptedVarParameter ARGS ((tTree var));
static void ExtractNewStatements ARGS ((tTree stmts, tTree * yyP29, tTree * yyP28, tTree * yyP27));
static rbool IsPreStatement ARGS ((tTree t));
static rbool IsPostStatement ARGS ((tTree t));

void MakeCalls
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 92 "MakeCalls.puma" */
  {
/* line 94 "MakeCalls.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeTempArgs, DoMakeTempArgs); 
  }
   return;

  }
/* line 97 "MakeCalls.puma" */
  {
/* line 98 "MakeCalls.puma" */
   failure_protocol (MODULE, "MakeCalls", t);
  }
   return;

;
}

static rbool StopMakeTempArgs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 115 "MakeCalls.puma" */
  {
/* line 116 "MakeCalls.puma" */
   return rfalse;
  }

}

static tTree DoMakeTempArgs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 132 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 134 "MakeCalls.puma" */
   MakeAcceptedParamList (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, t->ACF_BASIC.BASIC_STMT, IsSerialCall (t->ACF_BASIC.BASIC_STMT), & yyV1, & yyV2);
/* line 137 "MakeCalls.puma" */
 if (yyV1 != NoTree)
      { set_protocol_stmt (t);
        stmt_protocol ("new arguments for subroutine call necessary");
        tree_protocol ("pre_stmts  : \n", yyV1);
        tree_protocol ("post_stmts : \n", yyV2);
      }
  
  }
   return ComposeNewACF (yyV1, t, yyV2);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 148 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 151 "MakeCalls.puma" */
   if (! ((IsIntrCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
/* line 153 "MakeCalls.puma" */
   IntrinsicArguments (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
/* line 154 "MakeCalls.puma" */
   IntrinsicResult (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->ACF_BASIC.BASIC_STMT, & yyV3, & yyV4);
/* line 156 "MakeCalls.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 157 "MakeCalls.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
/* line 159 "MakeCalls.puma" */
 if (yyV1 != NoTree)

       { set_protocol_stmt (t);
         stmt_protocol ("new arguments for intrinsic function call necessary");
         tree_protocol ("pre_stmts  : \n", yyV1);
         tree_protocol ("post_stmts : \n", yyV2);
       }
   
  }
  }
   return CombineACF (yyV1, CombineACF (t, yyV2));
 }
yyL2:;

/* line 171 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 174 "MakeCalls.puma" */
   MakeAcceptedParamList (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, IsSerialCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP), & yyV1, & yyV2);
/* line 177 "MakeCalls.puma" */
   FunctionResult (t->ACF_BASIC.BASIC_STMT, & yyV3, & yyV4);
/* line 179 "MakeCalls.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 180 "MakeCalls.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
/* line 182 "MakeCalls.puma" */
 if (yyV1 != NoTree)

       { stmt_protocol ("new arguments for function call necessary");
         tree_protocol ("pre_stmts  : \n", yyV1);
         tree_protocol ("post_stmts : \n", yyV2);
       }
   
  }
   return CombineACF (yyV1, CombineACF (t, yyV2));
 }

  }
  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 193 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 195 "MakeCalls.puma" */
   MakeAcceptedIOParamList (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, & yyV1, & yyV2);
/* line 197 "MakeCalls.puma" */
 if (yyV1 != NoTree)

       { stmt_protocol ("new arguments for IO necessary");
         tree_protocol ("pre_stmts  : \n", yyV1);
         tree_protocol ("post_stmts : \n", yyV2);
       }
   
  }
   return CombineACF (yyV1, CombineACF (t, yyV2));
 }

  }
  }
  if (t->Kind == kACF_WHERE) {
/* line 220 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 222 "MakeCalls.puma" */
   ExtractNewStatements (t->ACF_WHERE.TRUE_PART, & yyV1, & yyV2, & yyV3);
/* line 223 "MakeCalls.puma" */
   ExtractNewStatements (t->ACF_WHERE.FALSE_PART, & yyV4, & yyV5, & yyV6);
/* line 225 "MakeCalls.puma" */
 t->ACF_WHERE.TRUE_PART = yyV1; t->ACF_WHERE.FALSE_PART = yyV4; 
/* line 227 "MakeCalls.puma" */
   yyV2 = CombineACF (yyV2, yyV5);
/* line 228 "MakeCalls.puma" */
   yyV3 = CombineACF (yyV6, yyV3);
  }
   return ComposeNewACF (yyV2, t, yyV3);
 }

  }
/* line 233 "MakeCalls.puma" */
   return t;

}

static void IntrinsicArguments
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree actuals, register tTree * yyP2, register tTree * yyP1)
# else
(name, actuals, yyP2, yyP1)
 register tIdent name;
 register tTree actuals;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
  if (actuals->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (actuals->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (actuals->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 261 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 265 "MakeCalls.puma" */
   if (! (((IntrFuncRed (name)) || (IntrFuncLocRed (name))))) goto yyL1;
  {
/* line 267 "MakeCalls.puma" */
   MakeAcceptedParam (actuals->BTP_LIST.Next->BTP_LIST.Elem, NoTree, rtrue, & yyV1, & yyV2);
/* line 268 "MakeCalls.puma" */
   MakeAcceptedLoopParam (actuals->BTP_LIST.Elem, rfalse, & yyV3, & yyV4);
/* line 270 "MakeCalls.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 271 "MakeCalls.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
/* line 273 "MakeCalls.puma" */
   MakeAcceptedLoopParam (actuals->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, rfalse, & yyV5, & yyV6);
/* line 275 "MakeCalls.puma" */
   yyV1 = CombineACF (yyV1, yyV5);
/* line 276 "MakeCalls.puma" */
   yyV2 = CombineACF (yyV6, yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

/* line 285 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 289 "MakeCalls.puma" */
   if (! ((IsIdent ("SPREAD") == name))) goto yyL2;
  {
/* line 291 "MakeCalls.puma" */
   MakeAcceptedParam (actuals->BTP_LIST.Next->BTP_LIST.Elem, NoTree, rtrue, & yyV1, & yyV2);
/* line 293 "MakeCalls.puma" */
   MakeAcceptedLoopParam (actuals->BTP_LIST.Elem, rfalse, & yyV3, & yyV4);
/* line 296 "MakeCalls.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 297 "MakeCalls.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL2:;

  }
  }
  }
  }
/* line 306 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 310 "MakeCalls.puma" */
   if (! ((IsIdent ("MERGE") == name))) goto yyL3;
  {
/* line 314 "MakeCalls.puma" */
   MakeAcceptedLoopParamList (actuals, rfalse, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

/* line 317 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 321 "MakeCalls.puma" */
   if (! ((IntrFuncElemental (name)))) goto yyL4;
  {
/* line 323 "MakeCalls.puma" */
   MakeAcceptedLoopParamList (actuals, rfalse, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL4:;

/* line 343 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 345 "MakeCalls.puma" */
   MakeAcceptedParamList (actuals, NoTree, rfalse, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

;
}

static void FunctionResult
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register tTree * yyP4, register tTree * yyP3)
# else
(assign, yyP4, yyP3)
 register tTree assign;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 361 "MakeCalls.puma" */
  {
/* line 363 "MakeCalls.puma" */
   if (! ((AcceptedVarParameter (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;
yyL1:;

/* line 366 "MakeCalls.puma" */
 {
  rbool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 371 "MakeCalls.puma" */
   GetExpDescriptor (assign->ASSIGN_STMT.ASSIGN_EXP, & found, & vard);
/* line 372 "MakeCalls.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 374 "MakeCalls.puma" */
   MakeNewAssignment (assign->ASSIGN_STMT.ASSIGN_EXP, & vard, & yyV1, & yyV2, & yyV3);
/* line 375 "MakeCalls.puma" */
 assign->ASSIGN_STMT.ASSIGN_EXP = yyV1; 
  }
  }
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }
yyL2:;

/* line 378 "MakeCalls.puma" */
  {
/* line 380 "MakeCalls.puma" */
   error_protocol ("no descriptor for function call found");
/* line 381 "MakeCalls.puma" */
   tree_protocol ("call is : ", assign->ASSIGN_STMT.ASSIGN_EXP);
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }
  }
;
}

static void IntrinsicResult
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree assign, register tTree * yyP6, register tTree * yyP5)
# else
(name, assign, yyP6, yyP5)
 register tIdent name;
 register tTree assign;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
/* line 398 "MakeCalls.puma" */
  {
/* line 400 "MakeCalls.puma" */
   if (! ((IsIdent ("SPREAD") == name))) goto yyL1;
  {
/* line 401 "MakeCalls.puma" */
   if (! ((DoLoopExpression (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  }
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL1:;

/* line 404 "MakeCalls.puma" */
  {
/* line 406 "MakeCalls.puma" */
   if (! ((IsIdent ("TRANSPOSE") == name))) goto yyL2;
  {
/* line 407 "MakeCalls.puma" */
   if (! ((DoLoopExpression (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL2;
  }
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL2:;

/* line 410 "MakeCalls.puma" */
  {
/* line 412 "MakeCalls.puma" */
   if (! ((IntrFuncElemental (name)))) goto yyL3;
  {
/* line 413 "MakeCalls.puma" */
   if (! ((DoLoopExpression (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL3;
  }
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL3:;

/* line 416 "MakeCalls.puma" */
 {
  tTree yyV1;
  {
/* line 418 "MakeCalls.puma" */
   if (! ((IntrFuncScatter (name)))) goto yyL4;
  {
/* line 419 "MakeCalls.puma" */
   SplitScatter (assign, & yyV1);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = NoTree;
   return;
 }
yyL4:;

  }
/* line 422 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 424 "MakeCalls.puma" */
   FunctionResult (assign, & yyV1, & yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

;
}

static void SplitScatter
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register tTree * yyP7)
# else
(assign, yyP7)
 register tTree assign;
 register tTree * yyP7;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 438 "MakeCalls.puma" */
  {
/* line 441 "MakeCalls.puma" */
   if (! ((! AcceptedVarParameter (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  {
/* line 443 "MakeCalls.puma" */
   error_protocol ("not accepted LHS in scatter reduction (indirection:-)");
  }
  }
   * yyP7 = NoTree;
   return;
yyL1:;

/* line 446 "MakeCalls.puma" */
  {
/* line 449 "MakeCalls.puma" */
   if (! ((NoSplit (assign->ASSIGN_STMT.ASSIGN_VAR, assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem)))) goto yyL2;
  }
   * yyP7 = NoTree;
   return;
yyL2:;

/* line 452 "MakeCalls.puma" */
 {
  tTree pre;
  {
/* line 457 "MakeCalls.puma" */
 pre = mASSIGN_STMT (CopyTree(assign->ASSIGN_STMT.ASSIGN_VAR), VarParamToExp (assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem));
     pre = mACF_BASIC (pre);
     assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem = mVAR_PARAM (CopyTree(assign->ASSIGN_STMT.ASSIGN_VAR));
   
/* line 462 "MakeCalls.puma" */
   tree_protocol ("copy base into lhs (are different) : ", pre);
  }
   * yyP7 = pre;
   return;
 }

  }
  }
  }
  }
;
}

static rbool NoSplit
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree base)
# else
(var, base)
 register tTree var;
 register tTree base;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (base->Kind == kVAR_PARAM) {
  if (base->VAR_PARAM.V->Kind == kINDEXED_VAR) {
/* line 467 "MakeCalls.puma" */
  {
/* line 469 "MakeCalls.puma" */
   if (! ((TreeVarName (var->INDEXED_VAR.IND_VAR) == TreeVarName (base->VAR_PARAM.V->INDEXED_VAR.IND_VAR)))) goto yyL1;
  {
/* line 470 "MakeCalls.puma" */
   if (! ((EqualIndexes (var->INDEXED_VAR.IND_EXPS, base->VAR_PARAM.V->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  }
  return rfalse;
}

static void MakeAcceptedIOParamList
# if defined __STDC__ | defined __cplusplus
(register tTree items, register tTree * yyP9, register tTree * yyP8)
# else
(items, yyP9, yyP8)
 register tTree items;
 register tTree * yyP9;
 register tTree * yyP8;
# endif
{
  if (items->Kind == kBTP_LIST) {
/* line 480 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 482 "MakeCalls.puma" */
   MakeAcceptedIOParam (items->BTP_LIST.Elem, & yyV1, & yyV2);
/* line 483 "MakeCalls.puma" */
   MakeAcceptedIOParamList (items->BTP_LIST.Next, & yyV3, & yyV4);
/* line 485 "MakeCalls.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 486 "MakeCalls.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP9 = yyV1;
   * yyP8 = yyV2;
   return;
 }

  }
  if (items->Kind == kBTP_EMPTY) {
/* line 489 "MakeCalls.puma" */
   * yyP9 = NoTree;
   * yyP8 = NoTree;
   return;

  }
;
}

static void MakeAcceptedIOParam
# if defined __STDC__ | defined __cplusplus
(register tTree item, register tTree * yyP11, register tTree * yyP10)
# else
(item, yyP11, yyP10)
 register tTree item;
 register tTree * yyP11;
 register tTree * yyP10;
# endif
{
/* line 494 "MakeCalls.puma" */
  {
/* line 496 "MakeCalls.puma" */
   if (! ((DoLoopExpression (item)))) goto yyL1;
  }
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;
yyL1:;

/* line 499 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 503 "MakeCalls.puma" */
   tree_protocol ("this IO-argument requires temporary : ", item);
/* line 505 "MakeCalls.puma" */
   MakeAcceptedParam (item, NoTree, rtrue, & yyV1, & yyV2);
  }
   * yyP11 = yyV1;
   * yyP10 = yyV2;
   return;
 }

;
}

static void MakeAcceptedLoopParamList
# if defined __STDC__ | defined __cplusplus
(register tTree params, register rbool serial, register tTree * yyP13, register tTree * yyP12)
# else
(params, serial, yyP13, yyP12)
 register tTree params;
 register rbool serial;
 register tTree * yyP13;
 register tTree * yyP12;
# endif
{
  if (params->Kind == kBTP_LIST) {
/* line 517 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 519 "MakeCalls.puma" */
   MakeAcceptedLoopParam (params->BTP_LIST.Elem, serial, & yyV1, & yyV2);
/* line 520 "MakeCalls.puma" */
   MakeAcceptedLoopParamList (params->BTP_LIST.Next, serial, & yyV3, & yyV4);
/* line 522 "MakeCalls.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 523 "MakeCalls.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP13 = yyV1;
   * yyP12 = yyV2;
   return;
 }

  }
  if (params->Kind == kBTP_EMPTY) {
/* line 526 "MakeCalls.puma" */
   * yyP13 = NoTree;
   * yyP12 = NoTree;
   return;

  }
;
}

static void MakeAcceptedLoopParam
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register rbool serial, register tTree * yyP15, register tTree * yyP14)
# else
(actual, serial, yyP15, yyP14)
 register tTree actual;
 register rbool serial;
 register tTree * yyP15;
 register tTree * yyP14;
# endif
{
/* line 531 "MakeCalls.puma" */
  {
/* line 533 "MakeCalls.puma" */
   if (! ((DoLoopExpression (actual)))) goto yyL1;
  }
   * yyP15 = NoTree;
   * yyP14 = NoTree;
   return;
yyL1:;

/* line 536 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 538 "MakeCalls.puma" */
   MakeAcceptedParam (actual, NoTree, serial, & yyV1, & yyV2);
  }
   * yyP15 = yyV1;
   * yyP14 = yyV2;
   return;
 }

;
}

static void MakeAcceptedParamList
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree call, register rbool serial, register tTree * yyP17, register tTree * yyP16)
# else
(actuals, call, serial, yyP17, yyP16)
 register tTree actuals;
 register tTree call;
 register rbool serial;
 register tTree * yyP17;
 register tTree * yyP16;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
/* line 560 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 562 "MakeCalls.puma" */
   MakeAcceptedParam (actuals->BTP_LIST.Elem, call, serial, & yyV1, & yyV2);
/* line 563 "MakeCalls.puma" */
   MakeAcceptedParamList (actuals->BTP_LIST.Next, call, serial, & yyV3, & yyV4);
/* line 565 "MakeCalls.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 566 "MakeCalls.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP17 = yyV1;
   * yyP16 = yyV2;
   return;
 }

  }
  if (actuals->Kind == kBTP_EMPTY) {
/* line 569 "MakeCalls.puma" */
   * yyP17 = NoTree;
   * yyP16 = NoTree;
   return;

  }
;
}

static void MakeAcceptedParam
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree call, register rbool serial, register tTree * yyP19, register tTree * yyP18)
# else
(actual, call, serial, yyP19, yyP18)
 register tTree actual;
 register tTree call;
 register rbool serial;
 register tTree * yyP19;
 register tTree * yyP18;
# endif
{
/* line 582 "MakeCalls.puma" */
  {
/* line 584 "MakeCalls.puma" */
   if (! ((AcceptedParameter (actual)))) goto yyL1;
  }
   * yyP19 = NoTree;
   * yyP18 = NoTree;
   return;
yyL1:;

  if (actual->Kind == kVAR_PARAM) {
/* line 587 "MakeCalls.puma" */
 {
  rbool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  {
/* line 589 "MakeCalls.puma" */
   if (! ((actual->VAR_PARAM.formal != NoObject))) goto yyL2;
  {
/* line 590 "MakeCalls.puma" */
   if (! ((call != NoTree))) goto yyL2;
  {
/* line 591 "MakeCalls.puma" */
   if (! ((! serial))) goto yyL2;
  {
/* line 596 "MakeCalls.puma" */
   GetDummyVarDescriptor (actual, actual->VAR_PARAM.formal, call, & found, & vard);
/* line 598 "MakeCalls.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 600 "MakeCalls.puma" */
   MakeParamTemporary (actual, & vard, & yyV1, & yyV2);
  }
  }
  }
  }
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   return;
 }
yyL2:;

/* line 603 "MakeCalls.puma" */
 {
  rbool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  {
/* line 608 "MakeCalls.puma" */
   GetParamDescriptor (actual, & found, & vard);
/* line 609 "MakeCalls.puma" */
   if (! ((found))) goto yyL3;
  {
/* line 611 "MakeCalls.puma" */
 if (serial)

        { vard.topology_rank = 0;
          vard.topology_obj  = GetDefaultTopology (0);
        }
   
/* line 618 "MakeCalls.puma" */
   MakeParamTemporary (actual, & vard, & yyV1, & yyV2);
  }
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   return;
 }
yyL3:;

/* line 621 "MakeCalls.puma" */
 {
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  {
/* line 625 "MakeCalls.puma" */
   if (! ((TreeRank (actual->VAR_PARAM.V) == 0))) goto yyL4;
  {
/* line 627 "MakeCalls.puma" */
   MakeReplicatedDescriptor (& vard);
/* line 629 "MakeCalls.puma" */
   MakeParamTemporary (actual, & vard, & yyV1, & yyV2);
  }
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   return;
 }
yyL4:;

  }
/* line 632 "MakeCalls.puma" */
  {
/* line 634 "MakeCalls.puma" */
   error_protocol ("could not make an accepted argument");
/* line 635 "MakeCalls.puma" */
   tree_protocol ("illegal argument : ", actual);
  }
   * yyP19 = NoTree;
   * yyP18 = NoTree;
   return;

;
}

static void FindParamDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register rbool * yyP21, var_descriptor * yyP20)
# else
(actual, yyP21, yyP20)
 register tTree actual;
 register rbool * yyP21;
 var_descriptor * yyP20;
# endif
{
/* line 646 "MakeCalls.puma" */
 {
  rbool found;
  var_descriptor vard;
  {
/* line 651 "MakeCalls.puma" */
   GetParamDescriptor (actual, & found, & vard);
/* line 652 "MakeCalls.puma" */
   if (! ((found))) goto yyL1;
  }
   * yyP21 = found;
   * yyP20 = vard;
   return;
 }
yyL1:;

/* line 655 "MakeCalls.puma" */
 {
  var_descriptor vard;
  {
  }
   * yyP21 = rfalse;
   * yyP20 = vard;
   return;
 }

;
}

static void MakeParamTemporary
# if defined __STDC__ | defined __cplusplus
(register tTree actual, pvar vard, register tTree * yyP23, register tTree * yyP22)
# else
(actual, vard, yyP23, yyP22)
 register tTree actual;
 pvar vard;
 register tTree * yyP23;
 register tTree * yyP22;
# endif
{
  if (actual->Kind == kVAR_PARAM) {
  if (actual->VAR_PARAM.V->Kind == kADDR) {
/* line 668 "MakeCalls.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree assign;
  tTree tmp_var;
  {
/* line 678 "MakeCalls.puma" */
   NoExpansion (vard);
/* line 679 "MakeCalls.puma" */
   MakeTemporaryStmt (actual->VAR_PARAM.V->ADDR.E, vard, & pre_stmts, & tmp_var, & assign, & post_stmts);
/* line 681 "MakeCalls.puma" */
 actual->VAR_PARAM.V = tmp_var; 
  }
   * yyP23 = CombineACF (pre_stmts, assign);
   * yyP22 = post_stmts;
   return;
 }

  }
/* line 684 "MakeCalls.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree new_var;
  {
/* line 691 "MakeCalls.puma" */
   NoExpansion (vard);
/* line 692 "MakeCalls.puma" */
   MakeTempVarStmt (actual->VAR_PARAM.V, actual->VAR_PARAM.intent, vard, & new_var, & pre_stmts, & post_stmts);
/* line 694 "MakeCalls.puma" */
 actual->VAR_PARAM.V = new_var; 
  }
   * yyP23 = pre_stmts;
   * yyP22 = post_stmts;
   return;
 }

  }
/* line 697 "MakeCalls.puma" */
  {
/* line 699 "MakeCalls.puma" */
   failure_protocol (MODULE, "MakeParamTemporary", actual);
  }
   * yyP23 = NoTree;
   * yyP22 = NoTree;
   return;

;
}

static void MakeNewAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP26, register tTree * yyP25, register tTree * yyP24)
# else
(exp, vard, yyP26, yyP25, yyP24)
 register tTree exp;
 pvar vard;
 register tTree * yyP26;
 register tTree * yyP25;
 register tTree * yyP24;
# endif
{
/* line 710 "MakeCalls.puma" */
 {
  tTree pre_stmt;
  tTree post_stmt;
  tTree tmp_var;
  tTree assign;
  {
/* line 718 "MakeCalls.puma" */
   NoExpansion (vard);
/* line 720 "MakeCalls.puma" */
   MakeTemporaryStmt (exp, vard, & pre_stmt, & tmp_var, & assign, & post_stmt);
  }
   * yyP26 = mVAR_EXP (tmp_var);
   * yyP25 = CombineACF (pre_stmt, assign);
   * yyP24 = post_stmt;
   return;
 }

;
}

static rbool AcceptedParameter
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kNO_PARAM) {
/* line 734 "MakeCalls.puma" */
   return rtrue;

  }
  if (param->Kind == kFUNC_PARAM) {
/* line 737 "MakeCalls.puma" */
   return rtrue;

  }
  if (param->Kind == kPROC_PARAM) {
/* line 740 "MakeCalls.puma" */
   return rtrue;

  }
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
/* line 743 "MakeCalls.puma" */
  {
/* line 745 "MakeCalls.puma" */
   if (! ((IsF77 (param->VAR_PARAM.V->ADDR.E)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
/* line 748 "MakeCalls.puma" */
  {
/* line 750 "MakeCalls.puma" */
   if (! ((AcceptedVarParameter (param->VAR_PARAM.V)))) goto yyL5;
  }
   return rtrue;
yyL5:;

  }
/* line 753 "MakeCalls.puma" */
  {
/* line 755 "MakeCalls.puma" */

#ifdef DEBUG
     FileUnparse (stdout, param); printf (" is not accepted parameter\n");
     WriteTree (stdout, param);
#endif
   
/* line 761 "MakeCalls.puma" */
   return rfalse;
  }

}

static rbool AcceptedVarParameter
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 779 "MakeCalls.puma" */
  {
/* line 781 "MakeCalls.puma" */
   if (! ((TreeRank (var) > 0))) goto yyL1;
  {
/* line 782 "MakeCalls.puma" */
   if (! ((IsDescriptorVar (var)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 787 "MakeCalls.puma" */
  {
/* line 789 "MakeCalls.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL2;
  {
/* line 790 "MakeCalls.puma" */
   if (! ((IsF77 (var)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static void ExtractNewStatements
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, register tTree * yyP29, register tTree * yyP28, register tTree * yyP27)
# else
(stmts, yyP29, yyP28, yyP27)
 register tTree stmts;
 register tTree * yyP29;
 register tTree * yyP28;
 register tTree * yyP27;
# endif
{
  if (stmts->Kind == kACF_EMPTY) {
/* line 804 "MakeCalls.puma" */
   * yyP29 = stmts;
   * yyP28 = NoTree;
   * yyP27 = NoTree;
   return;

  }
  if (stmts->Kind == kACF_LIST) {
/* line 807 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 809 "MakeCalls.puma" */
   if (! ((IsPreStatement (stmts->ACF_LIST.Elem)))) goto yyL2;
  {
/* line 811 "MakeCalls.puma" */
   ExtractNewStatements (stmts->ACF_LIST.Next, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP29 = yyV1;
   * yyP28 = CombineACF (stmts->ACF_LIST.Elem, yyV2);
   * yyP27 = yyV3;
   return;
 }
yyL2:;

/* line 814 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 816 "MakeCalls.puma" */
   if (! ((IsPostStatement (stmts->ACF_LIST.Elem)))) goto yyL3;
  {
/* line 818 "MakeCalls.puma" */
   ExtractNewStatements (stmts->ACF_LIST.Next, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP29 = yyV1;
   * yyP28 = yyV2;
   * yyP27 = CombineACF (stmts->ACF_LIST.Elem, yyV3);
   return;
 }
yyL3:;

/* line 821 "MakeCalls.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 823 "MakeCalls.puma" */
   ExtractNewStatements (stmts->ACF_LIST.Next, & yyV1, & yyV2, & yyV3);
/* line 825 "MakeCalls.puma" */
 stmts->ACF_LIST.Next = yyV1; 
  }
   * yyP29 = stmts;
   * yyP28 = yyV2;
   * yyP27 = yyV3;
   return;
 }

  }
;
}

static rbool IsPreStatement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCREATE_DSP_STMT) {
/* line 831 "MakeCalls.puma" */
   return rtrue;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
/* line 834 "MakeCalls.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static rbool IsPostStatement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kFREE_DSP_STMT) {
/* line 839 "MakeCalls.puma" */
   return rtrue;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
/* line 842 "MakeCalls.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

void BeginMakeCalls ARGS ((void))
{
}

void CloseMakeCalls ARGS ((void))
{
}
