# include "MakeArguments.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 34 "MakeArguments.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Transform.h" 
# include "Traverse.h"
# include "FindHome.h"
# include "Temporary.h"

# include "Descriptor.h"
# include "MoveDescriptor.h"

# include "MakeSerial.h"            /* MakeSerial             */
# include "TempFunctions.h"         /* MakeTempFunctions      */
# include "MakeCalls.h"             /* MakeCalls              */
# include "MakeRemapping.h"         /* MakeRemapping          */
# include "MakeReductions.h"        /* MakeReductions         */
# include "MakeOvUpdates.h"         /* MakeOvUpdates          */

# include "Nesting.h"
# include "Objects.h"

# define MODULE "MakeArguments"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyMakeArguments.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* MakeArguments_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeArguments, routine %s failed\n",
  yyFunction);
 MakeArguments_Exit ();
}

void MakeArguments ARGS ((tTree t));

void MakeArguments
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 76 "MakeArguments.puma" */
  {
/* line 78 "MakeArguments.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_LIST:
/* line 83 "MakeArguments.puma" */
  {
/* line 85 "MakeArguments.puma" */
   MakeArguments (t->UNIT_LIST.Elem);
/* line 86 "MakeArguments.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 89 "MakeArguments.puma" */
   return;

  case kPROGRAM_DECL:
/* line 92 "MakeArguments.puma" */
  {
/* line 94 "MakeArguments.puma" */
   NestOpenUnit (t);
/* line 95 "MakeArguments.puma" */
   MakeArguments (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 96 "MakeArguments.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 99 "MakeArguments.puma" */
  {
/* line 101 "MakeArguments.puma" */
   NestOpenUnit (t);
/* line 102 "MakeArguments.puma" */
   MakeArguments (t->PROC_DECL.PROC_BODY);
/* line 103 "MakeArguments.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 106 "MakeArguments.puma" */
  {
/* line 108 "MakeArguments.puma" */
   NestOpenUnit (t);
/* line 109 "MakeArguments.puma" */
   MakeArguments (t->FUNC_DECL.FUNC_BODY);
/* line 110 "MakeArguments.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 113 "MakeArguments.puma" */
  {
/* line 115 "MakeArguments.puma" */
   NestOpenUnit (t);
/* line 116 "MakeArguments.puma" */
   MakeArguments (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 117 "MakeArguments.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 120 "MakeArguments.puma" */
  {
/* line 122 "MakeArguments.puma" */
   NestOpenUnit (t);
/* line 123 "MakeArguments.puma" */
   MakeArguments (t->MODULE_DECL.MODULE_BODY);
/* line 124 "MakeArguments.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
/* line 127 "MakeArguments.puma" */
  {
/* line 129 "MakeArguments.puma" */
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

/* line 134 "MakeArguments.puma" */
  {
/* line 136 "MakeArguments.puma" */
   TemporaryInit (t);
/* line 138 "MakeArguments.puma" */
   print_protocol ("Step 1 : Serialization of FORALL/WHERE/Array-Assigments\n");
/* line 141 "MakeArguments.puma" */
   MakeSerial (t);
/* line 143 "MakeArguments.puma" */
   print_protocol ("Step 2 : determine the overlap updates \n");
/* line 145 "MakeArguments.puma" */
   MakeOvUpdates (t);
/* line 147 "MakeArguments.puma" */
   print_protocol ("Step 3 : Extract function calls to own statements\n");
/* line 150 "MakeArguments.puma" */
   MakeTempFunctions (t);
/* line 152 "MakeArguments.puma" */
   print_protocol ("Step 4 : make legal call arguments/results \n");
/* line 154 "MakeArguments.puma" */
   MakeCalls (t);
/* line 156 "MakeArguments.puma" */
   print_protocol ("Step 5 : remapping of arguments \n");
/* line 158 "MakeArguments.puma" */
   MakeRemapping (t);
/* line 160 "MakeArguments.puma" */
   print_protocol ("Step 6 : temporary for reductions \n");
/* line 162 "MakeArguments.puma" */
   MakeReductions (t);
/* line 164 "MakeArguments.puma" */
   TemporaryDone (t);
/* line 166 "MakeArguments.puma" */
   t = t->BODY_NODE.INTERNALS;
   goto yyRecursion;
  }

  }

;
}

void BeginMakeArguments ARGS ((void))
{
}

void CloseMakeArguments ARGS ((void))
{
}
