# include "Loops.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 32 "Loops.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "TreeOps.h"
# include "Expressions.h"
# include "Nesting.h"
# include "ParNest.h"

# include "Invariant.h"

# define MODULE "Loops"

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyLoops.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Loops_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Loops, routine %s failed\n",
  yyFunction);
 Loops_Exit ();
}

rbool IsFullParLoopVar ARGS ((tTree var));
rbool IsFullLoopVar ARGS ((tTree var));
rbool IsLinParLoopVar ARGS ((tTree var));
static rbool IsInParallelLoop ARGS ((tTree var, tTree loop));
static rbool LinearInParallelLoop ARGS ((tTree var, tTree loop));
static rbool LinearDependency ARGS ((tTree var, tTree id));
static rbool Dependency ARGS ((tTree var, tTree id));
rbool LoopInvariantAddressing ARGS ((tTree var, tTree loop));
static rbool IsLinearDependent ARGS ((tTree exp, tTree id));
rbool IsParallelLoop ARGS ((tTree loop));
rbool HasOuterParallelLoop ARGS ((void));
rbool NoParallelLoopIndex ARGS ((tTree index_exp));
void ForallVarCheck ARGS ((tTree var));
static void ForallLoopVarCheck ARGS ((tTree loop, tTree var));
rbool IsLoopInvariant ARGS ((tTree exp, tTree loop));
rbool IsUnchanged ARGS ((tTree var, tTree stmt));

rbool IsFullParLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 67 "Loops.puma" */
 {
  rbool okay;
  int i;
  {
/* line 72 "Loops.puma" */
 okay = rtrue;
     for (i=1; i <= OuterLoops(); i++)
        okay = okay && IsInParallelLoop (var, GetOuterLoop(i));
   
/* line 77 "Loops.puma" */
   if (! ((okay))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

/* line 80 "Loops.puma" */
  {
/* line 82 "Loops.puma" */
   return rfalse;
  }

}

rbool IsFullLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 99 "Loops.puma" */
 {
  rbool okay;
  int i;
  {
/* line 104 "Loops.puma" */
 okay = rtrue;

     for (i=1; i <= GetParNestingDepth (); i++)
      
       { tTree loop;

         loop = GetParNestACF (i);

         if (IsCountLoop (loop))
            okay = okay && Dependency (var, GetLoopId (loop));
       }

   
/* line 118 "Loops.puma" */
   if (! ((okay))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

/* line 121 "Loops.puma" */
  {
/* line 123 "Loops.puma" */
   return rfalse;
  }

}

rbool IsLinParLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 141 "Loops.puma" */
 {
  rbool okay;
  int i;
  {
/* line 146 "Loops.puma" */
 okay = rtrue;
     for (i=1; i <= OuterLoops(); i++)
        okay = okay && LinearInParallelLoop (var, GetOuterLoop(i));
   
/* line 151 "Loops.puma" */
   if (! ((okay))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

/* line 154 "Loops.puma" */
  {
/* line 156 "Loops.puma" */
   return rfalse;
  }

}

static rbool IsInParallelLoop
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree loop)
# else
(var, loop)
 register tTree var;
 register tTree loop;
# endif
{
/* line 169 "Loops.puma" */
  {
/* line 171 "Loops.puma" */
   if (! ((IsParallelLoop (loop)))) goto yyL1;
  {
/* line 172 "Loops.puma" */
   if (! ((Dependency (var, GetLoopId (loop))))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 175 "Loops.puma" */
  {
/* line 176 "Loops.puma" */
   if (! ((! IsParallelLoop (loop)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static rbool LinearInParallelLoop
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree loop)
# else
(var, loop)
 register tTree var;
 register tTree loop;
# endif
{
/* line 189 "Loops.puma" */
  {
/* line 191 "Loops.puma" */
   if (! ((IsParallelLoop (loop)))) goto yyL1;
  {
/* line 192 "Loops.puma" */
   if (! ((LinearDependency (var, GetLoopId (loop))))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 195 "Loops.puma" */
  {
/* line 196 "Loops.puma" */
   if (! ((! IsParallelLoop (loop)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static rbool LinearDependency
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id)
# else
(var, id)
 register tTree var;
 register tTree id;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 209 "Loops.puma" */
  {
/* line 211 "Loops.puma" */
   if (! ((LinearDependency (var->INDEXED_VAR.IND_EXPS, id)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (var->Kind == kBTE_LIST) {
/* line 214 "Loops.puma" */
  {
/* line 216 "Loops.puma" */
   if (! ((IsLinearDependent (var->BTE_LIST.Elem, id)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 219 "Loops.puma" */
  {
/* line 221 "Loops.puma" */
   if (! ((LinearDependency (var->BTE_LIST.Next, id)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static rbool Dependency
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id)
# else
(var, id)
 register tTree var;
 register tTree id;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 234 "Loops.puma" */
  {
/* line 236 "Loops.puma" */
   if (! ((Dependency (var->INDEXED_VAR.IND_EXPS, id)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (var->Kind == kBTE_LIST) {
/* line 239 "Loops.puma" */
  {
/* line 241 "Loops.puma" */
   if (! ((IsVarInExp (TreeVarName (id), var->BTE_LIST.Elem)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 244 "Loops.puma" */
  {
/* line 246 "Loops.puma" */
   if (! ((Dependency (var->BTE_LIST.Next, id)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

rbool LoopInvariantAddressing
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree loop)
# else
(var, loop)
 register tTree var;
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_WHILE) {
/* line 268 "Loops.puma" */
  {
/* line 270 "Loops.puma" */
   return rfalse;
  }

  }
/* line 273 "Loops.puma" */
  {
/* line 275 "Loops.puma" */
   if (! ((! IsCountLoop (loop)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 281 "Loops.puma" */
  {
/* line 283 "Loops.puma" */
   if (! ((! IsVarInExp (TreeVarName (GetLoopId (loop)), var)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  return rfalse;
}

static rbool IsLinearDependent
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id)
# else
(exp, id)
 register tTree exp;
 register tTree id;
# endif
{
/* line 296 "Loops.puma" */
 {
  tTree var;
  int stride;
  int base;
  rbool found;
  {
/* line 303 "Loops.puma" */
   ResolveExpression (exp, & found, & stride, & base, & var);
/* line 304 "Loops.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 305 "Loops.puma" */
   if (! ((stride != 0))) goto yyL1;
  {
/* line 306 "Loops.puma" */
   if (! ((TreeVarName (var) == TreeVarName (id)))) goto yyL1;
  }
  }
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

rbool IsParallelLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_FORALL) {
/* line 317 "Loops.puma" */
   return rtrue;

  }
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 320 "Loops.puma" */
   return rtrue;

  }
  }
  if (loop->Kind == kDO_EXP) {
/* line 323 "Loops.puma" */
   return rtrue;

  }
  if (loop->Kind == kDO_VAR) {
/* line 326 "Loops.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool HasOuterParallelLoop
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 337 "Loops.puma" */
 {
  rbool parloop;
  {
/* line 340 "Loops.puma" */
 int i;
      parloop = rfalse;
 
      for (i=1; i<= OuterLoops(); i++)
        parloop = parloop || IsParallelLoop (GetOuterLoop(i));
    
/* line 346 "Loops.puma" */
   if (! ((parloop))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

rbool NoParallelLoopIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index_exp)
# else
(index_exp)
 register tTree index_exp;
# endif
{
/* line 357 "Loops.puma" */
 {
  rbool okay;
  {
/* line 361 "Loops.puma" */
 int lnr;

     okay = rtrue;

     for (lnr=1; lnr <= OuterLoops (); lnr++)

       { tTree loop;

         loop = GetOuterLoop (lnr);

         if (IsParallelLoop (loop))

           { if (IsVarInExp (TreeVarName (GetLoopId (loop)), index_exp))

               okay = rfalse;
           }
       }
   
/* line 380 "Loops.puma" */
   if (! ((okay))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

void ForallVarCheck
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 396 "Loops.puma" */
  {
/* line 398 "Loops.puma" */
 int i;
     for (i=1; i <= OuterLoops(); i++)
        ForallLoopVarCheck (GetOuterLoop(i), var);
   
  }
   return;

;
}

static void ForallLoopVarCheck
# if defined __STDC__ | defined __cplusplus
(register tTree loop, register tTree var)
# else
(loop, var)
 register tTree loop;
 register tTree var;
# endif
{
  if (loop->Kind == kACF_FORALL) {
  if (var->Kind == kUSED_VAR) {
/* line 406 "Loops.puma" */
  {
/* line 410 "Loops.puma" */
   error_protocol ("Only indexed variable in lhs of FORALL assignments");
  }
   return;

  }
  if (loop->ACF_FORALL.FORALL_ID->Kind == kLOOP_VAR) {
/* line 413 "Loops.puma" */
  {
/* line 417 "Loops.puma" */
 if (IsVarInExp (loop->ACF_FORALL.FORALL_ID->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, var) == 0)
       { error_protocol ("loop index appears not in lhs in FORALL");
         tree_protocol  ("assignment variable is ", var);
         tree_protocol  ("loop variable is ", loop->ACF_FORALL.FORALL_ID);
       }
   
  }
   return;

  }
  }
;
}

rbool IsLoopInvariant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree loop)
# else
(exp, loop)
 register tTree exp;
 register tTree loop;
# endif
{

  switch (exp->Kind) {
  case kBTE_LIST:
/* line 435 "Loops.puma" */
  {
/* line 437 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->BTE_LIST.Elem, loop)))) goto yyL1;
  {
/* line 438 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->BTE_LIST.Next, loop)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  break;
  case kBTE_EMPTY:
/* line 441 "Loops.puma" */
   return rtrue;

  case kOP_EXP:
/* line 444 "Loops.puma" */
  {
/* line 446 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->OP_EXP.OPND1, loop)))) goto yyL3;
  {
/* line 447 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->OP_EXP.OPND2, loop)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  break;
  case kOP1_EXP:
/* line 450 "Loops.puma" */
  {
/* line 452 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->OP1_EXP.OPND, loop)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  break;
  case kCONST_EXP:
/* line 455 "Loops.puma" */
   return rtrue;

  case kVAR_EXP:
/* line 458 "Loops.puma" */
  {
/* line 460 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->VAR_EXP.V, loop)))) goto yyL6;
  }
   return rtrue;
yyL6:;

  break;
  case kINDEXED_VAR:
/* line 463 "Loops.puma" */
  {
/* line 465 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->INDEXED_VAR.IND_EXPS, loop)))) goto yyL7;
  {
/* line 466 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->INDEXED_VAR.IND_VAR, loop)))) goto yyL7;
  }
  }
   return rtrue;
yyL7:;

  break;
  case kUSED_VAR:
/* line 469 "Loops.puma" */
  {
/* line 471 "Loops.puma" */
   if (! ((IsUnchanged (exp, loop)))) goto yyL8;
  }
   return rtrue;
yyL8:;

  break;
  case kLOOP_VAR:
/* line 474 "Loops.puma" */
  {
/* line 476 "Loops.puma" */
   if (! ((IsUnchanged (exp, loop)))) goto yyL9;
  }
   return rtrue;
yyL9:;

  break;
  case kSLICE_EXP:
/* line 479 "Loops.puma" */
  {
/* line 481 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->SLICE_EXP.FIRST, loop)))) goto yyL10;
  {
/* line 482 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->SLICE_EXP.STOP, loop)))) goto yyL10;
  {
/* line 483 "Loops.puma" */
   if (! ((IsLoopInvariant (exp->SLICE_EXP.INC, loop)))) goto yyL10;
  }
  }
  }
   return rtrue;
yyL10:;

  break;
  case kDUMMY_EXP:
/* line 486 "Loops.puma" */
   return rtrue;

  case kFUNC_CALL_EXP:
/* line 489 "Loops.puma" */
   return rtrue;

  }

  return rfalse;
}

rbool IsUnchanged
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt)
# else
(var, stmt)
 register tTree var;
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
/* line 502 "Loops.puma" */
  {
/* line 504 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_LIST.Elem)))) goto yyL1;
  {
/* line 505 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  break;
  case kACF_EMPTY:
/* line 508 "Loops.puma" */
   return rtrue;

  case kACF_DUMMY:
/* line 511 "Loops.puma" */
   return rtrue;

  case kACF_DO:
/* line 514 "Loops.puma" */
  {
/* line 516 "Loops.puma" */
   if (! ((TreeVarName (var) != TreeVarName (stmt->ACF_DO.DO_ID)))) goto yyL4;
  {
/* line 518 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_DO.DO_BODY)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

  break;
  case kACF_FORALL:
/* line 521 "Loops.puma" */
  {
/* line 523 "Loops.puma" */
   if (! ((TreeVarName (var) != TreeVarName (stmt->ACF_FORALL.FORALL_ID)))) goto yyL5;
  {
/* line 525 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_FORALL.FORALL_BODY)))) goto yyL5;
  }
  }
   return rtrue;
yyL5:;

  break;
  case kACF_WHILE:
/* line 529 "Loops.puma" */
  {
/* line 531 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_WHILE.WHILE_BODY)))) goto yyL6;
  }
   return rtrue;
yyL6:;

  break;
  case kACF_IF:
/* line 534 "Loops.puma" */
  {
/* line 536 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_IF.THEN_PART)))) goto yyL7;
  {
/* line 537 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_IF.ELSE_PART)))) goto yyL7;
  }
  }
   return rtrue;
yyL7:;

  break;
  case kACF_HOME:
/* line 540 "Loops.puma" */
  {
/* line 542 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_HOME.HOME_BODY)))) goto yyL8;
  }
   return rtrue;
yyL8:;

  break;
  case kACF_NEW:
/* line 545 "Loops.puma" */
  {
/* line 547 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_NEW.NEW_BODY)))) goto yyL9;
  }
   return rtrue;
yyL9:;

  break;
  case kACF_RESIDENT:
/* line 550 "Loops.puma" */
  {
/* line 552 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_RESIDENT.RESIDENT_BODY)))) goto yyL10;
  }
   return rtrue;
yyL10:;

  break;
  case kACF_REDUCTION:
/* line 555 "Loops.puma" */
  {
/* line 557 "Loops.puma" */
   if (! ((IsUnchanged (var, stmt->ACF_REDUCTION.REDUCTION_BODY)))) goto yyL11;
  }
   return rtrue;
yyL11:;

  break;
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 560 "Loops.puma" */
  {
/* line 562 "Loops.puma" */
   if (! ((TreeVarName (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) != TreeVarName (var)))) goto yyL12;
  }
   return rtrue;
yyL12:;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 565 "Loops.puma" */
   return rtrue;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 568 "Loops.puma" */
   return rtrue;

  }
/* line 571 "Loops.puma" */
  {
/* line 573 "Loops.puma" */
   return rfalse;
  }

  }

  return rfalse;
}

void BeginLoops ARGS ((void))
{
}

void CloseLoops ARGS ((void))
{
}
