# include "LooPo.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 17 "LooPo.puma" */


# include "DynArray.h"

# include "protocol.h"

# include "StrUnparse.h"

# include "Nesting.h"
# include "Traverse.h"

# include "TreeOps.h"     
# include "Rank.h"         /* VarRank     */
# include "Objects.h"      /* IsVarSave   */
# include "Loops.h"        /* IsUnchanged */
# include "SemReduction.h" /* CheckReduction */
# include "SemParallel.h"  /* SemParallel    */

# include "StmtDeps.h"
# include "Candidates.h"

# include "LivingVars.h"   /* insertion of NEW directives */

# undef DEBUG
# define MODULE "LooPo"

/*********************************************************************
*                                                                    *
*  Global variables for identification of Parameters                 *
*                                                                    *
*********************************************************************/

static tTree global_stmt;

static int   no_params;
static tTree parameters [MAX_PARAMETERS];



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyLooPo.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* LooPo_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module LooPo, routine %s failed\n",
  yyFunction);
 LooPo_Exit ();
}

void LooPo ARGS ((tTree t));
static void LooPoBody ARGS ((tTree body, tTree unit));
static rbool StopLooPo ARGS ((tTree t));
static tTree ApplyLooPo ARGS ((tTree loop));
static void GetIndependentInfo ARGS ((tTree loop, rbool * yyP3, tTree * yyP2, tTree * yyP1));
static void MakeIndependent ARGS ((tTree loop, rbool independent, tTree new_vars, tTree red_vars));
static rbool IsIndependent ARGS ((tTree loop));
static void GetAllParameters ARGS ((tTree stmt));
static void CheckParameter ARGS ((tTree t));
static rbool IsParameter ARGS ((tTree t));
static void AddParameter ARGS ((tTree t));
static rbool StopAutoReduction ARGS ((tTree t));
static tTree ApplyAutoReduction ARGS ((tTree loop));
static void FindReductionVar ARGS ((tTree t));
static rbool GoodReductionVar ARGS ((tTree red_var));

void LooPo
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 66 "LooPo.puma" */
  {
/* line 68 "LooPo.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 71 "LooPo.puma" */
   return;

  case kUNIT_LIST:
/* line 74 "LooPo.puma" */
  {
/* line 76 "LooPo.puma" */
   LooPo (t->UNIT_LIST.Elem);
/* line 77 "LooPo.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kPROGRAM_DECL:
/* line 80 "LooPo.puma" */
  {
/* line 82 "LooPo.puma" */
   NestOpenUnit (t);
/* line 83 "LooPo.puma" */
   LooPoBody (t->PROGRAM_DECL.PROGRAM_BODY, t);
/* line 84 "LooPo.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 87 "LooPo.puma" */
  {
/* line 89 "LooPo.puma" */
   NestOpenUnit (t);
/* line 90 "LooPo.puma" */
   LooPoBody (t->PROC_DECL.PROC_BODY, t);
/* line 91 "LooPo.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 94 "LooPo.puma" */
  {
/* line 96 "LooPo.puma" */
   NestOpenUnit (t);
/* line 97 "LooPo.puma" */
   LooPoBody (t->FUNC_DECL.FUNC_BODY, t);
/* line 98 "LooPo.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 101 "LooPo.puma" */
  {
/* line 103 "LooPo.puma" */
   NestOpenUnit (t);
/* line 104 "LooPo.puma" */
   LooPoBody (t->BLOCK_DATA_DECL.DATA_BODY, t);
/* line 105 "LooPo.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 108 "LooPo.puma" */
  {
/* line 110 "LooPo.puma" */
   NestOpenUnit (t);
/* line 111 "LooPo.puma" */
   LooPoBody (t->MODULE_DECL.MODULE_BODY, t);
/* line 112 "LooPo.puma" */
   NestCloseUnit (t);
  }
   return;

  }

/* line 115 "LooPo.puma" */
  {
/* line 117 "LooPo.puma" */
   failure_protocol (MODULE, "LooPo", t);
  }
   return;

;
}

static void LooPoBody
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree unit)
# else
(body, unit)
 register tTree body;
 register tTree unit;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 128 "LooPo.puma" */
  {
/* line 130 "LooPo.puma" */
   if (! ((loop_parallelization))) goto yyL1;
  {
/* line 132 "LooPo.puma" */
   LivingVars (body);
/* line 134 "LooPo.puma" */
   body->BODY_NODE.STATS = ReplaceAST (body->BODY_NODE.STATS, StopAutoReduction, ApplyAutoReduction);
/* line 135 "LooPo.puma" */
   body->BODY_NODE.STATS = ReplaceAST (body->BODY_NODE.STATS, StopLooPo, ApplyLooPo);
/* line 137 "LooPo.puma" */
   LooPo (body->BODY_NODE.INTERNALS);
  }
  }
   return;
yyL1:;

/* line 140 "LooPo.puma" */
  {
/* line 142 "LooPo.puma" */
   print_protocol ("automatic loop parallelization is switched off");
  }
   return;

  }
/* line 145 "LooPo.puma" */
  {
/* line 147 "LooPo.puma" */
   failure_protocol (MODULE, "LooPoBody", body);
  }
   return;

;
}

static rbool StopLooPo
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kBT_STMT)) {
/* line 160 "LooPo.puma" */
   return rtrue;

  }
  if (Tree_IsType (t, kBT_EXP)) {
/* line 163 "LooPo.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree ApplyLooPo
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 177 "LooPo.puma" */
  {
/* line 179 "LooPo.puma" */
   if (! ((HasJumpOut (loop->ACF_DO.DO_BODY)))) goto yyL1;
  {
/* line 181 "LooPo.puma" */
   set_protocol_stmt (loop);
/* line 183 "LooPo.puma" */
   info_protocol ("DO loop: not INDEPENDENT (jump out of loop)");
  }
  }
   return loop;
yyL1:;

/* line 188 "LooPo.puma" */
  {
/* line 190 "LooPo.puma" */
   if (! ((! LegalIndepBody (loop->ACF_DO.DO_BODY)))) goto yyL2;
  {
/* line 192 "LooPo.puma" */
   set_protocol_stmt (loop);
/* line 194 "LooPo.puma" */
   info_protocol ("DO loop: not INDEPENDENT (contains unsupported stmt)");
  }
  }
   return loop;
yyL2:;

/* line 199 "LooPo.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 201 "LooPo.puma" */
   GetIndependentInfo (loop, & yyV1, & yyV2, & yyV3);
/* line 203 "LooPo.puma" */
   set_protocol_stmt (loop);
/* line 205 "LooPo.puma" */
   MakeIndependent (loop, yyV1, yyV2, yyV3);
  }
   return loop;
 }

  }
  }
/* line 210 "LooPo.puma" */
   return loop;

}

static void GetIndependentInfo
# if defined __STDC__ | defined __cplusplus
(register tTree loop, register rbool * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(loop, yyP3, yyP2, yyP1)
 register tTree loop;
 register rbool * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 222 "LooPo.puma" */
 {
  rbool independent;
  {
/* line 226 "LooPo.puma" */
   independent = IsIndependent (loop);
  }
   * yyP3 = independent;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
 }

;
}

static void MakeIndependent
# if defined __STDC__ | defined __cplusplus
(register tTree loop, register rbool independent, register tTree new_vars, register tTree red_vars)
# else
(loop, independent, new_vars, red_vars)
 register tTree loop;
 register rbool independent;
 register tTree new_vars;
 register tTree red_vars;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 239 "LooPo.puma" */
  {
/* line 241 "LooPo.puma" */
   if (! ((independent))) goto yyL1;
  {
/* line 243 "LooPo.puma" */
   loop->ACF_DO.DO_DEP_INFO = mINDEP_INFO (rfalse, 0, NoTree, NoTree);
/* line 245 "LooPo.puma" */
   info_protocol ("DO loop is now INDEPENDENT");
  }
  }
   return;
yyL1:;

  }
/* line 248 "LooPo.puma" */
  {
/* line 250 "LooPo.puma" */
   info_protocol ("DO loop: could not prove INDEPENDENT");
  }
   return;

;
}

static rbool IsIndependent
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 261 "LooPo.puma" */
 {
  Predicate p;
  {
/* line 265 "LooPo.puma" */
   GetAllParameters (loop);
/* line 267 "LooPo.puma" */
   LoopDependence (loop, parameters, no_params, & p);
/* line 269 "LooPo.puma" */
   if (! ((PIsFalse (& p)))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  }
  }
  return rfalse;
}

static void GetAllParameters
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
/* line 280 "LooPo.puma" */
  {
/* line 282 "LooPo.puma" */
   global_stmt = stmt;
/* line 283 "LooPo.puma" */
   no_params = 0;
/* line 285 "LooPo.puma" */
   FullTraverseAST (stmt, CheckParameter);
  }
   return;

;
}

static void CheckParameter
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
/* line 290 "LooPo.puma" */
  {
/* line 292 "LooPo.puma" */
   if (! ((TreeRank (t) == 0))) goto yyL1;
  {
/* line 294 "LooPo.puma" */
   if (! ((! IsParameter (t)))) goto yyL1;
  {
/* line 296 "LooPo.puma" */
   if (! ((IsUnchanged (t, global_stmt)))) goto yyL1;
  {
/* line 298 "LooPo.puma" */
   AddParameter (t);
  }
  }
  }
  }
   return;
yyL1:;

  }
  if (t->Kind == kLOOP_VAR) {
/* line 301 "LooPo.puma" */
  {
/* line 303 "LooPo.puma" */
   if (! ((! IsParameter (t)))) goto yyL2;
  {
/* line 305 "LooPo.puma" */
   if (! ((IsUnchanged (t, global_stmt)))) goto yyL2;
  {
/* line 307 "LooPo.puma" */
   AddParameter (t);
  }
  }
  }
   return;
yyL2:;

  }
;
}

static rbool IsParameter
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 312 "LooPo.puma" */
 {
  rbool found;
  int i;
  {
/* line 317 "LooPo.puma" */
   found = rfalse;
/* line 319 "LooPo.puma" */
/* line 319 "LooPo.puma" */
   i = 0;
   while (i < no_params) {
/* line 321 "LooPo.puma" */
   if ((! found)) {
/* line 323 "LooPo.puma" */
   found = (TreeVarName (t) == TreeVarName (parameters [i]));
   }
/* line 319 "LooPo.puma" */
   i ++;
   }
/* line 329 "LooPo.puma" */
   if (! ((found))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static void AddParameter
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 334 "LooPo.puma" */
  {
/* line 336 "LooPo.puma" */
   if (! ((no_params < MAX_PARAMETERS))) goto yyL1;
  {
/* line 338 "LooPo.puma" */
 parameters[no_params] = t; no_params++; 
  }
  }
   return;
yyL1:;

;
}

static rbool StopAutoReduction
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kBT_STMT)) {
/* line 351 "LooPo.puma" */
   return rtrue;

  }
  if (Tree_IsType (t, kBT_EXP)) {
/* line 354 "LooPo.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 360 "LooPo.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static tTree ApplyAutoReduction
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 374 "LooPo.puma" */
 {
  tTree new_stmt;
  int i;
  int n;
  tTree red_var;
  tTree red_fn;
  {
/* line 376 "LooPo.puma" */
   if (! ((! HasJumpOut (loop->ACF_DO.DO_BODY)))) goto yyL1;
  {
/* line 377 "LooPo.puma" */
   if (! ((LegalIndepBody (loop->ACF_DO.DO_BODY)))) goto yyL1;
  {
/* line 379 "LooPo.puma" */
   InitCandidates ();
/* line 381 "LooPo.puma" */
   FullTraverseAST (loop->ACF_DO.DO_BODY, FindReductionVar);
/* line 383 "LooPo.puma" */
   new_stmt = loop;
/* line 388 "LooPo.puma" */
   n = NoCandidates ();
/* line 390 "LooPo.puma" */
   if (! ((n > 0))) goto yyL1;
  {
/* line 392 "LooPo.puma" */
/* line 392 "LooPo.puma" */
   i = 1;
   while (i <= n) {
/* line 397 "LooPo.puma" */
   red_var = GetCandidate (i);
/* line 398 "LooPo.puma" */
   red_fn = GetCandidateInfo (i);
/* line 400 "LooPo.puma" */
   if ((IsLegalReduction (new_stmt, red_var, red_fn))) {
/* line 402 "LooPo.puma" */
 char msg[100]; 
        char var_string[MAX_ID_LENGTH], fn_string[MAX_ID_LENGTH];
      
/* line 406 "LooPo.puma" */
   new_stmt = mACF_REDUCTION (kDEFAULT_REDUCTION, mBTV_LIST (CopyTree (red_var), mBTV_EMPTY ()), red_fn, mACF_LIST (new_stmt, mACF_EMPTY ()));
/* line 411 "LooPo.puma" */
   SemParallel (new_stmt);
/* line 415 "LooPo.puma" */
   set_protocol_stmt (loop);
/* line 417 "LooPo.puma" */
   StrUnparse (var_string, MAX_ID_LENGTH, red_var);
/* line 418 "LooPo.puma" */
   StrUnparse (fn_string, MAX_ID_LENGTH, red_fn);
/* line 419 "LooPo.puma" */
   sprintf (msg, "%s becomes REDUCTION var (%s) in DO loop", var_string, fn_string);
/* line 421 "LooPo.puma" */
   info_protocol (msg);
   }
/* line 392 "LooPo.puma" */
   i ++;
   }
/* line 427 "LooPo.puma" */
   loop->ACF_DO.DO_BODY = ReplaceAST (loop->ACF_DO.DO_BODY, StopAutoReduction, ApplyAutoReduction);
  }
  }
  }
  }
   return new_stmt;
 }
yyL1:;

/* line 434 "LooPo.puma" */
  {
/* line 436 "LooPo.puma" */
   loop->ACF_DO.DO_BODY = ReplaceAST (loop->ACF_DO.DO_BODY, StopAutoReduction, ApplyAutoReduction);
  }
   return loop;

  }
  }
/* line 441 "LooPo.puma" */
   return loop;

}

static void FindReductionVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 454 "LooPo.puma" */
 {
  tTree red_var;
  tTree red_fn;
  tTree red_exp;
  {
/* line 460 "LooPo.puma" */
   red_var = NoTree;
/* line 462 "LooPo.puma" */
   CheckRedStmt (t, & red_var, & red_fn, & red_exp);
/* line 464 "LooPo.puma" */
   if (! ((red_fn != NoTree))) goto yyL1;
  {
/* line 466 "LooPo.puma" */
   if (! ((GoodReductionVar (red_var)))) goto yyL1;
  {
/* line 470 "LooPo.puma" */
   AddCandidate (red_var, red_fn, rtrue);
  }
  }
  }
   return;
 }
yyL1:;

;
}

static rbool GoodReductionVar
# if defined __STDC__ | defined __cplusplus
(register tTree red_var)
# else
(red_var)
 register tTree red_var;
# endif
{
  if (red_var->Kind == kUSED_VAR) {
/* line 475 "LooPo.puma" */
  {
/* line 477 "LooPo.puma" */
   if (! ((VarRank (red_var->USED_VAR.VARNAME->VAR_OBJ.Object) == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

void BeginLooPo ARGS ((void))
{
}

void CloseLooPo ARGS ((void))
{
}
