# include "LivingVars.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 24 "LivingVars.puma" */


# include "VarSets.h"

# define MODULE "LivingVars"

# include "protocol.h"
# include "Nesting.h"   /* GetCurrentUnitObject */
# include "Shapes.h"    /* IsFullVar            */

# include "Unparse.h"
# include "StrUnparse.h"
# include "Candidates.h"
# include "Rank.h"
# include "Distributions.h"  /* do not consider distributed arrays */
# include "Transform.h"      /* CombineBTV                         */

static int N;

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyLivingVars.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* LivingVars_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module LivingVars, routine %s failed\n",
  yyFunction);
 LivingVars_Exit ();
}

void LivingVars ARGS ((tTree t));
static void LiveVarAnalysis ARGS ((tTree t, rbool final, pVarSet live_vars_in, pVarSet live_vars_out));
static void LiveVarBasic ARGS ((tTree t, pVarSet live_vars_in, pVarSet live_vars_out));
static void LiveVarParams ARGS ((tTree t, pVarSet live_vars_in, pVarSet live_vars_out));
static void CheckLiveVar ARGS ((tTree var, int intent, pVarSet live_in, pVarSet live_out));
static void AddUsedVars ARGS ((tTree exp, pVarSet used_vars));
static void GetIndexUsedVars ARGS ((tTree var, pVarSet used_vars));
static void GetVarInfo ARGS ((tTree var, rbool * yyP3, rbool * yyP2, int * yyP1));
static void IdentifyNewVars ARGS ((tTree loop, pVarSet live_body, pVarSet live_out));
static void FindNewVars ARGS ((tTree stmts, pVarSet live_set));
static void AddVarList ARGS ((tTree vars, pVarSet var_set));
static void SetNewCandidate ARGS ((tTree var));
static tTree CollectNewVars ARGS ((int n, pVarSet live_warning, String sub));
static tTree MakeNewVarBody ARGS ((tTree body, tTree new_vars));

void LivingVars
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 60 "LivingVars.puma" */
 {
  VarSet live_vars_out;
  VarSet live_vars_in;
  {
/* line 62 "LivingVars.puma" */
   N = MakeLocalVarSet (GetCurrentUnitObject ()) - 1;
/* line 64 "LivingVars.puma" */
   if ((N < 0)) {
/* line 64 "LivingVars.puma" */
   return;
   }
/* line 69 "LivingVars.puma" */
   MakeSet (& live_vars_out, N);
/* line 70 "LivingVars.puma" */
   MakeSet (& live_vars_in, N);
/* line 74 "LivingVars.puma" */
   LiveVarAnalysis (t->BODY_NODE.STATS, rtrue, & live_vars_in, & live_vars_out);
/* line 76 "LivingVars.puma" */
   ReleaseSet (& live_vars_in);
/* line 77 "LivingVars.puma" */
   ReleaseSet (& live_vars_out);
/* line 79 "LivingVars.puma" */
   ReleaseLocalVarSet ();
  }
 }

  }
;
}

static void LiveVarAnalysis
# if defined __STDC__ | defined __cplusplus
(register tTree t, register rbool final, pVarSet live_vars_in, pVarSet live_vars_out)
# else
(t, final, live_vars_in, live_vars_out)
 register tTree t;
 register rbool final;
 pVarSet live_vars_in;
 pVarSet live_vars_out;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 92 "LivingVars.puma" */
 {
  VarSet live_vars_help;
  {
/* line 96 "LivingVars.puma" */
   MakeSet (& live_vars_help, N);
/* line 98 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_LIST.Next, final, & live_vars_help, live_vars_out);
/* line 100 "LivingVars.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 102 "LivingVars.puma" */

#ifdef DEBUG
     PrintVarSet (&live_vars_help, "live vars (out)");
     FileUnparse (stdout, t->ACF_LIST.Elem);
#endif 
     LiveVarAnalysis (t->ACF_LIST.Elem, final, live_vars_in, &live_vars_help);
#ifdef DEBUG
     PrintVarSet (live_vars_in, "live vars (in)");
#endif
    
/* line 113 "LivingVars.puma" */
   ReleaseSet (& live_vars_help);
  }
   return;
 }

  case kACF_EMPTY:
/* line 116 "LivingVars.puma" */
  {
/* line 118 "LivingVars.puma" */
   Assign (live_vars_in, live_vars_out);
  }
   return;

  case kACF_DUMMY:
/* line 121 "LivingVars.puma" */
  {
/* line 123 "LivingVars.puma" */
   Assign (live_vars_in, live_vars_out);
  }
   return;

  case kACF_DO:
/* line 126 "LivingVars.puma" */
 {
  VarSet live_help;
  VarSet live_body;
  {
/* line 143 "LivingVars.puma" */
   MakeSet (& live_body, N);
/* line 144 "LivingVars.puma" */
   MakeSet (& live_help, N);
/* line 146 "LivingVars.puma" */
   AddUsedVars (t->ACF_DO.DO_RANGE->SLICE_EXP.INC, & live_help);
/* line 147 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_DO.DO_BODY, rfalse, & live_body, & live_help);
/* line 148 "LivingVars.puma" */
   AddUsedVars (t->ACF_DO.DO_RANGE->SLICE_EXP.STOP, & live_body);
/* line 152 "LivingVars.puma" */
   if ((final)) {
/* line 153 "LivingVars.puma" */
   IdentifyNewVars (t, & live_body, live_vars_out);
   }
/* line 156 "LivingVars.puma" */
   Union (& live_body, live_vars_out);
/* line 158 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_DO.DO_BODY, final, & live_help, & live_body);
/* line 159 "LivingVars.puma" */
   CheckLiveVar (t->ACF_DO.DO_ID, IntentOut, live_vars_in, & live_help);
/* line 161 "LivingVars.puma" */
   ReleaseSet (& live_help);
/* line 162 "LivingVars.puma" */
   ReleaseSet (& live_body);
  }
   return;
 }

  case kACF_WHILE:
/* line 165 "LivingVars.puma" */
 {
  VarSet live_help;
  VarSet live_body;
  {
/* line 178 "LivingVars.puma" */
   MakeSet (& live_body, N);
/* line 179 "LivingVars.puma" */
   MakeSet (& live_help, N);
/* line 181 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_WHILE.WHILE_BODY, rfalse, & live_body, & live_help);
/* line 182 "LivingVars.puma" */
   AddUsedVars (t->ACF_WHILE.WHILE_EXP, & live_body);
/* line 184 "LivingVars.puma" */
   Union (& live_body, live_vars_out);
/* line 186 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_WHILE.WHILE_BODY, final, live_vars_in, & live_body);
/* line 188 "LivingVars.puma" */
   Union (live_vars_in, live_vars_out);
/* line 189 "LivingVars.puma" */
   AddUsedVars (t->ACF_WHILE.WHILE_EXP, live_vars_in);
/* line 191 "LivingVars.puma" */
   ReleaseSet (& live_help);
/* line 192 "LivingVars.puma" */
   ReleaseSet (& live_body);
  }
   return;
 }

  case kACF_IF:
/* line 195 "LivingVars.puma" */
 {
  VarSet live_help;
  {
/* line 199 "LivingVars.puma" */
   MakeSet (& live_help, N);
/* line 201 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_IF.THEN_PART, final, live_vars_in, live_vars_out);
/* line 202 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_IF.ELSE_PART, final, & live_help, live_vars_out);
/* line 204 "LivingVars.puma" */
   Union (live_vars_in, & live_help);
/* line 205 "LivingVars.puma" */
   AddUsedVars (t->ACF_IF.IF_EXP, live_vars_in);
/* line 207 "LivingVars.puma" */
   ReleaseSet (& live_help);
  }
   return;
 }

  case kACF_WHERE:
/* line 210 "LivingVars.puma" */
 {
  VarSet live_help;
  {
/* line 215 "LivingVars.puma" */
   MakeSet (& live_help, N);
/* line 217 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_WHERE.TRUE_PART, final, live_vars_in, live_vars_out);
/* line 218 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_WHERE.FALSE_PART, final, & live_help, live_vars_out);
/* line 220 "LivingVars.puma" */
   Union (live_vars_in, & live_help);
/* line 221 "LivingVars.puma" */
   AddUsedVars (t->ACF_WHERE.WHERE_EXP, live_vars_in);
/* line 223 "LivingVars.puma" */
   ReleaseSet (& live_help);
  }
   return;
 }

  case kACF_BASIC:
/* line 226 "LivingVars.puma" */
  {
/* line 228 "LivingVars.puma" */
   set_protocol_stmt (t);
/* line 229 "LivingVars.puma" */
   LiveVarBasic (t->ACF_BASIC.BASIC_STMT, live_vars_in, live_vars_out);
  }
   return;

  case kACF_HOME:
/* line 232 "LivingVars.puma" */
  {
/* line 234 "LivingVars.puma" */
   LiveVarAnalysis (t->ACF_HOME.HOME_BODY, final, live_vars_in, live_vars_out);
/* line 236 "LivingVars.puma" */
   IdentifyNewVars (t, live_vars_in, live_vars_out);
  }
   return;

  case kACF_NEW:
/* line 239 "LivingVars.puma" */
  {
/* line 241 "LivingVars.puma" */
   t = t->ACF_NEW.NEW_BODY;
   goto yyRecursion;
  }

  case kACF_RESIDENT:
/* line 244 "LivingVars.puma" */
  {
/* line 246 "LivingVars.puma" */
   t = t->ACF_RESIDENT.RESIDENT_BODY;
   goto yyRecursion;
  }

  case kACF_REDUCTION:
/* line 249 "LivingVars.puma" */
  {
/* line 251 "LivingVars.puma" */
   t = t->ACF_REDUCTION.REDUCTION_BODY;
   goto yyRecursion;
  }

  }

/* line 256 "LivingVars.puma" */
  {
/* line 258 "LivingVars.puma" */
   AssignEmpty (live_vars_in);
/* line 259 "LivingVars.puma" */
   Complement (live_vars_in);
/* line 261 "LivingVars.puma" */
   serious_warning_protocol ("no live analysis for this construct");
  }
   return;

;
}

static void LiveVarBasic
# if defined __STDC__ | defined __cplusplus
(register tTree t, pVarSet live_vars_in, pVarSet live_vars_out)
# else
(t, live_vars_in, live_vars_out)
 register tTree t;
 pVarSet live_vars_in;
 pVarSet live_vars_out;
# endif
{

  switch (t->Kind) {
  case kASSIGN_STMT:
/* line 276 "LivingVars.puma" */
  {
/* line 280 "LivingVars.puma" */
   CheckLiveVar (t->ASSIGN_STMT.ASSIGN_VAR, IntentOut, live_vars_in, live_vars_out);
/* line 281 "LivingVars.puma" */
   AddUsedVars (t->ASSIGN_STMT.ASSIGN_EXP, live_vars_in);
  }
   return;

  case kCALL_STMT:
/* line 284 "LivingVars.puma" */
  {
/* line 286 "LivingVars.puma" */
   LiveVarParams (t->CALL_STMT.CALL_PARAMS, live_vars_in, live_vars_out);
  }
   return;

  case kREDUCE_STMT:
/* line 289 "LivingVars.puma" */
  {
/* line 291 "LivingVars.puma" */
   LiveVarParams (t->REDUCE_STMT.RED_PARAMS, live_vars_in, live_vars_out);
  }
   return;

  case kIO_STMT:
/* line 294 "LivingVars.puma" */
 {
  VarSet live_vars_help;
  {
/* line 298 "LivingVars.puma" */
   MakeSet (& live_vars_help, N);
/* line 300 "LivingVars.puma" */
   LiveVarParams (t->IO_STMT.IO_ITEMS, & live_vars_help, live_vars_out);
/* line 301 "LivingVars.puma" */
   LiveVarParams (t->IO_STMT.IO_SPECS, live_vars_in, & live_vars_help);
/* line 303 "LivingVars.puma" */
   ReleaseSet (& live_vars_help);
  }
   return;
 }

  case kALLOCATE_STMT:
/* line 306 "LivingVars.puma" */
 {
  VarSet live_vars_help;
  {
/* line 310 "LivingVars.puma" */
   MakeSet (& live_vars_help, N);
/* line 315 "LivingVars.puma" */
   LiveVarParams (t->ALLOCATE_STMT.PARAMS, & live_vars_help, live_vars_out);
/* line 317 "LivingVars.puma" */
   ReleaseSet (& live_vars_help);
  }
   return;
 }

  case kDEALLOCATE_STMT:
/* line 320 "LivingVars.puma" */
  {
/* line 322 "LivingVars.puma" */
   Assign (live_vars_in, live_vars_out);
  }
   return;

  case kFREE_DSP_STMT:
/* line 325 "LivingVars.puma" */
  {
/* line 327 "LivingVars.puma" */
   Assign (live_vars_in, live_vars_out);
  }
   return;

  case kCREATE_DSP_STMT:
/* line 330 "LivingVars.puma" */
  {
/* line 332 "LivingVars.puma" */
   Assign (live_vars_in, live_vars_out);
  }
   return;

  case kSTOP_STMT:
/* line 335 "LivingVars.puma" */
  {
/* line 337 "LivingVars.puma" */
   AssignEmpty (live_vars_in);
  }
   return;

  case kGOTO_STMT:
/* line 340 "LivingVars.puma" */
  {
/* line 344 "LivingVars.puma" */
   AssignEmpty (live_vars_in);
/* line 345 "LivingVars.puma" */
   Complement (live_vars_in);
  }
   return;

  case kREDISTRIBUTE_STMT:
/* line 348 "LivingVars.puma" */
   return;

  case kREALIGN_STMT:
/* line 353 "LivingVars.puma" */
   return;

  }

/* line 358 "LivingVars.puma" */
  {
/* line 360 "LivingVars.puma" */
   AssignEmpty (live_vars_in);
/* line 361 "LivingVars.puma" */
   Complement (live_vars_in);
/* line 363 "LivingVars.puma" */
   serious_warning_protocol ("no live analysis for this basic statement");
  }
   return;

;
}

static void LiveVarParams
# if defined __STDC__ | defined __cplusplus
(register tTree t, pVarSet live_vars_in, pVarSet live_vars_out)
# else
(t, live_vars_in, live_vars_out)
 register tTree t;
 pVarSet live_vars_in;
 pVarSet live_vars_out;
# endif
{
  if (t->Kind == kBTP_LIST) {
/* line 374 "LivingVars.puma" */
 {
  VarSet live_vars_help;
  {
/* line 378 "LivingVars.puma" */
   MakeSet (& live_vars_help, N);
/* line 380 "LivingVars.puma" */
   LiveVarParams (t->BTP_LIST.Next, & live_vars_help, live_vars_out);
/* line 381 "LivingVars.puma" */
   LiveVarParams (t->BTP_LIST.Elem, live_vars_in, & live_vars_help);
/* line 383 "LivingVars.puma" */
   ReleaseSet (& live_vars_help);
  }
   return;
 }

  }
  if (t->Kind == kBTP_EMPTY) {
/* line 386 "LivingVars.puma" */
  {
/* line 388 "LivingVars.puma" */
   Assign (live_vars_in, live_vars_out);
  }
   return;

  }
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
/* line 391 "LivingVars.puma" */
  {
/* line 393 "LivingVars.puma" */
   Assign (live_vars_in, live_vars_out);
/* line 394 "LivingVars.puma" */
   AddUsedVars (t->VAR_PARAM.V->ADDR.E, live_vars_in);
  }
   return;

  }
/* line 397 "LivingVars.puma" */
  {
/* line 399 "LivingVars.puma" */
   CheckLiveVar (t->VAR_PARAM.V, t->VAR_PARAM.intent, live_vars_in, live_vars_out);
  }
   return;

  }
/* line 404 "LivingVars.puma" */
  {
/* line 406 "LivingVars.puma" */
   Assign (live_vars_in, live_vars_out);
  }
   return;

;
}

static void CheckLiveVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int intent, pVarSet live_in, pVarSet live_out)
# else
(var, intent, live_in, live_out)
 register tTree var;
 register int intent;
 pVarSet live_in;
 pVarSet live_out;
# endif
{
/* line 417 "LivingVars.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 419 "LivingVars.puma" */
   Assign (live_in, live_out);
/* line 420 "LivingVars.puma" */
   GetIndexUsedVars (var, live_in);
/* line 421 "LivingVars.puma" */
   GetVarInfo (var, & yyV1, & yyV2, & yyV3);
/* line 423 "LivingVars.puma" */
   if ((intent == IntentOut)) {
/* line 425 "LivingVars.puma" */
   if ((yyV1 && yyV2)) {
/* line 425 "LivingVars.puma" */
   Exclude (live_in, yyV3);
   }
   } else
/* line 429 "LivingVars.puma" */
   if ((yyV1)) {
/* line 429 "LivingVars.puma" */
   Include (live_in, yyV3);
   }
  }
   return;
 }

;
}

static void AddUsedVars
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pVarSet used_vars)
# else
(exp, used_vars)
 register tTree exp;
 pVarSet used_vars;
# endif
{
 yyRecursion:

  switch (exp->Kind) {
  case kVAR_EXP:
/* line 448 "LivingVars.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 450 "LivingVars.puma" */
   GetVarInfo (exp->VAR_EXP.V, & yyV1, & yyV2, & yyV3);
/* line 452 "LivingVars.puma" */
   if ((yyV1)) {
/* line 452 "LivingVars.puma" */
   Include (used_vars, yyV3);
   }
/* line 453 "LivingVars.puma" */
   GetIndexUsedVars (exp->VAR_EXP.V, used_vars);
  }
   return;
 }

  case kOP_EXP:
/* line 456 "LivingVars.puma" */
  {
/* line 458 "LivingVars.puma" */
   AddUsedVars (exp->OP_EXP.OPND1, used_vars);
/* line 459 "LivingVars.puma" */
   exp = exp->OP_EXP.OPND2;
   goto yyRecursion;
  }

  case kOP1_EXP:
/* line 462 "LivingVars.puma" */
  {
/* line 464 "LivingVars.puma" */
   exp = exp->OP1_EXP.OPND;
   goto yyRecursion;
  }

  case kCONST_EXP:
/* line 467 "LivingVars.puma" */
   return;

  case kSLICE_EXP:
/* line 470 "LivingVars.puma" */
  {
/* line 472 "LivingVars.puma" */
   AddUsedVars (exp->SLICE_EXP.FIRST, used_vars);
/* line 473 "LivingVars.puma" */
   AddUsedVars (exp->SLICE_EXP.STOP, used_vars);
/* line 474 "LivingVars.puma" */
   exp = exp->SLICE_EXP.INC;
   goto yyRecursion;
  }

  case kDUMMY_EXP:
/* line 477 "LivingVars.puma" */
   return;

  case kBTE_LIST:
/* line 480 "LivingVars.puma" */
  {
/* line 482 "LivingVars.puma" */
   AddUsedVars (exp->BTE_LIST.Elem, used_vars);
/* line 483 "LivingVars.puma" */
   exp = exp->BTE_LIST.Next;
   goto yyRecursion;
  }

  case kBTE_EMPTY:
/* line 486 "LivingVars.puma" */
   return;

  case kFUNC_CALL_EXP:
/* line 489 "LivingVars.puma" */
 {
  VarSet live_out;
  {
/* line 493 "LivingVars.puma" */
   MakeSet (& live_out, N);
/* line 495 "LivingVars.puma" */
   Assign (& live_out, used_vars);
/* line 496 "LivingVars.puma" */
   LiveVarParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, used_vars, & live_out);
/* line 498 "LivingVars.puma" */
   ReleaseSet (& live_out);
  }
   return;
 }

  case kDO_EXP:
/* line 501 "LivingVars.puma" */
 {
  VarSet used_help;
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 505 "LivingVars.puma" */
   MakeSet (& used_help, N);
/* line 507 "LivingVars.puma" */
   AddUsedVars (exp->DO_EXP.RANGE, & used_help);
/* line 508 "LivingVars.puma" */
   AddUsedVars (exp->DO_EXP.BODY, & used_help);
/* line 512 "LivingVars.puma" */
   GetVarInfo (exp->DO_EXP.DO_ID, & yyV1, & yyV2, & yyV3);
/* line 514 "LivingVars.puma" */
   if ((yyV1 && yyV2)) {
/* line 514 "LivingVars.puma" */
   Exclude (& used_help, yyV3);
   }
/* line 516 "LivingVars.puma" */
   Union (used_vars, & used_help);
  }
   return;
 }

  case kPERM_EXP:
/* line 519 "LivingVars.puma" */
  {
/* line 521 "LivingVars.puma" */
   exp = exp->PERM_EXP.VAL;
   goto yyRecursion;
  }

  case kARRAY_EXP:
/* line 524 "LivingVars.puma" */
  {
/* line 526 "LivingVars.puma" */
   exp = exp->ARRAY_EXP.ELEMENTS;
   goto yyRecursion;
  }

  case kTYPE_EXP:
/* line 529 "LivingVars.puma" */
  {
/* line 531 "LivingVars.puma" */
   exp = exp->TYPE_EXP.ELEMENTS;
   goto yyRecursion;
  }

  case kBOUND_EXP:
/* line 534 "LivingVars.puma" */
   return;

  case kRANK_EXP:
/* line 537 "LivingVars.puma" */
   return;

  }

/* line 540 "LivingVars.puma" */
  {
/* line 544 "LivingVars.puma" */
   failure_protocol (MODULE, "AddUsedVars", exp);
  }
   return;

;
}

static void GetIndexUsedVars
# if defined __STDC__ | defined __cplusplus
(register tTree var, pVarSet used_vars)
# else
(var, used_vars)
 register tTree var;
 pVarSet used_vars;
# endif
{
 yyRecursion:

  switch (var->Kind) {
  case kINDEXED_VAR:
/* line 555 "LivingVars.puma" */
  {
/* line 557 "LivingVars.puma" */
   AddUsedVars (var->INDEXED_VAR.IND_EXPS, used_vars);
  }
   return;

  case kUSED_VAR:
/* line 560 "LivingVars.puma" */
   return;

  case kLOOP_VAR:
/* line 563 "LivingVars.puma" */
   return;

  case kSELECTED_VAR:
/* line 566 "LivingVars.puma" */
  {
/* line 568 "LivingVars.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }

  case kSUBSTRING_VAR:
/* line 571 "LivingVars.puma" */
  {
/* line 573 "LivingVars.puma" */
   AddUsedVars (var->SUBSTRING_VAR.IND_EXP, used_vars);
  }
   return;

  case kDO_VAR:
/* line 576 "LivingVars.puma" */
  {
/* line 578 "LivingVars.puma" */
   AddUsedVars (var->DO_VAR.RANGE, used_vars);
/* line 580 "LivingVars.puma" */
   var = var->DO_VAR.BODY;
   goto yyRecursion;
  }

  case kBTV_LIST:
/* line 583 "LivingVars.puma" */
  {
/* line 585 "LivingVars.puma" */
   GetIndexUsedVars (var->BTV_LIST.Elem, used_vars);
/* line 586 "LivingVars.puma" */
   var = var->BTV_LIST.Next;
   goto yyRecursion;
  }

  case kBTV_EMPTY:
/* line 589 "LivingVars.puma" */
   return;

  }

/* line 592 "LivingVars.puma" */
  {
/* line 594 "LivingVars.puma" */
   failure_protocol (MODULE, "GetIndexUsedVars", var);
  }
   return;

;
}

static void GetVarInfo
# if defined __STDC__ | defined __cplusplus
(register tTree var, register rbool * yyP3, register rbool * yyP2, register int * yyP1)
# else
(var, yyP3, yyP2, yyP1)
 register tTree var;
 register rbool * yyP3;
 register rbool * yyP2;
 register int * yyP1;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 605 "LivingVars.puma" */
 {
  rbool found;
  int elem;
  {
/* line 610 "LivingVars.puma" */
   FindVarSetIndex (var->USED_VAR.VARNAME->VAR_OBJ.Object, & found, & elem);
  }
   * yyP3 = found;
   * yyP2 = rtrue;
   * yyP1 = elem;
   return;
 }

  }
  if (var->Kind == kLOOP_VAR) {
/* line 613 "LivingVars.puma" */
 {
  rbool found;
  int elem;
  {
/* line 618 "LivingVars.puma" */
   FindVarSetIndex (var->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Object, & found, & elem);
  }
   * yyP3 = found;
   * yyP2 = rtrue;
   * yyP1 = elem;
   return;
 }

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 621 "LivingVars.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 623 "LivingVars.puma" */
   GetVarInfo (var->INDEXED_VAR.IND_VAR, & yyV1, & yyV2, & yyV3);
  }
   * yyP3 = yyV1;
   * yyP2 = IsWholeVar (var);
   * yyP1 = yyV3;
   return;
 }

  }
/* line 626 "LivingVars.puma" */
   * yyP3 = rfalse;
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

;
}

static void IdentifyNewVars
# if defined __STDC__ | defined __cplusplus
(register tTree loop, pVarSet live_body, pVarSet live_out)
# else
(loop, live_body, live_out)
 register tTree loop;
 pVarSet live_body;
 pVarSet live_out;
# endif
{
/* line 638 "LivingVars.puma" */
  {
/* line 640 "LivingVars.puma" */

#ifdef DEBUG
     printf ("Identify NEW vars for this construct:\n");
     FileUnparse (stdout, loop);
     PrintVarSet (live_body, "living vars for body (NEW)");
     PrintVarSet (live_out, "living vars after body (NEW)");
#endif
   
/* line 649 "LivingVars.puma" */
   goto yyL1;
  }
yyL1:;

  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 670 "LivingVars.puma" */
 {
  tTree new_vars;
  int no_vars;
  VarSet live_set;
  VarSet scalars;
  {
/* line 677 "LivingVars.puma" */
   InitCandidates ();
/* line 679 "LivingVars.puma" */
   MakeSet (& live_set, N);
/* line 680 "LivingVars.puma" */
   MakeSet (& scalars, N);
/* line 687 "LivingVars.puma" */
   Assign (& live_set, live_out);
/* line 688 "LivingVars.puma" */
   ScalarLocalVarSet (& scalars);
/* line 689 "LivingVars.puma" */
   Difference (& live_set, & scalars);
/* line 690 "LivingVars.puma" */
   Union (& live_set, live_body);
/* line 692 "LivingVars.puma" */

#ifdef DEBUG
     PrintVarSet (&scalars, "scalar vars");
     PrintVarSet (&live_set, "live for DO loop");
#endif
   
/* line 699 "LivingVars.puma" */
   InitCandidates ();
/* line 701 "LivingVars.puma" */
   FindNewVars (loop->ACF_DO.DO_BODY, & live_set);
/* line 703 "LivingVars.puma" */
   no_vars = NoCandidates ();
/* line 705 "LivingVars.puma" */
   if ((no_vars > 0)) {
/* line 707 "LivingVars.puma" */
   set_protocol_stmt (loop);
/* line 711 "LivingVars.puma" */
   new_vars = CollectNewVars (no_vars, live_out, "serial DO loop");
/* line 712 "LivingVars.puma" */
   loop->ACF_DO.DO_BODY = MakeNewVarBody (loop->ACF_DO.DO_BODY, new_vars);
/* line 714 "LivingVars.puma" */
   stmt_protocol ("new variables set in serial DO loop");
   }
/* line 718 "LivingVars.puma" */
   ReleaseSet (& scalars);
/* line 719 "LivingVars.puma" */
   ReleaseSet (& live_set);
  }
   return;
 }

  }
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 742 "LivingVars.puma" */
 {
  tTree new_vars;
  int no_vars;
  VarSet live_set;
  {
/* line 748 "LivingVars.puma" */
   InitCandidates ();
/* line 750 "LivingVars.puma" */
   MakeSet (& live_set, N);
/* line 752 "LivingVars.puma" */
   Assign (& live_set, live_body);
/* line 753 "LivingVars.puma" */
   Union (& live_set, live_out);
/* line 755 "LivingVars.puma" */
   FindNewVars (loop->ACF_DO.DO_BODY, & live_set);
/* line 757 "LivingVars.puma" */
   no_vars = NoCandidates ();
/* line 759 "LivingVars.puma" */
   if ((no_vars > 0)) {
/* line 761 "LivingVars.puma" */
   set_protocol_stmt (loop);
/* line 763 "LivingVars.puma" */
   AssignEmpty (& live_set);
/* line 764 "LivingVars.puma" */
   Complement (& live_set);
/* line 766 "LivingVars.puma" */
   new_vars = CollectNewVars (no_vars, & live_set, "independent DO loop");
/* line 767 "LivingVars.puma" */
   loop->ACF_DO.DO_BODY = MakeNewVarBody (loop->ACF_DO.DO_BODY, new_vars);
/* line 769 "LivingVars.puma" */
   stmt_protocol ("new variables set in independent DO loop");
   }
/* line 773 "LivingVars.puma" */
   ReleaseSet (& live_set);
  }
   return;
 }

  }
  }
  if (loop->Kind == kACF_HOME) {
/* line 791 "LivingVars.puma" */
 {
  tTree new_vars;
  int no_vars;
  VarSet live_set;
  {
/* line 797 "LivingVars.puma" */
   InitCandidates ();
/* line 799 "LivingVars.puma" */
   MakeSet (& live_set, N);
/* line 801 "LivingVars.puma" */
   Assign (& live_set, live_body);
/* line 802 "LivingVars.puma" */
   Union (& live_set, live_out);
/* line 804 "LivingVars.puma" */
   FindNewVars (loop->ACF_HOME.HOME_BODY, & live_set);
/* line 806 "LivingVars.puma" */
   no_vars = NoCandidates ();
/* line 808 "LivingVars.puma" */
   if ((no_vars > 0)) {
/* line 810 "LivingVars.puma" */
   set_protocol_stmt (loop);
/* line 812 "LivingVars.puma" */
   AssignEmpty (& live_set);
/* line 814 "LivingVars.puma" */
   new_vars = CollectNewVars (no_vars, & live_set, "HOME");
/* line 815 "LivingVars.puma" */
   loop->ACF_HOME.HOME_BODY = MakeNewVarBody (loop->ACF_HOME.HOME_BODY, new_vars);
/* line 817 "LivingVars.puma" */
   stmt_protocol ("new variables set for HOME statement");
   }
/* line 821 "LivingVars.puma" */
   ReleaseSet (& live_set);
  }
   return;
 }

  }
;
}

static void FindNewVars
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, pVarSet live_set)
# else
(stmts, live_set)
 register tTree stmts;
 pVarSet live_set;
# endif
{
 yyRecursion:
  if (stmts->Kind == kACF_LIST) {
/* line 832 "LivingVars.puma" */
  {
/* line 834 "LivingVars.puma" */
   FindNewVars (stmts->ACF_LIST.Elem, live_set);
/* line 835 "LivingVars.puma" */
   stmts = stmts->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (stmts->Kind == kACF_EMPTY) {
/* line 838 "LivingVars.puma" */
   return;

  }
  if (stmts->Kind == kACF_BASIC) {
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 841 "LivingVars.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 843 "LivingVars.puma" */
   GetVarInfo (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2, & yyV3);
/* line 844 "LivingVars.puma" */
   if (! ((yyV1))) goto yyL3;
  {
/* line 846 "LivingVars.puma" */
   if (! ((! IsElement (yyV3, live_set)))) goto yyL3;
  {
/* line 848 "LivingVars.puma" */
   SetNewCandidate (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
  }
  }
  }
   return;
 }
yyL3:;

  }
  }
  if (stmts->Kind == kACF_IF) {
/* line 851 "LivingVars.puma" */
  {
/* line 853 "LivingVars.puma" */
   FindNewVars (stmts->ACF_IF.THEN_PART, live_set);
/* line 854 "LivingVars.puma" */
   stmts = stmts->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  }
  if (stmts->Kind == kACF_NEW) {
/* line 857 "LivingVars.puma" */
 {
  VarSet live_new;
  {
/* line 864 "LivingVars.puma" */
   MakeSet (& live_new, N);
/* line 865 "LivingVars.puma" */
   Assign (& live_new, live_set);
/* line 866 "LivingVars.puma" */
   AddVarList (stmts->ACF_NEW.NEW_VAR, & live_new);
/* line 868 "LivingVars.puma" */
   FindNewVars (stmts->ACF_NEW.NEW_BODY, & live_new);
/* line 870 "LivingVars.puma" */
   ReleaseSet (& live_new);
  }
   return;
 }

  }
;
}

static void AddVarList
# if defined __STDC__ | defined __cplusplus
(register tTree vars, pVarSet var_set)
# else
(vars, var_set)
 register tTree vars;
 pVarSet var_set;
# endif
{
 yyRecursion:
  if (vars->Kind == kBTV_EMPTY) {
/* line 881 "LivingVars.puma" */
   return;

  }
  if (vars->Kind == kBTV_LIST) {
/* line 883 "LivingVars.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 885 "LivingVars.puma" */
   GetVarInfo (vars->BTV_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 886 "LivingVars.puma" */
   if ((yyV1)) {
/* line 886 "LivingVars.puma" */
   Include (var_set, yyV3);
   }
/* line 887 "LivingVars.puma" */
   vars = vars->BTV_LIST.Next;
   goto yyRecursion;
  }
 }

  }
;
}

static void SetNewCandidate
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kUSED_VAR) {
/* line 898 "LivingVars.puma" */
  {
/* line 900 "LivingVars.puma" */
   if (! ((VarDistribution (var->USED_VAR.VARNAME->VAR_OBJ.Object) == 0))) goto yyL1;
  {
/* line 904 "LivingVars.puma" */
   AddCandidate (var, NoTree, rtrue);
  }
  }
   return;
yyL1:;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 907 "LivingVars.puma" */
  {
/* line 909 "LivingVars.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
;
}

static tTree CollectNewVars
# if defined __STDC__ | defined __cplusplus
(register int n, pVarSet live_warning, String sub)
# else
(n, live_warning, sub)
 register int n;
 pVarSet live_warning;
 String sub;
# endif
{
/* line 925 "LivingVars.puma" */
 {
  tTree new_vars;
  tTree new_var;
  int i;
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 931 "LivingVars.puma" */
   new_vars = mBTV_EMPTY ();
/* line 933 "LivingVars.puma" */
/* line 933 "LivingVars.puma" */
   i = 1;
   while (i <= n) {
/* line 935 "LivingVars.puma" */
 char msg[100];
        char var_string[MAX_ID_LENGTH];
      
/* line 939 "LivingVars.puma" */
   new_var = GetCandidate (i);
/* line 941 "LivingVars.puma" */
   GetVarInfo (new_var, & yyV1, & yyV2, & yyV3);
/* line 942 "LivingVars.puma" */
   if ((yyV1)) {
/* line 942 "LivingVars.puma" */
   yyV1 = IsElement (yyV3, live_warning);
   }
/* line 944 "LivingVars.puma" */
   new_vars = mBTV_LIST (CopyTree (new_var), new_vars);
/* line 946 "LivingVars.puma" */
   StrUnparse (var_string, MAX_ID_LENGTH, GetCandidate (i));
/* line 948 "LivingVars.puma" */
   if ((yyV1)) {
/* line 949 "LivingVars.puma" */
   sprintf (msg, "%s becomes NEW var in %s (no last val assumed)", var_string, sub);
/* line 951 "LivingVars.puma" */
   serious_warning_protocol (msg);
   } else {
/* line 953 "LivingVars.puma" */
   sprintf (msg, "%s becomes NEW var in %s", var_string, sub);
/* line 955 "LivingVars.puma" */
   info_protocol (msg);
   }
/* line 933 "LivingVars.puma" */
   i ++;
   }
  }
   return new_vars;
 }

}

static tTree MakeNewVarBody
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree new_vars)
# else
(body, new_vars)
 register tTree body;
 register tTree new_vars;
# endif
{
  if (new_vars->Kind == kBTV_EMPTY) {
/* line 980 "LivingVars.puma" */
   return body;

  }
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Elem->Kind == kACF_NEW) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 985 "LivingVars.puma" */
  {
/* line 987 "LivingVars.puma" */
 body->ACF_LIST.Elem->ACF_NEW.NEW_VAR = CombineBTV (new_vars, body->ACF_LIST.Elem->ACF_NEW.NEW_VAR); 
  }
   return body;

  }
  }
  }
/* line 992 "LivingVars.puma" */
   return mACF_LIST (mACF_NEW (new_vars, body), mACF_EMPTY ());

}

void BeginLivingVars ARGS ((void))
{
}

void CloseLivingVars ARGS ((void))
{
}
