# include "Invariant.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 54 "Invariant.puma" */


# define MODULE "Invariant"

# include "Idents.h"
# include "StringM.h"

# include "Expressions.h"
# include "Nesting.h"
# include "Dependences.h"
# include "Loops.h"
# include "Intrinsics.h"
# include "Rank.h"
# include "TreeOps.h"
# include "Objects.h"

# include "protocol.h"

      /***********************************************************
      *  global data for Var Var Dependences                     *
      ***********************************************************/

static ptree loop_nest;           /* pointers to surrounding loops  */
static int   loop_depth;          /* number of surrounding loops    */

static PredVector loop_pv;        /* predicate used for dependences */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyInvariant.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Invariant_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Invariant, routine %s failed\n",
  yyFunction);
 Invariant_Exit ();
}

int ForallVarExpDependences ARGS ((tTree var, tTree exp));
static int VarExpDependences ARGS ((tTree var, tTree exp));
static int VarScatterDependences ARGS ((tTree var, tTree scatter_params));
static int VarVarDependences ARGS ((tTree var1, tTree var2));
static rbool NonOverlappingIndexes ARGS ((tTree indexes1, tTree indexes2));
void ResolveLoopVar ARGS ((tTree exp, tTree id, rbool * yyP2, int * yyP1));
static void CombineTimes ARGS ((tTree e1, int val1, tTree e2, int val2, rbool * yyP4, int * yyP3));
void MakeVector ARGS ((tTree exp, tTree id, int c, tTree slice, tTree * yyP7, tTree * yyP6, tTree * yyP5));
static tTree MakeNewIncrement ARGS ((tTree inc, int cval));
static tTree Replace ARGS ((tTree exp, tTree id, tTree newexp));

int ForallVarExpDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
/* line 94 "Invariant.puma" */
  {
/* line 96 "Invariant.puma" */
 rbool stop;
     int  common_loops, const_loops;
     int  i;

     

     loop_depth = OuterLoops ();
     loop_nest  = GetAllOuterLoops ();

     

     stop = (loop_depth == 0);

     while (!stop)
 
       { stop = IsForallLoop (loop_nest[0]);
         if (!stop)
           { loop_nest++;
             loop_depth--;
             stop = (loop_depth == 0);
           }
       }
 
     

     common_loops = 0;
     const_loops  = 0;

     

     PVMakeForLoopNest (loop_depth, common_loops, const_loops, &loop_pv);

     

     for (i=0; i<loop_depth; i++)

        if (IsIndepLoop (loop_nest[i]))

            PVAndComponent (&loop_pv, i+1, 0, 0);

   
  }
   return VarExpDependences (var, exp);

}

static int VarExpDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
 yyRecursion:
  if (var->Kind == kUSED_VAR) {
/* line 149 "Invariant.puma" */
  {
/* line 151 "Invariant.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL1;
  }
   return 0;
yyL1:;

  }
/* line 155 "Invariant.puma" */
  {
/* line 156 "Invariant.puma" */
   if (! ((exp == NoTree))) goto yyL2;
  }
   return 0;
yyL2:;


  switch (exp->Kind) {
  case kUSED_VAR:
/* line 160 "Invariant.puma" */
   return 0;

  case kLOOP_VAR:
/* line 164 "Invariant.puma" */
   return 0;

  case kINDEXED_VAR:
/* line 168 "Invariant.puma" */
   return VarVarDependences (var, exp);

  case kSUBSTRING_VAR:
/* line 172 "Invariant.puma" */
   return VarVarDependences (var, exp);

  case kSELECTED_VAR:
/* line 176 "Invariant.puma" */
   return VarVarDependences (var, exp);

  case kVAR_EXP:
/* line 180 "Invariant.puma" */
   exp = exp->VAR_EXP.V;
   goto yyRecursion;

  case kTYPE_EXP:
/* line 184 "Invariant.puma" */
   exp = exp->TYPE_EXP.ELEMENTS;
   goto yyRecursion;

  case kBTE_LIST:
/* line 188 "Invariant.puma" */
   return (VarExpDependences (var, exp->BTE_LIST.Elem) + VarExpDependences (var, exp->BTE_LIST.Next));

  case kBTE_EMPTY:
/* line 192 "Invariant.puma" */
   return 0;

  case kSLICE_EXP:
/* line 196 "Invariant.puma" */
   return (VarExpDependences (var, exp->SLICE_EXP.FIRST) + VarExpDependences (var, exp->SLICE_EXP.STOP) + VarExpDependences (var, exp->SLICE_EXP.INC));

  case kDUMMY_EXP:
/* line 201 "Invariant.puma" */
   return 0;

  case kCONST_EXP:
/* line 205 "Invariant.puma" */
   return 0;

  case kBOUND_EXP:
/* line 209 "Invariant.puma" */
   return 0;

  case kRANK_EXP:
/* line 213 "Invariant.puma" */
   return 0;

  case kADDR:
/* line 217 "Invariant.puma" */
   return (VarExpDependences (var, exp->ADDR.E));

  case kOP_EXP:
/* line 221 "Invariant.puma" */
   return (VarExpDependences (var, exp->OP_EXP.OPND1) + VarExpDependences (var, exp->OP_EXP.OPND2));

  case kOP1_EXP:
/* line 225 "Invariant.puma" */
   return (VarExpDependences (var, exp->OP1_EXP.OPND));

  case kPERM_EXP:
/* line 229 "Invariant.puma" */
  {
/* line 230 "Invariant.puma" */
   if (! ((IsVarInExp (TreeVarName (var), exp->PERM_EXP.VAL)))) goto yyL20;
  }
   return 1;
yyL20:;

/* line 234 "Invariant.puma" */
   return 0;

  case kARRAY_EXP:
/* line 238 "Invariant.puma" */
   exp = exp->ARRAY_EXP.ELEMENTS;
   goto yyRecursion;

  case kDO_EXP:
/* line 242 "Invariant.puma" */
   return VarExpDependences (var, exp->DO_EXP.RANGE) + VarExpDependences (var, exp->DO_EXP.BODY);

  case kFUNC_CALL_EXP:
/* line 246 "Invariant.puma" */
  {
/* line 248 "Invariant.puma" */
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL24;
  {
/* line 249 "Invariant.puma" */
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL24;
  }
  }
   exp = exp->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;
yyL24:;

/* line 254 "Invariant.puma" */
  {
/* line 256 "Invariant.puma" */
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL25;
  {
/* line 257 "Invariant.puma" */
   if (! ((IntrFuncScatter (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL25;
  }
  }
   return VarScatterDependences (var, exp->FUNC_CALL_EXP.FUNC_PARAMS);
yyL25:;

/* line 262 "Invariant.puma" */
  {
/* line 264 "Invariant.puma" */
   if (! ((IsVarInExp (TreeVarName (var), exp->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL26;
  }
   return 1;
yyL26:;

/* line 268 "Invariant.puma" */
   return 0;

  case kBTP_LIST:
/* line 273 "Invariant.puma" */
   return (VarExpDependences (var, exp->BTP_LIST.Elem) + VarExpDependences (var, exp->BTP_LIST.Next));

  case kBTP_EMPTY:
/* line 277 "Invariant.puma" */
   return 0;

  case kVAR_PARAM:
/* line 281 "Invariant.puma" */
   return (VarExpDependences (var, exp->VAR_PARAM.V));

  case kNO_PARAM:
/* line 285 "Invariant.puma" */
   return 0;

  }

/* line 289 "Invariant.puma" */
  {
/* line 290 "Invariant.puma" */
   failure2_protocol (MODULE, "VarExpDependences", var, exp);
  }
   return 0;

}

static int VarScatterDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree scatter_params)
# else
(var, scatter_params)
 register tTree var;
 register tTree scatter_params;
# endif
{
  if (scatter_params->Kind == kBTP_LIST) {
  if (scatter_params->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 304 "Invariant.puma" */
  {
/* line 306 "Invariant.puma" */
   if (! ((IsVarInExp (TreeVarName (var), scatter_params->BTP_LIST.Elem)))) goto yyL1;
  }
   return 1;
yyL1:;

/* line 311 "Invariant.puma" */
  {
/* line 313 "Invariant.puma" */
   if (! ((IsVarInExp (TreeVarName (var), scatter_params->BTP_LIST.Next->BTP_LIST.Next)))) goto yyL2;
  }
   return 1;
yyL2:;

/* line 318 "Invariant.puma" */
   return VarExpDependences (var, scatter_params->BTP_LIST.Next->BTP_LIST.Elem);

  }
  }
 yyAbort ("VarScatterDependences");
 { int yyDummy; return yyDummy; }
}

static int VarVarDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2)
# else
(var1, var2)
 register tTree var1;
 register tTree var2;
# endif
{
/* line 333 "Invariant.puma" */
  {
/* line 334 "Invariant.puma" */
   if (! ((TreeVarName (var1) != TreeVarName (var2)))) goto yyL1;
  }
   return 0;
yyL1:;

  if (var2->Kind == kUSED_VAR) {
/* line 338 "Invariant.puma" */
   return 0;

  }
  if (var2->Kind == kLOOP_VAR) {
/* line 342 "Invariant.puma" */
   return 0;

  }
  if (var1->Kind == kSUBSTRING_VAR) {
  if (var2->Kind == kSUBSTRING_VAR) {
/* line 346 "Invariant.puma" */
  {
/* line 347 "Invariant.puma" */
   if (! ((EqualExpression (var1->SUBSTRING_VAR.IND_EXP, var2->SUBSTRING_VAR.IND_EXP)))) goto yyL4;
  }
   return 0;
yyL4:;

  }
  }
  if (var1->Kind == kINDEXED_VAR) {
  if (var2->Kind == kINDEXED_VAR) {
/* line 354 "Invariant.puma" */
  {
/* line 368 "Invariant.puma" */
   if (! ((loop_depth == 0))) goto yyL5;
  {
/* line 369 "Invariant.puma" */
   if (! ((NonOverlappingIndexes (var1->INDEXED_VAR.IND_EXPS, var2->INDEXED_VAR.IND_EXPS)))) goto yyL5;
  }
  }
   return 0;
yyL5:;

/* line 374 "Invariant.puma" */
  {
/* line 376 "Invariant.puma" */
   if (! ((EqualIndexes (var1->INDEXED_VAR.IND_EXPS, var2->INDEXED_VAR.IND_EXPS)))) goto yyL6;
  }
   return 0;
yyL6:;

/* line 381 "Invariant.puma" */
 {
  int deps;
  {
/* line 385 "Invariant.puma" */
 PredVector pv;

     int no_parameters = 0;
     tTree *params;
 
     pv = loop_pv;    

     

     Dependences (var1, loop_nest, loop_depth, 
                  var2, loop_nest, loop_depth, 
                  loop_depth, 0, params, no_parameters,
                  &pv);

     

     if (PVIsFalse (&pv))
        deps = 0;
      else if (PVIsZero (&pv))  
        { if (NonOverlappingIndexes (var1->INDEXED_VAR.IND_EXPS, var2->INDEXED_VAR.IND_EXPS))
            deps = 0;
           else
            deps = 1;
        }
      else
        deps = 1;
   
  }
   return deps;
 }

  }
  }
  if (var1->Kind == kSELECTED_VAR) {
  if (var2->Kind == kSELECTED_VAR) {
/* line 421 "Invariant.puma" */
   return 0;

  }
  }
/* line 429 "Invariant.puma" */
   return 1;

}

static rbool NonOverlappingIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes1, register tTree indexes2)
# else
(indexes1, indexes2)
 register tTree indexes1;
 register tTree indexes2;
# endif
{
  if (indexes1->Kind == kBTE_LIST) {
  if (indexes2->Kind == kBTE_LIST) {
/* line 444 "Invariant.puma" */
  {
/* line 446 "Invariant.puma" */
   if (! ((TreeRank (indexes1->BTE_LIST.Elem) == 0))) goto yyL1;
  {
/* line 447 "Invariant.puma" */
   if (! ((TreeRank (indexes2->BTE_LIST.Elem) == 0))) goto yyL1;
  {
/* line 449 "Invariant.puma" */
   if (! ((NonOverlappingIndexes (indexes1->BTE_LIST.Next, indexes2->BTE_LIST.Next)))) goto yyL1;
  }
  }
  }
   return rtrue;
yyL1:;

/* line 452 "Invariant.puma" */
  {
/* line 454 "Invariant.puma" */
   if (! ((EqualExpression (indexes1->BTE_LIST.Elem, indexes2->BTE_LIST.Elem)))) goto yyL2;
  {
/* line 455 "Invariant.puma" */
   if (! ((NonOverlappingIndexes (indexes1->BTE_LIST.Next, indexes2->BTE_LIST.Next)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  }
  if (indexes1->Kind == kBTE_EMPTY) {
  if (indexes2->Kind == kBTE_EMPTY) {
/* line 458 "Invariant.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

void ResolveLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id, register rbool * yyP2, register int * yyP1)
# else
(exp, id, yyP2, yyP1)
 register tTree exp;
 register tTree id;
 register rbool * yyP2;
 register int * yyP1;
# endif
{
/* line 473 "Invariant.puma" */
 {
  rbool found;
  int val;
  {
/* line 477 "Invariant.puma" */
   GetIntConstValue (exp, & found, & val);
/* line 478 "Invariant.puma" */
   if (! ((found))) goto yyL1;
  }
   * yyP2 = rtrue;
   * yyP1 = 0;
   return;
 }
yyL1:;


  switch (exp->Kind) {
  case kLOOP_VAR:
  if (id->Kind == kLOOP_VAR) {
/* line 481 "Invariant.puma" */
  {
/* line 483 "Invariant.puma" */
   if (! ((exp->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident == id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL2;
  }
   * yyP2 = rtrue;
   * yyP1 = 1;
   return;
yyL2:;

/* line 486 "Invariant.puma" */
   * yyP2 = rtrue;
   * yyP1 = 0;
   return;

  }
  break;
  case kUSED_VAR:
  if (id->Kind == kLOOP_VAR) {
/* line 490 "Invariant.puma" */
  {
/* line 492 "Invariant.puma" */
   if (! ((exp->USED_VAR.VARNAME->VAR_OBJ.Ident == id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL4;
  }
   * yyP2 = rtrue;
   * yyP1 = 1;
   return;
yyL4:;

/* line 495 "Invariant.puma" */
   * yyP2 = rtrue;
   * yyP1 = 0;
   return;

  }
  break;
  case kINDEXED_VAR:
/* line 499 "Invariant.puma" */
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

  case kVAR_EXP:
/* line 502 "Invariant.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 504 "Invariant.puma" */
   ResolveLoopVar (exp->VAR_EXP.V, id, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  case kOP_EXP:
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
/* line 507 "Invariant.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 509 "Invariant.puma" */
   ResolveLoopVar (exp->OP_EXP.OPND1, id, & yyV1, & yyV2);
/* line 510 "Invariant.puma" */
   ResolveLoopVar (exp->OP_EXP.OPND2, id, & yyV3, & yyV4);
/* line 512 "Invariant.puma" */
 yyV1 = (yyV1 && yyV3);
     yyV2 += yyV4;
   
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
/* line 517 "Invariant.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 519 "Invariant.puma" */
   ResolveLoopVar (exp->OP_EXP.OPND1, id, & yyV1, & yyV2);
/* line 520 "Invariant.puma" */
   ResolveLoopVar (exp->OP_EXP.OPND2, id, & yyV3, & yyV4);
/* line 522 "Invariant.puma" */
 yyV1 = (yyV1 && yyV3);
     yyV2 -= yyV4;
   
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
/* line 527 "Invariant.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  rbool yyV5;
  int yyV6;
  {
/* line 529 "Invariant.puma" */
   ResolveLoopVar (exp->OP_EXP.OPND1, id, & yyV1, & yyV2);
/* line 530 "Invariant.puma" */
   ResolveLoopVar (exp->OP_EXP.OPND2, id, & yyV3, & yyV4);
/* line 532 "Invariant.puma" */
   if (! ((yyV1 && yyV3))) goto yyL10;
  {
/* line 534 "Invariant.puma" */
   if (! (((yyV2 == 0) || (yyV4 == 0)))) goto yyL10;
  {
/* line 536 "Invariant.puma" */
   CombineTimes (exp->OP_EXP.OPND1, yyV2, exp->OP_EXP.OPND2, yyV4, & yyV5, & yyV6);
  }
  }
  }
   * yyP2 = yyV5;
   * yyP1 = yyV6;
   return;
 }
yyL10:;

/* line 539 "Invariant.puma" */
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
/* line 542 "Invariant.puma" */
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

  }
  break;
  case kOP1_EXP:
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
/* line 545 "Invariant.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 547 "Invariant.puma" */
   ResolveLoopVar (exp->OP1_EXP.OPND, id, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = - yyV2;
   return;
 }

  }
  break;
  case kFUNC_CALL_EXP:
/* line 550 "Invariant.puma" */
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

  case kBOUND_EXP:
/* line 553 "Invariant.puma" */
   * yyP2 = rtrue;
   * yyP1 = 0;
   return;

  case kRANK_EXP:
/* line 556 "Invariant.puma" */
   * yyP2 = rtrue;
   * yyP1 = 0;
   return;

  case kSLICE_EXP:
/* line 559 "Invariant.puma" */
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

  }

/* line 562 "Invariant.puma" */
  {
/* line 563 "Invariant.puma" */
   failure_protocol (MODULE, "ResolveLoopVar", exp);
  }
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

;
}

static void CombineTimes
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register int val1, register tTree e2, register int val2, register rbool * yyP4, register int * yyP3)
# else
(e1, val1, e2, val2, yyP4, yyP3)
 register tTree e1;
 register int val1;
 register tTree e2;
 register int val2;
 register rbool * yyP4;
 register int * yyP3;
# endif
{
/* line 580 "Invariant.puma" */

rbool found;
int c;

  if (equalint (val2, 0)) {
/* line 588 "Invariant.puma" */
  {
/* line 590 "Invariant.puma" */
   GetIntConstValue (e2, & found, & c);
/* line 591 "Invariant.puma" */
   if (! ((found))) goto yyL1;
  }
   * yyP4 = rtrue;
   * yyP3 = c * val1;
   return;
yyL1:;

  }
  if (equalint (val1, 0)) {
/* line 594 "Invariant.puma" */
  {
/* line 596 "Invariant.puma" */
   GetIntConstValue (e1, & found, & c);
/* line 597 "Invariant.puma" */
   if (! ((found))) goto yyL2;
  }
   * yyP4 = rtrue;
   * yyP3 = c * val2;
   return;
yyL2:;

  }
/* line 600 "Invariant.puma" */
   * yyP4 = rfalse;
   * yyP3 = 0;
   return;

;
}

void MakeVector
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id, register int c, register tTree slice, register tTree * yyP7, register tTree * yyP6, register tTree * yyP5)
# else
(exp, id, c, slice, yyP7, yyP6, yyP5)
 register tTree exp;
 register tTree id;
 register int c;
 register tTree slice;
 register tTree * yyP7;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
/* line 629 "Invariant.puma" */
 {
  tTree start;
  tTree stop;
  tTree inc;
  {
/* line 635 "Invariant.puma" */
   stop = CopyTree (exp);
/* line 636 "Invariant.puma" */
   start = Replace (exp, id, slice->SLICE_EXP.FIRST);
/* line 637 "Invariant.puma" */
   stop = Replace (stop, id, slice->SLICE_EXP.STOP);
/* line 639 "Invariant.puma" */
   inc = MakeNewIncrement (slice->SLICE_EXP.INC, c);
  }
   * yyP7 = start;
   * yyP6 = stop;
   * yyP5 = inc;
   return;
 }

  }
;
}

static tTree MakeNewIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree inc, register int cval)
# else
(inc, cval)
 register tTree inc;
 register int cval;
# endif
{
  if (equalint (cval, 1)) {
/* line 654 "Invariant.puma" */
  {
/* line 655 "Invariant.puma" */
   if (! ((inc == NoTree))) goto yyL1;
  }
   return mDUMMY_EXP ();
yyL1:;

  }
/* line 659 "Invariant.puma" */
  {
/* line 660 "Invariant.puma" */
   if (! ((inc == NoTree))) goto yyL2;
  }
   return MakeConstant (cval);
yyL2:;

  if (inc->Kind == kDUMMY_EXP) {
  if (equalint (cval, 1)) {
/* line 664 "Invariant.puma" */
   return mDUMMY_EXP ();

  }
/* line 668 "Invariant.puma" */
   return MakeConstant (cval);

  }
/* line 672 "Invariant.puma" */
   return MultConstant (CopyTree (inc), cval);

}

static tTree Replace
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id, register tTree newexp)
# else
(exp, id, newexp)
 register tTree exp;
 register tTree id;
 register tTree newexp;
# endif
{
 yyRecursion:

  switch (exp->Kind) {
  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kLOOP_VAR) {
  if (id->Kind == kLOOP_VAR) {
/* line 684 "Invariant.puma" */
  {
/* line 686 "Invariant.puma" */
   if (! ((exp->VAR_EXP.V->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident == id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL1;
  }
   return CopyTree (newexp);
yyL1:;

  }
  }
  if (exp->VAR_EXP.V->Kind == kINDEXED_VAR) {
/* line 691 "Invariant.puma" */
   exp = exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS;
   goto yyRecursion;

  }
/* line 695 "Invariant.puma" */
   return exp;

  case kBOUND_EXP:
/* line 699 "Invariant.puma" */
   return exp;

  case kBTE_LIST:
/* line 703 "Invariant.puma" */
  {
/* line 704 "Invariant.puma" */
 exp->BTE_LIST.Elem = Replace (exp->BTE_LIST.Elem, id, newexp);
     exp->BTE_LIST.Next = Replace (exp->BTE_LIST.Next, id, newexp);
   
  }
   return exp;

  case kBTE_EMPTY:
/* line 710 "Invariant.puma" */
   return exp;

  case kOP_EXP:
/* line 714 "Invariant.puma" */
  {
/* line 715 "Invariant.puma" */
 exp->OP_EXP.OPND1 = Replace (exp->OP_EXP.OPND1, id, newexp);
     exp->OP_EXP.OPND2 = Replace (exp->OP_EXP.OPND2, id, newexp);
   
  }
   return exp;

  case kOP1_EXP:
/* line 722 "Invariant.puma" */
  {
/* line 723 "Invariant.puma" */
 exp->OP1_EXP.OPND = Replace (exp->OP1_EXP.OPND, id, newexp);
   
  }
   return exp;

  case kCONST_EXP:
/* line 728 "Invariant.puma" */
   return exp;

  }

/* line 732 "Invariant.puma" */
  {
/* line 733 "Invariant.puma" */
   failure_protocol (MODULE, "Replace", exp);
  }
   return exp;

}

void BeginInvariant ARGS ((void))
{
}

void CloseInvariant ARGS ((void))
{
}
