# include "Intrinsics.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 33 "Intrinsics.puma" */


# include "Idents.h"
# include "StringM.h"
# include "protocol.h"
# include "DefTable.h"

# define MODULE "Intrinsics"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyIntrinsics.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Intrinsics_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Intrinsics, routine %s failed\n",
  yyFunction);
 Intrinsics_Exit ();
}

rbool IntrFuncElemental ARGS ((tIdent name));
rbool IntrFuncRed ARGS ((tIdent name));
rbool IntrFuncLocRed ARGS ((tIdent name));
rbool IntrFuncScan ARGS ((tIdent name));
rbool IntrFuncScatter ARGS ((tIdent name));
rbool IntrFuncDalib ARGS ((tIdent name));
rbool IntrFuncInquiry ARGS ((tIdent name));
rbool IntrFuncShape ARGS ((tIdent name));
rbool IntrSerialRoutine ARGS ((tIdent name));
rbool IntrPureRoutine ARGS ((tIdent name));
int GetIntrinsicClass ARGS ((tDefinitions obj));
int GetIntrinsicKind ARGS ((tDefinitions obj));

rbool IntrFuncElemental
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 55 "Intrinsics.puma" */
  {
/* line 57 "Intrinsics.puma" */
   if (! ((GetIntrinsicClass (GetIntrinsicObject (name)) == kELEMENTAL))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IntrFuncRed
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 62 "Intrinsics.puma" */
  {
/* line 64 "Intrinsics.puma" */
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kREDUCTION))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IntrFuncLocRed
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 69 "Intrinsics.puma" */
  {
/* line 71 "Intrinsics.puma" */
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kLOCREDUCTION))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IntrFuncScan
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 76 "Intrinsics.puma" */
  {
/* line 78 "Intrinsics.puma" */
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kSCAN))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IntrFuncScatter
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 83 "Intrinsics.puma" */
  {
/* line 85 "Intrinsics.puma" */
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kSCATTER))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IntrFuncDalib
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("CSHIFT"))) {
/* line 100 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("EOSHIFT"))) {
/* line 101 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("MATMUL"))) {
/* line 102 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_NUMBER"))) {
/* line 103 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_SEED"))) {
/* line 104 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("HPF_ALIGNMENT"))) {
/* line 106 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("HPF_DISTRIBUTION"))) {
/* line 107 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("HPF_TEMPLATE"))) {
/* line 108 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("HPF_SUBGRID_INFO"))) {
/* line 109 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_ALIGNMENT"))) {
/* line 111 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_DISTRIBUTION"))) {
/* line 112 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TEMPLATE"))) {
/* line 113 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("ABSTRACT_TO_PHYSICAL"))) {
/* line 115 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("PHYSICAL_TO_ABSTRACT"))) {
/* line 116 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TO_LOCAL"))) {
/* line 118 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_TO_GLOBAL"))) {
/* line 119 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
/* line 121 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
/* line 122 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("SORT_DOWN"))) {
/* line 124 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("SORT_UP"))) {
/* line 125 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("DATE_AND_TIME"))) {
/* line 127 "Intrinsics.puma" */
   return rtrue;

  }
/* line 129 "Intrinsics.puma" */
  {
/* line 130 "Intrinsics.puma" */
   if (! ((IntrFuncScan (name)))) goto yyL22;
  }
   return rtrue;
yyL22:;

/* line 133 "Intrinsics.puma" */
  {
/* line 134 "Intrinsics.puma" */
   if (! ((IntrFuncScatter (name)))) goto yyL23;
  }
   return rtrue;
yyL23:;

  if (equaltIdent (name, IsIdent ("PACK"))) {
/* line 137 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
/* line 138 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
/* line 139 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
/* line 141 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("PROCESSORS_SHAPE"))) {
/* line 142 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_PROCS_SHAPE"))) {
/* line 143 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_NUM_PROCS"))) {
/* line 144 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_SIZE"))) {
/* line 146 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_SHAPE"))) {
/* line 147 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_BLKCNT"))) {
/* line 149 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_LINDEX"))) {
/* line 150 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_UINDEX"))) {
/* line 151 "Intrinsics.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IntrFuncInquiry
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 155 "Intrinsics.puma" */
  {
/* line 156 "Intrinsics.puma" */
   if (! ((GetIntrinsicClass (GetIntrinsicObject (name)) == kINQUIRY))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IntrFuncShape
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
/* line 161 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("PROCESSORS_SHAPE"))) {
/* line 162 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_PROCS_SHAPE"))) {
/* line 163 "Intrinsics.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IntrSerialRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("CPU_TIME"))) {
/* line 175 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("SYSTEM_CLOCK"))) {
/* line 178 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("DATE_AND_TIME"))) {
/* line 181 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("PACK"))) {
/* line 184 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
/* line 187 "Intrinsics.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
/* line 190 "Intrinsics.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IntrPureRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 201 "Intrinsics.puma" */
  {
/* line 202 "Intrinsics.puma" */
   if (! ((IntrFuncElemental (name)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 205 "Intrinsics.puma" */
  {
/* line 206 "Intrinsics.puma" */
   if (! ((IntrFuncInquiry (name)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  return rfalse;
}

int GetIntrinsicClass
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 217 "Intrinsics.puma" */
  {
/* line 218 "Intrinsics.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return - 1;
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kINTRINSIC_DECL) {
/* line 222 "Intrinsics.puma" */
   return obj->FuncObject.decl->INTRINSIC_DECL.class;

  }
  }
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kINTRINSIC_DECL) {
/* line 226 "Intrinsics.puma" */
   return obj->ProcObject.decl->INTRINSIC_DECL.class;

  }
  }
/* line 230 "Intrinsics.puma" */
   return - 1;

}

int GetIntrinsicKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 242 "Intrinsics.puma" */
  {
/* line 243 "Intrinsics.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return - 1;
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kINTRINSIC_DECL) {
/* line 247 "Intrinsics.puma" */
   return obj->FuncObject.decl->INTRINSIC_DECL.kind;

  }
  }
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kINTRINSIC_DECL) {
/* line 251 "Intrinsics.puma" */
   return obj->ProcObject.decl->INTRINSIC_DECL.kind;

  }
  }
/* line 255 "Intrinsics.puma" */
   return - 1;

}

void BeginIntrinsics ARGS ((void))
{
}

void CloseIntrinsics ARGS ((void))
{
}
