# include "Interchange.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 21 "Interchange.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "TreeOps.h"
# include "Expressions.h"      /* SliceIncrement, ConstDifference */
# include "Selection.h"        /* ShouldBeInterchanged            */

# define  MODULE  "Interchange"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyInterchange.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Interchange_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Interchange, routine %s failed\n",
  yyFunction);
 Interchange_Exit ();
}

rbool CanBeInterchanged ARGS ((tTree loop1));
static void GetSingleLoop ARGS ((tTree stmts, rbool * yyP3, tTree * yyP2, tTree * yyP1));
static rbool LegalInterchange ARGS ((tTree loop1, tTree loop2));
static rbool NoInterchangeDependences ARGS ((tTree loop1, tTree loop2));
static void DoInterchange ARGS ((tTree loop1, tTree loop2));

rbool CanBeInterchanged
# if defined __STDC__ | defined __cplusplus
(register tTree loop1)
# else
(loop1)
 register tTree loop1;
# endif
{
  if (loop1->Kind == kACF_DO) {
/* line 45 "Interchange.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  tTree yyV3;
  rbool yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 49 "Interchange.puma" */
   GetSingleLoop (loop1->ACF_DO.DO_BODY, & yyV1, & yyV2, & yyV3);
/* line 50 "Interchange.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 54 "Interchange.puma" */
   GetSingleLoop (yyV3, & yyV4, & yyV5, & yyV6);
/* line 55 "Interchange.puma" */
   if (! ((! yyV4))) goto yyL1;
  {
/* line 59 "Interchange.puma" */
   if (! ((LegalInterchange (loop1, yyV2)))) goto yyL1;
  {
/* line 60 "Interchange.puma" */
   if (! ((ShouldBeInterchanged (loop1, yyV2)))) goto yyL1;
  {
/* line 62 "Interchange.puma" */
   tree_protocol ("these two innermost loops will be interchanged: \n", loop1);
/* line 64 "Interchange.puma" */
   DoInterchange (loop1, yyV2);
/* line 66 "Interchange.puma" */
   tree_protocol ("the two innermost loops  are interchanged: \n", loop1);
  }
  }
  }
  }
  }
   return rtrue;
 }
yyL1:;

  }
  return rfalse;
}

static void GetSingleLoop
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, register rbool * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(stmts, yyP3, yyP2, yyP1)
 register tTree stmts;
 register rbool * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (stmts->Kind == kACF_LIST) {
  if (stmts->ACF_LIST.Elem->Kind == kACF_DO) {
  if (stmts->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 79 "Interchange.puma" */
   * yyP3 = rtrue;
   * yyP2 = stmts->ACF_LIST.Elem;
   * yyP1 = stmts->ACF_LIST.Elem->ACF_DO.DO_BODY;
   return;

  }
  }
  }
/* line 83 "Interchange.puma" */
   * yyP3 = rfalse;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static rbool LegalInterchange
# if defined __STDC__ | defined __cplusplus
(register tTree loop1, register tTree loop2)
# else
(loop1, loop2)
 register tTree loop1;
 register tTree loop2;
# endif
{
  if (loop1->Kind == kACF_DO) {
  if (loop2->Kind == kACF_DO) {
/* line 97 "Interchange.puma" */
  {
/* line 100 "Interchange.puma" */
   if (! ((! IsVarInExp (TreeVarName (loop1->ACF_DO.DO_ID), loop2->ACF_DO.DO_RANGE)))) goto yyL1;
  {
/* line 101 "Interchange.puma" */
   if (! ((NoInterchangeDependences (loop1, loop2)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static rbool NoInterchangeDependences
# if defined __STDC__ | defined __cplusplus
(register tTree loop1, register tTree loop2)
# else
(loop1, loop2)
 register tTree loop1;
 register tTree loop2;
# endif
{
  if (loop1->Kind == kACF_DO) {
  if (loop1->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
  if (loop2->Kind == kACF_DO) {
  if (loop2->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 106 "Interchange.puma" */
   return rtrue;

  }
  }
  }
  }
  return rfalse;
}

static void DoInterchange
# if defined __STDC__ | defined __cplusplus
(register tTree loop1, register tTree loop2)
# else
(loop1, loop2)
 register tTree loop1;
 register tTree loop2;
# endif
{
  if (loop1->Kind == kACF_DO) {
  if (loop2->Kind == kACF_DO) {
/* line 121 "Interchange.puma" */
 {
  tTree ht;
  {
/* line 126 "Interchange.puma" */
 ht = loop1->ACF_DO.DO_ID; loop1->ACF_DO.DO_ID = loop2->ACF_DO.DO_ID; loop2->ACF_DO.DO_ID = ht;
      ht  = loop1->ACF_DO.DO_RANGE; loop1->ACF_DO.DO_RANGE = loop2->ACF_DO.DO_RANGE; loop2->ACF_DO.DO_RANGE = ht;
      ht  = loop1->ACF_DO.DO_DEP_INFO; loop1->ACF_DO.DO_DEP_INFO = loop2->ACF_DO.DO_DEP_INFO; loop2->ACF_DO.DO_DEP_INFO = ht;
      ht  = loop1->ACF_DO.DO_HOME_INFO; loop1->ACF_DO.DO_HOME_INFO = loop2->ACF_DO.DO_HOME_INFO; loop2->ACF_DO.DO_HOME_INFO = ht;
    
  }
   return;
 }

  }
  }
/* line 133 "Interchange.puma" */
  {
/* line 135 "Interchange.puma" */
   failure2_protocol (MODULE, "DoInterchange", loop1, loop2);
  }
   return;

;
}

void BeginInterchange ARGS ((void))
{
}

void CloseInterchange ARGS ((void))
{
}
